 {
 ***********************************************************************
 Daq Pascal application program AkipWaveForm.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @SaveForm        - Save WaveForm in osc and csv file.
| @CopyWaveForm    - Copy waveform 
| @AssignTag       - Assign tag to value
| @DeviceMode      - Mode calculate device
|********************************************************
[]
[Compiler.Options]
Compiler.sLenMax = 1024*1024*64;
[]
 }
program AkipWaveForm;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 ao_CN1_POINT            = 0;    { Wave points channel 1            }
 ao_CN2_POINT            = 1;    { Wave points channel 2            }
 ao_CN3_POINT            = 2;    { Wave points channel 3            }
 ao_CN4_POINT            = 3;    { Wave points channel 4            }
 ao_STATUS               = 4;
 stt_None                = 0;    { Status: No data for handling     }
 stt_Handle              = 1;    { Status: Handling data wave       }
 stt_Clear               = 2;    { Status: Clear tag                }
 RawHeaderWFM            = 11;   { #9.......... in wfm raw file     }
 {------------------------------}{                                  }
 
type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 TChanRec = record               { Channel data                     }
  OFFSET    : TTagRef;           { Channel offset                   }
  OFFS      : TTagRef;           {                                  }
  SCALE     : TTagRef;           { Channel scale                    }
  SCAL      : TTagRef;           {                                  }
  WAVFORM   : TTagRef;           { Channel waveform                 }
  Points    : TVector;           { Channel dynamic array            }
 end;                            {                                  }
 {------------------------------}{                                  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 AKIP                : record    {                                  }
  Sim                : Boolean;  { Simulator mode                   }
  FileChanNum        : Integer;  { Number(count) channels in file   }
  ArrayField         : Integer;  { Field dynamic array              }
  FilePrefix         : String;   { Program fileprefix               }
  PointWaveDat       : Integer;  { Amount point wave data           }
  PathDirWave        : String;   { Path dir file save wave form     }
  PathDfltDirWave    : String;   { Default path file save wave form }
  FileNameCSV        : String;   { Name CSV file                    }
  FileNameOSC        : String;   { Name OSC file                    }
  FileHeadCSV        : String;   { File header CSV                  }
  FileHeadOSC        : String;   { File header OSC                  }
  WaveDataCn1        : String;   { Wave data channel 1              }
  WaveDataCn2        : String;   { Wave data channel 2              }
  WaveDataCn3        : String;   { Wave data channel 3              }
  WaveDataCn4        : String;   { Wave data channel 4              }
  SaveError          : String;   { Error save file                  }
  Cn1Scale           : Real;     { Channel 1 scale value            }
  Cn2Scale           : Real;     { Channel 2 scale value            }
  Cn3Scale           : Real;     { Channel 3 scale value            }
  Cn4Scale           : Real;     { Channel 4 scale value            }
  Cn1Offs            : Real;     { Channel 1 offset value           }
  Cn2Offs            : Real;     { Channel 2 offset value           }
  Cn3Offs            : Real;     { Channel 3 offset value           }
  Cn4Offs            : Real;     { Channel 4 offset value           }
  Status             : Integer;  { Status calculate device          }
  ChanNum            : Integer;  { Channel number                   }
  BASEDIR            : TTagRef;  { Base directory                   }
  EXPDIR             : TTagRef;  { Experiment directory             }
  EXTRACTNUM         : TTagRef;  { Extraction number                }
  OSCNAME            : TTagRef;  { Name oscilloscope                }
  CALCUL             : TTagRef;  { Calculate file data              }
  TIMDELAY           : TTagRef;  { Value time delay                 }
  TIMSCALE           : TTagRef;  { Value time scale                 }
  ACQSMPLRTE         : TTagRef;  { Value acquire sampling rate      }
  WAVESAVESTT        : TTagRef;  { Status waveform save             }
  CN1,CN2,CN3,CN4    : TChanRec; { Channels                         }
  DEF                : record    { Default                          }
   DIRBASE           : TTagRef;  {  Base directory                  }
   DIREXP            : TTagRef;  {  Experiment directory            }
  end;                           {                                  }
  ACQ                : record    { Acquire                          }
   SMPLRT            : TTagRef;  {  Sampling rate                   }
  end;                           {                                  }
  TIM                : record    { Time                             }
   DEL               : TTagRef;  {  Delay                           }
   SCAL              : TTagRef;  {  Scale                           }
  end;                           {                                  }
  WAV                : record    { Wave                             }
   SOUR              : TTagRef;  {  Source                          }
   POIN              : TTagRef;  {  Points                          }
   COPY              : TTagRef;  {  Copy waveform                   }
  end;                           {                                  }
  MODECALCDEV        : TTagRef;  { Mode calculate device            }
  FILENAME           : TTagRef;  { Name handling file               }
  FILENAMEBTN        : TTagRef;  { Chose handling file              }
  DRAW               : record    { Draw                             }
   CURVE             : TTagRef;  {  Curve waveforms                 }
  end;                           {                                  }
  CHECK              : record    { Chose automatical drawing curve  }
   CURVE             : TTagRef;  {                                  }
  end;                           {                                  }
 end;                            {                                  }
 cmd_Demo            : Integer;  { Command @Demo                    }
 cmd_Edit            : Integer;  { Command @Edit                    }
 cmd_CopyWaveForm    : Integer;  { Command @CopyWaveForm            }
 cmd_CalculateData   : Integer;  { Command @CalculateData           }
 cmd_AssignTag       : Integer;  { Command @AssignTag               }
 cmd_DeviceMode      : Integer;  { Command @DeviceMode              }
 cmd_ReadFile        : Integer;  { Command @ReadFile                }
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Init tags
 }
 procedure AkipInitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(AKIP.BASEDIR.tag,         Prefix+'.BASEDIR',         3);
   InitTag(AKIP.EXPDIR.tag,          Prefix+'.EXPDIR',          3);
   InitTag(AKIP.DEF.DIRBASE.tag,     Prefix+'.DEF.DIRBASE',     3);
   InitTag(AKIP.DEF.DIREXP.tag,      Prefix+'.DEF.DIREXP',      3);
   InitTag(AKIP.FILENAME.tag,        Prefix+'.FILENAME',        3);
   InitTag(AKIP.FILENAMEBTN.tag,     Prefix+'.FILENAMEBTN',     1);
   InitTag(AKIP.EXTRACTNUM.tag,      Prefix+'.EXTRACTNUM',      3);
   InitTag(AKIP.CN1.OFFSET.tag,      Prefix+'.CN1.OFFSET',      2);
   InitTag(AKIP.CN1.SCALE.tag,       Prefix+'.CN1.SCALE',       2);
   InitTag(AKIP.CN1.OFFS.tag,        Prefix+'.CN1.OFFS',        2);
   InitTag(AKIP.CN1.SCAL.tag,        Prefix+'.CN1.SCAL',        2);
   InitTag(AKIP.CN1.WAVFORM.tag,     Prefix+'.CN1.WAVFORM',     3);
   InitTag(AKIP.CN2.OFFSET.tag,      Prefix+'.CN2.OFFSET',      2);
   InitTag(AKIP.CN2.SCALE.tag,       Prefix+'.CN2.SCALE',       2);
   InitTag(AKIP.CN2.OFFS.tag,        Prefix+'.CN2.OFFS',        2);
   InitTag(AKIP.CN2.SCAL.tag,        Prefix+'.CN2.SCAL',        2);
   InitTag(AKIP.CN2.WAVFORM.tag,     Prefix+'.CN2.WAVFORM',     3);
   InitTag(AKIP.CN3.OFFSET.tag,      Prefix+'.CN3.OFFSET',      2);
   InitTag(AKIP.CN3.SCALE.tag,       Prefix+'.CN3.SCALE',       2);
   InitTag(AKIP.CN3.OFFS.tag,        Prefix+'.CN3.OFFS',        2);
   InitTag(AKIP.CN3.SCAL.tag,        Prefix+'.CN3.SCAL',        2);
   InitTag(AKIP.CN3.WAVFORM.tag,     Prefix+'.CN3.WAVFORM',     3);
   InitTag(AKIP.CN4.OFFSET.tag,      Prefix+'.CN4.OFFSET',      2);
   InitTag(AKIP.CN4.SCALE.tag,       Prefix+'.CN4.SCALE',       2);
   InitTag(AKIP.CN4.OFFS.tag,        Prefix+'.CN4.OFFS',        2);
   InitTag(AKIP.CN4.SCAL.tag,        Prefix+'.CN4.SCAL',        2);
   InitTag(AKIP.CN4.WAVFORM.tag,     Prefix+'.CN4.WAVFORM',     3);
   InitTag(AKIP.WAV.SOUR.tag,        Prefix+'.WAV.SOUR',        3);
   InitTag(AKIP.WAV.POIN.tag,        Prefix+'.WAV.POIN',        1);
   InitTag(AKIP.ACQ.SMPLRT.tag,      Prefix+'.ACQ.SMPLRT',      2);
   InitTag(AKIP.WAVESAVESTT.tag,     Prefix+'.WAVESAVESTT',     1);
   InitTag(AKIP.TIM.DEL.tag,         Prefix+'.TIM.DEL',         2);
   InitTag(AKIP.TIM.SCAL.tag,        Prefix+'.TIM.SCAL',        2);
   InitTag(AKIP.MODECALCDEV.tag,     Prefix+'.MODECALCDEV',     1);
   InitTag(AKIP.DRAW.CURVE.tag,      Prefix+'.DRAW.CURVE',      1);
   InitTag(AKIP.CHECK.CURVE.tag,     Prefix+'.CHECK.CURVE',     1);
   InitTag(AKIP.WAV.COPY.tag,        Prefix+'.WAV.COPY',        1);
   InitTag(AKIP.CALCUL.tag,          Prefix+'.CALCUL',          1);
   InitTag(AKIP.TIMDELAY.tag,        Prefix+'.TIMDELAY',        2);
   InitTag(AKIP.TIMSCALE.tag,        Prefix+'.TIMSCALE',        2);
   InitTag(AKIP.ACQSMPLRTE.tag,      Prefix+'.ACQSMPLRTE',      2);
   InitTag(AKIP.OSCNAME.tag,         Prefix+'.OSCNAME',         3);
  end;
 end;
 {
 Prefix for DIM @remote commands.
 }
 function DimRemote:String;
 var CanRemote:Boolean;
 begin
  CanRemote:=DIM_IsServerMode or DIM_IsClientMode;
  if (DIM_GuiClickTag=0) then CanRemote:=false;
  if (devDimSrv=0) then CanRemote:=false;
  if CanRemote
  then DimRemote:='@remote '
  else DimRemote:='';
 end;
 {
 Handle message @AssingTag argument
 }
 procedure AkipOnAssignTag(s:String);
 var tag:Integer; w1,w2:String;
  procedure Cleanup;
  begin
   w1:=''; w2:='';
  end;
 begin
  Cleanup;
  if (s<>'') then begin
   w1:=ExtractWord(1,s);
   tag:=FindTag(w1);
   if (tag<>0) then begin
    w2:=ExtractWord(2,s);
    if tag=AKIP.MODECALCDEV.tag then UpdateTag(tag,w2,0,1);
   end;
  end;
  Cleanup;
 end;
 {
 Create file header for OSC file
 }
 procedure FileHeaderOSC;
 var Header,TimeDel,TimeScl,SmpRt,Cn1Scl,Cn1Offs,Cn2Scl,Cn2Offs,Cn3Scl,Cn3Offs,Cn4Scl,Cn4Offs:String;
  procedure Cleanup;
  begin
   Header:=''; TimeDel:=''; TimeScl:=''; SmpRt:='';
   Cn1Scl:=''; Cn1Offs:=''; Cn2Scl:=''; Cn2Offs:='';
   Cn3Scl:=''; Cn3Offs:=''; Cn4Scl:=''; Cn4Offs:='';
  end;
 begin
  Cleanup;
  if iGetTag(AKIP.MODECALCDEV.tag)=1 then begin
   TimeDel:=str(rGetTag(AKIP.TIM.DEL.tag)); TimeScl:=str(rGetTag(AKIP.TIM.SCAL.tag)); SmpRt:=str(rGetTag(AKIP.ACQ.SMPLRT.tag));
   Cn1Scl:=str(rGetTag(AKIP.CN1.SCAL.tag)); Cn1Offs:=str(rGetTag(AKIP.CN1.OFFS.tag));
   Cn2Scl:=str(rGetTag(AKIP.CN2.SCAL.tag)); Cn2Offs:=str(rGetTag(AKIP.CN2.OFFS.tag));
   Cn3Scl:=str(rGetTag(AKIP.CN3.SCAL.tag)); Cn3Offs:=str(rGetTag(AKIP.CN3.OFFS.tag));
   Cn4Scl:=str(rGetTag(AKIP.CN4.SCAL.tag)); Cn4Offs:=str(rGetTag(AKIP.CN4.OFFS.tag));
  end else begin
   TimeDel:=str(rGetTag(AKIP.TIMDELAY.tag)); TimeScl:=str(rGetTag(AKIP.TIMSCALE.tag)); SmpRt:=str(rGetTag(AKIP.ACQSMPLRTE.tag));
   Cn1Scl:=str(rGetTag(AKIP.CN1.SCALE.tag)); Cn1Offs:=str(rGetTag(AKIP.CN1.OFFSET.tag));
   Cn2Scl:=str(rGetTag(AKIP.CN2.SCALE.tag)); Cn2Offs:=str(rGetTag(AKIP.CN2.OFFSET.tag));
   Cn3Scl:=str(rGetTag(AKIP.CN3.SCALE.tag)); Cn3Offs:=str(rGetTag(AKIP.CN3.OFFSET.tag));
   Cn4Scl:=str(rGetTag(AKIP.CN4.SCALE.tag)); Cn4Offs:=str(rGetTag(AKIP.CN4.OFFSET.tag));
  end;
  Header:='[Common]'+EOL;
  Header:=Header+'TimeDiv = '+TimeScl+EOL;
  Header:=Header+'TrigDelay = '+TimeDel+EOL;
  Header:=Header+'SampleRate = '+SmpRt+EOL;
  Header:=Header+'[C1]'+EOL;
  Header:=Header+'Offset = '+Cn1Offs+EOL;
  Header:=Header+'Scale = '+Cn1Scl+EOL;
  Header:=Header+'[C2]'+EOL;
  Header:=Header+'Offset = '+Cn2Offs+EOL;
  Header:=Header+'Scale = '+Cn2Scl+EOL;
  Header:=Header+'[C3]'+EOL;
  Header:=Header+'Offset = '+Cn3Offs+EOL;
  Header:=Header+'Scale = '+Cn3Scl+EOL;
  Header:=Header+'[C4]'+EOL;
  Header:=Header+'Offset = '+Cn4Offs+EOL;
  Header:=Header+'Scale = '+Cn4Scl+EOL;
  AKIP.FileHeadOSC:=Header;
  Cleanup;
 end;
 {
 Create file header for CSV file
 Form:='Формула расчета - voltage value = code value * (ChanScale/30) - ChanOffset';
 }
 procedure FileHeaderCSV;
 var Header:String;
  procedure Cleanup;
  begin
   Header:='';
  end;
 begin
  Cleanup;
  if iGetTag(AKIP.MODECALCDEV.tag)=1 then begin
   Header:='Time div'+CHR(_HT)+str(rGetTag(AKIP.TIM.SCAL.tag))+EOL;
   Header:=Header+'Trigger delay'+CHR(_HT)+str(rGetTag(AKIP.TIM.DEL.tag))+EOL;
   Header:=Header+'Channel Scale'+CHR(_HT)+str(rGetTag(AKIP.CN1.SCAL.tag))+CHR(_HT)+str(rGetTag(AKIP.CN2.SCAL.tag))+CHR(_HT)+str(rGetTag(AKIP.CN3.SCAL.tag))+CHR(_HT)+str(rGetTag(AKIP.CN4.SCAL.tag))+EOL;
   Header:=Header+'Channel Offset'+CHR(_HT)+str(rGetTag(AKIP.CN1.OFFS.tag))+CHR(_HT)+str(rGetTag(AKIP.CN2.OFFS.tag))+CHR(_HT)+str(rGetTag(AKIP.CN3.OFFS.tag))+CHR(_HT)+str(rGetTag(AKIP.CN4.OFFS.tag))+EOL;
   Header:=Header+'Channel Name'+EOL+'Channel 1'+CHR(_HT)+'Channel 2'+CHR(_HT)+'Channel 3'+CHR(_HT)+'Channel 4';
  end else begin
   Header:='Time div'+CHR(_HT)+str(rGetTag(AKIP.TIMSCALE.tag))+EOL;
   Header:=Header+'Trigger delay'+CHR(_HT)+str(rGetTag(AKIP.TIMDELAY.tag))+EOL;
   Header:=Header+'Channel Scale'+CHR(_HT)+str(rGetTag(AKIP.CN1.SCALE.tag))+CHR(_HT)+str(rGetTag(AKIP.CN2.SCALE.tag))+CHR(_HT)+str(rGetTag(AKIP.CN3.SCALE.tag))+CHR(_HT)+str(rGetTag(AKIP.CN4.SCALE.tag))+EOL;
   Header:=Header+'Channel Offset'+CHR(_HT)+str(rGetTag(AKIP.CN1.OFFSET.tag))+CHR(_HT)+str(rGetTag(AKIP.CN2.OFFSET.tag))+CHR(_HT)+str(rGetTag(AKIP.CN3.OFFSET.tag))+CHR(_HT)+str(rGetTag(AKIP.CN4.OFFSET.tag))+EOL;
   Header:=Header+'Channel Name'+EOL+'Channel 1'+CHR(_HT)+'Channel 2'+CHR(_HT)+'Channel 3'+CHR(_HT)+'Channel 4';
  end;
  AKIP.FileHeadCSV:=Header;
  Cleanup;
 end;
 {
 Make new directory
 }
 procedure MakeDirectory;
 var DirWave,DeflDir:String;
  procedure Cleanup;
  begin
   DirWave:=''; DeflDir:='';
  end;
 begin
  Cleanup;
  DeflDir:=sGetTag(AKIP.DEF.DIRBASE.tag)+sGetTag(AKIP.DEF.DIREXP.tag);
  DirWave:=sGetTag(AKIP.BASEDIR.tag)+sGetTag(AKIP.EXPDIR.tag);
  if pos('--',DirWave)<>0 then begin ShowTooltip('text "Отсутствует путь копирования" delay 10000 preset stdWarning');
  end else
  if IsSameText(DirWave,DeflDir) then begin
   if not DirExists(DeflDir) then bNul(mkDir(DeflDir));
  end else begin
   if not DirExists(DirWave) then bNul(mkDir(DirWave));
   if not DirExists(DeflDir) then bNul(mkDir(DeflDir));
   if DirExists(DirWave) then begin
    AKIP.PathDirWave:=DirWave;
    ShowTooltip('text "Каталог есть" delay 5000 preset stdSuccess');
   end else begin
    AKIP.PathDirWave:=DeflDir;
    ShowTooltip('text "Каталога нет" delay 5000 preset stdWarning');
   end;
  end;
  AKIP.PathDfltDirWave:=DeflDir;
  Cleanup;
 end;
 {
 Copy oscillogram file in new folder
 }
 procedure CopyFile;
 var i,n:Integer; FileName:String;
  procedure Cleanup;
  begin
   FileName:='';
  end;
 begin
  Cleanup;
  MakeDirectory;
  if not IsEmptyStr(AKIP.FileNameOSC) or not IsEmptyStr(AKIP.FileNameCSV) or not IsEmptyStr(sGetTag(AKIP.FILENAME.tag)) then
   if direxists(AKIP.PathDirWave) then begin
    DevSendCmdLocal('@CopyWaveForm '+(AKIP.PathDfltDirWave+AKIP.FileNameOSC)+' '+(AKIP.PathDirWave+AKIP.FileNameOSC));
    DevSendCmdLocal('@CopyWaveForm '+(AKIP.PathDfltDirWave+AKIP.FileNameCSV)+' '+(AKIP.PathDirWave+AKIP.FileNameCSV));
   end else begin
    i:=0;
    if IsUnix then
     repeat
      i:=PosEx('/',sGetTag(AKIP.FILENAME.tag),i+1);
      if (i>0) then n:=i;
     until (i<=0)
    else if IsWindows then
     repeat
      i:=PosEx('\',sGetTag(AKIP.FILENAME.tag),i+1);
      if (i>0) then n:=i;
     until (i<=0);
    FileName:=copy(sGetTag(AKIP.FILENAME.tag),n+1,length(sGetTag(AKIP.FILENAME.tag))-(n-1));
    if IsEmptyStr(FileName) then ShowTooltip('text "Ошибка в пути копирования" delay 10000 preset stdWarning')
    else DevSendCmdLocal('@CopyWaveForm '+(AKIP.PathDfltDirWave+FileName)+' '+(AKIP.PathDirWave+FileName));
   end 
  else ShowTooltip('text "Отсутствуют файлы для копирования" delay 10000 preset stdWarning');
  Cleanup;
 end;
 {
 Save CSV file
 }
 procedure WaveDataSaveCSV;
 var i,io:Integer; DeflFile:String; CN1,CN2,CN3,CN4:real;
  procedure Cleanup;
  begin
   DeflFile:='';
  end;
 begin
  Cleanup;
  FileHeaderCSV;
  DeflFile:=AKIP.PathDfltDirWave+AKIP.FileNameCSV;
  if FileExists(DeflFile) then io:=f_reset(DeflFile,2) else io:=f_rewrite(DeflFile,2);
  if io=0 then begin
   iNul(f_write(AKIP.FileHeadCSV+Eol));
   for i:=0 to AKIP.ArrayField do begin
    CN1:=rVec_get(AKIP.CN1.Points,i);
    CN2:=rVec_get(AKIP.CN2.Points,i);
    CN3:=rVec_get(AKIP.CN3.Points,i);
    CN4:=rVec_get(AKIP.CN4.Points,i);
    iNul(f_write(str(CN1)+_SemiColon+CHR(_HT)+str(CN2)+_SemiColon+CHR(_HT)+str(CN3)+_SemiColon+CHR(_HT)+str(CN4)+_SemiColon+EOL));
   end;
   writeln('Wrote '+Str(f_size)+' byte(s) to '+DeflFile);
   bNul(f_close);
   bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,2,true));
   AKIP.SaveError:=AKIP.SaveError+' CSV OK.';
   AKIP.Status:=stt_Clear;
  end else begin
   Trouble('Error create CSV file');
   bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,2,false));
   AKIP.SaveError:=AKIP.SaveError+' Error CSV file.';
   AKIP.Status:=stt_Clear;
  end;
  bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,4,false));
  Cleanup;
 end;
 {
 Save OSC file and reflection curve
 }
 procedure WaveDataSaveOSC;
 var io:Integer; DeflFile:String;
  procedure Cleanup;
  begin
    DeflFile:='';
  end;
 begin
  Cleanup;
  FileHeaderOSC;
  DeflFile:=AKIP.PathDfltDirWave+AKIP.FileNameOSC;
  if FileExists(DeflFile) then io:=f_reset(DeflFile,2) else io:=f_rewrite(DeflFile,2);
  if io=0 then begin
   writeln(rVec_Length(AKIP.CN1.Points));
   writeln(rVec_Length(AKIP.CN2.Points));
   writeln(rVec_Length(AKIP.CN3.Points));
   writeln(rVec_Length(AKIP.CN4.Points));
   iNul(f_write(AKIP.FileHeadOSC+AKIP.WaveDataCn1+AKIP.CN1.Points+EOL+AKIP.WaveDataCn2+AKIP.CN2.Points+EOL+AKIP.WaveDataCn3+AKIP.CN3.Points+EOL+AKIP.WaveDataCn4+AKIP.CN4.Points));
   writeln('Wrote '+Str(f_size)+' byte(s) to '+DeflFile);
   bNul(f_close);
   bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,1,true));
   AKIP.SaveError:=AKIP.SaveError+' OSC OK.';
   AKIP.Status:=stt_Clear;
  end else begin 
   Trouble('Error create OSC file');
   bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,1,false));
   AKIP.SaveError:=AKIP.SaveError+' Error OSC file.';
  end;
  Cleanup;
  if iGetTag(AKIP.CHECK.CURVE.tag)=1 then begin
   DevSendCmdLocal('@WinDraw '+ReadIni('tagPrefix')+'.PLOT |Range=xmin;ymin;xmax;ymax');
   DevSendCmdLocal('@WinSelect '+ReadIni('tagPrefix')+'.PLOT');
  end;
  bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,3,false));
  Cleanup;
 end;
 {
 Generate file name for save oscillograms
 }
 procedure GenerateFileName;
 var ExtractionNum,FileName:String;
  procedure Cleanup;
  begin
   ExtractionNum:=''; FileName:='';
  end;
 begin
  Cleanup;
  ExtractionNum:=sGetTag(AKIP.EXTRACTNUM.tag);
  if not IsEmptyStr(sGetTag(AKIP.OSCNAME.tag)) then FileName:=ExtractionNum+'_'+sGetTag(AKIP.OSCNAME.tag)+'_'+StrTimeFmt('yyyymmdd_hhnnss',msecnow)
  else FileName:=ExtractionNum+'_'+AKIP.FilePrefix+'_'+StrTimeFmt('yyyymmdd_hhnnss',msecnow);
  AKIP.FileNameOSC:=FileName+'.osc';
  AKIP.FileNameCSV:=FileName+'.csv';
  Cleanup;
 end;
 {
 Calculate the voltage value corresponding to Wavedata in online status
 }
 procedure CalculateWaveData(var Chan:TChanRec; curve,n:Integer; PointX,PointInterval,CnScale,CnOffs:Real);
 var Data,RawPoint:String; cRef,scal,offs,curPoint,Point:Real; i:Integer;
  procedure Cleanup;
  begin
   Data:=''; RawPoint:='';
  end;
  function ConvertToSigned(IntRawPoint:Integer):Integer;
  var SignedInt:Integer;
  begin
   SignedInt:=IntRawPoint;
   if isBit(IntRawPoint,7) then SignedInt:=IntRawPoint-255;
   ConvertToSigned:=SignedInt;
  end;
 begin
  Cleanup;
  Data:=sGetTag(Chan.WAVFORM.tag);
  if iGetTag(AKIP.MODECALCDEV.tag)=1 then begin
   scal:=rGetTag(Chan.SCAL.tag);
   offs:=rGetTag(Chan.OFFS.tag);
  end else begin
   scal:=rGetTag(Chan.SCALE.tag);
   offs:=rGetTag(Chan.OFFSET.tag);
  end;
  if not IsEmptyStr(Data) then begin
   rVec_Free(Chan.Points);
   Chan.Points:=rVec_Init(AKIP.ArrayField);
   cRef:=refao(curve);
   //writeln(curve);
   if crvLock(cRef) then begin
    rNul(crvDel(cRef,1,crvLen(cRef)));
    bNul(crvUnlock(cRef));
   end;
   for i:=12 to length(Data) do begin//i=12
    RawPoint:=Copy(Data,i,1);
    curPoint:=ConvertToSigned(dump2i(RawPoint));
    Point:=curPoint*(scal/30)-offs;
    rVec_Set(Chan.Points,i-12,Point);//i-12
    bNul(crvPut(cRef,crvLen(cRef)+1,PointX,Point));
    PointX:=PointX+PointInterval;
   end;
   AKIP.ChanNum:=n+1;
  end else begin
   cRef:=refao(curve);
   if crvLock(cRef) then begin
    rNul(crvDel(cRef,1,crvLen(cRef)));
    bNul(crvUnlock(cRef));
   end;
   Chan.Points:=rVec_Init(0);
   AKIP.ChanNum:=n+1;
  end;
  Cleanup;
 end;
 {
 Oscillograms handling
 }
 procedure WaveDataHandling(n:Integer);
 var PointX,PointInterval:Real;buff:String;
 begin
  buff:='';
  if iGetTag(AKIP.MODECALCDEV.tag)=1 then begin
   PointX:=rGetTag(AKIP.TIM.DEL.tag)-(rGetTag(AKIP.TIM.SCAL.tag)*10/2);
   PointInterval:=rGetTag(AKIP.ACQ.SMPLRT.tag);
   if not IsEmptyStr(sGetTag(AKIP.CN1.WAVFORM.tag)) then buff:=sGetTag(AKIP.CN1.WAVFORM.tag)
   else if not IsEmptyStr(sGetTag(AKIP.CN2.WAVFORM.tag)) then buff:=sGetTag(AKIP.CN2.WAVFORM.tag)
   else if not IsEmptyStr(sGetTag(AKIP.CN3.WAVFORM.tag)) then buff:=sGetTag(AKIP.CN3.WAVFORM.tag)
   else if not IsEmptyStr(sGetTag(AKIP.CN4.WAVFORM.tag)) then buff:=sGetTag(AKIP.CN4.WAVFORM.tag);
   AKIP.ArrayField:=val(Copy(buff,3,RawHeaderWFM-2));
   AKIP.WaveDataCn1:='DAT1,'+Copy(buff,1,RawHeaderWFM);
   AKIP.WaveDataCn2:='DAT2,'+Copy(buff,1,RawHeaderWFM);
   AKIP.WaveDataCn3:='DAT3,'+Copy(buff,1,RawHeaderWFM);
   AKIP.WaveDataCn4:='DAT4,'+Copy(buff,1,RawHeaderWFM);
   buff:='';
  end else begin
   PointX:=rGetTag(AKIP.TIMDELAY.tag)-(rGetTag(AKIP.TIMSCALE.tag)*10/2);
   PointInterval:=rGetTag(AKIP.ACQSMPLRTE.tag);
   bNul(rSetTag(AKIP.ACQ.SMPLRT.tag,rGetTag(AKIP.ACQSMPLRTE.tag)));
  end;
  if n=1 then CalculateWaveData(AKIP.CN1,0,n,PointX,PointInterval,0,0) else
  if n=2 then CalculateWaveData(AKIP.CN2,1,n,PointX,PointInterval,0,0) else
  if n=3 then CalculateWaveData(AKIP.CN3,2,n,PointX,PointInterval,0,0) else
  if n=4 then CalculateWaveData(AKIP.CN4,3,n,PointX,PointInterval,0,0) else
  if n=5 then begin
   WaveDataSaveOSC;
   WaveDataSaveCSV;
   CopyFile;
   if pos('Error',AKIP.SaveError)<>0 then bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,0,false))
   else bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,0,true));
   AKIP.SaveError:='';
  end;
 end;
 {
 Procedure to handle data line number n
 }
 procedure HandleData(line:String);
 var
  procedure SetTagValue(tag:Integer);
  begin
   if tag=AKIP.ACQSMPLRTE.tag then bNul(rSetTag(tag,rVal(Copy(line,pos(':',line)+1,length(line)))))
   else bNul(rSetTag(tag,rVal(Copy(line,pos(':',line)+1,length(line)))));
  end;
  function SetValue:String;
  begin
   SetValue:=Copy(line,pos(':',line)+1,length(line));
  end;
 begin
  if pos('Time Delay:',line)>0       then bNul(rSetTag(AKIP.TIMDELAY.tag,rVal(SetValue))) else //SetTagValue(AKIP.TIMDELAY.tag);
  if pos('Time Scale:',line)>0       then bNul(rSetTag(AKIP.TIMSCALE.tag,rVal(SetValue))) else //SetTagValue(AKIP.TIMSCALE.tag);
  if pos('Acq Sample Rate:',line)>0  then bNul(rSetTag(AKIP.ACQSMPLRTE.tag,rVal(SetValue))) else //SetTagValue(AKIP.ACQSMPLRTE.tag);
  if pos('Cn1 Scale:',line)>0        then begin
   bNul(rSetTag(AKIP.CN1.SCALE.tag,rVal(SetValue)));
   AKIP.FileChanNum:=AKIP.FileChanNum+1;
  end else
  if pos('Cn1 Offset:',line)>0       then bNul(rSetTag(AKIP.CN1.OFFSET.tag,rVal(SetValue))) else
  if pos('Cn2 Scale:',line)>0        then begin
   bNul(rSetTag(AKIP.CN2.SCALE.tag,rVal(SetValue)));
   AKIP.FileChanNum:=AKIP.FileChanNum+1;
  end else
  if pos('Cn2 Offset:',line)>0       then bNul(rSetTag(AKIP.CN2.OFFSET.tag,rVal(SetValue))) else
  if pos('Cn3 Scale:',line)>0        then begin
   bNul(rSetTag(AKIP.CN3.SCALE.tag,rVal(SetValue)));
   AKIP.FileChanNum:=AKIP.FileChanNum+1;
  end else
  if pos('Cn3 Offset:',line)>0       then bNul(rSetTag(AKIP.CN3.OFFSET.tag,rVal(SetValue))) else
  if pos('Cn4 Scale:',line)>0        then begin
   bNul(rSetTag(AKIP.CN4.SCALE.tag,rVal(SetValue)));
   AKIP.FileChanNum:=AKIP.FileChanNum+1;
  end else
  if pos('Cn4 Offset:',line)>0       then bNul(rSetTag(AKIP.CN4.OFFSET.tag,rVal(SetValue)));
 end;
 
 procedure HandleDataWF(var buff:String);
 var n:Integer;
  procedure HandleDatPos(tag,position:Integer);
  var CnName,Points:Integer;
  begin
   CnName:=position;
   Points:=val(copy(buff,CnName+7,9));
   AKIP.ArrayField:=Points;
   bNul(sSetTag(tag,Copy(buff,pos('#',buff),AKIP.ArrayField+RawHeaderWFM)));
   buff:=Copy(buff,pos('DAT1',buff)+points,length(buff));
  end;
 begin
  while (n>=0) and (n<=AKIP.FileChanNum) do begin
   if pos('DAT1,',buff)>0 then begin
    AKIP.WaveDataCn1:=Copy(buff,pos('DAT1',buff),16);
    HandleDatPos(AKIP.CN1.WAVFORM.tag,pos('DAT1,',buff));
   end else
   if pos('DAT2,',buff)>0 then begin
    AKIP.WaveDataCn2:=Copy(buff,pos('DAT2',buff),16);
    HandleDatPos(AKIP.CN2.WAVFORM.tag,pos('DAT2,',buff));
   end else
   if pos('DAT3,',buff)>0 then begin
    AKIP.WaveDataCn3:=Copy(buff,pos('DAT3',buff),16);
    HandleDatPos(AKIP.CN3.WAVFORM.tag,pos('DAT3,',buff));
   end else
   if pos('DAT4,',buff)>0 then begin
    AKIP.WaveDataCn4:=Copy(buff,pos('DAT4',buff),16);
    HandleDatPos(AKIP.CN4.WAVFORM.tag,pos('DAT4,',buff));
   end;
   n:=n+1;
  end;
 end;
 {
 Handle lines in buffer, return num.lines
 }
 procedure HandleLines(var buff:String);
 var p,s,n,l:Integer;
 begin
  p:=1; s:=1; n:=0; l:=length(buff);
  while (p>=1) and (p<=l) do begin
   p:=PosEol(buff,s,0);
   if (p>0) then begin
    if length(Copy(buff,s,p-s))=0 then begin 
     s:=PosEol(buff,p,1);
     n:=n+1;
    end else begin
      HandleData(Copy(buff,s,p-s));
      s:=PosEol(buff,p,1);
      n:=n+1;
    end;
   end else
   if (s<=l) then begin
    HandleData(Copy(buff,s,l-s+1));
    n:=n+1;
   end;
  end;
 end;
 {
 Read file data conserved oscillograms
 }
 procedure ReadData;
 var io:Integer; buff:String;
 begin
  buff:='';
  AKIP.PathDirWave:=sGetTag(AKIP.FILENAME.tag);
  if pos('_raw',AKIP.PathDirWave)>0 then begin
   if FileExists(AKIP.PathDirWave) then io:=(f_reset(AKIP.PathDirWave,2))
   else ShowTooltip('text "Неверно указан файл или его не существует" delay 10000 preset stdWarning');
   if io=0 then begin
    buff:=f_read(round(f_size));
    bNul(f_close);
    HandleLines(buff);
    HandleDataWF(buff);
    DevSendCmdLocal('@CalculateData');
   end else ShowTooltip('text "Ошибка открытия файла" delay 10000 preset stdWarning');
  end else ShowTooltip('text "Выбранный файл не является raw файлом или не имеет расширения osc" delay 10000 preset stdWarning');
  AKIP.PathDirWave:='';
  buff:='';
 end;
 {
 Xor bit on click
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(tag)+' '+Str(iXor(iGetTag(tag),XorMask)));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Xor bit on click
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Post command (cmd) to console on tag click.
 }
 procedure DevSendCmdEdit(tag:Integer; par:String);
 begin
  if CLickTag=tag then begin
   DevPostCmdLocal('@Edit '+NameTag(tag)+' '+par);
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Set base directory for save oscillogram file
 }
 procedure SetBaseDir(arg:String);
 begin
  if not IsEmptyStr(arg) then begin
   bNul(sSetTag(AKIP.BASEDIR.tag,AdaptFileName(AddPathDelim(arg))));
   Success('New copy directory: '+AddPathDelim(arg));
  end else bNul(sSetTag(AKIP.BASEDIR.tag,AdaptFileName(AddPathDelim(ReadIni('DefaultBaseDir')))));
 end;
 {
 Set experiment directory for save oscillogram file
 }
 procedure SetExpDir(arg:String);
 begin
  if not IsEmptyStr(arg) then begin
   bNul(sSetTag(AKIP.EXTRACTNUM.tag,''));
   bNul(sSetTag(AKIP.EXPDIR.tag,AdaptFileName(AddPathDelim(arg))));
   if IsWindows then
    if strtointbase(ExtractWordDelims(2,arg,Dump('\')),10,0)<>0 then
     bNul(sSetTag(AKIP.EXTRACTNUM.tag,ExtractWordDelims(2,arg,Dump('\'))))
    else begin end
   else if IsUnix then 
    if strtointbase(ExtractWordDelims(2,arg,Dump('/')),10,0)<>0 then
     bNul(sSetTag(AKIP.EXTRACTNUM.tag,ExtractWordDelims(2,arg,Dump('/'))))
    else begin end;
   Success('New copy catalog: '+AddPathDelim(arg));
  end else bNul(sSetTag(AKIP.EXPDIR.tag,AdaptFileName(AddPathDelim(ReadIni('DefaultExpDir')))));
 end;
 {
 Select file oscillogram(s)
 }
 procedure SelectFileDialog;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Укажите файл осциллограмм:');
   n:=n+EditAddInputLn(' ..\..\Data\*.osc');
   n:=n+EditAddInputLn(' Oscilloscope files (*.osc)|*.osc|');
   n:=n+EditAddInputLn(' All files (*.*)|*.*|');
   n:=n+EditAddSetting('@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox');
   n:=n+EditAddClosing('FileOpenDialog',EditGetUID('FOPEN'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var s:String; ClickCurve,i:Integer;
  procedure Cleanup;
  begin
   s:=''; DIM_GuiClickBuff:='';
  end;
  procedure SelectFileDialogHandler;
  var i:Integer;
  begin
   for i:=1 to EditGetAnswerCount-1 do begin
    bNul(sSetTag(AKIP.FILENAME.tag,edit('?ans '+str(i))));
   end;
  end;
 begin
  Cleanup;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Copy GUI click to DIM buffer for remote execution.
   }
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle local clicks
     }
     if ClickIsLocal then begin
      {
      Handle tag clicks
      }
      if (ClickTag<>0) then begin
       s:=mime_encode(SetFormUnderSensorLeftBottom(ClickParams('')));
       ClickTagXorRemote(AKIP.MODECALCDEV.tag,1);
       if ClickTag=AKIP.FILENAMEBTN.tag then begin
        SelectFileDialog;
       end;
       if ClickTag=AKIP.CALCUL.tag then DevSendCmdLocal('@ReadFile');
       if ClickTag=AKIP.WAV.COPY.tag then CopyFile;
       if ClickTag=AKIP.DRAW.CURVE.tag then begin
        i:=refao(0);
        iNul(WinSelectByCurve(i,0));
        bNul(Voice(snd_Click));
       end;
       if ClickTag=AKIP.CHECK.CURVE.tag then
       if iGetTag(AKIP.CHECK.CURVE.tag)=1 then bNul(iSetTag(AKIP.CHECK.CURVE.tag,0)) else bNul(iSetTag(AKIP.CHECK.CURVE.tag,1));
       DevSendCmdEdit(AKIP.TIMDELAY.tag,s);
       DevSendCmdEdit(AKIP.TIMSCALE.tag,s);
       DevSendCmdEdit(AKIP.FILENAME.tag,s);
       DevSendCmdEdit(AKIP.BASEDIR.tag,s);
       DevSendCmdEdit(AKIP.EXPDIR.tag,s);
       DevSendCmdEdit(AKIP.DEF.DIRBASE.tag,s);
       DevSendCmdEdit(AKIP.DEF.DIREXP.tag,s);
      end;
      {
      Select Plot & Tab windows by curve
      }
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
      {
      Console commands
      }
      if LooksLikeCommand(ClickSensor) then begin
       DevPostCmd(devMySelf,url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Handle remote clicks comes from DIM via @DimGuiClick message.
     @DimGuiClick default handler decode and write events to FIFO,
     so we can find it as ckicks and can handle it in usual way.
     }
     if ClickIsRemote then begin
      {
      Show time defference.
      }
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      {
      Handle remote console commands...
      }
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   if CheckEditTag(AKIP.FILENAME.tag,s)    then bNul(sSetTag(AKIP.FILENAME.tag,s));
   if CheckEditTag(AKIP.BASEDIR.tag,s)     then SetBaseDir(s);
   if CheckEditTag(AKIP.EXPDIR.tag,s)      then SetExpDir(s);
   if CheckEditTag(AKIP.DEF.DIRBASE.tag,s) then bNul(sSetTag(AKIP.DEF.DIRBASE.tag,addpathdelim(s)));
   if CheckEditTag(AKIP.DEF.DIREXP.tag,s)  then bNul(sSetTag(AKIP.DEF.DIREXP.tag,addpathdelim(s)));
   
   if EditTestResultName(EditGetUID('FOPEN')) then begin
    if EditTestResultCode(mr_OK) then SelectFileDialogHandler;
    EditReset;
   end;
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  Cleanup;
 end;
 {
 Initialization calculate process
 }
 procedure CalculateInit;
 begin
  AKIP.ChanNum:=1;
  AKIP.Status:=stt_Handle;
  MakeDirectory;
  GenerateFileName;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  AKIP.FileChanNum:=0;
  AKIP.ArrayField:=0;
  AKIP.FilePrefix:='';
  AKIP.WaveDataCn1:='';
  AKIP.WaveDataCn2:='';
  AKIP.WaveDataCn3:='';
  AKIP.WaveDataCn4:='';
  AKIP.PathDirWave:='';
  AKIP.FileNameCSV:='';
  AKIP.FileNameOSC:='';
  AKIP.SaveError:='';
  AKIP.FileHeadCSV:='';
  AKIP.FileHeadOSC:='';
  AKIP.PathDfltDirWave:='';
  AKIP.CN1.Points:=rVec_Init(0);
  AKIP.CN2.Points:=rVec_Init(0);
  AKIP.CN3.Points:=rVec_Init(0);
  AKIP.CN4.Points:=rVec_Init(0);
  bNul(rSetTag(AKIP.TIMDELAY.tag,0));
  bNul(rSetTag(AKIP.TIMSCALE.tag,0));
  bNul(rSetTag(AKIP.ACQSMPLRTE.tag,0));
  bNul(sSetTag(AKIP.FILENAME.tag,'-'));
  bNul(iSetTag(AKIP.CHECK.CURVE.tag,0));
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  bNul(sSetTag(AKIP.FILENAME.tag,''));
  bNul(sSetTag(AKIP.BASEDIR.tag,''));
  bNul(sSetTag(AKIP.EXPDIR.tag,''));
  bNul(sSetTag(AKIP.DEF.DIRBASE.tag,''));
  bNul(sSetTag(AKIP.DEF.DIREXP.tag,''));
  bNul(rSetTag(AKIP.TIMDELAY.tag,0));
  bNul(rSetTag(AKIP.TIMSCALE.tag,0));
  bNul(rSetTag(AKIP.ACQSMPLRTE.tag,0));
  bNul(iSetTag(AKIP.CHECK.CURVE.tag,0));
  AkipInitTags(ReadIni('tagPrefix'));
  AKIP.Sim:=iValDef(ReadIni('Sim'),0)<>0;
  AKIP.FilePrefix:=ReadIni('filePrefix');
  if not AKIP.Sim then
   if IsSameText(ReadIni('CalcDevMode'),'online') then 
    begin 
     Success('Status: '+ReadIni('CalcDevMode'));
     bNul(iSetTag(AKIP.MODECALCDEV.tag,1));
    end
   else if IsSameText(ReadIni('CalcDevMode'),'offline') then 
    begin
     Success('Status: '+ReadIni('CalcDevMode'));
     bNul(iSetTag(AKIP.MODECALCDEV.tag,0));
    end 
   else success('Device status not found')
  else begin
   bNul(iSetTag(AKIP.MODECALCDEV.tag,1));
   Success('Mode: Simulator');
  end;
  cmd_Demo:=RegisterStdInCmd('@Demo','');
  cmd_CopyWaveForm   :=RegisterStdInCmd('@CopyWaveForm',   '');
  cmd_CalculateData  :=RegisterStdInCmd('@CalculateData',  '');
  cmd_AssignTag      :=RegisterStdInCmd('@AssignTag',      '');
  cmd_Edit           :=RegisterStdInCmd('@Edit',           '');
  cmd_DeviceMode     :=RegisterStdInCmd('@DeviceMode',     '');
  cmd_ReadFile       :=RegisterStdInCmd('@ReadFile',       '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  rVec_Free(AKIP.CN1.Points);
  rVec_Free(AKIP.CN2.Points);
  rVec_Free(AKIP.CN3.Points);
  rVec_Free(AKIP.CN4.Points);
 end;
 {
 Status Wavedata handling update
 }
 procedure WaveDataHandlingUpdate;
 begin
  if AKIP.Status=stt_Handle then begin
   WaveDataHandling(AKIP.ChanNum)
  end else
  if AKIP.Status=stt_Clear then begin
   bNul(sSetTag(AKIP.CN1.WAVFORM.tag,''));
   bNul(sSetTag(AKIP.CN2.WAVFORM.tag,''));
   bNul(sSetTag(AKIP.CN3.WAVFORM.tag,''));
   bNul(sSetTag(AKIP.CN4.WAVFORM.tag,''));
   AKIP.Status:=stt_None;
  end;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GUIHandler;
  WaveDataHandlingUpdate;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,DeflFile,PathFile,s,par:String; cmdid,i,tag:Integer; r:Real;
  procedure Cleanup;
  begin
   cmd:=''; arg:=''; DeflFile:=''; PathFile:=''; s:=''; par:='';
  end;
 begin
  Cleanup;
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Demo 123 2*2
   }
   if (cmdid=cmd_Demo) then begin
    i:=iEvalDef(ExtractWord(1,arg),0);
    r:=rEvalDef(ExtractWord(2,arg),_NaN);
    Success(cmd+'='+Str(i)+_Comma+Str(r));
    Data:='';
   end else
   {
   @AssignTag
   }
   if (cmdid=cmd_AssignTag) then begin
    AkipOnAssignTag(arg);
    Data:='';
   end else
   {
   @ReadFile
   }
   if (cmdid=cmd_ReadFile) then begin
    if not IsEmptyStr(sGetTag(AKIP.FILENAME.tag)) and not IsSameText(sGetTag(AKIP.FILENAME.tag),'-') then ReadData
    else begin
     ShowTooltip('text "Не указан файл с осциллограммами" delay 10000 preset stdWarning');
    end;
    Data:='';
   end else
   {
   @CalculateData
   }
   if (cmdid=cmd_CalculateData) then begin
    CalculateInit;
    Data:='';
   end else
   {
   @CopyWaveForm DeflFile PathFile
   }
   if (cmdid=cmd_CopyWaveForm) then begin
    DeflFile:=AdaptFileName(ExtractWord(1,arg));
    PathFile:=AdaptFileName(ExtractWord(2,arg));
    if not IsEmptyStr(DeflFile) and (pos('--',PathFile)<>1) then
     if not IsSameText(DeflFile,PathFile) then
     if FileCopy(DeflFile+EOL+PathFile) then begin
      if pos('.osc',DeflFile)<>0 then bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,3,true))
      else if pos('.csv',DeflFile)<>0 then bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,4,true));
     end else begin
      if pos('.osc',DeflFile)<>0 then bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,3,false))
      else if pos('.osc',DeflFile)<>0 then bNul(iSetTagBitState(AKIP.WAVESAVESTT.tag,4,false));
     end
    else ShowTooltip('text "Не указан путь копирования" delay 10000 preset stdWarning');
    Data:='';
   end else
   {
   @Edit
   }
   if (cmdid=cmd_Edit) then begin
    par:=mime_decode(ExtractWord(2,arg));
    s:=ExtractWord(1,arg);
    tag:=FindTag(s);
    if Pos('FILENAME',s)>0    then StartEditTagEx(tag,'Введите имя файла: ',par);
    if Pos('DEF.DIRBASE',s)>0 then StartEditTagEx(tag,'Введите директорию сохранения: ',par);
    if Pos('DEF.DIREXP',s)>0  then StartEditTagEx(tag,'Введите каталог сохранения: ',par);
    if Pos('BASEDIR',s)>0     then StartEditTagEx(tag,'Введите директорию копирования: ',par);
    if Pos('EXPDIR',s)>0      then StartEditTagEx(tag,'Введите каталог копирования: ',par);
    if Pos('TIMDELAY',s)>0    then StartEditTagEx(tag,'Введите значение временной задержки: ',par);
    if Pos('TIMSCALE',s)>0    then StartEditTagEx(tag,'Введите значение временного масштаба: ',par);
    Data:='';
   end else
   {
   @DeviceMode arg
   }
   if (cmdid=cmd_DeviceMode) then begin
    if IsSameText(arg,'Online') then bNul(iSetTag(AKIP.MODECALCDEV.tag,1))
    else bNul(iSetTag(AKIP.MODECALCDEV.tag,0));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
