/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jaybird.parser.FirebirdReservedWords;
import org.firebirdsql.jaybird.parser.LocalStatementType;
import org.firebirdsql.jaybird.parser.SqlParser;
import org.firebirdsql.jaybird.parser.StatementDetector;
import org.firebirdsql.jaybird.parser.StatementIdentification;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.GeneratedKeysSupport;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.metadata.MetadataPattern;

final class GeneratedKeysQueryBuilder {
    private static final System.Logger logger = System.getLogger(GeneratedKeysQueryBuilder.class.getName());
    private static final Map<LocalStatementType, GeneratedKeysSupport.QueryType> statementTypeToQueryType;
    private static final int IDX_COLUMN_NAME = 4;
    private static final int IDX_ORDINAL_POSITION = 17;
    private final String originalSql;
    private final StatementIdentification statementIdentification;
    private final Set<GeneratedKeysSupport.QueryType> supportedQueryTypes;

    private GeneratedKeysQueryBuilder(String originalSql, StatementIdentification statementIdentification, Set<GeneratedKeysSupport.QueryType> supportedQueryTypes) {
        this.originalSql = originalSql;
        this.statementIdentification = statementIdentification;
        this.supportedQueryTypes = supportedQueryTypes;
    }

    private GeneratedKeysQueryBuilder(String originalSql) {
        this(originalSql, null, Collections.emptySet());
    }

    static GeneratedKeysQueryBuilder create(String statementText, Set<GeneratedKeysSupport.QueryType> supportedQueryTypes) {
        try {
            StatementDetector detector = new StatementDetector();
            SqlParser.withReservedWords(FirebirdReservedWords.latest()).withVisitor(detector).of(statementText).parse();
            return new GeneratedKeysQueryBuilder(statementText, detector.toStatementIdentification(), supportedQueryTypes);
        }
        catch (RuntimeException e) {
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, "Exception parsing query: " + statementText, (Throwable)e);
            }
            return new GeneratedKeysQueryBuilder(statementText);
        }
    }

    boolean isSupportedType() {
        if (this.statementIdentification == null) {
            return false;
        }
        LocalStatementType statementType = this.statementIdentification.getStatementType();
        GeneratedKeysSupport.QueryType queryType = statementTypeToQueryType.getOrDefault((Object)statementType, GeneratedKeysSupport.QueryType.UNSUPPORTED);
        return this.supportedQueryTypes.contains((Object)queryType);
    }

    GeneratedKeysSupport.Query forNoGeneratedKeysOption() {
        if (this.hasReturning()) {
            return new GeneratedKeysSupport.Query(true, this.originalSql);
        }
        return new GeneratedKeysSupport.Query(false, this.originalSql);
    }

    GeneratedKeysSupport.Query forReturnGeneratedKeysOption(FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.hasReturning()) {
            return new GeneratedKeysSupport.Query(true, this.originalSql);
        }
        if (this.isSupportedType()) {
            if (this.supportsReturningAll(databaseMetaData)) {
                return this.useReturningAll();
            }
            return this.useReturningAllColumnsByName(databaseMetaData);
        }
        return new GeneratedKeysSupport.Query(false, this.originalSql);
    }

    private boolean supportsReturningAll(FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseMajorVersion() >= 4;
    }

    private GeneratedKeysSupport.Query useReturningAll() {
        return this.addColumnsByNameImpl(Collections.singletonList("*"), QuoteStrategy.DIALECT_1);
    }

    private GeneratedKeysSupport.Query useReturningAllColumnsByName(FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        List<String> columnNames = this.getAllColumnNames(this.statementIdentification.getTableName(), databaseMetaData);
        QuoteStrategy quoteStrategy = QuoteStrategy.forDialect(databaseMetaData.getConnectionDialect());
        return this.addColumnsByNameImpl(columnNames, quoteStrategy);
    }

    private boolean hasReturning() {
        return this.statementIdentification != null && this.statementIdentification.returningClauseDetected();
    }

    GeneratedKeysSupport.Query forColumnsByIndex(int[] columnIndexes, FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.hasReturning()) {
            return new GeneratedKeysSupport.Query(true, this.originalSql);
        }
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw FbExceptionBuilder.forException(337248290).messageParameter((Object)"columnIndexes").toSQLException();
        }
        if (this.isSupportedType()) {
            List<String> columnNames = this.getColumnNames(this.statementIdentification.getTableName(), columnIndexes, databaseMetaData);
            QuoteStrategy quoteStrategy = QuoteStrategy.forDialect(databaseMetaData.getConnectionDialect());
            return this.addColumnsByNameImpl(columnNames, quoteStrategy);
        }
        return new GeneratedKeysSupport.Query(false, this.originalSql);
    }

    GeneratedKeysSupport.Query forColumnsByName(String[] columnNames) throws SQLException {
        if (this.hasReturning()) {
            return new GeneratedKeysSupport.Query(true, this.originalSql);
        }
        if (columnNames == null || columnNames.length == 0) {
            throw FbExceptionBuilder.forException(337248290).messageParameter((Object)"columnNames").toSQLException();
        }
        if (this.isSupportedType()) {
            return this.addColumnsByNameImpl(Arrays.asList(columnNames), QuoteStrategy.DIALECT_1);
        }
        return new GeneratedKeysSupport.Query(false, this.originalSql);
    }

    private GeneratedKeysSupport.Query addColumnsByNameImpl(List<String> columnNames, QuoteStrategy quoteStrategy) {
        assert (columnNames != null && !columnNames.isEmpty()) : "Column names are required";
        StringBuilder returningQuery = new StringBuilder(this.originalSql);
        for (int idx = returningQuery.length() - 1; idx >= 0; --idx) {
            char currentChar = returningQuery.charAt(idx);
            if (currentChar == ';') {
                returningQuery.setLength(idx);
                break;
            }
            if (Character.isWhitespace(currentChar)) continue;
            returningQuery.setLength(idx + 1);
            break;
        }
        returningQuery.append('\n').append("RETURNING ");
        for (String columnName : columnNames) {
            quoteStrategy.appendQuoted(columnName, returningQuery).append(',');
        }
        returningQuery.setLength(returningQuery.length() - 1);
        return new GeneratedKeysSupport.Query(true, returningQuery.toString());
    }

    private List<String> getAllColumnNames(String tableName, FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        try (ResultSet rs = databaseMetaData.getColumns(null, null, this.normalizeObjectName(tableName), null);){
            if (rs.next()) {
                ArrayList<String> columns = new ArrayList<String>();
                do {
                    columns.add(rs.getString(4));
                } while (rs.next());
                ArrayList<String> arrayList = columns;
                return arrayList;
            }
            throw FbExceptionBuilder.forException(337248292).messageParameter((Object)tableName).toSQLException();
        }
    }

    private List<String> getColumnNames(String tableName, int[] columnIndexes, FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        Map<Integer, String> columnByIndex = this.mapColumnNamesByIndex(tableName, columnIndexes, databaseMetaData);
        ArrayList<String> columns = new ArrayList<String>(columnIndexes.length);
        for (int indexToAdd : columnIndexes) {
            String columnName = columnByIndex.get(indexToAdd);
            if (columnName == null) {
                throw FbExceptionBuilder.forNonTransientException(337248291).messageParameter((Object)indexToAdd, (Object)tableName).toSQLException();
            }
            columns.add(columnName);
        }
        return columns;
    }

    private Map<Integer, String> mapColumnNamesByIndex(String tableName, int[] columnIndexes, FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        try (ResultSet rs = databaseMetaData.getColumns(null, null, this.normalizeObjectName(tableName), null);){
            if (!rs.next()) {
                throw FbExceptionBuilder.forNonTransientException(337248292).messageParameter((Object)tableName).toSQLException();
            }
            HashMap<Integer, String> columnByIndex = new HashMap<Integer, String>();
            int[] sortedIndexes = (int[])columnIndexes.clone();
            Arrays.sort(sortedIndexes);
            do {
                int columnPosition;
                if (Arrays.binarySearch(sortedIndexes, columnPosition = rs.getInt(17)) < 0) continue;
                columnByIndex.put(columnPosition, rs.getString(4));
            } while (rs.next());
            HashMap<Integer, String> hashMap = columnByIndex;
            return hashMap;
        }
    }

    private String normalizeObjectName(String objectName) {
        if (objectName == null) {
            return null;
        }
        objectName = objectName.trim();
        if ((objectName = MetadataPattern.escapeWildcards(objectName)).length() > 2 && objectName.charAt(0) == '\"' && objectName.charAt(objectName.length() - 1) == '\"') {
            return objectName.substring(1, objectName.length() - 1).replace("\"\"", "\"");
        }
        return objectName.toUpperCase(Locale.ROOT);
    }

    static {
        EnumMap<LocalStatementType, GeneratedKeysSupport.QueryType> temp = new EnumMap<LocalStatementType, GeneratedKeysSupport.QueryType>(LocalStatementType.class);
        temp.put(LocalStatementType.INSERT, GeneratedKeysSupport.QueryType.INSERT);
        temp.put(LocalStatementType.UPDATE, GeneratedKeysSupport.QueryType.UPDATE);
        temp.put(LocalStatementType.DELETE, GeneratedKeysSupport.QueryType.DELETE);
        temp.put(LocalStatementType.UPDATE_OR_INSERT, GeneratedKeysSupport.QueryType.UPDATE_OR_INSERT);
        temp.put(LocalStatementType.MERGE, GeneratedKeysSupport.QueryType.MERGE);
        statementTypeToQueryType = Collections.unmodifiableMap(temp);
    }
}

