/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.DimErrorHandler;
import dim.DimExitHandler;
import dim.Native;
import dim.Server;

public class DimServer {
    static {
        Native.loadNativeLibrary();
    }

    private DimServer() {
    }

    public static void start(String serverName) {
        Server.setServerName(serverName);
        Server.registerServices();
    }

    public static void start() {
        Server.registerServices();
    }

    public static void stop() {
        Server.stopServing();
    }

    public static String getClientName() {
        return Server.getClient();
    }

    public static int getClientId() {
        return Server.getClientConnID();
    }

    public static String[] getClientServices() {
        String[] services;
        String list = Server.getServices();
        if (list != null) {
            list = list.replace('\n', ',');
            services = list.split(",");
        } else {
            services = new String[]{};
        }
        return services;
    }

    public static native void disableAST();

    public static native void enableAST();

    public static void setDnsNode(String nodes, int port) {
        DimServer.setDnsPort(port);
        DimServer.setDnsNode(nodes);
    }

    public static native void setDnsNode(String var0);

    static native void setDnsPort(int var0);

    public static native String getDnsNode();

    public static native int getDnsPort();

    public static void addErrorHandler(DimErrorHandler handler) {
        DimErrorHandler.setSrvHandler(handler);
    }

    public static void addExitHandler(DimExitHandler handler) {
        DimExitHandler.setHandler(handler);
    }
}

