/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.CompletionHandler;
import dim.DataDecoder;
import dim.DataEncoder;
import dim.Memory;
import dim.Native;
import dim.SingleTaskCompletionSynchronizer;

public class Client {
    public static final int ONCE_ONLY = 1;
    public static final int TIMED = 2;
    public static final int MONITORED = 4;
    public static final int MONIT_ONLY = 32;
    public static final int UPDATE = 64;
    public static final int TIMED_ONLY = 128;
    public static final int MONIT_FIRST = 256;
    public static final int F_STAMPED = 4096;
    public static final int F_WAIT = 0x10000000;

    static {
        Native.loadNativeLibrary();
        Client.noPadding();
    }

    private Client() {
    }

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, boolean var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, char var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, byte var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, short var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, int var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, long var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, float var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, double var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, String var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, boolean[] var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, char[] var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, byte[] var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, short[] var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, int[] var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, long[] var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, float[] var4);

    public static native int send(String var0, CompletionHandler var1, int var2, int var3, double[] var4);

    private static native int send(String var0, CompletionHandler var1, int var2, int var3, long var4, int var6);

    public static int send(String name, CompletionHandler aCompletionHandler, int mode, int reserved, Memory theData) {
        return Client.send(name, aCompletionHandler, mode, reserved, theData.dataAddress, theData.highWaterMark);
    }

    public static int send(String name, CompletionHandler aCompletionHandler, int mode, int reserved, DataEncoder aNativeDataEncoder) {
        Memory theData = aNativeDataEncoder.encodeData();
        return Client.send(name, aCompletionHandler, mode, reserved, theData.dataAddress, theData.highWaterMark);
    }

    public static native int infoService(String var0, DataDecoder var1, int var2, int var3);

    public static native void releaseService(int var0);

    public static native void noPadding();

    public static native String getFormat(int var0);

    public static int setExitHandler(String serverName) {
        return Client.send(String.valueOf(serverName) + "/EXIT", null, 0, 0, 1);
    }

    public static native String getServer();

    public static native String getServices();

    public static native void stop();

    public static native int getServerConnID();

    public static native int getServerPID();

    private static class SendSynchronizer
    extends SingleTaskCompletionSynchronizer {
        CompletionHandler theCompletionHandler;

        SendSynchronizer(CompletionHandler aCompletionHandler) {
            this.theCompletionHandler = aCompletionHandler;
        }

        public int setCompletionCode(int theCompletionCode) {
            if (this.theCompletionHandler != null) {
                this.theCompletionHandler.setCompletionCode(theCompletionCode);
            }
            return super.setCompletionCode(theCompletionCode);
        }
    }

    private static class ReceiveSynchronizer
    extends SingleTaskCompletionSynchronizer
    implements DataDecoder {
        DataDecoder theNativeDataDecoder;

        ReceiveSynchronizer(DataDecoder aNativeDataDecoder) {
            this.theNativeDataDecoder = aNativeDataDecoder;
        }

        public void decodeData(Memory theData) {
            this.theNativeDataDecoder.decodeData(theData);
            int state = super.checkState();
            if ((state & 2) == 0) {
                this.setCompletionCode(1);
            }
        }
    }

    public static class Subscription {
        private int serviceId;

        public Subscription(String name, DataDecoder data, int mode, int timeout) {
            this.serviceId = Client.infoService(name, data, mode, timeout);
        }

        public void release() {
            Client.releaseService(this.serviceId);
        }
    }
}

