unit teststr;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes,
 _crw_alloc, _crw_fpu, _crw_str, _crw_utf8;

procedure Test_Str;
procedure Test_TText;

implementation

procedure readln;
begin
end;

procedure PrintLine(Index:LongInt; const TextLine:LongString; var Terminate:boolean; CustomData:Pointer);
begin
 writeln(Index:5,' - ',TextLine);
end;

procedure Test_TText;
var i,j:integer; s:shortstring;
 p:TText;
begin
 p:=newtext;
 p.text:='VarList'#13#10'One=1'#13#10' two = 2'#13#10' Three=3'#13#10'four=  4'#13#10'End'#13#10;
 p.write(output);
 writeln('ONE=',p.getvar('one'));
 writeln('TWO=',p.getvar('two'));
 writeln('THREE=',p.getvar('three'));
 writeln('FOUR=',p.getvar('four'));
 readln;
 p.setvar('one','10');
 p.setvar('two','20');
 p.setvar('three','30');
 p.setvar('four','40');
 p.write(output);
 writeln('ONE=',p.getvar('one'));
 writeln('TWO=',p.getvar('two'));
 writeln('THREE=',p.getvar('three'));
 writeln('FOUR=',p.getvar('four'));
 readln;
 p.setvar('one','');
 p.setvar('two','');
 p.setvar('three','');
 p.setvar('four','');
 p.write(output);
 writeln('ONE=',p.getvar('one'));
 writeln('TWO=',p.getvar('two'));
 writeln('THREE=',p.getvar('three'));
 writeln('FOUR=',p.getvar('four'));
 readln;
 kill(p);
 p.write(output);
 writeln('ONE=',p.getvar('one'));
 writeln('TWO=',p.getvar('two'));
 writeln('THREE=',p.getvar('three'));
 writeln('FOUR=',p.getvar('four'));

 s:='';        writeln(s:40,' ',adjuststrsize(s):10);
 s:='*';        writeln(s:40,' ',adjuststrsize(s):10);
 s:='**';        writeln(s:40,' ',adjuststrsize(s):10);
 s:='***';        writeln(s:40,' ',adjuststrsize(s):10);
 s:='****';        writeln(s:40,' ',adjuststrsize(s):10);
 s:='*****';        writeln(s:40,' ',adjuststrsize(s):10);
 s:='******';        writeln(s:40,' ',adjuststrsize(s):10);
 s:='*******';        writeln(s:40,' ',adjuststrsize(s):10);
 s:='********';        writeln(s:40,' ',adjuststrsize(s):10);
 readln;
 i:=0;  j:=1;  writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 i:=1;  j:=1;  writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 i:=2;  j:=1;  writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 i:=0;  j:=64; writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 i:=1;  j:=64; writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 i:=2;  j:=64; writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 i:=63; j:=64; writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 i:=64; j:=64; writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 i:=65; j:=64; writeln(i:10,' ',j:10,' ',adjustbuffersize(i,j):10);
 readln;
 
 writeln(GetAllocMemSize);
 p:=newtext;      p.foreach(printline,nil,false); readln; writeln(p.maxlength);
 p.addln('0');    p.foreach(printline,nil,false); readln;
 p.addln('1');    p.foreach(printline,nil,false); readln;
 p.addln('2');    p.foreach(printline,nil,false); readln;
 p.addln('3');    p.foreach(printline,nil,false); readln;
 p.addln('4');    p.foreach(printline,nil,false); readln;
 p[1]:=pad('x',30);       p.foreach(printline,nil,false); readln; writeln(p.maxlength);
 p.DelLn(3);      p.foreach(printline,nil,false); readln;
 p.insln(3,'y');  p.foreach(printline,nil,true ); readln;
 Kill(p);         p.foreach(printline,nil,false); readln;
 writeln(GetAllocMemSize);
 writeln('cap=',p.capacity:3,' cnt=',p.count:3); readln;
 p:=newtext;
 p.text:='Line1'#13#10'Line2'#13#10'Line3'#13#10'Line4'#13#10'Line5'#13#10'Line6';
 writeln(p.text);
 writeln(p.memused);
 writeln('cap=',p.capacity:3,' cnt=',p.count:3); readln;
 p.count:=20;
 writeln(p.text);
 writeln('cap=',p.capacity:3,' cnt=',p.count:3); readln;
 p.count:=4;
 writeln(p.text);
 writeln('cap=',p.capacity:3,' cnt=',p.count:3); readln;
 p.capacity:=200;
 writeln(p.text);
 writeln('cap=',p.capacity:3,' cnt=',p.count:3); readln;
 p.capacity:=2;
 writeln(p.text);
 writeln('cap=',p.capacity:3,' cnt=',p.count:3); readln;
 writeln(p.memused);
 Kill(p);
 p:=newtextread('template.txt');
 p.writefile('w.txt');
 for i:=0 to 100 do p.delln(random(p.count));
 for i:=0 to 100 do p.insln(random(p.count),pad('',60,'*'));
 for i:=0 to 100 do p[random(p.count)]:=pad('',random(60),'#');
 p.text:=p.text+p.text;
 for i:=0 to 100 do p[random(p.count)]:=pad('',random(60),'$');
 for i:=0 to 100 do p.delln(random(p.count));
 for i:=0 to 100 do p.insln(random(p.count),pad('',60,'*'));
 p.DosToWin;
 p.LoCase;
 p.writefile('x.txt');
 p.WinToDos;
 p.UpCase;
 p.Text:=ConvertCP(p.text,1251,CP_UTF8,0);
 p.write(Output);
 kill(p);
 writeln(p.text);
end;


procedure Test_Str;
var
 i,mem:integer; errors:int64; s,s1:shortstring; tmp:array[byte] of char;
 w:word; r:double; b:boolean;
 Data:packed record S:ShortString; D,H:LongInt; F:Double; C:Char end;
const
 dt=2000;
 w1=20;
 procedure PrintCaseTable;
 const n=24;
 var c:char; i:integer;
 begin
  writeln('************************');
  writeln('*** Print case table ***');
  writeln('************************');
  write('Press enter...'); readln;
  i:=0;
  for c:=low(c) to high(c) do begin
   if false and (locase(c)=c) and (upcase(c)=c) then continue;
   writeln(' ',ord(c):3,'  ',c,'  ',LoCase(c),'  ',UpCase(c));
   inc(i);
   if ord(i) mod n = 0 then begin
    write('Press enter...'); readln;
   end;
  end;
 end;
 procedure Testf2s(i,j:integer);
  procedure pr(i,j:integer; r:double);
  begin
   writeln('  ',format('%'+d2s(i)+'.'+d2s(j+1)+'G',[r]):30,'  ',f2s(r));
  end;
 begin
  f2sFormat(i,j);
  r:=_nan;       pr(i,j,r);
  r:=_plusinf;   pr(i,j,r);
  r:=_minusinf;  pr(i,j,r);
  r:=+0;         pr(i,j,r);
  r:=+1;         pr(i,j,r);
  r:=-1;         pr(i,j,r);
  r:=+1e3;       pr(i,j,r);
  r:=-1e3;       pr(i,j,r);
  r:=+1e6;       pr(i,j,r);
  r:=-1e6;       pr(i,j,r);
  r:=+1e-3;      pr(i,j,r);
  r:=-1e-3;      pr(i,j,r);
  r:=+1e-6;      pr(i,j,r);
  r:=-1e-6;      pr(i,j,r);
  r:=+pi*1e+20;  pr(i,j,r);
  r:=+pi*1e-20;  pr(i,j,r);
  r:=-pi*1e+20;  pr(i,j,r);
  r:=-pi*1e-20;  pr(i,j,r);
 end;
begin
 errors:=0;
 MEM:=GetAllocMemSize;
 writeln;
 writeln('********** test of _str unit ***************');
 writeln;

 writeln;
 writeln('NULL terminated strings test');
 writeln('****************************');
 write('Press enter...'); readln;
 writeln;
 writeln('function strcopy,strlen,strend,strecopy:');
 strcopy(strecopy(tmp,'this is '),'teststring');
 strcopy(strend(tmp),'++');
 writeln('  ',tmp,' ',strlen(tmp));
 strlcopy(tmp,tmp,strlen(tmp)-2);
 writeln;
 writeln('function strpcopy,strcat,strpcat:');
 writeln('  ',tmp,' ',strlen(tmp));
 strpcopy(tmp,'one');
 writeln(strpcat(strcat(strcat(tmp,' two'),' three'),' four'));
 writeln;
 writeln('function strcomp,stricomp,strlcomp:');
 writeln('  ',strcomp('000aBC','000abc'),' ',stricomp('000aBC','000abc'),' ',strlcomp('000aBC','000abc',3));
 writeln;
 writeln('function strscan,strrscan,strlower,strupper:');
 strcopy(tmp,abc_hex_table);
 writeln('  ',strscan(tmp,'4'),' ',strrscan(tmp,'6'));
 writeln('  ',strlower(strcopy(tmp,abc_RusDos_Lo+abc_RusDos_Up)));
 writeln('  ',strupper(strcopy(tmp,abc_RusDos_Lo+abc_RusDos_Up)));
 writeln;
 writeln('function strpos,strpas,strpass:');
 writeln('  ',strpas(strcopy(tmp,abc_hex_table)));
 writeln('  ',strpos(tmp,'456'));
 writeln('  ',strpass(tmp,['0'..'5']));
 writeln;
 strcat(strcat(strcat(strcat(strcopy(tmp,'  line1'),crlf),'  line2'),crlf),'  line3)');
 writeln(tmp,' have ',gettextnumlines(PChar(tmp)),' lines');
 writeln;

 writeln;
 writeln('String case conversion test');
 writeln('***************************');
 write('Press enter...'); readln;
 SetCaseTable_Default;
 PrintCaseTable;
 writeln;
 writeln('function Upcase:');
 writeln('  a -> ',Upcase('a')); if UpCase('a')<>'A' then inc(errors);
 writeln('  A -> ',Upcase('A')); if UpCase('A')<>'A' then inc(errors);
 writeln;
 writeln('function Locase:');
 writeln('  a -> ',Locase('a')); if LoCase('a')<>'a' then inc(errors);
 writeln('  A -> ',Locase('A')); if LoCase('A')<>'a' then inc(errors);
 writeln;
 writeln('function UpcaseStr:');
 writeln('  ',WinToDosStr(Abc_Eng_Up+Abc_Eng_Lo));
 writeln('  ',WinToDosStr(UpCaseStr(Abc_Eng_Up+Abc_Eng_Lo)));
 if UpCaseStr(Abc_Eng_Up+Abc_Eng_Lo)<>Abc_Eng_Up+Abc_Eng_Up then inc(errors);
 writeln('  ',WinToDosStr(Abc_RusWin_Up+Abc_RusWin_Lo));
 writeln('  ',WinToDosStr(UpCaseStr(Abc_RusWin_Up+Abc_RusWin_Lo)));
 if UpCaseStr(Abc_RusWin_Up+Abc_RusWin_Lo)<>Abc_RusWin_Up+Abc_RusWin_Up then inc(errors);
 writeln;
 writeln('function LocaseStr:');
 writeln('  ',WinToDosStr(Abc_Eng_Up+Abc_Eng_Lo));
 writeln('  ',WinToDosStr(LoCaseStr(Abc_Eng_Up+Abc_Eng_Lo)));
 if LoCaseStr(Abc_Eng_Up+Abc_Eng_Lo)<>Abc_Eng_Lo+Abc_Eng_Lo then inc(errors);
 writeln('  ',WinToDosStr(Abc_RusWin_Up+Abc_RusWin_Lo));
 writeln('  ',WinToDosStr(LoCaseStr(Abc_RusWin_Up+Abc_RusWin_Lo)));
 if LoCaseStr(Abc_RusWin_Up+Abc_RusWin_Lo)<>Abc_RusWin_Lo+Abc_RusWin_Lo then inc(errors);
 writeln;

 writeln;
 writeln('String codepage conversion test');
 writeln('*******************************');
 write('Press enter...'); readln;
 writeln;
 writeln('function WinToDos:');
 writeln('  ',Abc_RusWin);
 writeln('  ',WinToDosStr(Abc_RusWin));
 if WinToDosStr(Abc_RusWin)<>Abc_RusDos then inc(errors);
 writeln('function DosToWin:');
 writeln('  ',Abc_RusDos);
 writeln('  ',DosToWinStr(Abc_RusDos));
 if DosToWinStr(Abc_RusDos)<>Abc_RusWin then inc(errors);

 writeln;
 writeln('General purpose string manipulations');
 writeln('************************************');
 write('Press enter...'); readln;
 writeln;
 writeln('function CharSet2Str, Str2CharSet:');
 writeln('  ',Abc_Eng_Lo);
 writeln('  ',CharSet2Str(Str2CharSet(Abc_Eng_Lo)));
 if CharSet2Str(Str2CharSet(Abc_Eng_Lo))<>Abc_Eng_Lo then inc(errors);
 writeln;
 s:='0123456789';
 writeln('function LeftStr:');
 writeln('  ',s);
 writeln('  ',LeftStr(s,5));
 writeln;
 s:='0123456789';
 writeln('function RightStr:');
 writeln('  ',s);
 writeln('  ',RightStr(s,5));
 writeln;
 writeln('function CharStr,Pad,LeftPad:');
 writeln('  ',CharStr(25,'!'));
 writeln('  ',Pad('',25,'!'));
 writeln('  ',Pad(CharStr(25,'!'),10,'_'));
 writeln('  ',Pad(CharStr(25,'!'),30,'_'));
 writeln('  ',LeftPad(CharStr(25,'!'),10,'_'));
 writeln('  ',LeftPad(CharStr(25,'!'),30,'_'));
 writeln;
 writeln('function TrimLead,TrimTrail,Trim:');
 writeln('  ',TrimLeadChars(' !!!_lead_',['!',' ']),
              TrimTrailChars('_trail_??? ',['?',' ']),
              TrimChars(' !!!_trim_??? ',['!',' '],['?',' ']));
 writeln('  ',TrimLead('    _lead_'),
              TrimTrail('_trail_    '),
              Trim('    _trim_    '));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function ReplaceStr:');
 writeln;
 s:=' one cat, two cat, three cats ';
 writeln('  ',s,' -> ',ReplaceString(s,'cat','dog'));
 writeln;

 writeln;
 writeln('String word parsing');
 writeln('*******************');
 write('Press enter...'); readln;
 writeln;
 writeln('function WordCount:');
 s:='';
 writeln('  ',s,' -> ',WordCount(s,ScanSpaces));
 s:=' one two three ';
 writeln('  ',s,' -> ',WordCount(s,ScanSpaces));
 s:='one,two,three,four';
 writeln('  ',s,' -> ',WordCount(s,ScanSpaces));
 writeln;
 writeln('function ExtractWord,WordIndex:');
 s:='one,two,three,four';
 writeln('  ',s);
 writeln('  ',0,' ',ExtractWord(0,S,ScanSpaces),' ',WordIndex('',s,ScanSpaces));
 writeln('  ',1,' ',ExtractWord(1,S,ScanSpaces),' ',WordIndex('one',s,ScanSpaces));
 writeln('  ',2,' ',ExtractWord(2,S,ScanSpaces),' ',WordIndex('two',s,ScanSpaces));
 writeln('  ',3,' ',ExtractWord(3,S,ScanSpaces),' ',WordIndex('three',s,ScanSpaces));
 writeln('  ',4,' ',ExtractWord(4,S,ScanSpaces),' ',WordIndex('four',s,ScanSpaces));
 writeln('  ',5,' ',ExtractWord(5,S,ScanSpaces),' ',WordIndex('one','',ScanSpaces));
 writeln;
 writeln('function ExtractInt,ExtractReal:');
 s:=' 10 20 30 ';
 b:=extractint(1,s,ScanSpaces,i);
 writeln('  ',b,' ',i);
 b:=extractreal(2,s,ScanSpaces,r);
 writeln('  ',b,' ',r);
 writeln;
 writeln('function ScanVar:');
 strupper(strpcopy(tmp,'  Find:'+CRLF+
                       '  Var1 = StringVar2'+CRLF+
                       '  Var2 = 100'+CRLF+
                       '  Var3 = $0F'+CRLF+
                       '  Var4 = -3.14'+CRLF+
                       '  Var5 = &'));
 b:=ScanVar(svConfig,tmp,'Var1%a; Var2%d; Var3%d; Var4%f; Var5%c',Data)<>nil;
 if not b then inc(errors);
 writeln(tmp);
 writeln('  ScanVar = ',b,crlf,
         '  Var1 = ',Data.s,crlf,
         '  Var2 = ',Data.D,crlf,
         '  Var3 = ',Data.H,crlf,
         '  Var4 = ',Data.F,crlf,
         '  Var5 = ',Data.C);


 writeln;
 writeln('Numerical to string conversion test');
 writeln('***********************************');
 write('Press enter...'); readln;
 writeln;
 i:=1024*1024;
 r:=pi*1e3;
 writeln('function long2str,d2s,real2str:');
 writeln('  ',long2str(i));
 writeln('  ',real2str(r));
 writeln('  ',real2str(r,11,4));
 writeln('  >',d2s(i),'<');
 writeln('  >',d2s(i,10),'<');
 writeln('  >',d2s(i,-10),'<');
 writeln;
 writeln('BinB($12)=',BinB($12));
 writeln('BinW($1234)=',BinW($1234));
 writeln('BinL($12345678)=',BinL($12345678));
 writeln('OctB($12)=',OctB($12));
 writeln('OctW($1234)=',OctW($1234));
 writeln('OctL($12345678)=',OctL($12345678));
 writeln('HexB($12)=',HexB($12));
 writeln('HexW($1234)=',HexW($1234));
 writeln('HexL($12345678)=',HexL($12345678));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function f2s');
 writeln;
 Testf2s(20,14);
 writeln;
 write('Press enter...'); readln;
 writeln;
 Testf2s(0,4);
 writeln;
 write('Press enter...'); readln;
 writeln;
 Testf2s(10,4);
 writeln;
 write('Press enter...'); readln;
 writeln;
 Testf2s(-10,4);

 writeln;
 writeln('String to Numerical conversion test');
 writeln('***********************************');
 write('Press enter...'); readln;
 writeln;
 writeln('function atoi:');
 strcopy(tmp,'-123');       b:=atoi(tmp,i);  writeln('  ',tmp,' ',b,'  ',i);
 strcopy(tmp,'$F');         b:=atoi(tmp,i);  writeln('  ',tmp,' ',b,' $',hexl(i));
 strcopy(tmp,'$12345678');  b:=atoi(tmp,i);  writeln('  ',tmp,' ',b,' $',hexl(i));
 strcopy(tmp,'$');          b:=atoi(tmp,i);  writeln('  ',tmp,' ',b,' $',hexl(i));
 strcopy(tmp,'$1234567x');  b:=atoi(tmp,i);  writeln('  ',tmp,' ',b,' $',hexl(i));
 strcopy(tmp,'$123456789'); b:=atoi(tmp,i);  writeln('  ',tmp,' ',b,' $',hexl(i));
 strcopy(tmp,'-123');       b:=atof(tmp,r);  writeln('  ',tmp,' ',b,'  ',r);
 strcopy(tmp,'$12345678');  b:=atof(tmp,r);  writeln('  ',tmp,' ',b,' $',hexl(round(r)));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function Str2Int,Str2Word,Str2Long,Str2Real:');
 s:=' 65535x';  b:=Str2Int(s,i);     writeln('  ',s,' ',b,' ',i);
 s:=' 65534 ';  b:=Str2Int(s,i);     writeln('  ',s,' ',b,' ',i);
 s:=' 65533x';  b:=Str2Word(s,w);    writeln('  ',s,' ',b,' ',w);
 s:=' 65532 ';  b:=Str2Word(s,w);    writeln('  ',s,' ',b,' ',w);
 s:=' 65531x';  b:=Str2Long(s,i);    writeln('  ',s,' ',b,' ',i);
 s:=' 65530 ';  b:=Str2Long(s,i);    writeln('  ',s,' ',b,' ',i);
 s:=' 3.142x';  b:=Str2Real(s,r);    writeln('  ',s,' ',b,' ',r);
 s:=' 3.142 ';  b:=Str2Real(s,r);    writeln('  ',s,' ',b,' ',r);
 writeln;
 writeln('function StrHex2Long,StrOct2Long,StrBin2Long:');
 s:=' 89ABCDEFF'; b:=StrHex2Long(s,i); writeln('  ',s,' ',b,' ',HexL(i));
 s:=' 89ABCDEF '; b:=StrHex2Long(s,i); writeln('  ',s,' ',b,' ',HexL(i));
 s:=' 7654321x '; b:=StrOct2Long(s,i); writeln('  ',s,' ',b,' ',OctL(i));
 s:=' 76543210 '; b:=StrOct2Long(s,i); writeln('  ',s,' ',b,' ',OctL(i));
 s:=' 1110011x '; b:=StrBin2Long(s,i); writeln('  ',s,' ',b,' ',BinL(i));
 s:=' 11100111 '; b:=StrBin2Long(s,i); writeln('  ',s,' ',b,' ',BinL(i));
 s:=' ';          b:=StrBin2Long(s,i); writeln('  ',s,' ',b,' ',BinL(i));
 s:=' 1 1 '; b:=StrBin2Long(s,i); writeln('  ',s,' ',b,' ',BinL(i));
 s:='10101010101010101010101010101010'; b:=StrBin2Long(s,i); writeln('  ',s,' ',b,' ',BinL(i));
 s:=' 1 '; b:=StrBin2Long(s,i); writeln('  ',s,' ',b,' ',BinL(i));
 writeln;
 write('Press enter...'); readln;
 writeln;
(*
*)

 writeln;
 writeln('Filename parsing test');
 writeln('*********************');
 write('Press enter...'); readln;
 writeln;
 writeln('function IsEmptyStr');
 writeln;
 s:='';            writeln('  ',s:w1,' ',IsEmptyStr(s));
 s:='   ';         writeln('  ',s:w1,' ',IsEmptyStr(s));
 s:=' s ';         writeln('  ',s:w1,' ',IsEmptyStr(s));
 writeln;
 writeln('function LastDelimiter');
 writeln;
 s:='c:';          writeln('  ',s:w1,' ',LastDelimiter(['.'],s));
 s:='c:\x.y\z.w';  writeln('  ',s:w1,' ',LastDelimiter(['.'],s));
 s:='c:\x.y\z_w';  writeln('  ',s:w1,' ',LastDelimiter(['.'],s));
 writeln;
 writeln('function AddBackSlash');
 writeln;
 s:=' c: ';        writeln('  ',s:w1,' ',addbackslash(s));
 s:=' c:\';        writeln('  ',s:w1,' ',addbackslash(s));
 s:='c:\name';     writeln('  ',s:w1,' ',addbackslash(s));
 s:='c:\name\';    writeln('  ',s:w1,' ',addbackslash(s));
 s:='';            writeln('  ',s:w1,' ',addbackslash(s));
 s:='\';           writeln('  ',s:w1,' ',addbackslash(s));
 s:='.';           writeln('  ',s:w1,' ',addbackslash(s));
 s:='..';          writeln('  ',s:w1,' ',addbackslash(s));
 s:='.\';          writeln('  ',s:w1,' ',addbackslash(s));
 s:='..\';         writeln('  ',s:w1,' ',addbackslash(s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function DropBackSlash');
 writeln;
 s:=' c: ';        writeln('  ',s:w1,' ',dropbackslash(s));
 s:=' c:\';        writeln('  ',s:w1,' ',dropbackslash(s));
 s:='c:\name';     writeln('  ',s:w1,' ',dropbackslash(s));
 s:='c:\name\';    writeln('  ',s:w1,' ',dropbackslash(s));
 s:='';            writeln('  ',s:w1,' ',dropbackslash(s));
 s:='\';           writeln('  ',s:w1,' ',dropbackslash(s));
 s:='.';           writeln('  ',s:w1,' ',dropbackslash(s));
 s:='..';          writeln('  ',s:w1,' ',dropbackslash(s));
 s:='.\';          writeln('  ',s:w1,' ',dropbackslash(s));
 s:='..\';         writeln('  ',s:w1,' ',dropbackslash(s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function IsWildCard');
 s:='';            writeln('  ',s:w1,' ',iswildcard(s));
 s:='c:\xx\*.ext'; writeln('  ',s:w1,' ',iswildcard(s));
 s:='c:\xx\?.ext'; writeln('  ',s:w1,' ',iswildcard(s));
 s:='c:\xx\y.ext'; writeln('  ',s:w1,' ',iswildcard(s));
 writeln;
 writeln('function IsRelativePath:');
 writeln;
 s:='';                       writeln('  ',s:w1,' ',IsRelativePath(s));
 s:=' \\alex\postbox\x.doc '; writeln('  ',s:w1,' ',IsRelativePath(s));
 s:='alex\postbox\x.doc';     writeln('  ',s:w1,' ',IsRelativePath(s));
 s:='c:alex\postbox\x.doc';   writeln('  ',s:w1,' ',IsRelativePath(s));
 s:='..\alex\postbox\x.doc';  writeln('  ',s:w1,' ',IsRelativePath(s));
 s:='x.doc';                  writeln('  ',s:w1,' ',IsRelativePath(s));
 writeln;
 writeln('function HasExtension');
 s:='postbox\x.docum';        writeln('  ',s:w1,' ',HasExtension(s));
 s:='postbox\x_docum';        writeln('  ',s:w1,' ',HasExtension(s));
 s:='postbox.x\docum';        writeln('  ',s:w1,' ',HasExtension(s));
 s:='postbox\.doc';           writeln('  ',s:w1,' ',HasExtension(s));
 s:='postbox\.';              writeln('  ',s:w1,' ',HasExtension(s));
 s:='postbox\..';             writeln('  ',s:w1,' ',HasExtension(s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function DefaultExtension');
 s:='alex.x\doc.temp'; writeln('  ',s:w1,' ',DefaultExtension(s,'.kumac'));
 s:='alex.x\doc_temp'; writeln('  ',s:w1,' ',DefaultExtension(s,'.kumac'));
 s:='alex.x\doc.temp'; writeln('  ',s:w1,' ',DefaultExtension(s,'kumac'));
 s:='alex.x\doc_temp'; writeln('  ',s:w1,' ',DefaultExtension(s,'kumac'));
 writeln;
 writeln('function DefaultPath');
 s:='\\alex\postbox\x.doc';   writeln('  ',s:w1,' ',DefaultPath(s,'c:\paslib'));
 s:='alex\postbox\x.doc';     writeln('  ',s:w1,' ',DefaultPath(s,'c:\paslib\'));
 s:='c:alex\postbox\x.doc';   writeln('  ',s:w1,' ',DefaultPath(s,'c:\paslib'));
 s:='..\alex\postbox\x.doc';  writeln('  ',s:w1,' ',DefaultPath(s,'c:\paslib'));
 s:='x.doc';                  writeln('  ',s:w1,' ',DefaultPath(s,'c:\paslib\'));
 s:=defaultpath('alex\postbox\x.doc','c:\paslib'); writeln(s);
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function ForceExtension');
 s:='alex.x\doc.temp'; writeln('  ',s:w1,' ',ForceExtension(s,'.kumac'));
 s:='alex.x\doc_temp'; writeln('  ',s:w1,' ',ForceExtension(s,'.kumac'));
 s:='alex.x\doc.temp'; writeln('  ',s:w1,' ',ForceExtension(s,'kumac'));
 s:='alex.x\doc_temp'; writeln('  ',s:w1,' ',ForceExtension(s,'kumac'));
 writeln;
 writeln('function ForcePath');
 writeln;
 s:='\\alex\postbox\x.doc';   writeln('  ',s:w1,' ',ForcePath('c:\paslib',s));
 s:='alex\postbox\x.doc';     writeln('  ',s:w1,' ',ForcePath('c:\paslib',s));
 s:='c:alex\postbox\x.doc';   writeln('  ',s:w1,' ',ForcePath('c:\paslib',s));
 s:='..\alex\postbox\x.doc';  writeln('  ',s:w1,' ',ForcePath('c:\paslib',s));
 s:='x.doc';                  writeln('  ',s:w1,' ',ForcePath('c:\paslib',s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function ExtractFileNameExt:');
 writeln;
 s:='';                        writeln('  ',s:w1,' ',ExtractFileNameExt(s));
 s:='cx';                      writeln('  ',s:w1,' ',ExtractFileNameExt(s));
 s:='c:x';                     writeln('  ',s:w1,' ',ExtractFileNameExt(s));
 s:='c:\x';                    writeln('  ',s:w1,' ',ExtractFileNameExt(s));
 s:='c:\post\box.zip\.';       writeln('  ',s:w1,' ',ExtractFileNameExt(s));
 s:='c:\post\box.zip\..';      writeln('  ',s:w1,' ',ExtractFileNameExt(s));
 s:='\\alex\post\box\x.docum'; writeln('  ',s:w1,' ',ExtractFileNameExt(s));
 s:='c:\post\box.zip\xum.doc'; writeln('  ',s:w1,' ',ExtractFileNameExt(s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function ExtractFileName:');
 writeln;
 s:='';                        writeln('  ',s:w1,' ',ExtractFileName(s));
 s:='cx';                      writeln('  ',s:w1,' ',ExtractFileName(s));
 s:='c:x';                     writeln('  ',s:w1,' ',ExtractFileName(s));
 s:='c:\x';                    writeln('  ',s:w1,' ',ExtractFileName(s));
 s:='c:\post\box.zip\.';       writeln('  ',s:w1,' ',ExtractFileName(s));
 s:='c:\post\box.zip\..';      writeln('  ',s:w1,' ',ExtractFileName(s));
 s:='\\alex\post\box\x.docum'; writeln('  ',s:w1,' ',ExtractFileName(s));
 s:='c:\post\box.zip\xum.doc'; writeln('  ',s:w1,' ',ExtractFileName(s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function ExtractFileExt:');
 writeln;
 s:='';                        writeln('  ',s:w1,' ',ExtractFileExt(s));
 s:='cx';                      writeln('  ',s:w1,' ',ExtractFileExt(s));
 s:='c:x';                     writeln('  ',s:w1,' ',ExtractFileExt(s));
 s:='c:\x';                    writeln('  ',s:w1,' ',ExtractFileExt(s));
 s:='c:\post\box.zip\.';       writeln('  ',s:w1,' ',ExtractFileExt(s));
 s:='c:\post\box.zip\..';      writeln('  ',s:w1,' ',ExtractFileExt(s));
 s:='\\alex\post\box\x.docum'; writeln('  ',s:w1,' ',ExtractFileExt(s));
 s:='c:\post\box.zip\xum.doc'; writeln('  ',s:w1,' ',ExtractFileExt(s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function ExtractFilePath:');
 writeln;
 s:='';                        writeln('  ',s:w1,' ',ExtractFilePath(s));
 s:='cx';                      writeln('  ',s:w1,' ',ExtractFilePath(s));
 s:='c:x';                     writeln('  ',s:w1,' ',ExtractFilePath(s));
 s:='c:\x';                    writeln('  ',s:w1,' ',ExtractFilePath(s));
 s:='c:\post\box.zip\.';       writeln('  ',s:w1,' ',ExtractFilePath(s));
 s:='c:\post\box.zip\..';      writeln('  ',s:w1,' ',ExtractFilePath(s));
 s:='\\alex\post\box\x.docum'; writeln('  ',s:w1,' ',ExtractFilePath(s));
 s:='c:\post\box.zip\xum.doc'; writeln('  ',s:w1,' ',ExtractFilePath(s));
 writeln;
 writeln('function ExtractFileDrive:');
 writeln;
 s:='';                         writeln('  ',s:w1,' ',ExtractFileDrive(s));
 s:='\bp\bin';                  writeln('  ',s:w1,' ',ExtractFileDrive(s));
 s:='c:\bp\bin';                writeln('  ',s:w1,' ',ExtractFileDrive(s));
 s:='\\alex\bp\bin';            writeln('  ',s:w1,' ',ExtractFileDrive(s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function FExpand:');
 writeln;
 s:='';                        writeln('  ',s:w1,' ',FExpand(s));
 s:='cx';                      writeln('  ',s:w1,' ',FExpand(s));
 s:='c:x';                     writeln('  ',s:w1,' ',FExpand(s));
 s:='c:\x';                    writeln('  ',s:w1,' ',FExpand(s));
 s:='c:\post\box.zip\.\x.doc'; writeln('  ',s:w1,' ',FExpand(s));
 s:='c:\post\box.zip\..\x.do'; writeln('  ',s:w1,' ',FExpand(s));
 s:='\\alex\post\box\x.docum'; writeln('  ',s:w1,' ',FExpand(s));
 s:='c:\post\box.zip\xum.doc'; writeln('  ',s:w1,' ',FExpand(s));
 writeln;
 write('Press enter...'); readln;
 writeln;
 writeln('function MakeRelativePath:');  setcasetable_ruswin;
 writeln;
 s1:=' c:\bp\rtl\doc\*.* ';
 s:='  c:\bp\rtl\bin\bpc.exe';   writeln('  ',s:w1,' ',s1:w1,' ',MakeRelativePath(s,s1));
 s1:=' c:\бп\ртл\док\*.* ';
 s:='  c:\БП\ртл\bin\bpc.exe';   writeln('  ',WinToDosStr(s):w1,' ',WinToDosStr(s1):w1,' ',WinToDosStr(MakeRelativePath(s,s1)));
 writeln;
 write('Press enter...'); readln;
 writeln;

 MEM:=GetAllocMemSize-MEM;
 if MEM<>0
 then writeln('Memory leak ',MEM)
 else writeln('Memory leak not found.');
 writeln('ERRORS:',errors);
 writeln;
 writeln('********** end of test *************************');
 writeln;
end;

end.
