#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## CRW-DAQ script to build crwlib help.                  ##
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

readonly logfile="$scriptHOME/$scriptbase.log";
readonly cssfile="$scriptHOME/fpdoc.css";

declare input_pas="";
readonly fpcupdir="/opt/daqgroup/development/tools/fpcupdeluxe";
readonly fpdocget="$(find $fpcupdir -type f -executable -name fpdoc | sort | head -n 1)";
readonly fpdocdef="/opt/daqgroup/development/tools/fpcupdeluxe/fpc/bin/x86_64-linux/fpdoc";
readonly fpdoc="${fpdocget:-$fpdocdef}";
readonly makeskelget="$(find $fpcupdir -type f -executable -name makeskel | sort | head -n 1)";
readonly makeskeldef="/opt/daqgroup/development/tools/fpcupdeluxe/fpc/bin/x86_64-linux/makeskel";
readonly makeskel="${makeskelget:-$makeskeldef}";

function check_fpdoc(){
 if [ -x "$fpdoc" ]; then echo "Found fpdoc: $fpdoc"; else  fatal 1 "Error: fpdoc is not found."; fi;
 if [ -x "$makeskel" ]; then echo "Found makeskel: $makeskel"; else  fatal 1 "Error: makeskel is not found."; fi;
};

eval check_fpdoc;

function call(){
 echo "$@";
 eval "$@";
};

function call_fpdoc(){
 local options="--content";
 options+=" --auto-toc";
 options+=" --auto-index";
 options+=" --charset=UTF8";
 options+=" --make-searchable";
 options+=" --css-file=$cssfile";
 call $fpdoc --package=crwlib --format=chm  $options "$@";
 call $fpdoc --package=crwlib --format=html $options "$@";
};

function skip_this(){
 if [ -z "$(cat $1 | grep -P '^\s*implementation\b')" ]; then return 0; fi;
 if [ -n "$(echo $1 | grep -i '_crw_xxxx.pas')" ]; then return 0; fi;
 if [ -n "$(echo $1 | grep -i '_crw_copy.inc')" ]; then return 0; fi;
 if [ -n "$(echo $1 | grep -i 'mormot.core')" ]; then return 0; fi;
 return 1;
 if [ -z "$(cat $1 | grep '{$I _crw_uses_first.inc}')" ]; then return 0; fi;   
};

function doit(){
 echo "$(date +%Y.%m.%d-%H:%M:%S) => $scriptname: Start …"
 echo;
 local crwlib_dir="$(realpath $scriptHOME/..)"
 if pushd $crwlib_dir; then
  for item in crwlib manual crwlib.chm; do
   if [ -f "$item" ]; then rm -fv  ./$item; fi;
   if [ -d "$item" ]; then rm -rfv ./$item; fi;
  done;
  for pas in $(find $PWD -type f -name '*.pas'); do
   if skip_this $pas; then continue; fi;   
   input_pas+=" --input=$pas";
  done;
  call_fpdoc $input_pas;
  mv -fv crwlib manual;
  cp -fv script/fpdoc.css manual/;
 fi;
 popd;
 echo;
 echo "$(date +%Y.%m.%d-%H:%M:%S) => $scriptname: Done."
 echo;
};

################
# main function.
################
function main(){
 rm -f $logfile; touch $logfile;
 doit "$@" 2>&1 | tee -a $logfile;
 unix wintail $logfile;
};

main "$@";

#############
# END OF FILE
#############
