////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Severity levels.                                                           //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20250828 - Created by A.K.                                                 //
////////////////////////////////////////////////////////////////////////////////

unit _crw_sever; //  Severity levels

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math,
 _crw_alloc, _crw_str, _crw_fio, _crw_syslog,
 _crw_daqsys;

procedure InitKnownSeverityLevels;
function LoadKnownSeverityLevels:Integer;
function ReadKnownSeverityFromBuff(Buff:LongString):Integer;

implementation

procedure InitKnownSeverityLevels;
begin
 SeverityOfEchoBugs    := sev_Print;
 SeverityOfSoftBugs    := sev_Notify;
 SeverityOfHarmBugs    := sev_Exception;
 SeverityOfWatchdog    := sev_Watchdog;
 SeverityOfMistimes    := sev_Mistimes;
 SeverityOfDaqPrint    := sev_Notify;
 SeverityOfSysPrint    := sev_Print;
 SeverityOfSysInput    := sev_Input;
 SeverityOfSysVoice    := sev_Voice;
 SeverityOfTooltips    := sev_Tooltip;
 SeverityOfSysLogin    := sev_Notify;
 SeverityOfXLibBugs    := sev_Fail;
 SeverityOfXLibFail    := sev_Failure;
 SeverityOfDaqWatchdog := sev_Watchdog;
 SeverityOfDaqRunError := sev_Crash;
 SeverityOfDaqCompiler := sev_Trouble;
end;

function LoadKnownSeverityLevels:Integer;
var Buff:LongString;
begin
 Result:=0;
 Buff:=ExtractTextSection(SysIniFile,'[System.Syslog.Severity.Settings]',efConfigNC);
 if IsNonEmptyStr(Buff) then Inc(Result,ReadKnownSeverityFromBuff(Buff));
end;

function ReadKnownSeverityFromBuff(Buff:LongString):Integer;
 procedure Scan(var severity:Integer; const key:LongString);
 var sv:LongString; sl:Integer;
 begin
  if IsNonEmptyStr(key) then begin
   sv:=CookieScan(Buff,key,Ord(';'));
   if IsNonEmptyStr(sv) then begin
    sl:=SysLog.StringToSeverity(sv,-1);
    if InRange(sl,sev_MIN,sev_MAX) then begin
     severity:=sl; Inc(Result);
    end;
   end;
  end;
 end;
begin
 Result:=0; if (Buff='') then Exit;
 Scan( SeverityOfEchoBugs    , 'SeverityOfEchoBugs'    );
 Scan( SeverityOfSoftBugs    , 'SeverityOfSoftBugs'    );
 Scan( SeverityOfHarmBugs    , 'SeverityOfHarmBugs'    );
 Scan( SeverityOfWatchdog    , 'SeverityOfWatchdog'    );
 Scan( SeverityOfMistimes    , 'SeverityOfMistimes'    );
 Scan( SeverityOfDaqPrint    , 'SeverityOfDaqPrint'    );
 Scan( SeverityOfSysPrint    , 'SeverityOfSysPrint'    );
 Scan( SeverityOfSysInput    , 'SeverityOfSysInput'    );
 Scan( SeverityOfSysVoice    , 'SeverityOfSysVoice'    );
 Scan( SeverityOfTooltips    , 'SeverityOfTooltips'    );
 Scan( SeverityOfSysLogin    , 'SeverityOfSysLogin'    );
 Scan( SeverityOfXLibBugs    , 'SeverityOfXLibBugs'    );
 Scan( SeverityOfXLibFail    , 'SeverityOfXLibFail'    );
 Scan( SeverityOfDaqWatchdog , 'SeverityOfDaqWatchdog' );
 Scan( SeverityOfDaqRunError , 'SeverityOfDaqRunError' );
 Scan( SeverityOfDaqCompiler , 'SeverityOfDaqCompiler' );
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_crw_sever;
begin
end;

procedure Free_crw_sever;
begin
end;

initialization

 Init_crw_sever;

finalization

 Free_crw_sever;

end.

//////////////
// END OF FILE
//////////////

