#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

########################
# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname $scriptFILE)";

function note(){ return; };

function rm_linkres(){
 for f in $(find $PWD -type f -name 'link*.res'); do
  rm -fv $f;
 done;
};

function update_copy_sh(){
 local dir="$PWD/crwkit/add/src/suite_sh";
 if [ -d "$dir" ]; then
  cp -fuv $PWD/pack-daqgroup-*.sh $dir/;
  cp -fuv $PWD/check-daqgroup-*.sh $dir/;
  cp -fuv $PWD/clear-daqgroup-*.sh $dir/;
  cp -fuv $PWD/release-daqgroup-*.sh $dir/;
 fi;
};

function pack_daqgroup_suite_all(){
 if [ -z "$XZ_OPT" ]; then export XZ_OPT="-9 -T4"; fi;
 $PWD/pack-daqgroup-crwdaq.sh;
 $PWD/pack-daqgroup-crwkit.sh;
 $PWD/pack-daqgroup-crwlib.sh;
 $PWD/pack-daqgroup-suite.sh;
 echo -e "\n$(date +%Y.%m.%d-%H:%M:%S) - $scriptname done.\n";
};

function confirm_execution(){
 local ask="Hello, $USER.";
 ask="$ask\nDo you want to run the script:";
 ask="$ask\n\n<big><b><span fgcolor='green'>$scriptname</span></b>?</big>";
 ask="$ask\n\n<b><span fgcolor='blue'>Confirm</span>?</b>";
 if zenity --question --text "$ask" --timeout 180 >/dev/null 2>&1; then
  note "Run $scriptname …";
 else
  echo -ne "\n\nUser Cancel.\n\n";
  exit 0;
 fi;
};

function main(){
 confirm_execution;
 if pushd $scriptHOME >/dev/null 2>&1; then
  rm -f                               $scriptHOME/$scriptbase.log;
  rm_linkres                 | tee -a $scriptHOME/$scriptbase.log;
  update_copy_sh             | tee -a $scriptHOME/$scriptbase.log;
  pack_daqgroup_suite_all    | tee -a $scriptHOME/$scriptbase.log;
  unix grun wintail                   $scriptHOME/$scriptbase.log;
 fi;
 popd >/dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
