////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr Zon Fit Control.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231206 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrzonfitcontrol; // Form Spectr Zon Fit Control

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Spin,
 lcltype, lclintf, Grids,
 Form_SpectrZonFitWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm,
 _crw_curves, _crw_riff, _crw_calib,
 _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormSpectrZonFitControl }

  TFormSpectrZonFitControl = class(TMasterForm)
    PageControl: TPageControl;
    TabSheetRoi: TTabSheet;
    TabSheetZone: TTabSheet;
    TabSheetPeak: TTabSheet;    
    PanelCommon: TPanel;
    BitBtnClose: TBitBtn;
    BitBtnUndo: TBitBtn;
    ButtonRoiPeakIn: TButton;
    BitBtnHome: TBitBtn;
    ButtonRoiFit: TButton;
    ButtonZonFit: TButton;
    ButtonZonPeakIn: TButton;
    ButtonRoiNew: TButton;
    ButtonRoiSave: TButton;
    ButtonRoiLoad: TButton;
    ButtonRoiClear: TButton;
    ButtonZonePrev: TButton;
    ButtonZoneNext: TButton;
    LabelZoneMove: TLabel;
    ButtonPeakPrev: TButton;
    ButtonPeakNext: TButton;
    LabelPeakMove: TLabel;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ButtonZonNew: TButton;
    ButtonZonClear: TButton;
    ButtonZonDelete: TButton;
    ButtonZonMerge: TButton;
    ButtonRoiBugs: TButton;
    ButtonZonGround: TButton;
    ButtonZonLimits: TButton;
    ButtonPeakInsert: TButton;
    ButtonPeakDelete: TButton;
    ButtonPeakEdit: TButton;
    ButtonRoiCallRfa: TButton;
    ButtonZonCov: TButton;
    ButtonZonBugs: TButton;
    ButtonPeakInPreset: TButton;
    ButtonFitPreset: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonZonePrevClick(Sender: TObject);
    procedure ButtonZoneNextClick(Sender: TObject);
    procedure ButtonPeakPrevClick(Sender: TObject);
    procedure ButtonPeakNextClick(Sender: TObject);
    procedure BitBtnHomeClick(Sender: TObject);
    procedure BitBtnUndoClick(Sender: TObject);
    procedure ButtonRoiNewClick(Sender: TObject);
    procedure ButtonRoiPeakInClick(Sender: TObject);
    procedure ButtonRoiClearClick(Sender: TObject);
    procedure ButtonRoiFitClick(Sender: TObject);
    procedure ButtonRoiLoadClick(Sender: TObject);
    procedure ButtonRoiSaveClick(Sender: TObject);
    procedure ButtonRoiBugsClick(Sender: TObject);
    procedure ButtonRoiCallRfaClick(Sender: TObject);
    procedure ButtonZonNewClick(Sender: TObject);
    procedure ButtonZonPeakInClick(Sender: TObject);
    procedure ButtonZonClearClick(Sender: TObject);
    procedure ButtonZonFitClick(Sender: TObject);
    procedure ButtonZonDeleteClick(Sender: TObject);
    procedure ButtonZonLimitsClick(Sender: TObject);
    procedure ButtonZonMergeClick(Sender: TObject);
    procedure ButtonZonGroundClick(Sender: TObject);
    procedure ButtonZonCovClick(Sender: TObject);
    procedure ButtonZonBugsClick(Sender: TObject);
    procedure ButtonPeakInsertClick(Sender: TObject);
    procedure ButtonPeakDeleteClick(Sender: TObject);
    procedure ButtonPeakEditClick(Sender: TObject);
    procedure ButtonPeakInPresetClick(Sender: TObject);
    procedure ButtonFitPresetClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Win : TFormSpectrZonFitWindow;
    procedure UpdateControls(Flags:Integer);
  end;

procedure OpenFormSpectrZonFitControl(Win:TFormSpectrZonFitWindow);

implementation

{$R *.lfm}

procedure OpenFormSpectrZonFitControl(Win:TFormSpectrZonFitWindow);
begin
 if (Win is TFormSpectrZonFitWindow) then
 try
  Application.CreateForm(TFormSpectrZonFitControl, Win.ZonFit.Control);
  (Win.ZonFit.Control as TFormSpectrZonFitControl).Win:=Win;
  Win.ZonFit.Control.Master:=@Win.ZonFit.Control;
  (Win.ZonFit.Control as TFormSpectrZonFitControl).UpdateControls(ucUpdate+ucShow+ucHome);
  Win.ZonFit.Control.Caption:=Format('Fit - [%s]',[Win.Caption]);
 except
  on E:Exception do BugReport(E,nil,'OpenFormSpectrZonFitControl');
 end;
end;

procedure TFormSpectrZonFitControl.UpdateControls(Flags:Integer);
begin
 if Ok then
 if Win.Ok then
 try
  if HasFlags(Flags,ucUpdate) then begin
   Win.ZonFit.Roi.UpdateUndoState;
  end;
  if HasFlags(Flags,ucClick) then begin
  end;
  if HasFlags(Flags,ucMarker) then begin
  end;
  if HasFlags(Flags,ucHome) then begin
   Top:=120;
   Left:=0;
  end;
  if HasFlags(Flags,ucShow) then begin
   Show;
   BringToFront;
   WindowState:=wsNormal;
  end;
  if HasFlags(Flags,ucHide) then begin
   Hide;
  end;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TFormSpectrZonFitControl.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 OpenDialog.Title:=RusEng('Загрузить *.pik файл','Load *.pik file');
 SaveDialog.Title:=RusEng('Сохранить *.pik файл','Save *.pik file');
 PageControl.PageIndex:=0;
end;

procedure TFormSpectrZonFitControl.FormClose(Sender: TObject;  var Action: TCloseAction);
begin
 if Ok and Win.Ok then Win.UpdateControls(ucHide);
end;

procedure TFormSpectrZonFitControl.ButtonZonePrevClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.ZonePrev;
end;

procedure TFormSpectrZonFitControl.ButtonZoneNextClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.ZoneNext;
end;

procedure TFormSpectrZonFitControl.ButtonPeakPrevClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.PeakPrev;
end;

procedure TFormSpectrZonFitControl.ButtonPeakNextClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.PeakNext;
end;

procedure TFormSpectrZonFitControl.BitBtnHomeClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.UpdateControls(ucUpdate+ucMarker+ucShow+ucHome);
end;

procedure TFormSpectrZonFitControl.BitBtnUndoClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.Undo;
end;

procedure TFormSpectrZonFitControl.ButtonRoiNewClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.RoiNew;
end;

procedure TFormSpectrZonFitControl.ButtonRoiPeakInClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.RoiPeakIn;
end;

procedure TFormSpectrZonFitControl.ButtonRoiClearClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.RoiClear;
end;

procedure TFormSpectrZonFitControl.ButtonRoiFitClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.RoiFit;
end;

procedure TFormSpectrZonFitControl.ButtonRoiLoadClick(Sender: TObject);
begin
 if Ok and Win.Ok then
 if GuardOpenDialog(OpenDialog).Execute then Win.ZonFit.Roi.LoadFrom(OpenDialog.FileName);
end;

procedure TFormSpectrZonFitControl.ButtonRoiSaveClick(Sender: TObject);
begin
 if Ok and Win.Ok then
 if GuardOpenDialog(SaveDialog).Execute then Win.ZonFit.Roi.SaveTo(SaveDialog.FileName);
end;

procedure TFormSpectrZonFitControl.ButtonRoiBugsClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.RemoveRoiBugs;
end;

procedure TFormSpectrZonFitControl.ButtonRoiCallRfaClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.Make(mkSave+mkRfa);
end;

procedure TFormSpectrZonFitControl.ButtonZonNewClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.NewZone;
end;

procedure TFormSpectrZonFitControl.ButtonZonPeakInClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.ZonePeakIn;
end;

procedure TFormSpectrZonFitControl.ButtonZonClearClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.ClearZone;
end;

procedure TFormSpectrZonFitControl.ButtonZonFitClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.FitCurrent;
end;

procedure TFormSpectrZonFitControl.ButtonZonDeleteClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.DeleteCurrentZone;
end;

procedure TFormSpectrZonFitControl.ButtonZonLimitsClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.Interval;
end;

procedure TFormSpectrZonFitControl.ButtonZonMergeClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.MergeZone;
end;

procedure TFormSpectrZonFitControl.ButtonZonGroundClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.Ground;
end;

procedure TFormSpectrZonFitControl.ButtonZonCovClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.ViewCovariation;
end;

procedure TFormSpectrZonFitControl.ButtonZonBugsClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.RemoveZoneBugs;
end;

procedure TFormSpectrZonFitControl.ButtonPeakInsertClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.InsertPeak;
end;

procedure TFormSpectrZonFitControl.ButtonPeakDeleteClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.DeletePeak;
end;

procedure TFormSpectrZonFitControl.ButtonPeakEditClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.EditPeak;
end;

procedure TFormSpectrZonFitControl.ButtonPeakInPresetClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.PeakInPreset;
end;

procedure TFormSpectrZonFitControl.ButtonFitPresetClick(Sender: TObject);
begin
 if Ok and Win.Ok then Win.ZonFit.Roi.FitPreset;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrzonfitcontrol;
begin
end;

procedure Free_form_spectrzonfitcontrol;
begin
end;

initialization

 Init_form_spectrzonfitcontrol;

finalization

 Free_form_spectrzonfitcontrol;

end.

//////////////
// END OF FILE
//////////////

