unit form_crwdaqtest;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 lcltype, lclintf,
 _crw_alloc, _crw_str, _crw_eldraw, _crw_fio, _crw_fifo,
 _crw_guiutils, _crw_fonts, _crw_proc, _crw_guard,
 _crw_ee, _crw_syscal, _crw_utf8, _crw_curves,
 _crw_appforms, _crw_apptools, _crw_apputils,
 _crw_daqtags, _crw_calib, _crw_plut,
 _crw_rtc,
 form_crwdaqbuglist,
 form_crwdaqsyschild,
 form_crwdaqwatchdog,
 form_mistimingservice,
 form_secretservice,
 form_consolewindow,
 form_termwindow,
 form_tabwindow,
 form_tabwindowformatdialog,
 form_texteditor,
 form_texteditortemplates,
 form_textfinddialog,
 form_textreplacedialog,
 form_nsiswindow,
 form_circuitwindow,
 form_curvebyformula,
 form_curvewindow,
 form_curveeditdownsamplingdialog,
 form_curvetoolswritetabledialog,
 form_curveeditwindowstyledialog,
 form_curvetoolsreadtabledialog,
 form_curvetoolsrunmacrodialog,
 form_curverangeselector,
 form_curvestyledialog,
 form_curvetools,
 form_surfwindow,
 form_surfbyformula,
 form_surfwindowclipdialog,
 form_surftoolssmoothingdialog,
 form_surfwindowstyledialog,
 form_calibdialog,
 _crw_rfadata,
 _crw_stopion,
 _crw_peaksearch,
 form_rfamendeleevtable,
 form_spectrwindow,
 form_spectrdaqwindow,
 form_spectrpikwindow,
 form_spectrpikcontrol,
 form_spectrpeakinpreset,
 form_spectrmanfitwindow,
 form_spectrzonfitwindow,
 form_spectrrfabfpwindow,
 form_createnewdataanalysisplugin,
 form_editdataanalysispluginarguments,
 form_delphiprojecteditor,
 _crw_daqsys,
 _crw_daqdev,
 _crw_pcldev,
 _crw_adamdev,
 _crw_softdev,
 _crw_softdevscript,
 form_daqhelpviewer,
 form_daqhistlendialog,
 form_daqhistorywarning,
 form_daqedittagdialog,
 form_daqdatetimecalculator,
 form_daqopendynamicwindowdialog,
 form_daqmedianfilterdialog,
 form_daqcurvesmoothing,
 form_daqwinoperdialog,
 _crw_daqreaddat,
 form_daqreaddat,
 form_daqdevicecontrol,
 form_daqcontroldialog,
 form_daqpoint2dedit,
 unit_crwdaqmessages,
 form_daqdevicecommonpropertydialog,
 unit_resourcemonitorconsole,
 unit_keyboardlayout,
 _crw_crwapiserver,
 _crw_sect,
 form_crwdaqlogo;

type

  { TFormCrwDaq }

  TFormCrwDaq = class(TForm)
    BitBtnCrwDaqLogo: TBitBtn;
    ButtonCrwDaqBugList: TButton;
    ButtonCrwDaqCalibDialog: TButton;
    ButtonCrwDaqConsoleWindow: TButton;
    ButtonCrwDaqCurveByFormula: TButton;
    ButtonCrwDaqCurveSmoothing: TButton;
    ButtonCrwDaqDateTimeCalculator: TButton;
    ButtonCrwDaqEditorTemplates: TButton;
    ButtonCrwDaqMendeleevTable: TButton;
    ButtonCrwDaqMistiming: TButton;
    ButtonCrwDaqOpenDaqControl: TButton;
    ButtonCrwDaqOpenSdiChild: TButton;
    ButtonCrwDaqOpenResourceMonitor: TButton;
    ButtonCrwDaqOpenWatchDog: TButton;
    ButtonCrwDaqReadDat: TButton;
    ButtonCrwDaqSecretService: TButton;
    ButtonCrwDaqSpectrWindow: TButton;
    ButtonCrwDaqSurfByFormula: TButton;
    ButtonCrwDaqTabWindow: TButton;
    ButtonCrwDaqTextEditor: TButton;
    ButtonCtwDaqCircuitWindow: TButton;
    GroupBoxLog: TGroupBox;
    MemoLog: TMemo;
    OpenDialogCrc: TOpenDialog;
    OpenDialogDat: TOpenDialog;
    PageControlTest: TPageControl;
    PanelMain: TPanel;
    TabSheetTest: TTabSheet;
    Timer1000: TTimer;
    Timer55: TTimer;
    procedure BitBtnCrwDaqLogoClick(Sender: TObject);
    procedure ButtonCrwDaqBugListClick(Sender: TObject);
    procedure ButtonCrwDaqCalibDialogClick(Sender: TObject);
    procedure ButtonCrwDaqConsoleWindowClick(Sender: TObject);
    procedure ButtonCrwDaqCurveByFormulaClick(Sender: TObject);
    procedure ButtonCrwDaqCurveSmoothingClick(Sender: TObject);
    procedure ButtonCrwDaqDateTimeCalculatorClick(Sender: TObject);
    procedure ButtonCrwDaqEditorTemplatesClick(Sender: TObject);
    procedure ButtonCrwDaqMendeleevTableClick(Sender: TObject);
    procedure ButtonCrwDaqMistimingClick(Sender: TObject);
    procedure ButtonCrwDaqOpenDaqControlClick(Sender: TObject);
    procedure ButtonCrwDaqOpenSdiChildClick(Sender: TObject);
    procedure ButtonCrwDaqOpenResourceMonitorClick(Sender: TObject);
    procedure ButtonCrwDaqOpenWatchDogClick(Sender: TObject);
    procedure ButtonCrwDaqReadDatClick(Sender: TObject);
    procedure ButtonCrwDaqSecretServiceClick(Sender: TObject);
    procedure ButtonCrwDaqSpectrWindowClick(Sender: TObject);
    procedure ButtonCrwDaqSurfByFormulaClick(Sender: TObject);
    procedure ButtonCrwDaqTabWindowClick(Sender: TObject);
    procedure ButtonCrwDaqTextEditorClick(Sender: TObject);
    procedure ButtonCtwDaqCircuitWindowClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1000Timer(Sender: TObject);
    procedure Timer55Timer(Sender: TObject);
  private
    ZStamp : String;
  public
    procedure AddLog(When:TDateTime; Msg:String);
  end;

var
  FormCrwDaq: TFormCrwDaq;

implementation

{$R *.lfm}

procedure UpdateStdIo;
begin
 if Assigned(FormCrwDaq) then with FormCrwDaq do begin
  if (StdOutputFifo.Count>0) then AddLog(-1,StdOutputFifo.GetText);
  if (StdErrOutputFifo.Count>0) then AddLog(-1,StdErrOutputFifo.GetText);
  if (SystemCalculator.Fifo.Count>0) then AddLog(-1,SystemCalculator.Fifo.GetText);
 end;
end;

{ TFormCrwDaq }

procedure TFormCrwDaq.FormCreate(Sender: TObject);
begin
 inherited;
 Guard.Startup;
 Tick55Actions.Add(UpdateStdIo);
 Language:=lng_Russian;
end;

procedure TFormCrwDaq.Timer1000Timer(Sender: TObject);
begin
 try
  SecondActions.Execute;
 except
  on E:Exception do BugReport(E,Self,'Timer1000Timer');
 end;
end;

procedure TFormCrwDaq.Timer55Timer(Sender: TObject);
begin
 try
  Tick55Actions.Execute;
 except
  on E:Exception do BugReport(E,Self,'Timer55Timer');
 end;
end;


const
 PromptAr=' => ';
 DTFormat='yyyy.mm.dd-hh:mm:ss';

procedure TFormCrwDaq.AddLog(When:TDateTime; Msg:String);
var Stamp:String; Logger:TStrings; List:TStringList; i:Integer;
begin
 if (Msg<>'') and not IsLexeme(Msg,lex_utf8) then Msg:=utf8_fixbroken(Msg);
 if (ZStamp='') then begin
  ZStamp:=FormatDateTime(DTFormat,Now);
  ZStamp:=Pad('',Length(ZStamp),'=')+PromptAr;
 end;
 if (When<=0)
 then Stamp:=ZStamp
 else Stamp:=FormatDateTime(DTFormat,When)+PromptAr;
 if (When<0) then begin Stamp:=''; ZStamp:=''; end;
 Logger:=MemoLog.Lines;
 if (PosEol(Msg)=0) then begin
  Logger.Add(Stamp+Msg);
 end else begin
  List:=TStringList.Create;
  try
   List.Text:=ValidateEol(Msg);
   for i:=0 to List.Count-1 do begin
    Logger.Add(Stamp+List.Strings[i]);
    if (i=0) then Stamp:=ZStamp;
   end;
  finally
   List.Free;
  end;
 end;
 MemoLog.SelStart:=MaxInt;
end;

procedure TFormCrwDaq.BitBtnCrwDaqLogoClick(Sender: TObject);
begin
 ShowFormCrwDaqLogo('CRW-DAQ LOGO','LOGO','resource/bitmap/sarovlogo.jpg',true);
end;

procedure TFormCrwDaq.ButtonCrwDaqBugListClick(Sender: TObject);
var t:TText;
begin
 t:=NewText;
 t.Text:='Error Alert';
 FormCrwDaqBugList.ErrorAlert(t);
 Kill(t);
end;

procedure TFormCrwDaq.ButtonCrwDaqOpenSdiChildClick(Sender: TObject);
var aForm:TFormCrwDaqSysChild;
begin
 Application.CreateForm(TFormCrwDaqSysChild,aForm);
 aForm.Show;
end;

procedure TFormCrwDaq.ButtonCrwDaqOpenWatchDogClick(Sender: TObject);
begin
 if (GetWatchDogTimerLog='') then InitWatchdogTimer;
 OpenFormCrwDaqWatchDog;
end;

procedure TFormCrwDaq.ButtonCrwDaqMistimingClick(Sender: TObject);
begin
 OpenFormMistimingService;
 CheckMistiming;
end;

procedure TFormCrwDaq.ButtonCrwDaqSecretServiceClick(Sender: TObject);
begin
 OpenFormSecretService(true);
 //ShowLockWarning;
end;

procedure TFormCrwDaq.ButtonCrwDaqConsoleWindowClick(Sender: TObject);
var win:TFormConsoleWindow;
begin
 win:=NewConsoleWindow('Demo',NewFifo(1024*64),true,nil,NewFifo(1024*64),true,nil);
 win.UpdateLines('ProcessList:'+EOL+GetListOfProcesses(0,0,''));
end;

procedure TFormCrwDaq.ButtonCrwDaqTabWindowClick(Sender: TObject);
var tag:Integer; win:TFormTabWindow;
begin
 win:=NewTabWindow('Demo_TabWindow');
 tag:=InitTag('DemoTag',2); rSetTag(tag,pi); win.AddItem(nil,tag,'DemoTag',true);
 tag:=InitTag('TestTag',2); rSetTag(tag,exp(1)); win.AddItem(nil,tag,'TestTag',true);
 win.UpdateSize;
end;

procedure TFormCrwDaq.ButtonCrwDaqEditorTemplatesClick(Sender: TObject);
var s:LongString;
begin
 Language:=lng_Russian;
 s:=FormTextEditorTemplatesExecute('EditorTemplates',0,false);
 ShowMessage(s);
end;

procedure TFormCrwDaq.ButtonCrwDaqTextEditorClick(Sender: TObject);
var txt:LongString;
begin
 txt:=UnifyFileAlias(HomeDir+'/resource/crwdaq.voice.ini');
 FindTextEditor(txt,true);
end;

procedure TFormCrwDaq.ButtonCtwDaqCircuitWindowClick(Sender: TObject);
var crc,s:LongString; win:TFormCircuitWindow; p:TText;
begin
 if (OpenDialogCrc.InitialDir='') then begin
  crc:=UnifyFileAlias(HomeDir+'/resource/daqsite/painter/guilibdemo.crc');
  OpenDialogCrc.InitialDir:=ExtractFileDir(crc);
  OpenDialogCrc.FileName:=crc;
 end;
 if OpenDialogCrc.Execute then begin
  crc:=OpenDialogCrc.FileName;
  win:=NewCircuitWindowFromCrcFile(crc);
  p:=NewText;
  try
   win.Evaluator.VarList.GetText(p);
   win.Evaluator.ConstList.GetText(p);
   s:=p.Text;
   write(s);
  finally
   Kill(p);
  end;
 end;
end;

procedure TFormCrwDaq.ButtonCrwDaqCurveByFormulaClick(Sender: TObject);
var crv:TCurve; i:Integer;
begin
 crv:=CurveByFormulaDialog;
 if crv.Ok then begin
  for i:=0 to crv.Count-1 do writeln(Format('%d %.7g %.7g',[i,crv[i].x,crv[i].y]));
 end;
 Kill(crv);
 NewCurveWindowByFormula;
end;

procedure TFormCrwDaq.ButtonCrwDaqSurfByFormulaClick(Sender: TObject);
begin
 NewSurfWindowByFormulaDialog;
end;

procedure TFormCrwDaq.ButtonCrwDaqCalibDialogClick(Sender: TObject);
var cal:TPolynomCalibration;
begin
 cal:=NewCalibration;
 OpenFormCalibDialog(cal,true);
end;

procedure TFormCrwDaq.ButtonCrwDaqMendeleevTableClick(Sender: TObject);
begin
 if not Rfa.Active then Init_Rfa_SubSystem;
 FormRfaMendeleevTableExecute;
end;

procedure TFormCrwDaq.ButtonCrwDaqSpectrWindowClick(Sender: TObject);
var crv:TCurve; win:TFormSpectrWindow; i,j:Integer;
begin
 crv:=NewCurve(1024,'Spectr'); crv.Step:=0;
 for i:=0 to crv.Count-1 do crv[i]:=Point2D(i,0);
 for i:=1 to 10000 do begin
  j:=128+Random(128)+Random(128)+Random(128)+Random(128)+Random(128)+Random(128);
  crv[j]:=Point2D(crv[j].x,crv[j].y+1);
 end;
 win:=NewSpectrWindow(regSpecWin,'Test Spectr',crv,true);
 if Win.Ok then writeln(win.Caption);
end;

procedure TFormCrwDaq.ButtonCrwDaqDateTimeCalculatorClick(Sender: TObject);
begin
 OpenFormDaqDateTimeCalculator(0,msecnow);
end;

procedure TFormCrwDaq.ButtonCrwDaqCurveSmoothingClick(Sender: TObject);
var win:TFormCurveWindow;
begin
 win:=NewCurveWindowByFormula;
 win.AddCurve(NewCurve(1000,'Spline',clYellow,16));
 win.DefCurveNum:=-1;
 if win.Ok then FormDaqCurveSmoothingExecute(win);
end;

procedure TFormCrwDaq.ButtonCrwDaqReadDatClick(Sender: TObject);
begin
 if (OpenDialogDat.InitialDir='') then OpenDialogDat.InitialDir:=HomeDir;
 if OpenDialogDat.Execute then ReadDatFiles(OpenDialogDat.Files.Text);
end;

procedure TFormCrwDaq.ButtonCrwDaqOpenDaqControlClick(Sender: TObject);
begin
 OpenFormDaqControlDialog;
end;

procedure TFormCrwDaq.ButtonCrwDaqOpenResourceMonitorClick(Sender: TObject);
begin
 ResMonStatFlags:=15;
 OpenResourceMonitorConsole;
 writeln(SectDaqSys,' ',SectDaqSys(1));
end;

end.

