#!/usr/local/bin/crwkit pyvenv

##########################################################
# Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru
##########################################################
# The code designed to run in 'crwkit pyvenv' environment.
##########################################################

import os, sys, time
from pycrwkit import *

##########################################################
# Override DaqApplication class for Demo User Application:
##########################################################
class DemoDaqApplication(DaqApplication):
    ###############################
    # Override Greetings on startup
    ###############################
    def Greetengs(self):
        super().Greetengs() # call inherited
        print("Welcome to %s program." % self.Title)

    ####################################
    # Override Processing of StdIn lines
    ####################################
    def StdInProcessing(self,line):
        if not isinstance(line,str):
            return False
        print("Input: %s" % line)
        # call inherited StdIn processing
        return super().StdInProcessing(line)

    ##################################
    # Override HandleCommand for StdIn
    ##################################
    def HandleCommand(self,cmd,arg):
        if not isinstance(cmd,str):
            return False
        print("Command: %s %s" % (cmd,arg))
        # call inherited command handler
        return super().HandleCommand(cmd,arg)

    ##############################
    # Execute user polling actions
    ##############################
    def ExecPollingActions(self):
        # call inherited polling actions
        return super().ExecPollingActions()

    ####################################
    # Override handler for command @Exit
    ####################################
    def DoExit(self,cmd,arg):
        if not SameText(cmd,"@Exit"):
            return False
        code = StrToIntDef(arg,0)
        self.Terminate("Terminated %d." % code,code)
        return True

    ######################################
    # Define new handler for command @Test
    ######################################
    def DoTest(self,cmd,arg):
        if not SameText(cmd,"@Test"):
            return False
        n = StrToIntDef(arg,0)
        print("Test %d requested." % n)
        return True

    #######################################
    # Define new handler for command @Raise
    #######################################
    def DoRaise(self,cmd,arg):
        if not SameText(cmd,"@Raise"):
            return False
        print("Raise test exception")
        msg = "Demo exception for Test %s" % arg
        raise Exception(msg.strip())
        return True

##########################################
# Create the DaqApplication object to run:
##########################################
Application = DemoDaqApplication("demo",4)

###########################################
# Then add new application command handlers
###########################################
Application.AddCommandHandler(Application.DoTest,"@Test n - run test number n (demo)")
Application.AddCommandHandler(Application.DoRaise,"@Raise n - raise test (demo) exception n")

###################
# Main program body
###################
def execute_main():
    try:
        Application.Welcome()
        Application.RunLoop()
        Application.Goodbye()
        Application.SysExit()
    except Exception as E:
        Application.OnError(E)
        Application.SysExit(1)

######
# MAIN
######

if __name__ == '__main__':
    execute_main()

#############
# END OF FILE
#############
