 {
 StdIn data processing with TimeOut limit.
 Note: TimeOut=MaxInt mean unlimited time.
 }
 procedure StdIn_Processing(TimeOut:Integer);
 var ms:Real; Quit:Integer;
 begin
  if TimeOut=MaxInt then begin
   while StdIn_Readln(StdIn_Line) do StdIn_Processor(StdIn_Line);
  end else begin
   ms:=mSecNow; Quit:=0;
   while Quit=0 do begin
    if mSecNow>=ms+TimeOut then Quit:=1 else
    if StdIn_Readln(StdIn_Line) then StdIn_Processor(StdIn_Line) else Quit:=1;
   end;
  end;
 end;
 {
 Main: canonical program body.
 }
begin
 {
 Initialization on Start...
 }
 if Starting then begin
  ClearStdLibrary;
  ClearApplication;
  CheckStringLeaks;
  InitStdLibrary;
  InitApplication;
  if CheckStdErrors then begin
   Succeed('Start Ok.');
   PostStartingDevMsg;
   if StdIn_EnablePoll then
   if StdIn_ToStarting>0 then
   StdIn_Processing(StdIn_ToStarting);
  end else begin
   Trouble('Start Fails.');
   StdIn_EnablePoll:=False;
  end;
 end else
 {
 Finalization on Stop...
 }
 if Stopping then begin
  PostStoppingDevMsg;
  if StdIn_EnablePoll then
  if StdIn_ToStopping>0 then
  StdIn_Processing(StdIn_ToStopping);
  FreeApplication;
  FreeStdLibrary;
  ClearApplication;
  ClearStdLibrary;
  CheckStringLeaks;
  Succeed('Stop.');
 end else
 {
 Data processing on Poll...
 }
 if Polling then begin
  PollStdLibrary;
  if Polling then begin
   if StdIn_EnablePoll then
   if StdIn_ToPredPoll>0 then
   StdIn_Processing(StdIn_ToPredPoll);
   PollApplication;
   if StdIn_EnablePoll then
   if StdIn_ToPostPoll>0 then
   StdIn_Processing(StdIn_ToPostPoll);
  end;
 end;
end.
