 {
 Standard routines for Console:
 function  DebugFlagEnabled(flag:Integer):Boolean;
 procedure Trouble(msg:String);
 procedure Problem(msg:String);
 procedure Failure(ErrorCode:Integer; msg:String);
 procedure Success(msg:String);
 procedure Succeed(msg:String);
 procedure ViewImp(msg:String);
 procedure ViewExp(msg:String);
 procedure Details(msg:String);
 procedure Disturb(msg:String);
 procedure Alerter(msg:String);
 procedure CritErr(msg:String);
 procedure Fatally(msg:String);
 procedure Reports(msg:String);
 procedure Assertion(cond:Boolean; msg:String);
 function  IoError:Boolean;
 function  StdIn_Readln(var Data:String):Boolean;
 procedure StdIn_SetTimeouts(Init,Stop,Pred,Post:Integer);
 procedure StdIn_SetScripts(Init,Stop:String);
 function  LooksLikeCommand(line:String):Boolean;
 function  GotCommand(var Data,cmd,arg:String):Boolean;
 function  GotCommandId(var Data,cmd,arg:String; var cid:Integer):Boolean;
 function  RegisterStdInCmd(cmd:String; help:String):Integer;
 procedure OpenConsole(Mode:Integer);
 procedure ShowHelp(AllowEcho:Boolean);
 function  GetDateTime(ms:Real):String;
 procedure ClearStdConsole;
 procedure InitStdConsole;
 procedure FreeStdConsole;
 procedure PollStdConsole;
 }
 ////////////////
 {$I _fun_syslog}
 ////////////////
 {
 Check if DebugFlags contains given flag.
 }
 function DebugFlagEnabled(flag:Integer):Boolean;
 begin
  DebugFlagEnabled:=HasFlags(DebugFlags,flag);
 end;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 begin
  if HasFlags(DebugFlags,dfTrouble) then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if Starting then Errors:=Errors+1 else bNul(FixError(ErrorCode));
  if SysLogNotable(SeverityOfTrouble) then iNul(SysLogNote(SeverityOfTrouble,msg));
 end;
 {
 Report on problem.
 }
 procedure Problem(msg:String);
 begin
  if HasFlags(DebugFlags,dfTrouble) then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if SysLogNotable(SeverityOfProblem) then iNul(SysLogNote(SeverityOfProblem,msg));
 end;
 {
 Report on failure.
 }
 procedure Failure(ErrorCode:Integer; msg:String);
 begin
  if HasFlags(DebugFlags,dfTrouble) then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if Starting then Errors:=Errors+1 else bNul(FixError(ErrorCode));
  if SysLogNotable(SeverityOfFailure) then iNul(SysLogNote(SeverityOfFailure,msg));
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if HasFlags(DebugFlags,dfSuccess) then
  if Length(msg)>0 then Writeln(DevName+' : '+msg);
  if SysLogNotable(SeverityOfSuccess) then iNul(SysLogNote(SeverityOfSuccess,msg));
 end;
 {
 Report on succeed.
 }
 procedure Succeed(msg:String);
 begin
  if HasFlags(DebugFlags,dfSuccess) then
  if Length(msg)>0 then Writeln(DevName+' : '+msg);
  if SysLogNotable(SeverityOfSucceed) then iNul(SysLogNote(SeverityOfSucceed,msg));
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if HasFlags(DebugFlags,dfViewImp) then
  if Length(msg)>0 then Writeln(DevName+' < '+msg);
  if SysLogNotable(SeverityOfViewImp) then iNul(SysLogNote(SeverityOfViewImp,msg));
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if HasFlags(DebugFlags,dfViewExp) then
  if Length(msg)>0 then Writeln(DevName+' > '+msg);
  if SysLogNotable(SeverityOfViewExp) then iNul(SysLogNote(SeverityOfViewExp,msg));
 end;
 {
 Report on details.
 }
 procedure Details(msg:String);
 begin
  if HasFlags(DebugFlags,dfDetails) then
  if Length(msg)>0 then Writeln(DevName+' ~ '+msg);
  if SysLogNotable(SeverityOfDetails) then iNul(SysLogNote(SeverityOfDetails,msg));
 end;
 {
 Report on disturb.
 }
 procedure Disturb(msg:String);
 begin
  if HasFlags(DebugFlags,dfTrouble) then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if SysLogNotable(SeverityOfDisturb) then iNul(SysLogNote(SeverityOfDisturb,msg));
 end;
 {
 Report on alerter.
 }
 procedure Alerter(msg:String);
 begin
  if HasFlags(DebugFlags,dfTrouble) then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if SysLogNotable(SeverityOfAlerter) then iNul(SysLogNote(SeverityOfAlerter,msg));
 end;
 {
 Report on critical error.
 }
 procedure CritErr(msg:String);
 begin
  if HasFlags(DebugFlags,dfTrouble) then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if Starting then Errors:=Errors+1 else bNul(FixError(ErrorCode));
  if SysLogNotable(SeverityOfCritErr) then iNul(SysLogNote(SeverityOfCritErr,msg));
 end;
 {
 Report on fatally.
 }
 procedure Fatally(msg:String);
 begin
  if HasFlags(DebugFlags,dfTrouble) then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if Starting then Errors:=Errors+1 else bNul(FixError(ErrorCode));
  if SysLogNotable(SeverityOfFatally) then iNul(SysLogNote(SeverityOfFatally,msg));
 end;
 {
 Report on trouble...fatally.
 }
 procedure Reports(msg:String);
 const rlist='Trouble,Problem,Success,Succeed,ViewImp,ViewExp,Details,Disturb,Alerter,CritErr,Fatally';
 begin
  if (msg<>'') then
  case WordIndex(ExtractWord(1,msg),rlist) of
   1:  Trouble(SkipWords(1,msg));
   2:  Problem(SkipWords(1,msg));
   3:  Success(SkipWords(1,msg));
   4:  Succeed(SkipWords(1,msg));
   5:  ViewImp(SkipWords(1,msg));
   6:  ViewExp(SkipWords(1,msg));
   7:  Details(SkipWords(1,msg));
   8:  Disturb(SkipWords(1,msg));
   9:  Alerter(SkipWords(1,msg));
   10: CritErr(SkipWords(1,msg));
   11: Fatally(SkipWords(1,msg));
  end;
 end;
 {
 Check condition (cond) then call Success or Trouble.
 }
 procedure Assertion(cond:Boolean; msg:String);
 begin
  if cond
  then Success(msg)
  else Trouble(msg);
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=False;
  if IoResult<>0 then begin
   Trouble('CON: I/O error.');
   IoError:=True;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:String):Boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then begin Readln(Data); StdIn_LineCount:=StdIn_LineCount+1; end;
  if IoError then begin Data:=''; StdIn_LineErrors:=StdIn_LineErrors+1; end;
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Set StdIn TimeOut values:
 Init after  ApplicationInit on Starting
 Stop before ApplicationFree on Stopping
 Pred before ApplicationPoll on Polling
 Post after  ApplicationPoll on Polling
 0      mean disable polling 
 MaxInt mean no time limits.
 }
 procedure StdIn_SetTimeouts(Init,Stop,Pred,Post:Integer);
 begin
  StdIn_ToStarting:=Init;
  StdIn_ToStopping:=Stop;
  StdIn_ToPredPoll:=Pred;
  StdIn_ToPostPoll:=Post;
 end;
 {
 Set Starting and Stopping scripts, i.e. DevPost messages.
 }
 procedure StdIn_SetScripts(Init,Stop:String);
 begin
  StartingDevMsg:=Init;
  StoppingDevMsg:=Stop;
 end;
 {
 Is string (line) looks like command (@xxx...)?
 }
 function LooksLikeCommand(line:String):Boolean;
 begin
  LooksLikeCommand:=IsLexeme(line,lex_AtCmnd);
 end;
 {
 Have got a command?
 Check if input line (Data) contains a command.
 Command looks like "@cmd arg" or "@cmd=arg".
 Then extract cmd and arg.
 }
 function GotCommand(var Data,cmd,arg:String):Boolean;
 begin
  if IsLexeme(Data,lex_AtCall) then begin
   GotCommand:=True;
   cmd:=ExtractWord(1,Data);
   arg:=Copy(Data,Length(cmd)+2);
   StdIn_CmndCount:=StdIn_CmndCount+1;
  end else begin
   GotCommand:=False;
   cmd:='';
   arg:='';
  end;
 end;
 {
 Have got a command?
 Check if input line (Data) contains a command.
 Command looks like "@cmd arg" or "@cmd=arg".
 Then extract cmd and arg, then get command identifier cid from StdIn_CmdHashTab.
 }
 function GotCommandId(var Data,cmd,arg:String; var cid:Integer):Boolean;
 begin
  if IsLexeme(Data,lex_AtCall) then begin
   GotCommandId:=True;
   cmd:=ExtractWord(1,Data);
   arg:=Copy(Data,Length(cmd)+2);
   if (StdIn_CmdHashTab = 0) then cid := 0 else
   cid:=HashList_GetLink(StdIn_CmdHashTab,cmd);
   StdIn_CmndCount:=StdIn_CmndCount+1;
   if cid=0 then cid:=-1;
  end else begin
   GotCommandId:=False;
   cmd:='';
   arg:='';
   cid:=-1;
  end;
 end;
 {
 Register StdIn command and return command identifier.
 }
 function RegisterStdInCmd(cmd:String; help:String):Integer;
 var cid,i,p:Integer;
 begin
  cid:=0; cmd:=Trim(cmd);
  if StdIn_CmdHashTab=0 then StdIn_CmdHashTab:=HashList_Init(0);
  if StdIn_CmdHashTab<>0 then
  if LooksLikeCommand(cmd) then begin
   if HashList_IndexOf(StdIn_CmdHashTab,cmd)<0 then cid:=0 else
   cid:=HashList_GetLink(StdIn_CmdHashTab,cmd);
   if cid<=0 then begin
    cid:=HashList_Count(StdIn_CmdHashTab)+1;
    bNul(HashList_SetLink(StdIn_CmdHashTab,cmd,cid));
    bNul(HashList_SetPara(StdIn_CmdHashTab,cmd,help));
    i:=0; p:=1;
    repeat
     i:=PosEx(EOL,help,i+1);
     if (i>0) then begin
      bNul(text_AddLn(StdIn_HelpLines,' '+Copy(help,p,i-p)));
      p:=i+Length(EOL);
     end else begin
      if (p<=Length(help)) then
      bNul(text_AddLn(StdIn_HelpLines,' '+Copy(help,p,Length(help)-p+1)));
     end;
    until (i<=0);
   end;
   cid:=HashList_GetLink(StdIn_CmdHashTab,cmd);
   if cid>0 
   then Success('Registered command: '+cmd+' '+Str(cid))
   else Trouble('Could not register: '+cmd);
   if cid<0 then cid:=0;
  end;
  RegisterStdInCmd:=cid;
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
  procedure ShowWin(WinName:String);
  begin
   bNul(WinShow(WinName));
   bNul(WinDraw(WinName+'|top=317|left=0|width=600|height=317'));
   if Mode=1 then bNul(WinSelect(WinName)) else bNul(WinHide(WinName));
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Show help in device console and echo to Main console if AllowEcho.
 Help text should be placed in program comment is [@Help] section.
 First symbol of help block should be | and will be ignored.
 }
 procedure ShowHelp(AllowEcho:Boolean);
 var i,j,p,sect:Integer; f:Boolean;
 begin
  if not IsEmptyStr(ProgramSourcePas) then
  if FileExists(ProgramSourcePas) then begin
   f:=True;
   sect:=ReadIniSection(text_New,12,ProgramSourcePas,'[@Help]');
   for i:=0 to text_NumLn(sect)-1 do begin
    if Copy(text_GetLn(sect,i),1,1)='|' then p:=2 else p:=1;
    if AllowEcho then bNul(Echo(DevName+' : '+Copy(text_GetLn(sect,i),p)));
    Success(Copy(text_GetLn(sect,i),p));
    if f then if Pos('*********',text_GetLn(sect,i))>0 then begin
     for j:=0 to text_NumLn(StdIn_HelpLines)-1 do begin
      if AllowEcho then bNul(Echo(DevName+' : '+text_GetLn(StdIn_HelpLines,j)));
      Success(text_GetLn(StdIn_HelpLines,j));
     end;
     f:=False;
    end;
   end;
   bNul(text_Free(sect));
   if AllowEcho then begin
    bNul(WinSelect(ParamStr('MainConsole')));
   end;
   if StdIn_HelpBrowseOn then begin
    if FileExists(ForceExtension(ProgramSourcePas,'.htm'))
    then rNul(Eval('@system @async @silent @run WebBrowser '+ForceExtension(ProgramSourcePas,'.htm'))) else
    if FileExists(ForceExtension(ProgramSourcePas,'.md'))
    then rNul(Eval('@system @async @silent @run WebBrowser '+ForceExtension(ProgramSourcePas,'.md')));
   end;
  end;
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 function GetDateTime(ms:Real):String;
 begin
  GetDateTime:=StrTimeFmt('yyyy.mm.dd-hh:nn:ss',ms);
 end;
 {
 Check string manager leaks.
 }
 procedure CheckStringLeaks;
 var ma,sa:Integer;
  procedure CheckAvail;
  begin
   ma:=MaxAvail; sa:=StackAvail;
  end;
 begin
  CheckAvail;
  if Starting then begin
   FixMaxAvail:=ma;
   Success('Checked at '+GetDateTime(mSecNow));
   Success('MaxAvail='+Str(ma)+', StackAvail='+Str(sa));
  end else
  if Stopping then begin
   if FixMaxAvail>ma then Trouble('String Manager Leak = '+Str(FixMaxAvail-ma));
   if FixMaxAvail<ma then Problem('String Manager Leak = '+Str(FixMaxAvail-ma));
  end;
 end;
 {
 Clear standard Console.
 }
 procedure ClearStdConsole;
 begin
  StdIn_Line:='';
 end;
 {
 Initialize standard Console.
 }
 procedure InitStdConsole;
 var ma,sa:Integer;
 begin
  InitSysLogInternals;
  StdIn_Line:='';
  StdIn_LineCount:=0;
  StdIn_CmndCount:=0;
  StdIn_LineErrors:=0;
  StdIn_StrictErr:=True;
  StdIn_HelpEchoOn:=false;
  StdIn_HelpBrowseOn:=True;
  StdIn_EnablePoll:=True;
  StdIn_ToStarting:=0;
  StdIn_ToStopping:=0;
  StdIn_ToPredPoll:=0;
  StdIn_ToPostPoll:=MaxInt;
  StdIn_HelpLines:=text_New;
  ma:=MaxAvail; sa:=StackAvail;
  DebugFlags:=iEvalDef(ReadIni('DebugFlags'),3);
  OpenConsole(iEvalDef(ReadIni('OpenConsole'),0));
  Success('Started at '+GetDateTime(mSecNow)+' ThreadID '+ParamStr('CurrentThreadId'));
  Success('MaxAvail='+Str(ma)+', StackAvail='+Str(sa));
  StdIn_CmdHashTab:=0;
  ShouldPollStdConsole:=false;
 end;
 {
 Finalize standard Console.
 }
 procedure FreeStdConsole;
 var ma,sa:Integer; vm,ms,dt,de:Real;
 begin
  StdIn_Line:='';
  ma:=MaxAvail; sa:=StackAvail;
  Success('Stopped at '+GetDateTime(mSecNow)+' ThreadID '+ParamStr('CurrentThreadId'));
  Success('MaxAvail='+Str(ma)+', StackAvail='+Str(sa));
  bNul(text_Free(StdIn_HelpLines)); StdIn_HelpLines:=0;
  if HasFlags(DebugFlags,dfDetails) then begin
   ms:=mSecNow;
   vm:=VDPM_OpCount;
   dt:=(ms-FixmSecNow)/1000;
   de:=GetErrCount(-1)-FixDevErrCount;
   Details('Execution statistics:');
   Details(' Counters:');
   Details('  TimePass  = '+StrFix(dt,12,3)+' sec');
   Details('  RunCount  = '+StrFix(RunCountHolder,12,0)+' polls');
   Details('  ErrCount  = '+StrFix(de,12,0)+' errors');
   Details('  VMOpCount = '+StrFix(vm/1000,12,3)+' DP kOps');
   Details('  LineCount = '+StrFix(StdIn_LineCount,12,0)+' lines');
   Details('  CmndCount = '+StrFix(StdIn_CmndCount,12,0)+' cmnds');
   Details(' Rate, per run:');
   Details('  VMOpsRate = '+StrFix(vm/RunCountHolder,12,0)+' Ops/run');
   Details('  ErrorRate = '+StrFix(de/RunCountHolder,12,6)+' Bug/run');
   Details('  LinesRate = '+StrFix(StdIn_LineCount/RunCountHolder,12,3)+' line/run');
   Details('  CmndsRate = '+StrFix(StdIn_CmndCount/RunCountHolder,12,3)+' cmnd/run');
   Details(' Rate, per second:');
   Details('  PollsRate = '+StrFix(RunCountHolder/dt,12,3)+' runs/sec');
   Details('  ErrorRate = '+StrFix(de/dt,12,3)+' bugs/sec');
   Details('  VMOpsRate = '+StrFix(vm/dt/1000,12,3)+' kOps/sec');
   Details('  LinesRate = '+StrFix(StdIn_LineCount/dt,12,3)+' line/sec');
   Details('  CmndsRate = '+StrFix(StdIn_CmndCount/dt,12,3)+' cmnd/sec');
  end;
  if StdIn_CmdHashTab<>0 then begin
   bNul(HashList_Free(StdIn_CmdHashTab));
   StdIn_CmdHashTab:=0;
  end;
  FreeSysLogInternals;
 end;
 {
 Poll standard Console.
 }
 procedure PollStdConsole;
 begin
 end;
