@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2021 Alexey Kuryakin kouriakine@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Tool to detect com0com and to work with him anywhere
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Main
:SetSelfInfo
set SelfArgs=%*
set "SelfExt=%~x0"
set "SelfBase=%~n0"
set "SelfName=%~nx0"
set "SelfFile=%~f0"
set "SelfDir=%~dp0"
set "SelfDir=%SelfDir:~0,-1%"
for %%i in ("%~dp0\.") do set "SelfDir=%%~fi"

:StartProcessing
call :SetExeList
call :SetHtmList
call :SetHomeSite
call :SetInstaller
call :SetErrorLevel 0
call :SelfTitle %SelfArgs%

:CheckOptions
if "%~1" == ""          ( call :Help %~n0    & goto :EOF )
if "%~1" == "/?"        ( call :Help %~n0    & goto :EOF )
if "%~1" == "-h"        ( call :Help %~n0    & goto :EOF )
if "%~1" == "--help"    ( call :Help %~n0    & goto :EOF )
if "%~1" == "--version" ( call :Version %~n0 & goto :EOF )

:ProcessOptions
set "arg=%~1"
set "isopt=0"
set "isarg=1"
if "%~1" == "" set "isarg=0"
if "%isarg%" == "1" if "%arg:~0,1%" == "-" set "isopt=1"
if "%isarg%" == "1" if "%arg:~0,1%" == "-" set "isarg=0"
if "%isopt%" == "1" if /i "%~1" == "--url"        ( shift & goto :Com0comUrl       )
if "%isopt%" == "1" if /i "%~1" == "--site"       ( shift & goto :Com0comSite      )
if "%isopt%" == "1" if /i "%~1" == "--index"      ( shift & goto :Com0comIndex     )
if "%isopt%" == "1" if /i "%~1" == "--locate"     ( shift & goto :Com0comLocate    )
if "%isopt%" == "1" if /i "%~1" == "--detect"     ( shift & goto :Com0comDetect    )
if "%isopt%" == "1" if /i "%~1" == "--setupc"     ( shift & goto :Com0comSetupc    )
if "%isopt%" == "1" if /i "%~1" == "--setupg"     ( shift & goto :Com0comSetupg    )
if "%isopt%" == "1" if /i "%~1" == "--signon"     ( shift & goto :Com0comSignOn    )
if "%isopt%" == "1" if /i "%~1" == "--installer"  ( shift & goto :Com0comInstaller )
if "%isopt%" == "1" if /i "%~1" == "--install"    ( shift & goto :Com0comInstall   )
if "%isopt%" == "1" if /i "%~1" == "--gui"        ( shift & goto :Com0comStartGui  )
if "%isarg%" == "1" if /i "%~1" == "setupc"       ( shift & goto :Com0comSetupc    )
if "%isarg%" == "1" if /i "%~1" == "setupg"       ( shift & goto :Com0comSetupg    )
if "%isarg%" == "1" if /i "%~1" == "setupc.exe"   ( shift & goto :Com0comSetupc    )
if "%isarg%" == "1" if /i "%~1" == "setupg.exe"   ( shift & goto :Com0comSetupg    )
if "%isarg%" == "1" for %%i in ( %exelist% ) do if /i "%~1" == "%%~nxi" goto :Com0comCallExe
if "%isarg%" == "1" for %%i in ( %exelist% ) do if /i "%~1" == "%%~ni"  goto :Com0comCallExe
if "%isarg%" == "1" for %%i in ( %htmlist% ) do if /i "%~1" == "%%i"    goto :Com0comOpenHtm
if "%isarg%" == "1" for %%i in ( %txtlist% ) do if /i "%~1" == "%%i"    goto :Com0comTypeTxt
if "%isarg%" == "1" ( call :PrintToStdErr "Error: invalid argument %~1" & exit /b 1 )
if "%isopt%" == "1" ( call :PrintToStdErr "Error: invalid option %~1" & exit /b 1 )
exit /b 0
goto :EOF

:Version
echo %~1 version 1.0
goto :EOF

:Help
call :Version %1
echo Copyright^(c^) 2021 Alexey Kuryakin kouriakinemail.ru
echo Tool to detect com0com and work with him anywhere
echo The com0com is open COM port emulator under GPL
echo See %HomeSite%
echo Usage :
echo  call %1 [options] [arguments] [arg]
echo Options:
echo  -h --help      to print help
echo  --version      to print version
echo  --url          to print  com0com home site
echo  --site         to browse com0com home site
echo  --index        to browse com0com index.html
echo  --detect       to detect com0com is installed
echo  --locate       to print install directory of com0com
echo  --setupg arg   to start com0com setup command with arg, gui version
echo  --setupc arg   to exec  com0com setup command with arg, console version
echo  --signon       to set bcdedit TESTSIGNING ON to enable unsigned exe on W10 x64
echo  --installer    to print com0com installer command
echo  --install      to call  com0com installer command
echo  --gui          to call  com0com GUI setup/control tool [ com0com.lm9 ]
echo Arguments:
echo  setupg arg     to start com0com setup command with arg, gui version
echo  setupc arg     to exec  com0com setup command with arg, console version
echo  command arg    to call command with arguments (arg), where command is one of:
echo                    [ com2tcp, hub4com, com2tcp-rfc2217, hub4com-multiplexer ]
echo  file.htm       to call help file, where file is one of: [ %htmlist% ]
echo  file.txt       to type help file, where file is one of: [ %txtlist% ]
echo Examples:
echo  call %1 --detect
echo  call %1 --locate
echo  call %1 --setupg
echo  call %1 --setupc list
echo  call %1 com0com.txt
echo  call %1 com0com.htm
echo  call %1 com2tcp --baud 115200 --data 8 --stop 1 --parity no --ignore-dsr \\.\COM3 localhost 1234
echo.
goto :EOF

:SelfTitle
if not defined SelfFile goto :EOF
if     "%SelfFile: =%" == "%SelfFile%" Title %SelfFile% %*
if not "%SelfFile: =%" == "%SelfFile%" Title "%SelfFile%" %*
goto :EOF

:SetExeList
set "exelist=com2tcp.exe hub4com.exe com2tcp.bat com2tcp-rfc2217.bat multiplexer.bat hub4com-multiplexer.bat"
goto :EOF

:SetHtmList
set "htmlist=com0com.htm com2tcp.htm hub4com.htm"
set "txtlist=com0com.txt com2tcp.txt hub4com.txt"
goto :EOF

:SetHomeSite
set "HomeSite=http://sourceforge.net/projects/com0com/"
goto :EOF

:SetInstaller
set "gui=?"
set "installer=?"
if defined CRW_DAQ_SYS_HOME_DIR call :TrySetInstaller "%CRW_DAQ_SYS_HOME_DIR%\Packages\com0com\InstallCom0com.cmd"
if defined installer if "%installer%" == "?" call :TrySetInstaller "%SelfDir%\..\..\Packages\com0com\InstallCom0com.cmd"
if defined installer if "%installer%" == "?" call :TrySetInstaller "%SelfDir%\..\..\..\..\Packages\com0com\InstallCom0com.cmd"
goto :EOF

:TrySetInstaller
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
if defined installer if not "%installer%" == "?" goto :EOF
for %%i in ("%~dp1.\add\bin\com0com.lm9") do if exist "%%~fi" set "gui=%%~fi"
set "installer=%~f1"
goto :EOF

:Com0comStartGui
if not defined gui goto :Com0comStartGuiErrorNotFound
if "%gui%" == "?"  goto :Com0comStartGuiErrorNotFound
if not defined CRW_DAQ_SYS_EXE_PID                              goto :Com0comStartGuiErrorParentCrw32
call unix lsps %CRW_DAQ_SYS_EXE_PID% 0 Crw32.exe 1>nul 2>nul || goto :Com0comStartGuiErrorParentCrw32
start "com0com GUI" "%gui%" %* && exit /b 0
exit /b 1
goto :EOF

:Com0comStartGuiErrorNotFound
call :PrintToStdErr "Error: GUI program [com0com.lm9] was not found"
exit /b 1
goto :EOF

:Com0comStartGuiErrorParentCrw32
call :PrintToStdErr "Error: parent Crw32.exe process was not found"
exit /b 1
goto :EOF

:Com0comCallExe
if "%~1" == "" exit /b 1
call :FileAvailInPath %1 || path %path%;%SelfDir%
call %* && exit /b 0
exit /b 1
goto :EOF

:Com0comUrl
if not defined HomeSite exit /b 1
echo %HomeSite%
goto :EOF

:Com0comSite
if not defined HomeSite exit /b 1
start "com0com site" %HomeSite% && exit /b 0
exit /b 1
goto :EOF

:Com0comIndex
start "com0com index" "%SelfDir%\..\c0c\index.html" && exit /b 0
exit /b 1
goto :EOF

:Com0comOpenHtm
start "com0com help" "%SelfDir%\..\man\%~1" && exit /b 0
exit /b 1
goto :EOF

:Com0comTypeTxt
type "%SelfDir%\..\man\%~1" && exit /b 0
exit /b 1
goto :EOF

:Com0comDetectDir
set "Com0comDir="
set "Com0comKey=HKEY_LOCAL_MACHINE\SOFTWARE\com0com"
if defined ProgramFiles call :RegQueryString Com0comDir "%Com0comKey%" Install_Dir
if defined ProgramW6432 call :RegQueryString Com0comDir "%Com0comKey%" Install_Dir /reg:32
if defined ProgramW6432 call :RegQueryString Com0comDir "%Com0comKey%" Install_Dir /reg:64
if not defined Com0comDir   ( call :PrintToStdErr "Error: com0com is not installed" & exit /b 1 )
if not exist "%Com0comDir%" ( call :PrintToStdErr "Error: com0com directory failed" & exit /b 1 )
exit /b 0
goto :EOF

:Com0comCheckFiles
for %%i in ( com0com.sys com0com.inf comport.inf cncport.inf setup.dll setupc.exe setupg.exe ) do ^
if not exist "%Com0comDir%\%%i"  ( call :PrintToStdErr "Error: file missed - %Com0comDir%\%%i" & exit /b 1 )
exit /b 0
goto :EOF

:Com0comLocate
call :Com0comDetectDir  || exit /b 1
call :Com0comCheckFiles || exit /b 1
echo %Com0comDir%
exit /b 0
goto :EOF

:Com0comDetect
call :Com0comDetectDir  || exit /b 1
call :Com0comCheckFiles || exit /b 1
echo com0com is installed
exit /b 0
goto :EOF

:Com0comSetupc
call :Com0comDetectDir  || exit /b 1
call :Com0comCheckFiles || exit /b 1
start "com0com - setupc" /b /wait /d "%Com0comDir%"  "%Com0comDir%\setupc.exe" %1 %2 %3 %4 %5 %6 %7 %8 %9 || ( call :PrintToStdErr "Error: %Com0comDir%\setupc.exe" & exit /b 1 )
call :SelfTitle %SelfArgs%
exit /b 0
goto :EOF

:Com0comSetupg
call :Com0comDetectDir  || exit /b 1
call :Com0comCheckFiles || exit /b 1
start "com0com - setupg" /d "%Com0comDir%" "%Com0comDir%\setupg.exe" %1 %2 %3 %4 %5 %6 %7 %8 %9 || ( call :PrintToStdErr "Error: %Com0comDir%\setupg.exe" & exit /b 1 )
call :SelfTitle %SelfArgs%
exit /b 0
goto :EOF

:Com0comSignOn
call :FileAvailInPath bcdedit.exe || ( echo Error: file not found - bcdedit.exe & exit /b 1 )
bcdedit -set loadoptions DISABLE_INTEGRITY_CHECKS
bcdedit -set TESTSIGNING ON
call :SelfTitle %SelfArgs%
goto :EOF

:Com0comInstaller
if not defined installer ( call :PrintToStdErr "Error: Installer was not found." & exit /b 1 )
if "%installer%" == "?"  ( call :PrintToStdErr "Error: Installer was not found." & exit /b 1 )
echo %installer%
goto :EOF

:Com0comInstall
if not defined installer ( call :PrintToStdErr "Error: Installer was not found." & exit /b 1 )
if "%installer%" == "?"  ( call :PrintToStdErr "Error: Installer was not found." & exit /b 1 )
call "%installer%" && exit /b 0
exit /b 1
goto :EOF

:FileAvailInPath
if "%~1" == "" exit /b 1
for %%i in ( %1 ) do if not "%%~$path:i" == "" if exist "%%~$path:i" exit /b 0
exit /b 1
goto :EOF

:RegQueryString
rem Usage = call :RegQuery Variable Key Name Option
for /F "tokens=1,2*" %%x in ('reg query "%~2" /v "%~3" %~4 2^> nul') do if /I "%%x" == "%~3" if /I "%%y" == "REG_SZ" set %~1=%%z
goto :EOF

:PrintToStdErr
if not "%~1" == "" echo %~1 1>&2
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF
