 {
 Demo terminal for pipe I/O
 }
program PipeSrv;
const
 dfTrouble      = 1;       { DebugFlags - Trouble             }
 dfSuccess      = 2;       { DebugFlags - Success             }
 dfViewExp      = 4;       { DebugFlags - ViewExp             }
 dfViewImp      = 8;       { DebugFlags - ViewImp             }
 Quantum        = 50;      { Max. time quantum                }
 UseTcp         = true;    { Use Tcp or Pipe for testing      }
 SimpleTest     = false;   { Use simple or complex test       }
 TcpOptions     = 'TxPipeSize 65536 RxPipeSize 65536 Options $60';
 LoWater        = 265;
 HiWater        = 8192;
var
 b              : Boolean;
 Ok             : Boolean;
 errors         : Integer;
 errorcode      : Integer;
 DebugFlags     : Integer;
 FixMaxAvail    : Integer;
 Pipe           : Integer;
 Buff           : String;
 Curr,Last      : record
  TimeTx        : Real;
  TimeRx        : Real;
  LineTx        : Real;
  LineRx        : Real;
  ByteRx        : Real;
  ByteTx        : Real;
  Echo          : Real;
 end;
 ms             : Real;
 i              : Integer;
 r              : Real;
 s              : String;
 {
 Analog of /dev/null for strings.
 }
 procedure sNul(s:String);
 begin
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Process standard input...
 while StdIn_Readln(StdIn_Line) do StdIn_Process(StdIn_Line);
 }
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:string):boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then Readln(Data);
  if IoError then Data:='';
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end; 
 {
 Read line (Line) from pipe (pip) with CR or LF line terminator (EOL).
 Temporary buffer (Buff) should be global lifetime variable with startup initialization.
 }
 function Pipe_Readln(pip:Integer; var Line,Buff:String):Boolean;
 const MaxLeng = 16384;
 var p:Integer;
 begin
  Line:='';
  Pipe_Readln:=false;
  if (Pipe_Pid(pip)<>0) then begin
   if (Length(Buff)<MaxLeng) and (Pipe_RxCount(pip)>0)
   then Buff:=Buff+Pipe_Recv(pip,MaxLeng-Length(Buff));
   p:=PosEol(Buff,1,0);
   if (p>0) then begin
    Pipe_Readln:=True;
    if (p>1) then Line:=Copy(Buff,1,p-1);
    Buff:=Copy(Buff,PosEol(Buff,p,1),MaxInt);
   end else begin
    if (Length(Buff)>=MaxLeng) then begin
     Trouble('Received line is too long!');
     Buff:='';
    end;
   end;
  end;
 end;
 {
 Send Data and EOL to pipe with error checking.
 }
 procedure Pipe_Writeln(pipe:Integer; Data:String);
 var Leng,Sent:Integer;
 begin
  Leng:=Length(Data);
  if Leng>0 then begin
   Sent:=pipe_send(pipe,Data+EOL);
   if Sent<Leng+Length(EOL) then Trouble('Pipe send error!');
  end;
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 var i:Integer;
 begin
  s:='';
  Buff:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(Data:string);
 var i:Integer;
 begin
  ViewImp(Data);
 end;
 {
 First time Pipe initialization
 }
 procedure PipeInit;
 begin
  Pipe:=0; Buff:='';
  Curr.TimeTx:=0; Last.TimeTx:=0;
  Curr.TimeRx:=0; Last.TimeRx:=0;
  Curr.LineTx:=0; Last.LineTx:=0;
  Curr.LineRx:=0; Last.LineRx:=0;
  Curr.ByteTx:=0; Last.ByteTx:=0;
  Curr.ByteRx:=0; Last.ByteRx:=0;
  Curr.Echo:=0;   Last.Echo:=0;
 end;
 {
 Pipe finalization
 }
 procedure PipeFree;
 var i:Integer;
 begin
  if Pipe<>0 then b:=pipe_free(Pipe); Pipe:=0; Buff:='';
 end;
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr(devname);
  DebugFlags:=15;
  OpenConsole(1);
  ClearStrings;
  Success('Starting...');
  PipeInit;
  //
  // Create named pipe server - test
  //
  //Pipe:=pipe_init('tcp port 1234 server 1');
  if IsSameText(devname,'&Pipe_Server') then begin 
   if UseTcp
   then Pipe:=pipe_init('tcp port 1234 server 1 '+TcpOptions)
   else Pipe:=pipe_init('pipe test');
  end else begin
   if UseTcp
   then Pipe:=pipe_init('tcp port 1234 client localhost '+TcpOptions)
   else Pipe:=pipe_init('pipe .\test');
  end;
  if pipe_run(Pipe)
  then Success('Run Pipe - Ok')
  else Trouble('Run Pipe - Fails');
  //
  if errors=0 then Success('Start Ok') else Trouble('Start Fails');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  PipeFree;
  Success('Stop');
  ClearStrings;
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  {
  Process standard input...
  }
  while StdIn_Readln(s) do StdIn_Process(s);
  {
  Benchmark Pipe data I/O
  }
  if SimpleTest then begin
   {
   Simple test: only data I/O
   }
   if pipe_connected(Pipe)>0 then
   for i:=0 to pipe_count(Pipe)-1 do begin
    ms:=msecnow;
    while msecnow-ms<Quantum do begin
     s:=pipe_recv(pipe_stream(Pipe,i),16384);
     if Length(s)>0 then Curr.ByteRx:=Curr.ByteRx+Length(s) else ms:=0;
    end;
    s:=Str(Curr.TimeTx)+','+Str(Curr.LineTx)+EOL;
    s:=s+s; s:=s+s; s:=s+s;
    ms:=msecnow;
    while msecnow-ms<Quantum do
    if (pipe_txspace(pipe_stream(Pipe,i))>LoWater) and
       (pipe_txcount(pipe_stream(Pipe,i))<HiWater)
    then begin
     Curr.TimeTx:=ms;
     if pipe_send(pipe_stream(Pipe,i),s)=Length(s) then begin
      Curr.ByteTx:=Curr.ByteTx+Length(s);
      Curr.LineTx:=Curr.LineTx+1;
     end else begin
      errors:=errors+1;
      ms:=0;
     end;
    end else ms:=0;
   end;
  end else begin
   {
   Complex test: data I/O and some data parsing/analysis
   }
   if pipe_connected(Pipe)>0 then
   for i:=0 to pipe_count(Pipe)-1 do begin
    ms:=msecnow;
    if pipe_rxcount(pipe_stream(Pipe,i))>0 then
    while msecnow-ms<Quantum do
    if Pipe_Readln(pipe_stream(Pipe,i),s,Buff) then begin
     Curr.ByteRx:=Curr.ByteRx+Length(s)+2;
     r:=rVal(ExtractWord(1,s)); if isNan(r) then errors:=errors+1;
     Curr.TimeRx:=r;
     r:=rVal(ExtractWord(2,s)); if isNan(r) then errors:=errors+1;
     if r-Curr.LineRx<>1 then if Last.LineRx<>0 then errors:=errors+1;
     Curr.LineRx:=r;
    end else ms:=0;
    ms:=msecnow;
    while msecnow-ms<Quantum do
    if (pipe_txspace(pipe_stream(Pipe,i))>LoWater) and
       (pipe_txcount(pipe_stream(Pipe,i))<HiWater)
    then begin
     Curr.TimeTx:=msecnow;
     s:=Str(Curr.TimeTx)+','+Str(Curr.LineTx)+EOL;
     if pipe_send(pipe_stream(Pipe,i),s)=Length(s) then begin
      Curr.ByteTx:=Curr.ByteTx+Length(s);
      Curr.LineTx:=Curr.LineTx+1;
     end else begin
      errors:=errors+1;
      ms:=0;
     end;
    end else ms:=0;
   end;
  end;
  //
  //
  //
  Curr.Echo:=msecnow;
  if Curr.Echo-Last.Echo>1000 then begin
   write(' Errors:',errors:5);
   write(' LineTx:',Curr.LineTx:10:0,' ',1000*(Curr.LineTx-Last.LineTx)/(Curr.Echo-Last.Echo):5:0,' msg/sec');
   write(' LineRx:',Curr.LineRx:10:0,' ',1000*(Curr.LineRx-Last.LineRx)/(Curr.Echo-Last.Echo):5:0,' msg/sec');
   write(' ByteTx:',Curr.ByteTx:10:0,' ',1.00*(Curr.ByteTx-Last.ByteTx)/(Curr.Echo-Last.Echo):7:2,' kbyte/sec');
   write(' ByteRx:',Curr.ByteRx:10:0,' ',1.00*(Curr.ByteRx-Last.ByteRx)/(Curr.Echo-Last.Echo):7:2,' kbyte/sec');
   writeln;
   Last.LineTx:=Curr.LineTx; Last.LineRx:=Curr.LineRx;
   Last.ByteTx:=Curr.ByteTx; Last.ByteRx:=Curr.ByteRx;
   Last.TimeTx:=Curr.TimeTx; Last.TimeRx:=Curr.TimeRx;
   Last.Echo:=Curr.Echo;
  end;
 end;
end.



