 {
 ***********************************************************************
 GENDC main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
 [@Help]
 |StdIn Command list: "@cmd=arg" or "@cmd arg"
 |********************************************************
 | @UpdateTag tag value   - Update tag value
 |********************************************************
 []
 }
program gendc_main_ctrl;       { GENDC main control program     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod = 1000;             { Polling period for smile face    }
 AwakePeriod = 100;              { Period of checks to awake DatSrv }

type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 TGENDCMainRec = record        { Main control & GUI               }
  CMD      : record              { CoMmandDs to control GUI         }
   HELP    : TTagRef;            { Open Help                        }
   HOME    : TTagRef;            { Exec Home                        }
   OPEN    : TTagRef;            { Open DAT file(s)                 }
   SAVE    : TTagRef;            { Save DAT file(s)                 }
   LOADINI : TTagRef;            { Load INI file                    }
   SAVEINI : TTagRef;            { Save INI file                    }
   TOOLS   : TTagRef;            { Tools menu                       }
   SOUND   : TTagRef;            { Sound menu                       }
   SMILE   : TTagRef;            { Smile menu                       }
   CLOSE   : TTagRef;            { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 GENDC     : record            { All GENDC data                 }
  MAIN       : TGENDCMainRec;  { Main control & GUI               }
  AwokeTime  : Real;             { Time when DatSrv last awoke      }
  DatSrvGate : TTagRef;          { Save data to DatSrv              }
 end;                            {                                  }
 cmd_UpdateTag : Integer;        { Command @UpdateTag               }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize GENDC.MAIN record tags
 }
 procedure TGENDCMainRec_Init(var Rec:TGENDCMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.HELP.tag,    TagPrefix+'.CMD.HELP',    1);
   InitTag(Rec.CMD.HOME.tag,    TagPrefix+'.CMD.HOME',    1);
   InitTag(Rec.CMD.OPEN.tag,    TagPrefix+'.CMD.OPEN',    1);
   InitTag(Rec.CMD.SAVE.tag,    TagPrefix+'.CMD.SAVE',    1);
   InitTag(Rec.CMD.LOADINI.tag, TagPrefix+'.CMD.LOADINI', 1);
   InitTag(Rec.CMD.SAVEINI.tag, TagPrefix+'.CMD.SAVEINI', 1);
   InitTag(Rec.CMD.TOOLS.tag,   TagPrefix+'.CMD.TOOLS',   1);
   InitTag(Rec.CMD.SOUND.tag,   TagPrefix+'.CMD.SOUND',   1);
   InitTag(Rec.CMD.SMILE.tag,   TagPrefix+'.CMD.SMILE',   1);
   InitTag(Rec.CMD.CLOSE.tag,   TagPrefix+'.CMD.CLOSE',   1);
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then
  ShowTooltip('guid '+Str(getpid)+'@'+ProgName+' text "'+s+'" preset stdHelp delay 15000'
  +' btn1 Справка cmd1 '+AnsiQuotedStr(GetEnv('WantedWebBrowser')+' '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'),QuoteMark));
 end;
 {
 Menu Close Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 530 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Close Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@UpdateTag '+NameTag(GENDC.MAIN.CMD.HELP.tag)+' 1');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@UpdateTag '+NameTag(GENDC.MAIN.CMD.LOADINI.tag)+' 1');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@UpdateTag '+NameTag(GENDC.MAIN.CMD.SAVEINI.tag)+' 1');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Tools Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  GENDC.AwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'  ');
 end;
 {
 GENDC clear strings
 }
 procedure GENDC_CLEAR;
 begin
 end;
 {
 GENDC initialization
 }
 procedure GENDC_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TGENDCMainRec_Init(GENDC.MAIN,ReadIni('tagGENDC')+'.MAIN');
  InitTag(gendc.DatSrvGate.tag,'DATSRV.GATE',-1);
  //
  // Initialize values...
  //
  GENDC.AwokeTime:=0;
 end;
 {
 GENDC finalization
 }
 procedure GENDC_FREE;
 begin
 end;
 {
 GENDC polling
 }
 procedure GENDC_POLL;
 var nerrors:Real; ClickCurve,i:Integer;
 begin
  {
  Awake DatSrv to enforce data save.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then begin
   bNul(iSetTag(GENDC.DatSrvGate.tag,Ord(iGetTag(GENDC.MAIN.CMD.SAVE.tag)<>0)));
  end;
  {
  Execute GUI commands
  }
  if iGetTag(GENDC.MAIN.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
   bNul(iSetTag(GENDC.MAIN.CMD.HELP.tag,0));
  end;
  if iGetTag(GENDC.MAIN.CMD.HOME.tag)<>0 then begin
   Cron('@cron.run GENDC.MAIN.CTRL.HOME');
   bNul(iSetTag(GENDC.MAIN.CMD.HOME.tag,0));
  end;
  if iGetTag(GENDC.MAIN.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '
   +URL_Packed(AddBackSlash(DaqFileRef(AdaptFileName(ReadIni('['+DatSrv+'] DataPath')),''))+'*.dat;*.crw'));
   bNul(iSetTag(GENDC.MAIN.CMD.OPEN.tag,0));
  end;
  if iGetTag(GENDC.MAIN.CMD.LOADINI.tag)<>0 then begin
   bNul(iSetTag(GENDC.MAIN.CMD.LOADINI.tag,0));
   DevPostCmdLocal('@LoadIni');
  end;
  if iGetTag(GENDC.MAIN.CMD.SAVEINI.tag)<>0 then begin
   bNul(iSetTag(GENDC.MAIN.CMD.SAVEINI.tag,0));
   DevPostCmdLocal('@SaveIni');
  end;
  if iGetTag(GENDC.MAIN.CMD.TOOLS.tag)<>0 then begin
   bNul(iSetTag(GENDC.MAIN.CMD.TOOLS.tag,0));
   MenuToolsStarter;
  end;
  if iGetTag(GENDC.MAIN.CMD.CLOSE.tag)<>0 then begin
   bNul(iSetTag(GENDC.MAIN.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile button state
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   nerrors:=GetErrCount(-2);
   if nerrors>GENDC.MAIN.CMD.SMILE.val then bNul(iSetTag(GENDC.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(GENDC.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(GENDC.MAIN.CMD.SMILE.tag,1));
   GENDC.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Menu TOOLS.
   }
   MenuToolsHandler;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,KeyUp)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(GENDC.MAIN.CMD.HELP.tag,1);
     ClickBitXorLocal(GENDC.MAIN.CMD.HOME.tag,1);
     ClickBitXorLocal(GENDC.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(GENDC.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(GENDC.MAIN.CMD.LOADINI.tag,1);
     ClickBitXorLocal(GENDC.MAIN.CMD.SAVEINI.tag,1);
     ClickBitXorLocal(GENDC.MAIN.CMD.TOOLS.tag,1);
     ClickBitXorLocal(GENDC.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(GENDC.MAIN.CMD.CLOSE.tag,1);
     if ClickTag=GENDC.MAIN.CMD.SAVE.tag then begin
      bNul(iSetTag(GENDC.DatSrvGate.tag,Ord(iGetTag(GENDC.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(GENDC.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     //
     // Smile face button...
     //
     if ClickTag=GENDC.MAIN.CMD.SMILE.tag then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(GENDC.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
     //
     // GENx.CTRL sensors
     //
     if IsSameText(Copy(ClickSensor,1,3),'GEN') then
     if IsSameText(ExtractFileExt(ClickSensor),'.CTRL') then begin
      i:=0;
      while i<MaxInt do begin
       if IsEmptyStr(ParamStr('CIRWINNAME '+Str(i))) then i:=MaxInt else
       if Pos(UpcaseStr(ClickSensor),UpcaseStr(ParamStr('CIRWINNAME '+Str(i))))>0 then begin
        Cron('@WinSelect '+ParamStr('CIRWINNAME '+Str(i)));
        bNul(Voice(snd_Wheel));
        i:=MaxInt;
       end else i:=i+1;
      end;
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  GENDC_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  GENDC_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmdLocal('@LoadIni');
  cmd_UpdateTag:=RegisterStdInCmd('@UpdateTag','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmdLocal('@SaveIni');
  GENDC_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GENDC_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; tag:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @UpdateTag MAIN.CMD.CLOSE 1
   }
   if (cmdid=cmd_UpdateTag) then begin
    if (WordCount(arg)>1) then begin
     tag:=FindTag(ExtractWord(1,arg));
     if (TypeTag(tag)>0) then UpdateTag(tag,SkipWords(1,arg),-_inf,+_inf);
    end;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
