 {
 ***********************************************************************
 Daq Pascal application program birger_drv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Poll arg      - Enable/Disable poll, arg= 0 or 1 (0 - OFF Poll, 1 - ON Poll).
| @DimTagUpdate  - Dim Tag Update.
| @DIMCMDMY arg - Dim My Command, arg = @cmd in base64 code
| @MoveApInc arg - Move Aperture Incremental (arg=increment).
| @MoveApAbs arg - Move Aperture to Absolute position (arg=position).
| @MoveApOpn     - Move aperture to open position.
| @MoveApCls     - Move aperture to close position.
| @MenuTools     - Open Menu Tools
| @MenuApSel     - Open Menu Aperture Selection
| @ReInit        - Execute ReInitialization Lens
| @ErrorClear    - Error Clear Device
|********************************************************
[]
 }
program birger_drv;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {$I _con_NetLibrary}            { NetLibrary constants             }
 {------------------------------}{ And add User defined constants:  }
 st_NoReq     = 0;               { State : No request sent          }
 st_WaitAns   = 1;               { State : Waiting answer           }
 st_WaitGap   = 2;               { State : Waiting time gap         }
 st_TimeOut   = 3;               { State : TimeOut found            }
 stt_Disabled = 0;               { Status : Device is OFF           }
 stt_Work     = 1;               { Status : Device is Work          }
 stt_LensDisc = 2;               { Status : Lens Disconnected       }
 stt_Timeout  = 3;               { Status : Timeout                 }
 stt_Warning  = 4;               { Status : Warning                 }
 stt_Refused  = 5;               { Status : Refused                 }
 stt_Simulat  = 6;               { Status : Simulation mode         }
 ao_AperNum   = 0;               { AO: Aperture Number              }
 do_RX        = 0;               { DO: RX                           }
 do_TX        = 1;               { DO: TX                           }
 do_AperStep  = 2;               { DO: Apertur Step                 }
 do_FocusMin  = 3;               { DO: Focus Minimal                }
 do_FocusMax  = 4;               { DO: Focus Maximal                }
 do_FocusCur  = 5;               { DO: Current Focus                }
 do_FocusStep = 6;               { DO: Focus Steper                 }
 do_Status    = 7;               { DO: Device Status                }
 do_Error     = 8;               { DO: Error messege                }
 cm_ll        = 1;               { CMD ID: Test Command             }
 cm_rm        = 2;               { CMD ID: Mode answer              }
 cm_sr        = 3;               { CMD ID: Spontaneous answer is off}
 cm_in        = 4;               { CMD ID: Initialize aperture      }
 cm_sn        = 5;               { CMD ID: Device serial number     }
 cm_bv        = 6;               { CMD ID: Bootloader version       }
 cm_hv        = 7;               { CMD ID: HardWare version         }
 cm_vs        = 8;               { CMD ID: Library version          }
 cm_id        = 9;               { CMD ID: Lens Identification      }
 cm_da        = 10;              { CMD ID: Define Aperture          }
 cm_dz        = 11;              { CMD ID: Define Zoom              }
 cm_lp        = 12;              { CMD ID: Lens Presence            }
 cm_pf        = 13;              { CMD ID: Print Focus Position     }
 cm_fd        = 14;              { CMD ID: Focus Distance           }
 cm_pa        = 15;              { CMD ID: Print Aperture           }
 cm_fp        = 16;              { CMD ID: Full Focus Position      }
 cm_ma        = 17;              { CMD ID: Move Aperture absolute   }
 cm_mn        = 18;              { CMD ID: Move Aperture incremental}
 cm_mo        = 19;              { CMD ID: Move aperture to open    }
 cm_mc        = 20;              { CMD ID: Move aperture to close   }
 MaxCmdNum    = 20;              { Max commands id number           }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {$I _var_NetLibrary}            { NetLibrary variables             }
 {------------------------------}{ And add User defined variables:  }
 cmd_Poll         : Integer;     { Device Command @Poll             }
 cmd_DimTagUpdate : Integer;     { System Command @DimTagUpdate     }
 cmd_DimCmdMy     : Integer;     { System Command @DIMCMDMY        }
 cmd_MoveApInc    : Integer;     { Device Command @MoveApInc        }
 cmd_MoveApAbs    : Integer;     { Device Command @MoveApAbs        }
 cmd_MoveApOpn    : Integer;     { Device Command @MoveApOpn        }
 cmd_MoveApCls    : Integer;     { Device Command @MoveApCls        }
 cmd_MenuTools    : Integer;     { Device Command @MenuTools        }
 cmd_MenuApSel    : Integer;     { Device Command @MenuApSel        }
 cmd_ReInit       : Integer;     { Device Command @ReInit           }
 cmd_ErrorClear   : Integer;     { Device Command @ErrorClear       }
 ConCmdNum        : Integer;
 BIRGER           : record
  Simulator        : Boolean;    { Simulator mode                   }
  SimAperCur       : String;     { Current Aperture for Sim mode    }
  CMDID            : Integer;
  Work             : Boolean;
  APEROPEN         : TTagRef;    { CMD Tag: Move Aperture to Open   }
  APERCLOSE        : TTagRef;    { CMD Tag: Move Aperture to Close  }
  APERINCR         : TTagRef;    { CMD Tag: Move Aperture Increment }
  APERDECR         : TTagRef;    { CMD Tag: Move Aperture Decrement }
  APERRANGE        : TTagRef;    { Info Tag: Aperture Range         }
  APERNUM          : TTagRef;    { Info Tag: Current Aperture Num   }
  APERSTEP         : TTagRef;    { Info Tag: Current Aperture Step  }
  APERSET          : TTagRef;    { Param Tag: Aperture Set          }
  FOCUSZERO        : TTagRef;    { CMD Tag: Move Focus to Zero      }
  FOCUSINF         : TTagRef;    { CMD Tag: Move Focus to Inf       }
  FOCUSINCR        : TTagRef;    { CMD Tag: Move Focus Incremental  }
  FOCUSDECR        : TTagRef;    { CMD Tag: Move Focus Decremental  }
  FOCUSSTEP        : TTagRef;    { Param Tag: Steps for Move Focus  }
  FOCUSCUR         : TTagRef;    { Info Tag: Current Focus          }
  FOCUSDIST        : TTagRef;    { Info Tag: Distance Focus         }
  FOCUSMIN         : TTagRef;    { Info Tag: Minimal Focus          }
  FOCUSMAX         : TTagRef;    { Info Tag: Maximal Focus          }
  LENS_PRES        : TTagRef;    { Info Tag: Lens Presence          }
  LENS_ZOOMRANGE   : TTagRef;    { Info Tag: Zoom Range             }
  LENS_CONFIGCUR   : TTagRef;    { Info Tag: Current Configuration  }
  SERNUM           : TTagRef;    { Info Tag: Serial Number of device}
  LIBVER           : TTagRef;    { Info Tag: Library version        }
  BOOTVER          : TTagRef;    { Info Tag: Bootloader version     }
  HWVER            : TTagRef;    { Info Tag: Hardware version       }
  RX               : TTagRef;    { Info Tag: RX                     }
  TX               : TTagRef;    { Info Tag: TX                     }
  POLLEN           : TTagRef;    { CMD Tag: Poll Enable             }
  STATUS           : TTagRef;    { Info Tag: Status of device       }
  ERROR            : TTagRef;    { Info Tag: Error messege          }
  REINIT           : TTagRef;    { Reinitialization device          }
  SERVMODE         : TTagRef;    { Is DIM Server Mode?              }
  ModeConnect      : String;     { Connection Mode: TCP or COM      }
  Pipe             : record      { Comunication data                }
   ComPort          :String;     { COM port                         }
   BaudRate         :String;     { BaudRate                         }
   Parity           :String;     { Parity                           }
   DataBits         :String;     { DataBits                         }
   StopBits         :String;     { StopBits                         }
   TcpPort          :String;     { TCP Port                         }
   ClientIP         :String;     { IP of device                     }
   Polling          :String;     { Pipe Polling                     }
   Priority         :String;     { Pipe Priority                    }
   TxSize           :String;     { Pipe Tx Buffer Size              }
   RxSize           :String;     { Pipe Rx Buffer Size              }
   TimeOut          :String;     { Pipe TimeOut                     }
   PipeID           : Integer;   { PIPE ID                          }
   PipeSIM          : Integer;   { Local PIPE for Simulation        }
   Req,Ans,Buf      : String;    { Request, Answer                  }
   ReqTime,AnsTime  : Real;      { Request, Answer time, ms         }
   CntTimeOut       : Integer;   { Count Timeouts                   }
   RX,TX            : Integer;   { Reciver, Transmitter rate        }
  end;
  Cmd             : record       { Table of command for Smart-UPS   }
   Status         : Integer;     { CmdCycle Status flag             }
   Num            : Integer;     { Current Number of command        }
   Timeout        : Integer;
   Argument       : String;
   Enable         : array [1..MaxCmdNum] of Boolean;{ En/Dis cmd    }
   Acronym        : array [1..MaxCmdNum] of String; { ASCII symbol  }
   StartCmd       : array [1..MaxCmdNum] of Boolean;{ StartUp cmd   }
   ArgCmd         : array [1..MaxCmdNum] of Boolean;{ Arg cmd       }
  end;
 end;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {$I _fun_NetLibrary}            { NetLibrary functions             }
 {------------------------------}{ And add User defined functions:  }

 {
 Birger Clear Strings
 }
 Procedure BIRGER_ClearStrings;
 var i:Integer;
 begin
  BIRGER.SimAperCur   :='';
  BIRGER.Pipe.ComPort :='';
  BIRGER.Pipe.BaudRate:='';
  BIRGER.Pipe.Parity  :='';
  BIRGER.Pipe.DataBits:='';
  BIRGER.Pipe.StopBits:='';
  BIRGER.Pipe.TcpPort :='';
  BIRGER.Pipe.ClientIP:='';
  BIRGER.Pipe.Polling :='';
  BIRGER.Pipe.Priority:='';
  BIRGER.Pipe.TxSize  :='';
  BIRGER.Pipe.RxSize  :='';
  BIRGER.Pipe.TimeOut :='';
  BIRGER.Pipe.Req     :='';
  BIRGER.Pipe.Ans     :='';
  BIRGER.Pipe.Buf     :='';
  BIRGER.Cmd.Argument :='';
  if BIRGER.Pipe.PipeID<>0 then begin
   bNul(pipe_txclear(BIRGER.Pipe.PipeID));
   bNul(pipe_rxclear(BIRGER.Pipe.PipeID));
  end;
  if BIRGER.Pipe.PipeSIM<>0 then begin
   bNul(pipe_txclear(BIRGER.Pipe.PipeSIM));
   bNul(pipe_rxclear(BIRGER.Pipe.PipeSIM));
  end;
  for i:=1 to MaxCmdNum do begin
   BIRGER.Cmd.Acronym[i]:='';
  end;
 end;
 {
 Birger Clear CMD Table
 }
 Procedure BIRGER_ClearCmdTab;
 var i:Integer;
 begin
  for i:=1 to MaxCmdNum do begin
   BIRGER.Cmd.Enable[i]:=false;
  end;
 end;
 {
 Check command number is valid.
 }
 function IsValidCmdNum(n:Integer):Boolean;
 begin
  IsValidCmdNum:=(n>=1) and (n<=MaxCmdNum);
 end;
 {
 Enable/disable command n.
 }
 procedure EnableCmdNum(n:Integer; Enable:Boolean);
 begin
  if IsValidCmdNum(n) then BIRGER.Cmd.Enable[n]:=Enable;
 end;
 {
 Check if command (n) is query
 }
 function IsQueryCmdNum(n:Integer):Boolean;
 begin
  if IsValidCmdNum(n)
  then IsQueryCmdNum:=true
  else IsQueryCmdNum:=false;
 end;
 {
 Validate Command
 }
 function ValidateCmdNum(Num:Integer):Integer;
 begin
  if IsValidCmdNum(Num)
  then ValidateCmdNum:=Num
  else ValidateCmdNum:=1;
 end;
 {
 Clear Request
 }
 procedure ClearRequest(Num,Status:Integer);
 begin
  BIRGER.Pipe.Ans:='';
  BIRGER.Pipe.Buf:='';
  BIRGER.Pipe.ReqTime:=0;
  BIRGER.Pipe.AnsTime:=0;
  BIRGER.Cmd.Status:=Status;
  BIRGER.Cmd.Num:=ValidateCmdNum(Num);
  if BIRGER.Pipe.PipeID<>0 then begin
   bNul(pipe_txclear(BIRGER.Pipe.PipeID));
   bNul(pipe_rxclear(BIRGER.Pipe.PipeID));
  end;
  if BIRGER.Pipe.PipeSIM<>0 then begin
   bNul(pipe_txclear(BIRGER.Pipe.PipeSIM));
   bNul(pipe_rxclear(BIRGER.Pipe.PipeSIM));
  end;
 end;
 {
 BIRGER tag Initialization
 }
 procedure BIRGER_FillTags(InitVal:Real);
 begin
  BIRGER.APEROPEN.val      :=InitVal;
  BIRGER.APERCLOSE.val     :=InitVal;
  BIRGER.APERINCR.val      :=InitVal;
  BIRGER.APERDECR.val      :=InitVal;
  BIRGER.APERRANGE.val     :=InitVal;
  BIRGER.APERNUM.val       :=InitVal;
  BIRGER.APERSTEP.val      :=InitVal;
  BIRGER.APERSET.val       :=InitVal;
  BIRGER.FOCUSZERO.val     :=InitVal;
  BIRGER.FOCUSINF.val      :=InitVal;
  BIRGER.FOCUSINCR.val     :=InitVal;
  BIRGER.FOCUSDECR.val     :=InitVal;
  BIRGER.FOCUSSTEP.val     :=InitVal;
  BIRGER.FOCUSCUR.val      :=InitVal;
  BIRGER.FOCUSDIST.val     :=InitVal;
  BIRGER.FOCUSMIN.val      :=InitVal;
  BIRGER.FOCUSMAX.val      :=InitVal;
  BIRGER.LENS_PRES.val     :=InitVal;
  BIRGER.LENS_ZOOMRANGE.val:=InitVal;
  BIRGER.LENS_CONFIGCUR.val:=InitVal;
  BIRGER.SERNUM.val        :=InitVal;
  BIRGER.LIBVER.val        :=InitVal;
  BIRGER.BOOTVER.val       :=InitVal;
  BIRGER.HWVER.val         :=InitVal;
  BIRGER.RX.val            :=InitVal;
  BIRGER.TX.val            :=InitVal;
  BIRGER.POLLEN.val        :=InitVal;
  BIRGER.STATUS.val        :=InitVal;
  BIRGER.ERROR.val         :=InitVal;
  BIRGER.REINIT.val        :=InitVal;
 end;
 procedure BIRGER_InitTags(Prefix:String; InitVal:Real);
 begin
  if not IsEmptyStr(Prefix) then begin
   DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
   InitTag(BIRGER.APEROPEN.tag      ,Prefix+'.APEROPEN'      ,1);
   InitTag(BIRGER.APERCLOSE.tag     ,Prefix+'.APERCLOSE'     ,1);
   InitTag(BIRGER.APERINCR.tag      ,Prefix+'.APERINCR'      ,1);
   InitTag(BIRGER.APERDECR.tag      ,Prefix+'.APERDECR'      ,1);
   InitTag(BIRGER.APERRANGE.tag     ,Prefix+'.APERRANGE'     ,3);
   InitTag(BIRGER.APERNUM.tag       ,Prefix+'.APERNUM'       ,2);
   InitTag(BIRGER.APERSTEP.tag      ,Prefix+'.APERSTEP'      ,2);
   InitTag(BIRGER.APERSET.tag       ,Prefix+'.APERSET'       ,3);
   InitTag(BIRGER.FOCUSZERO.tag     ,Prefix+'.FOCUSZERO'     ,1);
   InitTag(BIRGER.FOCUSINF.tag      ,Prefix+'.FOCUSINF'      ,1);
   InitTag(BIRGER.FOCUSINCR.tag     ,Prefix+'.FOCUSINCR'     ,1);
   InitTag(BIRGER.FOCUSDECR.tag     ,Prefix+'.FOCUSDECR'     ,1);
   InitTag(BIRGER.FOCUSSTEP.tag     ,Prefix+'.FOCUSSTEP'     ,2);
   InitTag(BIRGER.FOCUSCUR.tag      ,Prefix+'.FOCUSCUR'      ,2);
   InitTag(BIRGER.FOCUSDIST.tag     ,Prefix+'.FOCUSDIST'     ,3);
   InitTag(BIRGER.FOCUSMIN.tag      ,Prefix+'.FOCUSMIN'      ,2);
   InitTag(BIRGER.FOCUSMAX.tag      ,Prefix+'.FOCUSMAX'      ,2);
   InitTag(BIRGER.LENS_PRES.tag     ,Prefix+'.LENS.PRES'     ,1);
   InitTag(BIRGER.LENS_ZOOMRANGE.tag,Prefix+'.LENS.ZOOMRANGE',3);
   InitTag(BIRGER.LENS_CONFIGCUR.tag,Prefix+'.LENS.CONFIGCUR',3);
   InitTag(BIRGER.SERNUM.tag        ,Prefix+'.SERNUM'        ,3);
   InitTag(BIRGER.LIBVER.tag        ,Prefix+'.LIBVER'        ,3);
   InitTag(BIRGER.BOOTVER.tag       ,Prefix+'.BOOTVER'       ,3);
   InitTag(BIRGER.HWVER.tag         ,Prefix+'.HWVER'         ,3);
   InitTag(BIRGER.RX.tag            ,Prefix+'.RX'            ,2);
   InitTag(BIRGER.TX.tag            ,Prefix+'.TX'            ,2);
   InitTag(BIRGER.POLLEN.tag        ,Prefix+'.POLLEN'        ,1);
   InitTag(BIRGER.STATUS.tag        ,Prefix+'.STATUS'        ,2);
   InitTag(BIRGER.ERROR.tag         ,Prefix+'.ERROR'         ,2);
   InitTag(BIRGER.REINIT.tag        ,Prefix+'.REINIT'        ,1);
   InitTag(BIRGER.SERVMODE.tag      ,Prefix+'.SERVMODE'      ,1);
   BIRGER_FillTags(InitVal);
  end;
 end;
 {
 Initialization Command Table
 }
 procedure BIRGER_InitCmdTab;
  procedure AddCmd(num,enb:Integer; acr:String; start,argcmd:Integer);
  begin
   if IsValidCmdNum(num) then begin
    BIRGER.Cmd.Enable[num]:=enb>0;
    BIRGER.Cmd.Acronym[num]:=acr;
    BIRGER.Cmd.StartCmd[num]:=start>0;
    BIRGER.Cmd.ArgCmd[num]:=argcmd>0;
   end;
  end;
 begin
  BIRGER.Cmd.Num:=1;
  AddCmd(cm_ll, 0, 'll'   ,1,0); { 1  - Test Command for StartUp        }
  AddCmd(cm_rm, 0, 'rm0,1',1,0); { 2  - Mode Answer for StartUp         }
  AddCmd(cm_sr, 0, 'sr0'  ,1,0); { 3  - Mode Answer for StartUp         }
  AddCmd(cm_in, 0, 'in'   ,1,0); { 4  - Initialize Aperture for StartUp }
  AddCmd(cm_sn, 0, 'sn'   ,1,0); { 5  - Serial Number for StartUp       }
  AddCmd(cm_bv, 0, 'bv'   ,1,0); { 6  - Bootloader  Version for StartUp }
  AddCmd(cm_hv, 0, 'hv'   ,1,0); { 7  - HardWare Version for StartUp    }
  AddCmd(cm_vs, 0, 'vs'   ,1,0); { 8  - Library Version for StartUp     }
  AddCmd(cm_id, 1, 'id'   ,1,0); { 9  - Lens Identification             }
  AddCmd(cm_da, 1, 'da'   ,1,0); { 10 - Define Aperture for Regular     }
  AddCmd(cm_dz, 1, 'dz'   ,1,0); { 11 - Define Zoom for Regular         }
  AddCmd(cm_lp, 1, 'lp'   ,1,0); { 12 - Lens Presence for Regular       }
  AddCmd(cm_pf, 0, 'pf'   ,0,0); { 13 - Print Focus for Something       }
  AddCmd(cm_fd, 1, 'fd'   ,0,0); { 14 - Print Focus Distance for Regular}
  AddCmd(cm_pa, 1, 'pa'   ,0,0); { 15 - Print Aperture for Regular      }
  AddCmd(cm_fp, 1, 'fp'   ,0,0); { 16 - Print Focus for Regular         }
  AddCmd(cm_ma, 0, 'ma'   ,0,1); { 17 - Move Aperture to Absolute       }
  AddCmd(cm_mn, 0, 'mn'   ,0,1); { 18 - Move Aperture Incremental       }
  AddCmd(cm_mo, 0, 'mo'   ,0,0); { 19 - Move Aperture to Open           }
  AddCmd(cm_mc, 0, 'mc'   ,0,0); { 20 - Move Aperture to Close          }
 end;
 {
 Pipe connection for BIRGER
 }
 Function BIRGER_PipeConnect:Boolean;
 var sPID,sPSIM:String;
 begin
  BIRGER_PipeConnect:=false;
  sPID:='';
  sPSIM:='';
  if BIRGER.Simulator then begin
   //Pipe connection for simulation
   BIRGER.Pipe.PipeID:=Pipe_Init('pipe '+ReadIni('tagPrefix'));
   BIRGER.Pipe.PipeSIM:=Pipe_Init('pipe .\'+ReadIni('tagPrefix'));
   BIRGER_PipeConnect:=(Pipe_Run(BIRGER.Pipe.PipeID) and Pipe_Run(BIRGER.Pipe.PipeSIM));
   sPID:=str(BIRGER.Pipe.PipeID);
   sPSIM:=str(BIRGER.Pipe.PipeSIM);
   Details('BIRGER.Pipe.PipeID = '+sPID);
   Details('BIRGER.Pipe.PipeSIM = '+sPSIM);
  end else begin
   //Pipe connection for device control by COM connection
   if BIRGER.ModeConnect='COM' then begin
    BIRGER.Pipe.ComPort :=ReadIni('ComPort');
    BIRGER.Pipe.Baudrate:=ReadIni('Baudrate');
    BIRGER.Pipe.Parity  :=ReadIni('Parity');
    BIRGER.Pipe.DataBits:=ReadIni('DataBits');
    BIRGER.Pipe.StopBits:=ReadIni('StopBits');
    BIRGER.Pipe.PipeID:=Pipe_Init('com port '+BIRGER.Pipe.ComPort+' baudrate '+BIRGER.Pipe.Baudrate+
    ' parity '+BIRGER.Pipe.Parity+' databits '+BIRGER.Pipe.DataBits+' stopbits '+BIRGER.Pipe.StopBits);
    bNul(Pipe_Run(BIRGER.Pipe.PipeID));
    BIRGER_PipeConnect:=Pipe_Connected(BIRGER.Pipe.PipeID)>0;
    sPID:=str(BIRGER.Pipe.PipeID);
    Details('BIRGER.Pipe.PipeID = '+sPID);
   end else
   //Pipe connection for device control by TCP connection
   if BIRGER.ModeConnect='TCP' then begin
    BIRGER.Pipe.TcpPort :=ReadIni('TcpPort');
    BIRGER.Pipe.ClientIP:=ReadIni('ClientIP');
    BIRGER.Pipe.Polling :=ReadIni('PipePolling');
    BIRGER.Pipe.Priority:=ReadIni('PipePriority');
    BIRGER.Pipe.TxSize  :=ReadIni('TxPipeSize');
    BIRGER.Pipe.RxSize  :=ReadIni('RxPipeSize');
    BIRGER.Pipe.Timeout :=ReadIni('PipeTimeout');
    BIRGER.Pipe.PipeID:=Pipe_Init('Tcp Port '+BIRGER.Pipe.TcpPort+' Client '+BIRGER.Pipe.ClientIP+
    ' Polling '+BIRGER.Pipe.Polling+' Priority '+BIRGER.Pipe.Priority+
    ' TxSize '+BIRGER.Pipe.TxSize+' RxPipeSize '+BIRGER.Pipe.RxSize+
    ' Timeout '+BIRGER.Pipe.Timeout);
    bNul(Pipe_Run(BIRGER.Pipe.PipeID));
    BIRGER_PipeConnect:=Pipe_Ref(BIRGER.Pipe.PipeID)>0;
    sPID:=str(BIRGER.Pipe.PipeID);
    Details('BIRGER.Pipe.PipeID = '+sPID);
   end else Trouble('Connection type not supported');
  end;
  sPID:='';
  sPSIM:='';
 end;
 {
 Pipe free for finalization application
 }
 Procedure BIRGER_PipeFree;
 begin
  if BIRGER.Pipe.PipeID<>0 then begin
    bNul(pipe_txclear(BIRGER.Pipe.PipeID));
    bNul(pipe_rxclear(BIRGER.Pipe.PipeID));
   end;
   if BIRGER.Pipe.PipeSIM<>0 then begin
    bNul(pipe_txclear(BIRGER.Pipe.PipeSIM));
    bNul(pipe_rxclear(BIRGER.Pipe.PipeSIM));
  end;
  bNul(pipe_free(BIRGER.Pipe.PipeID));
  bNul(pipe_free(BIRGER.Pipe.PipeSIM));
 end;
 {
 Decoding data BIRGER
 }
 function DecodeData(n:Integer; data:String):boolean;
 var valdata,pos1,pos2,pos3:integer; rvaldata,numap,stepap:real; decode:boolean;
  procedure InvalidAnswer(n:Integer; data:String);
  begin
   Trouble('Invalid answer on command '+BIRGER.Cmd.Acronym[n]+'.Answer: '+data);
  end;
  function ErrorAnswer(n:Integer; data:String):boolean;
  var err:boolean; i:integer;
  begin
   err:=false;
   if copy(data,1,3)='ERR' then begin
    i:=val(copy(data,4,length(data)));
    bNul(rSetTag(BIRGER.ERROR.tag,i));
    UpdateDo(do_Error,time,rGetTag(BIRGER.ERROR.tag));
    Trouble('Error from command '+BIRGER.Cmd.Acronym[n]);
    err:=true;
   end;
  ErrorAnswer:=err;
  end;
 begin
  decode:=false;
  if not isEmptyStr(data) then begin
   if not ErrorAnswer(n,data) then begin
    if n=cm_ll then
     begin
      if data='OK' then begin
       Success('Library is loaded. May work.');
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_rm then
     begin
      if data='OK' then begin
       Success('Mode answer is OK. May work.');
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_sr then
     begin
      if data='OK' then begin
       Success('Spontaneous answer is off');
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_in then
     begin
      if data='DONE' then begin
       Success('Aperture initializated');
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_sn then
     begin
      bNul(sSetTag(BIRGER.SERNUM.tag,data));
      decode:=true;
     end else
    if n=cm_bv then
     begin
      bNul(sSetTag(BIRGER.BOOTVER.tag,data));
      decode:=true;
     end else
    if n=cm_hv then
     begin
      bNul(sSetTag(BIRGER.HWVER.tag,data));
      decode:=true;
     end else
    if n=cm_vs then
     begin
      bNul(sSetTag(BIRGER.LIBVER.tag,data));
      decode:=true;
     end else
    if n=cm_id then
     begin
      bNul(sSetTag(BIRGER.LENS_CONFIGCUR.tag,data));
      decode:=true;
     end else
    if n=cm_da then
     begin
      bNul(sSetTag(BIRGER.APERRANGE.tag,data));
      decode:=true;
     end else
    if n=cm_dz then
     begin
      bNul(sSetTag(BIRGER.LENS_ZOOMRANGE.tag,data));
      decode:=true;
     end else
    if n=cm_lp then
     begin
      valdata:=iValDef(data,2);
      if (valdata<>0) and (valdata<>1) then begin
       InvalidAnswer(n,data);
      end else begin
       bNul(iSetTag(BIRGER.LENS_PRES.tag,valdata));
       if valdata=0 then begin
       end;
       decode:=true;
      end;
     end else
    if n=cm_pf then
     begin
      rvaldata:=rval(data);
      if not isNan(rvaldata) then begin
       bNul(rSetTag(BIRGER.FOCUSCUR.tag,rvaldata));
       UpdateDo(do_FocusCur,time,rvaldata);
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_fd then
     begin
      bNul(sSetTag(BIRGER.FOCUSDIST.tag,data));
      decode:=true;
     end else
    if n=cm_pa then
     begin
      pos1:=pos(',',data);
      pos2:=pos('f',data);
      if pos2=pos1+1 then begin
       stepap:=rval(copy(data,1,pos1-1));
       numap:=rval(copy(data,pos2+1,length(data)));
       numap:=numap/10;
       bNul(rSetTag(BIRGER.APERSTEP.tag,stepap));
       UpdateDo(do_AperStep,time,stepap);
       bNul(rSetTag(BIRGER.APERNUM.tag,numap));
       UpdateAo(ao_AperNum,time,numap);
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_fp then
     begin
      pos1:=pos('fmin:',data);
      pos2:=pos('fmax:',data);
      pos3:=pos('current:',data);
      if (pos1+pos2+pos3)<>0 then begin
       bNul(rSetTag(BIRGER.FOCUSMIN.tag,val(copy(data,(pos1+5),(pos2-1-(pos1+5))))));
       UpdateDo(do_FocusMin,time,rGetTag(BIRGER.FOCUSMIN.tag));
       bNul(rSetTag(BIRGER.FOCUSMAX.tag,val(copy(data,(pos2+5),(pos3-1-(pos2+5))))));
       UpdateDo(do_FocusMax,time,rGetTag(BIRGER.FOCUSMAX.tag));
       bNul(rSetTag(BIRGER.FOCUSCUR.tag,val(copy(data,(pos3+8),length(data)))));
       UpdateDo(do_FocusCur,time,rGetTag(BIRGER.FOCUSCUR.tag));
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_ma then
     begin
      pos1:=pos('DONE',data);
      if pos1<>0 then begin
       pos2:=pos(',',data);
       pos3:=pos('f',data);
       stepap:=rval(copy(data,pos1+4,pos2-5));
       numap:=rval(copy(data,pos3+1,length(data)));
       numap:=numap/10;
       bNul(rSetTag(BIRGER.APERSTEP.tag,stepap));
       UpdateDo(do_AperStep,time,stepap);
       bNul(rSetTag(BIRGER.APERNUM.tag,numap));
       UpdateAo(ao_AperNum,time,numap);
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_mn then
     begin
      pos1:=pos('DONE',data);
      if pos1<>0 then begin
       pos2:=pos(',',data);
       pos3:=pos('f',data);
       stepap:=rGetTag(BIRGER.APERSTEP.tag);
       stepap:=stepap+rVal(copy(data,pos1+4,pos2-5));
       numap:=rval(copy(data,pos3+1,length(data)));
       numap:=numap/10;
       bNul(rSetTag(BIRGER.APERSTEP.tag,stepap));
       UpdateDo(do_AperStep,time,stepap);
       bNul(rSetTag(BIRGER.APERNUM.tag,numap));
       UpdateAo(ao_AperNum,time,numap);
       bNul(iSetTag(BIRGER.APERINCR.tag,0));
       bNul(iSetTag(BIRGER.APERDECR.tag,0));
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_mo then
     begin
      pos1:=pos('DONE',data);
      if pos1<>0 then begin
       pos2:=pos(',',data);
       pos3:=pos('f',data);
       stepap:=rGetTag(BIRGER.APERSTEP.tag);
       stepap:=stepap+val(copy(data,pos1+4,pos2-5));
       numap:=rval(copy(data,pos3+1,length(data)));
       numap:=numap/10;
       bNul(rSetTag(BIRGER.APERSTEP.tag,stepap));
       UpdateDo(do_AperStep,time,stepap);
       bNul(rSetTag(BIRGER.APERNUM.tag,numap));
       UpdateAo(ao_AperNum,time,numap);
       bNul(iSetTag(BIRGER.APEROPEN.tag,0));
       decode:=true;
      end else InvalidAnswer(n,data);
     end else
    if n=cm_mc then
     begin
      pos1:=pos('DONE',data);
      if pos1<>0 then begin
       pos2:=pos(',',data);
       pos3:=pos('f',data);
       stepap:=rGetTag(BIRGER.APERSTEP.tag);
       stepap:=stepap+val(copy(data,pos1+4,pos2-5));
       numap:=rval(copy(data,pos3+1,length(data)));
       numap:=numap/10;
       bNul(rSetTag(BIRGER.APERSTEP.tag,stepap));
       UpdateDo(do_AperStep,time,stepap);
       bNul(rSetTag(BIRGER.APERNUM.tag,numap));
       UpdateAo(ao_AperNum,time,numap);
       bNul(iSetTag(BIRGER.APERCLOSE.tag,0));
       decode:=true;
      end else InvalidAnswer(n,data);
     end;
   end else decode:=true;
  end else Trouble('Answer on command '+BIRGER.Cmd.Acronym[n]+' is empty');
  DecodeData:=decode;
 end;
 {
 Simulator mode (handling receive command)
 }
 procedure BIRGER_Simulation(Req:String);
 var aprang,apnumset,ans:String; step,step1,zpos:Integer;
 begin
  Details('In simulator: '+Req);
  ans:='';
  aprang:='f45,22,f306';
  apnumset:='45,50,54,59,64,70,77,84,91,99,108,118,129,141,153,167,182,199,217,236,258,281,306';
  if Req='ll'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'OK'+CRLF));
  if Req='rm0,1' then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'OK'+CRLF));
  if Req='sr0'   then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'OK'+CRLF));
  if Req='in'    then begin
   iNul(pipe_send(BIRGER.Pipe.PipeSIM,'DONE'+CRLF));
   BIRGER.SimAperCur:='0,f'+extractword(1,apnumset);
  end;
  if Req='sn'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'Sim SN'+CRLF));
  if Req='bv'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'Sim BV'+CRLF));
  if Req='hv'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'Sim HV'+CRLF));
  if Req='vs'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'Sim LV'+CRLF));
  if Req='id'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'100mm,f45'+CRLF));
  if Req='da'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,aprang+CRLF));
  if Req='dz'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'100mm,400mm'+CRLF));
  if Req='lp'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'1'+CRLF));
  if Req='pf'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'743'+CRLF));
  if Req='fd'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'45cm,48cm'+CRLF));
  if Req='pa'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,BIRGER.SimAperCur+CRLF));
  if Req='fp'    then iNul(pipe_send(BIRGER.Pipe.PipeSIM,'fmin:0 fmax:1000 current:743'+CRLF));
  if copy(Req,1,2)='ma' then begin
   step:=val(copy(Req,3,length(Req)));
   if ((step>=0) and (step<=22)) then BIRGER.SimAperCur:=copy(Req,3,length(Req))+',f'+extractword(val(copy(Req,3,length(Req)))+1,apnumset) else
   if step<0 then BIRGER.SimAperCur:='0,f45' else
   if step>22 then BIRGER.SimAperCur:='22,f306';
   iNul(pipe_send(BIRGER.Pipe.PipeSIM,'DONE'+BIRGER.SimAperCur+CRLF));
  end;
  if copy(Req,1,2)='mn' then begin
   zpos:=pos(',',BIRGER.SimAperCur);
   step:=val(copy(BIRGER.SimAperCur,1,zpos-1));
   step1:=step+val(copy(Req,3,length(Req)));
    if step1<0 then begin
     ans:=str(0-step)+',f45';
     BIRGER.SimAperCur:='0,f45';
    end else
    if step1>22 then begin
     ans:=str(22-step)+',f306';
     BIRGER.SimAperCur:='22,f306';
    end else begin
     step:=step1;
     BIRGER.SimAperCur:=str(step)+',f'+extractword(step+1,apnumset);
     ans:=copy(Req,3,length(Req))+',f'+extractword(step+1,apnumset);
    end;
   iNul(pipe_send(BIRGER.Pipe.PipeSIM,'DONE'+ans+CRLF));
  end;
  if Req='mo'    then begin
   zpos:=pos(',',BIRGER.SimAperCur);
   step:=val(copy(BIRGER.SimAperCur,1,zpos-1));
   if step>0 then ans:=str(0-step)+',f45' else ans:='0,f45';
   BIRGER.SimAperCur:='0,f45';
   iNul(pipe_send(BIRGER.Pipe.PipeSIM,'DONE'+ans+CRLF));
  end;
  if Req='mc'    then begin
   zpos:=pos(',',BIRGER.SimAperCur);
   step:=val(copy(BIRGER.SimAperCur,1,zpos-1));
   if step<22 then ans:=str(22-step)+',f306' else ans:='0,f306';
   BIRGER.SimAperCur:='22,f306';
   iNul(pipe_send(BIRGER.Pipe.PipeSIM,'DONE'+ans+CRLF));
  end;
 BIRGER.Pipe.Req:='';
 aprang:='';
 apnumset:='';
 ans:='';
 end;
 {
 BIRGER StartUp
 }
 Procedure BIRGER_StartUp;
 const send=0; read=1; tout=2;
 var i,state,readtag,createfile,openfile,txt,n,toutcnt,cnttag:Integer; fname,custsect,dbsect,s,tag,dir:String;
  function GetNameSection(zoom,aper,configcur:String):String;
  var zoom1,aper1,conf1:string;
  begin
   zoom1:='';
   aper1:='';
   conf1:='';
   zoom1:=extractword(1,zoom)+extractword(2,zoom);
   aper1:=extractword(1,aper)+'s'+extractword(2,aper)+extractword(3,aper);
   conf1:=extractword(1,configcur)+extractword(2,configcur);
   GetNameSection:='['+zoom1+'_'+aper1+'_'+conf1+']';
   zoom1:='';
   aper1:='';
   conf1:='';
  end;
  procedure GetAperSet;
  var i,step,fpos:Integer;aperset:String;
  begin
   aperset:='';
   step:=val(extractword(2,sGetTag(BIRGER.APERRANGE.tag)));
   Details('GetAperSet - step = '+str(step));
   BIRGER.Cmd.Num:=cm_ma;
   if step>0 then begin
    for i:=0 to (step) do begin
     if Pipe_Send(BIRGER.Pipe.PipeID,BIRGER.Cmd.Acronym[BIRGER.Cmd.Num]+str(i)+CRLF)>0 then begin
      Birger.Pipe.ReqTime:=mSecNow;
      if BIRGER.Simulator then begin
       BIRGER.Pipe.Req:=BIRGER.Cmd.Acronym[BIRGER.Cmd.Num]+str(i);
       if (Length(BIRGER.Pipe.Req)>0) then BIRGER_Simulation(BIRGER.Pipe.Req);
      end;
      while mSecNow<BIRGER.Pipe.ReqTime+BIRGER.Cmd.Timeout do ;
      if Pipe_Readln(BIRGER.Pipe.PipeID,BIRGER.Pipe.Ans,BIRGER.Pipe.Buf) then begin
       fpos:=pos('f',BIRGER.Pipe.Ans);
       aperset:=aperset+copy(BIRGER.Pipe.Ans,(fpos+1),length(BIRGER.Pipe.Ans))+',';
       Details('aperset : '+aperset);
       bNul(DecodeData(BIRGER.Cmd.Num,BIRGER.Pipe.Ans));
      end else Trouble('StartUp Initialization Failure - Error GetAperSet - Get Answer');
     end else Trouble('StartUp Initialization Failure - Error GetAperSet - Send Cmd'+str(i));
    end;
    bNul(sSetTag(BIRGER.APERSET.tag,aperset));
   end else Trouble('StartUp Initialization Failure - Error GetAperSet - Get Aperture Steps');
  aperset:='';
  end;
  Function GetNoPrefTag(tag:Integer;pref:String):String;
  var s:String;
  begin
   s:='';
   s:=copy(nametag(tag),length(readini('tagPrefix'))+1,length(nametag(tag)));
   GetNoPrefTag:=s;
  end;
 begin
  ShowTooltip('text "Инициализация объектива..." delay 5000 preset stdSuccess');
  i:=1;
  state:=send;
  fname:='';
  custsect:='';
  dbsect:='';
  s:='';
  tag:='';
  dir:='';
  cnttag:=0;
  while i<MaxCmdNum do begin
   if BIRGER.Cmd.StartCmd[i] then begin
    if state=send then begin
     ClearRequest(i,st_NoReq);
     if Pipe_Send(BIRGER.Pipe.PipeID,BIRGER.Cmd.Acronym[BIRGER.Cmd.Num]+CRLF)>0 then begin
      BIRGER.Pipe.Req:=BIRGER.Cmd.Acronym[BIRGER.Cmd.Num];
      ViewExp('PIPE Sended > '+BIRGER.Pipe.Req);
      BIRGER.Pipe.ReqTime:=mSecNow;
      if BIRGER.Simulator then begin
       Details('StartUp - Try execute simulator');
       if (Length(BIRGER.Pipe.Req)>0) then BIRGER_Simulation(BIRGER.Pipe.Req);
      end;
      state:=read;
     end else Trouble(GetDateTime(mSecNow)+': Send Cmd not done, repeat send');
    end else
    if state=read then begin
     if Pipe_Readln(BIRGER.Pipe.PipeID,BIRGER.Pipe.Ans,BIRGER.Pipe.Buf) then begin
      ViewImp('PIPE Getted'+' < '+BIRGER.Pipe.Ans);
      BIRGER.Pipe.AnsTime:=mSecNow;
      if DecodeData(BIRGER.Cmd.Num,BIRGER.Pipe.Ans) then begin
       i:=i+1;
       state:=send;
       ClearRequest(i,st_NoReq);
      end else begin
       i:=i+1;
       state:=send;
       Trouble('StartUp Initialization Failure - Error DecodeData');
      end;
     end else state:=tout;
    end else
    if state=tout then begin
     if mSecNow>BIRGER.Pipe.ReqTime+BIRGER.Cmd.Timeout then begin
      toutcnt:=toutcnt+1;
      bNul(rSetTag(BIRGER.STATUS.tag,stt_Timeout));
      UpdateDo(do_Status,time,rGetTag(BIRGER.STATUS.tag));
      Problem(GetDateTime(mSecNow)+': TimeOut on command: '+BIRGER.Cmd.Acronym[i]);
      i:=i+1;
     end else state:=read;
    end;
   end else i:=i+1;
  end;
  if toutcnt=0 then begin
   dir:=ReadIni('LenseDBDir');
   dir:=daqfileref(dir,'');
   if not direxists(dir) then bNul(mkdir(dir));
   fname:=Trim(ReadIni('LenseDBDir')+ReadIni('LenseDBIni'));
   custsect:=GetNameSection(sGetTag(BIRGER.LENS_ZOOMRANGE.tag),sGetTag(BIRGER.APERRANGE.tag),sGetTag(BIRGER.LENS_CONFIGCUR.tag));
   if not IsEmptyStr(fname) then fname:=DaqFileRef(fname,'.ini');
   if not FileExists(fname) then begin
    GetAperSet;
    dbsect:=Trim(ReadIni('LensDBSection'));
    createfile:=rewrite(fname);
    if createfile=0 then begin
     openfile:=append(fname);
     if openfile=0 then begin
      writeln(custsect);
      writeln(GetNoPrefTag(BIRGER.LENS_ZOOMRANGE.tag,ReadIni('tagPrefix')),' = ',sGetTag(BIRGER.LENS_ZOOMRANGE.tag));
      cnttag:=cnttag+1;
      writeln(GetNoPrefTag(BIRGER.APERRANGE.tag,ReadIni('tagPrefix')),' = ',sGetTag(BIRGER.APERRANGE.tag));
      cnttag:=cnttag+1;
      writeln(GetNoPrefTag(BIRGER.LENS_CONFIGCUR.tag,ReadIni('tagPrefix')),' = ',sGetTag(BIRGER.LENS_CONFIGCUR.tag));
      cnttag:=cnttag+1;
      writeln(GetNoPrefTag(BIRGER.APERSET.tag,ReadIni('tagPrefix')),' = ',sGetTag(BIRGER.APERSET.tag));
      cnttag:=cnttag+1;
      writeln('[]');
      iNul(append(''));
      ShowTooltip('text "Записано '+str(cnttag)+' параметра объектива" delay 5000 preset stdSuccess');
     end else Problem('Error at open file. ErrorCode - '+str(openfile));
    end else Problem('Error at create file. ErrorCode - '+str(createfile));
   end else begin
    openfile:=reset(fname);
    if openfile=0 then begin
     txt:=text_new;
     while not eof do begin
      readln(s);
      bNul(text_addln(txt,s));
     end;
     iNul(reset(''));
     Details('number string in text = '+str(text_numln(txt)));
    end else Problem('Error at open file. ErrorCode - '+str(openfile));
    i:=0;
    while i<>text_numln(txt) do begin
     s:=Trim(text_getln(txt,i));
     if custsect=s then begin
      n:=i;
      i:=text_numln(txt);
     end else i:=i+1;
    end;
    if custsect=Trim(text_getln(txt,n)) then begin
     //iNul(CustomIniRW('R',fname+' '+custsect+' '+dbsect+' '+Trim(ReadIni('LenseDBDir'))+'BackUp',1));
     s:='';
     while not (s='[]') do begin
      n:=n+1;
      s:=Trim(text_getln(txt,n));
      i:=pos('=',s);
      if i<>0 then begin
       if sSetTag(findtag(ReadIni('tagPrefix')+copy(s,1,i-1)),copy(s,i+1,length(s))) then cnttag:=cnttag+1;
      end;
     end;
     ShowTooltip('text "Прочитано '+str(cnttag)+' параметра объектива" delay 5000 preset stdSuccess');
    end else begin
     GetAperSet;
     openfile:=append(fname);
     if openfile=0 then begin
      writeln(custsect);
      writeln(GetNoPrefTag(BIRGER.LENS_ZOOMRANGE.tag,ReadIni('tagPrefix')),' = ',sGetTag(BIRGER.LENS_ZOOMRANGE.tag));
      cnttag:=cnttag+1;
      writeln(GetNoPrefTag(BIRGER.APERRANGE.tag,ReadIni('tagPrefix')),' = ',sGetTag(BIRGER.APERRANGE.tag));
      cnttag:=cnttag+1;
      writeln(GetNoPrefTag(BIRGER.LENS_CONFIGCUR.tag,ReadIni('tagPrefix')),' = ',sGetTag(BIRGER.LENS_CONFIGCUR.tag));
      cnttag:=cnttag+1;
      writeln(GetNoPrefTag(BIRGER.APERSET.tag,ReadIni('tagPrefix')),' = ',sGetTag(BIRGER.APERSET.tag));
      cnttag:=cnttag+1;
      writeln('[]');
      iNul(append(''));
      ShowTooltip('text "Добавлено '+str(cnttag)+' параметра нового объектива" delay 5000 preset stdSuccess');
     end;
    end;
   end;
   BIRGER.Cmd.Num:=cm_mo;
   if Pipe_Send(BIRGER.Pipe.PipeID,BIRGER.Cmd.Acronym[BIRGER.Cmd.Num]+CRLF)>0 then begin
    Birger.Pipe.ReqTime:=mSecNow;
    if BIRGER.Simulator then begin
     BIRGER.Pipe.Req:=BIRGER.Cmd.Acronym[BIRGER.Cmd.Num];
     if (Length(BIRGER.Pipe.Req)>0) then BIRGER_Simulation(BIRGER.Pipe.Req);
    end;
    while mSecNow<BIRGER.Pipe.ReqTime+BIRGER.Cmd.Timeout do ;
    if Pipe_Readln(BIRGER.Pipe.PipeID,BIRGER.Pipe.Ans,BIRGER.Pipe.Buf) then begin
     bNul(DecodeData(BIRGER.Cmd.Num,BIRGER.Pipe.Ans));
    end else Trouble('StartUp Initialization Failure -StartPos - Get Answer');
   end else Trouble('StartUp Initialization Failure - StartPos - Send Cmd '+BIRGER.Pipe.Req);
  end else begin
   ShowTooltip('text "Проблемы при инициализации" delay 5000 trans 255 bkColor red textColor 0x000000'
                +' font "Arial Black" fontSize 16 ico notify.ico audio notify.wav');
   Problem('Initialization inavailible. Try later');
  end;
 bNul(text_free(txt));
 fname:='';
 custsect:='';
 dbsect:='';
 s:='';
 tag:='';
 dir:='';
 BIRGER.Cmd.Num:=0;
 bNul(iSetTag(BIRGER.REINIT.tag,0));
 end;
 {
 BIRGER Main Cmd Cycle
 }
 Procedure BIRGER_CmdCycle;
 var sPID:String;
  function NextCmdNum(Num:Integer):Integer;
  var i:Integer;
  begin
   i:=0;
   while (i<MaxCmdNum) do begin
    Num:=ValidateCmdNum(Num+1);
    if BIRGER.Cmd.Enable[Num]
    then i:=MaxCmdNum
    else i:=i+1;
   end;
   NextCmdNum:=Num;
  end;
  function HandleRequest(n:Integer; Ans:String):Boolean;
  var Handled:Boolean;
  begin
   Handled:=false;
   if IsValidCmdNum(n) and (Length(Ans)>0) then begin
    Handled:=DecodeData(n,Ans);
   end;
   HandleRequest:=Handled;
  end;
  procedure DisCtrlCmd(n:Integer);
  begin
   if (n=cm_ll) then BIRGER.Cmd.Enable[cm_ll]:=false;
   if (n=cm_rm) then BIRGER.Cmd.Enable[cm_rm]:=false;
   if (n=cm_sr) then BIRGER.Cmd.Enable[cm_sr]:=false;
   if (n=cm_in) then BIRGER.Cmd.Enable[cm_in]:=false;
   if (n=cm_sn) then BIRGER.Cmd.Enable[cm_sn]:=false;
   if (n=cm_bv) then BIRGER.Cmd.Enable[cm_bv]:=false;
   if (n=cm_hv) then BIRGER.Cmd.Enable[cm_hv]:=false;
   if (n=cm_vs) then BIRGER.Cmd.Enable[cm_vs]:=false;
   if (n=cm_ma) then BIRGER.Cmd.Enable[cm_ma]:=false;
   if (n=cm_mn) then BIRGER.Cmd.Enable[cm_mn]:=false;
   if (n=cm_mo) then BIRGER.Cmd.Enable[cm_mo]:=false;
   if (n=cm_mc) then BIRGER.Cmd.Enable[cm_mc]:=false;
  end;
  function SendCmd(pipeid,cmdnum:Integer):Integer;
  var n:Integer;
  begin
  n:=0;
   if BIRGER.Cmd.ArgCmd[cmdnum]
   then begin
    n:=Pipe_Send(pipeid, BIRGER.Cmd.Acronym[cmdnum]+BIRGER.Cmd.Argument+CRLF);
    BIRGER.Pipe.Req:=BIRGER.Cmd.Acronym[cmdnum]+BIRGER.Cmd.Argument;
    ViewExp('PIPE '+sPID+' > '+BIRGER.Cmd.Acronym[cmdnum]+BIRGER.Cmd.Argument);
   end else begin
    n:=Pipe_Send(pipeid, BIRGER.Cmd.Acronym[cmdnum]+CRLF);
    BIRGER.Pipe.Req:=BIRGER.Cmd.Acronym[cmdnum];
   end;
  ViewExp('PIPE '+sPID+' > '+BIRGER.Pipe.Req);
  SendCmd:=n;
  end;
 begin
  sPID:='';
  if not DIM_IsClientMode then begin
   if BIRGER.Simulator or (Pipe_Connected(BIRGER.Pipe.PipeID)=1) then begin
    sPID:=str(BIRGER.Pipe.PipeID);
    BIRGER.Cmd.Num:=ValidateCmdNum(BIRGER.Cmd.Num);
    if BIRGER.Cmd.Status=st_NoReq then begin
     ClearRequest(BIRGER.Cmd.Num,st_NoReq);
     if BIRGER.Cmd.Enable[BIRGER.Cmd.Num] then begin
      if SendCmd(BIRGER.Pipe.PipeID, BIRGER.Cmd.Num)>0 then begin
       BIRGER.Cmd.Status:=st_WaitAns;
       BIRGER.Pipe.ReqTime:=mSecNow;
       BIRGER.Pipe.TX:=BIRGER.Pipe.TX+1;
      end else begin
       Trouble(GetDateTime(mSecNow)+': Send Cmd not done, repeat send');
       ClearRequest(NextCmdNum(BIRGER.Cmd.Num),st_NoReq);
      end;
     end else ClearRequest(NextCmdNum(BIRGER.Cmd.Num),st_NoReq);
    end else
    if BIRGER.Cmd.Status=st_WaitAns then begin
     if IsQueryCmdNum(BIRGER.Cmd.Num) then begin
      if Pipe_Readln(BIRGER.Pipe.PipeID,BIRGER.Pipe.Ans,BIRGER.Pipe.Buf) then begin
       ViewImp('PIPE '+sPID+' < '+BIRGER.Pipe.Ans);
       BIRGER.Pipe.RX:=BIRGER.Pipe.RX+1;
       if HandleRequest(BIRGER.Cmd.Num,BIRGER.Pipe.Ans) then begin
        DisCtrlCmd(BIRGER.Cmd.Num);
        ClearRequest(NextCmdNum(BIRGER.Cmd.Num),st_NoReq);
       end;
      end else if mSecNow>BIRGER.Pipe.ReqTime+BIRGER.Cmd.TimeOut then begin
       BIRGER.Cmd.Status:=st_TimeOut;
      end else BIRGER.Cmd.Status:=st_WaitAns;
     end else BIRGER.Cmd.Status:=st_WaitGap;
    end;
    if BIRGER.Cmd.Status=st_WaitGap then begin
     if not IsQueryCmdNum(BIRGER.Cmd.Num) then begin
      if mSecNow>BIRGER.Pipe.ReqTime+BIRGER.Cmd.TimeOut then begin
       DisCtrlCmd(BIRGER.Cmd.Num);
       ClearRequest(NextCmdNum(BIRGER.Cmd.Num),st_NoReq);
      end else BIRGER.Cmd.Status:=st_WaitGap;
     end;
    end;
    if BIRGER.Cmd.Status=st_TimeOut then begin
     BIRGER.Pipe.CntTimeOut:=BIRGER.Pipe.CntTimeOut+1;
     bNul(rSetTag(BIRGER.STATUS.tag,stt_Timeout));
     UpdateDo(do_Status,time,rGetTag(BIRGER.STATUS.tag));
     Problem(GetDateTime(mSecNow)+': TimeOut on command: '+BIRGER.Cmd.Acronym[BIRGER.Cmd.Num]);
     ClearRequest(NextCmdNum(BIRGER.Cmd.Num),st_NoReq);
     if BIRGER.Pipe.CntTimeOut>=20 then begin
      Trouble(GetDateTime(mSecNow)+': Timeout Very Long - Try Reconnect');
      BIRGER_PipeFree;
      bNul(BIRGER_PipeConnect);
      BIRGER.Pipe.CntTimeOut:=0;
      BIRGER.Cmd.Status:=st_NoReq;
     end;
    end;
   end else begin
    bNul(rSetTag(BIRGER.STATUS.tag,stt_Refused));
    UpdateDo(do_Status,time,rGetTag(BIRGER.STATUS.tag));
   end;
  end;
  sPID:='';
 end;
 {
 Enabling Polling
 }
 Procedure EnabledPoll;
 begin
  if iGetTag(BIRGER.POLLEN.tag)>0 then begin
   BIRGER.Cmd.Enable[cm_da]:=true;
   BIRGER.Cmd.Enable[cm_dz]:=true;
   BIRGER.Cmd.Enable[cm_lp]:=true;
   BIRGER.Cmd.Enable[cm_fd]:=true;
   BIRGER.Cmd.Enable[cm_pa]:=true;
   BIRGER.Cmd.Enable[cm_fp]:=true;
  end else begin
   BIRGER.Cmd.Enable[cm_da]:=false;
   BIRGER.Cmd.Enable[cm_dz]:=false;
   BIRGER.Cmd.Enable[cm_lp]:=false;
   BIRGER.Cmd.Enable[cm_fd]:=false;
   BIRGER.Cmd.Enable[cm_pa]:=false;
   BIRGER.Cmd.Enable[cm_fp]:=false;
  end;
 end;
 {
 Post command for DIM
 }
 Procedure DimPostCmd(cmd:String);
 begin
  if DIM_IsClientMode then Dim_GuiConsoleSend(DevName,cmd) else DevPostCmdLocal(cmd);
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Aperture Selection
 }
 procedure MenuAperSelection;
 var n,i,sel:integer;aper:real;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Меню выбора апертуры... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   sel:=val(extractword(2,sGetTag(BIRGER.APERRANGE.tag)));
   if sel>0 then begin
    for i:=0 to sel do begin
     //////////////////////////////////////////
     aper:=rval(extractword((i+1),sGetTag(BIRGER.APERSET.tag)));
     aper:=aper/10;
     n:=n+EditAddInputLn(str(i)+',f'+str(aper));
     n:=n+EditAddConfirm('');
     n:=n+EditAddCommand('@MoveApAbs '+str(i));
     //////////////////////////////////////////
    end;
   end else n:=n+1;
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_APERSEL'),'');
   if (n>0) then Problem('Error initializing Menu Aperture Selection!');
  end else Problem('Cannot edit right now!');
 end;
 {
 All Menu Handler to handle editing.
 }
 procedure AllMenuHandler(s:String);
 begin
  EditMenuDefaultHandler(EditGetUID(s));
 end;
 //
 // Xor bit on click (local version).
 //
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Xor bit on click (remote version).
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
   if (ClickTag=tag) then begin
    DIM_GuiClickSend(DIM_GuiClickBuff+'NewValue='+Str(iXor(iGetTag(tag),XorMask)));
    bNul(Voice(snd_Click));
   end;
 end;
 {
 GUI Handler to process user input...
 }
 procedure BIRGER_GUI_Poll;
 var s:String; ClickCurve:Integer;
 begin
  s:='';
  DIM_GuiClickBuff:='';
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   //
   // Copy GUI click to DIM buffer for remote execution.
   //
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Click is local
     }
     if ClickIsLocal then begin
      {
      Click Tags
      }
      if ClickTag<>0 then begin
       if (ClickTag=BIRGER.POLLEN.tag) then begin
        if iGetTag(BIRGER.POLLEN.tag)=0 then DevPostCmdLocal('@Poll 1');
        if iGetTag(BIRGER.POLLEN.tag)=1 then DevPostCmdLocal('@Poll 0');
       end;
       if (ClickTag=BIRGER.APERINCR.tag) then begin
        bNul(iSetTag(BIRGER.APERINCR.tag,1));
        DevPostCmdLocal('@MoveApInc 1');
       end else
       if (ClickTag=BIRGER.APERDECR.tag) then begin
        bNul(iSetTag(BIRGER.APERDECR.tag,1));
        DevPostCmdLocal('@MoveApInc -1');
       end;
       if (ClickTag=BIRGER.ERROR.tag) then begin
        DevPostCmdLocal('@ErrorClear');
       end;
       if (ClickTag=BIRGER.APERCLOSE.tag) then begin
        bNul(iSetTag(BIRGER.APERCLOSE.tag,1));
        DevPostCmdLocal('@MoveApCls');
       end;
       if (ClickTag=BIRGER.APEROPEN.tag) then begin
        bNul(iSetTag(BIRGER.APEROPEN.tag,1));
        DevPostCmdLocal('@MoveApOpn');
       end;
       if ((ClickTag=BIRGER.APERNUM.tag) or (ClickTag=BIRGER.APERSTEP.tag)) then begin
        DevPostCmdLocal('@MenuApSel');
       end;
       if (ClickTag=BIRGER.REINIT.tag) then begin
        bNul(iSetTag(BIRGER.REINIT.tag,1));
        DevPostCmdLocal('@ReInit');
       end;
      end;
     end;
     {
     Handle sensor clicks...
     }
     if IsSameText(ClickSensor,'HELP') then begin
      Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
      bNul(Voice(snd_Click));
     end;
     if (ClickSensor='BIRGER.LOGO') then begin
      DevPostCmdLocal('@MenuTools');
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Handle remote clicks comes from DIM via @DimGuiClick message.
     // @DimGuiClick default handler decode and write events to FIFO,
     // so we can find it as clicks and can handle it in usual way.
     //
     if ClickIsRemote then begin
      //
      // Show time difference.
      //
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      //
      // Handle remote console commands...
      //
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  AllMenuHandler('MENU_TOOLS');
  AllMenuHandler('MENU_APERSEL');
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
 end;
 {
 DIM Update tag
 }
 procedure BIRGER_DIM_Update_tag;
 begin
  if DIM_IsServerMode then begin
   if SysTimer_Pulse(10000)>0 then BIRGER_FillTags(-MaxReal);
   if ShouldRefresh(BIRGER.APEROPEN.val,iGetTag(BIRGER.APEROPEN.tag))>0
   then DIM_UpdateTag(BIRGER.APEROPEN.tag,'');
   if ShouldRefresh(BIRGER.APERCLOSE.val,iGetTag(BIRGER.APERCLOSE.tag))>0
   then DIM_UpdateTag(BIRGER.APERCLOSE.tag,'');
   if ShouldRefresh(BIRGER.APERINCR.val,iGetTag(BIRGER.APERINCR.tag))>0
   then DIM_UpdateTag(BIRGER.APERINCR.tag,'');
   if ShouldRefresh(BIRGER.APERDECR.val,iGetTag(BIRGER.APERDECR.tag))>0
   then DIM_UpdateTag(BIRGER.APERDECR.tag,'');
   if ShouldRefresh(BIRGER.APERRANGE.val,HashIndexOf(sGetTag(BIRGER.APERRANGE.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.APERRANGE.tag,'');
   if ShouldRefresh(BIRGER.APERNUM.val,rGetTag(BIRGER.APERNUM.tag))>0
   then DIM_UpdateTag(BIRGER.APERNUM.tag,'');
   if ShouldRefresh(BIRGER.APERSTEP.val,rGetTag(BIRGER.APERSTEP.tag))>0
   then DIM_UpdateTag(BIRGER.APERSTEP.tag,'');
   if ShouldRefresh(BIRGER.APERSET.val,HashIndexOf(sGetTag(BIRGER.APERSET.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.APERSET.tag,'');
   if ShouldRefresh(BIRGER.FOCUSZERO.val,iGetTag(BIRGER.FOCUSZERO.tag))>0
   then DIM_UpdateTag(BIRGER.FOCUSZERO.tag,'');
   if ShouldRefresh(BIRGER.FOCUSINF.val,iGetTag(BIRGER.FOCUSINF.tag))>0
   then DIM_UpdateTag(BIRGER.FOCUSINF.tag,'');
   if ShouldRefresh(BIRGER.FOCUSINCR.val,iGetTag(BIRGER.FOCUSINCR.tag))>0
   then DIM_UpdateTag(BIRGER.FOCUSINCR.tag,'');
   if ShouldRefresh(BIRGER.FOCUSDECR.val,iGetTag(BIRGER.FOCUSDECR.tag))>0
   then DIM_UpdateTag(BIRGER.FOCUSDECR.tag,'');
   if ShouldRefresh(BIRGER.FOCUSSTEP.val,rGetTag(BIRGER.FOCUSSTEP.tag))>0
   then DIM_UpdateTag(BIRGER.FOCUSSTEP.tag,'');
   if ShouldRefresh(BIRGER.FOCUSCUR.val,rGetTag(BIRGER.FOCUSCUR.tag))>0
   then DIM_UpdateTag(BIRGER.FOCUSCUR.tag,'');
   if ShouldRefresh(BIRGER.FOCUSDIST.val,HashIndexOf(sGetTag(BIRGER.FOCUSDIST.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.FOCUSDIST.tag,'');
   if ShouldRefresh(BIRGER.FOCUSMIN.val,rGetTag(BIRGER.FOCUSMIN.tag))>0
   then DIM_UpdateTag(BIRGER.FOCUSMIN.tag,'');
   if ShouldRefresh(BIRGER.FOCUSMAX.val,rGetTag(BIRGER.FOCUSMAX.tag))>0
   then DIM_UpdateTag(BIRGER.FOCUSMAX.tag,'');
   if ShouldRefresh(BIRGER.LENS_PRES.val,iGetTag(BIRGER.LENS_PRES.tag))>0
   then DIM_UpdateTag(BIRGER.LENS_PRES.tag,'');
   if ShouldRefresh(BIRGER.LENS_ZOOMRANGE.val,HashIndexOf(sGetTag(BIRGER.LENS_ZOOMRANGE.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.LENS_ZOOMRANGE.tag,'');
   if ShouldRefresh(BIRGER.LENS_CONFIGCUR.val,HashIndexOf(sGetTag(BIRGER.LENS_CONFIGCUR.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.LENS_CONFIGCUR.tag,'');
   if ShouldRefresh(BIRGER.SERNUM.val,HashIndexOf(sGetTag(BIRGER.SERNUM.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.SERNUM.tag,'');
   if ShouldRefresh(BIRGER.LIBVER.val,HashIndexOf(sGetTag(BIRGER.LIBVER.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.LIBVER.tag,'');
   if ShouldRefresh(BIRGER.BOOTVER.val,HashIndexOf(sGetTag(BIRGER.BOOTVER.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.BOOTVER.tag,'');
   if ShouldRefresh(BIRGER.HWVER.val,HashIndexOf(sGetTag(BIRGER.HWVER.tag),0,0))>0
   then DIM_UpdateTag(BIRGER.HWVER.tag,'');
   if ShouldRefresh(BIRGER.RX.val,rGetTag(BIRGER.RX.tag))>0
   then DIM_UpdateTag(BIRGER.RX.tag,'');
   if ShouldRefresh(BIRGER.TX.val,rGetTag(BIRGER.TX.tag))>0
   then DIM_UpdateTag(BIRGER.TX.tag,'');
   if ShouldRefresh(BIRGER.POLLEN.val,iGetTag(BIRGER.POLLEN.tag))>0
   then DIM_UpdateTag(BIRGER.POLLEN.tag,'');
   if ShouldRefresh(BIRGER.STATUS.val,rGetTag(BIRGER.STATUS.tag))>0
   then DIM_UpdateTag(BIRGER.STATUS.tag,'');
   if ShouldRefresh(BIRGER.ERROR.val,rGetTag(BIRGER.ERROR.tag))>0
   then DIM_UpdateTag(BIRGER.ERROR.tag,'');
   if ShouldRefresh(BIRGER.REINIT.val,iGetTag(BIRGER.REINIT.tag))>0
   then DIM_UpdateTag(BIRGER.REINIT.tag,'');
   if SysTimer_Pulse(1000)>0  then begin
    DIM_UpdateTag(BIRGER.REINIT.tag,'');
    DIM_UpdateTag(BIRGER.APEROPEN.tag,'');
    DIM_UpdateTag(BIRGER.APERCLOSE.tag,'');
    DIM_UpdateTag(BIRGER.APERINCR.tag,'');
    DIM_UpdateTag(BIRGER.APERDECR.tag,'');
    DIM_UpdateTag(BIRGER.FOCUSZERO.tag,'');
    DIM_UpdateTag(BIRGER.FOCUSINF.tag,'');
    DIM_UpdateTag(BIRGER.FOCUSINCR.tag,'');
    DIM_UpdateTag(BIRGER.FOCUSDECR.tag,'');
   end;
  end;
 end;
 {
 Update Status Device
 }
 Procedure BIRGER_UpdateStatus;
 begin
  if BIRGER.Simulator then begin
   bNul(rSetTag(BIRGER.STATUS.tag,stt_Simulat));
   UpdateDo(do_Status,time,rGetTag(BIRGER.STATUS.tag));
  end else begin
   if iGetTag(BIRGER.LENS_PRES.tag)=0 then begin
    bNul(rSetTag(BIRGER.STATUS.tag,stt_LensDisc));
    UpdateDo(do_Status,time,rGetTag(BIRGER.STATUS.tag));
   end else
   if rGetTag(BIRGER.ERROR.tag)>0 then begin
    bNul(rSetTag(BIRGER.STATUS.tag,stt_Warning));
    UpdateDo(do_Status,time,rGetTag(BIRGER.STATUS.tag));
   end else
   if not ((rGetTag(BIRGER.STATUS.tag)=stt_Timeout) or (rGetTag(BIRGER.STATUS.tag)=stt_Refused)) then
   begin
    bNul(rSetTag(BIRGER.STATUS.tag,stt_Work));
    UpdateDo(do_Status,time,rGetTag(BIRGER.STATUS.tag));
   end;
  end;
 end;
 {
 BIRGER Polling
 }
 procedure BIRGER_Poll;
 begin
  BIRGER_GUI_Poll;
  if not DIM_IsClientMode then begin
   EnabledPoll;
   if BIRGER.Simulator then begin
    if (pipe_connected(BIRGER.Pipe.PipeSIM)>0) then begin
     if (Length(BIRGER.Pipe.Req)>0) then BIRGER_Simulation(BIRGER.Pipe.Req);
    end;
   end;
   if SysTimer_Pulse(1000)>0 then begin
    bNul(rSetTag(BIRGER.RX.tag,BIRGER.Pipe.RX));
    UpdateDo(do_RX,time,BIRGER.Pipe.RX);
    bNul(rSetTag(BIRGER.TX.tag,BIRGER.Pipe.TX));
    UpdateDo(do_TX,time,BIRGER.Pipe.TX);
    BIRGER.Pipe.RX:=0;
    BIRGER.Pipe.TX:=0;
   end;
   BIRGER_CmdCycle;
   BIRGER_UpdateStatus;
   if BIRGER.CMDID=cmd_ReInit then begin
    if BIRGER.Cmd.Status=st_NoReq then begin
     BIRGER_StartUp;
     BIRGER.CMDID:=0;
    end else if (BIRGER.Cmd.Status=st_WaitAns) or (BIRGER.Cmd.Status=st_WaitGap) then begin
     BIRGER.CMDID:=cmd_ReInit;
    end else Problem('Initialization not availble');
   end;
   BIRGER_DIM_Update_tag;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  BIRGER_ClearStrings;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  cmd_DimTagUpdate:=RegisterStdInCmd('@DimTagUpdate','');
  cmd_DimCmdMy    :=RegisterStdInCmd('@DIMCMDMY'   ,'');
  cmd_Poll        :=RegisterStdInCmd('@Poll'        ,'');
  cmd_MoveApInc   :=RegisterStdInCmd('@MoveApInc'   ,'');
  cmd_MoveApAbs   :=RegisterStdInCmd('@MoveApAbs'   ,'');
  cmd_MoveApOpn   :=RegisterStdInCmd('@MoveApOpn'   ,'');
  cmd_MoveApCls   :=RegisterStdInCmd('@MoveApCls'   ,'');
  cmd_MenuTools   :=RegisterStdInCmd('@MenuTools'   ,'');
  cmd_MenuApSel   :=RegisterStdInCmd('@MenuApSel'   ,'');
  cmd_ReInit      :=RegisterStdInCmd('@ReInit'      ,'');
  cmd_ErrorClear  :=RegisterStdInCmd('@ErrorClear'  ,'');
  BIRGER_InitTags(ReadIni('tagPrefix'),-MaxReal);
  BIRGER_InitCmdTab;
  BIRGER.Simulator:=val(ReadIni('Simulator'))>0;
  BIRGER.Cmd.Timeout:=val(ReadIni('Timeout'));
  BIRGER.ModeConnect:=ReadIni('ModeConnect');
  if not DIM_IsClientMode then begin
   if DIM_IsServerMode then begin 
    Details('IsServerMode = yes');
    bNul(iSetTag(BIRGER.SERVMODE.tag,0));
   end;
   if BIRGER_PipeConnect then begin
    Success('Connection success');
    BIRGER_StartUp;
   end else begin
    Problem('Connection lost');
    bNul(rSetTag(BIRGER.STATUS.tag,stt_Refused));
   end;
  end else begin
   bNul(iSetTag(BIRGER.SERVMODE.tag,1));
   Details('IsServerMode = No');
   Details('DIM_ClientServerMode = '+str(DIM_ClientServerMode));
  end;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  BIRGER_ClearCmdTab;
  BIRGER_PipeFree;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  BIRGER_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,cdm_arg_nocode:String; cmdid,tag,i:Integer; r:Real;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  cdm_arg_nocode:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Poll
   }
   if (cmdid = cmd_Poll) then begin
    if not DIM_IsClientMode then begin
     if arg='0' then begin
      bNul(iSetTag(BIRGER.POLLEN.tag,0));
     end else if arg='1' then begin
      bNul(iSetTag(BIRGER.POLLEN.tag,1));
     end else Trouble('Unrecognize parametr in command @Poll');
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @Poll '+arg);
    end;
   end else
   {
   @DimTagUpdate
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    if DIM_IsClientMode and not DIM_IsServerMode then begin
     tag:=FindTag(Trim(arg));
     if tag=BIRGER.APERNUM.tag   then UpdateAo(ao_AperNum,  time,rGetTag(tag));
     if tag=BIRGER.RX.tag        then UpdateDo(do_RX,       time,rGetTag(tag));
     if tag=BIRGER.TX.tag        then UpdateDo(do_TX,       time,rGetTag(tag));
     if tag=BIRGER.FOCUSMIN.tag  then UpdateDo(do_FocusMin, time,rGetTag(tag));
     if tag=BIRGER.FOCUSMAX.tag  then UpdateDo(do_FocusMax, time,rGetTag(tag));
     if tag=BIRGER.APERSTEP.tag  then UpdateDo(do_AperStep, time,rGetTag(tag));
     if tag=BIRGER.FOCUSSTEP.tag then UpdateDo(do_FocusStep,time,rGetTag(tag));
     if tag=BIRGER.FOCUSCUR.tag  then UpdateDo(do_FocusCur, time,rGetTag(tag));
     if tag=BIRGER.STATUS.tag    then UpdateDo(do_Status,   time,rGetTag(tag));
     if tag=BIRGER.ERROR.tag     then UpdateDo(do_Error,    time,rGetTag(tag));
    end;
   end else
   {
   @DIMCMDMY
   }
   if (cmdid=cmd_DimCmdMy) then begin
    //декодируем из base64
    cdm_arg_nocode:=base64_decode(arg);
    // Избавляемся от символ NUL (\x00).
    cdm_arg_nocode:=Trim(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@Poll')      then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@MoveApInc') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@MoveApAbs') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@MoveApOpn') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@MoveApCls') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@ReInit') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@ErrorClear') then DevPostCmdLocal(cdm_arg_nocode);
    Success('@DIMCMDMY='+cmd+' arg<'+cdm_arg_nocode+'>');
   end else
   {
   @MoveApInc
   }
   if (cmdid=cmd_MoveApInc) then begin
    if not DIM_IsClientMode then begin
     r:=rVal(arg);
     if not isNan(r) then begin
      BIRGER.Cmd.Argument:=arg;
      BIRGER.Cmd.Enable[cm_mn]:=true;
     end else Trouble('Unrecognize parametr in command @MoveApInc');
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @MoveApInc '+arg);
    end;
   end else
   {
   @MoveApAbs
   }
   if (cmdid=cmd_MoveApAbs) then begin
    if not DIM_IsClientMode then begin
     r:=rVal(arg);
     if not isNan(r) then begin
      BIRGER.Cmd.Argument:=arg;
      BIRGER.Cmd.Enable[cm_ma]:=true;
     end else Trouble('Unrecognize parametr in command @MoveApAbs');
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @MoveApAbs '+arg);
    end;
   end else
   {
   @MoveApOpn
   }
   if (cmdid=cmd_MoveApOpn) then begin
    if not DIM_IsClientMode then begin
     BIRGER.Cmd.Enable[cm_mo]:=true;
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @MoveApOpn');
    end;
   end else
   {
   @MoveApCls
   }
   if (cmdid=cmd_MoveApCls) then begin
    if not DIM_IsClientMode then begin
     BIRGER.Cmd.Enable[cm_mc]:=true;
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @MoveApCls');
    end;
   end else
   {
   @MenuTools
   }
   if (cmdid=cmd_MenuTools) then begin
    MenuToolsStarter;
   end else
   {
   @MenuApSel
   }
   if (cmdid=cmd_MenuApSel) then begin
    MenuAperSelection;
   end else
   {
   @ReInit
   }
   if (cmdid=cmd_ReInit) then begin
    if not DIM_IsClientMode then begin
     BIRGER.CMDID:=cmd_ReInit;
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReInit');
    end;
   end else
   {
   @ErrorClear
   }
   if (cmdid=cmd_ErrorClear) then begin
    if not DIM_IsClientMode then begin
     bNul(rSetTag(BIRGER.ERROR.tag,0));
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ErrorClear');
    end;
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  cdm_arg_nocode:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
