////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Этот ТЕСТ возбуждает исключения EDivByZero.
Он служит для проверки системы защиты и обработки исключений.
[]
[Manual.Eng]
This TEST generates EDivByZero exceptions.
Uses just to test Structured Exception Handling.
[]
}

library test_edivbyzero;

{$I _crw_sysdef}

{$IFDEF FPC}{$mode Delphi}{$ENDIF}{$H+}

{$R *.res}

uses
 _crw_sharemem, // NB: THIS UNIT MUST BE FIRST !!!
 {$IFDEF UNIX} cthreads, dl, {$ENDIF}
 {$IFDEF WINDOWS} windows, {$ENDIF}
 sysutils, classes, math, graphics,
 _crw_crwapi;

//////////////////////////////////////////////////
{$I _crw_plugin_declare} // Declare CRWDAQ_PLUGIN.
//////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:TCrwApi):Integer;
//////////////////////////////////////////////////
var i,n:integer;
begin
 Result:=0; n:=0;
 with CrwApi,SysApi,GuiApi,DaqApi do
 try
  RedirectStdIn(Input);
  RedirectStdOut(Output);
  writeln('This TEST generates DIVISION BY ZERO exceptions.');
  writeln('Uses just to test Structured Exception Handling.');
  //
  // !!! There expected to be EDivByZero !!!
  //
  i:=1 div n;              // There expected exception.
  inc(n); writeln('i=',i); // This code should not run.
 finally
  if n=0
  then writeln('Exception raised.')
  else writeln('Exception passed.');
 end;
end;

//////////////////////////////////////////////////
{$I _crw_plugin_exports} // Exports CRWDAQ_PLUGIN.
//////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID; //
//////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
 
