library test_000;

{$I _crw_sysdef}

{$IFDEF FPC}{$mode Delphi}{$ENDIF}{$H+}

{$R *.res}

uses
 _crw_sharemem, // NB: THIS UNIT MUST BE FIRST !!!
 {$IFDEF UNIX} cthreads, dl, {$ENDIF}
 {$IFDEF WINDOWS} windows, {$ENDIF}
 sysutils, classes, math, graphics,
 _crw_crwapi;

function f1(x:double; Custom:Pointer):double;
begin
 Result:=x*(x*x-2)-5;
end;

function f2(x:double; Custom:Pointer):double;
begin
 if x<>0.0 then Result:=sin(x)/x else Result:=1.0;
end;

procedure Test_zm(Api:TCrwApi);
VAR NOFUN:INTEGER; A,B,RESULT,RELERR,ABSERR,ERREST,FLAG:DOUBLE;
begin
 with Api,SysApi,GuiApi do begin
  writeln('Test macheps = ',MachEps);
  writeln('Test FindZero: expected 2.0945514815');
  writeln('Result:',FindZero(f1,2,3,MachEps,nil):16:14);
  writeln('Test FindMin: expected 0.81650');
  writeln('Result:',FindMin(f1,0,1,sqrt(MachEps),nil):16:14);
  writeln('Test QUANC8:expected RESULT=1.6054129768,FLAG=0');
  A:=0.0;
  B:=2.0;
  RELERR:=1.0E-10;
  ABSERR:=0.0;
  RESULT:=QUANC8(f2,A,B,ABSERR,RELERR,ERREST,NOFUN,FLAG,nil);
  WRITELN('RESULT=',RESULT:16:14);
  WRITELN('ERREST=',ERREST);
  IF(FLAG<>0.0) THEN WRITELN('FLAG=',FLAG);
 end;
end;

//////////////////////////////////////////////////
{$I _crw_plugin_declare} // Declare CRWDAQ_PLUGIN.
//////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:TCrwApi):Integer;
//////////////////////////////////////////////////
var i:integer; r:double; p:Pointer;
begin
 Result:=0;
 with CrwApi,SysApi,GuiApi,DaqApi do begin
  RedirectStdIn(Input);
  RedirectStdOut(Output);
  writeln(Format('%s',['Hello from DLL! :-)']));
  //exit;
  Test_zm(CrwApi);
  try
   i:=0;
   r:=ln(i);
   writeln(Format('%g',[r]));
  except
   on E:Exception do writeln('dll:',E.Message);
  end;
  i:=0;
  r:=ln(i);
  writeln(Format('%g',[r]));
  writeln('isNan=',isNan(r));
  writeln('isInf=',isInf(r));
  writeln(trunc(ln(-1)));
  Warning('Привет из DLL!');
  p:=Allocate(1024);
  Information(Format('%d',[AllocSize(P)]));
  Deallocate(p);
  writeln(GetDateStr(msecnow)+'-'+GetTimeStr(msecnow));
  writeln(ExtractTextSection(SysIniFile,'[System]',0));
  writeln(ProgName);
  writeln(GetWindowsShellFolder('Desktop'));
  writeln(GetWindowsShellDesktop);
  writeln(GetWindowsShellPrograms);
  writeln(GetWindowsShellStartup);
  writeln(GetWindowsShellStartMenu);
  writeln(GetWindowsShellFavorites);
  writeln(GetWindowsShellFonts);
  writeln(GetWindowsShellHistory);
  writeln(GetWindowsShellPersonal);
  writeln(GetWindowsShellSendTo);
  //CreateFileLink(ProgName,AddBackSlash(GetWindowsShellDesktop)+'CRW32_LINK.LNK','CRW32-DAQ','');
  //CreateFileLink(ProgName,AddBackSlash(GetWindowsShellPrograms)+'CRW32_LINK','CRW32-DAQ','');
 end;
end;

//////////////////////////////////////////////////
{$I _crw_plugin_exports} // Exports CRWDAQ_PLUGIN.
//////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID; //
//////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
 