@echo off
title %~nx0 %1 %2
SetLocal EnableExtensions EnableDelayedExpansion
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2021 Alexey Kuryakin kouriakine@mail.ru      ::
:: Under MIT License, see https://opensource.org/licenses/MIT ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: The script apply XCOPY to update Source-->Target.          ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Main
if "%~1" == "" goto :SourceIsEmpty
if "%~2" == "" goto :TargetIsEmpty
if not exist "%~1\" goto :SourceIsNotExist
if not exist "%~2\" goto :TargetIsNotExist
call :exec xcopy %1 %2 /S /E /V /C /I /H /R /Y /D
exit /b %ERRORLEVEL%
goto :EOF

:exec
title %*
echo %*
call %*
goto :EOF

:SourceIsEmpty
echo Error: Source directory is not specified. 1>&2
exit /b 1

:TargetIsEmpty
echo Error: Target directory is not specified. 1>&2
exit /b 1

:SourceIsNotExist
echo Error: Source directory is not exist. 1>&2
exit /b 1

:TargetIsNotExist
echo Error: Target directory is not exist. 1>&2
exit /b 1
