package spark.effects.animation
{
   import mx.core.mx_internal;
   import spark.effects.easing.IEaser;
   import spark.effects.easing.Linear;
   
   use namespace mx_internal;
   
   public class Keyframe
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var linearEaser:IEaser = new Linear();
       
      public var value:Object;
      
      [Inspectable(minValue="0.0")]
      public var time:Number;
      
      mx_internal var timeFraction:Number;
      
      public var easer:IEaser;
      
      public var valueBy:Object;
      
      public function Keyframe(time:Number = NaN, value:Object = null, valueBy:Object = null)
      {
         this.easer = linearEaser;
         super();
         this.value = value;
         this.time = time;
         this.valueBy = valueBy;
      }
      
      public function clone() : Keyframe
      {
         var kf:Keyframe = new Keyframe(this.time,this.value,this.valueBy);
         kf.easer = this.easer;
         kf.timeFraction = this.timeFraction;
         return kf;
      }
   }
}
