package spark.components
{
   import mx.core.mx_internal;
   import flash.ui.ContextMenuItem;
   import mx.managers.ISystemManager;
   import mx.utils.BitFlagUtil;
   import spark.layouts.supportClasses.LayoutBase;
   import mx.core.FlexGlobals;
   import flash.external.ExternalInterface;
   import mx.core.IInvalidating;
   import mx.utils.LoaderUtil;
   import flash.system.Capabilities;
   import flash.utils.setInterval;
   import flash.events.Event;
   import mx.managers.IActiveWindowManager;
   import mx.managers.FocusManager;
   import flash.display.InteractiveObject;
   import flash.ui.ContextMenu;
   import flash.events.ContextMenuEvent;
   import mx.core.UIComponentGlobals;
   import flash.net.navigateToURL;
   import flash.net.URLRequest;
   import flash.display.DisplayObject;
   import mx.managers.ILayoutManager;
   import mx.core.Singleton;
   
   use namespace mx_internal;
   
   [ResourceBundle("components")]
   [Frame(factoryClass="mx.managers.SystemManager")]
   [Exclude(kind="property",name="y")]
   [Exclude(kind="property",name="x")]
   [Exclude(kind="property",name="toolTip")]
   [Exclude(kind="property",name="tabIndex")]
   [Exclude(kind="property",name="direction")]
   [Style(inherit="no",name="backgroundColor",format="Color",type="uint")]
   [Event(name="error",type="flash.events.ErrorEvent")]
   [Event(name="applicationComplete",type="mx.events.FlexEvent")]
   public class Application extends SkinnableContainer
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static const CONTROLBAR_PROPERTY_FLAG:uint = 1 << 0;
      
      private static const LAYOUT_PROPERTY_FLAG:uint = 1 << 1;
      
      private static const VISIBLE_PROPERTY_FLAG:uint = 1 << 2;
       
      private var resizeHandlerAdded:Boolean = false;
      
      private var percentBoundsChanged:Boolean;
      
      private var preloadObj:Object;
      
      private var resizeWidth:Boolean = true;
      
      private var resizeHeight:Boolean = true;
      
      private var synchronousResize:Boolean = false;
      
      private var viewSourceCMI:ContextMenuItem;
      
      private var controlBarGroupProperties:Object;
      
      [SkinPart(required="false")]
      public var controlBarGroup:spark.components.Group;
      
      [Inspectable(defaultValue="24")]
      public var frameRate:Number;
      
      public var pageTitle:String;
      
      [Inspectable(defaultValue="mx.preloaders.DownloadProgressBar")]
      public var preloader:Object;
      
      [Inspectable(defaultValue="0xCCCCCC",format="Color")]
      public var preloaderChromeColor:uint;
      
      [Inspectable(defaultValue="1000")]
      public var scriptRecursionLimit:int;
      
      [Inspectable(defaultValue="60")]
      public var scriptTimeLimit:Number;
      
      [Inspectable(defaultValue="true")]
      public var usePreloader:Boolean;
      
      mx_internal var _parameters:Object;
      
      mx_internal var _url:String;
      
      private var _viewSourceURL:String;
      
      public function Application()
      {
         this.controlBarGroupProperties = {"visible":true};
         UIComponentGlobals.layoutManager = ILayoutManager(Singleton.getInstance("mx.managers::ILayoutManager"));
         UIComponentGlobals.layoutManager.usePhasedInstantiation = true;
         if(!FlexGlobals.topLevelApplication)
         {
            FlexGlobals.topLevelApplication = this;
         }
         super();
         showInAutomationHierarchy = true;
         this.initResizeBehavior();
      }
      
      [Inspectable(defaultValue="default",enumeration="default,off,on")]
      public function get colorCorrection() : String
      {
         var sm:ISystemManager = null;
         try
         {
            sm = systemManager;
            if(Boolean(sm) && Boolean(sm.stage))
            {
               return sm.stage.colorCorrection;
            }
         }
         catch(e:SecurityError)
         {
         }
         return null;
      }
      
      public function set colorCorrection(value:String) : void
      {
         var sm:ISystemManager = systemManager;
         if(Boolean(sm) && Boolean(sm.stage) && Boolean(sm.isTopLevelRoot()))
         {
            sm.stage.colorCorrection = value;
         }
      }
      
      [ArrayElementType("mx.core.IVisualElement")]
      public function get controlBarContent() : Array
      {
         if(this.controlBarGroup)
         {
            return this.controlBarGroup.getMXMLContent();
         }
         return this.controlBarGroupProperties.controlBarContent;
      }
      
      public function set controlBarContent(value:Array) : void
      {
         if(this.controlBarGroup)
         {
            this.controlBarGroup.mxmlContent = value;
            this.controlBarGroupProperties = BitFlagUtil.update(this.controlBarGroupProperties as uint,CONTROLBAR_PROPERTY_FLAG,value != null);
         }
         else
         {
            this.controlBarGroupProperties.controlBarContent = value;
         }
         invalidateSkinState();
      }
      
      public function get controlBarLayout() : LayoutBase
      {
         return Boolean(this.controlBarGroup)?this.controlBarGroup.layout:this.controlBarGroupProperties.layout;
      }
      
      public function set controlBarLayout(value:LayoutBase) : void
      {
         if(this.controlBarGroup)
         {
            this.controlBarGroup.layout = value;
            this.controlBarGroupProperties = BitFlagUtil.update(this.controlBarGroupProperties as uint,LAYOUT_PROPERTY_FLAG,true);
         }
         else
         {
            this.controlBarGroupProperties.layout = value;
         }
      }
      
      public function get controlBarVisible() : Boolean
      {
         return Boolean(this.controlBarGroup)?Boolean(this.controlBarGroup.visible):Boolean(this.controlBarGroupProperties.visible);
      }
      
      public function set controlBarVisible(value:Boolean) : void
      {
         if(this.controlBarGroup)
         {
            this.controlBarGroup.visible = value;
            this.controlBarGroupProperties = BitFlagUtil.update(this.controlBarGroupProperties as uint,VISIBLE_PROPERTY_FLAG,value);
         }
         else
         {
            this.controlBarGroupProperties.visible = value;
         }
         invalidateSkinState();
         if(skin)
         {
            skin.invalidateSize();
         }
      }
      
      [Inspectable(environment="none")]
      override public function get id() : String
      {
         if(Boolean(!super.id) && Boolean(this == FlexGlobals.topLevelApplication) && Boolean(ExternalInterface.available))
         {
            return ExternalInterface.objectID;
         }
         return super.id;
      }
      
      override public function set percentHeight(value:Number) : void
      {
         if(value != super.percentHeight)
         {
            super.percentHeight = value;
            this.percentBoundsChanged = true;
            invalidateProperties();
         }
      }
      
      override public function set percentWidth(value:Number) : void
      {
         if(value != super.percentWidth)
         {
            super.percentWidth = value;
            this.percentBoundsChanged = true;
            invalidateProperties();
         }
      }
      
      [Inspectable(environment="none")]
      override public function set tabIndex(value:int) : void
      {
      }
      
      [Inspectable(environment="none")]
      override public function set toolTip(value:String) : void
      {
      }
      
      public function get parameters() : Object
      {
         return this._parameters;
      }
      
      public function get url() : String
      {
         return this._url;
      }
      
      public function get viewSourceURL() : String
      {
         return this._viewSourceURL;
      }
      
      public function set viewSourceURL(value:String) : void
      {
         this._viewSourceURL = value;
      }
      
      override protected function invalidateParentSizeAndDisplayList() : void
      {
         if(!includeInLayout)
         {
            return;
         }
         var p:IInvalidating = parent as IInvalidating;
         if(!p)
         {
            if(parent is ISystemManager)
            {
               ISystemManager(parent).invalidateParentSizeAndDisplayList();
            }
            return;
         }
         super.invalidateParentSizeAndDisplayList();
      }
      
      override public function initialize() : void
      {
         var sm:ISystemManager = systemManager;
         this._url = LoaderUtil.normalizeURL(sm.loaderInfo);
         this._parameters = sm.loaderInfo.parameters;
         this.initManagers(sm);
         this.initContextMenu();
         super.initialize();
         if(Boolean(sm.isTopLevel()) && Boolean(Capabilities.isDebugger == true))
         {
            setInterval(this.debugTickler,1500);
         }
      }
      
      override protected function commitProperties() : void
      {
         super.commitProperties();
         this.resizeWidth = isNaN(explicitWidth);
         this.resizeHeight = isNaN(explicitHeight);
         if(Boolean(this.resizeWidth) || Boolean(this.resizeHeight))
         {
            this.resizeHandler(new Event(Event.RESIZE));
            if(!this.resizeHandlerAdded)
            {
               systemManager.addEventListener(Event.RESIZE,this.resizeHandler,false,0,true);
               this.resizeHandlerAdded = true;
            }
         }
         else if(this.resizeHandlerAdded)
         {
            systemManager.removeEventListener(Event.RESIZE,this.resizeHandler);
            this.resizeHandlerAdded = false;
         }
         if(this.percentBoundsChanged)
         {
            this.updateBounds();
            this.percentBoundsChanged = false;
         }
      }
      
      override protected function resourcesChanged() : void
      {
         super.resourcesChanged();
         if(this.viewSourceCMI)
         {
            this.viewSourceCMI.caption = resourceManager.getString("components","viewSource");
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         var newControlBarGroupProperties:uint = 0;
         super.partAdded(partName,instance);
         if(instance == this.controlBarGroup)
         {
            newControlBarGroupProperties = 0;
            if(this.controlBarGroupProperties.controlBarContent !== undefined)
            {
               this.controlBarGroup.mxmlContent = this.controlBarGroupProperties.controlBarContent;
               newControlBarGroupProperties = BitFlagUtil.update(newControlBarGroupProperties,CONTROLBAR_PROPERTY_FLAG,true);
            }
            if(this.controlBarGroupProperties.layout !== undefined)
            {
               this.controlBarGroup.layout = this.controlBarGroupProperties.layout;
               newControlBarGroupProperties = BitFlagUtil.update(newControlBarGroupProperties,LAYOUT_PROPERTY_FLAG,true);
            }
            if(this.controlBarGroupProperties.visible !== undefined)
            {
               this.controlBarGroup.visible = this.controlBarGroupProperties.visible;
               newControlBarGroupProperties = BitFlagUtil.update(newControlBarGroupProperties,VISIBLE_PROPERTY_FLAG,true);
            }
            this.controlBarGroupProperties = newControlBarGroupProperties;
         }
      }
      
      override protected function partRemoved(partName:String, instance:Object) : void
      {
         var newControlBarGroupProperties:Object = null;
         super.partRemoved(partName,instance);
         if(instance == this.controlBarGroup)
         {
            newControlBarGroupProperties = {};
            if(BitFlagUtil.isSet(this.controlBarGroupProperties as uint,CONTROLBAR_PROPERTY_FLAG))
            {
               newControlBarGroupProperties.controlBarContent = this.controlBarGroup.getMXMLContent();
            }
            if(BitFlagUtil.isSet(this.controlBarGroupProperties as uint,LAYOUT_PROPERTY_FLAG))
            {
               newControlBarGroupProperties.layout = this.controlBarGroup.layout;
            }
            if(BitFlagUtil.isSet(this.controlBarGroupProperties as uint,VISIBLE_PROPERTY_FLAG))
            {
               newControlBarGroupProperties.visible = this.controlBarGroup.visible;
            }
            this.controlBarGroupProperties = newControlBarGroupProperties;
            this.controlBarGroup.mxmlContent = null;
            this.controlBarGroup.layout = null;
         }
      }
      
      override protected function getCurrentSkinState() : String
      {
         var state:String = !!enabled?"normal":"disabled";
         if(this.controlBarGroup)
         {
            if(Boolean(BitFlagUtil.isSet(this.controlBarGroupProperties as uint,CONTROLBAR_PROPERTY_FLAG)) && Boolean(BitFlagUtil.isSet(this.controlBarGroupProperties as uint,VISIBLE_PROPERTY_FLAG)))
            {
               state = state + "WithControlBar";
            }
         }
         else if(Boolean(this.controlBarGroupProperties.controlBarContent) && Boolean(this.controlBarGroupProperties.visible))
         {
            state = state + "WithControlBar";
         }
         return state;
      }
      
      override mx_internal function setUnscaledHeight(value:Number) : void
      {
         invalidateProperties();
         super.setUnscaledHeight(value);
      }
      
      override mx_internal function setUnscaledWidth(value:Number) : void
      {
         invalidateProperties();
         super.setUnscaledWidth(value);
      }
      
      private function debugTickler() : void
      {
         var i:int = 0;
      }
      
      private function initManagers(sm:ISystemManager) : void
      {
         var awm:IActiveWindowManager = null;
         if(sm.isTopLevel())
         {
            focusManager = new FocusManager(this);
            awm = IActiveWindowManager(sm.getImplementation("mx.managers::IActiveWindowManager"));
            if(awm)
            {
               awm.activate(this);
            }
            else
            {
               focusManager.activate();
            }
         }
      }
      
      private function initContextMenu() : void
      {
         var caption:String = null;
         if(flexContextMenu != null)
         {
            if(systemManager is InteractiveObject)
            {
               InteractiveObject(systemManager).contextMenu = contextMenu;
            }
            return;
         }
         var defaultMenu:ContextMenu = new ContextMenu();
         defaultMenu.hideBuiltInItems();
         defaultMenu.builtInItems.print = true;
         if(this._viewSourceURL)
         {
            caption = resourceManager.getString("components","viewSource");
            this.viewSourceCMI = new ContextMenuItem(caption,true);
            this.viewSourceCMI.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,this.menuItemSelectHandler);
            defaultMenu.customItems.push(this.viewSourceCMI);
         }
         contextMenu = defaultMenu;
         if(systemManager is InteractiveObject)
         {
            InteractiveObject(systemManager).contextMenu = defaultMenu;
         }
      }
      
      private function initResizeBehavior() : void
      {
         var version:Array = Capabilities.version.split(" ")[1].split(",");
         this.synchronousResize = (Boolean(parseFloat(version[0]) > 10) || Boolean(parseFloat(version[0]) == 10) && Boolean(parseFloat(version[1]) >= 1)) && Boolean(Capabilities.playerType != "Desktop");
      }
      
      private function resizeHandler(event:Event) : void
      {
         if(!this.percentBoundsChanged)
         {
            this.updateBounds();
            if(this.synchronousResize)
            {
               UIComponentGlobals.layoutManager.validateNow();
            }
         }
      }
      
      protected function menuItemSelectHandler(event:Event) : void
      {
         navigateToURL(new URLRequest(this._viewSourceURL),"_blank");
      }
      
      private function updateBounds() : void
      {
         var w:Number = NaN;
         var h:Number = NaN;
         if(this.resizeWidth)
         {
            if(isNaN(percentWidth))
            {
               w = DisplayObject(systemManager).width;
            }
            else
            {
               super.percentWidth = Math.max(percentWidth,0);
               super.percentWidth = Math.min(percentWidth,100);
               w = percentWidth * DisplayObject(systemManager).width / 100;
            }
            if(!isNaN(explicitMaxWidth))
            {
               w = Math.min(w,explicitMaxWidth);
            }
            if(!isNaN(explicitMinWidth))
            {
               w = Math.max(w,explicitMinWidth);
            }
         }
         else
         {
            w = width;
         }
         if(this.resizeHeight)
         {
            if(isNaN(percentHeight))
            {
               h = DisplayObject(systemManager).height;
            }
            else
            {
               super.percentHeight = Math.max(percentHeight,0);
               super.percentHeight = Math.min(percentHeight,100);
               h = percentHeight * DisplayObject(systemManager).height / 100;
            }
            if(!isNaN(explicitMaxHeight))
            {
               h = Math.min(h,explicitMaxHeight);
            }
            if(!isNaN(explicitMinHeight))
            {
               h = Math.max(h,explicitMinHeight);
            }
         }
         else
         {
            h = height;
         }
         if(Boolean(w != width) || Boolean(h != height))
         {
            invalidateProperties();
            invalidateSize();
         }
         setActualSize(w,h);
         invalidateDisplayList();
      }
   }
}
