package spark.accessibility
{
   import mx.accessibility.AccImpl;
   import mx.core.mx_internal;
   import spark.components.supportClasses.ListBase;
   import mx.core.UIComponent;
   import mx.accessibility.AccConst;
   import spark.components.List;
   import flash.events.Event;
   import spark.events.IndexChangeEvent;
   import flash.accessibility.Accessibility;
   
   use namespace mx_internal;
   
   public class ListBaseAccImpl extends AccImpl
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function ListBaseAccImpl(master:UIComponent)
      {
         super(master);
         role = AccConst.ROLE_SYSTEM_LIST;
      }
      
      public static function enableAccessibility() : void
      {
         ListBase.createAccessibilityImplementation = createAccessibilityImplementation;
      }
      
      mx_internal static function createAccessibilityImplementation(component:UIComponent) : void
      {
         component.accessibilityImplementation = new ListBaseAccImpl(component);
      }
      
      override protected function get eventsToHandle() : Array
      {
         return super.eventsToHandle.concat(["change","caretChange"]);
      }
      
      override public function get_accName(childID:uint) : String
      {
         if(childID == 0)
         {
            return super.get_accName(childID);
         }
         var accName:String = this.getName(childID);
         return Boolean(accName != null) && Boolean(accName != "")?accName:null;
      }
      
      override public function get_accRole(childID:uint) : uint
      {
         return childID == 0?uint(role):uint(AccConst.ROLE_SYSTEM_LISTITEM);
      }
      
      override public function get_accState(childID:uint) : uint
      {
         var index:uint = 0;
         var isInvisible:Boolean = false;
         var accState:uint = getState(childID);
         if(childID > 0)
         {
            index = childID - 1;
            isInvisible = false;
            if(isInvisible)
            {
               accState = accState | (AccConst.STATE_SYSTEM_OFFSCREEN | AccConst.STATE_SYSTEM_INVISIBLE);
            }
            else
            {
               if(master is List)
               {
                  accState = accState | AccConst.STATE_SYSTEM_SELECTABLE;
               }
               if(ListBase(master).isItemIndexSelected(index))
               {
                  accState = accState | AccConst.STATE_SYSTEM_SELECTED;
               }
               if(index == ListBase(master).caretIndex)
               {
                  accState = accState | AccConst.STATE_SYSTEM_FOCUSED;
               }
            }
         }
         else if(Boolean(master is List) && Boolean(List(master).allowMultipleSelection))
         {
            accState = accState | AccConst.STATE_SYSTEM_MULTISELECTABLE;
         }
         return accState;
      }
      
      override public function get_accDefaultAction(childID:uint) : String
      {
         if(childID == 0)
         {
            return null;
         }
         return "Double Click";
      }
      
      override public function accDoDefaultAction(childID:uint) : void
      {
         if(childID > 0)
         {
            ListBase(master).selectedIndex = childID - 1;
         }
      }
      
      override public function getChildIDArray() : Array
      {
         var n:int = Boolean(ListBase(master).dataProvider)?int(ListBase(master).dataProvider.length):int(0);
         return createChildIDArray(n);
      }
      
      override public function accLocation(childID:uint) : *
      {
         var listBase:ListBase = ListBase(master);
         var index:uint = childID - 1;
         var isInvisible:Boolean = false;
         if(isInvisible)
         {
            return null;
         }
         return this.getItemAt(index);
      }
      
      override public function get_accSelection() : Array
      {
         var accSelection:Array = [];
         var selectedIndices:Array = [];
         if(Boolean(master is List) && Boolean(List(master).allowMultipleSelection))
         {
            selectedIndices.concat(List(master).selectedIndices);
         }
         else
         {
            selectedIndices.concat(ListBase(master).selectedIndex);
         }
         var n:int = selectedIndices.length;
         for(var i:int = 0; i < n; i++)
         {
            accSelection[i] = selectedIndices[i] + 1;
         }
         return accSelection;
      }
      
      override public function get_accFocus() : uint
      {
         var index:uint = ListBase(master).caretIndex;
         return index >= 0?uint(index + 1):uint(0);
      }
      
      override public function accSelect(selFlag:uint, childID:uint) : void
      {
         var listBase:ListBase = ListBase(master);
         var index:uint = childID - 1;
         if(Boolean(index >= 0) && Boolean(index < listBase.dataProvider.length))
         {
            listBase.selectedIndex = index;
         }
      }
      
      override protected function getName(childID:uint) : String
      {
         if(childID == 0)
         {
            return "";
         }
         var listBase:ListBase = ListBase(master);
         var index:uint = childID - 1;
         if(Boolean(index < 0) || Boolean(index >= listBase.dataProvider.length))
         {
            return "";
         }
         return listBase.itemToLabel(listBase.dataProvider.getItemAt(index));
      }
      
      override protected function eventHandler(event:Event) : void
      {
         var index:uint = 0;
         var childID:uint = 0;
         $eventHandler(event);
         switch(event.type)
         {
            case "change":
               index = IndexChangeEvent(event).newIndex;
               if(index >= 0)
               {
                  childID = index + 1;
                  Accessibility.sendEvent(master,childID,AccConst.EVENT_OBJECT_SELECTION);
               }
               break;
            case "caretChange":
               index = IndexChangeEvent(event).newIndex;
               childID = index + 1;
               Accessibility.sendEvent(master,childID,AccConst.EVENT_OBJECT_FOCUS);
         }
      }
      
      private function getItemAt(index:int) : Object
      {
         if(ListBase(master).dataGroup)
         {
            return ListBase(master).dataGroup.getElementAt(index);
         }
         return master;
      }
   }
}
