package spark.accessibility
{
   import mx.core.mx_internal;
   import spark.components.supportClasses.DropDownListBase;
   import mx.core.UIComponent;
   import mx.accessibility.AccConst;
   import flash.events.Event;
   import flash.accessibility.Accessibility;
   
   use namespace mx_internal;
   
   public class DropDownListBaseAccImpl extends ListBaseAccImpl
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function DropDownListBaseAccImpl(master:UIComponent)
      {
         super(master);
         role = AccConst.ROLE_SYSTEM_COMBOBOX;
      }
      
      public static function enableAccessibility() : void
      {
         DropDownListBase.createAccessibilityImplementation = createAccessibilityImplementation;
      }
      
      mx_internal static function createAccessibilityImplementation(component:UIComponent) : void
      {
         component.accessibilityImplementation = new DropDownListBaseAccImpl(component);
      }
      
      override protected function get eventsToHandle() : Array
      {
         return super.eventsToHandle.concat(["open","close"]);
      }
      
      override public function get_accValue(childID:uint) : String
      {
         if(childID == 0)
         {
            return getName(DropDownListBase(master).selectedIndex + 1);
         }
         return null;
      }
      
      override public function get_accState(childID:uint) : uint
      {
         var accState:uint = super.get_accState(childID);
         if(childID == 0)
         {
            if(DropDownListBase(master).isDropDownOpen)
            {
               accState = accState | AccConst.STATE_SYSTEM_EXPANDED;
            }
            else
            {
               accState = accState | AccConst.STATE_SYSTEM_COLLAPSED;
            }
         }
         return accState;
      }
      
      override protected function eventHandler(event:Event) : void
      {
         var index:uint = 0;
         switch(event.type)
         {
            case "open":
               Accessibility.sendEvent(master,0,AccConst.EVENT_OBJECT_STATECHANGE);
               index = DropDownListBase(master).selectedIndex;
               if(index >= 0)
               {
                  Accessibility.sendEvent(master,index + 1,AccConst.EVENT_OBJECT_FOCUS);
               }
               break;
            case "close":
               Accessibility.sendEvent(master,0,AccConst.EVENT_OBJECT_STATECHANGE);
               Accessibility.sendEvent(master,0,AccConst.EVENT_OBJECT_FOCUS);
               break;
            case "change":
               if(!DropDownListBase(master).isDropDownOpen)
               {
                  Accessibility.sendEvent(master,0,AccConst.EVENT_OBJECT_VALUECHANGE,true);
                  break;
               }
            case "caretChange":
               if(!DropDownListBase(master).isDropDownOpen)
               {
                  break;
               }
            default:
               super.eventHandler(event);
         }
      }
   }
}
