package org.alivepdf.pdf
{
   import flash.events.IEventDispatcher;
   import org.alivepdf.layout.Size;
   import org.alivepdf.colors.IColor;
   import org.alivepdf.drawing.DashedLine;
   import flash.geom.Matrix;
   import org.alivepdf.fonts.IFont;
   import flash.utils.ByteArray;
   import flash.utils.Dictionary;
   import org.alivepdf.images.PDFImage;
   import flash.events.EventDispatcher;
   import org.alivepdf.pages.Page;
   import flash.geom.Rectangle;
   import org.alivepdf.fonts.FontMetrics;
   import org.alivepdf.data.Grid;
   import flash.display.Shape;
   import org.alivepdf.fonts.CoreFont;
   import org.alivepdf.fonts.FontFamily;
   import org.alivepdf.events.PageEvent;
   import org.alivepdf.drawing.WindingRule;
   import org.alivepdf.tools.sprintf;
   import org.alivepdf.colors.RGBColor;
   import org.alivepdf.colors.CMYKColor;
   import org.alivepdf.colors.SpotColor;
   import org.alivepdf.colors.GrayColor;
   import flash.display.BitmapData;
   import org.alivepdf.operators.Drawing;
   import org.alivepdf.visibility.Visibility;
   import org.alivepdf.annotations.Annotation;
   import org.alivepdf.annotations.TextAnnotation;
   import org.alivepdf.annotations.MovieAnnotation;
   import org.alivepdf.links.Outline;
   import org.alivepdf.links.ILink;
   import org.alivepdf.links.InternalLink;
   import org.alivepdf.links.HTTPLink;
   import org.alivepdf.fonts.EmbeddedFont;
   import flash.events.Event;
   import org.alivepdf.layout.Align;
   import org.alivepdf.cells.CellVO;
   import org.alivepdf.html.HTMLTag;
   import org.alivepdf.data.GridColumn;
   import flash.net.URLRequestHeader;
   import flash.net.URLRequest;
   import org.alivepdf.events.ProcessingEvent;
   import flash.utils.getTimer;
   import org.alivepdf.encoding.Base64;
   import flash.net.URLRequestMethod;
   import flash.net.navigateToURL;
   import org.alivepdf.saving.Method;
   import flash.display.DisplayObject;
   import org.alivepdf.layout.Resize;
   import org.alivepdf.encoding.JPEGEncoder;
   import org.alivepdf.images.ImageFormat;
   import org.alivepdf.images.DoJPEGImage;
   import org.alivepdf.encoding.PNGEncoder;
   import org.alivepdf.images.DoPNGImage;
   import org.alivepdf.encoding.TIFFEncoder;
   import org.alivepdf.images.DoTIFFImage;
   import org.alivepdf.images.gif.player.GIFPlayer;
   import org.alivepdf.images.JPEGImage;
   import org.alivepdf.images.PNGImage;
   import org.alivepdf.images.GIFImage;
   import flash.utils.Endian;
   import org.alivepdf.images.TIFFImage;
   import org.alivepdf.layout.Mode;
   import org.alivepdf.layout.Position;
   import org.alivepdf.display.Display;
   import flash.system.Capabilities;
   import flash.geom.Point;
   import org.alivepdf.layout.Unit;
   import org.alivepdf.images.ColorSpace;
   import org.alivepdf.fonts.FontDescription;
   import org.alivepdf.fonts.FontType;
   import org.alivepdf.decoding.Filter;
   import org.alivepdf.display.PageMode;
   import org.alivepdf.layout.Layout;
   
   [Event(name="started",type="org.alivepdf.events.ProcessingEvent")]
   [Event(name="resources",type="org.alivepdf.events.ProcessingEvent")]
   [Event(name="pageTree",type="org.alivepdf.events.ProcessingEvent")]
   [Event(name="complete",type="org.alivepdf.events.ProcessingEvent")]
   [Event(name="added",type="org.alivepdf.events.PageEvent")]
   public class PDF implements IEventDispatcher
   {
      
      protected static const PDF_VERSION:String = "1.3";
      
      protected static const ALIVEPDF_VERSION:String = "0.1.5 RC";
      
      protected static const STATE_0:int = 0;
      
      protected static const STATE_1:int = 1;
      
      protected static const STATE_2:int = 2;
      
      protected static const STATE_3:int = 3;
       
      protected const I1000:int = 1000;
      
      protected var format:Array;
      
      protected var size:Size;
      
      protected var margin:Number;
      
      protected var nbPages:int;
      
      protected var n:int;
      
      protected var offsets:Array;
      
      protected var state:int;
      
      protected var defaultOrientation:String;
      
      protected var defaultSize:Size;
      
      protected var defaultRotation:int;
      
      protected var defaultUnit:String;
      
      protected var currentOrientation:String;
      
      protected var orientationChanges:Array;
      
      protected var strokeColor:IColor;
      
      protected var fillColor:IColor;
      
      protected var strokeStyle:String;
      
      protected var strokeAlpha:Number;
      
      protected var strokeFlatness:Number;
      
      protected var strokeBlendMode:String;
      
      protected var strokeDash:DashedLine;
      
      protected var strokeCaps:String;
      
      protected var strokeJoints:String;
      
      protected var strokeMiter:Number;
      
      protected var textAlpha:Number;
      
      protected var textLeading:Number;
      
      protected var textColor:IColor;
      
      protected var textScale:Number;
      
      protected var textSpace:Number;
      
      protected var textWordSpace:Number;
      
      protected var k:Number;
      
      protected var leftMargin:Number;
      
      protected var topMargin:Number;
      
      protected var rightMargin:Number;
      
      protected var bottomMargin:Number;
      
      protected var currentMargin:Number;
      
      protected var currentX:Number;
      
      protected var currentY:Number;
      
      protected var currentMatrix:Matrix;
      
      protected var lasth:Number;
      
      protected var strokeThickness:Number;
      
      protected var fonts:Array;
      
      protected var differences:Array;
      
      protected var fontFamily:String;
      
      protected var fontStyle:String;
      
      protected var underline:Boolean;
      
      protected var fontSizePt:Number;
      
      protected var windingRule:String;
      
      protected var addTextColor:String;
      
      protected var colorFlag:Boolean;
      
      protected var ws:Number;
      
      protected var helvetica:IFont;
      
      protected var autoPageBreak:Boolean;
      
      protected var pageBreakTrigger:Number;
      
      protected var inHeader:Boolean;
      
      protected var inFooter:Boolean;
      
      protected var zoomMode;
      
      protected var zoomFactor:Number;
      
      protected var layoutMode:String;
      
      protected var pageMode:String;
      
      protected var isLinux:Boolean;
      
      protected var documentTitle:String;
      
      protected var documentSubject:String;
      
      protected var documentAuthor:String;
      
      protected var documentKeywords:String;
      
      protected var documentCreator:String;
      
      protected var aliasNbPages:String;
      
      protected var version:String;
      
      protected var buffer:ByteArray;
      
      protected var streamDictionary:Dictionary;
      
      protected var compressedPages:ByteArray;
      
      protected var image:PDFImage;
      
      protected var fontSize:Number;
      
      protected var name:String;
      
      protected var type:String;
      
      protected var desc:String;
      
      protected var underlinePosition:Number;
      
      protected var underlineThickness:Number;
      
      protected var charactersWidth:Object;
      
      protected var d:Number;
      
      protected var nb:int;
      
      protected var size1:Number;
      
      protected var size2:Number;
      
      protected var currentFont:IFont;
      
      protected var defaultFont:IFont;
      
      protected var b2:String;
      
      protected var filter:String;
      
      protected var filled:Boolean;
      
      protected var dispatcher:EventDispatcher;
      
      protected var arrayPages:Array;
      
      protected var arrayNotes:Array;
      
      protected var graphicStates:Array;
      
      protected var currentPage:Page;
      
      protected var outlines:Array;
      
      protected var outlineRoot:int;
      
      protected var textRendering:int;
      
      protected var viewerPreferences:String;
      
      protected var reference:String;
      
      protected var pagesReferences:Array;
      
      protected var nameDictionary:String;
      
      protected var displayObjectbounds:Rectangle;
      
      protected var coreFontMetrics:FontMetrics;
      
      protected var columnNames:Array;
      
      protected var columns:Array;
      
      protected var currentGrid:Grid;
      
      protected var isEven:int;
      
      protected var matrix:Matrix;
      
      protected var pushedFontName:String;
      
      protected var fontUnderline:Boolean;
      
      protected var jsResource:int;
      
      protected var js:String;
      
      protected var widths;
      
      protected var aligns:Array;
      
      protected var spotColors:Array;
      
      protected var drawColor:String;
      
      protected var bitmapFilled:Boolean;
      
      protected var bitmapFillBuffer:Shape;
      
      protected var visibility:String = "all";
      
      protected var nOCGPrint:int;
      
      protected var nOCGView:int;
      
      protected var startingPageIndex:uint;
      
      public function PDF(orientation:String = "Portrait", unit:String = "Mm", pageSize:Size = null, rotation:int = 0)
      {
         this.aligns = new Array();
         this.spotColors = new Array();
         this.bitmapFillBuffer = new Shape();
         super();
         this.init(orientation,unit,pageSize,rotation);
      }
      
      public function setMargins(left:Number, top:Number, right:Number = -1, bottom:Number = 20) : void
      {
         this.leftMargin = left;
         this.topMargin = top;
         if(right == -1)
         {
            right = left;
         }
         this.bottomMargin = bottom;
         this.rightMargin = right;
      }
      
      public function getMargins() : Rectangle
      {
         return new Rectangle(this.leftMargin,this.topMargin,this.getCurrentPage().w - this.rightMargin - this.leftMargin,this.getCurrentPage().h - this.bottomMargin - this.topMargin);
      }
      
      public function setLeftMargin(margin:Number) : void
      {
         this.leftMargin = margin;
         if(Boolean(this.nbPages > 0) && Boolean(this.currentX < margin))
         {
            this.currentX = margin;
         }
      }
      
      public function setTopMargin(margin:Number) : void
      {
         this.topMargin = margin;
      }
      
      public function setBottomMargin(margin:Number) : void
      {
         this.bottomMargin = margin;
      }
      
      public function setRightMargin(margin:Number) : void
      {
         this.rightMargin = margin;
      }
      
      public function setAutoPageBreak(auto:Boolean, margin:Number) : void
      {
         this.autoPageBreak = auto;
         this.bottomMargin = margin;
         if(this.currentPage != null)
         {
            this.pageBreakTrigger = this.currentPage.h - margin;
         }
      }
      
      public function setDisplayMode(zoom:String = "FullWidth", layout:String = "SinglePage", mode:String = "UseNone", zoomValue:Number = 1) : void
      {
         this.zoomMode = zoom;
         this.zoomFactor = zoomValue;
         this.layoutMode = layout;
         this.pageMode = mode;
      }
      
      public function setAdvanceTiming(timing:int) : void
      {
         this.currentPage.advanceTiming = timing;
      }
      
      public function setTitle(title:String) : void
      {
         this.documentTitle = title;
      }
      
      public function setSubject(subject:String) : void
      {
         this.documentSubject = subject;
      }
      
      public function setAuthor(author:String) : void
      {
         this.documentAuthor = author;
      }
      
      public function setKeywords(keywords:String) : void
      {
         this.documentKeywords = keywords;
      }
      
      public function setCreator(creator:String) : void
      {
         this.documentCreator = creator;
      }
      
      public function setAliasNbPages(alias:String = "{nb}") : void
      {
         this.aliasNbPages = alias;
      }
      
      public function rotatePage(number:int, rotation:Number) : void
      {
         if(Boolean(number > 0) && Boolean(number <= this.arrayPages.length))
         {
            this.arrayPages[int(number - 1)].rotate(rotation);
            return;
         }
         throw new RangeError("No page available, please select a page from 1 to " + this.arrayPages.length);
      }
      
      public function addPage(page:Page = null) : Page
      {
         if(page == null)
         {
            page = new Page(this.defaultOrientation,this.defaultUnit,this.defaultSize,this.defaultRotation);
         }
         this.pagesReferences.push(3 + (this.arrayPages.length << 1) + " 0 R");
         this.arrayPages.push(this.currentPage = page);
         page.number = this.pagesReferences.length;
         if(this.state == PDF.STATE_0)
         {
            this.open();
         }
         if(this.nbPages > 0)
         {
            this.inFooter = true;
            this.footer();
            this.inFooter = false;
            this.finishPage();
         }
         this.startPage(page != null?page.orientation:this.defaultOrientation);
         if(this.strokeColor != null)
         {
            this.lineStyle(this.strokeColor,this.strokeThickness,this.strokeFlatness,this.strokeAlpha,this.windingRule,this.strokeBlendMode,this.strokeDash,this.strokeCaps,this.strokeJoints,this.strokeMiter);
         }
         if(this.fillColor != null)
         {
            this.beginFill(this.fillColor);
         }
         if(this.textColor != null)
         {
            this.textStyle(this.textColor,this.textAlpha,this.textRendering,this.textSpace,this.textSpace,this.textScale,this.textLeading);
         }
         if(this.currentFont != null)
         {
            this.setFont(this.currentFont,this.fontSizePt);
         }
         else
         {
            this.setFont(new CoreFont(FontFamily.HELVETICA),9);
         }
         this.inHeader = true;
         this.header();
         this.inHeader = false;
         this.dispatcher.dispatchEvent(new PageEvent(PageEvent.ADDED,this.currentPage));
         return page;
      }
      
      public function getPage(index:int) : Page
      {
         var lng:int = this.arrayPages.length;
         if(Boolean(index > 0) && Boolean(index <= lng))
         {
            return this.arrayPages[int(index - 1)];
         }
         throw new RangeError("Can\'t retrieve page " + index + ". " + lng + " page(s) available.");
      }
      
      public function getPages() : Array
      {
         if(this.arrayPages.length)
         {
            return this.arrayPages;
         }
         throw new RangeError("No pages available.");
      }
      
      public function gotoPage(index:int) : void
      {
         var lng:int = this.arrayPages.length;
         if(Boolean(index > 0) && Boolean(index <= lng))
         {
            this.currentPage = this.arrayPages[index - 1];
            return;
         }
         throw new RangeError("Can\'t find page " + index + ". " + lng + " page(s) available.");
      }
      
      public function removePage(index:int) : Page
      {
         if(Boolean(index > 0) && Boolean(index <= this.arrayPages.length))
         {
            return this.arrayPages.splice(index - 1,1)[0];
         }
         throw new RangeError("Cannot remove page " + index + ".");
      }
      
      public function removeAllPages() : void
      {
         this.arrayPages = new Array();
         this.pagesReferences = new Array();
      }
      
      public function getCurrentPage() : Page
      {
         if(this.arrayPages.length > 0)
         {
            return this.currentPage;
         }
         throw new RangeError("Can\'t retrieve the current page, " + this.arrayPages.length + " pages available.");
      }
      
      public function get totalPages() : int
      {
         return this.arrayPages.length;
      }
      
      public function newLine(height:* = "") : void
      {
         this.currentX = this.leftMargin;
         this.currentY = this.currentY + (height is String?this.lasth:height);
      }
      
      public function getX() : Number
      {
         return this.currentX;
      }
      
      public function getY() : Number
      {
         return this.currentY;
      }
      
      public function setX(x:Number) : void
      {
         if(this.acceptPageBreak())
         {
            this.currentX = x >= 0?Number(x):Number(this.currentPage.w + x);
         }
         else
         {
            this.currentX = x;
         }
      }
      
      public function setY(y:Number) : void
      {
         if(this.acceptPageBreak())
         {
            this.currentX = this.leftMargin;
            this.currentY = y >= 0?Number(y):Number(this.currentPage.h + y);
         }
         else
         {
            this.currentY = y;
         }
      }
      
      public function setXY(x:Number, y:Number) : void
      {
         this.setY(y);
         this.setX(x);
      }
      
      public function getDefaultSize() : Size
      {
         return this.defaultSize;
      }
      
      public function getDefaultOrientation() : String
      {
         return this.defaultOrientation;
      }
      
      public function getDefaultUnit() : String
      {
         return this.defaultUnit;
      }
      
      public function skew(ax:Number, ay:Number, x:Number = -1, y:Number = -1) : void
      {
         if(x == -1)
         {
            x = this.getX();
         }
         if(y == -1)
         {
            y = this.getY();
         }
         if(Boolean(ax == 90) || Boolean(ay == 90))
         {
            throw new RangeError("Please use values between -90° and 90° for skewing.");
         }
         x = x * this.k;
         y = (this.currentPage.h - y) * this.k;
         ax = ax * (Math.PI / 180);
         ay = ay * (Math.PI / 180);
         this.matrix.identity();
         this.matrix.a = 1;
         this.matrix.b = Math.tan(ay);
         this.matrix.c = Math.tan(ax);
         this.matrix.d = 1;
         this.getMatrixTransformPoint(x,y);
         this.transform(this.matrix);
      }
      
      public function rotate(angle:Number, x:Number = -1, y:Number = -1) : void
      {
         if(x == -1)
         {
            x = this.getX();
         }
         if(y == -1)
         {
            y = this.getY();
         }
         angle = angle * (Math.PI / 180);
         x = x * this.k;
         y = (this.currentPage.h - y) * this.k;
         this.matrix.identity();
         this.matrix.rotate(-angle);
         this.getMatrixTransformPoint(x,y);
         this.transform(this.matrix);
      }
      
      protected function header() : void
      {
      }
      
      protected function footer() : void
      {
      }
      
      public function setAlpha(alpha:Number, blendMode:String = "Normal") : void
      {
         var graphicState:int = this.addExtGState({
            "ca":alpha,
            "SA":true,
            "CA":alpha,
            "BM":"/" + blendMode
         });
         this.setExtGState(graphicState);
      }
      
      public function moveTo(x:Number, y:Number) : void
      {
         this.write(x * this.k + " " + (this.currentPage.h - y) * this.k + " m");
      }
      
      public function lineTo(x:Number, y:Number) : void
      {
         this.write(x * this.k + " " + (this.currentPage.h - y) * this.k + " l");
      }
      
      public function end() : void
      {
         this.write(!this.filled?"s":this.windingRule == WindingRule.NON_ZERO?"b":"b*");
      }
      
      public function curveTo(controlX1:Number, controlY1:Number, controlX2:Number, controlY2:Number, finalX3:Number, finalY3:Number) : void
      {
         this.write(controlX1 * this.k + " " + (this.currentPage.h - controlY1) * this.k + " " + controlX2 * this.k + " " + (this.currentPage.h - controlY2) * this.k + " " + finalX3 * this.k + " " + (this.currentPage.h - finalY3) * this.k + " c");
      }
      
      public function lineStyle(color:IColor, thickness:Number = 1, flatness:Number = 0, alpha:Number = 1, rule:String = "NonZeroWinding", blendMode:String = "Normal", style:DashedLine = null, caps:String = null, joints:String = null, miterLimit:Number = 3) : void
      {
         this.setStrokeColor(this.strokeColor = color);
         this.strokeThickness = thickness;
         this.strokeAlpha = alpha;
         this.strokeFlatness = flatness;
         this.windingRule = rule;
         this.strokeBlendMode = blendMode;
         this.strokeDash = style;
         this.strokeCaps = caps;
         this.strokeJoints = joints;
         this.strokeMiter = miterLimit;
         this.setAlpha(alpha,blendMode);
         if(this.nbPages > 0)
         {
            this.write(sprintf("%.2f w",thickness * this.k));
         }
         this.write(flatness + " i ");
         this.write(style != null?style.pattern:"[] 0 d");
         if(caps != null)
         {
            this.write(caps);
         }
         if(joints != null)
         {
            this.write(joints);
         }
         this.write(miterLimit + " M");
      }
      
      protected function setStrokeColor(color:IColor, tint:Number = 100) : void
      {
         var op:String = null;
         var r:Number = NaN;
         var g:Number = NaN;
         var b:Number = NaN;
         var c:Number = NaN;
         var m:Number = NaN;
         var y:Number = NaN;
         var k:Number = NaN;
         var gray:Number = NaN;
         if(color is RGBColor)
         {
            op = "RG";
            r = (color as RGBColor).r / 255;
            g = (color as RGBColor).g / 255;
            b = (color as RGBColor).b / 255;
            this.write(r + " " + g + " " + b + " " + op);
         }
         else if(color is CMYKColor)
         {
            op = "K";
            c = (color as CMYKColor).cyan * 0.01;
            m = (color as CMYKColor).magenta * 0.01;
            y = (color as CMYKColor).yellow * 0.01;
            k = (color as CMYKColor).black * 0.01;
            this.write(c + " " + m + " " + y + " " + k + " " + op);
         }
         else if(color is SpotColor)
         {
            if(this.spotColors.indexOf(color) == -1)
            {
               this.spotColors.push(color);
            }
            this.write(sprintf("/CS%d CS %.3F SCN",(color as SpotColor).i,tint * 0.01));
         }
         else
         {
            op = "G";
            gray = (color as GrayColor).gray * 0.01;
            this.write(gray + " " + op);
         }
      }
      
      protected function setTextColor(color:IColor, tint:Number = 100) : void
      {
         var op:String = null;
         var r:Number = NaN;
         var g:Number = NaN;
         var b:Number = NaN;
         var c:Number = NaN;
         var m:Number = NaN;
         var y:Number = NaN;
         var k:Number = NaN;
         var gray:Number = NaN;
         if(color is RGBColor)
         {
            op = !this.textRendering?"rg":"RG";
            r = (color as RGBColor).r / 255;
            g = (color as RGBColor).g / 255;
            b = (color as RGBColor).b / 255;
            this.addTextColor = r + " " + g + " " + b + " " + op;
         }
         else if(color is CMYKColor)
         {
            op = !this.textRendering?"k":"K";
            c = (color as CMYKColor).cyan * 0.01;
            m = (color as CMYKColor).magenta * 0.01;
            y = (color as CMYKColor).yellow * 0.01;
            k = (color as CMYKColor).black * 0.01;
            this.addTextColor = c + " " + m + " " + y + " " + k + " " + op;
         }
         else if(color is SpotColor)
         {
            if(this.spotColors.indexOf(color) == -1)
            {
               this.spotColors.push(color);
            }
            this.addTextColor = sprintf("/CS%d cs %.3F scn",(color as SpotColor).i,tint * 0.01);
            this.colorFlag = this.fillColor != this.textColor;
         }
         else
         {
            op = !this.textRendering?"g":"G";
            gray = (color as GrayColor).gray * 0.01;
            this.addTextColor = gray + " " + op;
         }
      }
      
      public function beginFill(color:IColor, tint:Number = 100) : void
      {
         var op:String = null;
         var r:Number = NaN;
         var g:Number = NaN;
         var b:Number = NaN;
         var c:Number = NaN;
         var m:Number = NaN;
         var y:Number = NaN;
         var k:Number = NaN;
         var gray:Number = NaN;
         this.filled = true;
         this.fillColor = color;
         if(color is RGBColor)
         {
            op = "rg";
            r = (color as RGBColor).r / 255;
            g = (color as RGBColor).g / 255;
            b = (color as RGBColor).b / 255;
            this.write(r + " " + g + " " + b + " " + op);
         }
         else if(color is CMYKColor)
         {
            op = "k";
            c = (color as CMYKColor).cyan * 0.01;
            m = (color as CMYKColor).magenta * 0.01;
            y = (color as CMYKColor).yellow * 0.01;
            k = (color as CMYKColor).black * 0.01;
            this.write(c + " " + m + " " + y + " " + k + " " + op);
         }
         else if(color is SpotColor)
         {
            if(this.spotColors.indexOf(color) == -1)
            {
               this.spotColors.push(color);
            }
            this.write(sprintf("/CS%d cs %.3F scn",(color as SpotColor).i,tint * 0.01));
            this.colorFlag = this.fillColor != this.textColor;
         }
         else
         {
            op = "g";
            gray = (color as GrayColor).gray * 0.01;
            this.write(gray + " " + op);
         }
      }
      
      public function beginBitmapFill(bitmap:BitmapData, matrix:Matrix = null) : void
      {
         this.bitmapFilled = true;
         this.bitmapFillBuffer = new Shape();
         this.bitmapFillBuffer.graphics.beginBitmapFill(bitmap,matrix);
      }
      
      public function endFill() : void
      {
         if(!this.bitmapFilled)
         {
            this.filled = false;
         }
         else
         {
            this.bitmapFilled = false;
         }
      }
      
      public function drawRect(rect:Rectangle) : void
      {
         var style:String = null;
         if(!this.bitmapFilled)
         {
            style = !!this.filled?Drawing.CLOSE_AND_FILL_AND_STROKE:Drawing.STROKE;
            this.write(sprintf("%.2f %.2f %.2f %.2f re %s",rect.x * this.k,(this.currentPage.h - rect.y) * this.k,rect.width * this.k,-rect.height * this.k,style));
         }
         else
         {
            this.bitmapFillBuffer.graphics.drawRect(rect.x,rect.y,rect.width,rect.height);
            this.addImage(this.bitmapFillBuffer,null,rect.x,rect.y,rect.width,rect.height);
         }
      }
      
      public function drawRoundRect(rect:Rectangle, ellipseWidth:Number) : void
      {
         if(!this.bitmapFilled)
         {
            this.drawRoundRectComplex(rect,ellipseWidth,ellipseWidth,ellipseWidth,ellipseWidth);
         }
         else
         {
            this.bitmapFillBuffer.graphics.drawRoundRect(rect.x,rect.y,rect.width,rect.height,ellipseWidth,ellipseWidth);
            this.addImage(this.bitmapFillBuffer,null,rect.x,rect.y);
         }
      }
      
      public function drawRoundRectComplex(rect:Rectangle, topLeftEllipseWidth:Number, topRightEllipseWidth:Number, bottomLeftEllipseWidth:Number, bottomRightEllipseWidth:Number) : void
      {
         var k:Number = NaN;
         var hp:Number = NaN;
         var MyArc:Number = NaN;
         var xc:Number = NaN;
         var yc:Number = NaN;
         var style:String = null;
         if(!this.bitmapFilled)
         {
            k = this.k;
            hp = this.currentPage.h;
            MyArc = 4 / 3 * (Math.sqrt(2) - 1);
            this.write(sprintf("%.2f %.2f m",(rect.x + topLeftEllipseWidth) * k,(hp - rect.y) * k));
            xc = rect.x + rect.width - topRightEllipseWidth;
            yc = rect.y + topRightEllipseWidth;
            this.write(sprintf("%.2f %.2f l",xc * k,(hp - rect.y) * k));
            this.curve(xc + topRightEllipseWidth * MyArc,yc - topRightEllipseWidth,xc + topRightEllipseWidth,yc - topRightEllipseWidth * MyArc,xc + topRightEllipseWidth,yc);
            xc = rect.x + rect.width - bottomRightEllipseWidth;
            yc = rect.y + rect.height - bottomRightEllipseWidth;
            this.write(sprintf("%.2f %.2f l",(rect.x + rect.width) * k,(hp - yc) * k));
            this.curve(xc + bottomRightEllipseWidth,yc + bottomRightEllipseWidth * MyArc,xc + bottomRightEllipseWidth * MyArc,yc + bottomRightEllipseWidth,xc,yc + bottomRightEllipseWidth);
            xc = rect.x + bottomLeftEllipseWidth;
            yc = rect.y + rect.height - bottomLeftEllipseWidth;
            this.write(sprintf("%.2f %.2f l",xc * k,(hp - (rect.y + rect.height)) * k));
            this.curve(xc - bottomLeftEllipseWidth * MyArc,yc + bottomLeftEllipseWidth,xc - bottomLeftEllipseWidth,yc + bottomLeftEllipseWidth * MyArc,xc - bottomLeftEllipseWidth,yc);
            xc = rect.x + topLeftEllipseWidth;
            yc = rect.y + topLeftEllipseWidth;
            this.write(sprintf("%.2f %.2f l",rect.x * k,(hp - yc) * k));
            this.curve(xc - topLeftEllipseWidth,yc - topLeftEllipseWidth * MyArc,xc - topLeftEllipseWidth * MyArc,yc - topLeftEllipseWidth,xc,yc - topLeftEllipseWidth);
            style = !!this.filled?Drawing.CLOSE_AND_FILL_AND_STROKE:Drawing.STROKE;
            this.write(style);
         }
         else
         {
            this.bitmapFillBuffer.graphics.drawRoundRectComplex(rect.x,rect.y,rect.width,rect.height,topLeftEllipseWidth,topRightEllipseWidth,bottomLeftEllipseWidth,bottomRightEllipseWidth);
            this.addImage(this.bitmapFillBuffer,null,rect.x,rect.y);
         }
      }
      
      public function drawEllipse(x:Number, y:Number, radiusX:Number, radiusY:Number) : void
      {
         var style:String = null;
         var lx:Number = NaN;
         var ly:Number = NaN;
         var k:Number = NaN;
         var h:Number = NaN;
         if(!this.bitmapFilled)
         {
            style = !!this.filled?Drawing.CLOSE_AND_FILL_AND_STROKE:Drawing.STROKE;
            lx = 4 / 3 * (1.4142135623731 - 1) * radiusX;
            ly = 4 / 3 * (1.4142135623731 - 1) * radiusY;
            k = this.k;
            h = this.currentPage.h;
            this.write(sprintf("%.2f %.2f m %.2f %.2f %.2f %.2f %.2f %.2f c",(x + radiusX) * k,(h - y) * k,(x + radiusX) * k,(h - (y - ly)) * k,(x + lx) * k,(h - (y - radiusY)) * k,x * k,(h - (y - radiusY)) * k));
            this.write(sprintf("%.2f %.2f %.2f %.2f %.2f %.2f c",(x - lx) * k,(h - (y - radiusY)) * k,(x - radiusX) * k,(h - (y - ly)) * k,(x - radiusX) * k,(h - y) * k));
            this.write(sprintf("%.2f %.2f %.2f %.2f %.2f %.2f c",(x - radiusX) * k,(h - (y + ly)) * k,(x - lx) * k,(h - (y + radiusY)) * k,x * k,(h - (y + radiusY)) * k));
            this.write(sprintf("%.2f %.2f %.2f %.2f %.2f %.2f c %s",(x + lx) * k,(h - (y + radiusY)) * k,(x + radiusX) * k,(h - (y + ly)) * k,(x + radiusX) * k,(h - y) * k,style));
         }
         else
         {
            this.bitmapFillBuffer.graphics.drawEllipse(x,y,radiusX,radiusY);
            this.addImage(this.bitmapFillBuffer,null,x,y);
         }
      }
      
      public function drawCircle(x:Number, y:Number, radius:Number) : void
      {
         this.drawEllipse(x,y,radius,radius);
      }
      
      public function drawPolygone(points:Array) : void
      {
         var pos:int = 0;
         var lng:int = points.length;
         var i:int = 0;
         while(i < lng)
         {
            pos = int(i + 1);
            if(i == 0)
            {
               this.moveTo(points[i],points[pos]);
            }
            else
            {
               this.lineTo(points[i],points[pos]);
            }
            i = i + 2;
         }
         this.end();
      }
      
      public function setVisible(visible:String) : void
      {
         if(this.visibility != Visibility.ALL)
         {
            this.write("EMC");
         }
         if(visible == Visibility.PRINT)
         {
            this.write("/OC /OC1 BDC");
         }
         else if(visible == Visibility.SCREEN)
         {
            this.write("/OC /OC2 BDC");
         }
         else if(visible != Visibility.ALL)
         {
            throw new Error("Incorrect visibility: " + visible);
         }
         this.visibility = visible;
      }
      
      public function addAnnotation(annotation:Annotation) : void
      {
         var textAnnotation:TextAnnotation = null;
         var movieAnnotation:MovieAnnotation = null;
         var rectangle:String = annotation.x * this.k + " " + ((this.currentPage.h - annotation.y) * this.k - annotation.height * this.k) + " " + (annotation.x * this.k + annotation.width * this.k) + " " + (this.currentPage.h - annotation.y) * this.k;
         if(annotation is TextAnnotation)
         {
            textAnnotation = annotation as TextAnnotation;
            this.currentPage.annotations = this.currentPage.annotations + ("<</Type /Annot /Border [0 0 1] /Subtype /" + textAnnotation.type + " /Contents " + this.escapeString(textAnnotation.text) + " /Rect [ " + rectangle + " ]>>");
         }
         else if(annotation is MovieAnnotation)
         {
            movieAnnotation = annotation as MovieAnnotation;
            this.currentPage.annotations = this.currentPage.annotations + ("<</Type /Annot /Border [0 0 1] /Subtype /" + movieAnnotation.type + " /Contents " + this.escapeString(movieAnnotation.text) + " /Rect [ " + rectangle + " ]>>");
         }
      }
      
      public function addBookmark(text:String, level:int = 0, y:Number = -1, color:RGBColor = null) : void
      {
         if(color == null)
         {
            color = new RGBColor(0);
         }
         if(y == -1)
         {
            y = this.getY();
         }
         this.outlines.push(new Outline(text,level,this.nbPages,y,color.r,color.g,color.b));
      }
      
      public function addLink(x:Number, y:Number, width:Number, height:Number, link:ILink, highlight:String = "I") : void
      {
         var currentLink:InternalLink = null;
         var h:Number = NaN;
         var rectangle:String = x * this.k + " " + (this.currentPage.h - y - height) * this.k + " " + (x + width) * this.k + " " + (this.currentPage.h - y) * this.k;
         this.currentPage.annotations = this.currentPage.annotations + ("<</Type /Annot /Subtype /Link /Rect [" + rectangle + "] /Border [0 0 0] /H /" + highlight + " ");
         if(link is HTTPLink)
         {
            this.currentPage.annotations = this.currentPage.annotations + ("/A <</S /URI /URI " + this.escapeString((link as HTTPLink).link) + ">>>>");
         }
         else
         {
            currentLink = link as InternalLink;
            h = this.orientationChanges[currentLink.page] != null?Number(this.currentPage.wPt):Number(this.currentPage.hPt);
            if(currentLink.rectangle != null)
            {
               this.currentPage.annotations = this.currentPage.annotations + sprintf("/Dest [%d 0 R /FitR %.2f %.2f %.2f %.2f]>>",1 + 2 * currentLink.page,currentLink.rectangle.x * this.k,(this.currentPage.h - currentLink.rectangle.y - currentLink.rectangle.height) * this.k,(currentLink.rectangle.x + currentLink.rectangle.width) * this.k,(this.currentPage.h - currentLink.rectangle.y) * this.k);
            }
            else if(!currentLink.fit)
            {
               this.currentPage.annotations = this.currentPage.annotations + sprintf("/Dest [%d 0 R /XYZ 0 %.2f null]>>",1 + 2 * currentLink.page,(this.currentPage.h - currentLink.y) * this.k);
            }
            else if(currentLink.fit)
            {
               this.currentPage.annotations = this.currentPage.annotations + sprintf("/Dest [%d 0 R /Fit]>>",1 + 2 * currentLink.page);
            }
         }
      }
      
      public function getCurrentInternalLink() : InternalLink
      {
         return new InternalLink(this.totalPages,this.currentY);
      }
      
      public function addTransition(style:String = "R", duration:Number = 1, dimension:String = "H", motionDirection:String = "I", transitionDirection:int = 0) : void
      {
         this.currentPage.addTransition(style,duration,dimension,motionDirection,transitionDirection);
      }
      
      public function setViewerPreferences(toolbar:String = "false", menubar:String = "false", windowUI:String = "false", fitWindow:String = "false", centeredWindow:String = "false", displayTitle:String = "false") : void
      {
         this.viewerPreferences = "<< /HideToolbar " + toolbar + " /HideMenubar " + menubar + " /HideWindowUI " + windowUI + " /FitWindow " + fitWindow + " /CenterWindow " + centeredWindow + " /DisplayDocTitle " + displayTitle + " >>";
      }
      
      public function setStartingPage(index:int) : void
      {
         var lng:int = this.arrayPages.length;
         if(Boolean(index > 0) && Boolean(index <= lng))
         {
            this.startingPageIndex = index - 1;
            return;
         }
         throw new RangeError("Can\'t set page " + index + ". " + lng + " page(s) available.");
      }
      
      private function insertSpotColors() : void
      {
         var color:SpotColor = null;
         for each(color in this.spotColors)
         {
            this.newObj();
            this.write("[/Separation /" + this.findAndReplace(" ","#20",color.name));
            this.write("/DeviceCMYK <<");
            this.write("/Range [0 1 0 1 0 1 0 1] /C0 [0 0 0 0] ");
            this.write(sprintf("/C1 [%.3F %.3F %.3F %.3F] ",color.color.cyan * 0.01,color.color.magenta * 0.01,color.color.yellow * 0.01,color.color.black * 0.01));
            this.write("/FunctionType 2 /Domain [0 1] /N 1>>]");
            this.write("endobj");
            color.n = this.n;
         }
      }
      
      protected function addFont(font:IFont) : IFont
      {
         var addedFont:EmbeddedFont = null;
         var j:int = 0;
         this.pushedFontName = font.name;
         if(!this.fonts.some(this.filterCallback))
         {
            this.fonts.push(font);
         }
         font.id = this.fonts.length;
         this.fontFamily = font.name;
         if(font is EmbeddedFont)
         {
            addedFont = font as EmbeddedFont;
            if(addedFont.differences != null)
            {
               this.d = -1;
               this.nb = this.differences.length;
               for(j = 0; j < this.nb; j++)
               {
                  if(this.differences[j] == addedFont.differences)
                  {
                     this.d = j;
                     break;
                  }
               }
               if(this.d == -1)
               {
                  this.d = this.nb;
                  this.differences[this.d] = addedFont.differences;
               }
               this.fonts[this.fonts.length - 1].differences = this.d;
            }
         }
         return font;
      }
      
      private function characterMissing(e:Event) : void
      {
         this.dispatchEvent(e);
      }
      
      private function filterCallback(element:IFont, index:int, arr:Array) : Boolean
      {
         return element.name == this.pushedFontName;
      }
      
      public function setFont(font:IFont, size:int = 12, underlined:Boolean = false) : void
      {
         this.pushedFontName = font.name;
         var result:Array = this.fonts.filter(this.filterCallback);
         this.currentFont = result.length > 0?result[0]:this.addFont(font);
         this.underline = underlined;
         this.fontFamily = this.currentFont.name;
         this.fontSizePt = size;
         this.fontSize = size / this.k;
         if(this.nbPages > 0)
         {
            this.write(sprintf("BT /F%d %.2f Tf ET",this.currentFont.id,this.fontSizePt));
         }
      }
      
      public function setFontSize(size:int) : void
      {
         if(this.fontSizePt == size)
         {
            return;
         }
         this.fontSizePt = size;
         this.fontSize = size / this.k;
         if(this.nbPages > 0)
         {
            this.write(sprintf("BT /F%d %.2f Tf ET",this.currentFont.id,this.fontSizePt));
         }
      }
      
      public function removeFont(font:IFont) : void
      {
         if(!(font.type is EmbeddedFont))
         {
            throw new Error("The font you have passed is a Core font. Core fonts cannot be removed as they are not embedded in the PDF.");
         }
         var position:int = this.fonts.indexOf(font);
         if(position != -1)
         {
            this.fonts.splice(position,1);
            return;
         }
         throw new Error("Font cannot be found.");
      }
      
      public function get totalFonts() : int
      {
         return this.fonts.length;
      }
      
      public function getFonts() : Array
      {
         return this.fonts;
      }
      
      public function addText(text:String, x:Number = 0, y:Number = 0) : void
      {
         var s:String = sprintf("BT %.2f %.2f Td (%s) Tj ET",x * this.k,(this.currentPage.h - y) * this.k,this.escapeIt(text));
         if(Boolean(this.underline) && Boolean(text != ""))
         {
            s = s + (" " + this.doUnderline(x,y,text));
         }
         if(this.colorFlag)
         {
            s = "q " + this.addTextColor + " " + s + " Q";
         }
         this.write(s);
      }
      
      public function textStyle(color:IColor, alpha:Number = 1, rendering:int = 0, wordSpace:Number = 0, characterSpace:Number = 0, scale:Number = 100, leading:Number = 0) : void
      {
         this.textColor = color;
         this.textAlpha = alpha;
         this.textWordSpace = wordSpace;
         this.textSpace = characterSpace;
         this.textScale = scale;
         this.textLeading = leading;
         this.write(sprintf("%d Tr",this.textRendering = rendering));
         this.setTextColor(color);
         this.setAlpha(alpha);
         this.write(wordSpace + " Tw " + characterSpace + " Tc " + scale + " Tz " + leading + " TL ");
         this.colorFlag = this.fillColor != this.addTextColor;
      }
      
      public function addCell(width:Number = 0, height:Number = 0, text:String = "", border:* = 0, ln:Number = 0, align:String = "", fill:Number = 0, link:ILink = null) : void
      {
         var op:String = null;
         var x:Number = NaN;
         var borderBuffer:String = null;
         var currentPageHeight:Number = NaN;
         var dx:Number = NaN;
         var txt2:String = null;
         if(Boolean(this.currentY + height > this.pageBreakTrigger) && Boolean(!this.inHeader) && Boolean(!this.inFooter) && Boolean(this.acceptPageBreak()))
         {
            x = this.currentX;
            if(this.ws > 0)
            {
               this.ws = 0;
               this.write("0 Tw");
            }
            this.addPage(new Page(this.currentOrientation,this.defaultUnit,this.defaultSize,this.currentPage.rotation));
            this.currentX = x;
            if(this.ws > 0)
            {
               this.write(sprintf("%.3f Tw",this.ws * this.k));
            }
         }
         if(this.currentPage.w == 0)
         {
            this.currentPage.w = this.currentPage.w - this.rightMargin - this.currentX;
         }
         var s:String = new String();
         if(Boolean(fill == 1) || Boolean(border == 1))
         {
            if(fill == 1)
            {
               op = border == 1?Drawing.FILL_AND_STROKE:Drawing.FILL;
            }
            else
            {
               op = Drawing.STROKE;
            }
            s = sprintf("%.2f %.2f %.2f %.2f re %s ",this.currentX * this.k,(this.currentPage.h - this.currentY) * this.k,width * this.k,-height * this.k,op);
            this.endFill();
         }
         if(border is String)
         {
            borderBuffer = String(border);
            currentPageHeight = this.currentPage.h;
            if(borderBuffer.indexOf(Align.LEFT) != -1)
            {
               s = s + sprintf("%.2f %.2f m %.2f %.2f l S ",this.currentX * this.k,(currentPageHeight - this.currentY) * this.k,this.currentX * this.k,(currentPageHeight - (this.currentY + height)) * this.k);
            }
            if(borderBuffer.indexOf(Align.TOP) != -1)
            {
               s = s + sprintf("%.2f %.2f m %.2f %.2f l S ",this.currentX * this.k,(currentPageHeight - this.currentY) * this.k,(this.currentX + width) * this.k,(currentPageHeight - this.currentY) * this.k);
            }
            if(borderBuffer.indexOf(Align.RIGHT) != -1)
            {
               s = s + sprintf("%.2f %.2f m %.2f %.2f l S ",(this.currentX + width) * this.k,(currentPageHeight - this.currentY) * this.k,(this.currentX + width) * this.k,(currentPageHeight - (this.currentY + height)) * this.k);
            }
            if(borderBuffer.indexOf(Align.BOTTOM) != -1)
            {
               s = s + sprintf("%.2f %.2f m %.2f %.2f l S ",this.currentX * this.k,(currentPageHeight - (this.currentY + height)) * this.k,(this.currentX + width) * this.k,(currentPageHeight - (this.currentY + height)) * this.k);
            }
         }
         if(text !== "")
         {
            if(align == Align.RIGHT)
            {
               dx = width - this.currentMargin - this.getStringWidth(text);
            }
            else if(align == Align.CENTER)
            {
               dx = (width - this.getStringWidth(text)) * 0.5;
            }
            else
            {
               dx = this.currentMargin;
            }
            if(this.colorFlag)
            {
               s = s + ("q " + this.addTextColor + " ");
            }
            txt2 = this.findAndReplace(")","\\)",this.findAndReplace("(","\\(",this.findAndReplace("\\","\\\\",text)));
            s = s + sprintf("BT %.2f %.2f Td (%s) Tj ET",(this.currentX + dx) * this.k,(this.currentPage.h - (this.currentY + 0.5 * height + 0.3 * this.fontSize)) * this.k,txt2);
            if(this.underline)
            {
               s = s + (" " + this.doUnderline(this.currentX + dx,this.currentY + 0.5 * height + 0.3 * this.fontSize,text));
            }
            if(this.colorFlag)
            {
               s = s + " Q";
            }
            if(link != null)
            {
               this.addLink(this.currentX + dx,this.currentY + 0.5 * height - 0.5 * this.fontSize,this.getStringWidth(text),this.fontSize,link);
            }
         }
         if(s != "")
         {
            this.write(s);
         }
         this.lasth = this.currentPage.h;
         if(ln > 0)
         {
            this.currentY = this.currentY + height;
            if(ln == 1)
            {
               this.currentX = this.leftMargin;
            }
         }
         else
         {
            this.currentX = this.currentX + width;
         }
      }
      
      public function addMultiCell(width:Number, height:Number, text:String, border:* = 0, align:String = "J", filled:int = 0) : void
      {
         var c:String = null;
         var ls:int = 0;
         this.charactersWidth = this.currentFont.charactersWidth;
         if(width == 0)
         {
            width = this.currentPage.w - this.rightMargin - this.currentX;
         }
         var wmax:Number = (width - 2 * this.currentMargin) * this.I1000 / this.fontSize;
         var s:String = this.findAndReplace("\r","",text);
         var nb:int = s.length;
         if(Boolean(nb > 0) && Boolean(s.charAt(nb - 1) == "\n"))
         {
            nb--;
         }
         var b:* = 0;
         if(border)
         {
            if(border == 1)
            {
               border = "LTRB";
               b = "LRT";
               this.b2 = "LR";
            }
            else
            {
               this.b2 = "";
               if(border.indexOf(Align.LEFT) != -1)
               {
                  this.b2 = this.b2 + Align.LEFT;
               }
               if(border.indexOf(Align.RIGHT) != -1)
               {
                  this.b2 = this.b2 + Align.RIGHT;
               }
               b = border.indexOf(Align.TOP) != -1?this.b2 + Align.TOP:this.b2;
            }
         }
         var sep:int = -1;
         var i:int = 0;
         var j:int = 0;
         var l:int = 0;
         var ns:int = 0;
         var nl:int = 1;
         var cwAux:int = 0;
         while(i < nb)
         {
            c = s.charAt(i);
            if(c == "\n")
            {
               if(this.ws > 0)
               {
                  this.ws = 0;
                  this.write("0 Tw");
               }
               this.addCell(width,height,s.substr(j,i - j),b,2,align,filled);
               i++;
               sep = -1;
               j = i;
               l = 0;
               ns = 0;
               nl++;
               if(Boolean(border) && Boolean(nl == 2))
               {
                  b = this.b2;
               }
            }
            else
            {
               if(c == " ")
               {
                  sep = i;
                  ls = l;
                  ns++;
               }
               cwAux = this.charactersWidth[c] as int;
               if(cwAux == 0)
               {
                  cwAux = FontMetrics.DEFAULT_WIDTH;
               }
               l = l + cwAux;
               if(l > wmax)
               {
                  if(sep == -1)
                  {
                     if(i == j)
                     {
                        i++;
                     }
                     if(this.ws > 0)
                     {
                        this.ws = 0;
                        this.write("0 Tw");
                     }
                     this.addCell(width,height,s.substr(j,i - j),b,2,align,filled);
                  }
                  else
                  {
                     if(align == Align.JUSTIFIED)
                     {
                        this.ws = ns > 1?Number((wmax - ls) * 0.001 * this.fontSize / (ns - 1)):Number(0);
                        this.write(sprintf("%.3f Tw",this.ws * this.k));
                     }
                     this.addCell(width,height,s.substr(j,sep - j),b,2,align,filled);
                     i = sep + 1;
                  }
                  sep = -1;
                  j = i;
                  l = 0;
                  ns = 0;
                  nl++;
                  if(Boolean(border) && Boolean(nl == 2))
                  {
                     b = this.b2;
                  }
               }
               else
               {
                  i++;
               }
            }
         }
         if(this.ws > 0)
         {
            this.ws = 0;
            this.write("0 Tw");
         }
         if(Boolean(border) && Boolean(border.indexOf("B") != -1))
         {
            b = b + "B";
         }
         this.addCell(width,height,s.substr(j,i - j),b,2,align,filled);
         this.currentX = this.leftMargin;
      }
      
      public function writeText(lineHeight:Number, text:String, link:ILink = null) : void
      {
         var c:String = null;
         var cwAux:int = 0;
         var cw:Object = this.currentFont.charactersWidth;
         var w:Number = this.currentPage.w - this.rightMargin - this.currentX;
         var wmax:Number = (w - 2 * this.currentMargin) * this.I1000 / this.fontSize;
         var s:String = this.findAndReplace("\r","",text);
         var nb:int = s.length;
         var sep:int = -1;
         var i:int = 0;
         var j:int = 0;
         var l:int = 0;
         var nl:int = 1;
         while(i < nb)
         {
            c = s.charAt(i);
            if(c == "\n")
            {
               this.addCell(w,lineHeight,s.substr(j,i - j),0,2,"",0,link);
               i++;
               sep = -1;
               j = i;
               l = 0;
               if(nl == 1)
               {
                  this.currentX = this.leftMargin;
                  w = this.currentPage.w - this.rightMargin - this.currentX;
                  wmax = (w - 2 * this.currentMargin) * this.I1000 / this.fontSize;
               }
               nl++;
            }
            else
            {
               if(c == " ")
               {
                  sep = i;
               }
               cwAux = cw[c] as int;
               if(cwAux == 0)
               {
                  cwAux = FontMetrics.DEFAULT_WIDTH;
               }
               l = l + cwAux;
               if(l > wmax)
               {
                  if(sep == -1)
                  {
                     if(this.currentX > this.leftMargin)
                     {
                        this.currentX = this.leftMargin;
                        this.currentY = this.currentY + this.currentPage.h;
                        w = this.currentPage.w - this.rightMargin - this.currentX;
                        wmax = (w - 2 * this.currentMargin) * this.I1000 / this.fontSize;
                        i++;
                        nl++;
                        continue;
                     }
                     if(i == j)
                     {
                        i++;
                     }
                     this.addCell(w,lineHeight,s.substr(j,i - j),0,2,"",0,link);
                  }
                  else
                  {
                     this.addCell(w,lineHeight,s.substr(j,sep - j),0,2,"",0,link);
                     i = sep + 1;
                  }
                  sep = -1;
                  j = i;
                  l = 0;
                  if(nl == 1)
                  {
                     this.currentX = this.leftMargin;
                     w = this.currentPage.w - this.rightMargin - this.currentX;
                     wmax = (w - 2 * this.currentMargin) * this.I1000 / this.fontSize;
                  }
                  nl++;
               }
               else
               {
                  i++;
               }
            }
         }
         if(i != j)
         {
            this.addCell(l * 0.001 * this.fontSize,lineHeight,s.substr(j),0,0,"",0,link);
         }
      }
      
      public function writeFlashHtmlText(pHeight:Number, pText:String, pLink:ILink = null) : void
      {
         var nb:int = 0;
         var cellVO:CellVO = null;
         var fontBold:Boolean = false;
         var fontItalic:Boolean = false;
         var attr:XML = null;
         var cwAux:int = 0;
         var fs:int = 0;
         var fontColor:RGBColor = null;
         var cs:int = 0;
         var newFont:IFont = null;
         var c:String = null;
         var cw:Object = this.currentFont.charactersWidth;
         var w:Number = this.currentPage.w - this.rightMargin - this.currentX;
         var wmax:Number = (w - 2 * this.currentMargin) * this.I1000 / this.fontSize;
         var s:String = this.findAndReplace("\r","",pText);
         s = this.findAndReplace("\n","",s);
         var sep:int = -1;
         var lenAtSep:Number = 0;
         var i:int = 0;
         var j:int = 0;
         var l:int = 0;
         var k:int = 0;
         var ns:int = 0;
         var prevWhiteSpace:Boolean = XML.ignoreWhitespace;
         XML.ignoreWhitespace = false;
         var aTaggedString:Array = this.parseTags(new XML("<html>" + s + "</html>"));
         XML.ignoreWhitespace = prevWhiteSpace;
         var currentLine:Array = new Array();
         fontBold = false;
         fontItalic = false;
         this.fontUnderline = false;
         var textAlign:String = "";
         var lng:int = aTaggedString.length;
         k = 0;
         loop0:
         while(true)
         {
            if(k >= lng)
            {
               if(currentLine.length > 0)
               {
                  this.renderLine(currentLine,textAlign);
                  this.lineBreak(pHeight);
                  currentLine = new Array();
               }
               this.currentY = this.currentY + this.currentPage.h;
               return;
            }
            switch(aTaggedString[k].tag.toUpperCase())
            {
               case "<TEXTFORMAT>":
               case "</TEXTFORMAT>":
                  break;
               case "<P>":
                  for each(attr in aTaggedString[k].attr)
                  {
                     switch(String(attr.name()).toUpperCase())
                     {
                        case "ALIGN":
                           textAlign = String(attr).charAt(0);
                           continue;
                        default:
                           continue;
                     }
                  }
                  break;
               case "</P>":
                  this.renderLine(currentLine,textAlign);
                  currentLine = new Array();
                  this.currentX = this.leftMargin;
                  textAlign = "";
                  ns = 0;
                  this.lineBreak(pHeight);
                  break;
               case "<FONT>":
                  for each(attr in aTaggedString[k].attr)
                  {
                     switch(String(attr.name()).toUpperCase())
                     {
                        case "FACE":
                           continue;
                        case "SIZE":
                           fs = parseInt(String(attr));
                           continue;
                        case "COLOR":
                           fontColor = RGBColor.hexStringToRGBColor(String(attr));
                           continue;
                        case "LETTERSPACING":
                           cs = parseInt(String(attr));
                           continue;
                        case "KERNING":
                           continue;
                        default:
                           continue;
                     }
                  }
                  break;
               case "</FONT>":
                  fontColor = this.textColor as RGBColor;
                  break;
               case "<B>":
                  fontBold = true;
                  break;
               case "</B>":
                  fontBold = false;
                  break;
               case "<I>":
                  fontItalic = true;
                  break;
               case "</I>":
                  fontItalic = false;
                  break;
               case "<U>":
                  this.fontUnderline = true;
                  break;
               case "</U>":
                  this.fontUnderline = false;
                  break;
               case "<BR>":
                  this.lineBreak(pHeight);
               case "</BR>":
               default:
                  cellVO = new CellVO();
                  cellVO.link = pLink;
                  cellVO.fontSizePt = this.fontSizePt;
                  cellVO.color = fontColor;
                  cellVO.underlined = this.fontUnderline;
                  if(this.currentFont is EmbeddedFont)
                  {
                     break loop0;
                  }
                  newFont = new CoreFont(this.getFontStyleString(fontBold,fontItalic,this.fontFamily));
                  this.setFont(newFont,cellVO.fontSizePt);
                  cellVO.font = newFont;
                  cw = this.currentFont.charactersWidth;
                  w = this.currentPage.w - this.rightMargin - this.currentX;
                  wmax = (w - 2 * this.currentMargin) * this.I1000 / this.fontSize;
                  s = aTaggedString[k].value;
                  nb = s.length;
                  i = 0;
                  j = 0;
                  sep = -1;
                  l = 0;
                  while(i < nb)
                  {
                     c = s.charAt(i);
                     if(c == " ")
                     {
                        sep = i;
                        lenAtSep = l;
                        ns++;
                     }
                     cwAux = cw[c] as int;
                     if(cwAux == 0)
                     {
                        cwAux = FontMetrics.DEFAULT_WIDTH;
                     }
                     l = l + cwAux;
                     if(l > wmax)
                     {
                        if(sep == -1)
                        {
                           if(this.currentX > this.leftMargin)
                           {
                              this.currentX = this.leftMargin;
                              this.currentY = this.currentY + pHeight;
                              w = this.currentPage.w - this.rightMargin - this.currentX;
                              wmax = (w - 2 * this.currentMargin) * this.I1000 / this.fontSize;
                              i++;
                              continue;
                           }
                           if(i == j)
                           {
                              i++;
                           }
                           l = l - cwAux;
                           cellVO.x = this.currentX;
                           cellVO.y = this.currentY;
                           cellVO.width = l * 0.001 * this.fontSize;
                           cellVO.height = pHeight;
                           cellVO.text = s.substr(j,i - j);
                           currentLine.push(cellVO);
                           this.renderLine(currentLine,textAlign);
                           currentLine = new Array();
                           this.currentX = this.leftMargin;
                        }
                        else
                        {
                           cellVO.x = this.currentX;
                           cellVO.y = this.currentY;
                           cellVO.width = lenAtSep * 0.001 * this.fontSize;
                           cellVO.height = pHeight;
                           cellVO.text = s.substr(j,sep - j);
                           currentLine.push(cellVO);
                           if(textAlign == Align.JUSTIFIED)
                           {
                              this.ws = ns > 1?Number((wmax - lenAtSep) / this.I1000 * this.fontSize / (ns - 1)):Number(0);
                              this.write(sprintf("%.3f Tw",this.ws * k));
                           }
                           this.renderLine(currentLine,textAlign);
                           currentLine = new Array();
                           this.currentX = this.leftMargin;
                           w = this.currentPage.w - 2 * this.currentMargin;
                           i = sep + 1;
                        }
                        sep = -1;
                        j = i;
                        l = 0;
                        ns = 0;
                        this.currentX = this.leftMargin;
                        w = this.currentPage.w - this.rightMargin - this.currentX;
                        wmax = (w - 2 * this.currentMargin) * this.I1000 / this.fontSize;
                     }
                     else
                     {
                        i++;
                     }
                  }
                  if(i != j)
                  {
                     cellVO.x = this.currentX;
                     cellVO.y = this.currentY;
                     cellVO.width = l * 0.001 * this.fontSize;
                     cellVO.height = pHeight;
                     cellVO.text = s.substr(j);
                     if(this.ws > 0)
                     {
                        this.ws = 0;
                        this.write("0 Tw");
                     }
                     currentLine.push(cellVO);
                     this.currentX = this.currentX + cellVO.width;
                  }
                  break;
            }
            if(Boolean(k == aTaggedString.length) && Boolean(currentLine.length > 0))
            {
               this.renderLine(currentLine,textAlign);
               this.lineBreak(pHeight);
               currentLine = new Array();
            }
            k++;
         }
         throw new Error("Sorry, writeFlashHtmlText does not work for now with embedded fonts.");
      }
      
      protected function lineBreak(pHeight:Number) : void
      {
         this.currentX = this.leftMargin;
         this.currentY = this.currentY + pHeight;
      }
      
      protected function getFontStyleString(bold:Boolean, italic:Boolean, family:String) : String
      {
         var position:int = 0;
         var font:String = family;
         if((position = font.indexOf("-")) != -1)
         {
            font = font.substr(0,position);
         }
         if(Boolean(bold) && Boolean(italic))
         {
            font = font + "-BoldOblique";
         }
         else if(bold)
         {
            font = font + "-Bold";
         }
         else if(italic)
         {
            font = font + "-Oblique";
         }
         return font;
      }
      
      protected function renderLine(lineArray:Array, align:String = "") : void
      {
         var cellVO:CellVO = null;
         var i:int = 0;
         var availWidth:Number = this.currentPage.w - this.leftMargin - this.rightMargin;
         var lineLength:Number = 0;
         var offsetX:Number = 0;
         var offsetY:Number = 0;
         var firstCell:CellVO = CellVO(lineArray[0]);
         if(firstCell == null)
         {
            return;
         }
         if(firstCell.y + firstCell.height > this.pageBreakTrigger)
         {
            this.addPage();
            offsetY = this.currentY - firstCell.y;
         }
         var lng:int = lineArray.length;
         for(i = 0; i < lng; i++)
         {
            lineLength = lineLength + (lineArray[i] as CellVO).width;
         }
         if(align == Align.CENTER)
         {
            offsetX = (availWidth - lineLength) * 0.5;
         }
         else if(align == Align.RIGHT)
         {
            offsetX = availWidth - lineLength;
         }
         for(i = 0; i < lng; i++)
         {
            cellVO = CellVO(lineArray[int(i)]);
            this.currentX = cellVO.x + offsetX;
            this.currentY = cellVO.y + offsetY;
            this.setFont(cellVO.font,cellVO.fontSizePt,cellVO.underlined);
            if(cellVO.color != null)
            {
               this.setTextColor(cellVO.color);
            }
            this.colorFlag = this.fillColor != this.addTextColor;
            this.addCell(cellVO.width,cellVO.height,cellVO.text,cellVO.border,2,null,cellVO.fill,cellVO.link);
         }
      }
      
      protected function parseTags(myXML:XML) : Array
      {
         var returnedTags:Array = null;
         var subLng:int = 0;
         var j:int = 0;
         var aTags:Array = new Array();
         var children:XMLList = myXML.children();
         var lng:int = children.length();
         for(var i:int = 0; i < lng; i++)
         {
            if(children[i].name() != null)
            {
               aTags.push(new HTMLTag("<" + children[i].name() + ">",children[i].attributes(),""));
               returnedTags = this.parseTags(children[i]);
               subLng = returnedTags.length;
               for(j = 0; j < subLng; j++)
               {
                  aTags.push(returnedTags[j]);
               }
               aTags.push(new HTMLTag("</" + children[i].name() + ">",children[i].attributes(),""));
            }
            else
            {
               aTags.push(new HTMLTag("none",new XMLList(),children[i]));
            }
         }
         return aTags;
      }
      
      protected function importTemplate(template:XML) : void
      {
      }
      
      protected function getTemplate(template:XML) : XML
      {
         return null;
      }
      
      public function addGrid(grid:Grid, x:Number = 0, y:Number = 0, repeatHeader:Boolean = true) : void
      {
         var row:Array = null;
         var item:* = undefined;
         var firstItem:* = undefined;
         var fields:Array = null;
         var column:GridColumn = null;
         var p:* = null;
         var fieldsLng:int = 0;
         if(this.textColor == null)
         {
            throw new Error("Please call the setFont and textStyle method before adding a Grid.");
         }
         this.currentGrid = grid;
         this.currentGrid.x = x;
         this.currentGrid.y = y;
         this.columns = this.currentGrid.columns;
         var buffer:Array = grid.dataProvider;
         var i:int = 0;
         var j:int = 0;
         if(this.columns == null)
         {
            firstItem = buffer[0];
            fields = new Array();
            for(p in firstItem)
            {
               fields.push(p);
            }
            fields.sort();
            this.columns = new Array();
            fieldsLng = fields.length;
            for(i = 0; i < fieldsLng; i++)
            {
               this.columns.push(new GridColumn(fields[i],fields[i],this.currentGrid.width));
            }
         }
         this.columnNames = new Array();
         var lng:int = buffer.length;
         var lngColumns:int = this.columns.length;
         for(i = 0; i < lngColumns; i++)
         {
            this.columnNames.push(this.columns[i].headerText);
         }
         var rect:Rectangle = this.getRect(this.columnNames);
         if(this.checkPageBreak(rect.height))
         {
            this.addPage();
         }
         this.beginFill(grid.headerColor);
         this.setXY(x + this.getX(),y + this.getY());
         this.addRow(this.columnNames,false,rect);
         this.endFill();
         for(i = 0; i < lng; i++)
         {
            item = buffer[i];
            row = new Array();
            for(j = 0; j < lngColumns; j++)
            {
               row.push(item[this.columns[j].dataField] != null?item[this.columns[j].dataField]:"");
               this.nb = Math.max(this.nb,this.nbLines(this.columns[j].width,row[j]));
            }
            rect = this.getRect(row);
            this.setX(x + this.getX());
            if(this.checkPageBreak(rect.height))
            {
               this.addPage();
               this.setXY(x + this.getX(),y + this.getY());
               if(repeatHeader)
               {
                  this.beginFill(grid.headerColor);
                  this.addRow(this.columnNames,false,this.getRect(this.columnNames));
                  this.endFill();
                  this.setX(x + this.getX());
               }
            }
            if(Boolean(grid.alternateRowColor) && Boolean(Boolean(this.isEven = i & 1)))
            {
               this.beginFill(grid.cellColor);
               this.addRow(row,true,rect);
               this.endFill();
            }
            else
            {
               this.addRow(row,true,rect);
            }
         }
      }
      
      protected function getRect(rows:Array) : Rectangle
      {
         var nbL:int = 0;
         var a:String = null;
         var nb:int = 0;
         var lng:int = rows.length;
         for(var i:int = 0; i < lng; i++)
         {
            if((nbL = this.nbLines(this.columns[i].width,rows[i])) > nb)
            {
               nb = nbL;
            }
         }
         var ph:int = 5;
         var h:Number = ph * nb;
         var x:Number = 0;
         var y:Number = 0;
         var w:Number = 0;
         return new Rectangle(x,y,w,h);
      }
      
      protected function addRow(data:Array, style:Boolean, rect:Rectangle) : void
      {
         var a:String = null;
         var x:Number = 0;
         var y:Number = 0;
         var w:Number = 0;
         var ph:int = 5;
         var h:Number = rect.height;
         var lng:int = data.length;
         for(var i:int = 0; i < lng; i++)
         {
            a = !!style?this.columns[i].cellAlign:this.columns[i].headerAlign;
            rect.x = x = this.getX();
            rect.y = y = this.getY();
            rect.width = w = this.columns[i].width;
            this.lineStyle(this.currentGrid.borderColor,0,0,this.currentGrid.borderAlpha);
            this.drawRect(rect);
            this.setAlpha(1);
            this.addMultiCell(w,ph,data[i],0,a);
            this.setXY(x + w,y);
         }
         this.newLine(h);
      }
      
      protected function checkPageBreak(height:Number) : Boolean
      {
         return this.getY() + height > this.pageBreakTrigger;
      }
      
      protected function nbLines(width:int, text:String) : int
      {
         var c:String = null;
         var cwAux:int = 0;
         var cw:Object = this.currentFont.charactersWidth;
         if(width == 0)
         {
            width = this.currentPage.w - this.rightMargin - this.leftMargin;
         }
         var wmax:int = (width - 2 * this.currentMargin) * this.I1000 / this.fontSize;
         var s:String = this.findAndReplace("\r","",text);
         var nb:int = s.length;
         if(Boolean(nb > 0) && Boolean(s.charAt(nb - 1) == "\n"))
         {
            nb--;
         }
         var sep:Number = -1;
         var i:int = 0;
         var j:int = 0;
         var l:int = 0;
         var nl:int = 1;
         while(i < nb)
         {
            c = s.charAt(i);
            if(c == "\n")
            {
               i++;
               sep = -1;
               j = i;
               l = 0;
               nl++;
            }
            else
            {
               if(c == " ")
               {
                  sep = i;
               }
               cwAux = cw[c] as int;
               if(cwAux == 0)
               {
                  cwAux = FontMetrics.DEFAULT_WIDTH;
               }
               l = l + cwAux;
               if(l > wmax)
               {
                  if(sep == -1)
                  {
                     if(i == j)
                     {
                        i++;
                     }
                  }
                  else
                  {
                     i = sep + 1;
                  }
                  sep = -1;
                  j = i;
                  l = 0;
                  nl++;
               }
               else
               {
                  i++;
               }
            }
         }
         return nl;
      }
      
      public function save(method:String, url:String = "", downloadMethod:String = "inline", fileName:String = "generated.pdf", frame:String = "_blank") : *
      {
         var header:URLRequestHeader = null;
         var myRequest:URLRequest = null;
         this.dispatcher.dispatchEvent(new ProcessingEvent(ProcessingEvent.STARTED));
         var started:Number = getTimer();
         this.finish();
         this.dispatcher.dispatchEvent(new ProcessingEvent(ProcessingEvent.COMPLETE,getTimer() - started));
         this.buffer.position = 0;
         var output:* = null;
         switch(method)
         {
            case Method.LOCAL:
               output = this.buffer;
               break;
            case Method.BASE_64:
               output = Base64.encode64(this.buffer);
               break;
            case Method.REMOTE:
               header = new URLRequestHeader("Content-type","application/octet-stream");
               myRequest = new URLRequest(url + "?name=" + fileName + "&method=" + downloadMethod);
               myRequest.requestHeaders.push(header);
               myRequest.method = URLRequestMethod.POST;
               myRequest.data = this.buffer;
               navigateToURL(myRequest,frame);
               break;
            default:
               throw new Error("Unknown Method \"" + method + "\"");
         }
         return output;
      }
      
      private function addSWF(swf:ByteArray) : void
      {
      }
      
      public function addJavaScript(script:String) : void
      {
         this.js = script;
      }
      
      public function addImage(displayObject:DisplayObject, resizeMode:Resize = null, x:Number = 0, y:Number = 0, width:Number = 0, height:Number = 0, rotation:Number = 0, alpha:Number = 1, keepTransformation:Boolean = true, imageFormat:String = "PNG", quality:Number = 100, blendMode:String = "Normal", link:ILink = null) : void
      {
         var bytes:ByteArray = null;
         var bitmapDataBuffer:BitmapData = null;
         var transformMatrix:Matrix = null;
         var id:int = 0;
         var encoder:JPEGEncoder = null;
         if(this.streamDictionary[displayObject] == null)
         {
            this.displayObjectbounds = displayObject.getBounds(displayObject);
            if(keepTransformation)
            {
               bitmapDataBuffer = new BitmapData(displayObject.width,displayObject.height,false);
               transformMatrix = displayObject.transform.matrix;
               transformMatrix.tx = transformMatrix.ty = 0;
               transformMatrix.translate(-(this.displayObjectbounds.x * displayObject.scaleX),-(this.displayObjectbounds.y * displayObject.scaleY));
            }
            else
            {
               bitmapDataBuffer = new BitmapData(displayObject.width,displayObject.height,false);
               transformMatrix = new Matrix();
               transformMatrix.translate(-this.displayObjectbounds.x,-this.displayObjectbounds.y);
            }
            bitmapDataBuffer.draw(displayObject,transformMatrix);
            id = this.getTotalProperties(this.streamDictionary) + 1;
            if(imageFormat == ImageFormat.JPG)
            {
               encoder = new JPEGEncoder(quality);
               bytes = encoder.encode(bitmapDataBuffer);
               this.image = new DoJPEGImage(bitmapDataBuffer,bytes,id);
            }
            else if(imageFormat == ImageFormat.PNG)
            {
               bytes = PNGEncoder.encode(bitmapDataBuffer);
               this.image = new DoPNGImage(bitmapDataBuffer,bytes,id);
            }
            else
            {
               bytes = TIFFEncoder.encode(bitmapDataBuffer);
               this.image = new DoTIFFImage(bitmapDataBuffer,bytes,id);
            }
            this.streamDictionary[displayObject] = this.image;
         }
         else
         {
            this.image = this.streamDictionary[displayObject];
         }
         this.setAlpha(alpha,blendMode);
         this.placeImage(x,y,width,height,rotation,resizeMode,link);
      }
      
      private function addTransparentImage(displayObject:DisplayObject) : void
      {
      }
      
      public function addEPSImage(stream:ByteArray, x:Number = 0, y:Number = 0, w:Number = 0, h:Number = 0, useBoundingBox:Boolean = true) : void
      {
         var x1:Number = NaN;
         var y1:Number = NaN;
         var x2:Number = NaN;
         var y2:Number = NaN;
         var buffer:Array = null;
         var version:String = null;
         var buffVersion:Array = null;
         var numVersion:int = 0;
         var end:int = 0;
         var k:Number = NaN;
         var dx:Number = NaN;
         var dy:Number = NaN;
         var scaleX:Number = NaN;
         var scaleY:Number = NaN;
         var lines:Array = null;
         var u:Number = NaN;
         var cnt:int = 0;
         var line:String = null;
         var length:int = 0;
         var chunks:Array = null;
         var c:String = null;
         var m:String = null;
         var ty:String = null;
         var tk:String = null;
         var cmd:String = null;
         var r:String = null;
         var g:String = null;
         var b:String = null;
         var i:int = 0;
         var isU:Boolean = false;
         var max:Number = NaN;
         var j:int = 0;
         stream.position = 0;
         var source:String = stream.readUTFBytes(stream.bytesAvailable);
         var regs:Array = source.match(/%%Creator:([^\r\n]+)/);
         if(regs.length > 1)
         {
            version = regs[1];
            if(version.indexOf("Adobe Illustrator") != -1)
            {
               buffVersion = version.split(" ");
               numVersion = buffVersion.pop();
               if(numVersion > 8)
               {
                  throw new Error("Wrong version, only 1.x, 3.x or 8.x AI files are supported for now.");
               }
            }
            else
            {
               throw new Error("This EPS file was not created with Adobe® Illustrator®");
            }
         }
         var start:int = source.indexOf("%!PS-Adobe");
         if(start != -1)
         {
            source = source.substr(start);
         }
         regs = source.match(/%%BoundingBox:([^\r\n]+)/);
         if(regs.length > 1)
         {
            buffer = regs[1].substr(1).split(" ");
            x1 = buffer[0];
            y1 = buffer[1];
            x2 = buffer[2];
            y2 = buffer[3];
            start = source.indexOf("%%EndSetup");
            if(start == -1)
            {
               start = source.indexOf("%%EndProlog");
            }
            if(start == -1)
            {
               start = source.indexOf("%%BoundingBox");
            }
            source = source.substr(start);
            end = source.indexOf("%%PageTrailer");
            if(end == -1)
            {
               end = source.indexOf("showpage");
            }
            if(end)
            {
               source = source.substr(0,end);
            }
            this.write("q");
            k = this.k;
            if(useBoundingBox)
            {
               dx = x * k - x1;
               dy = y * k - y1;
            }
            else
            {
               dx = x * k;
               dy = y * k;
            }
            this.write(sprintf("%.3F %.3F %.3F %.3F %.3F %.3F cm",1,0,0,1,dx,dy + (this.currentPage.hPt - 2 * y * k - (y2 - y1))));
            if(w > 0)
            {
               scaleX = w / ((x2 - x1) / k);
               if(h > 0)
               {
                  scaleY = h / ((y2 - y1) / k);
               }
               else
               {
                  scaleY = scaleX;
                  h = (y2 - y1) / k * scaleY;
               }
            }
            else if(h > 0)
            {
               scaleY = h / ((y2 - y1) / k);
               scaleX = scaleY;
               w = (x2 - x1) / k * scaleX;
            }
            else
            {
               w = (x2 - x1) / k;
               h = (y2 - y1) / k;
            }
            if(!isNaN(scaleX))
            {
               this.write(sprintf("%.3F %.3F %.3F %.3F %.3F %.3F cm",scaleX,0,0,scaleY,x1 * (1 - scaleX),y2 * (1 - scaleY)));
            }
            lines = source.split(/\r\n|[\r\n]/);
            u = 0;
            cnt = lines.length;
            for(i = 0; i < cnt; i++)
            {
               line = lines[i];
               if(!(Boolean(line == "") || Boolean(line.charAt(0) == "%")))
               {
                  length = line.length;
                  chunks = line.split(" ");
                  cmd = chunks.pop();
                  if(Boolean(cmd == "Xa") || Boolean(cmd == "XA"))
                  {
                     r = chunks.pop();
                     g = chunks.pop();
                     b = chunks.pop();
                     this.write(r + " " + g + " " + b + " " + (cmd == "Xa"?"rg":"RG"));
                  }
                  else
                  {
                     switch(cmd)
                     {
                        case "m":
                        case "l":
                        case "y":
                        case "c":
                        case "k":
                        case "K":
                        case "g":
                        case "G":
                        case "s":
                        case "S":
                        case "J":
                        case "j":
                        case "w":
                        case "M":
                        case "d":
                        case "n":
                        case "v":
                           this.write(line);
                           break;
                        case "x":
                           c = chunks[0];
                           m = chunks[1];
                           ty = chunks[2];
                           tk = chunks[3];
                           this.write(c + " " + m + " " + ty + " " + tk + " k");
                           break;
                        case "X":
                           c = chunks[0];
                           m = chunks[1];
                           ty = chunks[2];
                           tk = chunks[3];
                           this.write(c + " " + m + " " + ty + " " + tk + " K");
                           break;
                        case "Y":
                        case "N":
                        case "V":
                        case "L":
                        case "C":
                           this.write(line.toLowerCase());
                           break;
                        case "b":
                        case "B":
                           this.write(cmd + "*");
                           break;
                        case "f":
                        case "F":
                           if(u > 0)
                           {
                              isU = false;
                              max = i + 5 < cnt?Number(i + 5):Number(cnt);
                              for(j = i + 1; j < max; )
                              {
                                 isU = Boolean(isU) || (Boolean(lines[j] == "U") || Boolean(lines[j] == "*U"));
                                 j++;
                              }
                              if(isU)
                              {
                                 this.write("f*");
                              }
                           }
                           else
                           {
                              this.write("f*");
                           }
                           break;
                        case "*u":
                           u++;
                           break;
                        case "*U":
                           u--;
                     }
                  }
               }
            }
            this.write("Q");
            return;
         }
         throw new Error("No bounding box found in the current EPS file");
      }
      
      public function addImageStream(imageBytes:ByteArray, colorSpace:String, resizeMode:Resize = null, x:Number = 0, y:Number = 0, width:Number = 0, height:Number = 0, rotation:Number = 0, alpha:Number = 1, blendMode:String = "Normal", link:ILink = null) : void
      {
         var id:int = 0;
         var decoder:GIFPlayer = null;
         var capture:BitmapData = null;
         var bytes:ByteArray = null;
         if(this.streamDictionary[imageBytes] == null)
         {
            imageBytes.position = 0;
            id = this.getTotalProperties(this.streamDictionary) + 1;
            if(imageBytes.readUnsignedShort() == JPEGImage.HEADER)
            {
               this.image = new JPEGImage(imageBytes,colorSpace,id);
            }
            else if(Boolean(!(imageBytes.position = 0)) && Boolean(imageBytes.readUnsignedShort() == PNGImage.HEADER))
            {
               this.image = new PNGImage(imageBytes,colorSpace,id);
            }
            else if(Boolean(!(imageBytes.position = 0)) && Boolean(imageBytes.readUTFBytes(3) == GIFImage.HEADER))
            {
               imageBytes.position = 0;
               decoder = new GIFPlayer(false);
               capture = decoder.loadBytes(imageBytes);
               bytes = PNGEncoder.encode(capture);
               this.image = new DoPNGImage(capture,bytes,id);
            }
            else if(Boolean(!(imageBytes.position = 0)) && (Boolean(imageBytes.endian = Endian.LITTLE_ENDIAN)) && Boolean(imageBytes.readByte() == 73))
            {
               this.image = new TIFFImage(imageBytes,colorSpace,id);
            }
            else
            {
               throw new Error("Image format not supported for now.");
            }
            this.streamDictionary[imageBytes] = this.image;
         }
         else
         {
            this.image = this.streamDictionary[imageBytes];
         }
         this.setAlpha(alpha,blendMode);
         this.placeImage(x,y,width,height,rotation,resizeMode,link);
      }
      
      protected function placeImage(x:Number, y:Number, width:Number, height:Number, rotation:Number, resizeMode:Resize, link:ILink) : void
      {
         var ratio:Number = NaN;
         if(Boolean(width == 0) && Boolean(height == 0))
         {
            width = this.image.width / this.k;
            height = this.image.height / this.k;
         }
         if(width == 0)
         {
            width = height * this.image.width / this.image.height;
         }
         if(height == 0)
         {
            height = width * this.image.height / this.image.width;
         }
         var realWidth:Number = this.currentPage.width - (this.leftMargin + this.rightMargin) * this.k;
         var realHeight:Number = this.currentPage.height - (this.bottomMargin + this.topMargin) * this.k;
         var xPos:Number = 0;
         var yPos:Number = 0;
         if(resizeMode == null)
         {
            resizeMode = new Resize(Mode.NONE,Position.LEFT);
         }
         if(resizeMode.mode == Mode.RESIZE_PAGE)
         {
            this.currentPage.resize(this.image.width + (this.leftMargin + this.rightMargin) * this.k,this.image.height + (this.bottomMargin + this.topMargin) * this.k,this.k);
         }
         else if(resizeMode.mode == Mode.FIT_TO_PAGE)
         {
            ratio = Math.min(realWidth / this.image.width,realHeight / this.image.height);
            if(ratio < 1)
            {
               width = width * ratio;
               height = height * ratio;
            }
         }
         if(resizeMode.mode != Mode.RESIZE_PAGE)
         {
            if(resizeMode.position == Position.CENTERED)
            {
               x = (realWidth - width * this.k) * 0.5;
               y = (realHeight - height * this.k) * 0.5;
            }
            else if(resizeMode.position == Position.RIGHT)
            {
               x = realWidth - width * this.k;
            }
         }
         xPos = Boolean(resizeMode.position == Position.LEFT) && Boolean(resizeMode.mode == Mode.NONE)?Number((x + this.leftMargin) * this.k):Number(x + this.leftMargin * this.k);
         yPos = Boolean(resizeMode.position == Position.CENTERED) && Boolean(resizeMode.mode != Mode.RESIZE_PAGE)?Number(y + (this.bottomMargin + this.topMargin) * this.k):Number((this.currentPage.h - this.topMargin - (y + height)) * this.k);
         this.rotate(rotation);
         this.write(sprintf("q %.2f 0 0 %.2f %.2f %.2f cm",width * this.k,height * this.k,xPos,yPos));
         this.write(sprintf("/I%d Do Q",this.image.resourceId));
         if(link != null)
         {
            this.addLink(xPos,yPos,width * this.k,height * this.k,link);
         }
      }
      
      public function toString() : String
      {
         return "[PDF totalPages=" + this.totalPages + " nbImages=" + this.getTotalProperties(this.streamDictionary) + " totalFonts=" + this.totalFonts + " PDFVersion=" + this.version + " AlivePDFVersion=" + PDF.ALIVEPDF_VERSION + "]";
      }
      
      protected function init(orientation:String = "Portrait", unit:String = "Mm", pageSize:Size = null, rotation:int = 0) : void
      {
         this.size = pageSize != null?Size.getSize(pageSize).clone():Size.A4.clone();
         if(this.size == null)
         {
            throw new RangeError("Unknown page format : " + pageSize + ", please use a org.alivepdf.layout." + "Size object or any of those strings : Size.A3, Size.A4, Size.A5, Size.Letter, Size.Legal, Size.Tabloid");
         }
         this.dispatcher = new EventDispatcher(this);
         this.viewerPreferences = new String();
         this.outlines = new Array();
         this.arrayPages = new Array();
         this.arrayNotes = new Array();
         this.graphicStates = new Array();
         this.orientationChanges = new Array();
         this.nbPages = this.arrayPages.length;
         this.buffer = new ByteArray();
         this.offsets = new Array();
         this.fonts = new Array();
         this.differences = new Array();
         this.streamDictionary = new Dictionary();
         this.inHeader = this.inFooter = false;
         this.fontFamily = new String();
         this.fontStyle = new String();
         this.underline = false;
         this.colorFlag = false;
         this.matrix = new Matrix();
         this.pagesReferences = new Array();
         this.compressedPages = new ByteArray();
         this.coreFontMetrics = new FontMetrics();
         this.defaultUnit = this.setUnit(unit);
         this.defaultSize = this.size;
         this.defaultOrientation = orientation;
         this.defaultRotation = rotation;
         this.n = 2;
         this.state = PDF.STATE_0;
         this.lasth = 0;
         this.fontSizePt = 12;
         this.ws = 0;
         this.margin = 28.35 / this.k;
         this.setMargins(this.margin,this.margin);
         this.currentMargin = this.margin / 10;
         this.strokeThickness = 0.567 / this.k;
         this.setAutoPageBreak(true,this.margin * 2);
         this.setDisplayMode(Display.FULL_WIDTH);
         this.isLinux = Capabilities.version.indexOf("LNX") != -1;
         this.version = PDF.PDF_VERSION;
      }
      
      protected function transform(tm:Matrix) : void
      {
         this.write(sprintf("%.3f %.3f %.3f %.3f %.3f %.3f cm",tm.a,tm.b,tm.c,tm.d,tm.tx,tm.ty));
      }
      
      protected function getMatrixTransformPoint(px:Number, py:Number) : void
      {
         var position:Point = new Point(px,py);
         var deltaPoint:Point = this.matrix.deltaTransformPoint(position);
         this.matrix.tx = px - deltaPoint.x;
         this.matrix.ty = py - deltaPoint.y;
      }
      
      protected function startTransform() : void
      {
         this.write("q");
      }
      
      protected function stopTransform() : void
      {
         this.write("Q");
      }
      
      protected function finish() : void
      {
         this.close();
      }
      
      protected function setUnit(unit:String) : String
      {
         if(unit == Unit.POINT)
         {
            this.k = 1;
         }
         else if(unit == Unit.MM)
         {
            this.k = 72 / 25.4;
         }
         else if(unit == Unit.CM)
         {
            this.k = 72 / 2.54;
         }
         else if(unit == Unit.INCHES)
         {
            this.k = 72;
         }
         else
         {
            throw new RangeError("Incorrect unit: " + unit);
         }
         return unit;
      }
      
      protected function acceptPageBreak() : Boolean
      {
         return this.autoPageBreak;
      }
      
      protected function curve(x1:Number, y1:Number, x2:Number, y2:Number, x3:Number, y3:Number) : void
      {
         var h:Number = this.currentPage.h;
         this.write(sprintf("%.2f %.2f %.2f %.2f %.2f %.2f c ",x1 * this.k,(h - y1) * this.k,x2 * this.k,(h - y2) * this.k,x3 * this.k,(h - y3) * this.k));
      }
      
      protected function getStringWidth(content:String) : Number
      {
         this.charactersWidth = this.currentFont.charactersWidth;
         var w:Number = 0;
         var l:int = content.length;
         var cwAux:int = 0;
         while(l--)
         {
            cwAux = cwAux + (this.charactersWidth[content.charAt(l)] as int);
            if(cwAux == 0)
            {
               cwAux = FontMetrics.DEFAULT_WIDTH;
            }
         }
         w = cwAux;
         return w * this.fontSize * 0.001;
      }
      
      protected function open() : void
      {
         this.state = PDF.STATE_1;
      }
      
      protected function close() : void
      {
         if(this.arrayPages.length == 0)
         {
            this.addPage();
         }
         this.inFooter = true;
         this.footer();
         this.inFooter = false;
         this.finishPage();
         this.finishDocument();
      }
      
      protected function addExtGState(graphicState:Object) : int
      {
         this.graphicStates.push(graphicState);
         return this.graphicStates.length - 1;
      }
      
      protected function setExtGState(graphicState:int) : void
      {
         this.write(sprintf("/GS%d gs",graphicState));
      }
      
      protected function insertExtGState() : void
      {
         var k:* = null;
         var lng:int = this.graphicStates.length;
         for(var i:int = 0; i < lng; i++)
         {
            this.newObj();
            this.graphicStates[i].n = this.n;
            this.write("<</Type /ExtGState");
            for(k in this.graphicStates[i])
            {
               this.write("/" + k + " " + this.graphicStates[i][k]);
            }
            this.write(">>");
            this.write("endobj");
         }
      }
      
      protected function getChannels(color:Number) : String
      {
         var r:Number = (color & 16711680) >> 16;
         var g:Number = (color & 65280) >> 8;
         var b:Number = color & 255;
         return r / 255 + " " + g / 255 + " " + b / 255;
      }
      
      protected function getCurrentDate() : String
      {
         var myDate:Date = new Date();
         var year:Number = myDate.getFullYear();
         var month:* = myDate.getMonth() < 10?"0" + Number(myDate.getMonth() + 1):myDate.getMonth() + 1;
         var day:Number = myDate.getDate();
         var hours:* = myDate.getHours() < 10?"0" + Number(myDate.getHours()):myDate.getHours();
         var currentDate:String = myDate.getFullYear() + "" + month + "" + day + "" + hours + "" + myDate.getMinutes();
         return currentDate;
      }
      
      protected function findAndReplace(search:String, replace:String, source:String) : String
      {
         return source.split(search).join(replace);
      }
      
      protected function createPageTree() : void
      {
         var p:String = null;
         var page:Page = null;
         this.compressedPages = new ByteArray();
         this.nb = this.arrayPages.length;
         if(this.aliasNbPages != null)
         {
            for(this.n = 0; this.n < this.nb; this.n++)
            {
               this.arrayPages[this.n].content = this.findAndReplace(this.aliasNbPages,this.nb.toString(),this.arrayPages[this.n].content);
            }
         }
         this.filter = new String();
         this.offsets[1] = this.buffer.length;
         this.write("1 0 obj");
         this.write("<</Type /Pages");
         this.write("/Kids [" + this.pagesReferences.join(" ") + "]");
         this.write("/Count " + this.nb + ">>");
         this.write("endobj");
         for each(page in this.arrayPages)
         {
            this.newObj();
            this.write("<</Type /Page");
            this.write("/Parent 1 0 R");
            this.write(sprintf("/MediaBox [0 0 %.2f %.2f]",page.width,page.height));
            this.write("/Resources 2 0 R");
            if(page.annotations != "")
            {
               this.write("/Annots [" + page.annotations + "]");
            }
            this.write("/Rotate " + page.rotation);
            if(page.advanceTiming != 0)
            {
               this.write("/Dur " + page.advanceTiming);
            }
            if(page.transitions.length > 0)
            {
               this.write(page.transitions);
            }
            this.write("/Contents " + (this.n + 1) + " 0 R>>");
            this.write("endobj");
            this.newObj();
            this.write("<<" + this.filter + "/Length " + page.content.length + ">>");
            this.writeStream(page.content.substr(0,page.content.length - 1));
            this.write("endobj");
         }
      }
      
      protected function writeXObjectDictionary() : void
      {
         var image:PDFImage = null;
         for each(image in this.streamDictionary)
         {
            this.write("/I" + image.resourceId + " " + image.n + " 0 R");
         }
      }
      
      protected function writeResourcesDictionary() : void
      {
         var font:IFont = null;
         var k:* = null;
         var color:SpotColor = null;
         this.write("/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]");
         this.write("/Font <<");
         for each(font in this.fonts)
         {
            this.write("/F" + font.id + " " + font.resourceId + " 0 R");
         }
         this.write(">>");
         this.write("/XObject <<");
         this.writeXObjectDictionary();
         this.write(">>");
         this.write("/ExtGState <<");
         for(k in this.graphicStates)
         {
            this.write("/GS" + k + " " + this.graphicStates[k].n + " 0 R");
         }
         this.write(">>");
         this.write("/ColorSpace <<");
         for each(color in this.spotColors)
         {
            this.write("/CS" + color.i + " " + color.n + " 0 R");
         }
         this.write(">>");
         this.write("/Properties <</OC1 " + this.nOCGPrint + " 0 R /OC2 " + this.nOCGView + " 0 R>>");
      }
      
      protected function insertImages() : void
      {
         var stream:ByteArray = null;
         var image:PDFImage = null;
         var trns:String = null;
         var lng:int = 0;
         var i:int = 0;
         var pal:String = null;
         var filter:String = new String();
         for each(image in this.streamDictionary)
         {
            this.newObj();
            image.n = this.n;
            this.write("<</Type /XObject");
            this.write("/Subtype /Image");
            this.write("/Width " + image.width);
            this.write("/Height " + image.height);
            if(image.colorSpace == ColorSpace.INDEXED)
            {
               this.write("/ColorSpace [/" + ColorSpace.INDEXED + " /" + ColorSpace.DEVICE_RGB + " " + ((image as PNGImage).pal.length / 3 - 1) + " " + (this.n + 1) + " 0 R]");
            }
            else
            {
               this.write("/ColorSpace /" + image.colorSpace);
               if(image.colorSpace == ColorSpace.DEVICE_CMYK)
               {
                  this.write("/Decode [1 0 1 0 1 0 1 0]");
               }
            }
            this.write("/BitsPerComponent " + image.bitsPerComponent);
            if(image.filter != null)
            {
               this.write("/Filter /" + image.filter);
            }
            if(Boolean(image is PNGImage) || Boolean(image is GIFImage))
            {
               if(image.parameters != null)
               {
                  this.write(image.parameters);
               }
               if(Boolean(image.transparency != null) && Boolean(image.transparency is Array))
               {
                  trns = "";
                  lng = image.transparency.length;
                  for(i = 0; i < lng; i++)
                  {
                     trns = trns + (image.transparency[i] + " " + image.transparency[i] + " ");
                  }
                  this.write("/Mask [" + trns + "]");
               }
            }
            stream = image.bytes;
            this.write("/Length " + stream.length + ">>");
            this.write("stream");
            this.buffer.writeBytes(stream);
            this.buffer.writeUTFBytes("\n");
            this.write("endstream");
            this.write("endobj");
            if(image.colorSpace == ColorSpace.INDEXED)
            {
               this.newObj();
               pal = (image as PNGImage).pal;
               this.write("<<" + filter + "/Length " + pal.length + ">>");
               this.writeStream(pal);
               this.write("endobj");
            }
         }
      }
      
      protected function insertFonts() : void
      {
         var diff:String = null;
         var font:IFont = null;
         var embeddedFont:EmbeddedFont = null;
         var fontDescription:FontDescription = null;
         var type:String = null;
         var name:String = null;
         var charactersWidth:Object = null;
         var s:String = null;
         var lng:int = 0;
         var i:int = 0;
         var nf:int = this.n;
         for each(diff in this.differences)
         {
            this.newObj();
            this.write("<</Type /Encoding /BaseEncoding /WinAnsiEncoding /Differences [" + diff + "]>>");
            this.write("endobj");
         }
         for each(font in this.fonts)
         {
            if(font is EmbeddedFont)
            {
               if(font.type == FontType.TRUE_TYPE)
               {
                  embeddedFont = font as EmbeddedFont;
                  fontDescription = embeddedFont.description;
                  this.newObj();
                  this.write("<</Length " + embeddedFont.stream.length);
                  this.write("/Filter /" + Filter.FLATE_DECODE);
                  this.write("/Length1 " + embeddedFont.originalSize + ">>");
                  this.write("stream");
                  this.buffer.writeBytes(embeddedFont.stream);
                  this.buffer.writeUTFBytes("\n");
                  this.write("endstream");
                  this.write("endobj");
               }
            }
            font.resourceId = this.n + 1;
            type = font.type;
            name = font.name;
            if(!(font is EmbeddedFont))
            {
               this.newObj();
               this.write("<</Type /Font");
               this.write("/BaseFont /" + name);
               this.write("/Subtype /Type1");
               if(Boolean(name != FontFamily.SYMBOL) && Boolean(name != FontFamily.ZAPFDINGBATS))
               {
                  this.write("/Encoding /WinAnsiEncoding");
               }
               this.write(">>");
               this.write("endobj");
               continue;
            }
            if(font is EmbeddedFont)
            {
               this.newObj();
               this.write("<</Type /Font");
               this.write("/BaseFont /" + name);
               this.write("/Subtype /" + type);
               this.write("/FirstChar 32");
               this.write("/LastChar 255");
               this.write("/Widths " + (this.n + 1) + " 0 R");
               this.write("/FontDescriptor " + (this.n + 2) + " 0 R");
               if(embeddedFont.encoding != null)
               {
                  if(embeddedFont.differences != null)
                  {
                     this.write("/Encoding " + (int(nf) + int(embeddedFont.differences) + 1) + " 0 R");
                  }
                  else
                  {
                     this.write("/Encoding /WinAnsiEncoding");
                  }
               }
               this.write(">>");
               this.write("endobj");
               this.newObj();
               s = "[ ";
               for(i = 32; i <= 255; i++)
               {
                  s = s + (embeddedFont.widths[String.fromCharCode(i)] + " ");
               }
               this.write(s + "]");
               this.write("endobj");
               this.newObj();
               this.write("<</Type /FontDescriptor");
               this.write("/FontName /" + name);
               this.write("/FontWeight /" + fontDescription.fontWeight);
               this.write("/Descent " + fontDescription.descent);
               this.write("/Ascent " + fontDescription.ascent);
               this.write("/AvgWidth " + fontDescription.averageWidth);
               this.write("/Flags " + fontDescription.flags);
               this.write("/FontBBox [" + fontDescription.boundingBox[0] + " " + fontDescription.boundingBox[1] + " " + fontDescription.boundingBox[2] + " " + fontDescription.boundingBox[3] + "]");
               this.write("/ItalicAngle " + fontDescription.italicAngle);
               this.write("/StemV " + fontDescription.stemV);
               this.write("/MissingWidth " + fontDescription.missingWidth);
               this.write("/CapHeight " + fontDescription.capHeight);
               this.write("/FontFile" + (type == "Type1"?"":"2") + " " + (embeddedFont.resourceId - 1) + " 0 R");
               this.write(">>");
               this.write("endobj");
               continue;
            }
            throw new Error("Unsupported font type: " + type + "\nMake sure you used the UnicodePDF class if you used the ArialUnicodeMS font class");
         }
      }
      
      protected function insertJS() : void
      {
         this.newObj();
         this.jsResource = this.n;
         this.write("<<");
         this.write("/Names [(EmbeddedJS) " + (this.n + 1) + " 0 R]");
         this.write(">>");
         this.write("endobj");
         this.newObj();
         this.write("<<");
         this.write("/S /JavaScript");
         this.write("/JS " + this.escapeString(this.js));
         this.write(">>");
         this.write("endobj");
      }
      
      protected function writeResources() : void
      {
         this.insertOCG();
         this.insertSpotColors();
         this.insertExtGState();
         this.insertFonts();
         this.insertImages();
         if(this.js != null)
         {
            this.insertJS();
         }
         this.offsets[2] = this.buffer.length;
         this.write("2 0 obj");
         this.write("<<");
         this.writeResourcesDictionary();
         this.write(">>");
         this.write("endobj");
         this.insertBookmarks();
      }
      
      protected function insertOCG() : void
      {
         this.newObj();
         this.nOCGPrint = this.n;
         this.write("<</Type /OCG /Name " + this.escapeString("print"));
         this.write("/Usage <</Print <</PrintState /ON>> /View <</ViewState /OFF>>>>>>");
         this.write("endobj");
         this.newObj();
         this.nOCGView = this.n;
         this.write("<</Type /OCG /Name " + this.escapeString("view"));
         this.write("/Usage <</Print <</PrintState /OFF>> /View <</ViewState /ON>>>>>>");
         this.write("endobj");
      }
      
      protected function insertBookmarks() : void
      {
         var o:Outline = null;
         var i:* = null;
         var n:int = 0;
         var p:Outline = null;
         var parent:* = undefined;
         var prev:int = 0;
         var nb:int = this.outlines.length;
         if(nb == 0)
         {
            return;
         }
         var lru:Array = new Array();
         var level:Number = 0;
         for(i in this.outlines)
         {
            o = this.outlines[i];
            if(o.level > 0)
            {
               parent = lru[int(o.level - 1)];
               this.outlines[i].parent = parent;
               this.outlines[parent].last = i;
               if(o.level > level)
               {
                  this.outlines[parent].first = i;
               }
            }
            else
            {
               this.outlines[i].parent = nb;
            }
            if(Boolean(o.level <= level) && Boolean(int(i) > 0))
            {
               prev = lru[o.level];
               this.outlines[prev].next = i;
               this.outlines[i].prev = prev;
            }
            lru[o.level] = i;
            level = o.level;
         }
         n = this.n + 1;
         for each(p in this.outlines)
         {
            this.newObj();
            this.write("<</Title " + this.escapeString(p.text));
            this.write("/Parent " + (n + int(p.parent)) + " 0 R");
            if(p.prev != null)
            {
               this.write("/Prev " + (n + int(p.prev)) + " 0 R");
            }
            if(p.next != null)
            {
               this.write("/Next " + (n + int(p.next)) + " 0 R");
            }
            if(p.first != null)
            {
               this.write("/First " + (n + int(p.first)) + " 0 R");
            }
            if(p.last != null)
            {
               this.write("/Last " + (n + int(p.last)) + " 0 R");
            }
            this.write("/C [" + p.redMultiplier + " " + p.greenMultiplier + " " + p.blueMultiplier + "]");
            this.write(sprintf("/Dest [%d 0 R /XYZ 0 %.2f null]",1 + 2 * p.pages,(this.currentPage.h - p.y) * this.k));
            this.write("/Count 0>>");
            this.write("endobj");
         }
         this.newObj();
         this.outlineRoot = this.n;
         this.write("<</Type /Outlines /First " + n + " 0 R");
         this.write("/Last " + (this.n - 1) + " 0 R>>");
         this.write("endobj");
      }
      
      protected function insertInfos() : void
      {
         this.write("/Producer " + this.escapeString("AlivePDF " + PDF.ALIVEPDF_VERSION));
         if(this.documentTitle != null)
         {
            this.write("/Title " + this.escapeString(this.documentTitle));
         }
         if(this.documentSubject != null)
         {
            this.write("/Subject " + this.escapeString(this.documentSubject));
         }
         if(this.documentAuthor != null)
         {
            this.write("/Author " + this.escapeString(this.documentAuthor));
         }
         if(this.documentKeywords != null)
         {
            this.write("/Keywords " + this.escapeString(this.documentKeywords));
         }
         if(this.documentCreator != null)
         {
            this.write("/Creator " + this.escapeString(this.documentCreator));
         }
         this.write("/CreationDate " + this.escapeString("D:" + this.getCurrentDate()));
      }
      
      protected function createCatalog() : void
      {
         this.write("/Type /Catalog");
         this.write("/Pages 1 0 R");
         var startingPage:String = this.pagesReferences[this.startingPageIndex];
         if(this.zoomMode == Display.FULL_PAGE)
         {
            this.write("/OpenAction [" + startingPage + " /Fit]");
         }
         else if(this.zoomMode == Display.FULL_WIDTH)
         {
            this.write("/OpenAction [" + startingPage + " /FitH null]");
         }
         else if(this.zoomMode == Display.REAL)
         {
            this.write("/OpenAction [" + startingPage + " /XYZ null null " + this.zoomFactor + "]");
         }
         else if(!(this.zoomMode is String))
         {
            this.write("/OpenAction [" + startingPage + " /XYZ null null " + this.zoomMode * 0.01 + "]");
         }
         this.write("/PageLayout /" + this.layoutMode);
         if(this.viewerPreferences.length)
         {
            this.write("/ViewerPreferences " + this.viewerPreferences);
         }
         if(this.outlines.length)
         {
            this.write("/Outlines " + this.outlineRoot + " 0 R");
            this.write("/PageMode /UseOutlines");
         }
         else
         {
            this.write("/PageMode /" + this.pageMode);
         }
         if(this.js != null)
         {
            this.write("/Names <</JavaScript " + this.jsResource + " 0 R>>");
         }
         var p:String = this.nOCGPrint + " 0 R";
         var v:String = this.nOCGView + " 0 R";
         var ast:String = "<</Event /Print /OCGs [" + p + " " + v + "] /Category [/Print]>> <</Event /View /OCGs [" + p + " " + v + "] /Category [/View]>>";
         this.write("/OCProperties <</OCGs [" + p + " " + v + "] /D <</ON [" + p + "] /OFF [" + v + "] /AS [" + ast + "]>>>>");
      }
      
      protected function createHeader() : void
      {
         this.write("%PDF-" + this.version);
      }
      
      protected function createTrailer() : void
      {
         this.write("/Size " + (this.n + 1));
         this.write("/Root " + this.n + " 0 R");
         this.write("/Info " + (this.n - 1) + " 0 R");
      }
      
      protected function finishDocument() : void
      {
         var started:Number = NaN;
         if(this.pageMode == PageMode.USE_ATTACHMENTS)
         {
            this.version = "1.6";
         }
         else if(Boolean(this.layoutMode == Layout.TWO_PAGE_LEFT) || Boolean(this.layoutMode == Layout.TWO_PAGE_RIGHT) || Boolean(this.visibility != null))
         {
            this.version = "1.5";
         }
         else if(Boolean(this.graphicStates.length) && Boolean(this.version < "1.4"))
         {
            this.version = "1.4";
         }
         else if(this.outlines.length)
         {
            this.version = "1.4";
         }
         this.createHeader();
         started = getTimer();
         this.createPageTree();
         this.dispatcher.dispatchEvent(new ProcessingEvent(ProcessingEvent.PAGE_TREE,getTimer() - started));
         started = getTimer();
         this.writeResources();
         this.dispatcher.dispatchEvent(new ProcessingEvent(ProcessingEvent.RESOURCES,getTimer() - started));
         this.newObj();
         this.write("<<");
         this.insertInfos();
         this.write(">>");
         this.write("endobj");
         this.newObj();
         this.write("<<");
         this.createCatalog();
         this.write(">>");
         this.write("endobj");
         var o:int = this.buffer.length;
         this.write("xref");
         this.write("0 " + (this.n + 1));
         this.write("0000000000 65535 f ");
         for(var i:int = 1; i <= this.n; i++)
         {
            this.write(sprintf("%010d 00000 n ",this.offsets[i]));
         }
         this.write("trailer");
         this.write("<<");
         this.createTrailer();
         this.write(">>");
         this.write("startxref");
         this.write(o.toString());
         this.write("%%EOF");
         this.state = PDF.STATE_3;
      }
      
      protected function startPage(newOrientation:String) : void
      {
         this.nbPages = this.arrayPages.length;
         this.state = PDF.STATE_2;
         this.setXY(this.leftMargin,this.topMargin);
         if(newOrientation == "")
         {
            newOrientation = this.defaultOrientation;
         }
         else if(newOrientation != this.defaultOrientation)
         {
            this.orientationChanges[this.nbPages] = true;
         }
         this.pageBreakTrigger = this.arrayPages[this.nbPages - 1].h - this.bottomMargin;
         this.currentOrientation = newOrientation;
      }
      
      protected function finishPage() : void
      {
         this.setVisible(Visibility.ALL);
         this.state = PDF.STATE_1;
      }
      
      protected function newObj() : void
      {
         this.offsets[int(++this.n)] = this.buffer.length;
         this.write(this.n + " 0 obj");
      }
      
      protected function doUnderline(x:Number, y:Number, content:String) : String
      {
         this.underlinePosition = this.currentFont.underlinePosition;
         this.underlineThickness = this.currentFont.underlineThickness;
         var w:Number = this.getStringWidth(content) + this.ws * this.substrCount(content," ");
         return sprintf("%.2f %.2f %.2f %.2f re f",x * this.k,(this.currentPage.h - (y - this.underlinePosition * 0.001 * this.fontSize)) * this.k,w * this.k,-this.underlineThickness * 0.001 * this.fontSizePt);
      }
      
      protected function substrCount(content:String, search:String) : int
      {
         return content.split(search).length;
      }
      
      protected function getTotalProperties(object:Object) : int
      {
         var p:* = null;
         var num:int = 0;
         for(p in object)
         {
            num++;
         }
         return num;
      }
      
      protected function escapeString(content:String) : String
      {
         return "(" + this.escapeIt(content) + ")";
      }
      
      protected function escapeIt(content:String) : String
      {
         return this.findAndReplace(")","\\)",this.findAndReplace("(","\\(",this.findAndReplace("\\","\\\\",this.findAndReplace("\r","\\r",content))));
      }
      
      protected function writeStream(stream:String) : void
      {
         this.write("stream");
         this.write(stream);
         this.write("endstream");
      }
      
      protected function write(content:String) : void
      {
         var contentTxt:String = null;
         var lng:int = 0;
         var i:int = 0;
         if(this.currentPage == null)
         {
            throw new Error("No pages available, please call the addPage method first.");
         }
         if(this.state == PDF.STATE_2)
         {
            this.currentPage.content = this.currentPage.content + (content + "\n");
         }
         else if(!this.isLinux)
         {
            this.buffer.writeMultiByte(content + "\n","windows-1252");
         }
         else
         {
            contentTxt = content.toString();
            lng = contentTxt.length;
            for(i = 0; i < lng; i++)
            {
               this.buffer.writeByte(contentTxt.charCodeAt(i));
            }
            this.buffer.writeByte(10);
         }
      }
      
      public function addEventListener(type:String, listener:Function, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = false) : void
      {
         this.dispatcher.addEventListener(type,listener,useCapture,priority,useWeakReference);
      }
      
      public function dispatchEvent(event:Event) : Boolean
      {
         return this.dispatcher.dispatchEvent(event);
      }
      
      public function hasEventListener(type:String) : Boolean
      {
         return this.dispatcher.hasEventListener(type);
      }
      
      public function removeEventListener(type:String, listener:Function, useCapture:Boolean = false) : void
      {
         this.dispatcher.removeEventListener(type,listener,useCapture);
      }
      
      public function willTrigger(type:String) : Boolean
      {
         return this.dispatcher.willTrigger(type);
      }
   }
}
