package org.alivepdf.images.gif.player
{
   import flash.display.Bitmap;
   import flash.net.URLLoader;
   import org.alivepdf.images.gif.decoder.GIFDecoder;
   import flash.utils.Timer;
   import flash.events.IOErrorEvent;
   import flash.events.Event;
   import flash.display.BitmapData;
   import flash.utils.ByteArray;
   import flash.errors.ScriptTimeoutError;
   import org.alivepdf.images.gif.errors.FileTypeError;
   import org.alivepdf.images.gif.events.GIFPlayerEvent;
   import org.alivepdf.images.gif.events.TimeoutEvent;
   import org.alivepdf.images.gif.events.FileTypeEvent;
   import flash.events.TimerEvent;
   import org.alivepdf.images.gif.events.FrameEvent;
   import flash.net.URLRequest;
   import org.alivepdf.images.gif.frames.GIFFrame;
   import flash.net.URLLoaderDataFormat;
   
   public class GIFPlayer extends Bitmap
   {
       
      private var urlLoader:URLLoader;
      
      private var gifDecoder:GIFDecoder;
      
      private var aFrames:Array;
      
      private var myTimer:Timer;
      
      private var iInc:int;
      
      private var iIndex:int;
      
      private var auto:Boolean;
      
      private var arrayLng:uint;
      
      public var preWidth:Number;
      
      public var preHeight:Number;
      
      public function GIFPlayer(pAutoPlay:Boolean = true)
      {
         super();
         this.auto = pAutoPlay;
         this.iIndex = this.iInc = 0;
         this.myTimer = new Timer(0,0);
         this.aFrames = new Array();
         this.urlLoader = new URLLoader();
         this.urlLoader.dataFormat = URLLoaderDataFormat.BINARY;
         this.urlLoader.addEventListener(Event.COMPLETE,this.onComplete);
         this.urlLoader.addEventListener(IOErrorEvent.IO_ERROR,this.onIOError);
         this.myTimer.addEventListener(TimerEvent.TIMER,this.update);
         this.gifDecoder = new GIFDecoder();
      }
      
      private function onIOError(pEvt:IOErrorEvent) : void
      {
         dispatchEvent(pEvt);
      }
      
      private function onComplete(pEvt:Event) : void
      {
         this.readStream(pEvt.target.data);
      }
      
      private function readStream(pBytes:ByteArray) : BitmapData
      {
         var lng:int = 0;
         var i:int = 0;
         var gifStream:ByteArray = pBytes;
         this.aFrames = new Array();
         this.iInc = 0;
         try
         {
            this.gifDecoder.read(gifStream);
            lng = this.gifDecoder.getFrameCount();
            for(i = 0; i < lng; this.aFrames[int(i)] = this.gifDecoder.getFrame(i),i++)
            {
            }
            this.arrayLng = this.aFrames.length;
            if(this.auto)
            {
               this.play();
            }
            else
            {
               this.gotoAndStop(1);
            }
            dispatchEvent(new GIFPlayerEvent(GIFPlayerEvent.COMPLETE,this.aFrames[0].bitmapData.rect));
         }
         catch(e:ScriptTimeoutError)
         {
            dispatchEvent(new TimeoutEvent(TimeoutEvent.TIME_OUT));
         }
         catch(e:FileTypeError)
         {
            dispatchEvent(new FileTypeEvent(FileTypeEvent.INVALID));
         }
         catch(e:Error)
         {
            throw new Error("An unknown error occured, make sure the GIF file contains at least one frame\nNumber of frames : " + aFrames.length);
         }
         return this.aFrames[0].bitmapData;
      }
      
      private function update(pEvt:TimerEvent) : void
      {
         var delay:int = this.aFrames[this.iIndex = this.iInc++ % this.arrayLng].delay;
         pEvt.target.delay = delay > 0?delay:100;
         switch(this.gifDecoder.disposeValue)
         {
            case 1:
               if(!this.iIndex)
               {
                  bitmapData = this.aFrames[0].bitmapData.clone();
               }
               bitmapData.draw(this.aFrames[this.iIndex].bitmapData);
               break;
            case 2:
               bitmapData = this.aFrames[this.iIndex].bitmapData;
         }
         dispatchEvent(new FrameEvent(FrameEvent.FRAME_RENDERED,this.aFrames[this.iIndex]));
      }
      
      private function concat(pIndex:int) : int
      {
         bitmapData.lock();
         for(var i:int = 0; i < pIndex; bitmapData.draw(this.aFrames[i].bitmapData),i++)
         {
         }
         bitmapData.unlock();
         return i;
      }
      
      public function load(pRequest:URLRequest) : void
      {
         this.stop();
         this.urlLoader.load(pRequest);
      }
      
      public function loadBytes(pBytes:ByteArray) : BitmapData
      {
         return this.readStream(pBytes);
      }
      
      public function play() : void
      {
         if(this.aFrames.length)
         {
            if(!this.myTimer.running)
            {
               this.myTimer.start();
            }
            return;
         }
         throw new Error("Nothing to play");
      }
      
      public function stop() : void
      {
         if(this.myTimer.running)
         {
            this.myTimer.stop();
         }
      }
      
      public function get currentFrame() : int
      {
         return this.iIndex + 1;
      }
      
      public function get totalFrames() : int
      {
         return this.aFrames.length;
      }
      
      public function get loopCount() : int
      {
         return this.gifDecoder.getLoopCount();
      }
      
      public function get autoPlay() : Boolean
      {
         return this.auto;
      }
      
      public function get frames() : Array
      {
         return this.aFrames;
      }
      
      public function gotoAndStop(pFrame:int) : void
      {
         if(Boolean(pFrame >= 1) && Boolean(pFrame <= this.aFrames.length))
         {
            this.iInc = int(int(pFrame) - 1);
            switch(this.gifDecoder.disposeValue)
            {
               case 1:
                  bitmapData = this.aFrames[0].bitmapData.clone();
                  bitmapData.draw(this.aFrames[this.concat(this.iInc)].bitmapData);
                  break;
               case 2:
                  bitmapData = this.aFrames[this.iInc].bitmapData;
            }
            if(this.myTimer.running)
            {
               this.myTimer.stop();
            }
            return;
         }
         throw new RangeError("Frame out of range, please specify a frame between 1 and " + this.aFrames.length);
      }
      
      public function gotoAndPlay(pFrame:int) : void
      {
         if(Boolean(pFrame >= 1) && Boolean(pFrame <= this.aFrames.length))
         {
            this.iInc = int(int(pFrame) - 1);
            switch(this.gifDecoder.disposeValue)
            {
               case 1:
                  bitmapData = this.aFrames[0].bitmapData.clone();
                  bitmapData.draw(this.aFrames[this.concat(this.iInc)].bitmapData);
                  break;
               case 2:
                  bitmapData = this.aFrames[this.iInc].bitmapData;
            }
            if(!this.myTimer.running)
            {
               this.myTimer.start();
            }
            return;
         }
         throw new RangeError("Frame out of range, please specify a frame between 1 and " + this.aFrames.length);
      }
      
      public function getFrame(pFrame:int) : GIFFrame
      {
         var frame:GIFFrame = null;
         if(Boolean(pFrame >= 1) && Boolean(pFrame <= this.aFrames.length))
         {
            frame = this.aFrames[pFrame - 1];
            return frame;
         }
         throw new RangeError("Frame out of range, please specify a frame between 1 and " + this.aFrames.length);
      }
      
      public function getDelay(pFrame:int) : int
      {
         var delay:int = 0;
         if(Boolean(pFrame >= 1) && Boolean(pFrame <= this.aFrames.length))
         {
            delay = this.aFrames[pFrame - 1].delay;
            return delay;
         }
         throw new RangeError("Frame out of range, please specify a frame between 1 and " + this.aFrames.length);
      }
   }
}
