package org.alivepdf.fonts
{
   import flash.events.EventDispatcher;
   import flash.utils.Dictionary;
   import flash.utils.ByteArray;
   
   public final class AFMParser extends EventDispatcher
   {
      
      protected static var fix:Object = {
         "Edot":"Edotaccent",
         "edot":"edotaccent",
         "Idot":"Idotaccent",
         "Zdot":"Zdotaccent",
         "zdot":"zdotaccent",
         "Odblacute":"Ohungarumlaut",
         "odblacute":"ohungarumlaut",
         "Udblacute":"Uhungarumlaut",
         "udblacute":"uhungarumlaut",
         "Gcedilla":"Gcommaaccent",
         "gcedilla":"gcommaaccent",
         "Kcedilla":"Kcommaaccent",
         "kcedilla":"kcommaaccent",
         "Lcedilla":"Lcommaaccent",
         "lcedilla":"lcommaaccent",
         "Ncedilla":"Ncommaaccent",
         "ncedilla":"ncommaaccent",
         "Rcedilla":"Rcommaaccent",
         "rcedilla":"rcommaaccent",
         "Scedilla":"Scommaaccent",
         "scedilla":"scommaaccent",
         "Tcedilla":"Tcommaaccent",
         "tcedilla":"tcommaaccent",
         "Dslash":"Dcroat",
         "dslash":"dcroat",
         "Dmacron":"Dcroat",
         "dmacron":"dcroat",
         "combininggraveaccent":"gravecomb",
         "combininghookabove":"hookabovecomb",
         "combiningtildeaccent":"tildecomb",
         "combiningacuteaccent":"acutecomb",
         "combiningdotbelow":"dotbelowcomb",
         "dongsign":"dong"
      };
      
      protected static const reg:RegExp = /[ ]+/;
      
      protected static const C:String = "C";
      
      protected static const AC:String = "20AC";
      
      protected static const EURO:String = "Euro";
      
      private static const TRUETYPE:int = 65536;
      
      private static const TYPE1:int = 37;
       
      protected var _widths:Dictionary;
      
      protected var _fontName:String;
      
      protected var _ascender;
      
      protected var _capHeight;
      
      protected var _capXHeight;
      
      protected var _descender;
      
      protected var _isFixedPitch:Boolean;
      
      protected var _italicAngle;
      
      protected var _missingWidth:int;
      
      protected var _stdVW;
      
      protected var _underlineThickness;
      
      protected var _underlinePosition;
      
      protected var _weight:String;
      
      protected var _flags:int;
      
      protected var _stemV;
      
      protected var _boundingBox:Array;
      
      protected var _differences:String;
      
      protected var _type:String;
      
      protected var fm:Dictionary;
      
      protected var widthsBuffer:Dictionary;
      
      public function AFMParser(stream:ByteArray, afm:ByteArray, encoding:Class)
      {
         this.fm = new Dictionary(true);
         this.widthsBuffer = new Dictionary(true);
         super();
         this.makeFont(stream,afm,encoding);
      }
      
      protected function readMap(enc:ByteArray) : Array
      {
         var item:String = null;
         var i:int = 0;
         var e:Array = null;
         var cc:int = 0;
         var gn:String = null;
         enc.position = 0;
         var a:String = enc.readUTFBytes(enc.bytesAvailable);
         var cc2gn:Array = new Array();
         var tab:Array = a.split("\n");
         for each(item in tab)
         {
            if(item.charAt(0) == "!")
            {
               e = item.split(AFMParser.reg);
               cc = int("0x" + e[0].substr(1));
               gn = e[2];
               cc2gn[cc] = gn;
            }
         }
         for(i = 0; i <= 255; i++)
         {
            if(cc2gn[i] == null)
            {
               cc2gn[i] = ".notdef";
            }
         }
         return cc2gn;
      }
      
      protected function readAFM(file:ByteArray, map:Array) : Dictionary
      {
         var item:String = null;
         var e:Array = null;
         var code:String = null;
         var param:String = null;
         var cc:int = 0;
         var w:int = 0;
         var gn:String = null;
         var n:* = null;
         var i:int = 0;
         this.widthsBuffer.length = 0;
         var a:String = file.readUTFBytes(file.bytesAvailable);
         var buffer:Array = a.split("\n");
         for each(item in buffer)
         {
            e = item.split(" ");
            if(e.length >= 2)
            {
               code = e[0];
               param = e[1];
               if(code == AFMParser.C)
               {
                  cc = int(e[1]);
                  w = e[4];
                  gn = e[7];
                  if(gn.substr(-4) == AFMParser.AC)
                  {
                     gn = AFMParser.EURO;
                  }
                  if(AFMParser.fix[gn] != null)
                  {
                     for(n in map)
                     {
                        if(map[n] == AFMParser.fix[gn])
                        {
                           map[n] = gn;
                        }
                     }
                  }
                  if(map.length == 0)
                  {
                     this.widthsBuffer[cc] = w;
                  }
                  else
                  {
                     this.widthsBuffer[gn] = w;
                     if(gn == "X")
                     {
                        this._capXHeight = e[13];
                     }
                  }
                  if(gn == ".notdef")
                  {
                     this._missingWidth = w;
                  }
               }
               else if(code == "FontName")
               {
                  this._fontName = param;
               }
               else if(code == "Weight")
               {
                  this._weight = param;
               }
               else if(code == "ItalicAngle")
               {
                  this._italicAngle = int(param);
               }
               else if(code == "Ascender")
               {
                  this._ascender = int(param);
               }
               else if(code == "Descender")
               {
                  this._descender = int(param);
               }
               else if(code == "UnderlineThickness")
               {
                  this._underlineThickness = int(param);
               }
               else if(code == "UnderlinePosition")
               {
                  this._underlinePosition = int(param);
               }
               else if(code == "IsFixedPitch")
               {
                  this._isFixedPitch = param == "true";
               }
               else if(code == "FontBBox")
               {
                  this._boundingBox = new Array(e[1],e[2],e[3],e[4]);
               }
               else if(code == "CapHeight")
               {
                  this._capHeight = int(param);
               }
               else if(code == "StdVW")
               {
                  this._stdVW = int(param);
               }
            }
         }
         if(this._fontName == null)
         {
            throw new Error("FontName not found");
         }
         if(map.length > 0)
         {
            if(this.widthsBuffer[".notdef"] == null)
            {
               this.widthsBuffer[".notdef"] = 600;
            }
            if(Boolean(this.widthsBuffer["Delta"] == null) && Boolean(this.widthsBuffer["increment"] != null))
            {
               this.widthsBuffer["Delta"] = this.widthsBuffer["increment"];
            }
            for(i = 0; i <= 255; i++)
            {
               if(this.widthsBuffer[map[i]] == null)
               {
                  this.widthsBuffer[i] = this.widthsBuffer[".notdef"];
               }
               else
               {
                  this.widthsBuffer[i] = this.widthsBuffer[map[i]];
               }
            }
         }
         return this.widthsBuffer;
      }
      
      protected function makeFontDescriptor(fm:Object, symbolic:Boolean) : void
      {
         var ch:int = 0;
         this._ascender = this._ascender != null?this._ascender:1000;
         this._descender = this._descender != null?this._descender:-200;
         if(this._capHeight != null)
         {
            this._capHeight = this._capHeight;
         }
         else if(this._capXHeight != null)
         {
            this._capHeight = this._capXHeight;
         }
         else
         {
            this._capHeight = this._ascender;
         }
         if(this._isFixedPitch)
         {
            this._flags = this._flags + (1 << 0);
         }
         if(symbolic)
         {
            this._flags = this._flags + (1 << 2);
         }
         if(!symbolic)
         {
            this._flags = this._flags + (1 << 5);
         }
         if(Boolean(this._italicAngle != 0) && Boolean(this._isFixedPitch != 0))
         {
            this._flags = this._flags + (1 << 6);
         }
         if(this._boundingBox == null)
         {
            this._boundingBox = new Array(0,this._descender - 100,1000,this._ascender + 100);
         }
         if(this._italicAngle == null)
         {
            this._italicAngle = 0;
         }
         if(this._stdVW != null)
         {
            this._stemV = this._stdVW;
         }
         else if(Boolean(this._weight != null) && Boolean(this._weight.match("/bold|black/i")))
         {
            this._stemV = 120;
         }
         else
         {
            this._stemV = 70;
         }
      }
      
      protected function makeWidthArray(buffer:Dictionary) : Dictionary
      {
         this.fm.length = 0;
         for(var i:int = 0; i <= 255; i++)
         {
            this.fm[String.fromCharCode(i)] = buffer[i];
         }
         return this.fm;
      }
      
      protected function makeFontEncoding(map:Array) : String
      {
         var ref:Array = this.readMap(new CodePage.CP1252());
         var s:String = new String();
         var last:int = 0;
         for(var i:int = 32; i <= 255; i++)
         {
            if(map[i] != ref[i])
            {
               if(i != last + 1)
               {
                  s = s + (i + " ");
               }
               last = i;
               s = s + ("/" + map[i] + " ");
            }
         }
         return s;
      }
      
      public function makeFont(fontfile:ByteArray, afmfile:ByteArray, enc:Class) : void
      {
         var p:* = null;
         var fm:Dictionary = null;
         var differences:String = null;
         var header:uint = 0;
         var patch:Array = new Array();
         var map:Array = this.readMap(new enc());
         for(p in patch)
         {
            map[p] = patch[p];
         }
         fm = this.readAFM(afmfile,map);
         differences = this.makeFontEncoding(map);
         if(differences.length)
         {
            this._differences = differences;
         }
         this.makeFontDescriptor(fm,map.length == 0);
         if(fontfile != null)
         {
            fontfile.position = 0;
            header = fontfile.readUnsignedInt();
            if(header == AFMParser.TRUETYPE)
            {
               this._type = FontType.TRUE_TYPE;
            }
            else if(Boolean(!(fontfile.position = 0)) && Boolean(fontfile.readByte() == AFMParser.TYPE1))
            {
               this._type = FontType.TYPE1;
            }
            else
            {
               throw new Error("Error: unrecognized font file.");
            }
         }
         else if(Boolean(this.type != FontType.TRUE_TYPE) && Boolean(this.type != FontType.TYPE1))
         {
            throw new Error("<b>Error:</b> incorrect font type: " + this.type);
         }
         if(this._underlinePosition == null)
         {
            this._underlinePosition = -100;
         }
         if(this._underlineThickness == null)
         {
            this._underlineThickness = 50;
         }
         this._widths = this.makeWidthArray(fm);
      }
      
      public function get boundingBox() : Array
      {
         return this._boundingBox;
      }
      
      public function get weight() : String
      {
         return this._weight;
      }
      
      public function get underlinePosition() : *
      {
         return this._underlinePosition;
      }
      
      public function get underlineThickness() : *
      {
         return this._underlineThickness;
      }
      
      public function get stdVW() : int
      {
         return this._stdVW;
      }
      
      public function get missingWidth() : int
      {
         return this._missingWidth;
      }
      
      public function get italicAngle() : int
      {
         return this._italicAngle;
      }
      
      public function get descender() : int
      {
         return this._descender;
      }
      
      public function get capXHeight() : int
      {
         return this._capXHeight;
      }
      
      public function get capHeight() : int
      {
         return this._capHeight;
      }
      
      public function get ascender() : int
      {
         return this._ascender;
      }
      
      public function get fontName() : String
      {
         return this._fontName;
      }
      
      public function get widths() : Dictionary
      {
         return this._widths;
      }
      
      public function get stemV() : int
      {
         return this._stemV;
      }
      
      public function get differences() : String
      {
         return this._differences;
      }
      
      public function get type() : String
      {
         return this._type;
      }
   }
}
