package org.alivepdf.colors
{
   public final class RGBColor implements IColor
   {
       
      public var r:Number;
      
      public var g:Number;
      
      public var b:Number;
      
      public function RGBColor(color:Number)
      {
         super();
         this.r = color >> 16 & 255;
         this.g = color >> 8 & 255;
         this.b = color & 255;
      }
      
      public static function hexStringToRGBColor(hex:String) : RGBColor
      {
         var l:int = 0;
         hex = hex.toLowerCase();
         if(hex.indexOf("0x") > -1)
         {
            l = hex.length - 2;
            hex = hex.substr(hex.length - l,l);
         }
         if(hex.indexOf("#") > -1)
         {
            l = hex.length - 1;
            hex = hex.substr(hex.length - l,l);
         }
         l = hex.length;
         if(l > 6)
         {
            hex = hex.substr(0,6);
         }
         var c:Number = parseInt(hex,16);
         return new RGBColor(c);
      }
   }
}
