package mx.effects
{
   import mx.core.mx_internal;
   import mx.effects.effectClasses.MoveInstance;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.effects.Move",since="4.0")]
   public class Move extends TweenEffect
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var AFFECTED_PROPERTIES:Array = ["x","y"];
      
      private static var RELEVANT_STYLES:Array = ["left","right","top","bottom","horizontalCenter","verticalCenter"];
       
      [Inspectable(defaultValue="NaN",category="General")]
      public var xBy:Number;
      
      [Inspectable(defaultValue="NaN",category="General")]
      public var xFrom:Number;
      
      [Inspectable(defaultValue="NaN",category="General")]
      public var xTo:Number;
      
      [Inspectable(defaultValue="NaN",category="General")]
      public var yBy:Number;
      
      [Inspectable(defaultValue="NaN",category="General")]
      public var yFrom:Number;
      
      [Inspectable(defaultValue="NaN",category="General")]
      public var yTo:Number;
      
      public function Move(target:Object = null)
      {
         super(target);
         instanceClass = MoveInstance;
      }
      
      override public function getAffectedProperties() : Array
      {
         return AFFECTED_PROPERTIES;
      }
      
      override public function get relevantStyles() : Array
      {
         return RELEVANT_STYLES;
      }
      
      override protected function initInstance(instance:IEffectInstance) : void
      {
         var moveInstance:MoveInstance = null;
         super.initInstance(instance);
         moveInstance = MoveInstance(instance);
         moveInstance.xFrom = this.xFrom;
         moveInstance.xTo = this.xTo;
         moveInstance.xBy = this.xBy;
         moveInstance.yFrom = this.yFrom;
         moveInstance.yTo = this.yTo;
         moveInstance.yBy = this.yBy;
      }
   }
}
