package mx.accessibility
{
   import flash.accessibility.AccessibilityProperties;
   import mx.core.mx_internal;
   import mx.core.UIComponent;
   import flash.events.Event;
   import flash.accessibility.Accessibility;
   
   use namespace mx_internal;
   
   public class UIComponentAccProps extends AccessibilityProperties
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var oldToolTip:String;
      
      private var oldErrorString:String;
      
      protected var master:UIComponent;
      
      public function UIComponentAccProps(component:UIComponent)
      {
         var formName:String = null;
         super();
         this.master = component;
         if(component.accessibilityProperties)
         {
            silent = component.accessibilityProperties.silent;
            forceSimple = component.accessibilityProperties.forceSimple;
            noAutoLabeling = component.accessibilityProperties.noAutoLabeling;
            if(component.accessibilityProperties.name)
            {
               name = component.accessibilityProperties.name;
            }
            if(component.accessibilityProperties.description)
            {
               description = component.accessibilityProperties.description;
            }
            if(component.accessibilityProperties.shortcut)
            {
               shortcut = component.accessibilityProperties.shortcut;
            }
         }
         var scrollBarClass:Class = Class(AccImpl.getDefinition("mx.controls.scrollClasses.ScrollBar",this.master.moduleFactory));
         if(Boolean(scrollBarClass) && Boolean(this.master is scrollBarClass))
         {
            silent = true;
            return;
         }
         var formItemLabelClass:Class = Class(AccImpl.getDefinition("mx.controls.FormItemLabel",this.master.moduleFactory));
         if(Boolean(formItemLabelClass) && Boolean(this.master is formItemLabelClass))
         {
            name = AccImpl.getFormName(this.master);
            silent = true;
         }
         else
         {
            formName = AccImpl.getFormName(this.master);
            if(Boolean(formName) && Boolean(formName.length != 0))
            {
               name = formName + name;
            }
            if(Boolean(this.master.toolTip) && Boolean(this.master.toolTip.length != 0))
            {
               if(Boolean(!component.accessibilityProperties) || Boolean(component.accessibilityProperties) && Boolean(!component.accessibilityProperties.name))
               {
                  this.oldToolTip = " " + this.master.toolTip;
                  name = name + this.oldToolTip;
               }
            }
            if(Boolean(this.master.errorString) && Boolean(this.master.errorString.length != 0))
            {
               this.oldErrorString = " " + this.master.errorString;
               name = name + this.oldErrorString;
            }
            this.master.addEventListener("toolTipChanged",this.eventHandler);
            this.master.addEventListener("errorStringChanged",this.eventHandler);
         }
      }
      
      public static function enableAccessibility() : void
      {
         UIComponent.createAccessibilityImplementation = createAccessibilityImplementation;
      }
      
      mx_internal static function createAccessibilityImplementation(component:UIComponent) : void
      {
         component.accessibilityProperties = new UIComponentAccProps(component);
      }
      
      protected function eventHandler(event:Event) : void
      {
         var pos:int = 0;
         switch(event.type)
         {
            case "errorStringChanged":
               if(Boolean(name) && Boolean(name.length != 0) && Boolean(this.oldErrorString))
               {
                  pos = name.indexOf(this.oldErrorString);
                  if(pos != -1)
                  {
                     name = name.substring(0,pos) + name.substring(pos + this.oldErrorString.length);
                  }
                  this.oldErrorString = null;
               }
               if(Boolean(this.master.errorString) && Boolean(this.master.errorString.length != 0))
               {
                  if(!name)
                  {
                     name = "";
                  }
                  this.oldErrorString = " " + this.master.errorString;
                  name = name + this.oldErrorString;
               }
               Accessibility.updateProperties();
               break;
            case "toolTipChanged":
               if(Boolean(name) && Boolean(name.length != 0) && Boolean(this.oldToolTip))
               {
                  pos = name.indexOf(this.oldToolTip);
                  if(pos != -1)
                  {
                     name = name.substring(0,pos) + name.substring(pos + this.oldToolTip.length);
                  }
                  this.oldToolTip = null;
               }
               if(Boolean(this.master.toolTip) && Boolean(this.master.toolTip.length != 0))
               {
                  if(Boolean(!this.master.accessibilityProperties) || Boolean(this.master.accessibilityProperties) && Boolean(!this.master.accessibilityProperties.name))
                  {
                     if(!name)
                     {
                        name = "";
                     }
                     this.oldToolTip = " " + this.master.toolTip;
                     name = name + this.oldToolTip;
                  }
               }
               Accessibility.updateProperties();
         }
      }
   }
}
