package flashx.textLayout.elements
{
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class FlowValueHolder extends TextLayoutFormatValueHolder
   {
       
      private var _userStyles:Object;
      
      private var _privateData:Object;
      
      public function FlowValueHolder(initialValues:FlowValueHolder = null)
      {
         super(initialValues);
         this.initialize(initialValues);
      }
      
      private function initialize(initialValues:FlowValueHolder) : void
      {
         var s:* = null;
         if(initialValues)
         {
            for(s in initialValues.userStyles)
            {
               this.writableUserStyles()[s] = initialValues.userStyles[s];
            }
            for(s in initialValues.privateData)
            {
               this.writablePrivateData()[s] = initialValues.privateData[s];
            }
         }
      }
      
      private function writableUserStyles() : Object
      {
         if(this._userStyles == null)
         {
            this._userStyles = new Object();
         }
         return this._userStyles;
      }
      
      public function get userStyles() : Object
      {
         return this._userStyles;
      }
      
      public function set userStyles(val:Object) : void
      {
         this._userStyles = val;
      }
      
      public function getUserStyle(styleProp:String) : *
      {
         return Boolean(this._userStyles)?this._userStyles[styleProp]:undefined;
      }
      
      public function setUserStyle(styleProp:String, newValue:*) : void
      {
         if(newValue === undefined)
         {
            if(this._userStyles)
            {
               delete this._userStyles[styleProp];
            }
         }
         else
         {
            this.writableUserStyles()[styleProp] = newValue;
         }
      }
      
      private function writablePrivateData() : Object
      {
         if(this._privateData == null)
         {
            this._privateData = new Object();
         }
         return this._privateData;
      }
      
      public function get privateData() : Object
      {
         return this._privateData;
      }
      
      public function set privateData(val:Object) : void
      {
         this._privateData = val;
      }
      
      public function getPrivateData(styleProp:String) : *
      {
         return Boolean(this._privateData)?this._privateData[styleProp]:undefined;
      }
      
      public function setPrivateData(styleProp:String, newValue:*) : void
      {
         if(newValue === undefined)
         {
            if(this._privateData)
            {
               delete this._privateData[styleProp];
            }
         }
         else
         {
            this.writablePrivateData()[styleProp] = newValue;
         }
      }
   }
}
