#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## DaqGroup downloader.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

readonly xterm="xterm -fa 'PT Mono' -fs 12 -geometry 138x35+90+130 -hold -e";
readonly diesel_site="http://www.visual-t.ru";

function download_site(){
 local site="$1"; shift;
 wget --no-check-certificate -e robots=off -np -m "$@" $site;
 colorize_bold echo -ne "\n Done download: $site\n\n";
};

function download_wanted_sites(){
 download_site $diesel_site;
 #download_site $diesel_site/files/ZEOSDBO.7z;
 #download_site $diesel_site/files/fpspreadsheet.7z;
};

function main(){
 if [ -t 1 ]; then
  if pushd $scriptHOME >/dev/null 2>&1; then
   download_wanted_sites;
   find . -name '*.html?*' -delete;
  fi;
  popd >/dev/null 2>&1;
  echo; colorize_bold echo " Done!"; echo;
 else
  local ask="$(langstr ru "Вы уверены, что хотите выполнить загрузку $diesel_site?" en "Are you sure to proceed download $diesel_site?")";
  if zenity --question --timeout 180 --text="$ask"; then eval $xterm $scriptFILE "$@"; fi;
 fi;
};

main "$@";

##############
## END OF FILE
##############
