unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, DBGrids,
  StdCtrls, IBDatabase, IBCustomDataSet, XDBGrids, db;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    IBDatabase1: TIBDatabase;
    IBDataSet1: TIBDataSet;
    IBRead: TIBTransaction;
    IBWrite: TIBTransaction;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure DBGrid1TitleClick(Column: TColumn);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure OnAppExeption(Sender: TObject; E: Exception);
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses dateutils, LazUTF8, IB, LConvEncoding, LCLType;

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnException := @OnAppExeption;
  IBDatabase1.Open;
  IBRead.StartTransaction;
end;

procedure TForm1.DBGrid1TitleClick(Column: TColumn);
begin
  IBDataSet1.OrderFields := Column.FieldName;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  IBDataSet1.FullRefresh;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  IBDatabase1.CloseDataSets;
  IBRead.Commit;
  IBDatabase1.Close;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  IBDataSet1.Open;
end;

procedure TForm1.OnAppExeption(Sender: TObject; E: Exception);
var
  S: string;
  SL: TStringList;
  SQLErrCode, IBErrCode: LongInt;
begin
  //Application.Flags:= Application.Flags + [AppHandlingException];
  if (not Application.Terminated) and (AppInitialized in Application.Flags) then
  begin
    Application.DisableIdleHandler;
    try
      S := E.Message;
      if FindInvalidUTF8Character(PChar(S), Length(S), False) > 0 then
        S := CP1251ToUTF8(S);

      if E is EIBInterBaseError then
      begin
        SQLErrCode := EIBInterBaseError(E).SQLCode;
        IBErrCode:= EIBInterBaseError(E).IBErrorCode;
        if (SQLErrCode = -836) and ((IBErrCode = 335544517) or
        (IBErrCode = 335544848))  then
        begin
          SL := TStringList.Create;
          SL.Text:= S;
          if SL.Count > 2 then
            S := SL.Strings[2];
          SL.Free;

        end;
      end;

      Application.MessageBox(PChar(S), PChar(Application.Title), MB_OK or MB_ICONERROR);
    finally
      Application.EnableIdleHandler;
    end;
  end;
end;

initialization
  //Для нормальной работы IBX в Linux
  DefaultFormatSettings.ThousandSeparator := ' ';
  FormatSettings.ThousandSeparator := ' ';
  FormatSettings.DateSeparator := '.';
  FormatSettings.ShortDateFormat := 'dd.mm.yyyy';

end.

