unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, ExtCtrls, DBGrids, IBDatabase, IBCustomDataSet, db;

type

  { TForm1 }

  TForm1 = class(TForm)
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    IBDataSet1: TIBDataSet;
    Label1: TLabel;
    Panel1: TPanel;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure OnAppExeption(Sender: TObject; E: Exception);
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses data, LConvEncoding, LazUTF8, IB, LCLType;

procedure ConvetToUTF8LocalConst;
begin
  DefaultFormatSettings.ShortMonthNames[1]:='января';
  DefaultFormatSettings.ShortMonthNames[2]:='февраля';
  DefaultFormatSettings.ShortMonthNames[3]:='марта';
  DefaultFormatSettings.ShortMonthNames[4]:='апреля';
  DefaultFormatSettings.ShortMonthNames[5]:='мая';
  DefaultFormatSettings.ShortMonthNames[6]:='июня';
  DefaultFormatSettings.ShortMonthNames[7]:='июля';
  DefaultFormatSettings.ShortMonthNames[8]:='августа';
  DefaultFormatSettings.ShortMonthNames[9]:='сентября';
  DefaultFormatSettings.ShortMonthNames[10]:='октября';
  DefaultFormatSettings.ShortMonthNames[11]:='ноября';
  DefaultFormatSettings.ShortMonthNames[12]:='декабря';

  DefaultFormatSettings.LongMonthNames[1]:='Январь';
  DefaultFormatSettings.LongMonthNames[2]:='Февраль';
  DefaultFormatSettings.LongMonthNames[3]:='Март';
  DefaultFormatSettings.LongMonthNames[4]:='Апрель';
  DefaultFormatSettings.LongMonthNames[5]:='Май';
  DefaultFormatSettings.LongMonthNames[6]:='Июнь';
  DefaultFormatSettings.LongMonthNames[7]:='Июль';
  DefaultFormatSettings.LongMonthNames[8]:='Август';
  DefaultFormatSettings.LongMonthNames[9]:='Сентябрь';
  DefaultFormatSettings.LongMonthNames[10]:='Октябрь';
  DefaultFormatSettings.LongMonthNames[11]:='Ноябрь';
  DefaultFormatSettings.LongMonthNames[12]:='Декабрь';

  DefaultFormatSettings.LongDayNames[1]:='Воскресенье';
  DefaultFormatSettings.LongDayNames[2]:='Понедельник';
  DefaultFormatSettings.LongDayNames[3]:='Вторник';
  DefaultFormatSettings.LongDayNames[4]:='Среда';
  DefaultFormatSettings.LongDayNames[5]:='Четверг';
  DefaultFormatSettings.LongDayNames[6]:='Пятница';
  DefaultFormatSettings.LongDayNames[7]:='Суббота';

  DefaultFormatSettings.ShortDayNames[1]:='Вс';
  DefaultFormatSettings.ShortDayNames[2]:='Пн';
  DefaultFormatSettings.ShortDayNames[3]:='Вт';
  DefaultFormatSettings.ShortDayNames[4]:='Ср';
  DefaultFormatSettings.ShortDayNames[5]:='Чт';
  DefaultFormatSettings.ShortDayNames[6]:='Пт';
  DefaultFormatSettings.ShortDayNames[7]:='Сб';
end;

procedure InitLocale;
begin
  DefaultFormatSettings.LongDateFormat:='dd.mm.yyyy';
  DefaultFormatSettings.ShortDateFormat:=DefaultFormatSettings.LongDateFormat;
  DefaultFormatSettings.DateSeparator:='.';
  DefaultFormatSettings.TimeSeparator:=':';
  DefaultFormatSettings.ThousandSeparator:=' ';
  DefaultFormatSettings.CurrencyString:='р.';

  ConvetToUTF8LocalConst;
end;

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnException := @OnAppExeption;
  DM.IBDatabase.Open;
end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  CloseAction :=  caFree;
  IBDataSet1.Close;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  DM.IBDatabase.CloseDataSets;
  DM.IBDatabase.Close;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  IBDataSet1.Open;
end;

procedure TForm1.OnAppExeption(Sender: TObject; E: Exception);
var
  S: string;
  SL: TStringList;
  SQLErrCode, IBErrCode: LongInt;
begin
  //Application.Flags:= Application.Flags + [AppHandlingException];
  if (not Application.Terminated) and (AppInitialized in Application.Flags) then
  begin
    Application.DisableIdleHandler;
    try
      S := E.Message;
      if FindInvalidUTF8Character(PChar(S), Length(S), False) > 0 then
        S := CP1251ToUTF8(S);

      if E is EIBInterBaseError then
      begin
        SQLErrCode := EIBInterBaseError(E).SQLCode;
        IBErrCode:= EIBInterBaseError(E).IBErrorCode;
        if (SQLErrCode = -836) and ((IBErrCode = 335544517) or
        (IBErrCode = 335544848))  then
        begin
          SL := TStringList.Create;
          SL.Text:= S;
          if SL.Count > 2 then
            S := SL.Strings[2];
          SL.Free;

        end;
      end;

      Application.MessageBox(PChar(S), PChar(Application.Title), MB_OK or MB_ICONERROR);
    finally
      Application.EnableIdleHandler;
    end;
  end;
end;

initialization
  {$I main.lrs}
  InitLocale;

end.

