unit ZSQLPropEdit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, SQLEditor, PropEdits, ZDataset, ZSqlUpdate, ZSqlMetadata,
  ZAbstractDataset, Forms, ComCtrls, ZAbstractRODataset;

type
  { TZSQLPropertyEditor }

  TZSQLPropertyEditor = class(TSQLPropertyEditor)
  protected
    MainMetadata: TZSQLMetadata;
    SubMetadata: TZSQLMetadata;
    IndexedColumn: TZSQLMetadata;
    PKeyMetadata: TZSQLMetadata;
  public
    constructor Create(Hook: TPropertyEditorHook; APropCount: Integer);
       override;
    destructor Destroy; override;
    procedure LoadMetadata(MetaTypes: TMetadataTypes); override;
  end;

implementation

{ TZSQLPropertyEditor }

constructor TZSQLPropertyEditor.Create(Hook: TPropertyEditorHook;
  APropCount: Integer);
begin
  inherited Create(Hook, APropCount);
  MainMetadata := TZSQLMetadata.Create(Application);
  SubMetadata := TZSQLMetadata.Create(Application);
  PKeyMetadata := TZSQLMetadata.Create(Application);
end;

destructor TZSQLPropertyEditor.Destroy;
begin
  FreeAndNil(MainMetadata);
  FreeAndNil(SubMetadata);
  FreeAndNil(PKeyMetadata);
  inherited Destroy;
end;

procedure TZSQLPropertyEditor.LoadMetadata(MetaTypes: TMetadataTypes);
var
  Connect: Boolean;
  Node: TTreeNode;
  S: string;
  B: Boolean;
  DataSet: TZAbstractRODataset;
begin
  ClearNameList;
  DataSet := nil;
  if GetComponent(0) is TZAbstractRODataset then
    DataSet := TZAbstractRODataset(GetComponent(0))
  else
  if GetComponent(0) is TZUpdateSQL then
    DataSet := TZAbstractDataset(TZUpdateSQL(GetComponent(0)).DataSet);

  if DataSet = nil then Exit;
  MainMetadata.Connection := DataSet.Connection;
  SubMetadata.Connection := MainMetadata.Connection;
  PKeyMetadata.Connection := MainMetadata.Connection;
  if MainMetadata.Connection = nil then Exit;
  Connect:= MainMetadata.Connection.Connected;
  if not Connect then MainMetadata.Connection.Connect;
  if not MainMetadata.Connection.Connected then Exit;
  try
    if mtTable in MetaTypes then
    begin
      MainMetadata.MetadataType := mdTables;
      MainMetadata.SortedFields:= 'TABLE_NAME';
      MainMetadata.Open;
      while not MainMetadata.EOF do
      begin
        if (MainMetadata.FieldByName('TABLE_TYPE').AsString = 'TABLE') and
         (MainMetadata.FieldByName('TABLE_SCHEM').AsString <> 'information_schema') and
         (MainMetadata.FieldByName('TABLE_SCHEM').AsString <> 'pg_catalog') then
        begin
          if MainMetadata.FieldByName('TABLE_SCHEM').IsNull or
           (MainMetadata.FieldByName('TABLE_SCHEM').AsString = 'public') then
            S := MainMetadata.FieldByName('TABLE_NAME').AsString
          else
            S := MainMetadata.FieldByName('TABLE_SCHEM').AsString + '.' + MainMetadata.FieldByName('TABLE_NAME').AsString;
          Node := AddTable(S);
          SubMetadata.MetadataType := mdColumns;
          SubMetadata.TableName := S;
          PKeyMetadata.MetadataType := mdPrimaryKeys;
          PKeyMetadata.TableName := S;
          SubMetadata.Open;
          PKeyMetadata.Open;
          while not SubMetadata.EOF do
          begin
            S := SubMetadata.FieldByName('COLUMN_NAME').AsString;
            B := False;
            if PKeyMetadata.Locate('COLUMN_NAME', S, []) then B := True;
            AddField(Node, S, B);
            SubMetadata.Next;
          end;
          SubMetadata.Close;
          PKeyMetadata.Close;
        end;
        MainMetadata.Next;
      end;
      MainMetadata.Close;
    end;
    if mtView in MetaTypes then
    begin
      MainMetadata.MetadataType := mdTables;
      MainMetadata.SortedFields:= 'TABLE_NAME';
      MainMetadata.Open;
      while not MainMetadata.EOF do
      begin
        if MainMetadata.FieldByName('TABLE_TYPE').AsString = 'VIEW' then
        begin
          S := MainMetadata.FieldByName('TABLE_NAME').AsString;
          Node := AddView(S);
          SubMetadata.MetadataType := mdColumns;
          SubMetadata.TableName := S;
          SubMetadata.Open;
          while not SubMetadata.EOF do
          begin
            S := SubMetadata.FieldByName('COLUMN_NAME').AsString;
            AddField(Node, S, False);
            SubMetadata.Next;
          end;
          SubMetadata.Close;
        end;
        MainMetadata.Next;
      end;
      MainMetadata.Close;
    end;
    {if mtStoredProc in MetaTypes then
    begin
      MainMetadata.MetadataType:= mdProcedures;
      MainMetadata.SortedFields := 'PROCEDURE_NAME';
      SubMetadata.MetadataType:= mdProcedureColumns;
      MainMetadata.Open;
      while not MainMetadata.EOF do
      begin
        S := MainMetadata.FieldByName('PROCEDURE_NAME').AsString;
        Node := AddProcedure(S);
        SubMetadata.ProcedureName := S;
        SubMetadata.Open;
        while not SubMetadata.EOF do
        begin
          if SubMetadata.FieldByName('PROCEDURE_NAME').AsString = S then
          begin
            AddProcParam(Node, SubMetadata.FieldByName('COLUMN_NAME').AsString, SubMetadata.FieldByName('COLUMN_TYPE').AsInteger = 1);
          end;
          SubMetadata.Next;
        end;
        SubMetadata.Close;
        MainMetadata.Next;
      end;
      MainMetadata.Close;
    end;}
  finally
    if not Connect then MainMetadata.Connection.Disconnect;
  end;

end;

end.

