unit dpi_uos;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, Variants, uos, dpi_mettyps;

type

  { TUosHelperEndProc }

  { TUosHelperProc }

  TUosHelperProc = class
  public
    Proc: TSuProc;
    procedure UosProc;
  end;

  { TdpUOSImport }

  TdpUOSImport = class(TClassImporter)
    function uoslib_loadlib(Instance: TObject; var Params: Variant): Variant;
    function uoslib_unloadlib(Instance: TObject; var Params: Variant): Variant;

    function uoslib_uos_RePlay(Instance: TObject; var Params: Variant): Variant;
    function uoslib_uos_Stop(Instance: TObject; var Params: Variant): Variant;
    function uoslib_uos_Pause(Instance: TObject; var Params: Variant): Variant;
    function uoslib_uos_GetVersion(Instance: TObject; var Params: Variant): Variant;

    function uoslib_uos_PlayFile(Instance: TObject; var Params: Variant): Variant;
    function uoslib_uos_PlayFileEx(Instance: TObject; var Params: Variant): Variant;
    function uoslib_uos_Record(Instance: TObject; var Params: Variant): Variant;
    function uoslib_uos_RecordEx(Instance: TObject; var Params: Variant): Variant;

  protected
    procedure UosPlayEx(PlayerIndex: Integer; SoundPath: string; BeginProc, EndProc: TSuProc);
    procedure UosRecordEx(PlayerIndex: Integer; FileName: string; ListMic: Boolean; BeginProc, EndProc: TSuProc);
  public
    procedure AddMethods(AddMethod: TAddMethodProc); override;

  end;

implementation

uses
  Forms, FileUtil, uos_flat;

{ TUosHelperProc }

procedure TUosHelperProc.UosProc;
begin
  Proc.Exec;
  Free;
end;

{ TdpUOSImport }

function TdpUOSImport.uoslib_loadlib(Instance: TObject; var Params: Variant
  ): Variant;
var
  LibPortaudio, LibSndFile, LibMpg, LibSndTach: string;
  ordir: string;
begin
  ordir := application.Location;
{$IFDEF Windows}
  {$if defined(cpu64)}
  LibPortaudio := ordir + 'LibPortaudio-64.dll';
  LibSndFile := ordir + 'LibSndFile-64.dll';
  LibMpg := ordir + 'LibMpg123-64.dll';
  LibSndTach := ordir + 'LibSoundTouch-64.dll';
 {$else}
  LibPortaudio := ordir + 'LibPortaudio-32.dll';
  LibSndFile := ordir + 'LibSndFile-32.dll';
  LibMpg := ordir + 'LibMpg123-32.dll';
  LibSndTach := ordir + 'LibSoundTouch-32.dll';
  {$endif}
{$ENDIF}

{$IFDEF Darwin}
  opath := ordir;
  opath := copy(opath, 1, Pos('/uos', opath) - 1);
  LibPortaudio := opath + '/LibPortaudio-32.dylib';
  LibSndFile := opath + '/LibSndFile-32.dylib';
  LibMpg := opath + '/LibMpg123-32.dylib';
  LibSndTach := opath + '/LibSoundTouch-32.dylib'
{$ENDIF}

{$IFDEF linux}
    {$if defined(cpu64)}
    LibPortaudio := ordir + 'LibPortaudio-64.so';
    LibSndFile := ordir + 'LibSndFile-64.so';
    LibMpg := ordir + 'LibMpg123-64.so';
    LibSndTach := ordir + 'LibSoundTouch-64.so';
   {$else}
    LibPortaudio := ordir + 'LibPortaudio-32.so';
    LibSndFile := ordir + 'LibSndFile-32.so';
    LibMpg := ordir + 'LibMpg123-32.so';
    LibSndTach := ordir + 'LibSoundTouch-32.so';
   {$endif}

{$ENDIF}
  Result := uos_loadlib(PChar(LibPortaudio), PChar(LibSndFile), PChar(LibMpg), PChar(LibSndTach));
end;

function TdpUOSImport.uoslib_unloadlib(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := 0;
  uos_unloadlib;
end;

function TdpUOSImport.uoslib_uos_RePlay(Instance: TObject; var Params: Variant
  ): Variant;
begin
  uos_RePlay(Params[0]);
end;

function TdpUOSImport.uoslib_uos_Stop(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := 0;
  uos_Stop(Params[0]);
end;

function TdpUOSImport.uoslib_uos_Pause(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := 0;
  uos_Pause(Params[0]);
end;

function TdpUOSImport.uoslib_uos_GetVersion(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := uos_GetVersion();
end;

function TdpUOSImport.uoslib_uos_PlayFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  PlayerIndex: Integer;
  FileName: String;
begin
  Result := 0;
  PlayerIndex := Params[0];
  FileName := Params[1];
  UosPlayEx(PlayerIndex, FileName, nil, nil);
end;

function TdpUOSImport.uoslib_uos_PlayFileEx(Instance: TObject;
  var Params: Variant): Variant;
var
  PlayerIndex: Integer;
  FileName: String;
  ScriptProcBegin: TSuProc;
  ScriptProcEnd: TSuProc;
begin
  Result := 0;
  PlayerIndex := Params[0];
  FileName := Params[1];
  ScriptProcBegin := TSuProc( TSuPtr(Params[2]) );
  ScriptProcEnd := TSuProc( TSuPtr(Params[3]) );

  UosPlayEx(PlayerIndex, FileName, ScriptProcBegin, ScriptProcEnd);
end;


function TdpUOSImport.uoslib_uos_Record(Instance: TObject; var Params: Variant
  ): Variant;
var
  PlayerIndex: Integer;
  FileName: String;
  ListMic: Boolean;
begin
  Result := 0;
  PlayerIndex := Params[0];
  FileName := Params[1];
  ListMic := Params[2];

  UosRecordEx(PlayerIndex, FileName, ListMic, nil, nil);
end;

function TdpUOSImport.uoslib_uos_RecordEx(Instance: TObject; var Params: Variant
  ): Variant;
var
  PlayerIndex: Integer;
  FileName: String;
  ListMic: Boolean;
  ScriptProcBegin: TSuProc;
  ScriptProcEnd: TSuProc;
begin
  Result := 0;
  PlayerIndex := Params[0];
  FileName := Params[1];
  ListMic := Params[2];
  ScriptProcBegin := TSuProc( TSuPtr(Params[3]) );
  ScriptProcEnd := TSuProc( TSuPtr(Params[4]) );

  UosRecordEx(PlayerIndex, FileName, ListMic, ScriptProcBegin, ScriptProcEnd);
end;

procedure TdpUOSImport.UosPlayEx(PlayerIndex: Integer; SoundPath: string;
  BeginProc, EndProc: TSuProc);
var
  UosBeginProcHelper: TUosHelperProc;
  UosEndProcHelper: TUosHelperProc;
begin
  uos_CreatePlayer(PlayerIndex);
  uos_AddIntoDevOut(PlayerIndex);

  if BeginProc <> nil then
  begin
    UosBeginProcHelper := TUosHelperProc.Create;
    UosBeginProcHelper.Proc := BeginProc;
    uos_BeginProc(PlayerIndex, @UosBeginProcHelper.UosProc);
  end;
  if EndProc <> nil then
  begin
    UosEndProcHelper := TUosHelperProc.Create;
    UosEndProcHelper.Proc := EndProc;
    uos_EndProc(PlayerIndex, @UosEndProcHelper.UosProc);
  end;
  if (Pos('http:', SoundPath) = 1) or (Pos('ftp:', SoundPath) = 1) then
    uos_AddFromURL(PlayerIndex, PChar(SoundPath))
  else
  begin
    uos_AddFromFile(PlayerIndex, PChar(SoundPath));
  end;
  uos_Play(PlayerIndex);
end;

procedure TdpUOSImport.UosRecordEx(PlayerIndex: Integer; FileName: string;
  ListMic: Boolean; BeginProc, EndProc: TSuProc);
var
  UosBeginProcHelper: TUosHelperProc;
  UosEndProcHelper: TUosHelperProc;
  In1Index : integer;
begin
   uos_CreatePlayer(PlayerIndex);
  if BeginProc <> nil then
  begin
    UosBeginProcHelper := TUosHelperProc.Create;
    UosBeginProcHelper.Proc := BeginProc;
    uos_BeginProc(PlayerIndex, @UosBeginProcHelper.UosProc);
  end;
  if EndProc <> nil then
  begin
    UosEndProcHelper := TUosHelperProc.Create;
    UosEndProcHelper.Proc := EndProc;
    uos_EndProc(PlayerIndex, @UosEndProcHelper.UosProc);
  end;
  uos_AddIntoFile(PlayerIndex, Pchar(FileName));

  if ListMic then
      uos_AddIntoDevOut(PlayerIndex);

  In1Index := uos_AddFromDevIn(PlayerIndex);
  uos_AddDSPVolumeIn(PlayerIndex, In1Index, 8, 8);
  uos_SetDSPVolumeIn(PlayerIndex, In1Index, 8, 8, True); /// Set volume
  uos_Play(PlayerIndex);
end;

procedure TdpUOSImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('function uos_LoadLib: Integer', @uoslib_loadlib);
  AddMethod('procedure uos_unloadlib', @uoslib_unloadlib);
  AddMethod('procedure uos_RePlay(PlayerIndex: LongInt)', @uoslib_uos_RePlay);
  AddMethod('procedure uos_Stop(PlayerIndex: LongInt)', @uoslib_uos_Stop);
  AddMethod('procedure uos_Pause(PlayerIndex: LongInt)', @uoslib_uos_Pause);
  AddMethod('function uos_GetVersion: Integer', @uoslib_uos_GetVersion);
  AddMethod('procedure uos_Play(PlayerIndex: Integer; SonudPath: string)', @uoslib_uos_PlayFile);
  AddMethod('procedure uos_PlayEx(PlayerIndex: Integer; SoundPath: string; BeginProc, EndProc: Pointer)', @uoslib_uos_PlayFileEx);
  AddMethod('procedure uos_Record(PlayerIndex: Integer; FileName: string; ListMic: Boolean)', @uoslib_uos_Record);
  AddMethod('procedure uos_RecordEx(PlayerIndex: Integer; FileName: string; ListMic: Boolean; BeginProc, EndProc: Pointer)', @uoslib_uos_RecordEx);
end;

end.

