unit dpi_JSON;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, Variants, fpjson, jsonparser, dpUtils,
  dpi_mettyps;

type

  { TJSONFloatNum }

  TJSONFloatNum = class(TJSONFloatNumber)
  protected
    FFormat: string;
    function GetAsString: TJSONStringType; override;
    constructor Create(AValue: TJSONFloat); reintroduce;
  published
    property Format: string read FFormat write FFormat;
  end;

  { TJSONImport }

  TJSONImport = class(TClassImporter)
    function BaseJSONEnumerator_Current(Instance: Pointer): Variant;
    function BaseJSONEnumerator_MoveNext(Instance: TObject; var Params: Variant
      ): Variant;
    function IJSON_JSONTypeName(Instance: TObject; var Params: Variant): Variant;
    function IJSON_CreateJSONNull(Instance: TObject; var Params: Variant): Variant;
    function IJSON_CreateJSONBoolean(Instance: TObject; var Params: Variant): Variant;
    function IJSON_CreateJSONInteger(Instance: TObject; var Params: Variant): Variant;
    function IJSON_CreateJSONInt64(Instance: TObject; var Params: Variant): Variant;
    function IJSON_CreateJSONFloat(Instance: TObject; var Params: Variant): Variant;
    function IJSON_CreateJSONstring(Instance: TObject; var Params: Variant): Variant;
    function IJSON_CreateJSONArray(Instance: TObject; var Params: Variant): Variant;
    function IJSON_CreateJSONObject(Instance: TObject; var Params: Variant): Variant;
    function IJSON_GetJSON(Instance: TObject; var Params: Variant): Variant;
    function IJSON_GetJSONFromStream(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_Add(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_AddArray(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_AddBoolean(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_AddFloat(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_AddInt64(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_AddInteger(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_AddItem(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_AddObject(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_AddStr(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_ArraysGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_ArraysSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_BooleansGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_BooleansSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_Create(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_CreateOf(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_Delete(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_Exchange(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_Extract(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_ExtractItem(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_FloatsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_FloatsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_IndexOf(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_Insert(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_InsertArray(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_InsertBoolean(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_InsertFloat(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_InsertInt64(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_InsertInteger(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_InsertItem(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_InsertObject(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_InsertString(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_Int64sGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_Int64sSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_IntegersGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_IntegersSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_Move(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_NullsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_ObjectsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_ObjectsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_Remove(Instance: TObject; var Params: Variant): Variant;
    function JSONArray_StringsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_StringsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONArray_TypesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONBoolean_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONData_AsBooleanGet(Instance: Pointer): Variant;
    procedure JSONData_AsBooleanSet(Instance: Pointer; AValue: Variant);
    function JSONData_AsFloatGet(Instance: Pointer): Variant;
    procedure JSONData_AsFloatSet(Instance: Pointer; AValue: Variant);
    function JSONData_AsInt64Get(Instance: Pointer): Variant;
    procedure JSONData_AsInt64Set(Instance: Pointer; AValue: Variant);
    function JSONData_AsIntegerGet(Instance: Pointer): Variant;
    procedure JSONData_AsIntegerSet(Instance: Pointer; AValue: Variant);
    function JSONData_AsJSON(Instance: Pointer): Variant;
    function JSONData_AsStringGet(Instance: Pointer): Variant;
    procedure JSONData_AsStringSet(Instance: Pointer; AValue: Variant);
    function JSONData_Clone(Instance: TObject; var Params: Variant): Variant;
    function JSONData_Count(Instance: Pointer): Variant;
    function JSONData_FindPath(Instance: TObject; var Params: Variant): Variant;
    function JSONData_FormatJSON(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONData_GetEnumerator(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONData_GetPath(Instance: TObject; var Params: Variant): Variant;
    function JSONData_IsNull(Instance: Pointer): Variant;
    function JSONData_ItemsGet(Instance: TObject; var Params: Variant): Variant;
    function JSONData_ItemsSet(Instance: TObject; var Params: Variant): Variant;
    function JSONEnum_KeyGet(Instance: Pointer): Variant;
    function JSONEnum_KeyNumGet(Instance: Pointer): Variant;
    procedure JSONEnum_KeyNumSet(Instance: Pointer; AValue: Variant);
    procedure JSONEnum_KeySet(Instance: Pointer; AValue: Variant);
    function JSONEnum_ValueGet(Instance: Pointer): Variant;
    procedure JSONEnum_ValueSet(Instance: Pointer; AValue: Variant);
    function JSONFloatNumber_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONInt64Number_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONIntegerNumber_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONNull_Create(Instance: TObject; var Params: Variant): Variant;
    function JSONObject_Add(Instance: TObject; var Params: Variant): Variant;
    function JSONObject_AddArray(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_AddBoolean(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_AddData(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_AddFloat(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_AddInt64(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_AddInteger(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_AddString(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_AGet(Instance: TObject; var Params: Variant): Variant;
    function JSONObject_ArraysGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_ArraysSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_BooleansGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_BooleansSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_Create(Instance: TObject; var Params: Variant): Variant;
    function JSONObject_CreateOf(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_Delete(Instance: TObject; var Params: Variant): Variant;
    function JSONObject_DeleteIndex(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_ElementsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_ElementsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_Extract(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_ExtractIndex(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_Find(Instance: TObject; var Params: Variant): Variant;
    function JSONObject_FindOfType(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_FloatsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_FloatsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_GetArray(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_GetBoolean(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_GetFloat(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_GetInt64(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_GetInteger(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_GetObject(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_GetString(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_IndexOf(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_IndexOfName(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_Int64sGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_Int64sSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_IntegersGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_IntegersSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_NamesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_NullsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_NullsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_ObjectsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_ObjectsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_Remove(Instance: TObject; var Params: Variant): Variant;
    function JSONObject_StringsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_StringsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONObject_TypesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONParser_Create(Instance: TObject; var Params: Variant): Variant;
    function JSONParser_CreateFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function JSONParser_Parse(Instance: TObject; var Params: Variant): Variant;
    function JSONString_Create(Instance: TObject; var Params: Variant): Variant;
    function TJSONNumberType_NumberType(Instance: TObject; var Params: Variant
      ): Variant;
  private
    function JSONFloatNum_Create(Instance: TObject; var Params: Variant
      ): Variant;
  protected
  public
    JEnum: TJSONEnum;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
    procedure RegisterPublic(AType: TDpType); override;
  end;

implementation

uses jsonscanner;

{ TJSONFloatNum }

function TJSONFloatNum.GetAsString: TJSONStringType;
var
  F: TJSONFloat;
  fs: TFormatSettings;
begin
  fs := DefaultFormatSettings;
  fs.DecimalSeparator := '.';
  F := GetAsFloat;

  Result := FormatFloat(FFormat, F, fs);
end;

constructor TJSONFloatNum.Create(AValue: TJSONFloat);
begin
  inherited Create(AValue);
  FFormat := '0.0##############';
end;

{ TJSONImport }

function TJSONImport.BaseJSONEnumerator_Current(Instance: Pointer): Variant;

begin
  JEnum := TBaseJSONEnumerator(Instance).Current;
  Result := TSuPtr( @JEnum );
end;

function TJSONImport.BaseJSONEnumerator_MoveNext(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBaseJSONEnumerator(Instance).MoveNext;
end;

function TJSONImport.IJSON_JSONTypeName(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := JSONTypeName(Params[0]);
end;

function TJSONImport.IJSON_CreateJSONNull(Instance: TObject; var Params: Variant
  ): Variant;
begin
   Result := TSuPtr( CreateJSON );
end;

function TJSONImport.IJSON_CreateJSONBoolean(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( CreateJSON(Boolean(Params[0])) );
end;

function TJSONImport.IJSON_CreateJSONInteger(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( CreateJSON(Integer(Params[0])) );
end;

function TJSONImport.IJSON_CreateJSONInt64(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( CreateJSON(Int64(Params[0])) );
end;

function TJSONImport.IJSON_CreateJSONFloat(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( CreateJSON(TJSONFloat(Params[0])) );
end;

function TJSONImport.IJSON_CreateJSONstring(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( CreateJSON(TJSONStringType(Params[0])) );
end;

function TJSONImport.IJSON_CreateJSONArray(Instance: TObject; var Params: Variant
  ): Variant;
var
  R: TConstArray;
begin
  VariantToVarRec(Params, R);
  try
    Result := TSuPtr( CreateJSONArray(R) );
  finally
    ClearVarRec(R);
  end;

end;

function TJSONImport.IJSON_CreateJSONObject(Instance: TObject;
  var Params: Variant): Variant;
var
  R: TConstArray;
begin
  VariantToVarRec(Params, R);
  try
    Result := TSuPtr( CreateJSONObject(R) );
  finally
    ClearVarRec(R);
  end;
end;

function TJSONImport.IJSON_GetJSON(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( GetJSON(TJSONStringType(Params[0])) );
end;

function TJSONImport.IJSON_GetJSONFromStream(Instance: TObject;
  var Params: Variant): Variant;
var
  S: TStream;
  UseUTF: Boolean;
begin
  S := TStream( TSuPtr( Params[0] ) );
  UseUTF:= Params[1];
  Result := TSuPtr( GetJSON(S, UseUTF) );
end;

function TJSONImport.JSONArray_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).Add;
end;

function TJSONImport.JSONArray_AddArray(Instance: TObject; var Params: Variant
  ): Variant;
var
  AnArray: TJSONArray;
begin
  AnArray := TJSONArray( TSuPtr(Params[0]) );

  Result := TJSONArray(Instance).Add(AnArray);
end;

function TJSONImport.JSONArray_AddBoolean(Instance: TObject; var Params: Variant
  ): Variant;
var
  B: Boolean;
begin
  B := Params[0];
  Result := TJSONArray(Instance).Add(B);
end;

function TJSONImport.JSONArray_AddFloat(Instance: TObject; var Params: Variant
  ): Variant;
var
  F: TJSONFloat;
begin
  F := Params[0];
  Result := TJSONArray(Instance).Add(F);
end;

function TJSONImport.JSONArray_AddInt64(Instance: TObject; var Params: Variant
  ): Variant;
var
  I: Int64;
begin
  I := Params[0];
  Result := TJSONArray(Instance).Add(I);
end;

function TJSONImport.JSONArray_AddInteger(Instance: TObject; var Params: Variant
  ): Variant;
var
  I: Integer;
begin
  I := Params[0];
  Result := TJSONArray(Instance).Add(I);
end;

function TJSONImport.JSONArray_AddItem(Instance: TObject; var Params: Variant
  ): Variant;
var
  Item: TJSONData;
begin
  Item := TJSONData( TSuPtr(Params[0]) );
  Result := TJSONArray(Instance).Add(Item);
end;

function TJSONImport.JSONArray_AddObject(Instance: TObject; var Params: Variant
  ): Variant;
var
  AnObject: TJSONObject;
begin
  AnObject := TJSONObject( TSuPtr(Params[0]) );
  Result := TJSONArray(Instance).Add(AnObject);
end;

function TJSONImport.JSONArray_AddStr(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TJSONArray(Instance).Add(S);
end;

function TJSONImport.JSONArray_ArraysGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONArray(Instance).Arrays[Params[0]] );
end;

function TJSONImport.JSONArray_ArraysSet(Instance: TObject; var Params: Variant
  ): Variant;
var
  AnArray: TJSONArray;
begin
  AnArray := TJSONArray( TSuPtr(Params[1]) );
  TJSONArray(Instance).Arrays[Params[0]] := AnArray;
end;

function TJSONImport.JSONArray_BooleansGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).Booleans[Params[0]];
end;

function TJSONImport.JSONArray_BooleansSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Booleans[Params[0]] := Params[1];
end;

function TJSONImport.JSONArray_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONArray.Create );
end;

function TJSONImport.JSONArray_CreateOf(Instance: TObject; var Params: Variant
  ): Variant;
var
  R: TConstArray;
  L: Integer;
  V: Variant;
begin
  V := Params[0];
  L := VarArrayHighBound(V, 1);
  VariantToVarRec(V, R);
  try
    Result := TSuPtr( TJSONArray.Create(R) );
  finally
    ClearVarRec(R);
  end;
end;

function TJSONImport.JSONArray_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Delete(Params[0]);
end;

function TJSONImport.JSONArray_Exchange(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Exchange(Params[0], Params[1]);
end;

function TJSONImport.JSONArray_Extract(Instance: TObject; var Params: Variant
  ): Variant;
var
  I: Integer;
begin
  I := Params[0];
  Result := TSuPtr( TJSONArray(Instance).Extract(I) );
end;

function TJSONImport.JSONArray_ExtractItem(Instance: TObject; var Params: Variant
  ): Variant;
var
  Item: TJSONData;
begin
  Item := TJSONData( TSuPtr(Params[0]) );
  Result := TSuPtr( TJSONArray(Instance).Extract(Item) );
end;

function TJSONImport.JSONArray_FloatsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).Floats[Params[0]];
end;

function TJSONImport.JSONArray_FloatsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Floats[Params[0]] := Params[1];
end;

function TJSONImport.JSONArray_IndexOf(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).IndexOf( TJSONData( TSuPtr(Params[0]) ) );
end;

function TJSONImport.JSONArray_Insert(Instance: TObject; var Params: Variant
  ): Variant;
var
  I: Integer;
begin
  I := Params[0];
  TJSONArray(Instance).Insert(I);
end;

function TJSONImport.JSONArray_InsertArray(Instance: TObject; var Params: Variant
  ): Variant;
var
  Index: Integer;
  AnArray: TJSONArray;
begin
  Index := Params[0];
  AnArray := TJSONArray( TSuPtr(Params[0]) );
  TJSONArray(Instance).Insert(Index, AnArray);
end;

function TJSONImport.JSONArray_InsertBoolean(Instance: TObject;
  var Params: Variant): Variant;
var
  Index: Integer;
  B: Boolean;
begin
  Index := Params[0];
  B := Params[1];
  TJSONArray(Instance).Insert(Index, B);
end;

function TJSONImport.JSONArray_InsertFloat(Instance: TObject; var Params: Variant
  ): Variant;
var
  Index: Integer;
  F: TJSONFloat;
begin
  Index := Params[0];
  F := Params[1];
  TJSONArray(Instance).Insert(Index, F);
end;

function TJSONImport.JSONArray_InsertInt64(Instance: TObject; var Params: Variant
  ): Variant;
var
  Index: Integer;
  I: Int64;
begin
  Index:= Params[0];
  I := Params[1];
  TJSONArray(Instance).Insert(Index, I);
end;

function TJSONImport.JSONArray_InsertInteger(Instance: TObject;
  var Params: Variant): Variant;
var
  I, AValeu: Integer;

begin
  I := Params[0];
  AValeu := Params[1];
  TJSONArray(Instance).Insert(I, AValeu);
end;

function TJSONImport.JSONArray_InsertItem(Instance: TObject; var Params: Variant
  ): Variant;
var
  I: Integer;
  Item: TJSONData;
begin
  I := Params[0];
  Item := TJSONData( TSuPtr(Params[0]) );
  TJSONArray(Instance).Insert(I, Item);
end;

function TJSONImport.JSONArray_InsertObject(Instance: TObject;
  var Params: Variant): Variant;
var
  Index: Integer;
  AnObject: TJSONObject;
begin
  Index := Params[0];
  AnObject := TJSONObject(TSuPtr(Params[1]));
  TJSONArray(Instance).Insert(Index, AnObject);
end;

function TJSONImport.JSONArray_InsertString(Instance: TObject;
  var Params: Variant): Variant;
var
  Index: Integer;
  S: string;
begin
  Index := Params[0];
  S := Params[1];
  TJSONArray(Instance).Insert(Index, S);
end;

function TJSONImport.JSONArray_Int64sGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).Int64s[Params[0]];
end;

function TJSONImport.JSONArray_Int64sSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Int64s[Params[0]] := Params[1];
end;

function TJSONImport.JSONArray_IntegersGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).Integers[Params[0]];
end;

function TJSONImport.JSONArray_IntegersSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Integers[Params[0]] := Params[1];
end;

function TJSONImport.JSONArray_Move(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Move(Params[0], Params[1]);
end;

function TJSONImport.JSONArray_NullsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).Nulls[Params[0]];
end;

function TJSONImport.JSONArray_ObjectsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONArray(Instance).Objects[Params[0]] );
end;

function TJSONImport.JSONArray_ObjectsSet(Instance: TObject; var Params: Variant
  ): Variant;
var
  O: TJSONObject;
begin
  O := TJSONObject( TSuPtr(Params[1]) );
  TJSONArray(Instance).Objects[Params[0]] := O;
end;

function TJSONImport.JSONArray_Remove(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Remove( TJSONData(TSuPtr(Params[0])) );
end;

function TJSONImport.JSONArray_StringsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).Strings[Params[0]];
end;

function TJSONImport.JSONArray_StringsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONArray(Instance).Strings[Params[0]] := Params[1];
end;

function TJSONImport.JSONArray_TypesGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONArray(Instance).Types[Params[0]];
end;

function TJSONImport.JSONBoolean_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONBoolean.Create(Params[0]) );
end;

function TJSONImport.JSONData_AsBooleanGet(Instance: Pointer): Variant;
begin
  Result := TJSONData(Instance).AsBoolean;
end;

procedure TJSONImport.JSONData_AsBooleanSet(Instance: Pointer; AValue: Variant);
begin
  TJSONData(Instance).AsBoolean := AValue;
end;

function TJSONImport.JSONData_AsFloatGet(Instance: Pointer): Variant;
begin
  Result := TJSONData(Instance).AsFloat;
end;

procedure TJSONImport.JSONData_AsFloatSet(Instance: Pointer; AValue: Variant);
begin
  TJSONData(Instance).AsFloat := AValue;
end;

function TJSONImport.JSONData_AsInt64Get(Instance: Pointer): Variant;
begin
  Result := TJSONData(Instance).AsInt64;
end;

procedure TJSONImport.JSONData_AsInt64Set(Instance: Pointer; AValue: Variant);
begin
  TJSONData(Instance).AsInt64:= AValue;
end;

function TJSONImport.JSONData_AsIntegerGet(Instance: Pointer): Variant;
begin
  Result := TJSONData(Instance).AsInteger;
end;

procedure TJSONImport.JSONData_AsIntegerSet(Instance: Pointer; AValue: Variant);
begin
  TJSONData(Instance).AsInteger:= AValue;
end;

function TJSONImport.JSONData_AsJSON(Instance: Pointer): Variant;
begin
  Result := TJSONData(Instance).AsJSON;
end;

function TJSONImport.JSONData_AsStringGet(Instance: Pointer): Variant;
begin
  Result := TJSONData(Instance).AsString;
end;

procedure TJSONImport.JSONData_AsStringSet(Instance: Pointer; AValue: Variant);
begin
  TJSONData(Instance).AsString:= AValue;
end;

function TJSONImport.JSONData_Clone(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONData(Instance).Clone );
end;

function TJSONImport.JSONData_Count(Instance: Pointer): Variant;
begin
  Result := TJSONData(Instance).Count;
end;

function TJSONImport.JSONData_FindPath(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: TJSONStringType;
begin
  S := Params[0];
  Result := TSuPtr( TJSONData(Instance).FindPath(S) );
end;

type
  PFormatOptions = ^TFormatOptions;
  PJSONOptions = ^TJSONOptions;

function TJSONImport.JSONData_FormatJSON(Instance: TObject; var Params: Variant
  ): Variant;
var
  P: PFormatOptions;
begin
  P := PFormatOptions( TSuPtr( Params[0] ) );
  Result := TJSONData(Instance).FormatJSON(P^, Params[1]);
end;

function TJSONImport.JSONData_GetEnumerator(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TJSONData(Instance).GetEnumerator );
end;

function TJSONImport.JSONData_GetPath(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: TJSONStringType;
begin
  S := Params[0];
  Result := TSuPtr( TJSONData(Instance).GetPath(S) );
end;

function TJSONImport.JSONData_IsNull(Instance: Pointer): Variant;
begin
  Result := TJSONData(Instance).IsNull;
end;

function TJSONImport.JSONData_ItemsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONData(Instance).Items[Params[0]] );
end;

function TJSONImport.JSONData_ItemsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONData(Instance).Items[Params[0]] := TJSONData( TSuPtr( Params[1] ) );
end;

type
  PJSONEnum = ^TJSONEnum;

function TJSONImport.JSONEnum_KeyGet(Instance: Pointer): Variant;
begin
  Result := PJSONEnum(Instance)^.Key;
end;

function TJSONImport.JSONEnum_KeyNumGet(Instance: Pointer): Variant;
begin
  Result := PJSONEnum(Instance)^.KeyNum;
end;

procedure TJSONImport.JSONEnum_KeyNumSet(Instance: Pointer; AValue: Variant);
begin
  PJSONEnum(Instance)^.KeyNum := AValue;
end;

procedure TJSONImport.JSONEnum_KeySet(Instance: Pointer; AValue: Variant);
begin
  PJSONEnum(Instance)^.Key := AValue;
end;

function TJSONImport.JSONEnum_ValueGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( PJSONEnum(Instance)^.Value );
end;

procedure TJSONImport.JSONEnum_ValueSet(Instance: Pointer; AValue: Variant);
begin
  PJSONEnum(Instance)^.Value := TJSONData( TSuPtr(AValue) );
end;

function TJSONImport.JSONFloatNumber_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TJSONFloatNumber.Create(Params[0]) );
end;

function TJSONImport.JSONInt64Number_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TJSONInt64Number.Create(Params[0]) );
end;

function TJSONImport.JSONIntegerNumber_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TJSONIntegerNumber.Create(Params[0]) );
end;

function TJSONImport.JSONNull_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONNull.Create );
end;

function TJSONImport.JSONObject_Add(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: TJSONStringType;
begin
  AName := Params[0];
  Result := TJSONObject(Instance).Add(AName);
end;

function TJSONImport.JSONObject_AddArray(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: TJSONStringType;
  AValue: TJSONArray;
begin
  AName := Params[0];
  AValue := TJSONArray( TSuPtr(Params[1]) );
  Result := TJSONObject(Instance).Add(AName, AValue);
end;

function TJSONImport.JSONObject_AddBoolean(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: TJSONStringType;
  AValue: Boolean;
begin
  AName := Params[0];
  AValue := Params[1];
  Result := TJSONObject(Instance).Add(AName, AValue);
end;

function TJSONImport.JSONObject_AddData(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: TJSONStringType;
  AValue: TJSONData;
begin
  AName := Params[0];
  AValue := TJSONData(TSuPtr(Params[1]));
  Result := TJSONObject(Instance).Add(AName, AValue);
end;

function TJSONImport.JSONObject_AddFloat(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: TJSONStringType;
  AValue: TJSONFloat;
begin
  AName := Params[0];
  AValue := Params[1];
  Result := TJSONObject(Instance).Add(AName, AValue);
end;

function TJSONImport.JSONObject_AddInt64(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: TJSONStringType;
  AValue: Int64;
begin
  AName := Params[0];
  AValue := Params[1];
  Result := TJSONObject(Instance).Add(AName, AValue);
end;

function TJSONImport.JSONObject_AddInteger(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: TJSONStringType;
  AValue: Integer;
begin
  AName := Params[0];
  AValue := Params[1];
  Result := TJSONObject(Instance).Add(AName, AValue);
end;

function TJSONImport.JSONObject_AddString(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName, AValue: TJSONStringType;
begin
  AName := Params[0];
  AValue := Params[1];
  Result := TJSONObject(Instance).Add(AName, AValue);
end;

function TJSONImport.JSONObject_AGet(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
begin
  AName:= Params[0];
  Result := TJSONObject(Instance).Get(AName);
end;

function TJSONImport.JSONObject_ArraysGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONObject(Instance).Arrays[Params[0]] );
end;

function TJSONImport.JSONObject_ArraysSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONObject(Instance).Arrays[Params[0]] := TJSONArray( TSuPtr(Params[1]) );
end;

function TJSONImport.JSONObject_BooleansGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TJSONObject(Instance).Booleans[Params[0]];
end;

function TJSONImport.JSONObject_BooleansSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TJSONObject(Instance).Booleans[Params[0]] := Params[1];
end;

function TJSONImport.JSONObject_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONObject.Create );
end;

function TJSONImport.JSONObject_CreateOf(Instance: TObject; var Params: Variant
  ): Variant;
var
  R: TConstArray;
begin
  VariantToVarRec(Params, R);
  try
    Result := TSuPtr( TJSONObject.Create(R) );
  finally
    ClearVarRec(R);
  end;
end;

function TJSONImport.JSONObject_Delete(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
begin
  AName:= Params[0];
  TJSONObject(Instance).Delete(AName);
end;

function TJSONImport.JSONObject_DeleteIndex(Instance: TObject;
  var Params: Variant): Variant;
var
  AIndex: Integer;
begin
  AIndex:= Params[0];
  TJSONObject(Instance).Delete(AIndex);
end;

function TJSONImport.JSONObject_ElementsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TJSONObject(Instance).Elements[Params[0]] );
end;

function TJSONImport.JSONObject_ElementsSet(Instance: TObject;
  var Params: Variant): Variant;
var
  D: TJSONData;
begin
  D := TJSONData( TSuPtr(Params[1]) );
  TJSONObject(Instance).Elements[Params[0]] := D;
end;

function TJSONImport.JSONObject_Extract(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
begin
  AName:= Params[0];
  Result := TSuPtr( TJSONObject(Instance).Extract(AName) );
end;

function TJSONImport.JSONObject_ExtractIndex(Instance: TObject;
  var Params: Variant): Variant;
var
  AIndex: Integer;
begin
  AIndex:= Params[0];
  Result := TSuPtr( TJSONObject(Instance).Extract(AIndex) );
end;

function TJSONImport.JSONObject_Find(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
begin
  AName:= Params[0];
  Result := TSuPtr( TJSONObject(Instance).Find(AName) );
end;

function TJSONImport.JSONObject_FindOfType(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  AType: TJSONtype;
begin
  AName := Params[0];
  AType := Params[1];
  Result := TSuPtr( TJSONObject(Instance).Find(AName, AType) );
end;

function TJSONImport.JSONObject_FloatsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONObject(Instance).Floats[Params[0]];
end;

function TJSONImport.JSONObject_FloatsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONObject(Instance).Floats[Params[0]] := Params[1];
end;

function TJSONImport.JSONObject_GetArray(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADefautl: TJSONArray;
begin
  AName := Params[0];
  ADefautl := TJSONArray( TSuPtr(Params[1]) );
  Result := TSuPtr( TJSONObject(Instance).Get(AName, ADefautl) );
end;

function TJSONImport.JSONObject_GetBoolean(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADefautl: Boolean;
begin
  AName := Params[0];
  ADefautl := Params[1];
  Result := TJSONObject(Instance).Get(AName, ADefautl);
end;

function TJSONImport.JSONObject_GetFloat(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADef: TJSONFloat;
begin
  AName := Params[0];
  ADef := Params[1];
  Result := TJSONObject(Instance).Get(AName, ADef);
end;

function TJSONImport.JSONObject_GetInt64(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADefautl: Int64;
begin
  AName := Params[0];
  ADefautl := Params[1];
  Result := TJSONObject(Instance).Get(AName, ADefautl);
end;

function TJSONImport.JSONObject_GetInteger(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADefautl: Integer;
begin
  AName := Params[0];
  ADefautl := Params[1];
  Result := TJSONObject(Instance).Get(AName, ADefautl);
end;

function TJSONImport.JSONObject_GetObject(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADefautl: TJSONObject;
begin
  AName := Params[0];
  ADefautl := TJSONObject( TSuPtr(Params[1]) );
  Result := TSuPtr( TJSONObject(Instance).Get(AName, ADefautl) );
end;

function TJSONImport.JSONObject_GetString(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADefautl: TJSONStringType;
begin
  AName := Params[0];
  ADefautl := Params[1];
  Result := TJSONObject(Instance).Get(AName, ADefautl);
end;

function TJSONImport.JSONObject_IndexOf(Instance: TObject; var Params: Variant
  ): Variant;
var
  Item: TJSONData;
begin
  Item := TJSONData(TSuPtr(Params[0]));
  Result := TJSONObject(Instance).IndexOf(Item);
end;

function TJSONImport.JSONObject_IndexOfName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TJSONObject(Instance).IndexOfName(Params[0], Params[1]);
end;

function TJSONImport.JSONObject_Int64sGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONObject(Instance).Int64s[Params[0]];
end;

function TJSONImport.JSONObject_Int64sSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONObject(Instance).Int64s[Params[0]] := Params[1];
end;

function TJSONImport.JSONObject_IntegersGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TJSONObject(Instance).Integers[Params[0]];
end;

function TJSONImport.JSONObject_IntegersSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TJSONObject(Instance).Integers[Params[0]] := Params[1];
end;

function TJSONImport.JSONObject_NamesGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONObject(Instance).Names[Params[0]];
end;

function TJSONImport.JSONObject_NullsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONObject(Instance).Nulls[Params[0]];
end;

function TJSONImport.JSONObject_NullsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONObject(Instance).Nulls[Params[0]] := Params[1];
end;

function TJSONImport.JSONObject_ObjectsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONObject(Instance).Objects[Params[0]] );
end;

function TJSONImport.JSONObject_ObjectsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONObject(Instance).Objects[Params[0]] := TJSONObject( TSuPtr(Params[1]) );
end;

function TJSONImport.JSONObject_Remove(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONObject(Instance).Remove( TJSONData( TSuPtr(Params[0]) ) );
end;

function TJSONImport.JSONObject_StringsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONObject(Instance).Strings[Params[0]];
end;

function TJSONImport.JSONObject_StringsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TJSONObject(Instance).Strings[Params[0]] := Params[1];
end;

function TJSONImport.JSONObject_TypesGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TJSONObject(Instance).Types[Params[0]];
end;

function TJSONImport.JSONParser_Create(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
  P: PJSONOptions;
begin
  S := Params[0];
  P := PJSONOptions( TSuPtr(Params[1]) );
  Result := TSuPtr( TJSONParser.Create(S, P^));
end;

function TJSONImport.JSONParser_CreateFromStream(Instance: TObject;
  var Params: Variant): Variant;
var
  S: TStream;
  P: PJSONOptions;
begin
  S := TStream( TSuPtr(Params[0]) );
  P := PJSONOptions( TSuPtr( Params[1] ) );
  Result := TSuPtr( TJSONParser.create(S, P^) );
end;

function TJSONImport.JSONParser_Parse(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TJSONParser(Instance).Parse);
end;

function TJSONImport.JSONString_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TJSONString.Create(Params[0]) );
end;

function TJSONImport.TJSONNumberType_NumberType(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TJSONNumber(Instance).NumberType;
end;

function TJSONImport.JSONFloatNum_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TJSONFloatNum.Create(Params[0]));
end;

procedure TJSONImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TJSONtype));
  AddType(TypeInfo(TJSONInstanceType));
  AddType(TypeInfo(TFormatOption));
  AddType(TypeInfo(TFormatOptions));
  AddType(TypeInfo(TJSONNumberType));
  AddType(TypeInfo(TJSONOption));
  AddType(TypeInfo(TJSONOptions));
end;

procedure TJSONImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddRecord('TJSONEnum', SizeOf(TJSONEnum)).ClassImporter := Self;
  AddClass(TJSONParser).ClassImporter := Self;
  AddClass(TJSONData).ClassImporter := Self;
  AddClass(TJSONNumber).ClassImporter := Self;
  AddClass(TJSONFloatNumber).ClassImporter := Self;
  AddClass(TJSONFloatNum).ClassImporter := Self;
  AddClass(TJSONIntegerNumber).ClassImporter := Self;
  AddClass(TJSONInt64Number).ClassImporter := Self;
  AddClass(TJSONString).ClassImporter := Self;
  AddClass(TJSONBoolean).ClassImporter := Self;
  AddClass(TJSONNull);//.ClassImporter := Self;
  AddClass(TJSONArray).ClassImporter := Self;
  AddClass(TJSONObject).ClassImporter := Self;
  AddClass(TBaseJSONEnumerator).ClassImporter := Self;
end;

procedure TJSONImport.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('TJSONFloat', btFloat);
  AddType('TJSONStringType', btString);
  AddType('TJSONCharType', btChar);
end;

procedure TJSONImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('function JSONTypeName(JSONType: TJSONType): String', @IJSON_JSONTypeName);
  AddMethod('function CreateJSONNull: TJSONNull', @IJSON_CreateJSONNull);
  AddMethod('function CreateJSONBoolean(Data: Boolean): TJSONBoolean', @IJSON_CreateJSONBoolean);
  AddMethod('function CreateJSONInteger(Data: Integer): TJSONIntegerNumber', @IJSON_CreateJSONInteger);
  AddMethod('Function CreateJSONInt64(Data: Int64): TJSONInt64Number', @IJSON_CreateJSONInt64);
  AddMethod('function CreateJSONFloat(Data: TJSONFloat): TJSONFloatNumber', @IJSON_CreateJSONFloat);
  AddMethod('function CreateJSONstring(Data: TJSONStringType): TJSONString;', @IJSON_CreateJSONstring);
  AddMethod('function CreateJSONArray(Data: Array of const): TJSONArray', @IJSON_CreateJSONArray);
  AddMethod('function CreateJSONObject(Data: Array of const): TJSONObject', @IJSON_CreateJSONObject);
  AddMethod('function GetJSON(Const JSON: TJSONStringType; Const UseUTF8 : Boolean = True): TJSONData', @IJSON_GetJSON);
  AddMethod('function GetJSONFromStream(Const JSON: TStream; Const UseUTF8 : Boolean = True): TJSONData', @IJSON_GetJSONFromStream);
end;

procedure TJSONImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TJSONParser then
  begin
    AType.AddMethod('constructor Create(Source: string; Options: TJSONOptions = [joUTF8])', @JSONParser_Create);
    AType.AddMethod('constructor CreateFromStream(Source : TStream; Options: TJSONOptions = [joUTF8])', @JSONParser_CreateFromStream);
    AType.AddMethod('function Parse: TJSONData', @JSONParser_Parse);
  end
  else
  if AType.ValueClassType = TJSONData then
  begin
    AType.AddMethod('function GetEnumerator: TBaseJSONEnumerator', @JSONData_GetEnumerator);
    AType.AddMethod('function FindPath(Const APath: TJSONStringType): TJSONdata', @JSONData_FindPath);
    AType.AddMethod('function GetPath(Const APath: TJSONStringType): TJSONdata', @JSONData_GetPath);
    AType.AddMethod('function Clone: TJSONData', @JSONData_Clone);
    AType.AddMethod('function FormatJSON(Options: TFormatOptions = []; Indentsize: Integer = 2): TJSONStringType', @JSONData_FormatJSON);
    AType.AddProp('Count', 'Integer', @JSONData_Count);
    AType.AddProp('AsString', 'TJSONStringType', @JSONData_AsStringGet, @JSONData_AsStringSet);
    AType.AddProp('AsFloat', 'TJSONFloat', @JSONData_AsFloatGet, @JSONData_AsFloatSet);
    AType.AddProp('AsInteger', 'Integer', @JSONData_AsIntegerGet, @JSONData_AsIntegerSet);
    AType.AddProp('AsInt64', 'Int64', @JSONData_AsInt64Get, @JSONData_AsInt64Set);
    AType.AddProp('AsBoolean', 'Boolean', @JSONData_AsBooleanGet, @JSONData_AsBooleanSet);
    AType.AddProp('IsNull', 'Boolean', @JSONData_IsNull);
    AType.AddProp('AsJSON', 'TJSONStringType', @JSONData_AsJSON);
    AType.AddIndexedProp('Items','TJSONData','Integer', @JSONData_ItemsGet, @JSONData_ItemsSet);
  end
  else
  if AType.ValueClassType = TJSONNumber then
  begin
    AType.AddMethod('function NumberType: TJSONNumberType', @TJSONNumberType_NumberType);
  end
  else
  if AType.ValueClassType = TJSONFloatNumber then
  begin
    AType.AddMethod('constructor Create(AValue: TJSONFloat)', @JSONFloatNumber_Create);
  end
  else
  if AType.ValueClassType = TJSONFloatNum then
  begin
    AType.AddMethod('constructor Create(AValue: TJSONFloat)', @JSONFloatNum_Create);
  end
  else
  if AType.ValueClassType = TJSONIntegerNumber then
  begin
    AType.AddMethod('constructor Create(AValue : Integer)', @JSONIntegerNumber_Create);
  end
  else
  if AType.ValueClassType = TJSONInt64Number then
  begin
    AType.AddMethod('constructor Create(AValue : Int64)', @JSONInt64Number_Create);
  end
  else
  if AType.ValueClassType = TJSONString then
  begin
    AType.AddMethod('constructor Create(const AValue : TJSONStringType)', @JSONString_Create);
  end
  else
  if AType.ValueClassType = TJSONBoolean then
  begin
    AType.AddMethod('constructor Create(AValue: Boolean)', @JSONBoolean_Create);
  end
  else
  if AType.ValueClassType = TJSONNull then
  begin
    AType.AddMethod('constructor Create', @JSONNull_Create);
  end
  else
  if AType.ValueClassType = TJSONArray then
  begin
    AType.AddMethod('constructor Create', @JSONArray_Create);
    AType.AddMethod('constructor CreateOf(const Elements: Array of Const)', @JSONArray_CreateOf);
    AType.AddMethod('function IndexOf(obj: TJSONData): Integer', @JSONArray_IndexOf);
    AType.AddMethod('function AddItem(Item: TJSONData): Integer', @JSONArray_AddItem);
    AType.AddMethod('function AddInteger(I: Integer): Integer', @JSONArray_AddInteger);
    AType.AddMethod('function AddInt64(I: Int64): Int64', @JSONArray_AddInt64);
    AType.AddMethod('function AddStr(const S : String): Integer', @JSONArray_AddStr);
    AType.AddMethod('function Add: Integer', @JSONArray_Add);
    AType.AddMethod('function AddFloat(F: TJSONFloat): Integer', @JSONArray_AddFloat);
    AType.AddMethod('function AddBoolean(B: Boolean): Integer', @JSONArray_AddBoolean);
    AType.AddMethod('function AddArray(AnArray : TJSONArray): Integer', @JSONArray_AddArray);
    AType.AddMethod('function AddObject(AnObject: TJSONObject): Integer', @JSONArray_AddObject);
    AType.AddMethod('procedure Delete(Index : Integer)', @JSONArray_Delete);
    AType.AddMethod('procedure Exchange(Index1, Index2: Integer)', @JSONArray_Exchange);
    AType.AddMethod('function Extract(Index : Integer): TJSONData', @JSONArray_Extract);
    AType.AddMethod('function ExtractItem(Item: TJSONData): TJSONData', @JSONArray_ExtractItem);
    AType.AddMethod('procedure Insert(Index: Integer)', @JSONArray_Insert);
    AType.AddMethod('procedure InsertItem(Index: Integer; Item : TJSONData)', @JSONArray_InsertItem);
    AType.AddMethod('procedure InsertInteger(Index: Integer; I: Integer)', @JSONArray_InsertInteger);
    AType.AddMethod('procedure InsertInt64(Index: Integer; I: Int64)', @JSONArray_InsertInt64);
    AType.AddMethod('procedure InsertString(Index: Integer; const S: String)', @JSONArray_InsertString);
    AType.AddMethod('procedure InsertFloat(Index: Integer; F: TJSONFloat)', @JSONArray_InsertFloat);
    AType.AddMethod('procedure InsertBoolean(Index: Integer; B : Boolean)', @JSONArray_InsertBoolean);
    AType.AddMethod('procedure InsertArray(Index: Integer; AnArray: TJSONArray)', @JSONArray_InsertArray);
    AType.AddMethod('procedure InsertObject(Index: Integer; AnObject: TJSONObject)', @JSONArray_InsertObject);
    AType.AddMethod('procedure Move(CurIndex, NewIndex: Integer)', @JSONArray_Move);
    AType.AddMethod('Procedure Remove(Item : TJSONData)', @JSONArray_Remove);
    AType.AddIndexedProp('Types', 'TJSONType', 'Integer', @JSONArray_TypesGet);
    AType.AddIndexedProp('Nulls', 'Boolean', 'Integer', @JSONArray_NullsGet);
    AType.AddIndexedProp('Integers', 'Integer', 'Integer', @JSONArray_IntegersGet, @JSONArray_IntegersSet);
    AType.AddIndexedProp('Int64s', 'Int64', 'Integer', @JSONArray_Int64sGet, @JSONArray_Int64sSet);
    AType.AddIndexedProp('Strings', 'TJSONStringType', 'Integer', @JSONArray_StringsGet, @JSONArray_StringsSet);
    AType.AddIndexedProp('Floats', 'TJSONFloat', 'Integer', @JSONArray_FloatsGet, @JSONArray_FloatsSet);
    AType.AddIndexedProp('Booleans', 'Boolean', 'Integer', @JSONArray_BooleansGet, @JSONArray_BooleansSet);
    AType.AddIndexedProp('Arrays', 'TJSONArray', 'Integer', @JSONArray_ArraysGet, @JSONArray_ArraysSet);
    AType.AddIndexedProp('Objects', 'TJSONObject', 'Integer', @JSONArray_ObjectsGet, @JSONArray_ObjectsSet);
  end
  else
  if AType.ValueClassType = TJSONObject then
  begin
    AType.AddMethod('constructor Create', @JSONObject_Create);
    AType.AddMethod('constructor CreateOf(const Elements : Array of Const)', @JSONObject_CreateOf);
    AType.AddMethod('function IndexOf(Item: TJSONData): Integer', @JSONObject_IndexOf);
    AType.AddMethod('function IndexOfName(const AName: TJSONStringType; CaseInsensitive: Boolean = False): Integer', @JSONObject_IndexOfName);
    AType.AddMethod('function Find(Const AName: String): TJSONData', @JSONObject_Find);
    AType.AddMethod('function FindOfType(Const AName: String; AType: TJSONType): TJSONData', @JSONObject_FindOfType);
    AType.AddMethod('function Get(Const AName: String): Variant', @JSONObject_AGet);
    AType.AddMethod('function GetFloat(Const AName: String; ADefault: TJSONFloat): TJSONFloat', @JSONObject_GetFloat);
    AType.AddMethod('function GetInteger(Const AName: String; ADefault: Integer): Integer', @JSONObject_GetInteger);
    AType.AddMethod('function GetInt64(Const AName: String; ADefault: Int64): Int64', @JSONObject_GetInt64);
    AType.AddMethod('function GetBoolean(Const AName: String; ADefault: Boolean): Boolean', @JSONObject_GetBoolean);
    AType.AddMethod('function GetString(Const AName: String; ADefault: TJSONStringType): TJSONStringTYpe', @JSONObject_GetString);
    AType.AddMethod('function GetArray(Const AName: String; ADefault: TJSONArray): TJSONArray', @JSONObject_GetArray);
    AType.AddMethod('function GetObject(Const AName: String; ADefault: TJSONObject): TJSONObject', @JSONObject_GetObject);
    AType.AddMethod('function Add(const AName: TJSONStringType): Integer', @JSONObject_Add);
    AType.AddMethod('function AddData(const AName: TJSONStringType; AValue: TJSONData): Integer', @JSONObject_AddData);
    AType.AddMethod('function AddBoolean(const AName: TJSONStringType; AValue: Boolean): Integer', @JSONObject_AddBoolean);
    AType.AddMethod('function AddFloat(const AName: TJSONStringType; AValue: TJSONFloat): Integer', @JSONObject_AddFloat);
    AType.AddMethod('function AddString(const AName, AValue: TJSONStringType): Integer', @JSONObject_AddString);
    AType.AddMethod('function AddInteger(const AName: TJSONStringType; Avalue: Integer): Integer', @JSONObject_AddInteger);
    AType.AddMethod('function AddInt64(const AName: TJSONStringType; Avalue: Int64): Integer', @JSONObject_AddInt64);
    AType.AddMethod('function AddArray(const AName: TJSONStringType; AValue : TJSONArray): Integer', @JSONObject_AddArray);
    AType.AddMethod('procedure Delete(Const AName: string)', @JSONObject_Delete);
    AType.AddMethod('procedure DeleteIndex(Index: Integer)', @JSONObject_DeleteIndex);
    AType.AddMethod('procedure Remove(Item: TJSONData)', @JSONObject_Remove);
    AType.AddMethod('function Extract(Const AName : string): TJSONData', @JSONObject_Extract);
    AType.AddMethod('function ExtractIndex(Index: Integer): TJSONData', @JSONObject_ExtractIndex);

    AType.AddIndexedProp('Names', 'TJSONStringType', 'Integer', @JSONObject_NamesGet);
    AType.AddIndexedProp('Elements', 'TJSONData', 'string', @JSONObject_ElementsGet, @JSONObject_ElementsSet);
    AType.AddIndexedProp('Types', 'TJSONType', 'string', @JSONObject_TypesGet);
    AType.AddIndexedProp('Nulls', 'Boolean', 'string', @JSONObject_NullsGet, @JSONObject_NullsSet);
    AType.AddIndexedProp('Floats', 'TJSONFloat', 'string', @JSONObject_FloatsGet, @JSONObject_FloatsSet);
    AType.AddIndexedProp('Integers', 'Integer', 'string', @JSONObject_IntegersGet, @JSONObject_IntegersSet);
    AType.AddIndexedProp('Int64s', 'Int64', 'string', @JSONObject_Int64sGet, @JSONObject_Int64sSet);
    AType.AddIndexedProp('Strings', 'string', 'string', @JSONObject_StringsGet, @JSONObject_StringsSet);
    AType.AddIndexedProp('Booleans', 'Boolean', 'string', @JSONObject_BooleansGet, @JSONObject_BooleansSet);
    AType.AddIndexedProp('Arrays', 'TJSONArray', 'string', @JSONObject_ArraysGet, @JSONObject_ArraysSet);
    AType.AddIndexedProp('Objects', 'TJSONObject', 'string', @JSONObject_ObjectsGet, @JSONObject_ObjectsSet);
  end
  else
  if AType.ValueClassType = TBaseJSONEnumerator then
  begin
    AType.AddMethod('function MoveNext: Boolean', @BaseJSONEnumerator_MoveNext);
    AType.AddProp('Current', 'TJSONEnum', @BaseJSONEnumerator_Current);
  end
  else
  if SameText(AType.Name, 'tjsonenum') then
  begin
    AType.AddProp('Key', 'TJSONStringType', @JSONEnum_KeyGet, @JSONEnum_KeySet);
    AType.AddProp('KeyNum', 'Integer', @JSONEnum_KeyNumGet, @JSONEnum_KeyNumSet);
    AType.AddProp('Value', 'TJSONData', @JSONEnum_ValueGet, @JSONEnum_ValueSet);
  end

end;

initialization
  SetJSONInstanceType(jitNumberFloat, TJSONFloatNum);

end.

