unit dpi_fphttpserv;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, Variants, fphttpserver, fphttpclient,
  opensslsockets;

type

  { THTTPServerThread }

  THTTPServerThread = Class(TThread)
  Private
    FServer : TFPHTTPServer;
    FOnRequest: THTTPServerRequestHandler;
    TempSender: TObject;
    TempRequest: TFPHTTPConnectionRequest;
    TempResponse: TFPHTTPConnectionResponse;
  protected
    procedure OnSynhr;
    procedure DoRequest(Sender: TObject;
      Var ARequest: TFPHTTPConnectionRequest;
      Var AResponse : TFPHTTPConnectionResponse);
  Public
    constructor Create(APort : Word);
    procedure Execute; override;
    property Server : TFPHTTPServer Read FServer;
  published
    property OnRequest: THTTPServerRequestHandler read FOnRequest write FOnRequest;
  end;

  { TFpHttpServImport }
  TFpHttpServImport = class(TClassImporter)
  private
    function Cookies_Add(Instance: TObject; var Params: Variant): Variant;
    function Cookies_CookieByName(Instance: TObject; var Params: Variant
      ): Variant;
    function Cookies_FindCookie(Instance: TObject; var Params: Variant
      ): Variant;
    function Cookies_IndexOfCookie(Instance: TObject; var Params: Variant
      ): Variant;
    function Cookie_AsStringGet(Instance: Pointer): Variant;
    function Cookie_DomainGet(Instance: Pointer): Variant;
    procedure Cookie_DomainSet(Instance: Pointer; AValue: Variant);
    function Cookie_ExpiresGet(Instance: Pointer): Variant;
    procedure Cookie_ExpiresSet(Instance: Pointer; AValue: Variant);
    function Cookie_HttpOnlyGet(Instance: Pointer): Variant;
    procedure Cookie_HttpOnlySet(Instance: Pointer; AValue: Variant);
    function Cookie_ItemsGet(Instance: TObject; var Params: Variant): Variant;
    function Cookie_ItemsSet(Instance: TObject; var Params: Variant): Variant;
    function Cookie_NameGet(Instance: Pointer): Variant;
    procedure Cookie_NameSet(Instance: Pointer; AValue: Variant);
    function Cookie_PathGet(Instance: Pointer): Variant;
    procedure Cookie_PathSet(Instance: Pointer; AValue: Variant);
    function Cookie_SameSiteGet(Instance: Pointer): Variant;
    procedure Cookie_SameSiteSet(Instance: Pointer; AValue: Variant);
    function Cookie_SecureGet(Instance: Pointer): Variant;
    procedure Cookie_SecureSet(Instance: Pointer; AValue: Variant);
    function Cookie_ValueGet(Instance: Pointer): Variant;
    procedure Cookie_ValueSet(Instance: Pointer; AValue: Variant);
    function CustomHTTPClient_AddHeader(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_AddHeaderExt(Instance: TObject;
      var Params: Variant): Variant;
    function CustomHTTPClient_Delete(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_FileFormPost(Instance: TObject;
      var Params: Variant): Variant;
    function CustomHTTPClient_FormPost(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_GetHeader(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_GetHeaderExt(Instance: TObject;
      var Params: Variant): Variant;
    function CustomHTTPClient_Head(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_HTTPMethod(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_IndexOfHeader(Instance: TObject;
      var Params: Variant): Variant;
    function CustomHTTPClient_IndexOfHeaderExt(Instance: TObject;
      var Params: Variant): Variant;
    function CustomHTTPClient_Options(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_Post(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_Put(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_StreamFormPost(Instance: TObject;
      var Params: Variant): Variant;
    function CustomHTTPClient_Terminate(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomHTTPClient_TerminatedGet(Instance: Pointer): Variant;
    function fpHTTPClient_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function FPHTTPServer_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function FpHttpServ_Expire(Instance: TObject; var Params: Variant): Variant;
    function HTTPHeader_AcceptCharsetGet(Instance: Pointer): Variant;
    procedure HTTPHeader_AcceptCharsetSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_AcceptEncodingGet(Instance: Pointer): Variant;
    procedure HTTPHeader_AcceptEncodingSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_AcceptGet(Instance: Pointer): Variant;
    function HTTPHeader_AcceptLanguageGet(Instance: Pointer): Variant;
    procedure HTTPHeader_AcceptLanguageSet(Instance: Pointer; AValue: Variant);
    procedure HTTPHeader_AcceptSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_AuthorizationGet(Instance: Pointer): Variant;
    procedure HTTPHeader_AuthorizationSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ConnectionGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ConnectionSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ContentEncodingGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ContentEncodingSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ContentFieldsGet(Instance: Pointer): Variant;
    function HTTPHeader_ContentGet(Instance: Pointer): Variant;
    function HTTPHeader_ContentLanguageGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ContentLanguageSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ContentLengthGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ContentLengthSet(Instance: Pointer; AValue: Variant);
    procedure HTTPHeader_ContentSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ContentTypeGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ContentTypeSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_CookieFieldsGet(Instance: Pointer): Variant;
    procedure HTTPHeader_CookieFieldsSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_CookieGet(Instance: Pointer): Variant;
    procedure HTTPHeader_CookieSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_Create(Instance: TObject; var Params: Variant): Variant;
    function HTTPHeader_CustomHeadersGet(Instance: Pointer): Variant;
    function HTTPHeader_DateGet(Instance: Pointer): Variant;
    procedure HTTPHeader_DateSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ExpiresGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ExpiresSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_FieldCountGet(Instance: Pointer): Variant;
    function HTTPHeader_FieldNamesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPHeader_FieldsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPHeader_FieldValuesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPHeader_FromGet(Instance: Pointer): Variant;
    procedure HTTPHeader_FromSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_GetHeader(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPHeader_HeaderIsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPHeader_HostGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HostSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_HTTPAcceptCharsetGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HTTPAcceptCharsetSet(Instance: Pointer; AValue: Variant
      );
    function HTTPHeader_HTTPAcceptEncodingGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HTTPAcceptEncodingSet(Instance: Pointer;
      AValue: Variant);
    function HTTPHeader_HTTPAcceptGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HTTPAcceptSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_HTTPIfModifiedSinceGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HTTPIfModifiedSinceSet(Instance: Pointer;
      AValue: Variant);
    function HTTPHeader_HTTPRefererGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HTTPRefererSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_HTTPUserAgentGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HTTPUserAgentSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_HttpVersionGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HttpVersionSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_HTTPXRequestedWithGet(Instance: Pointer): Variant;
    procedure HTTPHeader_HTTPXRequestedWithSet(Instance: Pointer;
      AValue: Variant);
    function HTTPHeader_IfModifiedSinceGet(Instance: Pointer): Variant;
    procedure HTTPHeader_IfModifiedSinceSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_LastModifiedGet(Instance: Pointer): Variant;
    procedure HTTPHeader_LastModifiedSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPHeader_LoadFromStrings(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPHeader_LocationGet(Instance: Pointer): Variant;
    procedure HTTPHeader_LocationSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_MethodGet(Instance: Pointer): Variant;
    procedure HTTPHeader_MethodSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_PathInfoGet(Instance: Pointer): Variant;
    procedure HTTPHeader_PathInfoSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_PathTranslatedGet(Instance: Pointer): Variant;
    procedure HTTPHeader_PathTranslatedSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_PragmaGet(Instance: Pointer): Variant;
    procedure HTTPHeader_PragmaSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ProtocolVersionGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ProtocolVersionSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_QueryFieldsGet(Instance: Pointer): Variant;
    function HTTPHeader_QueryGet(Instance: Pointer): Variant;
    procedure HTTPHeader_QuerySet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_RefererGet(Instance: Pointer): Variant;
    procedure HTTPHeader_RefererSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_RemoteAddressGet(Instance: Pointer): Variant;
    procedure HTTPHeader_RemoteAddressSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_RemoteAddrGet(Instance: Pointer): Variant;
    procedure HTTPHeader_RemoteAddrSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_RemoteHostGet(Instance: Pointer): Variant;
    procedure HTTPHeader_RemoteHostSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_RetryAfterGet(Instance: Pointer): Variant;
    procedure HTTPHeader_RetryAfterSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ScriptNameGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ScriptNameSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ServerGet(Instance: Pointer): Variant;
    function HTTPHeader_ServerPortGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ServerPortSet(Instance: Pointer; AValue: Variant);
    procedure HTTPHeader_ServerSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_SetCookieGet(Instance: Pointer): Variant;
    procedure HTTPHeader_SetCookieSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_SetHeader(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPHeader_URLGet(Instance: Pointer): Variant;
    procedure HTTPHeader_URLSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_UserAgentGet(Instance: Pointer): Variant;
    procedure HTTPHeader_UserAgentSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_ViaGet(Instance: Pointer): Variant;
    procedure HTTPHeader_ViaSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_WarningGet(Instance: Pointer): Variant;
    procedure HTTPHeader_WarningSet(Instance: Pointer; AValue: Variant);
    function HTTPHeader_WWWAuthenticateGet(Instance: Pointer): Variant;
    procedure HTTPHeader_WWWAuthenticateSet(Instance: Pointer; AValue: Variant);
    function HTTPServerThread_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPServerThread_DoTerminate(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPServerThread_Execute(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPServerThread_Server(Instance: Pointer): Variant;
    function HTTPServerThread_Terminate(Instance: TObject; var Params: Variant
      ): Variant;
    function Request_CommandGet(Instance: Pointer): Variant;
    function Request_CommandLineGet(Instance: Pointer): Variant;
    function Request_ContentRangeGet(Instance: Pointer): Variant;
    procedure Request_ContentRangeSet(Instance: Pointer; AValue: Variant);
    function Request_Create(Instance: TObject; var Params: Variant): Variant;
    function Request_FilesGet(Instance: Pointer): Variant;
    function Request_GetNextPathInfo(Instance: TObject; var Params: Variant
      ): Variant;
    function Request_HandleGetOnPostGet(Instance: Pointer): Variant;
    procedure Request_HandleGetOnPostSet(Instance: Pointer; AValue: Variant);
    function Request_HeaderLineGet(Instance: Pointer): Variant;
    function Request_IfMatchGet(Instance: Pointer): Variant;
    procedure Request_IfMatchSet(Instance: Pointer; AValue: Variant);
    function Request_IfNoneMatchGet(Instance: Pointer): Variant;
    procedure Request_IfNoneMatchSet(Instance: Pointer; AValue: Variant);
    function Request_IfRangeGet(Instance: Pointer): Variant;
    procedure Request_IfRangeSet(Instance: Pointer; AValue: Variant);
    function Request_IfUnModifiedSinceGet(Instance: Pointer): Variant;
    procedure Request_IfUnModifiedSinceSet(Instance: Pointer; AValue: Variant);
    function Request_LocalPathPrefixGet(Instance: Pointer): Variant;
    function Request_QueryStringGet(Instance: Pointer): Variant;
    procedure Request_QueryStringSet(Instance: Pointer; AValue: Variant);
    function Request_ReturnedPathInfoGet(Instance: Pointer): Variant;
    procedure Request_ReturnedPathInfoSet(Instance: Pointer; AValue: Variant);
    function Request_RouteParamsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function Request_RouteParamsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function Request_TEGet(Instance: Pointer): Variant;
    procedure Request_TESet(Instance: Pointer; AValue: Variant);
    function Request_UpgradeGet(Instance: Pointer): Variant;
    procedure Request_UpgradeSet(Instance: Pointer; AValue: Variant);
    function Request_URIGet(Instance: Pointer): Variant;
    procedure Request_URISet(Instance: Pointer; AValue: Variant);
    function Response_AgeGet(Instance: Pointer): Variant;
    procedure Response_AgeSet(Instance: Pointer; AValue: Variant);
    function Response_AllowGet(Instance: Pointer): Variant;
    procedure Response_AllowSet(Instance: Pointer; AValue: Variant);
    function Response_CacheControlGet(Instance: Pointer): Variant;
    procedure Response_CacheControlSet(Instance: Pointer; AValue: Variant);
    function Response_CodeGet(Instance: Pointer): Variant;
    procedure Response_CodeSet(Instance: Pointer; AValue: Variant);
    function Response_CodeTextGet(Instance: Pointer): Variant;
    procedure Response_CodeTextSet(Instance: Pointer; AValue: Variant);
    function Response_ContentGet(Instance: Pointer): Variant;
    function Response_ContentLocationGet(Instance: Pointer): Variant;
    procedure Response_ContentLocationSet(Instance: Pointer; AValue: Variant);
    function Response_ContentMD5Get(Instance: Pointer): Variant;
    procedure Response_ContentMD5Set(Instance: Pointer; AValue: Variant);
    function Response_ContentRangeGet(Instance: Pointer): Variant;
    procedure Response_ContentRangeSet(Instance: Pointer; AValue: Variant);
    function Response_ContentSentGet(Instance: Pointer): Variant;
    procedure Response_ContentSet(Instance: Pointer; AValue: Variant);
    function Response_ContentsGet(Instance: Pointer): Variant;
    procedure Response_ContentsSet(Instance: Pointer; AValue: Variant);
    function Response_ContentStreamGet(Instance: Pointer): Variant;
    procedure Response_ContentStreamSet(Instance: Pointer; AValue: Variant);
    function Response_CookiesGet(Instance: Pointer): Variant;
    function Response_Create(Instance: TObject; var Params: Variant): Variant;
    function Response_ETagGet(Instance: Pointer): Variant;
    procedure Response_ETagSet(Instance: Pointer; AValue: Variant);
    function Response_FirstHeaderLineGet(Instance: Pointer): Variant;
    procedure Response_FirstHeaderLineSet(Instance: Pointer; AValue: Variant);
    function Response_FreeContentStreamGet(Instance: Pointer): Variant;
    procedure Response_FreeContentStreamSet(Instance: Pointer; AValue: Variant);
    function Response_HeadersSentGet(Instance: Pointer): Variant;
    function Response_ProxyAuthenticateGet(Instance: Pointer): Variant;
    procedure Response_ProxyAuthenticateSet(Instance: Pointer; AValue: Variant);
    function Response_RequestGet(Instance: Pointer): Variant;
    function Response_RetryAfterGet(Instance: Pointer): Variant;
    procedure Response_RetryAfterSet(Instance: Pointer; AValue: Variant);
    function Response_SendContent(Instance: TObject; var Params: Variant
      ): Variant;
    function Response_SendHeaders(Instance: TObject; var Params: Variant
      ): Variant;
    function Response_SendRedirect(Instance: TObject; var Params: Variant
      ): Variant;
    function Response_SendResponse(Instance: TObject; var Params: Variant
      ): Variant;
    function THTTPServerThread_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function UploadedFiles_FileByName(Instance: TObject; var Params: Variant
      ): Variant;
    function UploadedFiles_FilesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function UploadedFiles_FilesSet(Instance: TObject; var Params: Variant
      ): Variant;
    function UploadedFiles_FindFile(Instance: TObject; var Params: Variant
      ): Variant;
    function UploadedFiles_First(Instance: TObject; var Params: Variant
      ): Variant;
    function UploadedFiles_IndexOfFile(Instance: TObject; var Params: Variant
      ): Variant;
    function UploadedFiles_Last(Instance: TObject; var Params: Variant
      ): Variant;
    function UploadedFile_ContentTypeGet(Instance: Pointer): Variant;
    procedure UploadedFile_ContentTypeSet(Instance: Pointer; AValue: Variant);
    function UploadedFile_DescriptionGet(Instance: Pointer): Variant;
    procedure UploadedFile_DescriptionSet(Instance: Pointer; AValue: Variant);
    function UploadedFile_DispositionGet(Instance: Pointer): Variant;
    procedure UploadedFile_DispositionSet(Instance: Pointer; AValue: Variant);
    function UploadedFile_FieldNameGet(Instance: Pointer): Variant;
    procedure UploadedFile_FieldNameSet(Instance: Pointer; AValue: Variant);
    function UploadedFile_FileNameGet(Instance: Pointer): Variant;
    procedure UploadedFile_FileNameSet(Instance: Pointer; AValue: Variant);
    function UploadedFile_LocalFileNameGet(Instance: Pointer): Variant;
    procedure UploadedFile_LocalFileNameSet(Instance: Pointer; AValue: Variant);
    function UploadedFile_SizeGet(Instance: Pointer): Variant;
    procedure UploadedFile_SizeSet(Instance: Pointer; AValue: Variant);
    function UploadedFile_StreamGet(Instance: Pointer): Variant;
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
              override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  end;

implementation

uses HTTPDefs, httpprotocol;

type

  { TDpHTTPServerRequestHandler }

  TDpHTTPServerRequestHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject;
      Var ARequest: TFPHTTPConnectionRequest;
      Var AResponse : TFPHTTPConnectionResponse);
    function GetHandlerAdres: Pointer; override;
  end;

{ TDpHTTPServerRequestHandler }

procedure TDpHTTPServerRequestHandler.CallHandler(Sender: TObject;
  var ARequest: TFPHTTPConnectionRequest;
  var AResponse: TFPHTTPConnectionResponse);
begin
  if Proc <> nil then
  begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Param[1].Value := TSuPtr(ARequest);
    Proc.Param[2].Value := TSuPtr(AResponse);
    Proc.Exec;
  end;
end;

function TDpHTTPServerRequestHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDpHTTPServerRequestHandler.CallHandler;
end;

{ THTTPServerThread }

procedure THTTPServerThread.OnSynhr;
begin
  if Assigned(FOnRequest) then
    FOnRequest(TempSender, TempRequest, TempResponse);
end;

procedure THTTPServerThread.DoRequest(Sender: TObject;
  var ARequest: TFPHTTPConnectionRequest;
  var AResponse: TFPHTTPConnectionResponse);
begin
  TempRequest := ARequest;
  TempResponse := AResponse;
  TempSender := Sender;
  Synchronize(Self, @OnSynhr);
  //AResponse.Contents.Add('sfsfsf');
end;

constructor THTTPServerThread.Create(APort: Word);
begin
  FServer := TFPHTTPServer.Create(nil);
  FServer.Port := APort;
  FServer.OnRequest := @DoRequest;
  inherited Create(False);
end;

procedure THTTPServerThread.Execute;
begin
  try
    FServer.Active:=True;
  Finally
    FreeAndNil(FServer);
  end;
end;

{ TFpHttpServImport }

function TFpHttpServImport.Cookies_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TCookies(Instance).Add );
end;

function TFpHttpServImport.Cookies_CookieByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCookies(Instance).CookieByName(Params[0]));
end;

function TFpHttpServImport.Cookies_FindCookie(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TCookies(Instance).FindCookie(Params[0]) );
end;

function TFpHttpServImport.Cookies_IndexOfCookie(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCookies(Instance).IndexOfCookie(Params[0]);
end;

function TFpHttpServImport.Cookie_AsStringGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).AsString;
end;

function TFpHttpServImport.Cookie_DomainGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).Domain;
end;

procedure TFpHttpServImport.Cookie_DomainSet(Instance: Pointer; AValue: Variant
  );
begin
  TCookie(Instance).Domain:= AValue;
end;

function TFpHttpServImport.Cookie_ExpiresGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).Expires;
end;

procedure TFpHttpServImport.Cookie_ExpiresSet(Instance: Pointer; AValue: Variant
  );
begin
  TCookie(Instance).Expires := AValue;
end;

function TFpHttpServImport.Cookie_HttpOnlyGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).HttpOnly;
end;

procedure TFpHttpServImport.Cookie_HttpOnlySet(Instance: Pointer;
  AValue: Variant);
begin
  TCookie(Instance).HttpOnly := AValue;
end;

function TFpHttpServImport.Cookie_ItemsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TCookies(Instance).Items[Params[0]] );
end;

function TFpHttpServImport.Cookie_ItemsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCookies(Instance).Items[Params[0]] := TCookie(TSuPtr(Params[1]));
end;

function TFpHttpServImport.Cookie_NameGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).Name;
end;

procedure TFpHttpServImport.Cookie_NameSet(Instance: Pointer; AValue: Variant);
begin
  TCookie(Instance).Name := AValue;
end;

function TFpHttpServImport.Cookie_PathGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).Path;
end;

procedure TFpHttpServImport.Cookie_PathSet(Instance: Pointer; AValue: Variant);
begin
  TCookie(Instance).Path := AValue;
end;

function TFpHttpServImport.Cookie_SameSiteGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).SameSite;
end;

procedure TFpHttpServImport.Cookie_SameSiteSet(Instance: Pointer;
  AValue: Variant);
begin
  TCookie(Instance).SameSite := AValue;
end;

function TFpHttpServImport.Cookie_SecureGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).Secure;
end;

procedure TFpHttpServImport.Cookie_SecureSet(Instance: Pointer; AValue: Variant
  );
begin
  TCookie(Instance).Secure := AValue;
end;

function TFpHttpServImport.Cookie_ValueGet(Instance: Pointer): Variant;
begin
  Result := TCookie(Instance).Value;
end;

procedure TFpHttpServImport.Cookie_ValueSet(Instance: Pointer; AValue: Variant);
begin
  TCookie(Instance).Value := AValue;
end;

function TFpHttpServImport.CustomHTTPClient_AddHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFPCustomHTTPClient(Instance).AddHeader(string(Params[0]), string(Params[1]));
end;

function TFpHttpServImport.CustomHTTPClient_AddHeaderExt(Instance: TObject;
  var Params: Variant): Variant;
var
  Headers: TStrings;
begin
  Headers := TStrings( TSuPtr(Params[0]) );
  TFPCustomHTTPClient(Instance).AddHeader(Headers, Params[1], Params[2]);
end;

function TFpHttpServImport.CustomHTTPClient_Delete(Instance: TObject;
  var Params: Variant): Variant;
var
  URL: string;
  Stream: TStream;
begin
  URL := Params[0];
  Stream := TStream(TSuPtr(Params[0]));
  TFPCustomHTTPClient(Instance).Delete(URL, Stream);
end;

function TFpHttpServImport.CustomHTTPClient_FileFormPost(Instance: TObject;
  var Params: Variant): Variant;
var
  URL, AFieldName, AFileName: string;
  FormData: TStrings;
  Response: TStream;
begin
  URL := Params[0];
  FormData := TStrings(TSuPtr(Params[1]));
  AFieldName := Params[2];
  AFileName := Params[3];
  Response := TStream(TSuPtr(Params[4]));
  TFPHTTPClient(Instance).FileFormPost(URL, FormData, AFieldName, AFileName, Response);
end;

function TFpHttpServImport.CustomHTTPClient_FormPost(Instance: TObject;
  var Params: Variant): Variant;
var
  URL: string;
  FormData: TStrings;
  Response: TStream;
begin
  URL := Params[0];
  FormData := TStrings(TSuPtr(Params[1]));
  Response := TStream(TSuPtr(Params[2]));
  TFPCustomHTTPClient(Instance).FormPost(URL, FormData, Response);
end;

function TFpHttpServImport.CustomHTTPClient_Get(Instance: TObject;
  var Params: Variant): Variant;
var
  URL: string;
  Response: TStream;
begin
  URL := Params[0];
  Response := TStream( TSuPtr(Params[1]) );
  TFPCustomHTTPClient(Instance).Get(URL, Response);
end;

function TFpHttpServImport.CustomHTTPClient_GetHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFPCustomHTTPClient(Instance).GetHeader(string(Params[0]));
end;

function TFpHttpServImport.CustomHTTPClient_GetHeaderExt(Instance: TObject;
  var Params: Variant): Variant;
var
  Headers: TStrings;
begin
  Headers := TStrings( TSuPtr(Params[0]) );
  Result := TFPCustomHTTPClient(Instance).GetHeader(Headers, Params[1]);
end;

function TFpHttpServImport.CustomHTTPClient_Head(Instance: TObject;
  var Params: Variant): Variant;
var
  URL: string;
  Headers: TStrings;
begin
  URL := Params[0];
  Headers := TStrings(TSuPtr(Params[1]));
  TFPCustomHTTPClient(Instance).Head(URL, Headers);
end;

function TFpHttpServImport.CustomHTTPClient_HTTPMethod(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
  A: Array of Integer;
  V: Variant;
  I, HBound: Integer;
begin
  Stream := TStream(TSuPtr(Params[2]));
  V := Params[3];
  HBound := VarArrayHighBound(V, 1);
  SetLength(A, HBound);
  for I := 0 to HBound - 1 do
    A[I] := V[I];
  TFPCustomHTTPClient(Instance).HTTPMethod(Params[0], Params[1], Stream, A);
end;

function TFpHttpServImport.CustomHTTPClient_IndexOfHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFPCustomHTTPClient(Instance).IndexOfHeader(Params[0]);
end;

function TFpHttpServImport.CustomHTTPClient_IndexOfHeaderExt(Instance: TObject;
  var Params: Variant): Variant;
var
  Headers: TStrings;
begin
  Headers := TStrings( TSuPtr(Params[0]) );
  Result := TFPCustomHTTPClient(Instance).IndexOfHeader(Headers, Params[1]);
end;

function TFpHttpServImport.CustomHTTPClient_Options(Instance: TObject;
  var Params: Variant): Variant;
var
  URL: string;
  Response: TStream;
begin
  URL := Params[0];
  Response := TStream(TSuPtr(Params[1]));
  TFPCustomHTTPClient(Instance).Options(URL, Response);
end;

function TFpHttpServImport.CustomHTTPClient_Post(Instance: TObject;
  var Params: Variant): Variant;
var
  URL: string;
  Response: TStream;
begin
  URL := Params[0];
  Response := TStream(TSuPtr(Params[1]));
  TFPCustomHTTPClient(Instance).Post(URL, Response);
end;

function TFpHttpServImport.CustomHTTPClient_Put(Instance: TObject;
  var Params: Variant): Variant;
var
  URL: string;
  Response: TStream;
begin
  URL := Params[0];
  Response := TStream(TSuPtr(Params[1]));
  TFPCustomHTTPClient(Instance).Put(URL, Response);
end;

function TFpHttpServImport.CustomHTTPClient_StreamFormPost(Instance: TObject;
  var Params: Variant): Variant;
var
  URL, AFieldName, AFileName: string;
  FormData: TStrings;
  AStream, Response: TStream;
begin
  URL := Params[0];
  FormData := TStrings(TSuPtr(Params[1]));
  AFieldName := Params[2];
  AFileName := Params[3];
  AStream := TStream(TSuPtr(Params[4]));
  Response := TStream(TSuPtr(Params[5]));
  TFPHTTPClient(Instance).StreamFormPost(URL, FormData, AFieldName, AFileName, AStream, Response);
end;

function TFpHttpServImport.CustomHTTPClient_Terminate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFPCustomHTTPClient(Instance).Terminate;
end;

function TFpHttpServImport.CustomHTTPClient_TerminatedGet(Instance: Pointer
  ): Variant;
begin
  Result := TFPCustomHTTPClient(Instance).Terminated;
end;

function TFpHttpServImport.fpHTTPClient_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TFPHTTPClient.Create( TComponent( TSuPtr(Params[0]) ) ));
end;

function TFpHttpServImport.FPHTTPServer_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TFPHttpServer.Create(TComponent(TSuPtr(Params[0]))) );
end;

function TFpHttpServImport.FpHttpServ_Expire(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCookie(Instance).Expire;
end;

function TFpHttpServImport.HTTPHeader_AcceptCharsetGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).AcceptCharset;
end;

procedure TFpHttpServImport.HTTPHeader_AcceptCharsetSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).AcceptCharset := AValue;
end;

function TFpHttpServImport.HTTPHeader_AcceptEncodingGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).AcceptEncoding;
end;

procedure TFpHttpServImport.HTTPHeader_AcceptEncodingSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).AcceptEncoding:= AValue;
end;

function TFpHttpServImport.HTTPHeader_AcceptGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Accept;
end;

function TFpHttpServImport.HTTPHeader_AcceptLanguageGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).AcceptLanguage;
end;

procedure TFpHttpServImport.HTTPHeader_AcceptLanguageSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).AcceptLanguage:= AValue;
end;

procedure TFpHttpServImport.HTTPHeader_AcceptSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Accept := AValue;
end;

function TFpHttpServImport.HTTPHeader_AuthorizationGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).Authorization;
end;

procedure TFpHttpServImport.HTTPHeader_AuthorizationSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Authorization := AValue;
end;

function TFpHttpServImport.HTTPHeader_ConnectionGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Connection;
end;

procedure TFpHttpServImport.HTTPHeader_ConnectionSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Connection := AValue;
end;

function TFpHttpServImport.HTTPHeader_ContentEncodingGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).ContentEncoding;
end;

procedure TFpHttpServImport.HTTPHeader_ContentEncodingSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).ContentEncoding := AValue;
end;

function TFpHttpServImport.HTTPHeader_ContentFieldsGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( THTTPHeader(Instance).ContentFields );
end;

function TFpHttpServImport.HTTPHeader_ContentGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Content;
end;

function TFpHttpServImport.HTTPHeader_ContentLanguageGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).ContentLanguage;
end;

procedure TFpHttpServImport.HTTPHeader_ContentLanguageSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).ContentLanguage := AValue;
end;

function TFpHttpServImport.HTTPHeader_ContentLengthGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).ContentLength;
end;

procedure TFpHttpServImport.HTTPHeader_ContentLengthSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).ContentLength := AValue;
end;

procedure TFpHttpServImport.HTTPHeader_ContentSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Content := AValue;
end;

function TFpHttpServImport.HTTPHeader_ContentTypeGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).ContentType;
end;

procedure TFpHttpServImport.HTTPHeader_ContentTypeSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).ContentType := AValue;
end;

function TFpHttpServImport.HTTPHeader_CookieFieldsGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(THTTPHeader(Instance).CookieFields);
end;

procedure TFpHttpServImport.HTTPHeader_CookieFieldsSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).CookieFields := TStrings(TSuPtr(AValue));
end;

function TFpHttpServImport.HTTPHeader_CookieGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Cookie;
end;

procedure TFpHttpServImport.HTTPHeader_CookieSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Cookie := AValue;
end;

function TFpHttpServImport.HTTPHeader_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( THTTPHeader.Create );
end;

function TFpHttpServImport.HTTPHeader_CustomHeadersGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(THTTPHeader(Instance).CustomHeaders);
end;

function TFpHttpServImport.HTTPHeader_DateGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Date;
end;

procedure TFpHttpServImport.HTTPHeader_DateSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Date := AValue;
end;

function TFpHttpServImport.HTTPHeader_ExpiresGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Expires;
end;

procedure TFpHttpServImport.HTTPHeader_ExpiresSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Expires := AValue;
end;

function TFpHttpServImport.HTTPHeader_FieldCountGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).FieldCount;
end;

function TFpHttpServImport.HTTPHeader_FieldNamesGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := THTTPHeader(Instance).FieldNames[Params[0]];
end;

function TFpHttpServImport.HTTPHeader_FieldsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := THTTPHeader(Instance).Fields[Params[0]];
end;

function TFpHttpServImport.HTTPHeader_FieldValuesGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := THTTPHeader(Instance).FieldValues[Params[0]];
end;

function TFpHttpServImport.HTTPHeader_FromGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).From;
end;

procedure TFpHttpServImport.HTTPHeader_FromSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).From := AValue;
end;

function TFpHttpServImport.HTTPHeader_GetHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := THTTPHeader(Instance).GetHeader(Params[0]);
end;

function TFpHttpServImport.HTTPHeader_HeaderIsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := THTTPHeader(Instance).HeaderIsSet(Params[0]);
end;

function TFpHttpServImport.HTTPHeader_HostGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Host;
end;

procedure TFpHttpServImport.HTTPHeader_HostSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Host := AValue;
end;

function TFpHttpServImport.HTTPHeader_HTTPAcceptCharsetGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).HTTPAcceptCharset;
end;

procedure TFpHttpServImport.HTTPHeader_HTTPAcceptCharsetSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).HTTPAcceptCharset := AValue;
end;

function TFpHttpServImport.HTTPHeader_HTTPAcceptEncodingGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).HTTPAcceptEncoding;
end;

procedure TFpHttpServImport.HTTPHeader_HTTPAcceptEncodingSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).HTTPAcceptEncoding := AValue;
end;

function TFpHttpServImport.HTTPHeader_HTTPAcceptGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).HTTPAccept;
end;

procedure TFpHttpServImport.HTTPHeader_HTTPAcceptSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).HTTPAccept := AValue;
end;

function TFpHttpServImport.HTTPHeader_HTTPIfModifiedSinceGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).HTTPIfModifiedSince;
end;

procedure TFpHttpServImport.HTTPHeader_HTTPIfModifiedSinceSet(
  Instance: Pointer; AValue: Variant);
begin
  THTTPHeader(Instance).HTTPIfModifiedSince := AValue;
end;

function TFpHttpServImport.HTTPHeader_HTTPRefererGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).HTTPReferer;
end;

procedure TFpHttpServImport.HTTPHeader_HTTPRefererSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).HTTPReferer := AValue;
end;

function TFpHttpServImport.HTTPHeader_HTTPUserAgentGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).HTTPUserAgent;
end;

procedure TFpHttpServImport.HTTPHeader_HTTPUserAgentSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).HTTPUserAgent := AValue;
end;

function TFpHttpServImport.HTTPHeader_HttpVersionGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).HttpVersion;
end;

procedure TFpHttpServImport.HTTPHeader_HttpVersionSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).HttpVersion := AValue;
end;

function TFpHttpServImport.HTTPHeader_HTTPXRequestedWithGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).HTTPXRequestedWith;
end;

procedure TFpHttpServImport.HTTPHeader_HTTPXRequestedWithSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).HTTPXRequestedWith := AValue;
end;

function TFpHttpServImport.HTTPHeader_IfModifiedSinceGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).IfModifiedSince;
end;

procedure TFpHttpServImport.HTTPHeader_IfModifiedSinceSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).IfModifiedSince := AValue;
end;

function TFpHttpServImport.HTTPHeader_LastModifiedGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).LastModified;
end;

procedure TFpHttpServImport.HTTPHeader_LastModifiedSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).LastModified := AValue;
end;

function TFpHttpServImport.HTTPHeader_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := THTTPHeader(Instance).LoadFromStream(TStream(TSuPtr(Params[0])), Params[1]);
end;

function TFpHttpServImport.HTTPHeader_LoadFromStrings(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := THTTPHeader(Instance).LoadFromStrings(TStrings(TSuPtr(Params[0])), Params[1]);
end;

function TFpHttpServImport.HTTPHeader_LocationGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Location;
end;

procedure TFpHttpServImport.HTTPHeader_LocationSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Location := AValue;
end;

function TFpHttpServImport.HTTPHeader_MethodGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Method;
end;

procedure TFpHttpServImport.HTTPHeader_MethodSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Method := AValue;
end;

function TFpHttpServImport.HTTPHeader_PathInfoGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).PathInfo;
end;

procedure TFpHttpServImport.HTTPHeader_PathInfoSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).PathInfo := AValue;
end;

function TFpHttpServImport.HTTPHeader_PathTranslatedGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).PathTranslated;
end;

procedure TFpHttpServImport.HTTPHeader_PathTranslatedSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).PathTranslated := AValue;
end;

function TFpHttpServImport.HTTPHeader_PragmaGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Pragma;
end;

procedure TFpHttpServImport.HTTPHeader_PragmaSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Pragma := AValue;
end;

function TFpHttpServImport.HTTPHeader_ProtocolVersionGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).ProtocolVersion;
end;

procedure TFpHttpServImport.HTTPHeader_ProtocolVersionSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).ProtocolVersion := AValue;
end;

function TFpHttpServImport.HTTPHeader_QueryFieldsGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( THTTPHeader(Instance).QueryFields );
end;

function TFpHttpServImport.HTTPHeader_QueryGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Query;
end;

procedure TFpHttpServImport.HTTPHeader_QuerySet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Query := AValue;
end;

function TFpHttpServImport.HTTPHeader_RefererGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Referer;
end;

procedure TFpHttpServImport.HTTPHeader_RefererSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Referer := AValue;
end;

function TFpHttpServImport.HTTPHeader_RemoteAddressGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).RemoteAddress;
end;

procedure TFpHttpServImport.HTTPHeader_RemoteAddressSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).RemoteAddress:= AValue;
end;

function TFpHttpServImport.HTTPHeader_RemoteAddrGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).RemoteAddr;
end;

procedure TFpHttpServImport.HTTPHeader_RemoteAddrSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).RemoteAddr := AValue;
end;

function TFpHttpServImport.HTTPHeader_RemoteHostGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).RemoteHost;
end;

procedure TFpHttpServImport.HTTPHeader_RemoteHostSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).RemoteHost := AValue;
end;

function TFpHttpServImport.HTTPHeader_RetryAfterGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).RetryAfter;
end;

procedure TFpHttpServImport.HTTPHeader_RetryAfterSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).RetryAfter := AValue;
end;

function TFpHttpServImport.HTTPHeader_ScriptNameGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).ScriptName;
end;

procedure TFpHttpServImport.HTTPHeader_ScriptNameSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).ScriptName:= AValue;
end;

function TFpHttpServImport.HTTPHeader_ServerGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Server;
end;

function TFpHttpServImport.HTTPHeader_ServerPortGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).ServerPort;
end;

procedure TFpHttpServImport.HTTPHeader_ServerPortSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).ServerPort := AValue;
end;

procedure TFpHttpServImport.HTTPHeader_ServerSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Server := AValue;
end;

function TFpHttpServImport.HTTPHeader_SetCookieGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).SetCookie;
end;

procedure TFpHttpServImport.HTTPHeader_SetCookieSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).SetCookie := AValue;
end;

function TFpHttpServImport.HTTPHeader_SetHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  THTTPHeader(Instance).SetHeader(Params[0], Params[1]);
end;

function TFpHttpServImport.HTTPHeader_URLGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).URL;
end;

procedure TFpHttpServImport.HTTPHeader_URLSet(Instance: Pointer; AValue: Variant
  );
begin
  THTTPHeader(Instance).URL := AValue;
end;

function TFpHttpServImport.HTTPHeader_UserAgentGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).UserAgent;
end;

procedure TFpHttpServImport.HTTPHeader_UserAgentSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).UserAgent := AValue;
end;

function TFpHttpServImport.HTTPHeader_ViaGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Via;
end;

procedure TFpHttpServImport.HTTPHeader_ViaSet(Instance: Pointer; AValue: Variant
  );
begin
  THTTPHeader(Instance).Via := AValue;
end;

function TFpHttpServImport.HTTPHeader_WarningGet(Instance: Pointer): Variant;
begin
  Result := THTTPHeader(Instance).Warning;
end;

procedure TFpHttpServImport.HTTPHeader_WarningSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).Warning := AValue;
end;

function TFpHttpServImport.HTTPHeader_WWWAuthenticateGet(Instance: Pointer
  ): Variant;
begin
  Result := THTTPHeader(Instance).WWWAuthenticate;
end;

procedure TFpHttpServImport.HTTPHeader_WWWAuthenticateSet(Instance: Pointer;
  AValue: Variant);
begin
  THTTPHeader(Instance).WWWAuthenticate := AValue;
end;

function TFpHttpServImport.HTTPServerThread_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( THTTPServerThread.Create(Params[0]) );
end;

function TFpHttpServImport.HTTPServerThread_DoTerminate(Instance: TObject;
  var Params: Variant): Variant;
begin
  THTTPServerThread(Instance).DoTerminate;
end;

function TFpHttpServImport.HTTPServerThread_Execute(Instance: TObject;
  var Params: Variant): Variant;
begin
  THTTPServerThread(Instance).Execute;
end;

function TFpHttpServImport.HTTPServerThread_Server(Instance: Pointer): Variant;
begin
  Result := TSuPtr( THTTPServerThread(Instance).Server );
end;

function TFpHttpServImport.HTTPServerThread_Terminate(Instance: TObject;
  var Params: Variant): Variant;
begin
  THTTPServerThread(Instance).Server.Active := False;
  THTTPServerThread(Instance).Terminate;
end;

function TFpHttpServImport.Request_CommandGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).Command;
end;

function TFpHttpServImport.Request_CommandLineGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).CommandLine;
end;

function TFpHttpServImport.Request_ContentRangeGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).ContentRange;
end;

procedure TFpHttpServImport.Request_ContentRangeSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).ContentRange := AValue;
end;

function TFpHttpServImport.Request_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TRequest.Create );
end;

function TFpHttpServImport.Request_FilesGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TRequest(Instance).Files );
end;

function TFpHttpServImport.Request_GetNextPathInfo(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TRequest(Instance).GetNextPathInfo;
end;

function TFpHttpServImport.Request_HandleGetOnPostGet(Instance: Pointer
  ): Variant;
begin
  Result := TRequest(Instance).HandleGetOnPost;
end;

procedure TFpHttpServImport.Request_HandleGetOnPostSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).HandleGetOnPost := AValue;
end;

function TFpHttpServImport.Request_HeaderLineGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).HeaderLine;
end;

function TFpHttpServImport.Request_IfMatchGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).IfMatch;
end;

procedure TFpHttpServImport.Request_IfMatchSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).IfMatch := AValue;
end;

function TFpHttpServImport.Request_IfNoneMatchGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).IfNoneMatch;
end;

procedure TFpHttpServImport.Request_IfNoneMatchSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).IfNoneMatch := AValue;
end;

function TFpHttpServImport.Request_IfRangeGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).IfRange;
end;

procedure TFpHttpServImport.Request_IfRangeSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).IfRange:= AValue;
end;

function TFpHttpServImport.Request_IfUnModifiedSinceGet(Instance: Pointer
  ): Variant;
begin
  Result := TRequest(Instance).IfUnModifiedSince;
end;

procedure TFpHttpServImport.Request_IfUnModifiedSinceSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).IfUnModifiedSince := AValue;
end;

function TFpHttpServImport.Request_LocalPathPrefixGet(Instance: Pointer
  ): Variant;
begin
  Result := TRequest(Instance).LocalPathPrefix;
end;

function TFpHttpServImport.Request_QueryStringGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).QueryString;
end;

procedure TFpHttpServImport.Request_QueryStringSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).QueryString := AValue;
end;

function TFpHttpServImport.Request_ReturnedPathInfoGet(Instance: Pointer
  ): Variant;
begin
  Result := TRequest(Instance).ReturnedPathInfo;
end;

procedure TFpHttpServImport.Request_ReturnedPathInfoSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).ReturnedPathInfo:= AValue;
end;

function TFpHttpServImport.Request_RouteParamsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TRequest(Instance).RouteParams[Params[0]];
end;

function TFpHttpServImport.Request_RouteParamsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TRequest(Instance).RouteParams[Params[0]] := Params[1];
end;

function TFpHttpServImport.Request_TEGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).TE;
end;

procedure TFpHttpServImport.Request_TESet(Instance: Pointer; AValue: Variant);
begin
  TRequest(Instance).TE := AValue;
end;

function TFpHttpServImport.Request_UpgradeGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).Upgrade;
end;

procedure TFpHttpServImport.Request_UpgradeSet(Instance: Pointer;
  AValue: Variant);
begin
  TRequest(Instance).Upgrade := AValue;
end;

function TFpHttpServImport.Request_URIGet(Instance: Pointer): Variant;
begin
  Result := TRequest(Instance).URI;
end;

procedure TFpHttpServImport.Request_URISet(Instance: Pointer; AValue: Variant);
begin
  TRequest(Instance).URI := AValue;
end;

function TFpHttpServImport.Response_AgeGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).Age;
end;

procedure TFpHttpServImport.Response_AgeSet(Instance: Pointer; AValue: Variant);
begin
  TResponse(Instance).Age := AValue;
end;

function TFpHttpServImport.Response_AllowGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).Allow;
end;

procedure TFpHttpServImport.Response_AllowSet(Instance: Pointer; AValue: Variant
  );
begin
  TResponse(Instance).Allow := AValue;
end;

function TFpHttpServImport.Response_CacheControlGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).CacheControl;
end;

procedure TFpHttpServImport.Response_CacheControlSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).CacheControl := AValue;
end;

function TFpHttpServImport.Response_CodeGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).Code;
end;

procedure TFpHttpServImport.Response_CodeSet(Instance: Pointer; AValue: Variant
  );
begin
  TResponse(Instance).Code := AValue;
end;

function TFpHttpServImport.Response_CodeTextGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).CodeText;
end;

procedure TFpHttpServImport.Response_CodeTextSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).CodeText := AValue;
end;

function TFpHttpServImport.Response_ContentGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).Content;
end;

function TFpHttpServImport.Response_ContentLocationGet(Instance: Pointer
  ): Variant;
begin
  Result := TResponse(Instance).ContentLocation;
end;

procedure TFpHttpServImport.Response_ContentLocationSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).ContentLocation := AValue;
end;

function TFpHttpServImport.Response_ContentMD5Get(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).ContentMD5;
end;

procedure TFpHttpServImport.Response_ContentMD5Set(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).ContentMD5 := AValue;
end;

function TFpHttpServImport.Response_ContentRangeGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).ContentRange;
end;

procedure TFpHttpServImport.Response_ContentRangeSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).ContentRange := AValue;
end;

function TFpHttpServImport.Response_ContentSentGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).ContentSent;
end;

procedure TFpHttpServImport.Response_ContentSet(Instance: Pointer;
  AValue: Variant);
var
  S: string;
begin
  S := AValue;
  TResponse(Instance).Content := S;
end;

function TFpHttpServImport.Response_ContentsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TResponse(Instance).Contents );
end;

procedure TFpHttpServImport.Response_ContentsSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).Contents := TStrings( TSuPtr(AValue) );
end;

function TFpHttpServImport.Response_ContentStreamGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TResponse(Instance).ContentStream );
end;

procedure TFpHttpServImport.Response_ContentStreamSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).ContentStream := TStream( TSuPtr(AValue) );
end;

function TFpHttpServImport.Response_CookiesGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TResponse(Instance).Cookies );
end;

function TFpHttpServImport.Response_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TResponse.Create( TRequest( TSuPtr(Params[0]) ) ) );
end;

function TFpHttpServImport.Response_ETagGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).ETag;
end;

procedure TFpHttpServImport.Response_ETagSet(Instance: Pointer; AValue: Variant
  );
begin
  TResponse(Instance).ETag := AValue;
end;

function TFpHttpServImport.Response_FirstHeaderLineGet(Instance: Pointer
  ): Variant;
begin
  Result := TResponse(Instance).FirstHeaderLine;
end;

procedure TFpHttpServImport.Response_FirstHeaderLineSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).FirstHeaderLine := AValue;
end;

function TFpHttpServImport.Response_FreeContentStreamGet(Instance: Pointer
  ): Variant;
begin
  Result := TResponse(Instance).FreeContentStream;
end;

procedure TFpHttpServImport.Response_FreeContentStreamSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).FreeContentStream := AValue;
end;

function TFpHttpServImport.Response_HeadersSentGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).HeadersSent;
end;

function TFpHttpServImport.Response_ProxyAuthenticateGet(Instance: Pointer
  ): Variant;
begin
  Result := TResponse(Instance).ProxyAuthenticate;
end;

procedure TFpHttpServImport.Response_ProxyAuthenticateSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).ProxyAuthenticate := AValue;
end;

function TFpHttpServImport.Response_RequestGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TResponse(Instance).Request);
end;

function TFpHttpServImport.Response_RetryAfterGet(Instance: Pointer): Variant;
begin
  Result := TResponse(Instance).RetryAfter;
end;

procedure TFpHttpServImport.Response_RetryAfterSet(Instance: Pointer;
  AValue: Variant);
begin
  TResponse(Instance).RetryAfter := AValue;
end;

function TFpHttpServImport.Response_SendContent(Instance: TObject;
  var Params: Variant): Variant;
begin
  TResponse(Instance).SendContent;
end;

function TFpHttpServImport.Response_SendHeaders(Instance: TObject;
  var Params: Variant): Variant;
begin
  TResponse(Instance).SendHeaders;
end;

function TFpHttpServImport.Response_SendRedirect(Instance: TObject;
  var Params: Variant): Variant;
begin
  TResponse(Instance).SendRedirect(Params[0]);
end;

function TFpHttpServImport.Response_SendResponse(Instance: TObject;
  var Params: Variant): Variant;
begin
  TResponse(Instance).SendResponse;
end;

function TFpHttpServImport.THTTPServerThread_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( THTTPServerThread.Create(Params[0]) );
end;

function TFpHttpServImport.UploadedFiles_FileByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TUploadedFiles(Instance).FileByName(Params[0]) );
end;

function TFpHttpServImport.UploadedFiles_FilesGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TUploadedFiles(Instance).Files[Params[0]] );
end;

function TFpHttpServImport.UploadedFiles_FilesSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TUploadedFiles(Instance).Files[Params[0]] := TUploadedFile( TSuPtr(Params[1]) );
end;

function TFpHttpServImport.UploadedFiles_FindFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TUploadedFiles(Instance).FindFile(Params[0]) );
end;

function TFpHttpServImport.UploadedFiles_First(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TUploadedFiles(Instance).First );
end;

function TFpHttpServImport.UploadedFiles_IndexOfFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TUploadedFiles(Instance).IndexOfFile(Params[0]);
end;

function TFpHttpServImport.UploadedFiles_Last(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TUploadedFiles(Instance).Last );
end;

function TFpHttpServImport.UploadedFile_ContentTypeGet(Instance: Pointer
  ): Variant;
begin
  Result := TUploadedFile(Instance).ContentType;
end;

procedure TFpHttpServImport.UploadedFile_ContentTypeSet(Instance: Pointer;
  AValue: Variant);
begin
  TUploadedFile(Instance).ContentType := AValue;
end;

function TFpHttpServImport.UploadedFile_DescriptionGet(Instance: Pointer
  ): Variant;
begin
  Result := TUploadedFile(Instance).Description;
end;

procedure TFpHttpServImport.UploadedFile_DescriptionSet(Instance: Pointer;
  AValue: Variant);
begin
  TUploadedFile(Instance).Description := AValue;
end;

function TFpHttpServImport.UploadedFile_DispositionGet(Instance: Pointer
  ): Variant;
begin
  Result := TUploadedFile(Instance).Disposition;
end;

procedure TFpHttpServImport.UploadedFile_DispositionSet(Instance: Pointer;
  AValue: Variant);
begin
  TUploadedFile(Instance).Disposition := AValue;
end;

function TFpHttpServImport.UploadedFile_FieldNameGet(Instance: Pointer
  ): Variant;
begin
  Result := TUploadedFile(Instance).FieldName;
end;

procedure TFpHttpServImport.UploadedFile_FieldNameSet(Instance: Pointer;
  AValue: Variant);
begin
  TUploadedFile(Instance).FieldName := AValue;
end;

function TFpHttpServImport.UploadedFile_FileNameGet(Instance: Pointer): Variant;
begin
  Result := TUploadedFile(Instance).FileName;
end;

procedure TFpHttpServImport.UploadedFile_FileNameSet(Instance: Pointer;
  AValue: Variant);
begin
  TUploadedFile(Instance).FileName := AValue;
end;

function TFpHttpServImport.UploadedFile_LocalFileNameGet(Instance: Pointer
  ): Variant;
begin
  Result := TUploadedFile(Instance).LocalFileName;
end;

procedure TFpHttpServImport.UploadedFile_LocalFileNameSet(Instance: Pointer;
  AValue: Variant);
begin
  TUploadedFile(Instance).LocalFileName := AValue;
end;

function TFpHttpServImport.UploadedFile_SizeGet(Instance: Pointer): Variant;
begin
  Result := TUploadedFile(Instance).Size;
end;

procedure TFpHttpServImport.UploadedFile_SizeSet(Instance: Pointer;
  AValue: Variant);
begin
  TUploadedFile(Instance).Size := AValue;
end;

function TFpHttpServImport.UploadedFile_StreamGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TUploadedFile(Instance).Stream );
end;

procedure TFpHttpServImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TCookie).ClassImporter := Self;
  AddClass(TCookies).ClassImporter := Self;
  AddClass(TUploadedFile).ClassImporter := Self;
  AddClass(TUploadedFiles).ClassImporter := Self;
  AddClass(THttpHeader).ClassImporter := Self;
  AddClass(TRequest).ClassImporter := Self;
  AddClass(TResponse).ClassImporter := Self;
  AddClass(TFPHTTPConnectionRequest);
  AddClass(TFPHTTPConnectionResponse);
  AddClass(TFPCustomHttpServer);
  AddClass(TFPHTTPServer).ClassImporter := Self;
  AddClass(TFPHTTPConnection).ClassImporter := Self;
  AddClass(TFPHTTPConnectionThread).ClassImporter := Self;
  AddClass(THTTPServerThread).ClassImporter := Self;
  AddClass(TFPCustomHTTPClient).ClassImporter := Self;
  AddClass(TFPHTTPClient).ClassImporter := Self;
end;

procedure TFpHttpServImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TSameSite));
  AddType(TypeInfo(THeader));
  AddType(TypeInfo(THeaders));
  AddType(TypeInfo(THTTPVariableType));
  AddType(TypeInfo(THTTPVariableTypes));
  //AddType(TypeInfo());
end;

procedure TFpHttpServImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TCookie then
  begin
    AType.AddMethod('procedure Expire', @FpHttpServ_Expire);
    AType.AddProp('Name', 'string', @Cookie_NameGet, @Cookie_NameSet);
    AType.AddProp('Value', 'string', @Cookie_ValueGet, @Cookie_ValueSet);
    AType.AddProp('Domain', 'string', @Cookie_DomainGet, @Cookie_DomainSet);
    AType.AddProp('Path', 'string', @Cookie_PathGet, @Cookie_PathSet);
    AType.AddProp('Expires', 'TDateTime', @Cookie_ExpiresGet, @Cookie_ExpiresSet);
    AType.AddProp('Secure', 'Boolean', @Cookie_SecureGet, @Cookie_SecureSet);
    AType.AddProp('HttpOnly', 'Boolean', @Cookie_HttpOnlyGet, @Cookie_HttpOnlySet);
    AType.AddProp('SameSite', 'TSameSite', @Cookie_SameSiteGet, @Cookie_SameSiteSet);
    AType.AddProp('AsString', 'string', @Cookie_AsStringGet);
  end
  else
  if AType.ValueClassType = TCookies then
  begin
    AType.AddMethod('function  Add: TCookie', @Cookies_Add);
    AType.AddMethod('function CookieByName(AName : String) : TCookie', @Cookies_CookieByName);
    AType.AddMethod('function FindCookie(AName : String): TCookie', @Cookies_FindCookie);
    AType.AddMethod('function IndexOfCookie(AName : String) : Integer', @Cookies_IndexOfCookie);
    AType.AddIndexedProp('Items', 'TCookie', 'Integer', @Cookie_ItemsGet, @Cookie_ItemsSet);
  end
  else
  if AType.ValueClassType = TUploadedFile then
  begin
    AType.AddProp('FieldName', 'string', @UploadedFile_FieldNameGet, @UploadedFile_FieldNameSet);
    AType.AddProp('FileName', 'string', @UploadedFile_FileNameGet, @UploadedFile_FileNameSet);
    AType.AddProp('Stream', 'TStream', @UploadedFile_StreamGet);
    AType.AddProp('Size', 'Int64', @UploadedFile_SizeGet, @UploadedFile_SizeSet);
    AType.AddProp('ContentType', 'string', @UploadedFile_ContentTypeGet, @UploadedFile_ContentTypeSet);
    AType.AddProp('Disposition', 'string', @UploadedFile_DispositionGet, @UploadedFile_DispositionSet);
    AType.AddProp('LocalFileName', 'string', @UploadedFile_LocalFileNameGet, @UploadedFile_LocalFileNameSet);
    AType.AddProp('Description', 'string', @UploadedFile_DescriptionGet, @UploadedFile_DescriptionSet);
  end
  else
  if AType.ValueClassType = TUploadedFiles then
  begin
    AType.AddMethod('function First : TUploadedFile', @UploadedFiles_First);
    AType.AddMethod('function Last : TUploadedFile', @UploadedFiles_Last);
    AType.AddMethod('function IndexOfFile(AName : String) : Integer', @UploadedFiles_IndexOfFile);
    AType.AddMethod('function FileByName(AName : String) : TUploadedFile', @UploadedFiles_FileByName);
    AType.AddMethod('function FindFile(AName : String) : TUploadedFile', @UploadedFiles_FindFile);
    AType.AddIndexedProp('Files', 'TUploadedFile', 'Integer', @UploadedFiles_FilesGet, @UploadedFiles_FilesSet);
  end
  else
  if AType.ValueClassType = THTTPHeader then
  begin
    AType.AddMethod('constructor Create', @HTTPHeader_Create);
    AType.AddMethod('function HeaderIsSet(AHeader : THeader) : Boolean', @HTTPHeader_HeaderIsSet);
    AType.AddMethod('function GetHeader(AHeader : THeader) : String', @HTTPHeader_GetHeader);
    AType.AddMethod('Procedure SetHeader(AHeader : THeader; Const AValue : String)', @HTTPHeader_SetHeader);
    AType.AddMethod('function LoadFromStream(Stream : TStream; IncludeCommand : Boolean) : integer', @HTTPHeader_LoadFromStream);
    AType.AddMethod('function LoadFromStrings(Strings: TStrings; IncludeCommand : Boolean) : integer', @HTTPHeader_LoadFromStrings);
    AType.AddProp('FieldCount', 'Integer', @HTTPHeader_FieldCountGet);

    AType.AddIndexedProp('Fields', 'Integer', 'string', @HTTPHeader_FieldsGet);
    AType.AddIndexedProp('FieldNames', 'Integer', 'string', @HTTPHeader_FieldNamesGet);
    AType.AddIndexedProp('FieldValues', 'Integer', 'string', @HTTPHeader_FieldValuesGet);

    AType.AddProp('Accept', 'string', @HTTPHeader_AcceptGet, @HTTPHeader_AcceptSet);
    AType.AddProp('AcceptCharset', 'string', @HTTPHeader_AcceptCharsetGet, @HTTPHeader_AcceptCharsetSet);
    AType.AddProp('AcceptEncoding', 'string', @HTTPHeader_AcceptEncodingGet, @HTTPHeader_AcceptEncodingSet);
    AType.AddProp('AcceptLanguage', 'string', @HTTPHeader_AcceptLanguageGet, @HTTPHeader_AcceptLanguageSet);
    AType.AddProp('Authorization', 'string', @HTTPHeader_AuthorizationGet, @HTTPHeader_AuthorizationSet);
    AType.AddProp('Connection', 'string', @HTTPHeader_ConnectionGet, @HTTPHeader_ConnectionSet);
    AType.AddProp('ContentEncoding', 'string', @HTTPHeader_ContentEncodingGet, @HTTPHeader_ContentEncodingSet);
    AType.AddProp('ContentLanguage', 'string', @HTTPHeader_ContentLanguageGet, @HTTPHeader_ContentLanguageSet);
    AType.AddProp('ContentLength', 'Integer', @HTTPHeader_ContentLengthGet, @HTTPHeader_ContentLengthSet);
    AType.AddProp('ContentType', 'string', @HTTPHeader_ContentTypeGet, @HTTPHeader_ContentTypeSet);
    AType.AddProp('Date', 'string', @HTTPHeader_DateGet, @HTTPHeader_DateSet);
    AType.AddProp('Expires', 'string', @HTTPHeader_ExpiresGet, @HTTPHeader_ExpiresSet);
    AType.AddProp('From', 'string', @HTTPHeader_FromGet, @HTTPHeader_FromSet);
    AType.AddProp('Host', 'string', @HTTPHeader_HostGet, @HTTPHeader_HostSet);
    AType.AddProp('IfModifiedSince', 'string', @HTTPHeader_IfModifiedSinceGet, @HTTPHeader_IfModifiedSinceSet);
    AType.AddProp('LastModified', 'string', @HTTPHeader_LastModifiedGet, @HTTPHeader_LastModifiedSet);
    AType.AddProp('Location', 'string', @HTTPHeader_LocationGet, @HTTPHeader_LocationSet);
    AType.AddProp('Pragma', 'string', @HTTPHeader_PragmaGet, @HTTPHeader_PragmaSet);
    AType.AddProp('Referer', 'string', @HTTPHeader_RefererGet, @HTTPHeader_RefererSet);
    AType.AddProp('RetryAfter', 'string', @HTTPHeader_RetryAfterGet, @HTTPHeader_RetryAfterSet);
    AType.AddProp('Server', 'string', @HTTPHeader_ServerGet, @HTTPHeader_ServerSet);
    AType.AddProp('UserAgent', 'string', @HTTPHeader_UserAgentGet, @HTTPHeader_UserAgentSet);
    AType.AddProp('Warning', 'string', @HTTPHeader_WarningGet, @HTTPHeader_WarningSet);
    AType.AddProp('WWWAuthenticate', 'string', @HTTPHeader_WWWAuthenticateGet, @HTTPHeader_WWWAuthenticateSet);
    AType.AddProp('Via', 'string', @HTTPHeader_ViaGet, @HTTPHeader_ViaSet);
    AType.AddProp('HTTPAccept', 'string', @HTTPHeader_HTTPAcceptGet, @HTTPHeader_HTTPAcceptSet);
    AType.AddProp('HTTPAcceptCharset', 'string', @HTTPHeader_HTTPAcceptCharsetGet, @HTTPHeader_HTTPAcceptCharsetSet);
    AType.AddProp('HTTPAcceptEncoding', 'string', @HTTPHeader_HTTPAcceptEncodingGet, @HTTPHeader_HTTPAcceptEncodingSet);
    AType.AddProp('HTTPIfModifiedSince', 'string', @HTTPHeader_HTTPIfModifiedSinceGet, @HTTPHeader_HTTPIfModifiedSinceSet);
    AType.AddProp('HTTPReferer', 'string', @HTTPHeader_HTTPRefererGet, @HTTPHeader_HTTPRefererSet);
    AType.AddProp('HTTPUserAgent', 'string', @HTTPHeader_HTTPUserAgentGet, @HTTPHeader_HTTPUserAgentSet);
    AType.AddProp('Cookie', 'string', @HTTPHeader_CookieGet, @HTTPHeader_CookieSet);
    AType.AddProp('SetCookie', 'string', @HTTPHeader_SetCookieGet, @HTTPHeader_SetCookieSet);
    AType.AddProp('HTTPXRequestedWith', 'string', @HTTPHeader_HTTPXRequestedWithGet, @HTTPHeader_HTTPXRequestedWithSet);
    AType.AddProp('HttpVersion', 'string', @HTTPHeader_HttpVersionGet, @HTTPHeader_HttpVersionSet);
    AType.AddProp('ProtocolVersion', 'string', @HTTPHeader_ProtocolVersionGet, @HTTPHeader_ProtocolVersionSet);
    AType.AddProp('PathInfo', 'string', @HTTPHeader_PathInfoGet, @HTTPHeader_PathInfoSet);
    AType.AddProp('PathTranslated', 'string', @HTTPHeader_PathTranslatedGet, @HTTPHeader_PathTranslatedSet);
    AType.AddProp('RemoteAddress', 'string', @HTTPHeader_RemoteAddressGet, @HTTPHeader_RemoteAddressSet);
    AType.AddProp('RemoteAddr', 'string', @HTTPHeader_RemoteAddrGet, @HTTPHeader_RemoteAddrSet);
    AType.AddProp('RemoteHost', 'string', @HTTPHeader_RemoteHostGet, @HTTPHeader_RemoteHostSet);
    AType.AddProp('ScriptName', 'string', @HTTPHeader_ScriptNameGet, @HTTPHeader_ScriptNameSet);
    AType.AddProp('ServerPort', 'string', @HTTPHeader_ServerPortGet, @HTTPHeader_ServerPortSet);
    AType.AddProp('HTTPMethod', 'string', @HTTPHeader_MethodGet, @HTTPHeader_MethodSet);
    AType.AddProp('URL', 'string', @HTTPHeader_URLGet, @HTTPHeader_URLSet);
    AType.AddProp('Query', 'string', @HTTPHeader_QueryGet, @HTTPHeader_QuerySet);
    AType.AddProp('Content', 'string', @HTTPHeader_ContentGet, @HTTPHeader_ContentSet);

    AType.AddProp('CookieFields','TStrings', @HTTPHeader_CookieFieldsGet, @HTTPHeader_CookieFieldsSet);
    AType.AddProp('ContentFields','TStrings', @HTTPHeader_ContentFieldsGet);
    AType.AddProp('QueryFields','TStrings', @HTTPHeader_QueryFieldsGet);
    AType.AddProp('CustomHeaders','TStringList', @HTTPHeader_CustomHeadersGet);
  end
  else
  if AType.ValueClassType = TRequest then
  begin
    AType.AddMethod('constructor Create', @Request_Create);
    AType.AddMethod('function GetNextPathInfo: String', @Request_GetNextPathInfo);
    AType.AddIndexedProp('RouteParams', 'string', 'string', @Request_RouteParamsGet, @Request_RouteParamsSet);
    AType.AddProp('ReturnedPathInfo', 'string', @Request_ReturnedPathInfoGet, @Request_ReturnedPathInfoSet);
    AType.AddProp('LocalPathPrefix', 'string', @Request_LocalPathPrefixGet);
    AType.AddProp('CommandLine', 'string', @Request_CommandLineGet);
    AType.AddProp('Command', 'string', @Request_CommandGet);
    AType.AddProp('URI', 'string', @Request_URIGet, @Request_URISet);
    AType.AddProp('QueryString', 'string', @Request_QueryStringGet, @Request_QueryStringSet);
    AType.AddProp('HeaderLine', 'string', @Request_HeaderLineGet);
    AType.AddProp('Files', 'TUploadedFiles', @Request_FilesGet);
    AType.AddProp('HandleGetOnPost', 'Boolean', @Request_HandleGetOnPostGet, @Request_HandleGetOnPostSet);
    AType.AddProp('IfMatch', 'string', @Request_IfMatchGet, @Request_IfMatchSet);
    AType.AddProp('IfNoneMatch', 'string', @Request_IfNoneMatchGet, @Request_IfNoneMatchSet);
    AType.AddProp('IfRange', 'string', @Request_IfRangeGet, @Request_IfRangeSet);
    AType.AddProp('IfUnModifiedSince', 'string', @Request_IfUnModifiedSinceGet, @Request_IfUnModifiedSinceSet);
    AType.AddProp('ContentRange', 'string', @Request_ContentRangeGet, @Request_ContentRangeSet);
    AType.AddProp('TE', 'string', @Request_TEGet, @Request_TESet);
    AType.AddProp('Upgrade', 'string', @Request_UpgradeGet, @Request_UpgradeSet);
  end
  else
  if AType.ValueClassType = TResponse then
  begin
    AType.AddMethod('constructor Create(ARequest : TRequest)', @Response_Create);
    AType.AddMethod('procedure SendContent', @Response_SendContent);
    AType.AddMethod('procedure SendHeaders', @Response_SendHeaders);
    AType.AddMethod('procedure SendResponse', @Response_SendResponse);
    AType.AddMethod('procedure SendRedirect(const TargetURL:String)', @Response_SendRedirect);
    AType.AddProp('Request', 'TRequest', @Response_RequestGet);
    AType.AddProp('Code', 'Integer', @Response_CodeGet, @Response_CodeSet);
    AType.AddProp('CodeText', 'string', @Response_CodeTextGet, @Response_CodeTextSet);
    AType.AddProp('Age', 'string', @Response_AgeGet, @Response_AgeSet);
    AType.AddProp('Allow', 'string', @Response_AllowGet, @Response_AllowSet);
    AType.AddProp('CacheControl', 'string', @Response_CacheControlGet, @Response_CacheControlSet);
    AType.AddProp('ContentLocation', 'string', @Response_ContentLocationGet, @Response_ContentLocationSet);
    AType.AddProp('ContentMD5', 'string', @Response_ContentMD5Get, @Response_ContentMD5Set);
    AType.AddProp('ContentRange', 'string', @Response_ContentRangeGet, @Response_ContentRangeSet);
    AType.AddProp('ETag', 'string', @Response_ETagGet, @Response_ETagSet);
    AType.AddProp('ProxyAuthenticate', 'string', @Response_ProxyAuthenticateGet, @Response_ProxyAuthenticateSet);
    AType.AddProp('RetryAfter', 'string', @Response_RetryAfterGet, @Response_RetryAfterSet);
    AType.AddProp('FirstHeaderLine', 'string', @Response_FirstHeaderLineGet, @Response_FirstHeaderLineSet);
    AType.AddProp('ContentStream', 'TStream', @Response_ContentStreamGet, @Response_ContentStreamSet);
    AType.AddProp('Content', 'string', @Response_ContentGet, @Response_ContentSet);
    AType.AddProp('Contents', 'TStrings', @Response_ContentsGet, @Response_ContentsSet);
    AType.AddProp('HeadersSent', 'Boolean', @Response_HeadersSentGet);
    AType.AddProp('ContentSent', 'Boolean', @Response_ContentSentGet);
    AType.AddProp('Cookies', 'TCookies', @Response_CookiesGet);
    AType.AddProp('FreeContentStream', 'Boolean', @Response_FreeContentStreamGet, @Response_FreeContentStreamSet);
  end
  else
  if AType.ValueClassType = TFPHTTPServer then
  begin
    AType.AddMethod('constructor Create(AOwner : TComponent)', @FPHTTPServer_Create);
  end
  else
  if AType.ValueClassType = THTTPServerThread then
  begin
    AType.AddMethod('constructor Create(APort: Word)', @HTTPServerThread_Create);
    AType.AddMethod('procedure Execute', @HTTPServerThread_Execute);
    //AType.AddMethod('procedure DoTerminate', @HTTPServerThread_DoTerminate);
    AType.AddMethod('procedure Terminate', @HTTPServerThread_Terminate);
    AType.AddProp('Server', 'TFPHTTPServer', @HTTPServerThread_Server);
  end
  else
  if AType.ValueClassType = TFPCustomHTTPClient then
  begin
    AType.AddMethod('procedure AddHeaderExt(HTTPHeaders: TStrings; Const AHeader, AValue : String)', @CustomHTTPClient_AddHeaderExt);
    AType.AddMethod('function IndexOfHeaderExt(HTTPHeaders: TStrings; Const AHeader : String) : Integer', @CustomHTTPClient_IndexOfHeaderExt);
    AType.AddMethod('function GetHeaderExt(HTTPHeaders: TStrings; Const AHeader : String) : String', @CustomHTTPClient_GetHeaderExt);
    AType.AddMethod('procedure Terminate', @CustomHTTPClient_Terminate);
    AType.AddMethod('function IndexOfHeader(Const AHeader: String) : Integer', @CustomHTTPClient_IndexOfHeader);
    AType.AddMethod('procedure AddHeader(Const AHeader, AValue: String)', @CustomHTTPClient_AddHeader);
    AType.AddMethod('function  GetHeader(Const AHeader: String) : String', @CustomHTTPClient_GetHeader);
    AType.AddMethod('procedure HTTPMethod(Const AMethod, AURL: String; Stream : TStream; Const AllowedResponseCodes: Array of Integer)', @CustomHTTPClient_HTTPMethod);
    AType.AddMethod('procedure Get(Const AURL: String; Stream: TStream)', @CustomHTTPClient_Get);
    AType.AddMethod('procedure Post(const URL: string; const Response: TStream)', @CustomHTTPClient_Post);
    AType.AddMethod('procedure Put(const URL: string; const Response: TStream)', @CustomHTTPClient_Put);
    AType.AddMethod('procedure Delete(const URL: string; const Response: TStream)', @CustomHTTPClient_Delete);
    AType.AddMethod('procedure Options(const URL: string; const Response: TStream)', @CustomHTTPClient_Options);
    AType.AddMethod('procedure Head(AURL: String; Headers: TStrings)', @CustomHTTPClient_Head);
    AType.AddMethod('procedure FormPost(const URL: string; FormData: TStrings; const Response: TStream)', @CustomHTTPClient_FormPost);
    AType.AddMethod('procedure FileFormPost(const AURL: string; FormData: TStrings; AFieldName, AFileName: string; const Response: TStream)', @CustomHTTPClient_FileFormPost);
    AType.AddMethod('Procedure StreamFormPost(const AURL: string; FormData: TStrings; const AFieldName, AFileName: string; const AStream: TStream; const Response: TStream)', @CustomHTTPClient_StreamFormPost);
    AType.AddProp('Terminated', 'Boolean', @CustomHTTPClient_TerminatedGet);
  end
  else
  if AType.ValueClassType = TFPHTTPClient then
  begin
    AType.AddMethod('constructor Create(AOwner: TComponent)', @fpHTTPClient_Create);
  end;
  //AType.AddMethod('', @Class_Method);
  //AType.AddProp('', '', @Class_PropGet, @Class_PropSet);
end;

procedure TFpHttpServImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(THTTPServerRequestHandler), TDpHTTPServerRequestHandler);
end;

end.

