{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit AppConst;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Graphics;

var
  AppDir: string;
  LangID: Integer;
  IntfIconSize: Integer;

const
  BaseLanguage = 'PASCAL';
  ALterLanguage = 'DPASCAL';

var
  AppVersion: string = '';
  VMajor: Integer = 0;
  VMinor: Integer = 0;
  VRevision: Integer = 0;


procedure SetVersion(AFileName: string; out AVersion: string; out aMajor, aMinor, aRevizion: Integer);

implementation

uses versionresource, resource, Forms, LazUTF8
 {$IFDEF WINDOWS}
  , winpeimagereader
{$ENDIF}
{$IFDEF LINUX}
  , elfreader
{$ENDIF} ;

procedure SetVersion(AFileName: string; out AVersion: string; out aMajor, aMinor, aRevizion: Integer);
var
  Res: TResources;
  i: Integer;
  Reader: TAbstractResourceReader;
  V: TVersionResource;
  FValid: Boolean;
  FValues, SL: TStringList;
  //FirstTime, LastTime, Delta: LongWord;

  procedure DoVersionInfo;
  var
    i,j:integer;
  begin
    for i:=0 to V.StringFileInfo.Count-1 do
    begin
      for j:=0 to V.StringFileInfo[i].Count-1 do
        FValues.Values[V.StringFileInfo[i].Keys[j]]:=SysToUTF8(V.StringFileInfo[i].ValuesByIndex[j]);
    end;
  end;

begin
  //FirstTime := GetTickCount;
  Reader := nil;
  {$IFDEF WINDOWS}
  Reader := TWinPEImageResourceReader.Create;
  {$ENDIF}
  {$IFDEF LINUX}
  Reader := TElfResourceReader.Create;
  {$ENDIF}

  if Reader = nil then Exit;

  Res := TResources.Create;
  V:=nil;
  FValues := TStringList.Create;
  SL := TStringList.Create;
  try
    Res.LoadFromFile(AFileName, Reader);
    for i:=0 to Res.Count-1 do
    begin
      if Res[i] is TVersionResource then
        V:=Res[i] as TVersionResource;
    end;
    FValid := Assigned(V);
    if FValid then
      DoVersionInfo();

     AVersion := FValues.Values['FileVersion'];
     SL.Delimiter:='.';
     SL.DelimitedText := AppVersion;
     if SL.Count >= 2 then
     begin
       aMajor:= StrToInt(SL.Strings[0]);
       aMinor:= StrToInt(SL.Strings[1]);
       aRevizion:=StrToInt(SL.Strings[2]);;
     end;
     //LastTime:= GetTickCount;
     //Delta := LastTime - FirstTime;

  finally
    Res.Free;
    Reader.Free;
    FValues.Free;
    SL.Free;
  end;

end;

initialization
  LangID := 0;
  IntfIconSize := 0;

end.

