unit SuMyDac;

interface

uses SysUtils, Classes, dpCompil, TypInfo, Variants;

{$I visualtech.inc}
{$M+}

type
  TMyDacImport = class(TClassImporter)
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    //procedure AddConsts(AddConst: TAddConstProc); override;
    //procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
    //procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
  published

    {TCustomDAConnection}
    function CustomDAConnection_Connect(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_Disconnect(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_PerformConnect(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_AssignConnect(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ParamByName(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ExecSQL(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ExecSQLEx(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ExecProc(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ExecProcEx(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_GetTableNames(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_GetDatabaseNames(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_GetStoredProcNames(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_StartTransaction(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_Commit(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_Rollback(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_ApplyUpdates(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_RemoveFromPool(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_MonitorMessage(Instence: TObject; var Params: Variant): Variant;
    function CustomDAConnection_InTransaction(Instence: Pointer): Variant;

    //MyConnection
    function MyConnection_Open(Instence: TObject; var Params: Variant): Variant;
    function MyConnection_Close(Instence: TObject; var Params: Variant): Variant;

    {TBlob}
    function Blob_Create(Instence: TObject; var Params: Variant): Variant;
    function Blob_FreeBlob(Instence: TObject; var Params: Variant): Variant;
    function Blob_IsEmpty(Instence: TObject; var Params: Variant): Variant;
    function Blob_Compress(Instence: TObject; var Params: Variant): Variant;
    function Blob_Defrag(Instence: TObject; var Params: Variant): Variant;
    function Blob_AddCR(Instence: TObject; var Params: Variant): Variant;
    function Blob_RemoveCR(Instence: TObject; var Params: Variant): Variant;
    function Blob_LoadFromStream(Instence: TObject; var Params: Variant): Variant;
    function Blob_SaveToStream(Instence: TObject; var Params: Variant): Variant;
    function Blob_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
    function Blob_SaveToFile(Instence: TObject; var Params: Variant): Variant;
    function Blob_Assign(Instence: TObject; var Params: Variant): Variant;
    function Blob_EnableRollback(Instence: TObject; var Params: Variant): Variant;
    function Blob_Commit(Instence: TObject; var Params: Variant): Variant;
    function Blob_Cancel(Instence: TObject; var Params: Variant): Variant;
    function Blob_CanRollback(Instence: TObject; var Params: Variant): Variant;
    function Blob_SizeGet(Instence: Pointer): Variant;
    procedure Blob_SizeSet(Instence: Pointer; AValue: Variant);
    function Blob_AsStringGet(Instence: Pointer): Variant;
    procedure Blob_AsStringSet(Instence: Pointer; AValue: Variant);
    function Blob_RollbackEnabledGet(Instence: Pointer): Variant;
    procedure Blob_RollbackEnabledSet(Instence: Pointer; AValue: Variant);
    function Blob_GetUseRollback(Instence: Pointer): Variant;
    procedure Blob_SetUseRollback(Instence: Pointer; AValue: Variant);

    {TMemDataSet}
    function MemDataSet_Prepare(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_UnPrepare(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_CheckPrepared(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_DeferredPost(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_CommitUpdates(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_CancelUpdates(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_RestoreUpdates(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_RevertRecord(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_SaveToXML(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_IsSequenced(Instence: TObject; var Params: Variant): Variant;
    function MemDataSet_GetBlob(Instence: TObject; var Params: Variant): Variant;

    //TCustomDADataSet
    function MyQuery_Disconnected_Get(Instance: Pointer): Variant;
    function MyQuery_ParamCount_Get(Instance: Pointer): Variant;
    function MyQuery_MacroCount_Get(Instance: Pointer): Variant;
    function MyQuery_Lock(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_UnLock(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_Execute(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_ExecSQL(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_Executing(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_Fetching(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_FetchingAll(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_Fetched(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_BreakExec(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_RefreshRecord(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_SaveSQL(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_RestoreSQL(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_SQLSaved(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_AddWhere(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_DeleteWhere(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_SetOrderBy(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_GetOrderBy(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_DeferredPost(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_MacroByName(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_ParamByName(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_FindParam(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_FindMacro(Instence: TObject; var Params: Variant): Variant;

    //TCustomMyQuery
    function MyQuery_InsertId_Get(Instance: Pointer): Variant;
    function MyQuery_LockTable(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_UnLockTable(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_OpenNext(Instence: TObject; var Params: Variant): Variant;
    function MyQuery_RefreshQuick(Instence: TObject; var Params: Variant): Variant;

    //TCustomMyStoredProc
    function MyStoredProc_ExecProc(Instence: TObject; var Params: Variant): Variant;

    //TCustomDASQL
    function CustomDASQL_Prepare(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_UnPrepare(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_ParamByName(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_FindParam(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_FindMacro(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_Execute(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_ExecuteIters(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_Executing(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_WaitExecuting(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_MacroByName(Instence: TObject; var Params: Variant): Variant;
    function CustomDASQL_Prepared(Instence: Pointer): Variant;

    //TMyCommand
    function MyCommand_InsertId_Get(Instance: Pointer): Variant;
    function MyCommand_BreakExec(Instence: TObject; var Params: Variant): Variant;

    //TCustomDAUpdateSQL
    function CustomDAUpdateSQL_Apply(Instence: TObject; var Params: Variant): Variant;
    function CustomDAUpdateSQL_ExecSQL(Instence: TObject; var Params: Variant): Variant;

    //TDAMetaData
    function DAMetaData_GetMetaDataKinds(Instence: TObject; var Params: Variant): Variant;
    function DAMetaData_GetRestrictions(Instence: TObject; var Params: Variant): Variant;

    //TMySCript
    function MyScript_Execute(Instence: TObject; var Params: Variant): Variant;
    function MyScript_ExecuteNext(Instence: TObject; var Params: Variant): Variant;
    function MyScript_ExecuteStream(Instence: TObject; var Params: Variant): Variant;
    function MyScript_ExecuteFile(Instence: TObject; var Params: Variant): Variant;
    function MyScript_BreakExec(Instence: TObject; var Params: Variant): Variant;
    function MyScript_ErrorOffset(Instence: TObject; var Params: Variant): Variant;

    function MyScript_ParamsGet(Instance: Pointer): Variant;
    function MyScript_AutoCommitGet(Instance: Pointer): Variant;
    procedure MyScript_AutoCommitSet(Instance: Pointer; AValue: Variant);
    function MyScript_StartPosGet(Instance: Pointer): Variant;
    function MyScript_EndPosGet(Instance: Pointer): Variant;
    function MyScript_StartLineGet(Instance: Pointer): Variant;
    function MyScript_EndLineGet(Instance: Pointer): Variant;
    function MyScript_StartOffsetGet(Instance: Pointer): Variant;
    function MyScript_EndOffsetGet(Instance: Pointer): Variant;

  end;

implementation

uses MyAccess, MyDacVCL, DBAccess, DB, MemDS, MyEmbConnection, MyScript,
  DAScript, MySQLMonitor, DASQLMonitor, MemData;

type
  TOnSQLMonitorHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Text: string; Flag: TDATraceFlag);
  end;


function TOnSQLMonitorHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnSQLMonitorHandler.CallHandler;
end;

procedure TOnSQLMonitorHandler.CallHandler(Sender: TObject; Text: string; Flag: TDATraceFlag);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Text;
  Proc.Param[2].Value := Flag;
  Proc.Exec;
end;

{TMyDacImport}

procedure TMyDacImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TOnSQLEvent), TOnSQLMonitorHandler);
end;

procedure TMyDacImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TMyIsolationLevel));
  AddType(TypeInfo(TLockType));
  AddType(TypeInfo(TLockRecordType));
  AddType(TypeInfo(TLockMode));
  AddType(TypeInfo(TRefreshOption));
  AddType(TypeInfo(TDATraceFlag));
  AddType(TypeInfo(TMonitorOptions));

  AddType(TCustomDADataSet.ClassInfo);
  AddType(TMyConnectionOptions.ClassInfo);
  AddType(TMySQLGenerator.ClassInfo);
  AddType(TMyConnectionSSLOptions.ClassInfo);
  AddType(TMyDataSetService.ClassInfo);
  AddType(TMyDataSetUpdater.ClassInfo);
  AddType(TMyDataSetOptions.ClassInfo);
  AddType(TMyTableOptions.ClassInfo);
  AddType(TMyTransaction.ClassInfo);
  AddType(TMyAccessUtils.ClassInfo);
  AddType(TMacros.ClassInfo);
  AddType(TMacro.ClassInfo);
  AddType(TDAParams.ClassInfo);
  AddType(TDAParam.ClassInfo);
  AddType(TDBMonitorOptions.ClassInfo);

  AddType(TCustomDAConnection.ClassInfo).ClassImporter := Self;
  AddType(TCustomMyConnection.ClassInfo).ClassImporter := Self;
  AddType(TMyConnection.ClassInfo);
  AddType(TBlob.ClassInfo).ClassImporter := Self;
  AddType(TMemDataSet.ClassInfo).ClassImporter := Self;
  AddType(TCustomDADataSet.ClassInfo).ClassImporter := Self;
  AddType(TCustomMyDataSet.ClassInfo).ClassImporter := Self;
  AddType(TMyQuery.ClassInfo);
  AddType(TMyTable.ClassInfo);
  AddType(TCustomMyStoredProc.ClassInfo).ClassImporter := Self;
  AddType(TMyStoredProc.ClassInfo);
  AddType(TCustomDASQL.ClassInfo).ClassImporter := Self;
  AddType(TMyCommand.ClassInfo).ClassImporter := Self;
  AddType(TMyScript.ClassInfo).ClassImporter := Self;
  AddType(TCustomDAUpdateSQL.ClassInfo).ClassImporter := Self;
  AddType(TMyUpdateSQL.ClassInfo);
  AddType(TMyDataSource.ClassInfo).ClassImporter := Self;
  AddType(TDAMetaData.ClassInfo).ClassImporter := Self;
  AddType(TMyMetaData.ClassInfo);
  //AddType(TMyEmbConnection.ClassInfo);
  AddType(TMyConnectDialog.ClassInfo);
  AddType(TMySQLMonitor.ClassInfo);
end;

procedure TMyDacImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TCustomDAConnection then
  begin
    AType.AddMethod('procedure Connect', CustomDAConnection_Connect);
    AType.AddMethod('procedure Disconnect', CustomDAConnection_Disconnect);
    AType.AddMethod('procedure PerformConnect(Retry: boolean = False)', CustomDAConnection_PerformConnect);
    AType.AddMethod('procedure AssignConnect(Source: TCustomDAConnection)', CustomDAConnection_AssignConnect);
    AType.AddMethod('function ParamByName(Name: string): TDAParam', CustomDAConnection_ParamByName);
    AType.AddMethod('function ExecSQL(Text: string; const Params: array of variant): variant', CustomDAConnection_ExecSQL);
    AType.AddMethod('function ExecSQLEx(Text: string; const Params: array of variant): variant', CustomDAConnection_ExecSQLEx);
    AType.AddMethod('function ExecProc(Name: string; const Params: array of variant): variant', CustomDAConnection_ExecProc);
    AType.AddMethod('function ExecProcEx(Name: string; const Params: array of variant): variant', CustomDAConnection_ExecProcEx);
    AType.AddMethod('procedure GetTableNames(List: TStrings; AllTables: boolean = False)', CustomDAConnection_GetTableNames);
    AType.AddMethod('procedure GetDatabaseNames(List: TStrings)', CustomDAConnection_GetDatabaseNames);
    AType.AddMethod('procedure GetStoredProcNames(List: TStrings; AllProcs: boolean = False)', CustomDAConnection_GetStoredProcNames);
    AType.AddMethod('procedure StartTransaction', CustomDAConnection_StartTransaction);
    AType.AddMethod('procedure Commit', CustomDAConnection_Commit);
    AType.AddMethod('procedure Rollback', CustomDAConnection_Rollback);
    AType.AddMethod('procedure ApplyUpdates', CustomDAConnection_ApplyUpdates);
    AType.AddMethod('procedure RemoveFromPool', CustomDAConnection_RemoveFromPool);
    AType.AddMethod('procedure MonitorMessage(const Msg: string)', CustomDAConnection_MonitorMessage);
    AType.AddProp('InTransaction', 'boolean', CustomDAConnection_InTransaction);
  end
  else
  if AType.ValueClassType = TCustomMyConnection then
  begin
    AType.AddMethod('procedure Open', MyConnection_Open);
    AType.AddMethod('procedure Close', MyConnection_Close);
  end
  else
  if AType.ValueClassType = TBlob then
  begin
    AType.AddMethod('constructor Create(IsUnicode: boolean = False)', Blob_Create);
    AType.AddMethod('procedure FreeBlob', Blob_FreeBlob);
    AType.AddMethod('function IsEmpty: boolean', Blob_IsEmpty);
    AType.AddMethod('procedure Compress', Blob_Compress);
    AType.AddMethod('procedure Defrag', Blob_Defrag);
    AType.AddMethod('procedure AddCR', Blob_AddCR);
    AType.AddMethod('procedure RemoveCR', Blob_RemoveCR);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', Blob_LoadFromStream);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', Blob_SaveToStream);
    AType.AddMethod('procedure LoadFromFile(const FileName: string)', Blob_LoadFromFile);
    AType.AddMethod('procedure SaveToFile(const FileName: string)', Blob_SaveToFile);
    AType.AddMethod('procedure Assign(Source: TBlob)', Blob_Assign);
    AType.AddMethod('procedure EnableRollback', Blob_EnableRollback);
    AType.AddMethod('procedure Commit', Blob_Commit);
    AType.AddMethod('procedure Cancel', Blob_Cancel);
    AType.AddMethod('function CanRollback: Boolean', Blob_CanRollback);
    AType.AddProp('Size', 'Cardinal', Blob_SizeGet, Blob_SizeSet);
    AType.AddProp('AsString', 'string', Blob_AsStringGet, Blob_AsStringSet);
    AType.AddProp('RollbackEnabled', 'boolean', Blob_RollbackEnabledGet, Blob_RollbackEnabledSet);
    AType.AddProp('UseRollback', 'boolean', Blob_GetUseRollback, Blob_SetUseRollback);
  end
  else
  if AType.ValueClassType = TMemDataSet then
  begin
    AType.AddMethod('procedure Prepare', MemDataSet_Prepare);
    AType.AddMethod('procedure UnPrepare', MemDataSet_UnPrepare);
    AType.AddMethod('procedure CheckPrepared', MemDataSet_CheckPrepared);
    AType.AddMethod('procedure DeferredPost', MemDataSet_DeferredPost);
    AType.AddMethod('procedure CommitUpdates', MemDataSet_CommitUpdates);
    AType.AddMethod('procedure CancelUpdates', MemDataSet_CancelUpdates);
    AType.AddMethod('procedure RestoreUpdates', MemDataSet_RestoreUpdates);
    AType.AddMethod('procedure RevertRecord', MemDataSet_RevertRecord);
    AType.AddMethod('procedure SaveToXML(const FileName: string)', MemDataSet_SaveToXML);
    AType.AddMethod('function IsSequenced: boolean', MemDataSet_IsSequenced);
    AType.AddMethod('function GetBlob(const FieldName: string): TBlob', MemDataSet_GetBlob);
  end
  else
  if AType.ValueClassType = TCustomDADataSet then
  begin
    AType.AddProp('Disconnected', 'Boolean', MyQuery_Disconnected_Get);
    AType.AddProp('ParamCount', 'Integer', MyQuery_ParamCount_Get);
    AType.AddProp('MacroCount', 'Integer', MyQuery_MacroCount_Get);

    AType.AddMethod('procedure Lock', MyQuery_Lock);
    AType.AddMethod('procedure UnLock', MyQuery_UnLock);
    AType.AddMethod('procedure Execute', MyQuery_Execute);
    AType.AddMethod('procedure ExecSQL', MyQuery_ExecSQL);
    AType.AddMethod('function Executing: Boolean', MyQuery_Executing);
    AType.AddMethod('function Fetching: Boolean', MyQuery_Fetching);
    AType.AddMethod('function FetchingAll: Boolean', MyQuery_FetchingAll);
    AType.AddMethod('function Fetched: Boolean', MyQuery_Fetched);
    AType.AddMethod('procedure BreakExec', MyQuery_BreakExec);
    AType.AddMethod('procedure RefreshRecord', MyQuery_RefreshRecord);
    AType.AddMethod('procedure SaveSQL', MyQuery_SaveSQL);
    AType.AddMethod('procedure RestoreSQL', MyQuery_RestoreSQL);
    AType.AddMethod('function SQLSaved: Boolean', MyQuery_SQLSaved);
    AType.AddMethod('procedure AddWhere(Condition: string)', MyQuery_AddWhere);
    AType.AddMethod('procedure DeleteWhere', MyQuery_DeleteWhere);
    AType.AddMethod('procedure SetOrderBy(Fields: string)', MyQuery_SetOrderBy);
    AType.AddMethod('function GetOrderBy: string', MyQuery_GetOrderBy);
    AType.AddMethod('procedure DeferredPost', MyQuery_DeferredPost);
    AType.AddMethod('function MacroByName(const Value: string): TMacro', MyQuery_MacroByName);
    AType.AddMethod('function ParamByName(const Value: string): TDAParam', MyQuery_ParamByName);
    AType.AddMethod('function PN(const Value: string): TDAParam', MyQuery_ParamByName);
    AType.AddMethod('function FindParam(const Value: string): TDAParam', MyQuery_FindParam);
    AType.AddMethod('function FindMacro(const Value: string): TMacro', MyQuery_FindMacro);
  end
  else
  if AType.ValueClassType = TCustomMyDataSet then
  begin
    AType.AddProp('InsertId', 'Int64', MyQuery_InsertId_Get);

    AType.AddMethod('procedure LockTable(LockType: TLockType)', MyQuery_LockTable);
    AType.AddMethod('procedure UnLockTable', MyQuery_UnLockTable);
    AType.AddMethod('function OpenNext: Boolean', MyQuery_OpenNext);
    AType.AddMethod('procedure RefreshQuick(const CheckDeleted: Boolean)', MyQuery_RefreshQuick);
  end
  else
  if AType.ValueClassType = TCustomMyStoredProc then
  begin
    AType.AddMethod('procedure ExecProc', MyStoredProc_ExecProc);
  end
  else
  if AType.ValueClassType = TCustomDASQL then
  begin
    AType.AddMethod('function ParamByName(const Value: string): TDAParam', CustomDASQL_ParamByName);
    AType.AddMethod('function PN(const Value: string): TDAParam', CustomDASQL_ParamByName);
    AType.AddMethod('function FindParam(const Value: string): TDAParam', CustomDASQL_FindParam);
    AType.AddMethod('procedure Prepare', CustomDASQL_Prepare);
    AType.AddMethod('procedure UnPrepare', CustomDASQL_UnPrepare);
    AType.AddMethod('procedure Execute', CustomDASQL_Execute);
    AType.AddMethod('procedure ExecuteIters(Iters: integer)', CustomDASQL_ExecuteIters);
    AType.AddMethod('function Executing: boolean', CustomDASQL_Executing);
    AType.AddMethod('function WaitExecuting(TimeOut: integer = 0): boolean', CustomDASQL_WaitExecuting);
    AType.AddMethod('function FindMacro(const Value: string): TMacro', CustomDASQL_FindMacro);
    AType.AddMethod('function MacroByName(const Value: string): TMacro', CustomDASQL_MacroByName);
    AType.AddProp('Prepared', 'boolean', CustomDASQL_Prepared);
  end
  else
  if AType.ValueClassType = TMyCommand then
  begin
    AType.AddProp('InsertId', 'Int64', MyCommand_InsertId_Get);
    AType.AddMethod('procedure BreakExec', MyCommand_BreakExec);
  end
  else
  if AType.ValueClassType = TCustomDAUpdateSQL then
  begin
    AType.AddMethod('procedure Apply(UpdateKind: TUpdateKind)', CustomDAUpdateSQL_Apply);
    AType.AddMethod('procedure ExecSQL(UpdateKind: TUpdateKind)', CustomDAUpdateSQL_ExecSQL);
  end
  else
  if AType.ValueClassType = TDAMetaData then
  begin
    AType.AddMethod('procedure GetMetaDataKinds(List: TStrings)', DAMetaData_GetMetaDataKinds);
    AType.AddMethod('procedure GetRestrictions(List: TStrings; const MetaDataKind: string)', DAMetaData_GetRestrictions);
  end
  else
  if AType.ValueClassType = TMyScript then
  begin
    AType.AddMethod('procedure Execute', MyScript_Execute);
    AType.AddMethod('function ExecuteNext: Boolean', MyScript_ExecuteNext);
    AType.AddMethod('procedure ExecuteStream(Stream: TStream)', MyScript_ExecuteStream);
    AType.AddMethod('procedure ExecuteFile(const FileName: string)', MyScript_ExecuteFile);
    AType.AddMethod('procedure BreakExec', MyScript_BreakExec);
    AType.AddMethod('function ErrorOffset: Int64', MyScript_ErrorOffset);

    AType.AddProp('Params', 'TDAParams', MyScript_ParamsGet);
    AType.AddProp('AutoCommit', 'Boolean', MyScript_AutoCommitGet, MyScript_AutoCommitSet);
    AType.AddProp('StartPos', 'Int64', MyScript_StartPosGet);
    AType.AddProp('EndPos', 'Int64', MyScript_EndPosGet);
    AType.AddProp('StartLine', 'Int64', MyScript_StartLineGet);
    AType.AddProp('EndLine', 'Int64', MyScript_EndLineGet);
    AType.AddProp('StartOffset', 'Int64', MyScript_StartOffsetGet);
    AType.AddProp('EndOffset', 'Int64', MyScript_EndOffsetGet);
  end;
end;

{TCustomDAConnection}

function TMyDacImport.CustomDAConnection_Connect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).Connect
end;

function TMyDacImport.CustomDAConnection_Disconnect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).Disconnect
end;

function TMyDacImport.CustomDAConnection_PerformConnect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).PerformConnect(Params[0]);
end;

function TMyDacImport.CustomDAConnection_AssignConnect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).AssignConnect(TCustomDAConnection(TSuPtr(Params[0])));
end;

function TMyDacImport.CustomDAConnection_ParamByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDAConnection(Instence).ParamByName(Params[0]))
end;

function TMyDacImport.CustomDAConnection_ExecSQL(Instence: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[1];
  Result := TCustomDAConnection(Instence).ExecSQL(Params[0], V)
end;

function TMyDacImport.CustomDAConnection_ExecSQLEx(Instence: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[1];
  Result := TCustomDAConnection(Instence).ExecSQLEx(Params[0], V)
end;

function TMyDacImport.CustomDAConnection_ExecProc(Instence: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[1];
  Result := TCustomDAConnection(Instence).ExecProc(Params[0], V)
end;

function TMyDacImport.CustomDAConnection_ExecProcEx(Instence: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[1];
  Result := TCustomDAConnection(Instence).ExecProcEx(Params[0], V)
end;

function TMyDacImport.CustomDAConnection_GetTableNames(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).GetTableNames(TStrings(TSuPtr(Params[0])), Params[1]);
end;

function TMyDacImport.CustomDAConnection_GetDatabaseNames(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).GetDatabaseNames(TStrings(TSuPtr(Params[0])));
end;

function TMyDacImport.CustomDAConnection_GetStoredProcNames(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).GetStoredProcNames(TSTrings(TSuPtr(Params[0])), Params[1]);
end;

function TMyDacImport.CustomDAConnection_StartTransaction(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).StartTransaction
end;

function TMyDacImport.CustomDAConnection_Commit(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).Commit
end;

function TMyDacImport.CustomDAConnection_Rollback(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).Rollback
end;

function TMyDacImport.CustomDAConnection_ApplyUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).ApplyUpdates
end;

function TMyDacImport.CustomDAConnection_RemoveFromPool(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).RemoveFromPool
end;

function TMyDacImport.CustomDAConnection_MonitorMessage(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAConnection(Instence).MonitorMessage(Params[0]);
end;

function TMyDacImport.CustomDAConnection_InTransaction(Instence: Pointer): Variant;
begin
  Result := TCustomDAConnection(Instence).InTransaction
end;

{TMyConnection}

function TMyDacImport.MyConnection_Open(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomMyConnection(Instence).Open
end;

function TMyDacImport.MyConnection_Close(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomMyConnection(Instence).Close
end;

{TBlob}
function TMyDacImport.Blob_Create(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TBlob(Instence).Create(Params[0]));
end;

function TMyDacImport.Blob_FreeBlob(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).FreeBlob
end;

function TMyDacImport.Blob_IsEmpty(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TBlob(Instence).IsEmpty
end;

function TMyDacImport.Blob_Compress(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Compress
end;

function TMyDacImport.Blob_Defrag(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Defrag
end;

function TMyDacImport.Blob_AddCR(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).AddCR
end;

function TMyDacImport.Blob_RemoveCR(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).RemoveCR
end;

function TMyDacImport.Blob_LoadFromStream(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).LoadFromStream(TStream(TSuPtr(Params[0])));
end;

function TMyDacImport.Blob_SaveToStream(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TMyDacImport.Blob_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).LoadFromFile(Params[0]);
end;

function TMyDacImport.Blob_SaveToFile(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).SaveToFile(Params[0]);
end;

function TMyDacImport.Blob_Assign(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Assign(TBlob(TSuPtr(Params[0])));
end;

function TMyDacImport.Blob_EnableRollback(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).EnableRollback
end;

function TMyDacImport.Blob_Commit(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Commit
end;

function TMyDacImport.Blob_Cancel(Instence: TObject; var Params: Variant): Variant;
begin
  TBlob(Instence).Cancel
end;

function TMyDacImport.Blob_CanRollback(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TBlob(Instence).CanRollback
end;

function TMyDacImport.Blob_SizeGet(Instence: Pointer): Variant;
begin
  Result := TBlob(Instence).Size
end;

procedure TMyDacImport.Blob_SizeSet(Instence: Pointer; AValue: Variant);
begin
  TBlob(Instence).Size := AValue
end;

function TMyDacImport.Blob_AsStringGet(Instence: Pointer): Variant;
begin
  Result := TBlob(Instence).AsString
end;

procedure TMyDacImport.Blob_AsStringSet(Instence: Pointer; AValue: Variant);
begin
  TBlob(Instence).AsString := AValue
end;

function TMyDacImport.Blob_RollbackEnabledGet(Instence: Pointer): Variant;
begin
  Result := TBlob(Instence).RollbackEnabled
end;

procedure TMyDacImport.Blob_RollbackEnabledSet(Instence: Pointer; AValue: Variant);
begin
  TBlob(Instence).RollbackEnabled := AValue
end;

function TMyDacImport.Blob_GetUseRollback(Instence: Pointer): Variant;
begin
  Result := TBlob(Instence).UseRollback
end;

procedure TMyDacImport.Blob_SetUseRollback(Instence: Pointer; AValue: Variant);
begin
  TBlob(Instence).UseRollback := AValue
end;

{TMemDataSet}

function TMyDacImport.MemDataSet_Prepare(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).Prepare
end;

function TMyDacImport.MemDataSet_UnPrepare(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).UnPrepare
end;

function TMyDacImport.MemDataSet_CheckPrepared(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).CheckPrepared
end;

function TMyDacImport.MemDataSet_DeferredPost(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).DeferredPost
end;

function TMyDacImport.MemDataSet_CommitUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).CommitUpdates
end;

function TMyDacImport.MemDataSet_CancelUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).CancelUpdates
end;

function TMyDacImport.MemDataSet_RestoreUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).RestoreUpdates
end;

function TMyDacImport.MemDataSet_RevertRecord(Instence: TObject; var Params: Variant): Variant;
begin
  TMemDataSet(Instence).RevertRecord
end;

function TMyDacImport.MemDataSet_SaveToXML(Instence: TObject; var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TMemDataSet(Instence).SaveToXML(S);
end;

function TMyDacImport.MemDataSet_IsSequenced(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TMemDataSet(Instence).IsSequenced
end;

function TMyDacImport.MemDataSet_GetBlob(Instence: TObject; var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TMemDataSet(Instence).GetBlob(S));
end;

{TCustomDADataSet}

function TMyDacImport.MyQuery_Disconnected_Get(Instance: Pointer): Variant;
begin
  Result := TCustomDADataSet(Instance).Disconnected
end;

function TMyDacImport.MyQuery_ParamCount_Get(Instance: Pointer): Variant;
begin
  Result := TCustomDADataSet(Instance).ParamCount
end;

function TMyDacImport.MyQuery_MacroCount_Get(Instance: Pointer): Variant;
begin
  Result := TCustomDADataSet(Instance).MacroCount
end;

function TMyDacImport.MyQuery_Lock(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).Lock
end;

function TMyDacImport.MyQuery_UnLock(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).UnLock
end;

function TMyDacImport.MyQuery_Execute(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).Execute
end;

function TMyDacImport.MyQuery_ExecSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).ExecSQL
end;

function TMyDacImport.MyQuery_Executing(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).Executing
end;

function TMyDacImport.MyQuery_Fetching(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).Fetching
end;

function TMyDacImport.MyQuery_FetchingAll(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).FetchingAll
end;

function TMyDacImport.MyQuery_Fetched(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).Fetched
end;

function TMyDacImport.MyQuery_BreakExec(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).BreakExec
end;

function TMyDacImport.MyQuery_RefreshRecord(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).RefreshRecord
end;

function TMyDacImport.MyQuery_SaveSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).SaveSQL
end;

function TMyDacImport.MyQuery_RestoreSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).RestoreSQL
end;

function TMyDacImport.MyQuery_SQLSaved(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).SQLSaved
end;

function TMyDacImport.MyQuery_AddWhere(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).AddWhere(Params[0]);
end;

function TMyDacImport.MyQuery_DeleteWhere(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).DeleteWhere
end;

function TMyDacImport.MyQuery_SetOrderBy(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).SetOrderBy(Params[0]);
end;

function TMyDacImport.MyQuery_GetOrderBy(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDADataSet(Instence).GetOrderBy
end;

function TMyDacImport.MyQuery_DeferredPost(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDADataSet(Instence).DeferredPost
end;

function TMyDacImport.MyQuery_MacroByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDADataSet(Instence).MacroByName(Params[0]))
end;

function TMyDacImport.MyQuery_ParamByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDADataSet(Instence).ParamByName(Params[0]))
end;

function TMyDacImport.MyQuery_FindParam(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDADataSet(Instence).FindParam(Params[0]));
end;

function TMyDacImport.MyQuery_FindMacro(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDADataSet(Instence).FindMacro(Params[0]));
end;

{TCustomMyDataSet}

function TMyDacImport.MyQuery_InsertId_Get(Instance: Pointer): Variant;
begin
  Result := TCustomMyDataSet(Instance).InsertId
end;

function TMyDacImport.MyQuery_LockTable(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomMyDataSet(Instence).LockTable(TLockType(TSuPtr(Params[0])));
end;

function TMyDacImport.MyQuery_UnLockTable(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomMyDataSet(Instence).UnLockTable
end;

function TMyDacImport.MyQuery_OpenNext(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomMyDataSet(Instence).OpenNext
end;

function TMyDacImport.MyQuery_RefreshQuick(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomMyDataSet(Instence).RefreshQuick(Params[0]);
end;

{TCustomMyStoredProc}

function TMyDacImport.MyStoredProc_ExecProc(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomMyStoredProc(Instence).ExecProc
end;

{TCustomDASQL}

function TMyDacImport.CustomDASQL_Prepare(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDASQL(Instence).Prepare
end;

function TMyDacImport.CustomDASQL_UnPrepare(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDASQL(Instence).UnPrepare
end;

function TMyDacImport.CustomDASQL_ParamByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDASQL(Instence).ParamByName(Params[0]))
end;

function TMyDacImport.CustomDASQL_FindParam(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDASQL(Instence).FindParam(Params[0]))
end;

function TMyDacImport.CustomDASQL_FindMacro(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDASQL(Instence).FindMacro(Params[0]))
end;

function TMyDacImport.CustomDASQL_Execute(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDASQL(Instence).Execute
end;

function TMyDacImport.CustomDASQL_ExecuteIters(Instence: TObject; var Params: Variant): Variant;
var
  I: Integer;
begin
  I := Params[0];
  TCustomDASQL(Instence).Execute(I);
end;

function TMyDacImport.CustomDASQL_Executing(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDASQL(Instence).Executing
end;

function TMyDacImport.CustomDASQL_WaitExecuting(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TCustomDASQL(Instence).WaitExecuting(Params[0])
end;

function TMyDacImport.CustomDASQL_MacroByName(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomDASQL(Instence).MacroByName(Params[0]));
end;

function TMyDacImport.CustomDASQL_Prepared(Instence: Pointer): Variant;
begin
   Result := TCustomDASQL(Instence).Prepared
end;

{TMyCommand}

function TMyDacImport.MyCommand_InsertId_Get(Instance: Pointer): Variant;
begin
  Result := TMyCommand(Instance).InsertId
end;

function TMyDacImport.MyCommand_BreakExec(Instence: TObject; var Params: Variant): Variant;
begin
  TMyCommand(Instence).BreakExec
end;

{TCustomDAUpdateSQL}

function TMyDacImport.CustomDAUpdateSQL_Apply(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAUpdateSQL(Instence).Apply(TUpdateKind(Params[0]));
end;

function TMyDacImport.CustomDAUpdateSQL_ExecSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomDAUpdateSQL(Instence).ExecSQL(TUpdateKind(Params[0]));
end;

{TDAMetaData}
function TMyDacImport.DAMetaData_GetMetaDataKinds(Instence: TObject; var Params: Variant): Variant;
begin
  TDAMetaData(Instence).GetMetaDataKinds(TStrings(TSuPtr(Params[0])));
end;

function TMyDacImport.DAMetaData_GetRestrictions(Instence: TObject; var Params: Variant): Variant;
begin
  TDAMetaData(Instence).GetRestrictions(TStrings(TSuPtr(Params[0])), Params[1]);
end;

{TMyScript}

function TMyDacImport.MyScript_Execute(Instence: TObject; var Params: Variant): Variant;
begin
  TMyScript(Instence).Execute
end;

function TMyDacImport.MyScript_ExecuteNext(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TMyScript(Instence).ExecuteNext
end;

function TMyDacImport.MyScript_ExecuteStream(Instence: TObject; var Params: Variant): Variant;
begin
  TMyScript(Instence).ExecuteStream(TStream(TSuPtr(Params[0])));
end;

function TMyDacImport.MyScript_ExecuteFile(Instence: TObject; var Params: Variant): Variant;
begin
  TMyScript(Instence).ExecuteFile(Params[0]);
end;

function TMyDacImport.MyScript_BreakExec(Instence: TObject; var Params: Variant): Variant;
begin
  TMyScript(Instence).BreakExec
end;

function TMyDacImport.MyScript_ErrorOffset(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TMyScript(Instence).ErrorOffset
end;


function TMyDacImport.MyScript_ParamsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TMyScript(Instance).Params)
end;

function TMyDacImport.MyScript_AutoCommitGet(Instance: Pointer): Variant;
begin
  Result := TMyScript(Instance).AutoCommit
end;

procedure TMyDacImport.MyScript_AutoCommitSet(Instance: Pointer; AValue: Variant);
begin
  TMyScript(Instance).AutoCommit := AValue
end;

function TMyDacImport.MyScript_StartPosGet(Instance: Pointer): Variant;
begin
  Result := TMyScript(Instance).StartPos
end;

function TMyDacImport.MyScript_EndPosGet(Instance: Pointer): Variant;
begin
  Result := TMyScript(Instance).EndPos
end;

function TMyDacImport.MyScript_StartLineGet(Instance: Pointer): Variant;
begin
  Result := TMyScript(Instance).StartLine
end;

function TMyDacImport.MyScript_EndLineGet(Instance: Pointer): Variant;
begin
  Result := TMyScript(Instance).EndLine
end;

function TMyDacImport.MyScript_StartOffsetGet(Instance: Pointer): Variant;
begin
  Result := TMyScript(Instance).StartOffset
end;

function TMyDacImport.MyScript_EndOffsetGet(Instance: Pointer): Variant;
begin
  Result := TMyScript(Instance).EndOffset
end;

end.
