unit dpi_WinApi;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpCompil, dpi_mettyps, winapiwrapper, LCLType;

type
  { TWinApiImport }

  TWinApiImport = class(TClassImporter)
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure AddObjects(AddObject: TAddObjectProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
  private
    function Call_WinApi(Instance: TObject; var Params: Variant): Variant;
    function Call_FindWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_FindWindowEx(Instance: TObject; var Params: Variant): Variant;
    function Call_SendMessage(Instance: TObject; var Params: Variant): Variant;
    function Call_PostMessage(Instance: TObject; var Params: Variant): Variant;
    function Call_BringWindowToTop(Instance: TObject; var Params: Variant): Variant;
    function Call_CloseWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_GetClassName(Instance: TObject; var Params: Variant): Variant;
    function Call_GetClientRectAsText(Instance: TObject; var Params: Variant): Variant;
    function Call_GetAncestor(Instance: TObject; var Params: Variant): Variant;
    function Call_GetDesktopWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_GetForegroundWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_GetParent(Instance: TObject; var Params: Variant): Variant;
    function Call_GetShellWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_GetTopWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_GetWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_GetWindowProcessId(Instance: TObject; var Params: Variant): Variant;
    function Call_GetWindowRectAsText(Instance: TObject; var Params: Variant): Variant;
    function Call_GetWindowText(Instance: TObject; var Params: Variant): Variant;
    function Call_IsChild(Instance: TObject; var Params: Variant): Variant;
    function Call_IsIconic(Instance: TObject; var Params: Variant): Variant;
    function Call_IsWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_IsWindowVisible(Instance: TObject; var Params: Variant): Variant;
    function Call_IsZoomed(Instance: TObject; var Params: Variant): Variant;
    function Call_MoveWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_SendMessageTimeOut(Instance: TObject; var Params: Variant): Variant;
    function Call_SetForegroundWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_SetWindowPos(Instance: TObject; var Params: Variant): Variant;
    function Call_SetWindowText(Instance: TObject; var Params: Variant): Variant;
    function Call_ShowWindow(Instance: TObject; var Params: Variant): Variant;
    function Call_ShowWindowAsync(Instance: TObject; var Params: Variant): Variant;
    function Call_WindowFromPoint(Instance: TObject; var Params: Variant): Variant;
    function Call_SendWmCopyData(Instance: TObject; var Params: Variant): Variant;
    function Call_GetListOfProcesses(Instance: TObject; var Params: Variant): Variant;
    function Call_GetListOfModules(Instance: TObject; var Params: Variant): Variant;
    function Call_GetListOfWindows(Instance: TObject; var Params: Variant): Variant;
    function Call_GetProcessId(Instance: TObject; var Params: Variant): Variant;
    function Call_GetCurrentProcess(Instance: TObject; var Params: Variant): Variant;
    function Call_GetCurrentProcessId(Instance: TObject; var Params: Variant): Variant;
    function Call_CloseHandle(Instance: TObject; var Params: Variant): Variant;
    function Call_OpenProcess(Instance: TObject; var Params: Variant): Variant;
    function Call_GetExitCodeProcess(Instance: TObject; var Params: Variant): Variant;
    function Call_GetProcessImageFileName(Instance: TObject; var Params: Variant): Variant;
    function Call_TerminateProcess(Instance: TObject; var Params: Variant): Variant;
    function Call_GetPriorityClass(Instance: TObject; var Params: Variant): Variant;
    function Call_SetPriorityClass(Instance: TObject; var Params: Variant): Variant;
    function Call_GetProcessTimesAsText(Instance: TObject; var Params: Variant): Variant;
    function Call_GetSystemTimesAsText(Instance: TObject; var Params: Variant): Variant;
    function Call_GetProcessAffinityMask(Instance: TObject; var Params: Variant): Variant;
    function Call_GetSystemAffinityMask(Instance: TObject; var Params: Variant): Variant;
    function Call_SetProcessAffinityMask(Instance: TObject; var Params: Variant): Variant;
    function Call_WinExec(Instance: TObject; var Params: Variant): Variant;
    function Call_GetWindowLong(Instance: TObject; var Params: Variant): Variant;
    function Call_SetWindowLong(Instance: TObject; var Params: Variant): Variant;
    function Call_GetWindowLongPtr(Instance: TObject; var Params: Variant): Variant;
    function Call_SetWindowLongPtr(Instance: TObject; var Params: Variant): Variant;
    function Call_ShellExecuteEx(Instance: TObject; var Params: Variant): Variant;
    function Call_WaitForSingleObject(Instance: TObject; var Params: Variant): Variant;
    function Call_GetACP(Instance: TObject; var Params: Variant): Variant;
    function Call_GetOEMCP(Instance: TObject; var Params: Variant): Variant;
    {
    function Call_(Instance: TObject; var Params: Variant): Variant;
    }
  end;

implementation

uses dpUtils;

{ TWinApiImport }

procedure TWinApiImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TWinApi).ClassImporter := Self; // Чтобы вызывался RegisterPublic
end;

procedure TWinApiImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('function WinApi: TWinApi', @Call_WinApi);
end;

procedure TWinApiImport.AddConsts(AddConst: TAddConstProc);
begin

end;

procedure TWinApiImport.AddObjects(AddObject: TAddObjectProc);
begin
  //AddObject('WinApi', WinApi);
end;

procedure TWinApiImport.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('UINT', btInt);
  AddType('ULONG', btInt);
  AddType('WPARAM', btInt);
  AddType('LPARAM', btInt);
  AddType('LRESULT', btInt);
  AddType('PtrInt', btInt);
  AddType('PtrUInt', btInt);
  AddType('SizeInt', btInt);
  AddType('SizeUInt', btInt);
end;

procedure TWinApiImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TWinApi then
  begin
    AType.AddMethod('function FindWindow(aClassName, aWindowName: String): HWND', @Call_FindWindow);
    AType.AddMethod('function FindWindowEx(hWndParent, hWndChildAfter: HWND; aClass, aWindow: String): HWND', @Call_FindWindowEx);
    AType.AddMethod('function SendMessage(Wnd: HWND; Msg: Cardinal; WPAR: WPARAM; LPAR: LPARAM): LRESULT', @Call_SendMessage);
    AType.AddMethod('function PostMessage(Wnd: HWND; Msg: Cardinal; WPAR: WPARAM; LPAR: LPARAM): Boolean', @Call_PostMessage);
    AType.AddMethod('function BringWindowToTop(Wnd: HWND): Boolean', @Call_BringWindowToTop);
    AType.AddMethod('function CloseWindow(Wnd: HWND): Boolean', @Call_CloseWindow);
    AType.AddMethod('function GetClassName(Wnd: HWND): String', @Call_GetClassName);
    AType.AddMethod('function GetClientRectAsText(Wnd: HWND): String', @Call_GetClientRectAsText);
    AType.AddMethod('function GetAncestor(Wnd: HWND; gaFlags: UINT): HWND', @Call_GetAncestor);
    AType.AddMethod('function GetDesktopWindow: HWND', @Call_GetDesktopWindow);
    AType.AddMethod('function GetForegroundWindow: HWND', @Call_GetForegroundWindow);
    AType.AddMethod('function GetParent(Wnd: HWND): HWND', @Call_GetParent);
    AType.AddMethod('function GetShellWindow: HWND', @Call_GetShellWindow);
    AType.AddMethod('function GetTopWindow(Wnd: HWND): HWND', @Call_GetTopWindow);
    AType.AddMethod('function GetWindow(Wnd: HWND; uCmd: UINT): HWND', @Call_GetWindow);
    AType.AddMethod('function GetWindowProcessId(Wnd: HWND): DWORD', @Call_GetWindowProcessId);
    AType.AddMethod('function GetWindowRectAsText(Wnd: HWND): String', @Call_GetWindowRectAsText);
    AType.AddMethod('function GetWindowText(Wnd: HWND): String', @Call_GetWindowText);
    AType.AddMethod('function IsChild(WndParent, Wnd: HWND): Boolean', @Call_IsChild);
    AType.AddMethod('function IsIconic(Wnd: HWND): Boolean', @Call_IsIconic);
    AType.AddMethod('function IsWindow(Wnd: HWND): Boolean', @Call_IsWindow);
    AType.AddMethod('function IsWindowVisible(Wnd: HWND): Boolean', @Call_IsWindowVisible);
    AType.AddMethod('function IsZoomed(Wnd: HWND): Boolean', @Call_IsZoomed);
    AType.AddMethod('function MoveWindow(Wnd: HWND; X, Y, W, H: Integer; Repaint:Boolean): Boolean', @Call_MoveWindow);
    AType.AddMethod('function SendMessageTimeOut(Wnd: HWND; Msg: Cardinal; WPAR: WPARAM; LPAR: LPARAM; Flags, TimeOut: UINT; var uResult: PtrUInt): LRESULT', @Call_SendMessageTimeOut);
    AType.AddMethod('function SetForegroundWindow(Wnd: HWND): Boolean', @Call_SetForegroundWindow);
    AType.AddMethod('function SetWindowPos(Wnd, WndInsertAfter: HWND; x, y, cx, cy: Integer; Flags: UINT): Boolean', @Call_SetWindowPos);
    AType.AddMethod('function SetWindowText(Wnd: HWND; const Caption:String): Boolean', @Call_SetWindowText);
    AType.AddMethod('function ShowWindow(Wnd: HWND; nCmdShow: Integer): Boolean', @Call_ShowWindow);
    AType.AddMethod('function ShowWindowAsync(Wnd: HWND; nCmdShow: Integer): Boolean', @Call_ShowWindowAsync);
    AType.AddMethod('function WindowFromPoint(x, y: Integer): HWND', @Call_WindowFromPoint);
    AType.AddMethod('function SendWmCopyData(Target, Sender: HWND; dwData: PtrUInt; Data: String; Hex: Boolean): LRESULT', @Call_SendWmCopyData);
    AType.AddMethod('function GetListOfProcesses(PID, PPID: Cardinal; Exe: String): String', @Call_GetListOfProcesses);
    AType.AddMethod('function GetListOfModules(PID: Cardinal): String', @Call_GetListOfModules);
    AType.AddMethod('function GetListOfWindows(PID: Cardinal; aClass, aTitle: String): String', @Call_GetListOfWindows);
    AType.AddMethod('function GetProcessId(hProcess: THandle): DWORD', @Call_GetProcessId);
    AType.AddMethod('function GetCurrentProcess: THandle', @Call_GetCurrentProcess);
    AType.AddMethod('function GetCurrentProcessId: DWORD', @Call_GetCurrentProcessId);
    AType.AddMethod('function CloseHandle(hObject: THandle): Boolean', @Call_CloseHandle);
    AType.AddMethod('function OpenProcess(dwDesiredAccess: DWORD; bInheritHandle: Boolean;  dwProcessId: DWORD): THandle', @Call_OpenProcess);
    AType.AddMethod('function GetExitCodeProcess(hProcess: THandle; var lpExitCode: DWord): Boolean', @Call_GetExitCodeProcess);
    AType.AddMethod('function GetProcessImageFileName(hProcess: THandle): String', @Call_GetProcessImageFileName);
    AType.AddMethod('function TerminateProcess(hProcess: THandle; uExitCode: UInt): Boolean', @Call_TerminateProcess);
    AType.AddMethod('function GetPriorityClass(hProcess: THandle): DWORD', @Call_GetPriorityClass);
    AType.AddMethod('function SetPriorityClass(hProcess: THandle; dwPriorityClass: DWORD): Boolean', @Call_SetPriorityClass);
    AType.AddMethod('function GetProcessTimesAsText(hProcess: THandle): String', @Call_GetProcessTimesAsText);
    AType.AddMethod('function GetSystemTimesAsText: String', @Call_GetSystemTimesAsText);
    AType.AddMethod('function GetProcessAffinityMask(hProcess: THandle): QWord', @Call_GetProcessAffinityMask);
    AType.AddMethod('function GetSystemAffinityMask: QWord', @Call_GetSystemAffinityMask);
    AType.AddMethod('function SetProcessAffinityMask(hProcess:THandle; Affinity:QWord):Boolean', @Call_SetProcessAffinityMask);
    AType.AddMethod('function WinExec(lpCmdLine: String; uCmdShow: UINT): UINT', @Call_WinExec);
    AType.AddMethod('function GetWindowLong(Wnd:HWND; nIndex:Integer):LongInt', @Call_GetWindowLong);
    AType.AddMethod('function SetWindowLong(Wnd:HWND; nIndex:Integer; dwNewLong:LongInt):LongInt', @Call_SetWindowLong);
    AType.AddMethod('function GetWindowLongPtr(Wnd:HWND; nIndex:Integer):PtrInt', @Call_GetWindowLongPtr);
    AType.AddMethod('function SetWindowLongPtr(Wnd:HWND; nIndex:Integer; dwNewLong:PtrInt):PtrInt', @Call_SetWindowLongPtr);
    AType.AddMethod('function ShellExecuteEx(fMask:DWORD; wnd:HWND; lpVerb:WideString; lpFile:WideString; lpParameters:WideString; lpDirectory:WideString; nShow:Integer; lpClass:WideString; hkeyClass:THandle; dwHotKey:DWORD; hIcon:THandle; var hInstApp:THandle; var hProcess:THandle):Boolean', @Call_ShellExecuteEx);
    AType.AddMethod('function WaitForSingleObject(hHandle:THandle; dwMilliseconds:DWORD):DWORD', @Call_WaitForSingleObject);
    AType.AddMethod('function GetACP:UINT', @Call_GetACP);
    AType.AddMethod('function GetOEMCP:UINT', @Call_GetOEMCP);
    {
    AType.AddMethod('', @Call_);
    }
  end;
end;

function TWinApiImport.Call_WinApi(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=TSuPtr(WinApi);
end;

function TWinApiImport.Call_FindWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.FindWindow(Params[0], Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_FindWindowEx(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.FindWindowEx(Params[0], Params[1], Params[2], Params[3]);
  {$ENDIF}
end;

function TWinApiImport.Call_SendMessage(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.SendMessage(Params[0], Params[1], Params[2], Params[3]);
  {$ENDIF}
end;

function TWinApiImport.Call_PostMessage(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
   Result := WinApi.PostMessage(Params[0], Params[1], Params[2], Params[3]);
  {$ENDIF}
end;

function TWinApiImport.Call_BringWindowToTop(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=false;
  {$IFDEF WINDOWS}
  Result := WinApi.BringWindowToTop(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_CloseWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=false;
  {$IFDEF WINDOWS}
  Result := WinApi.CloseWindow(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetClassName(Instance: TObject; var Params: Variant): Variant;
begin
  Result:='';
  {$IFDEF WINDOWS}
  Result := WinApi.GetClassName(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetClientRectAsText(Instance: TObject; var Params: Variant): Variant;
begin
  Result:='';
  {$IFDEF WINDOWS}
  Result := WinApi.GetClientRectAsText(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetAncestor(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetAncestor(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetDesktopWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetDesktopWindow;
  {$ENDIF}
end;

function TWinApiImport.Call_GetForegroundWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetForegroundWindow;
  {$ENDIF}
end;

function TWinApiImport.Call_GetParent(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetParent(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetShellWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetShellWindow;
  {$ENDIF}
end;

function TWinApiImport.Call_GetTopWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetTopWindow(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetWindow(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetWindowProcessId(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetWindowProcessId(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetWindowRectAsText(Instance: TObject; var Params: Variant): Variant;
begin
  Result:='';
  {$IFDEF WINDOWS}
  Result := WinApi.GetWindowRectAsText(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetWindowText(Instance: TObject; var Params: Variant): Variant;
begin
  Result:='';
  {$IFDEF WINDOWS}
  Result := WinApi.GetWindowText(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_IsChild(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.IsChild(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_IsIconic(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.IsIconic(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_IsWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.IsWindow(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_IsWindowVisible(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.IsWindowVisible(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_IsZoomed(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.IsZoomed(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_MoveWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.MoveWindow(Params[0],Params[1],Params[2],Params[3],Params[4],Params[5]);
  {$ENDIF}
end;

function TWinApiImport.Call_SendMessageTimeOut(Instance: TObject; var Params: Variant): Variant;
var dwResult:PtrUInt;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.SendMessageTimeOut(Params[0],Params[1],Params[2],Params[3],Params[4],Params[5],@dwResult);
  Params[6]:=dwResult;
  {$ENDIF}
end;

function TWinApiImport.Call_SetForegroundWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.SetForegroundWindow(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_SetWindowPos(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.SetWindowPos(Params[0],Params[1],Params[2],Params[3],Params[4],Params[5],Params[6]);
  {$ENDIF}
end;

function TWinApiImport.Call_SetWindowText(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.SetWindowText(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_ShowWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.ShowWindow(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_ShowWindowAsync(Instance: TObject; var Params: Variant): Variant;
begin
  Result := false;
  {$IFDEF WINDOWS}
  Result := WinApi.ShowWindowAsync(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_WindowFromPoint(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.WindowFromPoint(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_SendWmCopyData(Instance: TObject; var Params: Variant): Variant;
begin
  Result := 0;
  {$IFDEF WINDOWS}
  Result := WinApi.SendWmCopyData(Params[0],Params[1],Params[2],Params[3],Params[4]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetListOfProcesses(Instance: TObject; var Params: Variant): Variant;
begin
  Result := '';
  {$IFDEF WINDOWS}
  Result := WinApi.GetListOfProcesses(Params[0],Params[1],Params[2]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetListOfModules(Instance: TObject; var Params: Variant): Variant;
begin
  Result := '';
  {$IFDEF WINDOWS}
  Result := WinApi.GetListOfModules(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetListOfWindows(Instance: TObject; var Params: Variant): Variant;
begin
  Result := '';
  {$IFDEF WINDOWS}
  Result := WinApi.GetListOfWindows(Params[0],Params[1],Params[2]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetProcessId(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetProcessId(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetCurrentProcess(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetCurrentProcess;
  {$ENDIF}
end;

function TWinApiImport.Call_GetCurrentProcessId(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetCurrentProcessId;
  {$ENDIF}
end;

function TWinApiImport.Call_CloseHandle(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=false;
  {$IFDEF WINDOWS}
  Result := WinApi.CloseHandle(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_OpenProcess(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.OpenProcess(Params[0],Params[1],Params[2]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetExitCodeProcess(Instance: TObject; var Params: Variant): Variant;
{$IFDEF WINDOWS}var lpExitCode:DWORD;{$ENDIF}
begin
  Result:=false;
  {$IFDEF WINDOWS}
  Result := WinApi.GetExitCodeProcess(Params[0],lpExitCode);
  if Result then Params[1] := lpExitCode else Params[1]:=-1;
  {$ENDIF}
end;

function TWinApiImport.Call_GetProcessImageFileName(Instance: TObject; var Params: Variant): Variant;
begin
  Result:='';
  {$IFDEF WINDOWS}
  Result := WinApi.GetProcessImageFileName(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_TerminateProcess(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=false;
  {$IFDEF WINDOWS}
  Result := WinApi.TerminateProcess(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetPriorityClass(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetPriorityClass(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_SetPriorityClass(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=false;
  {$IFDEF WINDOWS}
  Result := WinApi.SetPriorityClass(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetProcessTimesAsText(Instance: TObject; var Params: Variant): Variant;
begin
  Result:='';
  {$IFDEF WINDOWS}
  Result := WinApi.GetProcessTimesAsText(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetSystemTimesAsText(Instance: TObject; var Params: Variant): Variant;
begin
  Result:='';
  {$IFDEF WINDOWS}
  Result := WinApi.GetSystemTimesAsText;
  {$ENDIF}
end;

function TWinApiImport.Call_GetProcessAffinityMask(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetProcessAffinityMask(Params[0]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetSystemAffinityMask(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetSystemAffinityMask;
  {$ENDIF}
end;

function TWinApiImport.Call_SetProcessAffinityMask(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=false;
  {$IFDEF WINDOWS}
  Result := WinApi.SetProcessAffinityMask(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_WinExec(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.WinExec(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetWindowLong(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetWindowLong(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_SetWindowLong(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.SetWindowLong(Params[0],Params[1],Params[2]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetWindowLongPtr(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetWindowLongPtr(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_SetWindowLongPtr(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.SetWindowLongPtr(Params[0],Params[1],Params[2]);
  {$ENDIF}
end;

function TWinApiImport.Call_ShellExecuteEx(Instance: TObject; var Params: Variant): Variant;
{$IFDEF WINDOWS}var hInstApp:THandle; var hProcess:THandle; {$ENDIF}
begin
  Result:=false;
  {$IFDEF WINDOWS}
  hInstApp:=0; hProcess:=0;
  Result := WinApi.ShellExecuteEx(Params[0],Params[1],Params[2],Params[3],Params[4],Params[5],Params[6],Params[7],Params[8],Params[9],Params[10],hInstApp,hProcess);
  Params[11]:=hInstApp; Params[12]:=hProcess;
  {$ENDIF}
end;

function TWinApiImport.Call_WaitForSingleObject(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=High(DWORD);
  {$IFDEF WINDOWS}
  Result := WinApi.WaitForSingleObject(Params[0],Params[1]);
  {$ENDIF}
end;

function TWinApiImport.Call_GetACP(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetACP;
  {$ENDIF}
end;

function TWinApiImport.Call_GetOEMCP(Instance: TObject; var Params: Variant): Variant;
begin
  Result:=0;
  {$IFDEF WINDOWS}
  Result := WinApi.GetOEMCP;
  {$ENDIF}
end;

initialization

end.

