{------------------------------------------------------------------------------}
{                                                                              }
{                               DieselPascal:                                  }
{                               Yuriy Kopnin                                   }
{                                    LGPL                                      }
{                                                                              }
{                        dpi_UsersExtraMethods.pas:                            }
{                      Contributed by Alexey Kuryakin                          }
{                                    LGPL                                      }
{                                                                              }
{------------------------------------------------------------------------------}
unit dpi_UsersExtraMethods;

{$mode objfpc}{$H+}
{$I SetComponent.inc}
{$inline on}

interface

uses
  Classes, SysUtils, StrUtils, Variants, dpi_mettyps;

{$IFDEF CRWDAQSYSTEM}
{
function GetProcessID: Cardinal
// CrossPlatform - Идентификатор процесса.
function GetEnvironmentVariable(Name: String): String
// CrossPlatform - Чтение переменной окружения.
function SetEnvironmentVariable(Name, Value: String): Boolean
// CrossPlatform - Запись переменной окружения.
function StrToHex(Str: String): String
// CrossPlatform - Преобразование строки в HEX формат.
function HexToStr(Hex: String): String
// CrossPlatform - Преобразование HEX формата в строку.
function VarToHex(Val: Variant): String
// CrossPlatform - Преобразование переменной в HEX формат.
function HexToVar(Hex: String; varType: Integer): Variant
// CrossPlatform - Преобразование HEX формата в переменную.
function WordCount(S, WordDelims: String): Integer
// CrossPlatform - Счетчик слов в строке.
function ExtractWord(N: Integer; S, WordDelims: String): String
// CrossPlatform - Выделение из строки слова с заданным номером.
function WordPosition(N: Integer; S, WordDelims: String): Integer
// CrossPlatform - Определение положения слова с данным номером в строке.
function SkipWords(N: Integer; S, WordDelims:String): String
// CrossPlatform - Возвращает остаток строки S после пропуска N слов.
function GetListOfProcesses(PID, PPID: Cardinal; Exe: String): String
// Windows,Linux - Список процессов PID, PPID, PRIO, NAME.
function GetListOfModules(PID: Cardinal): String
// Windows       - Список модулей, используемых процессом.
function GetListOfWindows(PID: Cardinal; aClass, aTitle: String): String
// Windows       - Список окон с заданным процессом, классом, заголовком.
function StringOfChar(Filler: Char; Count: Integer): String
// CrossPlatform - Строка заданной длины, заполненная заданным символом.
function StringReplace(S, OldPattern, NewPattern: String; rfFlags: Integer): String
// CrossPlatform - Замена подстроки OldPattern на NewPattern в строке S с флагами rfFlags.
function rfReplaceAll: Integer
// CrossPlatform - Флаг замены всех подстрок.
function rfIgnoreCase: Integer
// CrossPlatform - Флаг игнорирования регистра при замене подстрок.
function AdjustLineBreaks(S: String): String
// CrossPlatform - Исправляет символы разрыва строки.
function AnsiQuotedStr(S: String; aQuote: Char): String
// CrossPlatform - Помещает строку в кавычки.
function AnsiDeQuotedStr(S: String; aQuote: Char): String
// CrossPlatform - Убирает кавычки из строки.
function LeftStr(S: String; Count: Integer): String
// CrossPlatform - Вырезает Count символов строки слева.
function RightStr(S: String; Count: Integer): String
// CrossPlatform - Вырезает Count символов строки справа.
function LineEnding: String
// CrossPlatform - Разделитель строк (CR, LF или CR/LF).
function sLineBreak: String
// CrossPlatform - Разделитель строк (CR, LF или CR/LF).
function FormatVar(Fmt: String; Val: Variant): String
// CrossPlatform - Форматирует переменную Val по формату Fmt.
function TrimLeft(S: String): String
// CrossPlatform - Удаляет пробелы слева.
function TrimRight(S: String): String
// CrossPlatform - Удаляет пробелы справа.
function IsEmptyStr(S: String): Boolean
// CrossPlatform - Проверяет, что строка пустая.
function StrToIntDef(S: String; Def: Integer): Integer
function StrToDWordDef(S: String; Def: DWord): DWord
function StrToInt64Def(S: String; Def: Int64): Int64
function StrToQWordDef(S: String; Def: QWord): QWord
function StrToFloatDef(S: String; Def: Extended): Extended
// CrossPlatform - Преобразует строку S в Integer/DWord/Int64/QWord/Float или возвращает Def при ошибке.
function FileSearch(FileName, DirList: String; ImplicitCurrDir: Boolean): String
// CrossPlatform - Ищет файл с заданным именем в списке каталогов.
function CookieScan(Buff, Name: String; csmMode: Integer): String
// CrossPlatform - Ищет в буфере Buff выражение Name=Value и возвращает Value.
function csmCaseSensitive: Integer
// CrossPlatform - Режим CookieScan чувствительный к регистру символов.
function csmNotTrimName: Integer
// CrossPlatform - Режим CookieScan не удалять незначащие пробелы имени.
function csmNotTrimValue: Integer
// CrossPlatform - Режим CookieScan не удалять незначащие пробелы значения.
function ExecuteProcess(Path, CmdLine: String; efFlags: Integer): Integer
// CrossPlatform - Выполнить команду с параметрами и ожиданием завершения.
function ExpandFileName(FileName: String): String
// CrossPlatform - Преобразует относительное имя файла в абсолютное.
function Utf8ToAnsiToHex(S: String): String
// CrossPlatform - Преобразует строку UTF8->Ansi->Hex.
function RecodeStr(Data, Methods: String): String
// CrossPlatform - Преобразует стоку Data по цепочке методов, из списка (Utf8,Ansi,Hex,Url,Base64).
function GetHeapStatusAsText: String
// CrossPlatform - Возвращает статус менеджера памяти в виде текста.
function EasyIpc_Init(const PipeName, Options: String): THandle
// Windows       - Создает объект IPC с заданным именем канала (сервер: Name; клиент: .\Name) и параметрами (TimeOut,Rx/TxBuffSize,LogsLimit).
function EasyIpc_Free(hIpc: THandle): Boolean
// Windows       - Удаляет объект IPC.
function EasyIpc_Poll(hIpc: THandle): Boolean
// Windows       - Опрашивает объект IPC (вызывается по таймеру).
function EasyIpc_Send(hIpc: THandle; const TextLines: String): Boolean
// Windows       - Пересылает текст в канал IPC.
function EasyIpc_Recv(hIpc: THandle; Count: Integer): String
// Windows       - Принимает текст из канала IPC.
function EasyIpc_Ctrl(hIpc: THandle; const Request: String): String
// Windows       - Запрос/установка параметров IPC (Connected,IsServer,PipeName,...) или (*) для списка всех параметров.
function TryStrToInt(const S: String; Out Value: LongInt): Boolean
// CrossPlatform - Попытка преобразовать строку в Integer.
function TryStrToDWord(const S: String; Out Value: DWord): Boolean
// CrossPlatform - Попытка преобразовать строку в DWord.
function TryStrToInt64(const S: String; Out Value: Int64): Boolean
// CrossPlatform - Попытка преобразовать строку в Int64.
function TryStrToQWord(const S: String; Out Value: QWord): Boolean
// CrossPlatform - Попытка преобразовать строку в QWord.
function TryStrToFloat(const S: String; Out Value: Double): Boolean
// CrossPlatform - Попытка преобразовать строку в Double.
function MaxInt:Integer
// CrossPlatform - Максимальное целое число Integer.
function NaN: Double
// CrossPlatform - Значение "Не число" (Not A Number).
function Infinity: Double
// CrossPlatform - Значение "Плюс Бесконечность".
function NegInfinity: Double
// CrossPlatform - Значение "Минус Бесконечность".
function IsNaN(X: Double): Boolean
// CrossPlatform - Проверка числа на значение NaN.
function IsInf(X: Double): Boolean
// CrossPlatform - Проверка числа на "бесконечность".
function IsInfinite(X: Double): Boolean
// CrossPlatform - Проверка числа на "бесконечность".
function MachEps: Double
// CrossPlatform - Машинная точность.
function VarRangeMin(Value: Variant): Variant
// CrossPlatform - Минимальный диапазон значений Value.
function VarRangeMax(Value: Variant): Variant
// CrossPlatform - Максимальный диапазон значений Value.
function OrdVar(Value: Variant): Integer
// CrossPlatform - Порядковый номер Value.
function GetLastOsError: Integer
// CrossPlatform - Номер последней ошибки OS (Windows:GetLastError; Linux:errno).
function RaiseLastOsError(ErrNo: Integer): Integer
// CrossPlatform - Возбуждает исключение с кодом ошибки OS.
function GetOsErrorText(ErrNo: Integer): String
// CrossPlatform - Текст ошибки OS по номеру.
function ExpandEnvironmentVariables(const Expression: String; emMode: Integer): String
// CrossPlatform - Выполняет подстановку переменных окружения, типа %UserProfile% или $HOME.
function emExpandLikeWinC:Integer
function emExpandLikeWinE:Integer
function emExpandLikeUnix:Integer
function emExpandLikeBash:Integer
function emExpandDefaults:Integer
// CrossPlatform - Режимы emMode для ExpandEnvironmentVariables (%Name%,!Name!,$Name,${Name},All).
}
{$ENDIF}

type

  { TUsersExtraMethods }

  TUsersExtraMethods = class(TMethodsDef)
  public
    procedure AddMethod(Add_Method: TAddMethodProc); override;
  published
    {$IFDEF CRWDAQSYSTEM}
    function Call_GetProcessID(Instance: TObject; var Params: Variant): Variant;
    function Call_GetEnvironmentVariable(Instance: TObject; var Params: Variant ): Variant;
    function Call_SetEnvironmentVariable(Instance: TObject; var Params: Variant ): Variant;
    function Call_StrToHex(Instance: TObject; var Params: Variant ): Variant;
    function Call_HexToStr(Instance: TObject; var Params: Variant ): Variant;
    function Call_VarToHex(Instance: TObject; var Params: Variant ): Variant;
    function Call_HexToVar(Instance: TObject; var Params: Variant ): Variant;
    function Call_WordCount(Instance: TObject; var Params: Variant ): Variant;
    function Call_ExtractWord(Instance: TObject; var Params: Variant ): Variant;
    function Call_WordPosition(Instance: TObject; var Params: Variant ): Variant;
    function Call_SkipWords(Instance: TObject; var Params: Variant ): Variant;
    function Call_GetListOfProcesses(Instance: TObject; var Params: Variant ): Variant;
    function Call_GetListOfModules(Instance: TObject; var Params: Variant ): Variant;
    function Call_GetListOfWindows(Instance: TObject; var Params: Variant ): Variant;
    function Call_StringOfChar(Instance: TObject; var Params: Variant ): Variant;
    function Call_StringReplace(Instance: TObject; var Params: Variant ): Variant;
    function Call_rfReplaceAll(Instance: TObject; var Params: Variant ): Variant;
    function Call_rfIgnoreCase(Instance: TObject; var Params: Variant ): Variant;
    function Call_AdjustLineBreaks(Instance: TObject; var Params: Variant ): Variant;
    function Call_AnsiQuotedStr(Instance: TObject; var Params: Variant ): Variant;
    function Call_AnsiDeQuotedStr(Instance: TObject; var Params: Variant ): Variant;
    function Call_LeftStr(Instance: TObject; var Params: Variant ): Variant;
    function Call_RightStr(Instance: TObject; var Params: Variant ): Variant;
    function Call_LineEnding(Instance: TObject; var Params: Variant ): Variant;
    function Call_sLineBreak(Instance: TObject; var Params: Variant ): Variant;
    function Call_FormatVar(Instance: TObject; var Params: Variant ): Variant;
    function Call_TrimLeft(Instance: TObject; var Params: Variant ): Variant;
    function Call_TrimRight(Instance: TObject; var Params: Variant ): Variant;
    function Call_IsEmptyStr(Instance: TObject; var Params: Variant ): Variant;
    function Call_StrToIntDef(Instance: TObject; var Params: Variant ): Variant;
    function Call_StrToDWordDef(Instance: TObject; var Params: Variant ): Variant;
    function Call_StrToInt64Def(Instance: TObject; var Params: Variant ): Variant;
    function Call_StrToQWordDef(Instance: TObject; var Params: Variant ): Variant;
    function Call_StrToFloatDef(Instance: TObject; var Params: Variant ): Variant;
    function Call_FileSearch(Instance: TObject; var Params: Variant ): Variant;
    function Call_CookieScan(Instance: TObject; var Params: Variant ): Variant;
    function Call_csmCaseSensitive(Instance: TObject; var Params: Variant ): Variant;
    function Call_csmNotTrimName(Instance: TObject; var Params: Variant ): Variant;
    function Call_csmNotTrimValue(Instance: TObject; var Params: Variant ): Variant;
    function Call_ExecuteProcess(Instance: TObject; var Params: Variant ): Variant;
    function Call_ExpandFileName(Instance: TObject; var Params: Variant ): Variant;
    function Call_Utf8ToAnsiToHex(Instance: TObject; var Params: Variant ): Variant;
    function Call_RecodeStr(Instance: TObject; var Params: Variant ): Variant;
    function Call_GetHeapStatusAsText(Instance: TObject; var Params: Variant ): Variant;
    function Call_EasyIpc_Init(Instance: TObject; var Params: Variant ): Variant;
    function Call_EasyIpc_Free(Instance: TObject; var Params: Variant ): Variant;
    function Call_EasyIpc_Poll(Instance: TObject; var Params: Variant ): Variant;
    function Call_EasyIpc_Send(Instance: TObject; var Params: Variant ): Variant;
    function Call_EasyIpc_Recv(Instance: TObject; var Params: Variant ): Variant;
    function Call_EasyIpc_Ctrl(Instance: TObject; var Params: Variant ): Variant;
    function Call_TryStrToInt(Instance: TObject; var Params: Variant ): Variant;
    function Call_TryStrToDWord(Instance: TObject; var Params: Variant ): Variant;
    function Call_TryStrToInt64(Instance: TObject; var Params: Variant ): Variant;
    function Call_TryStrToQWord(Instance: TObject; var Params: Variant ): Variant;
    function Call_TryStrToFloat(Instance: TObject; var Params: Variant ): Variant;
    function Call_MaxInt(Instance: TObject; var Params: Variant ): Variant;
    function Call_NaN(Instance: TObject; var Params: Variant ): Variant;
    function Call_Infinity(Instance: TObject; var Params: Variant ): Variant;
    function Call_NegInfinity(Instance: TObject; var Params: Variant ): Variant;
    function Call_IsNaN(Instance: TObject; var Params: Variant ): Variant;
    function Call_IsInfinite(Instance: TObject; var Params: Variant ): Variant;
    function Call_MachEps(Instance: TObject; var Params: Variant ): Variant;
    function Call_VarRangeMin(Instance: TObject; var Params: Variant ): Variant;
    function Call_VarRangeMax(Instance: TObject; var Params: Variant ): Variant;
    function Call_OrdVar(Instance: TObject; var Params: Variant ): Variant;
    function Call_GetLastOsError(Instance: TObject; var Params: Variant ): Variant;
    function Call_RaiseLastOsError(Instance: TObject; var Params: Variant ): Variant;
    function Call_GetOsErrorText(Instance: TObject; var Params: Variant ): Variant;
    function Call_ExpandEnvironmentVariables(Instance: TObject; var Params: Variant ): Variant;
    function Call_emExpandLikeWinC(Instance: TObject; var Params: Variant ): Variant;
    function Call_emExpandLikeWinE(Instance: TObject; var Params: Variant ): Variant;
    function Call_emExpandLikeUnix(Instance: TObject; var Params: Variant ): Variant;
    function Call_emExpandLikeBash(Instance: TObject; var Params: Variant ): Variant;
    function Call_emExpandDefaults(Instance: TObject; var Params: Variant ): Variant;
    {$ENDIF}
  end;

var
  UsersExtraMethods: TUsersExtraMethods;

implementation

uses LCLProc, LCLType, LConvEncoding, dputils, Base64, synacode, math, LazFileUtils, LazUTF8, ctypes,
  {$IFDEF WINDOWS}
  windows, JwaTlHelp32, easyipc,
  {$ENDIF}
  expandenvvar, winapiwrapper;

function PCharArg(const S:String):PChar; {$IFDEF FPC}inline;{$ENDIF}
begin
  if (S='') then Result:=nil else Result:=PChar(S);
end;

function PWideCharArg(const S:WideString):PWideChar; {$IFDEF FPC}inline;{$ENDIF}
begin
  if (S='') then Result:=nil else Result:=PWideChar(S);
end;

function StrToHex(const Str:String):String;
begin
  Result:='';
  if (Str='') then exit;
  SetLength(Result,Length(Str)*2);
  BinToHex(PChar(Str),PChar(Result),Length(Str));
end;

function HexToStr(const Hex:String):String;
begin
  Result:='';
  if (Hex='') then exit;
  SetLength(Result,Length(Hex) div 2);
  SetLength(Result,HexToBin(PChar(Hex),PChar(Result),Length(Result)));
end;

function BufToStr(Buff:Pointer; Size:Integer):String;
begin
  Result:='';
  if (Size<=0) then exit;
  if (Buff=nil) then exit;
  SetString(Result,PChar(Buff),Size);
end;

function StrToBuf(const Str:String; Buff:Pointer; Size:Integer):Integer;
var n:Integer;
begin
  Result:=0;
  if(Size<=0) then exit;
  if (Buff=nil) then exit;
  FillChar(Buff^,Size,0);
  n:=Min(Size,Length(Str));
  if (n>0) then Move(PChar(Str)^,Buff^,n);
  Result:=n;
end;

function BufToHex(Buff:Pointer; Size:Integer):String;
begin
  Result:=StrToHex(BufToStr(Buff,Size));
end;

function VarToHex(var Param:Variant):String;
var ii:Integer; si:SmallInt; fs:Single; fd:Double; dt:TDateTime;
var ic:Currency; ih:ShortInt; bt:Byte; wd:Word; lw:LongWord;
var qi:Int64; qw:QWord; bl:Boolean; er:LongInt;
begin
  Result:='';
  case VarType(Param) of
    varSmallInt : begin si:=Param; Result:=BufToHex(@si,SizeOf(si)); end;
    varInteger  : begin ii:=Param; Result:=BufToHex(@ii,SizeOf(ii)); end;
    varSingle   : begin fs:=Param; Result:=BufToHex(@fs,SizeOf(fs)); end;
    varDouble   : begin fd:=Param; Result:=BufToHex(@fd,SizeOf(fd)); end;
    varDate     : begin dt:=Param; Result:=BufToHex(@dt,SizeOf(dt)); end;
    varCurrency : begin ic:=Param; Result:=BufToHex(@ic,SizeOf(ic)); end;
    varShortInt : begin ih:=Param; Result:=BufToHex(@ih,SizeOf(ih)); end;
    varError    : begin er:=Param; Result:=BufToHex(@er,SizeOf(er)); end;
    varByte     : begin bt:=Param; Result:=BufToHex(@bt,SizeOf(bt)); end;
    varWord     : begin wd:=Param; Result:=BufToHex(@wd,SizeOf(wd)); end;
    varLongWord : begin lw:=Param; Result:=BufToHex(@lw,SizeOf(lw)); end;
    varInt64    : begin qi:=Param; Result:=BufToHex(@qi,SizeOf(qi)); end;
    varQWord    : begin qw:=Param; Result:=BufToHex(@qw,SizeOf(qw)); end;
    varBoolean  : begin bl:=Param; Result:=BufToHex(@bl,SizeOf(bl)); end;
    varOleStr   : Result:=StrToHex(Param);
    varString   : Result:=StrToHex(Param);
    varUString  : Result:=StrToHex(Param);
  end;
end;

function HexToVar(const Hex:String; Typ:Integer):Variant;
var ii:Integer; si:SmallInt; fs:Single; fd:Double; dt:TDateTime;
var ic:Currency; ih:ShortInt; bt:Byte; wd:Word; lw:LongWord;
var qi:Int64; qw:QWord; bl:Boolean; er:HResult; Str:String;
begin
  Result:=Unassigned;
  if (Hex='') then exit;
  Str:=HexToStr(Hex);
  if (Str='') then exit;
  case Typ of
    varSmallInt : begin StrToBuf(Str,@si,SizeOf(si)); Result:=si; end;
    varInteger  : begin StrToBuf(Str,@ii,SizeOf(ii)); Result:=ii; end;
    varSingle   : begin StrToBuf(Str,@fs,SizeOf(fs)); Result:=fs; end;
    varDouble   : begin StrToBuf(Str,@fd,SizeOf(fd)); Result:=fd; end;
    varDate     : begin StrToBuf(Str,@dt,SizeOf(dt)); Result:=dt; end;
    varCurrency : begin StrToBuf(Str,@ic,SizeOf(ic)); Result:=ic; end;
    varShortInt : begin StrToBuf(Str,@ih,SizeOf(ih)); Result:=ih; end;
    varError    : begin StrToBuf(Str,@er,SizeOf(er)); Result:=er; end;
    varByte     : begin StrToBuf(Str,@bt,SizeOf(bt)); Result:=bt; end;
    varWord     : begin StrToBuf(Str,@wd,SizeOf(wd)); Result:=wd; end;
    varLongWord : begin StrToBuf(Str,@lw,SizeOf(lw)); Result:=lw; end;
    varInt64    : begin StrToBuf(Str,@qi,SizeOf(qi)); Result:=qi; end;
    varQWord    : begin StrToBuf(Str,@qw,SizeOf(qw)); Result:=qw; end;
    varBoolean  : begin StrToBuf(Str,@bl,SizeOf(bl)); Result:=bl; end;
    varOleStr   : Result:=Str;
    varString   : Result:=Str;
    varUString  : Result:=Str;
  end;
end;

function StrToSysCharSet(const S:String):TSysCharSet;
var i:Integer;
begin
  Result:=[];
  for i:=1 to Length(S) do Include(Result,S[i]);
end;

type
  EFormatVar = class(Exception);

function FormatVar(const Fmt:String; Param:Variant):String;
var ii:Integer; si:SmallInt; fs:Single; fd:Double; dt:TDateTime;
var ic:Currency; ih:ShortInt; bt:Byte; wd:Word; lw:LongWord;
var qi:Int64; qw:QWord; bl:Boolean; er:LongInt; st:String;
begin
  Result:='';
  if (Fmt='') then exit;
  case VarType(Param) of
   varSmallInt : begin si:=Param; Result:=Format(Fmt,[si]); end;
   varInteger  : begin ii:=Param; Result:=Format(Fmt,[ii]); end;
   varSingle   : begin fs:=Param; Result:=Format(Fmt,[fs]); end;
   varDouble   : begin fd:=Param; Result:=Format(Fmt,[fd]); end;
   varDate     : begin dt:=Param; Result:=Format(Fmt,[dt]); end;
   varCurrency : begin ic:=Param; Result:=Format(Fmt,[ic]); end;
   varShortInt : begin ih:=Param; Result:=Format(Fmt,[ih]); end;
   varError    : begin er:=Param; Result:=Format(Fmt,[er]); end;
   varByte     : begin bt:=Param; Result:=Format(Fmt,[bt]); end;
   varWord     : begin wd:=Param; Result:=Format(Fmt,[wd]); end;
   varLongWord : begin lw:=Param; Result:=Format(Fmt,[lw]); end;
   varInt64    : begin qi:=Param; Result:=Format(Fmt,[qi]); end;
   varQWord    : begin qw:=Param; Result:=Format(Fmt,[qw]); end;
   varBoolean  : begin bl:=Param; Result:=Format(Fmt,[bl]); end;
   varOleStr   : begin st:=Param; Result:=Format(Fmt,[st]); end;
   varString   : begin st:=Param; Result:=Format(Fmt,[st]); end;
   varUString  : begin st:=Param; Result:=Format(Fmt,[st]); end;
   else          raise EFormatVar.CreateFmt('Invalid FormatVar type %d.',[VarType(Param)]);
  end;
end;

type
  EVarRangeMin = class(Exception);

function VarRangeMin(Param:Variant):Variant;
var st:String;
begin
 Result:=Unassigned;
 case VarType(Param) of
  varSmallInt : Result:=Low(SmallInt);
  varInteger  : Result:=Low(Integer);
  varSingle   : Result:=MinSingle;
  varDouble   : Result:=MinDouble;
  varDate     : Result:=MinDateTime;
  varCurrency : Result:=MinCurrency;
  varShortInt : Result:=Low(ShortInt);
  varError    : Result:=Low(TError);
  varByte     : Result:=Low(Byte);
  varWord     : Result:=Low(Word);
  varLongWord : Result:=Low(LongWord);
  varInt64    : Result:=Low(Int64);
  varQWord    : Result:=Low(QWord);
  varBoolean  : Result:=Low(Boolean);
  varOleStr   : begin st:=Param; Result:=Low(st); end;
  varString   : begin st:=Param; Result:=Low(st); end;
  varUString  : begin st:=Param; Result:=Low(st); end;
  else          raise EVarRangeMin.CreateFmt('Invalid VarRangeMin type %d.',[VarType(Param)]);
 end;
end;

type
  EVarRangeMax = class(Exception);

function VarRangeMax(Param:Variant):Variant;
var st:String;
begin
 Result:=Unassigned;
 case VarType(Param) of
  varSmallInt : Result:=High(SmallInt);
  varInteger  : Result:=High(Integer);
  varSingle   : Result:=MaxSingle;
  varDouble   : Result:=MaxDouble;
  varDate     : Result:=MaxDateTime;
  varCurrency : Result:=MaxCurrency;
  varShortInt : Result:=High(ShortInt);
  varError    : Result:=High(TError);
  varByte     : Result:=High(Byte);
  varWord     : Result:=High(Word);
  varLongWord : Result:=High(LongWord);
  varInt64    : Result:=High(Int64);
  varQWord    : Result:=High(QWord);
  varBoolean  : Result:=High(Boolean);
  varOleStr   : begin st:=Param; Result:=High(st); end;
  varString   : begin st:=Param; Result:=High(st); end;
  varUString  : begin st:=Param; Result:=High(st); end;
  else          raise EVarRangeMax.CreateFmt('Invalid VarRangeMax type %d.',[VarType(Param)]);
 end;
end;

type EOrdVar = class(Exception);

function OrdVar(var Param:Variant):Integer;
var ii:Integer; si:SmallInt; ih:ShortInt; bt:Byte; wd:Word; lw:LongWord;
var qi:Int64; qw:QWord; bl:Boolean; er:LongInt; s:String;
begin
  case VarType(Param) of
    varSmallInt : begin si:=Param; Result:=Ord(si); end;
    varInteger  : begin ii:=Param; Result:=Ord(ii); end;
    varShortInt : begin ih:=Param; Result:=Ord(ih); end;
    varError    : begin er:=Param; Result:=Ord(er); end;
    varByte     : begin bt:=Param; Result:=Ord(bt); end;
    varWord     : begin wd:=Param; Result:=Ord(wd); end;
    varLongWord : begin lw:=Param; Result:=Ord(lw); end;
    varInt64    : begin qi:=Param; Result:=Ord(qi); end;
    varQWord    : begin qw:=Param; Result:=Ord(qw); end;
    varBoolean  : begin bl:=Param; Result:=Ord(bl); end;
    varOleStr,
    varString,
    varUString:   begin
                   S:=Param;
                   if (S='') then Result:=Ord(#0) else begin
                    if (FindInvalidUTF8Character(PChar(S), Length(S))=-1) then S:=dp_UTF8ToAnsi(S);
                    if (S='') then Result:=Ord(#0) else Result:=Ord(S[1]);
                   end;
                  end;
    else          raise EOrdVar.CreateFmt('Invalid OrdVar type %d.',[VarType(Param)]);
  end;
end;


function IsEmptyStr(const S:String):Boolean;
begin
  Result:=(Trim(S)='');
end;

const                       // CookieScan Mode flags:
 csm_CaseSense = $00000100; // Name comparison is case sensitive
 csm_SkipTrimN = $00000200; // Don't Trim name before comparison
 csm_SkipTrimV = $00000400; // Don't Trim result Value
 csm_Default   = 0;         // Default is case insensitive, trim name and value

function CookieScan(Buff:PChar; Size:Integer; const Name:String; Mode:Integer):String;
var lenline,lenname:Integer; line:PChar; c,no,Delim:Char; s,n,v:String;
 procedure ProcessLine;
 var p:Integer; found:Boolean;
 begin
  if (line<>nil) and (lenline>lenname) then begin
   SetString(s,line,lenline);
   p:=Pos('=',s);
   if p>lenname then begin
    n:=Copy(s,1,p-1); // Get name and compare with Name
    if (Mode and csm_SkipTrimN) = 0 then n:=SysUtils.Trim(n);
    if (Mode and csm_CaseSense) = 0 then found:=SameText(Name,n) else found:=(Name=n);
    if found then begin // Name was found, now get value
     v:=Copy(s,p+1,lenline-p); if (Mode and csm_SkipTrimV) = 0 then v:=SysUtils.Trim(v);
     no:=#0; // Mark success, i.e. clear "no expressions found" marker.
     c:=#0; // Should Break!
    end;
   end;
  end;
 end;
begin
 Result:='';
 if (Name<>'') then
 if Assigned(Buff) then begin
  Delim:=Chr(Mode);
  s:=''; n:=''; v:='';
  no:=Chr(Mode shr 16);
  line:=nil; lenline:=0;
  lenname:=Length(Name);
  while Size>0 do begin
   c:=Buff[0];
   if (c=#0) or (c=#13) or (c=#10) or (c=Delim) then begin
    if (line<>nil) then ProcessLine;
    line:=nil; lenline:=0;
    if (c=#0) then Break;
   end else begin
    if (line=nil) then line:=Buff;
    inc(lenline);
   end;
   inc(Buff);
   dec(Size);
  end;
  if (line<>nil) then ProcessLine;
  if (v='') and (no<>#0) then v:=no;
  Result:=v; s:=''; n:=''; v:='';
 end;
end;

function CookieScan(const Buff,Name:String; Mode:Integer):String;
begin
 if (Name<>'') and (Buff<>'')
 then Result:=CookieScan(PChar(Buff),Length(Buff),Name,Mode)
 else Result:='';
end;

type  TCodeMethod                                = (cmAsIs, cmRawByte, cmUtf8, cmAnsi, cmBase64, cmUrl, cmHex);
const sCodeMethod : array[TCodeMethod] of String = ('AsIs', 'RawByte', 'Utf8', 'Ansi', 'Base64', 'Url', 'Hex');

function GetCodeMethod(S:String):TCodeMethod;
var i:TCodeMethod;
begin
 Result:=cmAsIs;
 for i:=Low(TCodeMethod) to High(TCodeMethod) do
 if SameText(S,sCodeMethod[i]) then begin Result:=i; break; end;
end;

function RecodeStr(const Data: String; cmFrom, cmTo: TCodeMethod): String;
begin
 Result:=Data;
 case cmFrom of
  cmAsIs    : ;
  cmRawByte : ;
  cmUtf8    : ; // It's original code
  cmAnsi    : Result:=dp_Utf8ToAnsi(Result);
  cmBase64  : Result:=DecodeStringBase64(Result);
  cmUrl     : Result:=DecodeUrl(Result);
  cmHex     : Result:=HexToStr(Result);
 end;
 case cmTo of
  cmAsIs    : ;
  cmRawByte : ;
  cmUtf8    : Result:=dp_AnsiToUtf8(Result);
  cmAnsi    : Result:=dp_Utf8ToAnsi(Result);
  cmBase64  : Result:=EncodeStringBase64(Result);
  cmUrl     : Result:=EncodeUrl(Result);
  cmHex     : Result:=StrToHex(Result);
 end;
end;

// Example: S:=RecodeStr(S,'Utf8,Ansi,Hex');
function RecodeStr(const Data, Methods: String): String;
var i,n:Integer; cmFrom,cmTo:TCodeMethod;
const Delims=[#0..' ',',',';'];
begin
 Result:=Data;
 n:=WordCount(Methods,Delims); if (n<=0) then Exit;
 i:=1; cmFrom:=GetCodeMethod(ExtractWord(i,Methods,Delims)); cmTo:=cmAsIs;
 repeat
  Result:=RecodeStr(Result,cmFrom,cmTo);
  Inc(i); cmFrom:=cmAsIs; cmTo:=GetCodeMethod(ExtractWord(i,Methods,Delims));
 until (i>n);
end;

function MachEps:Double;
const eps:double=0.0;
var eps1:double;
begin
 if eps=0.0 then begin
  eps:=1.0;
  repeat
   eps:=0.5*eps;
   eps1:=1.0+eps;
  until eps1=1.0;
  eps:=eps*2.0;
 end;
 Result:=eps;
end;

{$IFDEF LINUX}
{$PUSH}
{$IOCHECKS OFF}
// List processes as PID, PPID, Priority, EXE, CmdLine
function GetListOfProc(aPid, aPPid:THandle; const aName:String; Detail:Boolean): String;
var Rec:TSearchRec; Pid,PPid:THandle; i,Prio:Integer; Proc,List:TStringList; ProgName,CmdLine:String;
  function GetParamName(const Line:String):String;
  begin
    Result:=Trim(ExtractWord(1,Line,[':']));
  end;
  function GetParamValue(const Line:String):String;
  begin
    Result:=Trim(ExtractWord(2,Line,[':']));
  end;
  function GetProcStatus(Pid:THandle; var PPid:THandle; var Prio:Integer; var ProgName,CmdLine:String):Boolean;
  var i,n:Integer; Line,sn,sv:String; F:Text;
  begin
    Result:=false;
    PPid:=0; Prio:=0; ProgName:=''; CmdLine:=''; n:=0;
    if (Pid=0) then Exit;
    IoResult;
    Assign(F,'/proc/' + IntToStr(Pid) + '/status');
    Reset(F);
    try
      while not Eof(F) and (n<2) do begin
        Readln(F,Line);
        sn:=GetParamName(Line);
        sv:=GetParamValue(Line);
        if (IOResult<>0) then Exit;
        if SameText(sn,'Pid') and (StrToInt64Def(sv,0)=0) then Exit;
        if SameText(sn,'Name') then begin ProgName:=sv; inc(n); end else
        if SameText(sn,'PPid') then begin PPid:=StrToInt64Def(sv,0); inc(n); end;
      end;
    finally
      Close(F);
    end;
    Assign(F,'/proc/' + IntToStr(Pid) + '/sched');
    Reset(F);
    try
      while not Eof(F) and (n<3) do begin
       Readln(F,Line);
       sn:=GetParamName(Line);
       sv:=GetParamValue(Line);
       if (IOResult<>0) then Exit;
       if SameText(sn,'prio') then begin Prio:=StrToIntDef(sv,0); inc(n); end;
      end;
    finally
      Close(F);
    end;
    Result:=(n>=3);
    if not Detail then Exit;
    Assign(F,'/proc/' + IntToStr(Pid) + '/cmdline');
    Reset(F);
    try
     Readln(F,Line);
     if (IoResult=0) then begin
       for i:=1 to Length(Line) do
       if (Line[i]=#0) then Line[i]:=' ';
       CmdLine:=Trim(Line);
     end;
    finally
      Close(F);
    end;
    IoResult;
  end;
begin
  Result:='';
  Proc:=TStringList.Create;
  List:=TStringList.Create;
  try
    IOResult;
    // Read /proc/pid to Proc list
    if (FindFirstUTF8('/proc/*', faDirectory, Rec) = 0) then
    repeat
      Pid:=StrToIntDef(Rec.Name,0);
      if (Pid<>0) then Proc.Add(IntToStr(Pid));
    until (FindNextUTF8(Rec) <> 0);
    FindCloseUTF8(Rec);
    // Select pid's by filter
    for i:=0 to Proc.Count-1 do begin
      Pid:=StrToIntDef(Proc[i],0);
      if (Pid=0) then Continue else
      if (aPid=0) or (aPid=Pid) then begin
        PPid:=0; Prio:=0; ProgName:=''; CmdLine:='';
        if GetProcStatus(Pid,PPid,Prio,ProgName,CmdLine) then
        if (aPPid=0) or (aPPid=PPid) then
        if (aName='') or SameText(aName,ProgName) then
        if (CmdLine='')
        then List.Add(Format('%d, %d, %d, %s',[Pid,PPid,Prio,ProgName]))
        else List.Add(Format('%d, %d, %d, %s, %s',[Pid,PPid,Prio,ProgName,CmdLine]));
      end;
    end;
    Result:=List.Text;
  finally
    List.Free;
    Proc.Free;
    IoResult;
  end;
end;
{$POP}
{$ENDIF LINUX}

{$IFDEF WINDOWS}
 {-$DEFINE USES_STRERROR}
 {$IFDEF USES_STRERROR}
 function strerror(errnum: cint): Pchar; cdecl; external 'msvcrt' name 'strerror';
 function GetOsErrorText(ErrorCode: Integer): String;
 begin
  Result:=strerror(ErrorCode);
 end;
 {$ELSE}
 function SysErrorMessage(ErrorCode: Integer): WideString;
 var Len:Integer; Buf:WideString;
 begin
  Buf:=StringOfChar(#0,1024);
  Len:=FormatMessageW(FORMAT_MESSAGE_FROM_SYSTEM or FORMAT_MESSAGE_ARGUMENT_ARRAY,nil,ErrorCode,0,PWideChar(Buf),Length(Buf),nil);
  while (Len>0) and (PWideChar(Buf)[Len-1] in [#0..#32]) do Dec(Len);
  SetString(Result,PWideChar(Buf),Len);
 end;
 function GetOsErrorText(ErrorCode: Integer): String;
 begin
  Result:=SysErrorMessage(ErrorCode);
 end;
 {$ENDIF}
{$ELSE}
function strerror(errnum: cint): Pchar; cdecl; external 'c'      name 'strerror';
function GetOsErrorText(ErrorCode: Integer): String;
begin
 Result:=strerror(ErrorCode);
end;
{$ENDIF}

{ TUsersExtraMethods }

procedure TUsersExtraMethods.AddMethod(Add_Method: TAddMethodProc);
begin
  {$IFDEF CRWDAQSYSTEM}
  Add_Method('function GetProcessID: Cardinal', @Call_GetProcessID);
  Add_Method('function GetEnvironmentVariable(Name: String): String', @Call_GetEnvironmentVariable);
  Add_Method('function SetEnvironmentVariable(Name, Value: String): Boolean', @Call_SetEnvironmentVariable);
  Add_Method('function StrToHex(Str: String): String', @Call_StrToHex);
  Add_Method('function HexToStr(Hex: String): String', @Call_HexToStr);
  Add_Method('function VarToHex(Val: Variant): String', @Call_VarToHex);
  Add_Method('function HexToVar(Hex: String; varType: Integer): Variant', @Call_HexToVar);
  Add_Method('function WordCount(S, WordDelims: String): Integer', @Call_WordCount);
  Add_Method('function ExtractWord(N: Integer; S, WordDelims: String): String', @Call_ExtractWord);
  Add_Method('function WordPosition(N: Integer; S, WordDelims: String): Integer', @Call_WordPosition);
  Add_Method('function SkipWords(N: Integer; S, WordDelims:String): String', @Call_SkipWords);
  Add_Method('function GetListOfProcesses(PID, PPID: Cardinal; Exe: String): String', @Call_GetListOfProcesses);
  Add_Method('function GetListOfModules(PID: Cardinal): String', @Call_GetListOfModules);
  Add_Method('function GetListOfWindows(PID: Cardinal; aClass, aTitle: String): String', @Call_GetListOfWindows);
  Add_Method('function StringOfChar(Filler: Char; Count: Integer): String', @Call_StringOfChar);
  Add_Method('function StringReplace(S, OldPattern, NewPattern: String; rfFlags: Integer): String', @Call_StringReplace);
  Add_Method('function rfReplaceAll: Integer', @Call_rfReplaceAll);
  Add_Method('function rfIgnoreCase: Integer', @Call_rfIgnoreCase);
  Add_Method('function AdjustLineBreaks(S: String): String', @Call_AdjustLineBreaks);
  Add_Method('function AnsiQuotedStr(S: String; aQuote: Char): String', @Call_AnsiQuotedStr);
  Add_Method('function AnsiDeQuotedStr(S: String; aQuote: Char): String', @Call_AnsiDeQuotedStr);
  Add_Method('function LeftStr(S: String; Count: Integer): String', @Call_LeftStr);
  Add_Method('function RightStr(S: String; Count: Integer): String', @Call_RightStr);
  Add_Method('function LineEnding: String', @Call_LineEnding);
  Add_Method('function sLineBreak: String', @Call_sLineBreak);
  Add_Method('function FormatVar(Fmt: String; Val: Variant): String', @Call_FormatVar);
  Add_Method('function TrimLeft(S: String): String', @Call_TrimLeft);
  Add_Method('function TrimRight(S: String): String', @Call_TrimRight);
  Add_Method('function IsEmptyStr(S: String): Boolean', @Call_IsEmptyStr);
  Add_Method('function StrToIntDef(S: String; Def: Integer): Integer', @Call_StrToIntDef);
  Add_Method('function StrToDWordDef(S: String; Def: DWord): DWord', @Call_StrToDWordDef);
  Add_Method('function StrToInt64Def(S: String; Def: Int64): Int64', @Call_StrToInt64Def);
  Add_Method('function StrToQWordDef(S: String; Def: QWord): QWord', @Call_StrToQWordDef);
  Add_Method('function StrToFloatDef(S: String; Def: Extended): Extended', @Call_StrToFloatDef);
  Add_Method('function FileSearch(FileName, DirList: String; ImplicitCurrDir: Boolean): String', @Call_FileSearch);
  Add_Method('function CookieScan(Buff, Name: String; csmMode: Integer): String', @Call_CookieScan);
  Add_Method('function csmCaseSensitive: Integer', @Call_csmCaseSensitive);
  Add_Method('function csmNotTrimName: Integer', @Call_csmNotTrimName);
  Add_Method('function csmNotTrimValue: Integer', @Call_csmNotTrimValue);
  Add_Method('function ExecuteProcess(Path, CmdLine: String; efFlags: Integer): Integer', @Call_ExecuteProcess);
  Add_Method('function ExpandFileName(FileName: String): String', @Call_ExpandFileName);
  Add_Method('function Utf8ToAnsiToHex(S: String): String', @Call_Utf8ToAnsiToHex);
  Add_Method('function RecodeStr(Data, Methods: String): String', @Call_RecodeStr);
  Add_Method('function GetHeapStatusAsText: String', @Call_GetHeapStatusAsText);
  Add_Method('function EasyIpc_Init(const PipeName, Options: String): THandle', @Call_EasyIpc_Init);
  Add_Method('function EasyIpc_Free(hIpc: THandle): Boolean', @Call_EasyIpc_Free);
  Add_Method('function EasyIpc_Poll(hIpc: THandle): Boolean', @Call_EasyIpc_Poll);
  Add_Method('function EasyIpc_Send(hIpc: THandle; const TextLines: String): Boolean', @Call_EasyIpc_Send);
  Add_Method('function EasyIpc_Recv(hIpc: THandle; Count: Integer): String', @Call_EasyIpc_Recv);
  Add_Method('function EasyIpc_Ctrl(hIpc: THandle; const Request: String): String', @Call_EasyIpc_Ctrl);
  Add_Method('function TryStrToInt(const S: String; Out Value: LongInt): Boolean', @Call_TryStrToInt);
  Add_Method('function TryStrToDWord(const S: String; Out Value: DWord): Boolean', @Call_TryStrToDWord);
  Add_Method('function TryStrToInt64(const S: String; Out Value: Int64): Boolean', @Call_TryStrToInt64);
  Add_Method('function TryStrToQWord(const S: String; Out Value: QWord): Boolean', @Call_TryStrToQWord);
  Add_Method('function TryStrToFloat(const S: String; Out Value: Double): Boolean', @Call_TryStrToFloat);
  Add_Method('function MaxInt:Integer', @Call_MaxInt);
  Add_Method('function NaN: Double', @Call_NaN);
  Add_Method('function Infinity: Double', @Call_Infinity);
  Add_Method('function NegInfinity: Double', @Call_NegInfinity);
  Add_Method('function IsNaN(X: Double): Boolean', @Call_IsNaN);
  Add_Method('function IsInf(X: Double): Boolean', @Call_IsInfinite);
  Add_Method('function IsInfinite(X: Double): Boolean', @Call_IsInfinite);
  Add_Method('function MachEps: Double', @Call_MachEps);
  Add_Method('function VarRangeMin(Value: Variant): Variant', @Call_VarRangeMin);
  Add_Method('function VarRangeMax(Value: Variant): Variant', @Call_VarRangeMax);
  Add_Method('function OrdVar(Value: Variant): Integer', @Call_OrdVar);
  Add_Method('function GetLastOsError: Integer', @Call_GetLastOsError);
  Add_Method('function RaiseLastOsError(ErrNo: Integer): Integer', @Call_RaiseLastOsError);
  Add_Method('function GetOsErrorText(ErrNo: Integer): String', @Call_GetOsErrorText);
  Add_Method('function ExpandEnvironmentVariables(const Expression: String; emMode: Integer): String', @Call_ExpandEnvironmentVariables);
  Add_Method('function emExpandLikeWinC: Integer', @Call_emExpandLikeWinC);
  Add_Method('function emExpandLikeWinE: Integer', @Call_emExpandLikeWinE);
  Add_Method('function emExpandLikeUnix: Integer', @Call_emExpandLikeUnix);
  Add_Method('function emExpandLikeBash: Integer', @Call_emExpandLikeBash);
  Add_Method('function emExpandDefaults: Integer', @Call_emExpandDefaults);
  {$ENDIF}
end;

{$IFDEF CRWDAQSYSTEM}

function TUsersExtraMethods.Call_GetProcessID(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := System.GetProcessID;
end;

function TUsersExtraMethods.Call_GetEnvironmentVariable(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := GetEnvironmentVariable(Params[0]);
end;

function TUsersExtraMethods.Call_SetEnvironmentVariable(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := SetEnvironmentVariable(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_StrToHex(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := StrToHex(Params[0]);
end;

function TUsersExtraMethods.Call_HexToStr(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := HexToStr(Params[0]);
end;

function TUsersExtraMethods.Call_VarToHex(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := VarToHex(Params[0]);
end;

function TUsersExtraMethods.Call_HexToVar(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := HexToVar(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_WordCount(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := WordCount(Params[0], StrToSysCharSet(Params[1]));
end;

function TUsersExtraMethods.Call_ExtractWord(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := ExtractWord(Params[0], Params[1], StrToSysCharSet(Params[2]));
end;

function TUsersExtraMethods.Call_WordPosition(Instance: TObject; var Params: Variant ): Variant;
begin
  Result :=WordPosition(Params[0], Params[1], StrToSysCharSet(Params[2]));
end;

function TUsersExtraMethods.Call_SkipWords(Instance: TObject; var Params: Variant ): Variant;
var p:Integer;
begin
  p:=WordPosition(Params[0]+1, Params[1], StrToSysCharSet(Params[2]));
  if (p>0) then Result:=Copy(Params[1],p,MaxInt) else Result:='';
end;

function TUsersExtraMethods.Call_GetListOfProcesses(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:='';
 {$IFDEF WINDOWS}
  Result := WinApi.GetListOfProcesses(Params[0], Params[1], Params[2]);
 {$ENDIF}
 {$IFDEF LINUX}
 Result := GetListOfProc(PtrUInt(Params[0]), PtrUInt(Params[1]), Params[2], false);
 {$ENDIF}
end;

function TUsersExtraMethods.Call_GetListOfModules(Instance: TObject; var Params: Variant ): Variant;
begin
 Result := '';
 {$IFDEF WINDOWS}
 Result := WinApi.GetListOfModules(Params[0]);
 {$ENDIF}
end;

function TUsersExtraMethods.Call_GetListOfWindows(Instance: TObject; var Params: Variant ): Variant;
begin
 Result := '';
 {$IFDEF WINDOWS}
  Result := WinApi.GetListOfWindows(Params[0], Params[1], Params[2]);
 {$ENDIF}
end;

function TUsersExtraMethods.Call_StringOfChar(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := System.StringOfChar(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_StringReplace(Instance: TObject; var Params: Variant ): Variant;
var Flags:TReplaceFlags; Mask:Integer; S, OldPattern, NewPattern:String;
begin
  S:=Params[0]; OldPattern:=Params[1]; NewPattern:=Params[2]; Mask:=Params[3];
  Flags:=[];
  if ((Mask and (1 shl Ord(rfReplaceAll)))<>0) then Include(Flags,rfReplaceAll);
  if ((Mask and (1 shl Ord(rfIgnoreCase)))<>0) then Include(Flags,rfIgnoreCase);
  Result := StringReplace(S, OldPattern, NewPattern, Flags);
end;

function TUsersExtraMethods.Call_rfReplaceAll(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := (1 shl Ord(rfReplaceAll));
end;

function TUsersExtraMethods.Call_rfIgnoreCase(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := (1 shl Ord(rfIgnoreCase));
end;

function TUsersExtraMethods.Call_AdjustLineBreaks(Instance: TObject; var Params: Variant ): Variant;
var S:String;
begin
  S := Params[0];
  Result := AdjustLineBreaks(S);
end;

function TUsersExtraMethods.Call_AnsiQuotedStr(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := AnsiQuotedStr(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_AnsiDeQuotedStr(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := AnsiDeQuotedStr(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_LeftStr(Instance: TObject; var Params: Variant ): Variant;
var S:String; Count:Integer;
begin
  S := Params[0]; Count:= Params[1];
  Result := LeftStr(S, Count);
end;

function TUsersExtraMethods.Call_RightStr(Instance: TObject; var Params: Variant ): Variant;
var S:String; Count:Integer;
begin
  S := Params[0]; Count:= Params[1];
  Result := RightStr(S, Count);
end;

function TUsersExtraMethods.Call_LineEnding(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := LineEnding;
end;

function TUsersExtraMethods.Call_sLineBreak(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := sLineBreak;
end;

function TUsersExtraMethods.Call_FormatVar(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := FormatVar(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_TrimLeft(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := TrimLeft(Params[0]);
end;

function TUsersExtraMethods.Call_TrimRight(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := TrimRight(Params[0]);
end;

function TUsersExtraMethods.Call_IsEmptyStr(Instance: TObject; var Params: Variant ): Variant;
begin
  Result := IsEmptyStr(Params[0]);
end;

function TUsersExtraMethods.Call_StrToIntDef(Instance: TObject; var Params: Variant ): Variant;
begin
 Result := StrToIntDef(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_StrToDWordDef(Instance: TObject; var Params: Variant ): Variant;
begin
 Result := StrToDWordDef(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_StrToInt64Def(Instance: TObject; var Params: Variant ): Variant;
begin
 Result := StrToInt64Def(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_StrToQWordDef(Instance: TObject; var Params: Variant ): Variant;
begin
 Result := StrToQWordDef(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_StrToFloatDef(Instance: TObject; var Params: Variant ): Variant;
begin
 Result := StrToFloatDef(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_FileSearch(Instance: TObject; var Params: Variant ): Variant;
var FileName,DirList:String; ImplicitCurrDir:Boolean;
begin
 FileName:=Params[0]; DirList:=Params[1]; ImplicitCurrDir:=Params[2];
 Result := FileSearch(FileName, DirList, ImplicitCurrDir);
end;

function TUsersExtraMethods.Call_CookieScan(Instance: TObject; var Params: Variant ): Variant;
begin
 Result := CookieScan(Params[0], Params[1], Params[2]);
end;

function TUsersExtraMethods.Call_csmCaseSensitive(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=csm_CaseSense;
end;

function TUsersExtraMethods.Call_csmNotTrimName(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=csm_SkipTrimN;
end;

function TUsersExtraMethods.Call_csmNotTrimValue(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=csm_SkipTrimV;
end;

function TUsersExtraMethods.Call_ExecuteProcess(Instance: TObject; var Params: Variant ): Variant;
var Path,CmdLine:String; efFlags:Integer; Flags:TExecuteFlags;
begin
 Path:=Params[0]; CmdLine:=Params[1]; efFlags:=Params[2];
 Flags:=[]; if ((efFlags and 1)<>0) then Include(Flags,ExecInheritsHandles);
 Result:=SysUtils.ExecuteProcess(Path,CmdLine,Flags);
end;

function TUsersExtraMethods.Call_ExpandFileName(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=ExpandFileName(Params[0]);
end;

function TUsersExtraMethods.Call_Utf8ToAnsiToHex(Instance: TObject; var Params: Variant ): Variant;
var S:String; A:AnsiString;
begin
 S:=Params[0];
 A:=dp_UTF8ToAnsi(S);
 Result:=StrToHex(A);
end;

function TUsersExtraMethods.Call_RecodeStr(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=RecodeStr(Params[0], Params[1]);
end;

function TUsersExtraMethods.Call_GetHeapStatusAsText(Instance: TObject; var Params: Variant ): Variant;
var S:String;
begin
 with GetHeapStatus do
 S:=((('TotalAddrSpace='+IntToStr(TotalAddrSpace)+LineEnding)
     +('TotalUncommitted='+IntToStr(TotalUncommitted)+LineEnding))
    +(('TotalCommitted='+IntToStr(TotalCommitted)+LineEnding)
     +('TotalAllocated='+IntToStr(TotalAllocated)+LineEnding)))
   +((('TotalFree='+IntToStr(TotalFree)+LineEnding)
     +('FreeSmall='+IntToStr(FreeSmall)+LineEnding))
    +(('FreeBig='+IntToStr(FreeBig)+LineEnding)
     +('Unused='+IntToStr(Unused)+LineEnding)))
   +((('Overhead='+IntToStr(Overhead)+LineEnding)
     +('HeapErrorCode='+IntToStr(HeapErrorCode)+LineEnding)));
 Result:=S;
end;

function TUsersExtraMethods.Call_EasyIpc_Init(Instance: TObject; var Params: Variant ): Variant;
begin
 {$IFDEF WINDOWS}
  Result:=EasyIpc_Init(Params[0], Params[1]);
 {$ELSE}
  Result := 0;
 {$ENDIF}
end;

function TUsersExtraMethods.Call_EasyIpc_Free(Instance: TObject; var Params: Variant ): Variant;
begin
 {$IFDEF WINDOWS}
  Result:=EasyIpc_Free(Params[0]);
 {$ELSE}
  Result := false;
 {$ENDIF}
end;

function TUsersExtraMethods.Call_EasyIpc_Poll(Instance: TObject; var Params: Variant ): Variant;
begin
 {$IFDEF WINDOWS}
  Result:=EasyIpc_Poll(Params[0]);
 {$ELSE}
  Result := false;
 {$ENDIF}
end;

function TUsersExtraMethods.Call_EasyIpc_Send(Instance: TObject; var Params: Variant ): Variant;
begin
 {$IFDEF WINDOWS}
  Result:=EasyIpc_Send(Params[0], Params[1]);
 {$ELSE}
  Result := false;
 {$ENDIF}
end;

function TUsersExtraMethods.Call_EasyIpc_Recv(Instance: TObject; var Params: Variant ): Variant;
begin
 {$IFDEF WINDOWS}
  Result:=EasyIpc_Recv(Params[0], Params[1]);
 {$ELSE}
  Result := '';
 {$ENDIF}
end;

function TUsersExtraMethods.Call_EasyIpc_Ctrl(Instance: TObject; var Params: Variant ): Variant;
begin
 {$IFDEF WINDOWS}
  Result:=EasyIpc_Ctrl(Params[0], Params[1]);
 {$ELSE}
  Result := '';
 {$ENDIF}
end;

function TUsersExtraMethods.Call_TryStrToInt(Instance: TObject; var Params: Variant ): Variant;
var x:LongInt;
begin
 x:=0; Result:=TryStrToInt(Params[0], x);   Params[1]:=x;
end;

function TUsersExtraMethods.Call_TryStrToDWord(Instance: TObject; var Params: Variant ): Variant;
var x:DWord;
begin
 x:=0; Result:=TryStrToDWord(Params[0], x); Params[1]:=x;
end;

function TUsersExtraMethods.Call_TryStrToInt64(Instance: TObject; var Params: Variant ): Variant;
var x:Int64;
begin
 x:=0; Result:=TryStrToInt64(Params[0], x); Params[1]:=x;
end;

function TUsersExtraMethods.Call_TryStrToQWord(Instance: TObject; var Params: Variant ): Variant;
var x:QWord;
begin
 x:=0; Result:=TryStrToQWord(Params[0], x); Params[1]:=x;
end;

function TUsersExtraMethods.Call_TryStrToFloat(Instance: TObject; var Params: Variant ): Variant;
var x:Double;
begin
 x:=0; Result:=TryStrToFloat(Params[0], x); Params[1]:=x;
end;

function TUsersExtraMethods.Call_MaxInt(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=MaxInt;
end;

function TUsersExtraMethods.Call_NaN(Instance: TObject; var Params: Variant ): Variant;
var x:Double;
begin
 x:=NaN;
 Result:=x;
end;

function TUsersExtraMethods.Call_Infinity(Instance: TObject; var Params: Variant ): Variant;
var x:Double;
begin
 x:=Infinity;
 Result:=x;
end;

function TUsersExtraMethods.Call_NegInfinity(Instance: TObject; var Params: Variant ): Variant;
var x:Double;
begin
 x:=NegInfinity;
 Result:=x;
end;

function TUsersExtraMethods.Call_IsNaN(Instance: TObject; var Params: Variant ): Variant;
var x:Double;
begin
 x:=Params[0];
 Result:=IsNaN(x);
end;

function TUsersExtraMethods.Call_IsInfinite(Instance: TObject; var Params: Variant ): Variant;
var x:Double;
begin
 x:=Params[0];
 Result:=IsInfinite(x);
end;

function TUsersExtraMethods.Call_MachEps(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=MachEps;
end;

function TUsersExtraMethods.Call_VarRangeMin(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=VarRangeMin(Params[0]);
end;

function TUsersExtraMethods.Call_VarRangeMax(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=VarRangeMax(Params[0]);
end;

function TUsersExtraMethods.Call_OrdVar(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=OrdVar(Params[0]);
end;

function TUsersExtraMethods.Call_GetLastOsError(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=GetLastOsError;
end;

function TUsersExtraMethods.Call_RaiseLastOsError(Instance: TObject; var Params: Variant ): Variant;
var ErrNo:Integer;
begin
 ErrNo:=Params[0];
 RaiseLastOsError(ErrNo);
 Result:=ErrNo;
end;

function TUsersExtraMethods.Call_GetOsErrorText(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=GetOsErrorText(Params[0]);
end;

function TUsersExtraMethods.Call_ExpandEnvironmentVariables(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=ExpandEnvironmentVariables(Params[0],Params[1]);
end;

function TUsersExtraMethods.Call_emExpandLikeWinC(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=emExpandLikeWinC;
end;

function TUsersExtraMethods.Call_emExpandLikeWinE(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=emExpandLikeWinE;
end;

function TUsersExtraMethods.Call_emExpandLikeUnix(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=emExpandLikeUnix;
end;

function TUsersExtraMethods.Call_emExpandLikeBash(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=emExpandLikeBash;
end;

function TUsersExtraMethods.Call_emExpandDefaults(Instance: TObject; var Params: Variant ): Variant;
begin
 Result:=emExpandDefaults;
end;

{$ENDIF}

initialization

  UsersExtraMethods := TUsersExtraMethods.Create;
  MethodDefList.Add(UsersExtraMethods);

finalization

  UsersExtraMethods.Free;

end.

