unit dpi_Forms;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo;

type

  { TFormsImport }

  TFormsImport = class(TClassImporter)
    function ControlScrollBar_ClientSize(Instance: TObject; var Params: Variant
      ): Variant;
    function ControlScrollBar_ClientSizeWithBar(Instance: TObject;
      var Params: Variant): Variant;
    function ControlScrollBar_ClientSizeWithoutBar(Instance: TObject;
      var Params: Variant): Variant;
    function ControlScrollBar_IsScrollBarVisible(Instance: TObject;
      var Params: Variant): Variant;
    function ControlScrollBar_KindGet(Instance: Pointer): Variant;
    function ControlScrollBar_SizeGet(Instance: Pointer): Variant;
    function TForm_Show(Instance: TObject;
      var Params: Variant): Variant;
    function TForm_Close(Instance: TObject;
      var Params: Variant): Variant;
    function TForm_SelectNext(Instance: TObject;
      var Params: Variant): Variant;
      function TForm_ShowModal(Instance: TObject;
      var Params: Variant): Variant;
    function TForm_Create(Instance: TObject;
      var Params: Variant): Variant;
    function TForm_ModalResult_Get(Instance: Pointer): Variant;
    procedure TForm_ModalResult_Set(Instance: Pointer; AValue: Variant);
    //function TForm_Canvas_get(Instance: Pointer): Variant;
    function TForm_Caption_get(Instance: Pointer): Variant;
    procedure TForm_Caption_Set(Instance: Pointer; AValue: Variant);
    {TFrame}
    function TFrame_Create(Instance: TObject;
      var Params: Variant): Variant;
    {TApplication}
    function TApplication_Title_Get(Instance: Pointer): Variant;
    procedure TApplication_Title_Set(Instance: Pointer; AValue: Variant);
    function TApplication_Terminate(Instance: TObject;
      var Params: Variant): Variant;
    function TApplication_Minimize(Instance: TObject;
      var Params: Variant): Variant;
    function TApplication_Restore(Instance: TObject;
      var Params: Variant): Variant;
    function TApplication_MessageBox(Instance: TObject;
      var Params: Variant): Variant;
    function TApplication_ReleaseComponent(Instance: TObject;
      var Params: Variant): Variant;
    function TApplication_ProcessMessages(Instance: TObject;
      var Params: Variant): Variant;
    function TApplication_ExeName(Instance: Pointer): Variant;
    {TScreen Support}
    function TScreen_MonitorFromPoint(Instance: TObject; var Params: Variant): Variant;
    function TScreen_MonitorFromRect(Instance: TObject; var Params: Variant): Variant;
    function TScreen_MonitorFromWindow(Instance: TObject; var Params: Variant): Variant;
    function TScreen_ActiveControl(Instance: Pointer): Variant;
    function TScreen_ActiveForm(Instance: Pointer): Variant;
    function TScreen_Cursor_Get(Instance: Pointer): Variant;
    procedure TScreen_Cursor_Set(Instance: Pointer; AValue: Variant);
    function TScreen_DM_Get(Instance: TObject; var Params: Variant): Variant;
    function TScreen_DataModuleCount(Instance: Pointer): Variant;
    function TScreen_FocusedForm(Instance: Pointer): Variant;
    function TScreen_MonitorCount(Instance: Pointer): Variant;
    function TSCreen_Monitors(Instance: TObject; var Params: Variant): Variant;
    function TScreen_DesktopRect(Instance: Pointer): Variant;
    function TScreen_DesktopHeight(Instance: Pointer): Variant;
    function TScreen_DesktopLeft(Instance: Pointer): Variant;
    function TScreen_DesktopTop(Instance: Pointer): Variant;
    function TScreen_DesktopWidth(Instance: Pointer): Variant;
    function TScreen_HintFont(Instance: Pointer): Variant;
    function TScreen_IconFont(Instance: Pointer): Variant;
    function TScreen_MenuFont(Instance: Pointer): Variant;
    function TScreen_Fonts(Instance: Pointer): Variant;
    function TScreen_FormCount(Instance: Pointer): Variant;
    function TScreen_Forms(Instance: TObject; var Params: Variant): Variant;
    function TScreen_Height(Instance: Pointer): Variant;
    function TScreen_PixelsPerInch(Instance: Pointer): Variant;
    function TScreen_PrimaryMonitor(Instance: Pointer): Variant;
    function TScreen_Width(Instance: Pointer): Variant;
  private
    function TApplication_ActivateHint(Instance: TObject; var Params: Variant
      ): Variant;
    function TApplication_BringToFront(Instance: TObject; var Params: Variant
      ): Variant;
    function TApplication_GetControlAtMouse(Instance: TObject;
      var Params: Variant): Variant;
    function TApplication_GetEnvironmentList(Instance: TObject;
      var Params: Variant): Variant;
    function TApplication_Handle_Get(Instance: Pointer): Variant;
    procedure TApplication_Handle_Set(Instance: Pointer; AValue: Variant);
    function TApplication_HideHint(Instance: TObject; var Params: Variant
      ): Variant;
    function TApplication_MainForm(Instance: Pointer): Variant;
    function TForm_Free(Instance: TObject; var Params: Variant): Variant;
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  end;

implementation

uses Forms, dpUtils, Controls;

type
  TCloseEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; var Action: TCloseAction);
  end;

  TCloseQueryHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject; var CanClose: Boolean);
    function GetHandlerAdres: Pointer; override;
  end;

  THelpHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    function CallHandler(Command: Word; Data: Longint;
      var CallHelp: Boolean): Boolean;
  end;

procedure TFormsImport.AddConsts(AddConst: TAddConstProc);
begin

end;

procedure TFormsImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TCloseEvent), TCloseEventHandler);
  RegisterHandler(TypeInfo(TCloseQueryEvent), TCloseQueryHandler);
  RegisterHandler(TypeInfo(THelpEvent), THelpHandler);
end;

procedure TFormsImport.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('TModalResult', btInt);
end;

function TFormsImport.ControlScrollBar_ClientSize(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TControlScrollBar(Instance).ClientSize;
end;

function TFormsImport.ControlScrollBar_ClientSizeWithBar(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TControlScrollBar(Instance).ClientSizeWithBar;
end;

function TFormsImport.ControlScrollBar_ClientSizeWithoutBar(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TControlScrollBar(Instance).ClientSizeWithoutBar;
end;

function TFormsImport.ControlScrollBar_IsScrollBarVisible(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TControlScrollBar(Instance).IsScrollBarVisible;
end;

function TFormsImport.ControlScrollBar_KindGet(Instance: Pointer): Variant;
begin
  Result := TControlScrollBar(Instance).Kind;
end;

function TFormsImport.ControlScrollBar_SizeGet(Instance: Pointer): Variant;
begin
  Result := TControlScrollBar(Instance).Size;
end;

procedure TFormsImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TWindowState));
  AddType(TypeInfo(TFormStyle));
  AddType(TypeInfo(TBorderIcon));
  AddType(TypeInfo(TBorderIcons));
  AddType(TypeInfo(TPosition));
  AddType(TypeInfo(TDefaultMonitor));
  AddType(TypeInfo(TCloseAction));
  AddType(TypeInfo(TFormState));
  AddType(TypeInfo(TScrollBarKind));
  AddType(TypeInfo(TScrollBarStyle));

  AddType(TypeInfo(TMonitorDefaultTo));
end;

procedure TFormsImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TApplication, 'ТПриложение').ClassImporter := Self;
  AddClass(TCustomForm).ClassImporter := Self;
  AddClass(TForm, 'ТФорма').ClassImporter := Self;
  AddClass(TMonitor, 'ТМонитор').ClassImporter := Self;
  AddClass(TScreen, 'ТЭкран').ClassImporter := Self;
  AddClass(TFrame, 'ТФрэйм').ClassImporter := Self;
  AddClass(TControlScrollBar).ClassImporter := Self;
end;

procedure TFormsImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TCustomForm then
  begin
    AType.AddMethod('procedure Show', @TForm_Show);
    AType.AddMethod('процедура Показать', @TForm_Show);
    AType.AddMethod('procedure Close', @TForm_Close);
    AType.AddMethod('procedure Free', @TForm_Free);
    AType.AddMethod('процедура Закрыть', @TForm_Close);
    AType.AddMethod('function ShowModal: Integer', @TForm_ShowModal);
    AType.AddMethod('функция ПоказатьМодально: Целое', @TForm_ShowModal);
    AType.AddMethod('procedure SelectNext(AControl: TWinControl; GoForward: Boolean = True)', @TForm_SelectNext);
    AType.AddMethod('процедура ВыбратьСледующий(АКонтрол: TWinControl; Вперед: Логическое = Правда)', @TForm_SelectNext);
    AType.AddProp('ModalResult', 'TModalResult', @TForm_ModalResult_Get, @TForm_ModalResult_Set);
    AType.AddProp('МодальныйРезультат', 'TModalResult', @TForm_ModalResult_Get, @TForm_ModalResult_Set);
  end
  else
  if AType.ValueClassType = TForm then
  begin
    AType.AddMethod('constructor Create(AOwner: TComponent)', @TForm_Create);
    AType.AddMethod('конструктор Создать(АВлвделец: ТКомпонент)', @TForm_Create);
  end
  else
  if AType.ValueClassType = TApplication then
  begin
    AType.AddProp('Title', 'String', @TApplication_Title_Get,  @TApplication_Title_Set);
    AType.AddProp('Handle', 'THandle', @TApplication_Handle_Get, @TApplication_Handle_Set);
    AType.AddProp('ExeName', 'String', @TApplication_ExeName, nil);
    AType.AddProp('MainForm', 'TForm', @TApplication_MainForm);
    AType.AddMethod('procedure Terminate', @TApplication_Terminate);
    AType.AddMethod('procedure Minimize', @TApplication_Minimize);
    AType.AddMethod('procedure Restore', @TApplication_Restore);
    AType.AddMethod('procedure ProcessMessages', @TApplication_ProcessMessages);
    AType.AddMethod('function MessageBox(const Text, Caption: string; Flags: Integer): Integer', @TApplication_MessageBox);
    AType.AddMethod('procedure ReleaseComponent(AComponent: TComponent)', @TApplication_ReleaseComponent);
    AType.AddMethod('procedure GetEnvironmentList(List : TStrings)', @TApplication_GetEnvironmentList);
    AType.AddMethod('procedure BringToFront', @TApplication_BringToFront);
    AType.AddMethod('function GetControlAtMouse: TControl', @TApplication_GetControlAtMouse);
    AType.AddMethod('procedure ActivateHint(CursorPos: TPoint; CheckHintControlChange: Boolean = False)', @TApplication_ActivateHint);
    AType.AddMethod('procedure HideHint', @TApplication_HideHint);
  end
  else
  if AType.ValueClassType = TScreen then
  begin
    AType.AddMethod('function MonitorFromPoint(const Point: TPoint; MonitorDefault: TMonitorDefaultTo = mdNearest): TMonitor', @TScreen_MonitorFromPoint);
    AType.AddMethod('function MonitorFromRect(const Rect: TRect; MonitorDefault: TMonitorDefaultTo = mdNearest): TMonitor', @TScreen_MonitorFromRect);
    AType.AddMethod('function MonitorFromWindow(const Handle: THandle; MonitorDefault: TMonitorDefaultTo = mdNearest): TMonitor', @TScreen_MonitorFromWindow);
    AType.AddProp('ActiveControl', 'TWinControl', @TScreen_ActiveControl, nil);
    AType.AddProp('ActiveForm', 'TForm', @TScreen_ActiveForm, nil);
    AType.AddProp('Cursor', 'TCursor', @TScreen_Cursor_Get, @TScreen_Cursor_Set);
    AType.AddIndexedProp('DataModules', 'TDataModule', 'Integer', @TScreen_DM_Get, nil);
    AType.AddProp('DataModuleCount', 'Integer', @TScreen_DataModuleCount, nil);
    AType.AddProp('FocusedForm', 'TCustomForm', @TScreen_FocusedForm, nil);
    AType.AddProp('MonitorCount', 'Integer', @TScreen_MonitorCount, nil);
    AType.AddIndexedProp('Monitors', 'TMonitor', 'Integer', @TSCreen_Monitors, nil);
    AType.AddProp('DesktopRect', 'TRect', @TScreen_DesktopRect, nil);
    AType.AddProp('DesktopHeight', 'Integer', @TScreen_DesktopHeight, nil);
    AType.AddProp('DesktopLeft', 'Integer', @TScreen_DesktopLeft, nil);
    AType.AddProp('DesktopTop', 'Integer', @TScreen_DesktopTop, nil);
    AType.AddProp('DesktopWidth', 'Integer', @TScreen_DesktopWidth, nil);
    AType.AddProp('HintFont', 'TFont', @TScreen_HintFont, nil);
    AType.AddProp('IconFont', 'TFont', @TScreen_IconFont, nil);
    AType.AddProp('MenuFont', 'TFont', @TScreen_MenuFont, nil);
    AType.AddProp('Fonts', 'TStrings', @TScreen_Fonts, nil);
    AType.AddProp('FormCount', 'Integer', @TScreen_FormCount, nil);
    AType.AddIndexedProp('Forms', 'TForm', 'Integer', @TScreen_Forms, nil);
    AType.AddProp('Height', 'Integer', @TScreen_Height, nil);
    AType.AddProp('PixelsPerInch', 'Integer', @TScreen_PixelsPerInch, nil);
    AType.AddProp('PrimaryMonitor', 'TMonitor', @TScreen_PrimaryMonitor, nil);
    AType.AddProp('Width', 'Integer', @TScreen_Width, nil);
  end
  else
  if AType.ValueClassType = TFrame then
  begin
    AType.AddMethod('constructor Create(AOwner: TComponent)', @TFrame_Create);
    AType.AddMethod('конструктор Создать(аВлвделец: ТКомпонент)', @TFrame_Create);
  end
  else
  if AType.ValueClassType = TControlScrollBar then
  begin
    AType.AddMethod('function ClientSize: integer', @ControlScrollBar_ClientSize);
    AType.AddMethod('function ClientSizeWithBar: integer', @ControlScrollBar_ClientSizeWithBar);
    AType.AddMethod('function ClientSizeWithoutBar: integer', @ControlScrollBar_ClientSizeWithoutBar);
    AType.AddMethod('function IsScrollBarVisible: Boolean', @ControlScrollBar_IsScrollBarVisible);
    AType.AddProp('Kind', 'TScrollBarKind', @ControlScrollBar_KindGet);
    AType.AddProp('Size', 'integer', @ControlScrollBar_SizeGet);
  end;
end;

{TForms}

function TFormsImport.TForm_Show(Instance: TObject;
      var Params: Variant): Variant;
begin
  TCustomForm(Instance).Show;
end;

function TFormsImport.TForm_Close(Instance: TObject;
      var Params: Variant): Variant;
begin
  TCustomForm(Instance).Close;
end;

function TFormsImport.TForm_SelectNext(Instance: TObject;
      var Params: Variant): Variant;
var
  AControl: TWinControl;
begin
  AControl := TWinControl(TSuPtr(Params[0]));
  TCustomForm(Instance).SelectNext(AControl, Params[1], True);
end;

function TFormsImport.TForm_ShowModal(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TCustomForm(Instance).ShowModal;
end;

function TFormsImport.TForm_Create(Instance: TObject;
      var Params: Variant): Variant;
var
  F: TForm;
  AType: TDpType;
  C: TComponent;
begin
  AType := TDpType(TSuPtr(Params[1]));
  if Assigned(Compiler.OnCreateForm) then
  begin
    C := TComponent(TSuPtr(Params[0]));
    F := Compiler.OnCreateForm(C, AType);
    Result := TSuPtr(F);
    if F <> nil then F.FreeNotification(Compiler);
  end
  else
  begin
    C := TComponent(TSuPtr(Params[0]));
    F := TForm.Create(C);
    Result := TSuPtr(F);
    if F <> nil then F.FreeNotification(Compiler);
  end;
end;

function TFormsImport.TFrame_Create(Instance: TObject;
      var Params: Variant): Variant;
var
  F: TFrame;
  AType: TDpType;
  C: TComponent;
begin
  AType := TDpType(TSuPtr(Params[1]));
  if Assigned(Compiler.OnCreateFrame) then
  begin
    C := TComponent(TSuPtr(Params[0]));
    F := Compiler.OnCreateFrame(C, AType);
    Result := TSuPtr(F);
    if F <> nil then F.FreeNotification(Compiler);
  end;
end;

function TFormsImport.TForm_ModalResult_Get(Instance: Pointer): Variant;
begin
  Result := TForm(Instance).ModalResult;
end;

procedure TFormsImport.TForm_ModalResult_Set(Instance: Pointer; AValue: Variant);
begin
  TForm(Instance).ModalResult := AValue;
end;

//function TFormsImport.TForm_Canvas_get(Instance: Pointer): Variant;
//begin
//  Result := TSuPtr(TForm(Instance).Canvas);
//end;

function TFormsImport.TForm_Caption_get(Instance: Pointer): Variant;
begin
  Result := TForm(Instance).Caption
end;

procedure TFormsImport.TForm_Caption_Set(Instance: Pointer; AValue: Variant);
begin
  TForm(Instance).Caption := string(AValue)
end;

{TApplication}

function TFormsImport.TApplication_Title_Get(Instance: Pointer): Variant;
begin
  Result := TApplication(Instance).Title;
end;

procedure TFormsImport.TApplication_Title_Set(Instance: Pointer; AValue: Variant);
begin
  TApplication(Instance).Title := AValue;
end;

function TFormsImport.TApplication_Terminate(Instance: TObject;
      var Params: Variant): Variant;
begin
  TApplication(Instance).Terminate;
end;

function TFormsImport.TApplication_Minimize(Instance: TObject;
      var Params: Variant): Variant;
begin
  TApplication(Instance).Minimize;
end;

function TFormsImport.TApplication_Restore(Instance: TObject;
      var Params: Variant): Variant;
begin
  TApplication(Instance).Restore;
end;

function TFormsImport.TApplication_MessageBox(Instance: TObject;
      var Params: Variant): Variant;
var
  Txt, Capt: string;
begin
  Txt := Params[0]; Capt := Params[1];

  Result := TApplication(Instance).MessageBox(PChar(Txt), PChar(Capt), Params[2]);
end;

function TFormsImport.TApplication_ReleaseComponent(Instance: TObject;
  var Params: Variant): Variant;
begin
  TApplication(Instance).ReleaseComponent(TComponent(TSuPtr(Params[0])));
end;

function TFormsImport.TApplication_ProcessMessages(Instance: TObject;
      var Params: Variant): Variant;
begin
  TApplication(Instance).ProcessMessages;
end;

function TFormsImport.TApplication_ExeName(Instance: Pointer): Variant;
begin
  Result := TApplication(Instance).ExeName;
end;

{TScreen Support}

function TFormsImport.TScreen_MonitorFromPoint(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TScreen(Instance).MonitorFromPoint(PPoint(TSuPtr(Params[0]))^, Params[1]));
end;

function TFormsImport.TScreen_MonitorFromRect(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TScreen(Instance).MonitorFromRect(PRect(TSuPtr(Params[0]))^, Params[1]));
end;

function TFormsImport.TScreen_MonitorFromWindow(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TScreen(Instance).MonitorFromWindow(THandle(Params[0]), Params[1]));
end;

function TFormsImport.TScreen_ActiveControl(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TScreen(Instance).ActiveControl);
end;

function TFormsImport.TScreen_ActiveForm(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TScreen(Instance).ActiveForm);
end;

function TFormsImport.TScreen_Cursor_Get(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).Cursor;
end;

procedure TFormsImport.TScreen_Cursor_Set(Instance: Pointer; AValue: Variant);
begin
  TScreen(Instance).Cursor := AValue;
end;

function TFormsImport.TScreen_DM_Get(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TScreen(Instance).DataModules[Params[0]]);
end;

function TFormsImport.TScreen_DataModuleCount(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).DataModuleCount;
end;

function TFormsImport.TScreen_FocusedForm(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TScreen(Instance).FocusedForm);
end;

function TFormsImport.TScreen_MonitorCount(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).MonitorCount;
end;

function TFormsImport.TSCreen_Monitors(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TScreen(Instance).Monitors[Params[0]]);
end;

function TFormsImport.TScreen_DesktopRect(Instance: Pointer): Variant;
begin
  Compiler.RetRect.Left := 0;
  Compiler.RetRect.Top := 0;
  Compiler.RetRect.Right := TScreen(Instance).DesktopWidth;
  Compiler.RetRect.Bottom := TScreen(Instance).DesktopHeight;
  Result := TSuPtr(@Compiler.RetRect);
end;

function TFormsImport.TScreen_DesktopHeight(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).DesktopHeight;
end;

function TFormsImport.TScreen_DesktopLeft(Instance: Pointer): Variant;
begin
  Result := 0;
end;

function TFormsImport.TScreen_DesktopTop(Instance: Pointer): Variant;
begin
  Result := 0;
end;

function TFormsImport.TScreen_DesktopWidth(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).DesktopWidth;
end;

function TFormsImport.TScreen_HintFont(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TScreen(Instance).HintFont);
end;

function TFormsImport.TScreen_IconFont(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TScreen(Instance).IconFont);
end;

function TFormsImport.TScreen_MenuFont(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TScreen(Instance).MenuFont)
end;

function TFormsImport.TScreen_Fonts(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TScreen(Instance).Fonts)
end;

function TFormsImport.TScreen_FormCount(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).FormCount
end;

function TFormsImport.TScreen_Forms(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TScreen(Instance).Forms[Params[0]]);
end;

function TFormsImport.TScreen_Height(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).Height
end;

function TFormsImport.TScreen_PixelsPerInch(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).PixelsPerInch
end;

function TFormsImport.TScreen_PrimaryMonitor(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TScreen(Instance).PrimaryMonitor)
end;

function TFormsImport.TScreen_Width(Instance: Pointer): Variant;
begin
  Result := TScreen(Instance).Width
end;

function TFormsImport.TApplication_ActivateHint(Instance: TObject;
  var Params: Variant): Variant;
begin
  Application.ActivateHint(PPoint(TSuPtr(Params[0]))^, Params[1]);
end;

function TFormsImport.TApplication_BringToFront(Instance: TObject;
  var Params: Variant): Variant;
begin
  Application.BringToFront;
end;

function TFormsImport.TApplication_GetControlAtMouse(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(Application.GetControlAtMouse);
end;

function TFormsImport.TApplication_GetEnvironmentList(Instance: TObject;
  var Params: Variant): Variant;
begin
  Application.GetEnvironmentList( TStrings(TSuPtr(Params[0])) );
end;

function TFormsImport.TApplication_Handle_Get(Instance: Pointer): Variant;
begin
  Result := TApplication(Instance).Handle;
end;

procedure TFormsImport.TApplication_Handle_Set(Instance: Pointer;
  AValue: Variant);
begin
  TApplication(Instance).Handle := THandle(AValue);
end;

function TFormsImport.TApplication_HideHint(Instance: TObject;
  var Params: Variant): Variant;
begin
  Application.HideHint;
end;

function TFormsImport.TApplication_MainForm(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TApplication(Instance).MainForm );
end;

function TFormsImport.TForm_Free(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TCustomForm(Instance).Free;
end;

{TEvent Handlers support}
procedure TCloseEventHandler.CallHandler(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Action;
  Proc.Exec;
  Action := Proc.Param[1].Value;
end;

function TCloseEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TCloseEventHandler.CallHandler;
end;

procedure TCloseQueryHandler.CallHandler(Sender: TObject; var CanClose: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := CanClose;
  Proc.Exec;
  CanClose := Proc.Param[1].Value;
end;

function TCloseQueryHandler.GetHandlerAdres: Pointer;
begin
  Result := @TCloseQueryHandler.CallHandler;
end;

function THelpHandler.GetHandlerAdres: Pointer;
begin
  Result := @THelpHandler.CallHandler;
end;

function THelpHandler.CallHandler(Command: Word; Data: Longint;
      var CallHelp: Boolean): Boolean;
begin
  Proc.Param[0].Value := Command;
  Proc.Param[1].Value := Data;
  Proc.Param[2].Value := CallHelp;
  Result := Proc.Value;
  CallHelp := Proc.Param[2].Value;
end;

end.

