unit dpi_DialogImport;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo;

type
  TDialogImport = class(TClassImporter)
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
  published
    function TCommonDialog_Execute(Instance: TObject; var Params: Variant): Variant;
    {TOpenDialog support}
    function TFileDialog_FilesGet(Instance: Pointer): Variant;
    function TFileDialog_HistoryListGet(Instance: Pointer): Variant;
    procedure TFileDialog_HistoryListSet(Instance: Pointer; AValue: Variant);
  end;

implementation

uses Dialogs, ExtDlgs, dpUtils;

procedure TDialogImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TFontDialogOption));
  AddType(TypeInfo(TFontDialogOptions));
  AddType(TypeInfo(TFindOption));
  AddType(TypeInfo(TFindOptions));
end;

procedure TDialogImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TCommonDialog).ClassImporter := Self;
  AddClass(TFileDialog).ClassImporter := Self;
  AddClass(TOpenDialog);
  AddClass(TSaveDialog);
  AddClass(TOpenPictureDialog);
  AddClass(TSavePictureDialog);
  AddClass(TFontDialog);
  AddClass(TColorDialog);
  //AddClass(TPrintDialog);
  //AddClass(TPrinterSetupDialog);
  AddClass(TFindDialog);
  AddClass(TReplaceDialog);
  AddClass(TSelectDirectoryDialog);
  AddClass(TCalendarDialog);
  AddClass(TCalculatorDialog);
  //AddClass(TPageSetupDialog);
end;

procedure TDialogImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TCommonDialog then
  begin
    AType.AddMethod('function Execute: Boolean', @TCommonDialog_Execute);
  end
  else
  if AType.ValueClassType = TFileDialog then
  begin
    AType.AddProp('Files', 'TStrings', @TFileDialog_FilesGet, nil);
    AType.AddProp('HistoryList', 'TStrings', @TFileDialog_HistoryListGet, @TFileDialog_HistoryListSet);
  end;
end;

{Dialog support}

function TDialogImport.TCommonDialog_Execute(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCommonDialog(Instance).Execute;
end;

{TOpenDialog support}

function TDialogImport.TFileDialog_FilesGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TOpenDialog(Instance).Files);
end;

function TDialogImport.TFileDialog_HistoryListGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TOpenDialog(Instance).HistoryList);
end;

procedure TDialogImport.TFileDialog_HistoryListSet(Instance: Pointer; AValue: Variant);
begin
  TOpenDialog(Instance).HistoryList := TStrings(TSuPtr(AValue));
end;

end.

