unit dpi_DataControls;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo;

type

  { TDCImport }

  TDCImport = class(TClassImporter)
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  published
    function TDBEdit_FieldGet(Instance: Pointer): Variant;
    function TDBText_FieldGet(Instance: Pointer): Variant;
    function TDBCheckBox_FieldGet(Instance: Pointer): Variant;
    function TDBComboBox_FieldGet(Instance: Pointer): Variant;
    function TDBListBox_FieldGet(Instance: Pointer): Variant;
    function TDBRadioGroup_FieldGet(Instance: Pointer): Variant;
    function TDBMemo_FieldGet(Instance: Pointer): Variant;
    function TDBImage_FieldGet(Instance: Pointer): Variant;
    function TColumn_FieldGet(Instance: Pointer): Variant;
    function TDBCalendar_FieldGet(Instance: Pointer): Variant;
  end;

implementation

uses DBCtrls, DBGrids, dpEvntHadlrs, dpUtils;

procedure TDCImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TDBEdit).ClassImporter := Self;
  AddClass(TDBText).ClassImporter := Self;
  AddClass(TDBCheckBox).ClassImporter := Self;
  AddClass(TDBComboBox).ClassImporter := Self;
  AddClass(TDBListBox).ClassImporter := Self;
  AddClass(TDBRadioGroup).ClassImporter := Self;
  AddClass(TDBMemo).ClassImporter := Self;
  AddClass(TDBImage).ClassImporter := Self;
  AddClass(TDBNavigator);
  AddClass(TDBLookupListBox).ClassImporter := Self;
  AddClass(TDBLookupComboBox).ClassImporter := Self;
  AddClass(TColumn).ClassImporter := Self;
  AddClass(TDBGridColumns).ClassImporter := Self;
  AddClass(TDBGrid).ClassImporter := Self;
  AddClass(TDBCalendar).ClassImporter := Self;
  AddClass(TDBNavButton);
  AddClass(TDBNavigator);
end;

procedure TDCImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TDBNavButtonType));
  AddType(TypeInfo(TDBNavButtonSet));
end;

procedure TDCImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TDBGridClickEvent), TSuNotifyHandler);
end;

procedure TDCImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TDBEdit then
  begin
    AType.AddProp('Field', 'TField', @TDBEdit_FieldGet);
  end
  else
  if AType.ValueClassType = TDBText then
  begin
    AType.AddProp('Field', 'TField', @TDBText_FieldGet);
  end
  else
  if AType.ValueClassType = TDBCheckBox then
  begin
    AType.AddProp('Field', 'TField', @TDBCheckBox_FieldGet);
  end
  else
  if AType.ValueClassType = TDBComboBox then
  begin
    AType.AddProp('Field', 'TField', @TDBComboBox_FieldGet);

  end
  else
  if AType.ValueClassType = TDBListBox then
  begin
    AType.AddProp('Field', 'TField', @TDBListBox_FieldGet);
  end
  else
  if AType.ValueClassType = TDBRadioGroup then
  begin
    AType.AddProp('Field', 'TField', @TDBRadioGroup_FieldGet);
  end
  else
  if AType.ValueClassType = TDBListBox then
  begin
    AType.AddProp('Field', 'TField', @TDBListBox_FieldGet);
  end
  else
  if AType.ValueClassType = TDBMemo then
  begin
    AType.AddProp('Field', 'TField', @TDBMemo_FieldGet);
  end
  else
  if AType.ValueClassType = TDBImage then
  begin
    AType.AddProp('Field', 'TField', @TDBImage_FieldGet);
  end
  else
  if AType.ValueClassType = TColumn then
  begin
    AType.AddProp('Field', 'TField', @TColumn_FieldGet);
  end
  else
  if AType.ValueClassType = TDBCalendar then
  begin
    AType.AddProp('Field', 'TField', @TDBCalendar_FieldGet);
  end;
end;

function TDCImport.TDBEdit_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBEdit(Instance).Field);
end;

function TDCImport.TDBText_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBText(Instance).Field);
end;

function TDCImport.TDBCheckBox_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBCheckBox(Instance).Field);
end;

function TDCImport.TDBComboBox_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBComboBox(Instance).Field);
end;

function TDCImport.TDBListBox_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBListBox(Instance).Field);
end;

function TDCImport.TDBRadioGroup_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBRadioGroup(Instance).Field);
end;

function TDCImport.TDBMemo_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBMemo(Instance).Field);
end;

function TDCImport.TDBImage_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBImage(Instance).Field);
end;

function TDCImport.TColumn_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TColumn(Instance).Field);
end;

function TDCImport.TDBCalendar_FieldGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDBCalendar(Instance).Field);
end;

end.

