unit dpi_Common;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo;

type

  { TCommonImport }

  TCommonImport = class(TClassImporter)
    function PopupNotifier_Hide(Instance: TObject; var Params: Variant
      ): Variant;
    function PopupNotifier_Show(Instance: TObject; var Params: Variant
      ): Variant;
    function PopupNotifier_ShowAtPos(Instance: TObject; var Params: Variant
      ): Variant;
    function StatusPanels_ItemsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function StatusPanels_ItemsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function TabSheet_PageControlGet(Instance: Pointer): Variant;
    procedure TabSheet_PageControlSet(Instance: Pointer; AValue: Variant);
    function TabSheet_TabIndexGet(Instance: Pointer): Variant;
  private
    function TCustomListView_AddItem(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_AlphaSort(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_BeginUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_Canvas_Get(Instance: Pointer): Variant;
    function TCustomListView_Checkboxes_Get(Instance: Pointer): Variant;
    procedure TCustomListView_Checkboxes_Set(Instance: Pointer; AValue: Variant
      );
    function TCustomListView_Clear(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_ClearSelection(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomListView_ColumnCount_Get(Instance: Pointer): Variant;
    function TCustomListView_Column_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_DropTarget_Get(Instance: Pointer): Variant;
    procedure TCustomListView_DropTarget_Set(Instance: Pointer; AValue: Variant
      );
    function TCustomListView_EndUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_FlatScrollBars_Get(Instance: Pointer): Variant;
    procedure TCustomListView_FlatScrollBars_Set(Instance: Pointer;
      AValue: Variant);
    function TCustomListView_FullDrag_Get(Instance: Pointer): Variant;
    procedure TCustomListView_FullDrag_Set(Instance: Pointer; AValue: Variant);
    function TCustomListView_GetItemAt(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_GetNearestItem(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomListView_GetNextItem(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_HotTrack_Get(Instance: Pointer): Variant;
    function TCustomListView_IsEditing(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_ItemFocused_Get(Instance: Pointer): Variant;
    procedure TCustomListView_ItemFocused_Set(Instance: Pointer; AValue: Variant
      );
    function TCustomListView_ItemIndex_Get(Instance: Pointer): Variant;
    procedure TCustomListView_ItemIndex_Set(Instance: Pointer; AValue: Variant);
    function TCustomListView_LastSelected_Get(Instance: Pointer): Variant;
    function TCustomListView_SelCount_Get(Instance: Pointer): Variant;
    function TCustomListView_SelectAll(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_Selected_Get(Instance: Pointer): Variant;
    procedure TCustomListView_Selected_Set(Instance: Pointer; AValue: Variant);
    function TCustomListView_Sort(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomListView_TopItem_Get(Instance: Pointer): Variant;
    procedure TCustomListView__HotTrackSet(Instance: Pointer; AValue: Variant);
    function TCustomTabControl_MultiLine_Get(Instance: Pointer): Variant;
    procedure TCustomTabControl_MultiLine_Set(Instance: Pointer; AValue: Variant
      );
    function TCustomTabControl_PageCount_Get(Instance: Pointer): Variant;
    function TCustomTabControl_PageIndex_Get(Instance: Pointer): Variant;
    procedure TCustomTabControl_PageIndex_Set(Instance: Pointer; AValue: Variant
      );
    function TCustomTabControl_Page_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTabControl_TabHeight_Get(Instance: Pointer): Variant;
    procedure TCustomTabControl_TabHeight_Set(Instance: Pointer; AValue: Variant
      );
    function TCustomTabControl_TabPosition_Get(Instance: Pointer): Variant;
    procedure TCustomTabControl_TabPosition_Set(Instance: Pointer;
      AValue: Variant);
    function TCustomTabControl_TabWidth_Get(Instance: Pointer): Variant;
    procedure TCustomTabControl_TabWidth_Set(Instance: Pointer; AValue: Variant
      );
    function TCustomTreeView_AlphaSort(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_ApplyStoredSelection(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_BeginUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_BottomItem_Get(Instance: Pointer): Variant;
    procedure TCustomTreeView_BottomItem_Set(Instance: Pointer; AValue: Variant
      );
    function TCustomTreeView_ClearInvisibleSelection(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_ClearSelection(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_ConsistencyCheck(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_EndUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_FullCollapse(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_FullExpand(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_GetFirstMultiSelected(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_GetLastMultiSelected(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_GetNodeAt(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_GetNodeWithExpandSignAt(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_IsEditing(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_LoadFromStream(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_LockSelectionChangeEvent(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_MakeSelectionVisible(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_MoveEnd(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_MoveHome(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_MovePageDown(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_MovePageUp(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_MoveToNextNode(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_MoveToPrevNode(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_Select(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_Selected_Get(Instance: Pointer): Variant;
    procedure TCustomTreeView_Selected_Set(Instance: Pointer; AValue: Variant);
    function TCustomTreeView_SelectionVisible(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_SelectList(Instance: TObject; var Params: Variant
      ): Variant;
    function TCustomTreeView_StoreCurrentSelection(Instance: TObject;
      var Params: Variant): Variant;
    function TCustomTreeView_TopItem_Get(Instance: Pointer): Variant;
    procedure TCustomTreeView_TopItem_Set(Instance: Pointer; AValue: Variant);
    function TCustomTreeView_UnlockSelectionChangeEvent(Instance: TObject;
      var Params: Variant): Variant;
    function TListColumns_Add(Instance: TObject; var Params: Variant): Variant;
    function TListColumns_Items_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TListColumns_Items_Set(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_Add(Instance: TObject; var Params: Variant): Variant;
    function TListItems_AddItem(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_BeginUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_Clear(Instance: TObject; var Params: Variant): Variant;
    function TListItems_Count_Get(Instance: Pointer): Variant;
    procedure TListItems_Count_Set(Instance: Pointer; AValue: Variant);
    function TListItems_Delete(Instance: TObject; var Params: Variant): Variant;
    function TListItems_EndUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_Exchange(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_FindCaption(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_FindData(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_IndexOf(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_Insert(Instance: TObject; var Params: Variant): Variant;
    function TListItems_InsertItem(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_Item_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_Item_Set(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItems_Move(Instance: TObject; var Params: Variant): Variant;
    function TListItems_Owner_Get(Instance: Pointer): Variant;
    function TListItem_Caption_Get(Instance: Pointer): Variant;
    procedure TListItem_Caption_Set(Instance: Pointer; AValue: Variant);
    function TListItem_Checked_Get(Instance: Pointer): Variant;
    procedure TListItem_Checked_Set(Instance: Pointer; AValue: Variant);
    function TListItem_Create(Instance: TObject; var Params: Variant): Variant;
    function TListItem_Cut_Get(Instance: Pointer): Variant;
    procedure TListItem_Cut_Set(Instance: Pointer; AValue: Variant);
    function TListItem_Data_Get(Instance: Pointer): Variant;
    procedure TListItem_Data_Set(Instance: Pointer; AValue: Variant);
    function TListItem_Delete(Instance: TObject; var Params: Variant): Variant;
    function TListItem_DropTarget_Get(Instance: Pointer): Variant;
    procedure TListItem_DropTarget_Set(Instance: Pointer; AValue: Variant);
    function TListItem_Focused_Get(Instance: Pointer): Variant;
    procedure TListItem_Focused_Set(Instance: Pointer; AValue: Variant);
    function TListItem_ImageIndex_Get(Instance: Pointer): Variant;
    procedure TListItem_ImageIndex_Set(Instance: Pointer; AValue: Variant);
    function TListItem_Index_Get(Instance: Pointer): Variant;
    function TListItem_Left_Get(Instance: Pointer): Variant;
    procedure TListItem_Left_Set(Instance: Pointer; AValue: Variant);
    function TListItem_ListView_Get(Instance: Pointer): Variant;
    function TListItem_MakeVisible(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItem_Owner_Get(Instance: Pointer): Variant;
    function TListItem_Selected_Get(Instance: Pointer): Variant;
    procedure TListItem_Selected_Set(Instance: Pointer; AValue: Variant);
    function TListItem_StateIndex_Get(Instance: Pointer): Variant;
    procedure TListItem_StateIndex_Set(Instance: Pointer; AValue: Variant);
    function TListItem_SubItemImages_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItem_SubItemImages_Set(Instance: TObject; var Params: Variant
      ): Variant;
    function TListItem_SubItems_Get(Instance: Pointer): Variant;
    procedure TListItem_SubItems_Set(Instance: Pointer; AValue: Variant);
    function TListItem_Top_Get(Instance: Pointer): Variant;
    procedure TListItem_Top_Set(Instance: Pointer; AValue: Variant);
    function TreeNodes_Add(Instance: TObject; var Params: Variant): Variant;
    function TreeNodes_AddChild(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_AddChildFirst(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_AddChildObject(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_AddChildObjectFirst(Instance: TObject;
      var Params: Variant): Variant;
    function TreeNodes_AddFirst(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_AddNode(Instance: TObject; var Params: Variant): Variant;
    function TreeNodes_AddObject(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_AddObjectFirst(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_BeginUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_ConsistencyCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_Count_Get(Instance: Pointer): Variant;
    function TreeNodes_Delete(Instance: TObject; var Params: Variant): Variant;
    function TreeNodes_EndUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_FindNodeWithData(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_FindNodeWithText(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_FindNodeWithTextPath(Instance: TObject;
      var Params: Variant): Variant;
    function TreeNodes_FindTopLvlNode(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_FreeAllNodeData(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_GetFirstNode(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_GetFirstVisibleNode(Instance: TObject;
      var Params: Variant): Variant;
    function TreeNodes_GetLastExpandedSubNode(Instance: TObject;
      var Params: Variant): Variant;
    function TreeNodes_GetLastNode(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_GetLastSubNode(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_GetLastVisibleNode(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_GetSelections(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_Insert(Instance: TObject; var Params: Variant): Variant;
    function TreeNodes_InsertBehind(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_InsertObject(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_InsertObjectBehind(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_IsMultiSelection(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_Item_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_KeepCollapsedNodes_Get(Instance: Pointer): Variant;
    procedure TreeNodes_KeepCollapsedNodes_Set(Instance: Pointer;
      AValue: Variant);
    function TreeNodes_MultiSelect(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_SelectionCount_Get(Instance: Pointer): Variant;
    function TreeNodes_SelectionsChanged(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_TopLvlCount_Get(Instance: Pointer): Variant;
    function TreeNodes_TopLvlItems_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TreeNodes_TopLvlItems_Set(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_AbsoluteIndex_Get(Instance: Pointer): Variant;
    function TTreeNode_AlphaSort(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_BottomExpanded(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_Collapse(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_ConsistencyCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_Count_Get(Instance: Pointer): Variant;
    function TTreeNode_Create(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_Cut_Get(Instance: Pointer): Variant;
    procedure TTreeNode_Cut_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_Data_Get(Instance: Pointer): Variant;
    procedure TTreeNode_Data_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_Delete(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_DeleteChildren(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_Deleting_Get(Instance: Pointer): Variant;
    function TTreeNode_DropTarget_Get(Instance: Pointer): Variant;
    procedure TTreeNode_DropTarget_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_EndEdit(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_Expand(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_Expanded_Get(Instance: Pointer): Variant;
    procedure TTreeNode_Expanded_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_ExpandParents(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_FindNode(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_Focused_Get(Instance: Pointer): Variant;
    procedure TTreeNode_Focused_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_FreeAllNodeData(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetFirstChild(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetFirstVisibleChild(Instance: TObject;
      var Params: Variant): Variant;
    function TTreeNode_GetLastChild(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetLastVisibleChild(Instance: TObject;
      var Params: Variant): Variant;
    function TTreeNode_GetNext(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_GetNextChild(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetNextExpanded(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetNextMultiSelected(Instance: TObject;
      var Params: Variant): Variant;
    function TTreeNode_GetNextSibling(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetNextSkipChildren(Instance: TObject;
      var Params: Variant): Variant;
    function TTreeNode_GetNextVisibleSibling(Instance: TObject;
      var Params: Variant): Variant;
    function TTreeNode_GetParentNodeOfAbsoluteLevel(Instance: TObject;
      var Params: Variant): Variant;
    function TTreeNode_GetPrev(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_GetPrevChild(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetPrevExpanded(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetPrevMultiSelected(Instance: TObject;
      var Params: Variant): Variant;
    function TTreeNode_GetPrevSibling(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetPrevVisible(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_GetPrevVisibleSibling(Instance: TObject;
      var Params: Variant): Variant;
    function TTreeNode_GetTextPath(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_Handle_Get(Instance: Pointer): Variant;
    function TTreeNode_HasAsParent(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_HasChildren_Get(Instance: Pointer): Variant;
    procedure TTreeNode_HasChildren_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_ImageIndex_Get(Instance: Pointer): Variant;
    procedure TTreeNode_ImageIndex_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_IndexOf(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_IndexOfText(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_Index_Get(Instance: Pointer): Variant;
    procedure TTreeNode_Index_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_IsFullHeightVisible_Get(Instance: Pointer): Variant;
    function TTreeNode_IsVisible_Get(Instance: Pointer): Variant;
    function TTreeNode_Items_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_Items_Set(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_Level_Get(Instance: Pointer): Variant;
    function TTreeNode_MakeVisible(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_MoveTo(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_MultiSelected_Get(Instance: Pointer): Variant;
    procedure TTreeNode_MultiSelected_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_MultiSelectGroup(Instance: TObject; var Params: Variant
      ): Variant;
    function TTreeNode_OverlayIndex_Get(Instance: Pointer): Variant;
    procedure TTreeNode_OverlayIndex_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_Owner_Get(Instance: Pointer): Variant;
    function TTreeNode_Parent_Get(Instance: Pointer): Variant;
    function TTreeNode_SelectedIndex_Get(Instance: Pointer): Variant;
    procedure TTreeNode_SelectedIndex_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_Selected_Get(Instance: Pointer): Variant;
    procedure TTreeNode_Selected_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_StateIndex_Get(Instance: Pointer): Variant;
    procedure TTreeNode_StateIndex_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_States_Get(Instance: Pointer): Variant;
    function TTreeNode_SubTreeCount_Get(Instance: Pointer): Variant;
    function TTreeNode_Text_Get(Instance: Pointer): Variant;
    procedure TTreeNode_Text_Set(Instance: Pointer; AValue: Variant);
    function TTreeNode_TreeNodes_Get(Instance: Pointer): Variant;
    function TTreeNode_TreeView_Get(Instance: Pointer): Variant;
    function TTreeNode_Update(Instance: TObject; var Params: Variant): Variant;
    function TTreeNode_Visible_Get(Instance: Pointer): Variant;
    procedure TTreeNode_Visible_Set(Instance: Pointer; AValue: Variant);
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  published
    function TImageListDraw(Instence: TObject; var Params: Variant): Variant;
    function TImageListDrawEffect(Instence: TObject; var Params: Variant): Variant;
    function TImageList_GetCount(Instance: Pointer): Variant;
    function TImagList_GetBitmap(Instence: TObject; var Params: Variant): Variant;
    function TToolButtonClick(Instance: TObject; var Params: Variant): Variant;
  end;

implementation

uses dpEvntHadlrs, dpUtils, ImgList, Controls, Graphics, GraphType, ComCtrls,
  ExtCtrls, PopupNotifier;

function TCommonImport.PopupNotifier_Hide(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TPopupNotifier(Instance).Hide;
end;

function TCommonImport.PopupNotifier_Show(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TPopupNotifier(Instance).Show;
end;

function TCommonImport.PopupNotifier_ShowAtPos(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPopupNotifier(Instance).ShowAtPos(Params[0], Params[1]);
end;

function TCommonImport.StatusPanels_ItemsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TStatusPanels(Instance).Items[Params[0]] );
end;

function TCommonImport.StatusPanels_ItemsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStatusPanels(Instance).Items[Params[0]] := TStatusPanel( TSuPtr( Params[1] ) );
end;

function TCommonImport.TabSheet_PageControlGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TTabSheet(Instance).PageControl );
end;

procedure TCommonImport.TabSheet_PageControlSet(Instance: Pointer;
  AValue: Variant);
begin
  TTabSheet(Instance).PageControl := TPageControl( TSuPtr(AValue) );
end;

function TCommonImport.TabSheet_TabIndexGet(Instance: Pointer): Variant;
begin
  Result := TTabSheet(Instance).TabIndex;
end;

function TCommonImport.TCustomListView_AddItem(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomListView(Instance).AddItem(Params[0], TObject(TSuPtr(Params[1])));
end;

function TCommonImport.TCustomListView_AlphaSort(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomListView(Instance).AlphaSort;
end;

function TCommonImport.TCustomListView_BeginUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomListView(Instance).BeginUpdate;
end;

function TCommonImport.TCustomListView_Canvas_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCustomListView(Instance).Canvas);
end;

function TCommonImport.TCustomListView_Checkboxes_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomListView(Instance).Checkboxes;
end;

procedure TCommonImport.TCustomListView_Checkboxes_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomListView(Instance).Checkboxes := AValue;
end;

function TCommonImport.TCustomListView_Clear(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomListView(Instance).Clear; Result := Unassigned;
end;

function TCommonImport.TCustomListView_ClearSelection(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomListView(Instance).ClearSelection;
end;

function TCommonImport.TCustomListView_ColumnCount_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomListView(Instance).ColumnCount;
end;

function TCommonImport.TCustomListView_Column_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomListView(Instance).Column[Params[0]]);
end;

function TCommonImport.TCustomListView_DropTarget_Get(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(TCustomListView(Instance).DropTarget);
end;

procedure TCommonImport.TCustomListView_DropTarget_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomListView(Instance).DropTarget := TListItem(TSuPtr(AValue));
end;

function TCommonImport.TCustomListView_EndUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomListView(Instance).EndUpdate;
end;

function TCommonImport.TCustomListView_FlatScrollBars_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomListView(Instance).FlatScrollBars;
end;

procedure TCommonImport.TCustomListView_FlatScrollBars_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomListView(Instance).FlatScrollBars := AValue;
end;

function TCommonImport.TCustomListView_FullDrag_Get(Instance: Pointer): Variant;
begin
  Result := TCustomListView(Instance).FullDrag;
end;

procedure TCommonImport.TCustomListView_FullDrag_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomListView(Instance).FullDrag := AValue;
end;

function TCommonImport.TCustomListView_GetItemAt(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomListView(Instance).GetItemAt(Params[0], Params[1]));
end;

function TCommonImport.TCustomListView_GetNearestItem(Instance: TObject;
  var Params: Variant): Variant;
var
  P: TPoint;
begin
  P.X:= Params[0];
  P.Y := Params[1];
  Result := TSuPtr(TCustomListView(Instance).GetNearestItem(P, Params[2]));
end;

function TCommonImport.TCustomListView_GetNextItem(Instance: TObject;
  var Params: Variant): Variant;
type
  PlistItemStates = ^TListItemStates;
begin
  Result := TSuPtr(TCustomListView(Instance).GetNextItem(TListItem(TSuPtr(Params[0])), Params[1], PlistItemStates(TSuPtr(Params[2]))^));
end;

function TCommonImport.TCustomListView_HotTrack_Get(Instance: Pointer): Variant;
begin
  Result :=  TCustomListView(Instance).HotTrack;
end;

function TCommonImport.TCustomListView_IsEditing(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomListView(Instance).IsEditing;
end;

function TCommonImport.TCustomListView_ItemFocused_Get(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(TCustomListView(Instance).ItemFocused);
end;

procedure TCommonImport.TCustomListView_ItemFocused_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomListView(Instance).ItemFocused := TListItem(TSuPtr(AValue));
end;

function TCommonImport.TCustomListView_ItemIndex_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomListView(Instance).ItemIndex;
end;

procedure TCommonImport.TCustomListView_ItemIndex_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomListView(Instance).ItemIndex := AValue;
end;

function TCommonImport.TCustomListView_LastSelected_Get(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(TCustomListView(Instance).LastSelected);
end;

function TCommonImport.TCustomListView_SelCount_Get(Instance: Pointer): Variant;
begin
  Result := TCustomListView(Instance).SelCount;
end;

function TCommonImport.TCustomListView_SelectAll(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomListView(Instance).SelectAll;
end;

function TCommonImport.TCustomListView_Selected_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCustomListView(Instance).Selected);
end;

procedure TCommonImport.TCustomListView_Selected_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomListView(Instance).Selected := TListItem(TSuPtr(AValue));
end;

function TCommonImport.TCustomListView_Sort(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomListView(Instance).Sort;
end;

function TCommonImport.TCustomListView_TopItem_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCustomListView(Instance).TopItem);
end;

procedure TCommonImport.TCustomListView__HotTrackSet(Instance: Pointer;
  AValue: Variant);
begin
  TCustomListView(Instance).HotTrack := AValue;
end;

function TCommonImport.TCustomTabControl_MultiLine_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomTabControl(Instance).MultiLine;
end;

procedure TCommonImport.TCustomTabControl_MultiLine_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomTabControl(Instance).MultiLine := AValue;
end;

function TCommonImport.TCustomTabControl_PageCount_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomTabControl(Instance).PageCount;
end;

function TCommonImport.TCustomTabControl_PageIndex_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomTabControl(Instance).PageIndex;
end;

procedure TCommonImport.TCustomTabControl_PageIndex_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomTabControl(Instance).PageIndex := AValue;
end;

function TCommonImport.TCustomTabControl_Page_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomTabControl(Instance).Page[Params[0]]);
end;

function TCommonImport.TCustomTabControl_TabHeight_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomTabControl(Instance).TabHeight;
end;

procedure TCommonImport.TCustomTabControl_TabHeight_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomTabControl(Instance).TabHeight := AValue;
end;

function TCommonImport.TCustomTabControl_TabPosition_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomTabControl(Instance).TabPosition;
end;

procedure TCommonImport.TCustomTabControl_TabPosition_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomTabControl(Instance).TabPosition := AValue;
end;

function TCommonImport.TCustomTabControl_TabWidth_Get(Instance: Pointer
  ): Variant;
begin
  Result := TCustomTabControl(Instance).TabWidth;
end;

procedure TCommonImport.TCustomTabControl_TabWidth_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomTabControl(Instance).TabWidth := AValue;
end;

function TCommonImport.TCustomTreeView_AlphaSort(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomTreeView(Instance).AlphaSort;
end;

function TCommonImport.TCustomTreeView_ApplyStoredSelection(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).ApplyStoredSelection(TStringList(TSuPtr(Params[0])), Params[1]);
end;

function TCommonImport.TCustomTreeView_BeginUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).BeginUpdate;
end;

function TCommonImport.TCustomTreeView_BottomItem_Get(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr(TCustomTreeView(Instance).BottomItem);
end;

procedure TCommonImport.TCustomTreeView_BottomItem_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomTreeView(Instance).BottomItem := TTreeNode(TSuPtr(AValue));
end;

function TCommonImport.TCustomTreeView_ClearInvisibleSelection(
  Instance: TObject; var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).ClearInvisibleSelection;
end;

function TCommonImport.TCustomTreeView_ClearSelection(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).ClearSelection(Params[0]);
end;

function TCommonImport.TCustomTreeView_ConsistencyCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).ConsistencyCheck;
end;

function TCommonImport.TCustomTreeView_EndUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).EndUpdate;
end;

function TCommonImport.TCustomTreeView_FullCollapse(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).FullCollapse;
end;

function TCommonImport.TCustomTreeView_FullExpand(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).FullExpand;
end;

function TCommonImport.TCustomTreeView_GetFirstMultiSelected(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomTreeView(Instance).GetFirstMultiSelected);
end;

function TCommonImport.TCustomTreeView_GetLastMultiSelected(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomTreeView(Instance).GetLastMultiSelected);
end;

function TCommonImport.TCustomTreeView_GetNodeAt(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomTreeView(Instance).GetNodeAt(Params[0], Params[1]));
end;

function TCommonImport.TCustomTreeView_GetNodeWithExpandSignAt(
  Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomTreeView(Instance).GetNodeWithExpandSignAt(Params[0], Params[1]));
end;

function TCommonImport.TCustomTreeView_IsEditing(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomTreeView(Instance).IsEditing;
end;

function TCommonImport.TCustomTreeView_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).LoadFromFile(Params[0]);
end;

function TCommonImport.TCustomTreeView_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).LoadFromStream(TStream(TSuPtr(Params[0])));
end;

function TCommonImport.TCustomTreeView_LockSelectionChangeEvent(
  Instance: TObject; var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).LockSelectionChangeEvent;
end;

function TCommonImport.TCustomTreeView_MakeSelectionVisible(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).MakeSelectionVisible;
end;

function TCommonImport.TCustomTreeView_MoveEnd(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).MoveEnd(Params[0]);
end;

function TCommonImport.TCustomTreeView_MoveHome(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).MoveHome(Params[0]);
end;

function TCommonImport.TCustomTreeView_MovePageDown(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).MovePageDown(Params[0]);
end;

function TCommonImport.TCustomTreeView_MovePageUp(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).MovePageUp(Params[0]);
end;

function TCommonImport.TCustomTreeView_MoveToNextNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).MoveToNextNode(Params[0]);
end;

function TCommonImport.TCustomTreeView_MoveToPrevNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).MoveToPrevNode(Params[0]);
end;

function TCommonImport.TCustomTreeView_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).SaveToFile(Params[0]);
end;

function TCommonImport.TCustomTreeView_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TCommonImport.TCustomTreeView_Select(Instance: TObject;
  var Params: Variant): Variant;
var
  PShift: PShiftState;
  Node: TTreeNode;
begin
  Node := TTreeNode(TSuPtr(Params[0]));
  PShift := PShiftState(TSuPtr(Params[1]));
  TCustomTreeView(Instance).Select(Node, PShift^);
end;

function TCommonImport.TCustomTreeView_Selected_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCustomTreeView(Instance).Selected);
end;

procedure TCommonImport.TCustomTreeView_Selected_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomTreeView(Instance).Selected := TTreeNode(TSuPtr(AValue));
end;

function TCommonImport.TCustomTreeView_SelectionVisible(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomTreeView(Instance).SelectionVisible;
end;

function TCommonImport.TCustomTreeView_SelectList(Instance: TObject;
  var Params: Variant): Variant;
var
  Nodes: TList;
begin
  Nodes := TList(TSuPtr(Params[0]));
  TCustomTreeView(Instance).Select(Nodes);
end;

function TCommonImport.TCustomTreeView_StoreCurrentSelection(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomTreeView(Instance).StoreCurrentSelection);
end;

function TCommonImport.TCustomTreeView_TopItem_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCustomTreeView(Instance).TopItem);
end;

procedure TCommonImport.TCustomTreeView_TopItem_Set(Instance: Pointer;
  AValue: Variant);
begin
  TCustomTreeView(Instance).TopItem := TTreeNode(TSuPtr(AValue));
end;

function TCommonImport.TCustomTreeView_UnlockSelectionChangeEvent(
  Instance: TObject; var Params: Variant): Variant;
begin
  TCustomTreeView(Instance).UnlockSelectionChangeEvent;
end;

function TCommonImport.TListColumns_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TListColumns(Instance).Add);
end;

function TCommonImport.TListColumns_Items_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TListColumns(Instance).Items[Params[0]]);
end;

function TCommonImport.TListColumns_Items_Set(Instance: TObject;
  var Params: Variant): Variant;
var
  Item: TListColumn;
begin
  Item := TListColumn(TSuPtr(Params[1]));
  TListColumns(Instance).Items[Params[0]] := Item;
end;

function TCommonImport.TListItems_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TListItems(Instance).Add);
end;

function TCommonImport.TListItems_AddItem(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TListItems(Instance).AddItem(TListItem(TSuPtr(Params[0])));
end;

function TCommonImport.TListItems_BeginUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListItems(Instance).BeginUpdate;
end;

function TCommonImport.TListItems_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TListItems(Instance).Clear;
end;

function TCommonImport.TListItems_Count_Get(Instance: Pointer): Variant;
begin
  Result := TListItems(Instance).Count;
end;

procedure TCommonImport.TListItems_Count_Set(Instance: Pointer; AValue: Variant
  );
begin
  TListItems(Instance).Count := AValue;
end;

function TCommonImport.TListItems_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TListItems(Instance).Delete(Params[0]);
end;

function TCommonImport.TListItems_EndUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListItems(Instance).EndUpdate;
end;

function TCommonImport.TListItems_Exchange(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListItems(Instance).Exchange(Params[0], Params[1]);
end;

function TCommonImport.TListItems_FindCaption(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TListItems(Instance).FindCaption(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5]));
end;

function TCommonImport.TListItems_FindData(Instance: TObject;
  var Params: Variant): Variant;
var
  AData: Pointer;
begin
  AData:= Pointer(TSuPtr(Params[0]));
  Result := TSuPtr(TListItems(Instance).FindData(AData));
end;

function TCommonImport.TListItems_IndexOf(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TListItems(Instance).IndexOf(TListItem(TSuPtr(Params[0])));
end;

function TCommonImport.TListItems_Insert(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TListItems(Instance).Insert(Params[0]));
end;

function TCommonImport.TListItems_InsertItem(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListItems(Instance).InsertItem(TListItem(TSuPtr(Params[0])), Params[1]);
end;

function TCommonImport.TListItems_Item_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TListItems(Instance).Item[Params[0]]);
end;

function TCommonImport.TListItems_Item_Set(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListItems(Instance).Item[Params[0]] := TListItem(TSuPtr(Params[1]));
end;

function TCommonImport.TListItems_Move(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TListItems(Instance).Move(Params[0], Params[1]);
end;

function TCommonImport.TListItems_Owner_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TListItems(Instance).Owner);
end;

function TCommonImport.TListItem_Caption_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).Caption;
end;

procedure TCommonImport.TListItem_Caption_Set(Instance: Pointer; AValue: Variant
  );
begin
  TListItem(Instance).Caption := AValue;
end;

function TCommonImport.TListItem_Checked_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).Checked;
end;

procedure TCommonImport.TListItem_Checked_Set(Instance: Pointer; AValue: Variant
  );
begin
  TListItem(Instance).Checked := AValue;
end;

function TCommonImport.TListItem_Create(Instance: TObject; var Params: Variant
  ): Variant;
var
  AOwner: TListItems;
begin
  AOwner := TListItems(TSuPtr(Params[0]));
  Result := TSuPtr(TListItem.Create(AOwner));
end;

function TCommonImport.TListItem_Cut_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).Cut;
end;

procedure TCommonImport.TListItem_Cut_Set(Instance: Pointer; AValue: Variant);
begin
  TListItem(Instance).Cut := AValue;
end;

function TCommonImport.TListItem_Data_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TListItem(Instance).Data);
end;

procedure TCommonImport.TListItem_Data_Set(Instance: Pointer; AValue: Variant);
begin
  TListItem(Instance).Data := Pointer(TSuPtr(AValue));
end;

function TCommonImport.TListItem_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TListItem(Instance).Delete;
end;

function TCommonImport.TListItem_DropTarget_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).DropTarget;
end;

procedure TCommonImport.TListItem_DropTarget_Set(Instance: Pointer;
  AValue: Variant);
begin
  TListItem(Instance).DropTarget := AValue;
end;

function TCommonImport.TListItem_Focused_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).Focused;
end;

procedure TCommonImport.TListItem_Focused_Set(Instance: Pointer; AValue: Variant
  );
begin
  TListItem(Instance).Focused := AValue;
end;

function TCommonImport.TListItem_ImageIndex_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).ImageIndex;
end;

procedure TCommonImport.TListItem_ImageIndex_Set(Instance: Pointer;
  AValue: Variant);
begin
  TListItem(Instance).ImageIndex := Integer(AValue);
end;

function TCommonImport.TListItem_Index_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).Index;
end;

function TCommonImport.TListItem_Left_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).Left;
end;

procedure TCommonImport.TListItem_Left_Set(Instance: Pointer; AValue: Variant);
begin
  TListItem(Instance).Left := AValue;
end;

function TCommonImport.TListItem_ListView_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TListItem(Instance).ListView);
end;

function TCommonImport.TListItem_MakeVisible(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListItem(Instance).MakeVisible(Params[0]);
end;

function TCommonImport.TListItem_Owner_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TListItem(Instance).Owner);
end;

function TCommonImport.TListItem_Selected_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).Selected;
end;

procedure TCommonImport.TListItem_Selected_Set(Instance: Pointer;
  AValue: Variant);
begin
  TListItem(Instance).Selected := AValue;
end;

function TCommonImport.TListItem_StateIndex_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).StateIndex;
end;

procedure TCommonImport.TListItem_StateIndex_Set(Instance: Pointer;
  AValue: Variant);
begin
  TListItem(Instance).StateIndex:= Integer(AValue);
end;

function TCommonImport.TListItem_SubItemImages_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TListItem(Instance).SubItemImages[Params[0]];
end;

function TCommonImport.TListItem_SubItemImages_Set(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListItem(Instance).SubItemImages[Params[0]] := Params[1];
end;

function TCommonImport.TListItem_SubItems_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TListItem(Instance).SubItems);
end;

procedure TCommonImport.TListItem_SubItems_Set(Instance: Pointer;
  AValue: Variant);
begin
  TListItem(Instance).SubItems := TStrings(TSuPtr(AValue));
end;

function TCommonImport.TListItem_Top_Get(Instance: Pointer): Variant;
begin
  Result := TListItem(Instance).Top;
end;

procedure TCommonImport.TListItem_Top_Set(Instance: Pointer; AValue: Variant);
begin
  TListItem(Instance).Top := AValue;
end;

function TCommonImport.TreeNodes_Add(Instance: TObject; var Params: Variant
  ): Variant;
var
  SiblingNode: TTreeNode;
begin
  SiblingNode := TTreeNode(TSuPtr(Params[0]));
  Result := TSuPtr( TTreeNodes(Instance).Add(SiblingNode, Params[1]));
end;

function TCommonImport.TreeNodes_AddChild(Instance: TObject; var Params: Variant
  ): Variant;
var
  ParentNode: TTreeNode;
begin
  ParentNode := TTreeNode(TSuPtr(Params[0]));
  Result := TSuPtr(TTreeNodes(Instance).AddChild(ParentNode, Params[1]));
end;

function TCommonImport.TreeNodes_AddChildFirst(Instance: TObject;
  var Params: Variant): Variant;
var
  ParentNode: TTreeNode;
begin
  ParentNode := TTreeNode(TSuPtr(Params[0]));
  Result := TSuPtr(TTreeNodes(Instance).AddChildFirst(ParentNode, Params[1]));
end;

function TCommonImport.TreeNodes_AddChildObject(Instance: TObject;
  var Params: Variant): Variant;
var
  ParentNode: TTreeNode;
  IO: TIdentObject;
begin
  ParentNode := TTreeNode(TSuPtr(Params[0]));
  IO := TIdentObject(TSuPtr(Params[2]));
  Result := TSuPtr(TTreeNodes(Instance).AddChildObject(ParentNode, Params[1], Pointer(TSuPtr(IO.Value))));
end;

function TCommonImport.TreeNodes_AddChildObjectFirst(Instance: TObject;
  var Params: Variant): Variant;
var
  ParentNode: TTreeNode;
  IO: TIdentObject;
begin
  ParentNode := TTreeNode(TSuPtr(Params[0]));
  IO := TIdentObject(TSuPtr(Params[2]));
  Result := TSuPtr(TTreeNodes(Instance).AddChildObjectFirst(ParentNode, Params[1], Pointer(TSuPtr(IO.Value))));
end;

function TCommonImport.TreeNodes_AddFirst(Instance: TObject; var Params: Variant
  ): Variant;
var
  SiblingNode: TTreeNode;
begin
  SiblingNode := TTreeNode(TSuPtr(Params[0]));
  Result := TSuPtr(TTreeNodes(Instance).AddFirst(SiblingNode, Params[1]));
end;

function TCommonImport.TreeNodes_AddNode(Instance: TObject; var Params: Variant
  ): Variant;
var
  Node, Relative: TTreeNode;
  IO: TIdentObject;
begin
  Node := TTreeNode(TSuPtr(Params[0]));
  Relative := TTreeNode(TSuPtr(Params[1]));
  IO := TIdentObject(TSuPtr(Params[3]));
  Result := TSuPtr(TTreeNodes(Instance).AddNode(Node, Relative, Params[2], Pointer(TSuPtr(IO.Value)), Params[4]));
end;

function TCommonImport.TreeNodes_AddObject(Instance: TObject;
  var Params: Variant): Variant;
var
  IO: TIdentObject;
begin
  IO := TIdentObject(TSuPtr(Params[2]));
  Result := TSuPtr(TTreeNodes(Instance).AddObject(TTreeNode(TSuPtr(Params[0])), Params[1], Pointer(TSuPtr(IO.Value))));
end;

function TCommonImport.TreeNodes_AddObjectFirst(Instance: TObject;
  var Params: Variant): Variant;
var
  IO: TIdentObject;
begin
  IO := TIdentObject(TSuPtr(Params[1]));
  Result := TSuPtr(TTreeNodes(Instance).AddObjectFirst(TTreeNode(TSuPtr(Params[0])),
         Params[1], Pointer(TSuPtr(IO.Value))));
end;

function TCommonImport.TreeNodes_BeginUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNodes(Instance).BeginUpdate;
end;

function TCommonImport.TreeNodes_ConsistencyCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNodes(Instance).ConsistencyCheck;
end;

function TCommonImport.TreeNodes_Count_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNodes(Instance).Count;
end;

function TCommonImport.TreeNodes_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TTreeNodes(Instance).Delete(TTreeNode(TSuPtr(Params[0])));
end;

function TCommonImport.TreeNodes_EndUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNodes(Instance).EndUpdate;
end;

function TCommonImport.TreeNodes_FindNodeWithData(Instance: TObject;
  var Params: Variant): Variant;
var
  IO: TIdentObject;
begin
  IO := TIdentObject(TSuPtr(Params[0]));
  Result := TSuPtr( TTreeNodes(Instance).FindNodeWithData(Pointer(TSuPtr(IO.Value))));
end;

function TCommonImport.TreeNodes_FindNodeWithText(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).FindNodeWithText(Params[0]));
end;

function TCommonImport.TreeNodes_FindNodeWithTextPath(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).FindNodeWithTextPath(Params[0]));
end;

function TCommonImport.TreeNodes_FindTopLvlNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).FindTopLvlNode(Params[0]));
end;

function TCommonImport.TreeNodes_FreeAllNodeData(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNode(Instance).FreeAllNodeData;
end;

function TCommonImport.TreeNodes_GetFirstNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).GetFirstNode);
end;

function TCommonImport.TreeNodes_GetFirstVisibleNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).GetFirstVisibleNode);
end;

function TCommonImport.TreeNodes_GetLastExpandedSubNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).GetLastExpandedSubNode);
end;

function TCommonImport.TreeNodes_GetLastNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).GetLastNode);
end;

function TCommonImport.TreeNodes_GetLastSubNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).GetLastSubNode);
end;

function TCommonImport.TreeNodes_GetLastVisibleNode(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).GetLastVisibleNode);
end;

function TCommonImport.TreeNodes_GetSelections(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).GetSelections(Params[0]));
end;

function TCommonImport.TreeNodes_Insert(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).Insert(TTreeNode(TSuPtr(Params[0])), Params[1]));
end;

function TCommonImport.TreeNodes_InsertBehind(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).InsertBehind(TTreeNode(TSuPtr(Params[0])), Params[1]));
end;

function TCommonImport.TreeNodes_InsertObject(Instance: TObject;
  var Params: Variant): Variant;
var
  NextNode: TTreeNode;
  IO: TIdentObject;
begin
  NextNode := TTreeNode(TSuPtr(Params[0]));
  IO := TIdentObject(TSuPtr(Params[2]));
  Result := TSuPtr(TTreeNodes(Instance).InsertObject(NextNode, Params[1], Pointer(TSuPtr(IO.Value))));
end;

function TCommonImport.TreeNodes_InsertObjectBehind(Instance: TObject;
  var Params: Variant): Variant;
var
  PrevNode: TTreeNode;
  IO: TIdentObject;
begin
  PrevNode := TTreeNode(TSuPtr(Params[0]));
  IO := TIdentObject(TSuPtr(Params[2]));
  Result := TSuPtr(TTreeNodes(Instance).InsertObjectBehind(PrevNode, Params[1], Pointer(TSuPtr(IO.Value))));
end;

function TCommonImport.TreeNodes_IsMultiSelection(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TTreeNodes(Instance).IsMultiSelection;
end;

function TCommonImport.TreeNodes_Item_Get(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).Item[Params[0]]);
end;

function TCommonImport.TreeNodes_KeepCollapsedNodes_Get(Instance: Pointer
  ): Variant;
begin
  Result := TTreeNodes(Instance).KeepCollapsedNodes;
end;

procedure TCommonImport.TreeNodes_KeepCollapsedNodes_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNodes(Instance).KeepCollapsedNodes := AValue;
end;

function TCommonImport.TreeNodes_MultiSelect(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNodes(Instance).MultiSelect(TTreeNode(TSuPtr(Params[0])), Params[1]);
end;

function TCommonImport.TreeNodes_SelectionCount_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNodes(Instance).SelectionCount;
end;

function TCommonImport.TreeNodes_SelectionsChanged(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNodes(Instance).SelectionsChanged(TTreeNode(TSuPtr(Params[0])), Params[1]);
end;

function TCommonImport.TreeNodes_TopLvlCount_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNodes(Instance).TopLvlCount;
end;

function TCommonImport.TreeNodes_TopLvlItems_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNodes(Instance).TopLvlItems[Params[0]]);
end;

function TCommonImport.TreeNodes_TopLvlItems_Set(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNodes(Instance).TopLvlItems[Params[0]] := TTreeNode(TSuPtr(Params[1]));
end;

function TCommonImport.TTreeNode_AbsoluteIndex_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).AbsoluteIndex;
end;

function TCommonImport.TTreeNode_AlphaSort(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TTreeNode(Instance).AlphaSort;
end;

function TCommonImport.TTreeNode_BottomExpanded(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TTreeNode(Instance).BottomExpanded;
end;

function TCommonImport.TTreeNode_Collapse(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TTreeNode(Instance).Collapse(Params[0]);
end;

function TCommonImport.TTreeNode_ConsistencyCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNode(Instance).ConsistencyCheck;
end;

function TCommonImport.TTreeNode_Count_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Count;
end;

function TCommonImport.TTreeNode_Create(Instance: TObject; var Params: Variant
  ): Variant;
var
  Nodes: TTreeNodes;
begin
  Nodes := TTreeNodes(TSuPtr( Params[0] ));
  Result := TSuPtr( TTreeNode.Create(Nodes));
end;

function TCommonImport.TTreeNode_Cut_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Cut;
end;

procedure TCommonImport.TTreeNode_Cut_Set(Instance: Pointer; AValue: Variant);
begin
  TTreeNode(Instance).Cut := AValue;
end;

function TCommonImport.TTreeNode_Data_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TTreeNode(Instance).Data);
end;

procedure TCommonImport.TTreeNode_Data_Set(Instance: Pointer; AValue: Variant);
begin
  TTreeNode(Instance).Data := Pointer(TSuPtr(AValue));
end;

function TCommonImport.TTreeNode_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TTreeNode(Instance).Delete;
end;

function TCommonImport.TTreeNode_DeleteChildren(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNode(Instance).DeleteChildren;
end;

function TCommonImport.TTreeNode_Deleting_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Deleting;
end;

function TCommonImport.TTreeNode_DropTarget_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).DropTarget;
end;

procedure TCommonImport.TTreeNode_DropTarget_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).DropTarget := AValue;
end;

function TCommonImport.TTreeNode_EndEdit(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TTreeNode(Instance).EndEdit(Params[0]);
end;

function TCommonImport.TTreeNode_Expand(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TTreeNode(Instance).Expand(Params[0]);
end;

function TCommonImport.TTreeNode_Expanded_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Expanded;
end;

procedure TCommonImport.TTreeNode_Expanded_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).Expanded := AValue;
end;

function TCommonImport.TTreeNode_ExpandParents(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNode(Instance).ExpandParents;
end;

function TCommonImport.TTreeNode_FindNode(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).FindNode(Params[0]) );
end;

function TCommonImport.TTreeNode_Focused_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Focused;
end;

procedure TCommonImport.TTreeNode_Focused_Set(Instance: Pointer; AValue: Variant
  );
begin
  TTreeNode(Instance).Focused := AValue;
end;

function TCommonImport.TTreeNode_FreeAllNodeData(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNode(Instance).FreeAllNodeData;
end;

function TCommonImport.TTreeNode_GetFirstChild(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetFirstChild );
end;

function TCommonImport.TTreeNode_GetFirstVisibleChild(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetFirstVisibleChild );
end;

function TCommonImport.TTreeNode_GetLastChild(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetLastChild );
end;

function TCommonImport.TTreeNode_GetLastVisibleChild(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetLastVisibleChild );
end;

function TCommonImport.TTreeNode_GetNext(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetNext );
end;

function TCommonImport.TTreeNode_GetNextChild(Instance: TObject;
  var Params: Variant): Variant;
var
  AValue: TTreeNode;
begin
  AValue := TTreeNode( TSuPtr(Params[0]) );
  Result := TSuPtr( TTreeNode(Instance).GetNextChild(AValue) );
end;

function TCommonImport.TTreeNode_GetNextExpanded(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetNextExpanded );
end;

function TCommonImport.TTreeNode_GetNextMultiSelected(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetNextMultiSelected );
end;

function TCommonImport.TTreeNode_GetNextSibling(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetNextSibling );
end;

function TCommonImport.TTreeNode_GetNextSkipChildren(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetNextSkipChildren );
end;

function TCommonImport.TTreeNode_GetNextVisibleSibling(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetNextVisibleSibling );
end;

function TCommonImport.TTreeNode_GetParentNodeOfAbsoluteLevel(
  Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetParentNodeOfAbsoluteLevel(Params[0]) );
end;

function TCommonImport.TTreeNode_GetPrev(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetPrev );
end;

function TCommonImport.TTreeNode_GetPrevChild(Instance: TObject;
  var Params: Variant): Variant;
var
  AValue: TTreeNode;
begin
  AValue := TTreeNode( TSuPtr(Params[0]) );
  Result := TSuPtr( TTreeNode(Instance).GetPrevChild(AValue) );
end;

function TCommonImport.TTreeNode_GetPrevExpanded(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetPrevExpanded );
end;

function TCommonImport.TTreeNode_GetPrevMultiSelected(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetPrevMultiSelected );
end;

function TCommonImport.TTreeNode_GetPrevSibling(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetPrevSibling );
end;

function TCommonImport.TTreeNode_GetPrevVisible(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetPrevVisible );
end;

function TCommonImport.TTreeNode_GetPrevVisibleSibling(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTreeNode(Instance).GetPrevVisibleSibling );
end;

function TCommonImport.TTreeNode_GetTextPath(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TTreeNode(Instance).GetTextPath;
end;

function TCommonImport.TTreeNode_Handle_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Handle;
end;

function TCommonImport.TTreeNode_HasAsParent(Instance: TObject;
  var Params: Variant): Variant;
var
  AValue: TTreeNode;
begin
  AValue := TTreeNode( TSuPtr(Params[0]) );
  Result := TSuPtr( TTreeNode(Instance).HasAsParent(AValue) );
end;

function TCommonImport.TTreeNode_HasChildren_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).HasChildren;
end;

procedure TCommonImport.TTreeNode_HasChildren_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).HasChildren := AValue;
end;

function TCommonImport.TTreeNode_ImageIndex_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).ImageIndex;
end;

procedure TCommonImport.TTreeNode_ImageIndex_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).ImageIndex := TImageIndex(Integer(AValue));
end;

function TCommonImport.TTreeNode_IndexOf(Instance: TObject; var Params: Variant
  ): Variant;
var
  AValue: TTReeNode;
begin
  AValue := TTreeNode(TSuPtr(Params[0]));
  Result := TTreeNode(Instance).IndexOf(AValue);
end;

function TCommonImport.TTreeNode_IndexOfText(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TTreeNode(Instance).IndexOfText(Params[0]);
end;

function TCommonImport.TTreeNode_Index_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Index;
end;

procedure TCommonImport.TTreeNode_Index_Set(Instance: Pointer; AValue: Variant);
begin
  TTreeNode(Instance).Index := AValue;
end;

function TCommonImport.TTreeNode_IsFullHeightVisible_Get(Instance: Pointer
  ): Variant;
begin
  TTreeNode(Instance).IsFullHeightVisible;
end;

function TCommonImport.TTreeNode_IsVisible_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).IsVisible;
end;

function TCommonImport.TTreeNode_Items_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTreeNode(Instance).Items[Params[0]]);
end;

function TCommonImport.TTreeNode_Items_Set(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNode(Instance).Items[Params[0]] := TTreeNode(TSuPtr(Params[1]));
end;

function TCommonImport.TTreeNode_Level_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Level;
end;

function TCommonImport.TTreeNode_MakeVisible(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNode(Instance).MakeVisible;
end;

function TCommonImport.TTreeNode_MoveTo(Instance: TObject; var Params: Variant
  ): Variant;
var
  Dest: TTreeNode;
  Mode: TNodeAttachMode;
begin
  Dest := TTreeNode(TSuPtr(Params[0]));
  Mode := Params[1];
  TTreeNode(Instance).MoveTo(Dest, Mode);
end;

function TCommonImport.TTreeNode_MultiSelected_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).MultiSelected;
end;

procedure TCommonImport.TTreeNode_MultiSelected_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).MultiSelected := AValue;
end;

function TCommonImport.TTreeNode_MultiSelectGroup(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTreeNode(Instance).MultiSelectGroup;
end;

function TCommonImport.TTreeNode_OverlayIndex_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).OverlayIndex;
end;

procedure TCommonImport.TTreeNode_OverlayIndex_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).OverlayIndex := AValue;
end;

function TCommonImport.TTreeNode_Owner_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TTreeNode(Instance).Owner);
end;

function TCommonImport.TTreeNode_Parent_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TTreeNode(Instance).Parent);
end;

function TCommonImport.TTreeNode_SelectedIndex_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).SelectedIndex;
end;

procedure TCommonImport.TTreeNode_SelectedIndex_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).SelectedIndex := AValue;
end;

function TCommonImport.TTreeNode_Selected_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Selected;
end;

procedure TCommonImport.TTreeNode_Selected_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).Selected := AValue;
end;

function TCommonImport.TTreeNode_StateIndex_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).StateIndex;
end;

procedure TCommonImport.TTreeNode_StateIndex_Set(Instance: Pointer;
  AValue: Variant);
begin
  TTreeNode(Instance).StateIndex := AValue;
end;

function TCommonImport.TTreeNode_States_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( @TTreeNode(Instance).States);
end;

function TCommonImport.TTreeNode_SubTreeCount_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).SubTreeCount;
end;

function TCommonImport.TTreeNode_Text_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Text;
end;

procedure TCommonImport.TTreeNode_Text_Set(Instance: Pointer; AValue: Variant);
begin
  TTreeNode(Instance).Text := AValue;
end;

function TCommonImport.TTreeNode_TreeNodes_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TTreeNode( Instance).TreeNodes);
end;

function TCommonImport.TTreeNode_TreeView_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TTreeNode(Instance).TreeView);
end;

function TCommonImport.TTreeNode_Update(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TTreeNode(Instance).Update;
end;

function TCommonImport.TTreeNode_Visible_Get(Instance: Pointer): Variant;
begin
  Result := TTreeNode(Instance).Visible;
end;

procedure TCommonImport.TTreeNode_Visible_Set(Instance: Pointer; AValue: Variant
  );
begin
  TTreeNode(Instance).Visible := AValue;
end;

procedure TCommonImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TCustomImageList).ClassImporter := Self;
  AddClass(TImageList).ClassImporter := Self;
  AddClass(TProgressBar);
  AddClass(TTreeNodes).ClassImporter := Self;
  AddClass(TTreeNode).ClassImporter := Self;
  AddClass(TListItem).ClassImporter := Self;
  AddClass(TListItems).ClassImporter := Self;
  AddClass(TListColumn);
  AddClass(TListColumns).ClassImporter := Self;
  AddClass(TCustomTreeView).ClassImporter := Self;
  AddClass(TCustomListView).ClassImporter := Self;
  AddClass(TTreeView);
  AddClass(TListView);
  AddClass(TStatusBar);
  AddClass(TStatusPanels).ClassImporter := Self;
  AddClass(TStatusPanel);
  AddClass(TToolBar);
  AddClass(TToolButton).ClassImporter := Self;
  //AddClass(TCustomPage).ClassImporter := Self;
  AddClass(TTabSheet).ClassImporter := Self;
  AddClass(TCustomTabControl).ClassImporter := Self;
  AddClass(TPageControl);
  AddClass(TTabControl);
  AddClass(TPopupNotifier).ClassImporter := Self;
end;

procedure TCommonImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TNodeState));
  AddType(TypeInfo(TNodeStates));
  AddType(TypeInfo(TNodeAttachMode));
  AddType(TypeInfo(TAddMode));
  AddType(TypeInfo(TMultiSelectStyles));
  AddType(TypeInfo(TMultiSelectStyle));
  AddType(TypeInfo(TTreeNodeChangeReason));
  { TCustomListView }
  AddType(TypeInfo(TItemChange));
  AddType(TypeInfo(TSearchDirection));
  AddType(TypeInfo(TViewStyle));
  AddType(TypeInfo(TListItemState));
  AddType(TypeInfo(TListItemStates));
  {TCustomTabControl}
  AddType(TypeInfo(TTabStyle));
  AddType(TypeInfo(TTabPosition));
end;

procedure TCommonImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TCustomImageList then
  begin
    AType.AddProp('Count', 'Integer', @TImageList_GetCount, nil);
    AType.AddMethod('procedure Draw(Canvas: TCanvas; X, Y, Index: Integer; Enabled: Boolean = True)', @TImageListDraw);
    AType.AddMethod('procedure DrawEffect(ACanvas: TCanvas; AX, AY, AIndex: Integer; ADrawEffect: TGraphicsDrawEffect)', @TImageListDrawEffect);
    AType.AddMethod('function GetBitmap(Index: Integer; Image: TBitmap): Boolean', @TImagList_GetBitmap);
  end
  else
  if AType.ValueClassType = TToolButton then
  begin
    AType.AddMethod('procedure Click', @TToolButtonClick);
  end
  else
  if AType.ValueClassType = TTabSheet then
  begin
    AType.AddProp('PageControl', 'TPageControl', @TabSheet_PageControlGet, @TabSheet_PageControlSet);
    AType.AddProp('TabIndex', 'Integer', @TabSheet_TabIndexGet);
  end
  else
  if AType.ValueClassType = TStatusPanels then
  begin
    AType.AddIndexedProp('Items', 'TStatusPanel', 'Integer', @StatusPanels_ItemsGet, @StatusPanels_ItemsSet);
  end
  else
  if AType.ValueClassType = TPopupNotifier then
  begin
    AType.AddMethod('procedure Hide', @PopupNotifier_Hide);
    AType.AddMethod('procedure Show', @PopupNotifier_Show);
    AType.AddMethod('procedure ShowAtPos(x: Integer; y: Integer)', @PopupNotifier_ShowAtPos);
  end
  else
  if AType.ValueClassType = TTreeNode then
  begin
    AType.AddMethod('constructor Create(AnOwner: TTreeNodes)', @TTreeNode_Create);
    AType.AddMethod('function AlphaSort: Boolean', @TTreeNode_AlphaSort);
    AType.AddMethod('function BottomExpanded: integer', @TTreeNode_BottomExpanded);
    AType.AddMethod('function FindNode(const NodeText: string): TTreeNode', @TTreeNode_FindNode);
    AType.AddMethod('function GetFirstChild: TTreeNode', @TTreeNode_GetFirstChild);
    AType.AddMethod('function GetFirstVisibleChild: TTreeNode', @TTreeNode_GetFirstVisibleChild);
    AType.AddMethod('function GetLastChild: TTreeNode', @TTreeNode_GetLastChild);
    AType.AddMethod('function GetLastVisibleChild: TTreeNode', @TTreeNode_GetLastVisibleChild);
    AType.AddMethod('function GetNext: TTreeNode', @TTreeNode_GetNext);
    AType.AddMethod('function GetNextChild(AValue: TTreeNode): TTreeNode', @TTreeNode_GetNextChild);
    AType.AddMethod('function GetNextExpanded: TTreeNode', @TTreeNode_GetNextExpanded);
    AType.AddMethod('function GetNextMultiSelected: TTreeNode', @TTreeNode_GetNextMultiSelected);
    AType.AddMethod('function GetNextSibling: TTreeNode', @TTreeNode_GetNextSibling);
    AType.AddMethod('function GetNextSkipChildren: TTreeNode', @TTreeNode_GetNextSkipChildren);
    AType.AddMethod('function GetNextVisibleSibling: TTreeNode', @TTreeNode_GetNextVisibleSibling);
    AType.AddMethod('function GetParentNodeOfAbsoluteLevel(TheAbsoluteLevel: integer): TTreeNode', @TTreeNode_GetParentNodeOfAbsoluteLevel);
    AType.AddMethod('function GetPrev: TTreeNode', @TTreeNode_GetPrev);
    AType.AddMethod('function GetPrevChild(AValue: TTreeNode): TTreeNode', @TTreeNode_GetPrevChild);
    AType.AddMethod('function GetPrevExpanded: TTreeNode', @TTreeNode_GetPrevExpanded);
    AType.AddMethod('function GetPrevMultiSelected: TTreeNode', @TTreeNode_GetPrevMultiSelected);
    AType.AddMethod('function GetPrevSibling: TTreeNode', @TTreeNode_GetPrevSibling);
    AType.AddMethod('function GetPrevVisible: TTreeNode', @TTreeNode_GetPrevVisible);
    AType.AddMethod('function GetPrevVisibleSibling: TTreeNode', @TTreeNode_GetPrevVisibleSibling);
    AType.AddMethod('function GetTextPath: string', @TTreeNode_GetTextPath);
    AType.AddMethod('function HasAsParent(AValue: TTreeNode): Boolean', @TTreeNode_HasAsParent);
    AType.AddMethod('function IndexOf(AValue: TTreeNode): Integer', @TTreeNode_IndexOf);
    AType.AddMethod('function IndexOfText(const NodeText: string): Integer', @TTreeNode_IndexOfText);
    AType.AddMethod('procedure Collapse(Recurse: Boolean)', @TTreeNode_Collapse);
    AType.AddMethod('procedure ConsistencyCheck', @TTreeNode_ConsistencyCheck);
    AType.AddMethod('procedure Delete', @TTreeNode_Delete);
    AType.AddMethod('procedure DeleteChildren', @TTreeNode_DeleteChildren);
    AType.AddMethod('procedure EndEdit(Cancel: Boolean)', @TTreeNode_EndEdit);
    AType.AddMethod('procedure Expand(Recurse: Boolean)', @TTreeNode_Expand);
    AType.AddMethod('procedure ExpandParents', @TTreeNode_ExpandParents);
    AType.AddMethod('procedure FreeAllNodeData', @TTreeNode_FreeAllNodeData);
    AType.AddMethod('procedure MakeVisible', @TTreeNode_MakeVisible);
    AType.AddMethod('procedure MoveTo(Destination: TTreeNode; Mode: TNodeAttachMode)', @TTreeNode_MoveTo);
    AType.AddMethod('procedure MultiSelectGroup', @TTreeNode_MultiSelectGroup);
    AType.AddMethod('procedure Update', @TTreeNode_Update);
    AType.AddProp('AbsoluteIndex', 'Integer', @TTreeNode_AbsoluteIndex_Get);
    AType.AddProp('Count', 'Integer', @TTreeNode_Count_Get);
    AType.AddProp('Cut', 'Boolean', @TTreeNode_Cut_Get, @TTreeNode_Cut_Set);
    AType.AddProp('Data', 'Pointer', @TTreeNode_Data_Get, @TTreeNode_Data_Set);
    AType.AddProp('Deleting', 'Boolean', @TTreeNode_Deleting_Get);
    AType.AddProp('DropTarget', 'Boolean', @TTreeNode_DropTarget_Get, @TTreeNode_DropTarget_Set);
    AType.AddProp('Expanded', 'Boolean', @TTreeNode_Expanded_Get, @TTreeNode_Expanded_Set);
    AType.AddProp('Focused', 'Boolean', @TTreeNode_Focused_Get, @TTreeNode_Focused_Set);
    AType.AddProp('Handle', 'THandle', @TTreeNode_Handle_Get);
    AType.AddProp('HasChildren', 'Boolean', @TTreeNode_HasChildren_Get, @TTreeNode_HasChildren_Set);
    AType.AddProp('ImageIndex', 'TImageIndex', @TTreeNode_ImageIndex_Get, @TTreeNode_ImageIndex_Set);
    AType.AddProp('Index', 'Integer', @TTreeNode_Index_Get, @TTreeNode_Index_Set);
    AType.AddProp('IsFullHeightVisible', 'Boolean', @TTreeNode_IsFullHeightVisible_Get);
    AType.AddProp('IsVisible', 'Boolean', @TTreeNode_IsVisible_Get);
    AType.AddIndexedProp('Items','TTreeNode','Integer', @TTreeNode_Items_Get, @TTreeNode_Items_Set);
    AType.AddProp('Level', 'Integer', @TTreeNode_Level_Get);
    AType.AddProp('MultiSelected', 'Boolean', @TTreeNode_MultiSelected_Get, @TTreeNode_MultiSelected_Set);
    AType.AddProp('OverlayIndex', 'Integer', @TTreeNode_OverlayIndex_Get, @TTreeNode_OverlayIndex_Set);
    AType.AddProp('Owner', 'TTreeNodes', @TTreeNode_Owner_Get);
    AType.AddProp('Parent', 'TTreeNodes', @TTreeNode_Parent_Get);
    AType.AddProp('Selected', 'Boolean', @TTreeNode_Selected_Get, @TTreeNode_Selected_Set);
    AType.AddProp('SelectedIndex', 'Integer', @TTreeNode_SelectedIndex_Get, @TTreeNode_SelectedIndex_Set);
    AType.AddProp('StateIndex', 'Integer', @TTreeNode_StateIndex_Get, @TTreeNode_StateIndex_Set);
    AType.AddProp('States', 'TNodeStates', @TTreeNode_States_Get);
    AType.AddProp('SubTreeCount', 'integer', @TTreeNode_SubTreeCount_Get);
    AType.AddProp('Text', 'string', @TTreeNode_Text_Get, @TTreeNode_Text_Set);
    AType.AddProp('TreeNodes', 'TTreeNodes', @TTreeNode_TreeNodes_Get);
    AType.AddProp('TreeView', 'TCustomTreeView', @TTreeNode_TreeView_Get);
    AType.AddProp('Visible', 'Boolean', @TTreeNode_Visible_Get, @TTreeNode_Visible_Set);
  end
  else
  if AType.ValueClassType = TTreeNodes then
  begin
    AType.AddMethod('function Add(SiblingNode: TTreeNode; const S: string): TTreeNode', @TreeNodes_Add);
    AType.AddMethod('function AddChild(ParentNode: TTreeNode; const S: string): TTreeNode', @TreeNodes_AddChild);
    AType.AddMethod('function AddChildFirst(ParentNode: TTreeNode; const S: string): TTreeNode', @TreeNodes_AddChildFirst);
    AType.AddMethod('function AddChildObject(ParentNode: TTreeNode; const S: string; Data: Pointer): TTreeNode', @TreeNodes_AddChildObject);
    AType.AddMethod('function AddChildObjectFirst(ParentNode: TTreeNode; const S: string; Data: Pointer): TTreeNode', @TreeNodes_AddChildObjectFirst);
    AType.AddMethod('function AddFirst(SiblingNode: TTreeNode; const S: string): TTreeNode', @TreeNodes_AddFirst);
    AType.AddMethod('function AddNode(Node: TTreeNode; Relative: TTreeNode; const S: string; Ptr: Pointer; AMethod: TNodeAttachMode): TTreeNode', @TreeNodes_AddNode);
    AType.AddMethod('function AddObject(SiblingNode: TTreeNode; const S: string; Data: Pointer): TTreeNode', @TreeNodes_AddObject);
    AType.AddMethod('function AddObjectFirst(SiblingNode: TTreeNode; const S: string; Data: Pointer): TTreeNode', @TreeNodes_AddObjectFirst);
    AType.AddMethod('function FindNodeWithData(const NodeData: Pointer): TTreeNode', @TreeNodes_FindNodeWithData);
    AType.AddMethod('function FindNodeWithText(const NodeText: string): TTreeNode', @TreeNodes_FindNodeWithText);
    AType.AddMethod('function FindNodeWithTextPath(TextPath: string): TTreeNode', @TreeNodes_FindNodeWithTextPath);
    AType.AddMethod('function FindTopLvlNode(const NodeText: string): TTreeNode', @TreeNodes_FindTopLvlNode);
    AType.AddMethod('function GetFirstNode: TTreeNode', @TreeNodes_GetFirstNode);
    AType.AddMethod('function GetFirstVisibleNode: TTreeNode', @TreeNodes_GetFirstVisibleNode);
    AType.AddMethod('function GetLastExpandedSubNode: TTreeNode', @TreeNodes_GetLastExpandedSubNode);
    AType.AddMethod('function GetLastNode: TTreeNode', @TreeNodes_GetLastNode);
    AType.AddMethod('function GetLastSubNode: TTreeNode', @TreeNodes_GetLastSubNode);
    AType.AddMethod('function GetLastVisibleNode: TTreeNode', @TreeNodes_GetLastVisibleNode);
    AType.AddMethod('function GetSelections(const AIndex: Integer): TTreeNode', @TreeNodes_GetSelections);
    AType.AddMethod('function Insert(NextNode: TTreeNode; const S: string): TTreeNode', @TreeNodes_Insert);
    AType.AddMethod('function InsertBehind(PrevNode: TTreeNode; const S: string): TTreeNode', @TreeNodes_InsertBehind);
    AType.AddMethod('function InsertObject(NextNode: TTreeNode; const S: string; Data: Pointer): TTreeNode;', @TreeNodes_InsertObject);
    AType.AddMethod('function InsertObjectBehind(PrevNode: TTreeNode; const S: string; Data: Pointer): TTreeNode', @TreeNodes_InsertObjectBehind);
    AType.AddMethod('function IsMultiSelection: boolean', @TreeNodes_IsMultiSelection);
    AType.AddMethod('procedure BeginUpdate', @TreeNodes_BeginUpdate);
    AType.AddMethod('procedure ConsistencyCheck', @TreeNodes_ConsistencyCheck);
    AType.AddMethod('procedure Delete(Node: TTreeNode)', @TreeNodes_Delete);
    AType.AddMethod('procedure EndUpdate', @TreeNodes_EndUpdate);
    AType.AddMethod('procedure FreeAllNodeData', @TreeNodes_FreeAllNodeData);
    AType.AddMethod('procedure SelectionsChanged(ANode: TTreeNode; const AIsSelected: Boolean)', @TreeNodes_SelectionsChanged);
    AType.AddMethod('procedure MultiSelect(Node: TTreeNode; ClearWholeSelection: Boolean)', @TreeNodes_MultiSelect);
    AType.AddProp('Count', 'Integer', @TreeNodes_Count_Get);
    AType.AddIndexedProp('Item','TTreeNode','Integer',  @TreeNodes_Item_Get);
    AType.AddProp('KeepCollapsedNodes', 'boolean', @TreeNodes_KeepCollapsedNodes_Get, @TreeNodes_KeepCollapsedNodes_Set);
    AType.AddProp('SelectionCount', 'Cardinal', @TreeNodes_SelectionCount_Get);
    AType.AddProp('TopLvlCount', 'integer', @TreeNodes_TopLvlCount_Get);
    AType.AddIndexedProp('TopLvlItems','TTreeNode','Integer',  @TreeNodes_TopLvlItems_Get, @TreeNodes_TopLvlItems_Set);
  end
  else
  if AType.ValueClassType = TCustomTreeView then
  begin
    AType.AddMethod('function AlphaSort: Boolean', @TCustomTreeView_AlphaSort);
    AType.AddMethod('procedure ConsistencyCheck', @TCustomTreeView_ConsistencyCheck);
    AType.AddMethod('procedure ClearSelection(KeepPrimary: Boolean = false)', @TCustomTreeView_ClearSelection);
    AType.AddMethod('function GetNodeAt(X, Y: Integer): TTreeNode', @TCustomTreeView_GetNodeAt);
    AType.AddMethod('function GetNodeWithExpandSignAt(X, Y: Integer): TTreeNode', @TCustomTreeView_GetNodeWithExpandSignAt);
    AType.AddMethod('function IsEditing: Boolean', @TCustomTreeView_IsEditing);
    AType.AddMethod('procedure BeginUpdate', @TCustomTreeView_BeginUpdate);
    AType.AddMethod('procedure EndUpdate', @TCustomTreeView_EndUpdate);
    AType.AddMethod('procedure FullCollapse', @TCustomTreeView_FullCollapse);
    AType.AddMethod('procedure FullExpand', @TCustomTreeView_FullExpand);
    AType.AddMethod('procedure LoadFromFile(const FileName: string)', @TCustomTreeView_LoadFromFile);
    AType.AddMethod('procedure SaveToFile(const FileName: string)', @TCustomTreeView_SaveToFile);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @TCustomTreeView_LoadFromStream);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @TCustomTreeView_SaveToStream);
    AType.AddMethod('procedure LockSelectionChangeEvent', @TCustomTreeView_LockSelectionChangeEvent);
    AType.AddMethod('procedure UnlockSelectionChangeEvent', @TCustomTreeView_UnlockSelectionChangeEvent);
    AType.AddMethod('function GetFirstMultiSelected: TTreeNode', @TCustomTreeView_GetFirstMultiSelected);
    AType.AddMethod('function GetLastMultiSelected: TTreeNode', @TCustomTreeView_GetLastMultiSelected);
    AType.AddMethod('procedure Select(Node: TTreeNode; ShiftState: TShiftState = []);', @TCustomTreeView_Select);
    AType.AddMethod('procedure SelectList(Nodes: TList)', @TCustomTreeView_SelectList);
    AType.AddMethod('function SelectionVisible: boolean', @TCustomTreeView_SelectionVisible);
    AType.AddMethod('procedure MakeSelectionVisible', @TCustomTreeView_MakeSelectionVisible);
    AType.AddMethod('procedure ClearInvisibleSelection', @TCustomTreeView_ClearInvisibleSelection);
    AType.AddMethod('function StoreCurrentSelection: TStringList', @TCustomTreeView_StoreCurrentSelection);
    AType.AddMethod('procedure ApplyStoredSelection(ASelection: TStringList; FreeList: boolean = True)', @TCustomTreeView_ApplyStoredSelection);
    AType.AddMethod('procedure MoveToNextNode(ASelect: Boolean = False)', @TCustomTreeView_MoveToNextNode);
    AType.AddMethod('procedure MoveToPrevNode(ASelect: Boolean = False)', @TCustomTreeView_MoveToPrevNode);
    AType.AddMethod('procedure MovePageDown(ASelect: Boolean = False)', @TCustomTreeView_MovePageDown);
    AType.AddMethod('procedure MovePageUp(ASelect: Boolean = False)', @TCustomTreeView_MovePageUp);
    AType.AddMethod('procedure MoveHome(ASelect: Boolean = False)', @TCustomTreeView_MoveHome);
    AType.AddMethod('procedure MoveEnd(ASelect: Boolean = False)', @TCustomTreeView_MoveEnd);
    AType.AddProp('Selected','TTreeNode', @TCustomTreeView_Selected_Get, @TCustomTreeView_Selected_Set);
    AType.AddProp('BottomItem','TTreeNode', @TCustomTreeView_BottomItem_Get, @TCustomTreeView_BottomItem_Set);
    AType.AddProp('TopItem','TTreeNode', @TCustomTreeView_TopItem_Get, @TCustomTreeView_TopItem_Set);
  end
  else
  if AType.ValueClassType = TListItem then
  begin
    AType.AddMethod('constructor Create(AOwner: TListItems)', @TListItem_Create);
    AType.AddMethod('procedure Delete', @TListItem_Delete);
    AType.AddMethod('procedure MakeVisible(PartialOK: Boolean)', @TListItem_MakeVisible);
    AType.AddProp('Caption', 'String', @TListItem_Caption_Get, @TListItem_Caption_Set);
    AType.AddProp('Checked', 'Boolean', @TListItem_Checked_Get, @TListItem_Checked_Set);
    AType.AddProp('Cut', 'Boolean', @TListItem_Cut_Get, @TListItem_Cut_Set);
    AType.AddProp('Data', 'Pointer', @TListItem_Data_Get, @TListItem_Data_Set);
    AType.AddProp('DropTarget', 'Boolean', @TListItem_DropTarget_Get, @TListItem_DropTarget_Set);
    AType.AddProp('Focused', 'Boolean', @TListItem_Focused_Get, @TListItem_Focused_Set);
    AType.AddProp('Index', 'Integer', @TListItem_Index_Get);
    AType.AddProp('ImageIndex','TImageIndex', @TListItem_ImageIndex_Get, @TListItem_ImageIndex_Set);
    AType.AddProp('Left', 'Integer', @TListItem_Left_Get, @TListItem_Left_Set);
    AType.AddProp('ListView', 'TCustomListView', @TListItem_ListView_Get);
    AType.AddProp('Owner', 'TListItems', @TListItem_Owner_Get);
    AType.AddProp('Selected', 'Boolean', @TListItem_Selected_Get, @TListItem_Selected_Set);
    AType.AddProp('StateIndex', 'TImageIndex', @TListItem_StateIndex_Get, @TListItem_StateIndex_Set);
    AType.AddProp('SubItems','TStrings', @TListItem_SubItems_Get, @TListItem_SubItems_Set);
    AType.AddProp('Top','Integer', @TListItem_Top_Get, @TListItem_Top_Set);
    AType.AddIndexedProp('SubItemImages', 'Integer', 'Integer', @TListItem_SubItemImages_Get, @TListItem_SubItemImages_Set);
  end
  else
  if AType.ValueClassType = TListItems then
  begin
    AType.AddMethod('function Add: TListItem', @TListItems_Add);
    AType.AddMethod('procedure AddItem(AItem: TListItem)', @TListItems_AddItem);
    AType.AddMethod('procedure BeginUpdate', @TListItems_BeginUpdate);
    AType.AddMethod('procedure Clear', @TListItems_Clear);
    AType.AddMethod('procedure Delete(const AIndex : Integer)', @TListItems_Delete);
    AType.AddMethod('procedure EndUpdate', @TListItems_EndUpdate);
    AType.AddMethod('procedure Exchange(const AIndex1, AIndex2: Integer)', @TListItems_Exchange);
    AType.AddMethod('procedure Move(const AFromIndex, AToIndex: Integer)', @TListItems_Move);
    AType.AddMethod('function FindCaption(StartIndex: Integer; Value: string; Partial, Inclusive, Wrap: Boolean; PartStart: Boolean = True): TListItem', @TListItems_FindCaption);
    AType.AddMethod('function FindData(const AData: Pointer): TListItem', @TListItems_FindData);
    AType.AddMethod('function IndexOf(const AItem: TListItem): Integer', @TListItems_IndexOf);
    AType.AddMethod('function Insert(const AIndex: Integer) : TListItem', @TListItems_Insert);
    AType.AddMethod('procedure InsertItem(AItem: TListItem; const AIndex: Integer)', @TListItems_InsertItem);
    AType.AddProp('Count', 'Integer', @TListItems_Count_Get, @TListItems_Count_Set);
    AType.AddProp('Owner', 'TCustomListView', @TListItems_Owner_Get);
    AType.AddIndexedProp('Item', 'TListItem', 'Integer', @TListItems_Item_Get, @TListItems_Item_Set);
  end
  else
  if AType.ValueClassType = TListColumns then
  begin
    AType.AddMethod('function Add: TListColumn', @TListColumns_Add);
    AType.AddIndexedProp('Items', 'TListColumn', 'Integer', @TListColumns_Items_Get, @TListColumns_Items_Set);
  end
  else
  if AType.ValueClassType = TCustomListView then
  begin
    AType.AddMethod('procedure AddItem(Item: string; AObject: TObject)', @TCustomListView_AddItem);
    AType.AddMethod('function AlphaSort: Boolean', @TCustomListView_AlphaSort);
    AType.AddMethod('procedure Sort', @TCustomListView_Sort);
    AType.AddMethod('procedure BeginUpdate', @TCustomListView_BeginUpdate);
    AType.AddMethod('procedure Clear', @TCustomListView_Clear);
    AType.AddMethod('procedure EndUpdate', @TCustomListView_EndUpdate);
    AType.AddMethod('function GetItemAt(x,y: integer): TListItem', @TCustomListView_GetItemAt);
    AType.AddMethod('function GetNearestItem(X, Y: Integer; Direction: TSearchDirection): TListItem', @TCustomListView_GetNearestItem);
    AType.AddMethod('function GetNextItem(StartItem: TListItem; Direction: TSearchDirection; States: TListItemStates): TListItem', @TCustomListView_GetNextItem);
    AType.AddMethod('procedure ClearSelection', @TCustomListView_ClearSelection);
    AType.AddMethod('procedure SelectAll', @TCustomListView_SelectAll);
    AType.AddMethod('function IsEditing: Boolean', @TCustomListView_IsEditing);
    AType.AddProp('Canvas', 'TCanvas', @TCustomListView_Canvas_Get);
    AType.AddProp('Checkboxes', 'Boolean', @TCustomListView_Checkboxes_Get, @TCustomListView_Checkboxes_Set);
    AType.AddIndexedProp('Column', 'TListColumn', 'Integer', @TCustomListView_Column_Get);
    AType.AddProp('ColumnCount', 'Integer', @TCustomListView_ColumnCount_Get);
    AType.AddProp('DropTarget', 'TListItem', @TCustomListView_DropTarget_Get, @TCustomListView_DropTarget_Set);
    AType.AddProp('FlatScrollBars', 'Boolean', @TCustomListView_FlatScrollBars_Get, @TCustomListView_FlatScrollBars_Set);
    AType.AddProp('FullDrag', 'Boolean', @TCustomListView_FullDrag_Get, @TCustomListView_FullDrag_Set);
    AType.AddProp('HotTrack', 'Boolean', @TCustomListView_HotTrack_Get, @TCustomListView__HotTrackSet);
    AType.AddProp('ItemFocused', 'TListItem', @TCustomListView_ItemFocused_Get, @TCustomListView_ItemFocused_Set);
    AType.AddProp('ItemIndex', 'Integer', @TCustomListView_ItemIndex_Get, @TCustomListView_ItemIndex_Set);
    AType.AddProp('SelCount', 'Integer', @TCustomListView_SelCount_Get);
    AType.AddProp('Selected', 'TListItem', @TCustomListView_Selected_Get, @TCustomListView_Selected_Set);
    AType.AddProp('LastSelected', 'TListItem', @TCustomListView_LastSelected_Get);
    AType.AddProp('TopItem', 'TListItem', @TCustomListView_TopItem_Get);
  end
  else
  if AType.ValueClassType = TCustomPage then
  begin

  end
  else
  if AType.ValueClassType = TCustomTabControl then
  begin
    AType.AddProp('MultiLine', 'Boolean', @TCustomTabControl_MultiLine_Get, @TCustomTabControl_MultiLine_Set);
    AType.AddProp('PageCount', 'integer', @TCustomTabControl_PageCount_Get);
    AType.AddProp('PageIndex', 'Integer', @TCustomTabControl_PageIndex_Get, @TCustomTabControl_PageIndex_Set);
    AType.AddProp('TabHeight', 'Smallint', @TCustomTabControl_TabHeight_Get, @TCustomTabControl_TabHeight_Set);
    AType.AddProp('TabWidth', 'Smallint', @TCustomTabControl_TabWidth_Get, @TCustomTabControl_TabWidth_Set);
    AType.AddProp('TabPosition', 'TTabPosition', @TCustomTabControl_TabPosition_Get, @TCustomTabControl_TabPosition_Set);
    AType.AddIndexedProp('Page', 'TCustomPage', 'Integer', @TCustomTabControl_Page_Get);
  end;
end;

procedure TCommonImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TTabChangingEvent), TObjVarBoolHandler);
  RegisterHandler(TypeInfo(TDrawTabEvent), TDrawTabHandler);
  RegisterHandler(TypeInfo(TTabGetImageEvent), TTabGetImageHandler);
  RegisterHandler(TypeInfo(TDrawPanelEvent), TDrawPanelHandler);
  RegisterHandler(TypeInfo(TTVChangingEvent), TObjObjVarBoolHandler);
  RegisterHandler(TypeInfo(TTVChangedEvent), TTooObjectHandler);
  RegisterHandler(TypeInfo(TTVEditingEvent), TObjObjVarBoolHandler);
  RegisterHandler(TypeInfo(TTVEditedEvent), TSenderObjVarStrHandler);
  RegisterHandler(TypeInfo(TTVExpandingEvent), TTVExpandingHandler);
  RegisterHandler(TypeInfo(TTVCollapsingEvent), TObjObjVarBoolHandler);
  RegisterHandler(TypeInfo(TTVExpandedEvent), TTooObjectHandler);
  RegisterHandler(TypeInfo(TTVCompareEvent), TTVCompareHandler);
  RegisterHandler(TypeInfo(TLVDeletedEvent), TTooObjectHandler);
  RegisterHandler(TypeInfo(TLVChangeEvent), TLVChangeHandler);
  RegisterHandler(TypeInfo(TLVColumnClickEvent), TTooObjectHandler);
  RegisterHandler(TypeInfo(TLVColumnRClickEvent), TLVColumnRClickHandler);
  RegisterHandler(TypeInfo(TLVCompareEvent), TTVCompareHandler);
  RegisterHandler(TypeInfo(TLVSelectItemEvent), TSenderObjBoolHandler);
end;

function TCommonImport.TImageListDraw(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomImageList(Instence).Draw(TCanvas(TSuPtr(Params[0])), Params[1], Params[2], Params[3], Boolean(Params[4]));
end;

function TCommonImport.TImageListDrawEffect(Instence: TObject; var Params: Variant): Variant;
begin
  TCustomImageList(Instence).Draw(TCanvas(TSuPtr(Params[0])), Params[1], Params[2], Params[3], TGraphicsDrawEffect(Params[4]));
end;

function TCommonImport.TImageList_GetCount(Instance: Pointer): Variant;
begin
  Result := TCustomImageList(Instance).Count;
end;

function TCommonImport.TImagList_GetBitmap(Instence: TObject; var Params: Variant): Variant;
var
  B: TCustomBitmap;
  Ind: Integer;
begin
  Result := varempty;
  Ind := Params[0];
  B := TCustomBitmap(TSuPtr( Params[1] ));
  TCustomImageList(Instence).GetBitmap(Ind, B);
end;

function TCommonImport.TToolButtonClick(Instance: TObject; var Params: Variant): Variant;
begin
  TToolButton(Instance).Click;
end;

end.

