{------------------------------------------------------------------------------}
{                                                                              }
{                            Author Yuriy Kopnin                               }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}

unit dpCompil;

{$mode objfpc}{$H+}
{$I SetComponent.inc}

interface

uses
  Classes, SysUtils, Forms, dpLex, dpUtils, dpCompilMsg, TypInfo,
  dpActiveX, dpi_Methods, variants, dpi_mettyps, dpi_UsersExtraMethods;

type
  TSuPtr = IntPtr;
  TOnExecuteInstruction = procedure(UnitName: string; ACol, ARow: Integer) of object;
  TDpOnMessage = procedure(AMessage: string) of object;
  TDpOnError = procedure(AMessage: TDpCompilerMessage) of object;

  TGetPublicProp = function(Instance: Pointer): Variant of object;
  TSetPublicProp = procedure(Instance: Pointer; AValue: Variant) of Object;


  TDpCompiler = class;
  TTypeTable = class;
  TIdentObject = class;
  TIdentTable = class;
  TDpCustomProc = class;
  //TClassImporter = class;
  TDpClassData = class;

  PRect   = ^TRect;
  PPoint  = ^TPoint;

  TOnAfterCallProc = procedure(Proc: TDpCustomProc) of object;

  TDSSet = set of 0..255;
  PDSSet = ^TDSSet;
  PShiftState = ^TShiftState;

  TClassImporter = class;
  TClassImpoerterClass = class of TClassImporter;

  { TDpType }

  TDpType = class
  private
    FHashValue: Cardinal;
    FBaseType: TsuBaseType;
    FName: string;
    FCompiler: TDpCompiler;
    FOriginalName: TDpString;
    FParent: TDpType;
    FAtributes: TList;
    FMinVal: Integer;
    FMaxVal: Integer;
    FValueClassType: TClass;
    FPersClass: TPersistentClass;
    FClassObjects: TIdentTable;
    FResursName: TDpString;
    FDeclUnit: TDpString;
  protected
    ScriptClass: Boolean;
    procedure SetName(Value: TDpString);
    procedure SetValueClassType(AClass: TClass);
  public
    ATypeInfo: PTypeInfo;
    ClassImporter: TClassImporter;
    Size: Integer;
    ScriptRec: Boolean;
    constructor Create(ACompiler: TDpCompiler);
    destructor Destroy; override;
    procedure AddMethodObj(AProc: TDpCustomProc);
    procedure AddMethod(MethodDecl: TDpString; CallProc: TCallDelphiMethod);
    procedure AddProp(AName, ATypeName: TDpString;
      GetProp: TGetPublicProp; SetProp: TSetPublicProp = nil);
    procedure AddPublishedProp(AName, ATypeName: TDpString; AProp: PPropInfo; ROnly: Boolean);
    function FindClassObject(AName: TDpString; AInherited: Boolean): TIdentObject;
    procedure AddIndexedProp(AName, ATypeName, Indexed: TDpString;
      GetProp: TCallDelphiMethod; SetProp: TCallDelphiMethod = nil);
    property HashValue: Cardinal read FHashValue;
    property BaseType: TsuBaseType read FBaseType write FBaseType;
    property OriginalName: TDpString read FOriginalName;
    property Name: TDpString read FName write SetName;
    property Parent: TDpType read FParent write FParent;
    property MinVal: Integer read FMinVal write FMinVal;
    property MaxVal: Integer read FMaxVal write FMaxVal;
    property ValueClassType: TClass read FValueClassType write SetValueClassType;
    property ClassObjects: TIdentTable read FClassObjects write FClassObjects;
    property Compiler: TDpCompiler read FCompiler;
    property ResursName: TDpString read FResursName; //For Forms
    property DeclUnit: TDpString read FDeclUnit;
    property Atributes: TList read FAtributes;
  end;

  TTypeTable = class
  private
    FList: TList;
    FCompiler: TDpCompiler;
  protected
    function GetItems(Index: Integer): TDpType;
  public
    constructor Create(ACompiler: TDpCompiler);
    destructor Destroy; override;
    procedure Clear; virtual;
    function Add(AName: TDpString; ABaseType: TsuBaseType;
      AClass: TClass; AParent: TDpType; P: PTypeInfo): TDpType;
    function AddSimpleType(AName: TDpString; ABaseType: TsuBaseType): TDpType;
    procedure AddType(AType: TDpType);
    procedure Append(AObject: TDpType);
    function Count: Integer;
    procedure Remove(AObject: TDpType);
    function Find(AName: TDpString; H: Cardinal): TDpType;
    function IsTypeExists(TypeName: TDpString; H: Cardinal): Boolean;
    property Items[Index: Integer]: TDpType read GetItems;
  end;

  TDebugInfo = class
  public
    Col: Integer;
    Row: Integer;
    DeclUnit: TDpString;
  end;

  TIdentObject = class
  private
    FCompiler: TDpCompiler;
    FProc: TDpCustomProc;
    FName: TDpString;
    FOriginalName: TDpString;
    FHashValue: Cardinal;
    FIdentType: TsuIdentType;
    FDeclUnit: TDpString;
    FCol: Integer;
    FRow: Integer;
    FValueType: TDpType;
    FValue: Variant;
    FIniValue: Variant;
    FInitObj: Boolean;
    FUse: Boolean;
    FOnlyRead: Boolean;
  protected
    procedure SetName(AValue: TDpString);
    procedure SetValue(AValue: Variant); virtual;
    procedure SetValueType(AValue: TDpType); virtual;
    function GetValue: Variant; virtual;
    function GetObjectValue: TObject; virtual;
    procedure Assign(Source: TIdentObject); virtual;
    procedure SetProc(AValue: TDpCustomProc); virtual;
  public
    FIndex: Longint;
    AsPointer: Boolean;
    ConstValue: Boolean;
    ClassOwner: TDpType;
    ClassWisibleStatus: Integer;
    constructor Create(ACompiler: TDpCompiler); virtual;
    destructor Destroy; override;
    procedure Inicializ; virtual;
    property Compiler: TDpCompiler read FCompiler write FCompiler;
    property Name: TDpString read FName write SetName;
    property OriginalName: TDpString read FOriginalName;
    property HashValue: Cardinal read FHashValue;
    property IdentType: TsuIdentType read FIdentType write FIdentType;
    property DeclUnit: TDpString read FDeclUnit write FDeclUnit;
    property ValueType: TDpType read FValueType write SetValueType;
    property Value: Variant read GetValue write SetValue;
    property OnlyRead: Boolean read FOnlyRead write FOnlyRead;
    property Proc: TDpCustomProc read FProc write SetProc;
  end;

  TIdentClass = class of TIdentObject;

  TIdentTable = class
  private
    FList: TList;
  protected
    function GetItems(Index: Integer): TIdentObject;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear; virtual;
    procedure Add(AObject: TIdentObject);
    function Count: Integer;
    procedure Remove(AObject: TIdentObject);
    function Find(AName: TDpString; HashValue: Cardinal): TIdentObject;
    property Items[Index: Integer]: TIdentObject read GetItems;
  end;

  TStringObject = class(TIdentObject)
  protected
    procedure SetValue(AValue: Variant); override;
  end;

  { TIntegerObject }

  TIntegerObject = class(TIdentObject)
  protected
    procedure SetValue(AValue: Variant); override;
  end;

  TClassPublicProp = class(TIdentObject)
  protected
    GetPrValue: TGetPublicProp;
    SetPrVAlue: TSetPublicProp;
    procedure Assign(Source: TIdentObject); override;
  public
  end;

  TClassPublishedProp = class(TIdentObject)
  protected
    AProp: PPropInfo;
    procedure Assign(Source: TIdentObject); override;
  public
  end;

  TClassIndexedProp = class(TIdentObject)
  protected
    GetMethod: TCallDelphiMethod;
    SetMethod: TCallDelphiMethod;
    procedure Assign(Source: TIdentObject); override;
  public
    Params: TList;
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
  end;

  TScriptProp = class(TIdentObject)
  protected
    ReadIdent: TIdentObject;
    WriteIdent: TIdentObject;
  end;

  TDpCode = class(TObjectList)
  private
    FProc: TDpCustomProc;
    FPos: Integer;
    FParentCode: TDpCode;
    FCompiler: TDpCompiler;
    FDebugInfo: TDebugInfo;
  protected
    procedure Exec; virtual;
  public
    constructor Create(AProc: TDpCustomProc; ACol, ARow: Integer); virtual;
    destructor Destroy; override;
    function Add(AObject: TObject): Integer; override;
    property Proc: TDpCustomProc read FProc write FProc;
    property ParentCode: TDpCode read FParentCode write FParentCode;
    property Pos: Integer read FPos write FPos;
  end;

  { TDpEventHandler }

  TDpEventHandler = class
  protected
    Proc: TDpCustomProc;
    procedure ShiftToSet(PSet: PDSSet; Shift: TShiftState);
  public
    constructor Create(AProc: TDpCustomProc);
    destructor Destroy;
    function GetHandlerAdres: Pointer; virtual;
  end;

  TArrayObject = class(TIdentObject)
  private
    FDataType: TDpType;
    FDimCount: Integer;
    FDinArray: Boolean;
  protected
    procedure Assign(Source: TIdentObject); override;
    procedure SetValue(AValue: Variant); override;
  public
    //destructor Destroy; override;
    property DimCount: Integer read FDimCount write FDimCount;
    property DataType: TDpType read FDataType write FDataType;
  end;

  TArrayValueObject = class(TArrayObject)
  private
    FList: TList;
  protected
    function GetValue: Variant; override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
  end;

  TSetObject = class(TIdentObject)
  private
    SVal: PDSSet;
    FRefType: TDpType;
    FMinVal, FMaxVal: Integer;
  protected
    //function GetSetValue: TDSSet; override;
    procedure Assign(Source: TIdentObject); override;
    procedure SetValue(AValue: Variant); override;
    function GetValue: Variant; override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
    property MinVal: Integer read FMinVal write FMinVal;
    property MaxVal: Integer read FMaxVal write FMaxVal;
    property RefType: TDpType read FRefType write FRefType;
  end;

  TEnumObject = class(TIdentObject)
  protected
    procedure SetValue(AValue: variant); override;
   end;

  TRecObject = class(TIdentObject)
  private
    P: Pointer;
    RecSize: Integer;
  protected
    procedure SetValueType(AValue: TDpType); override;
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
  end;

  TScriptRecord = class(TIdentObject)
  private
    Obj: TObject;
    ClassData: TDpClassData;
  protected
    procedure SetValueType(AValue: TDpType); override;
    procedure SetValue(AValue: Variant); override;
  public
    destructor Destroy; override;
  end;

  TAdresExpression = class(TIdentObject)
  public
    RefObject: TIdentObject;
    function AssignedValue: Boolean;
    constructor Create(ACompiler: TDpCompiler); override;
    //destructor Destroy; override;
  end;

  TRecFieldObject = class(TIdentObject)
  private
  protected
    //RO: TRecObject;
    RO: TIdentObject;
    ASetProp: TSetPublicProp;
    AGetprop: TGetPublicProp;
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
  end;

  TSimpleExpression = class(TIdentObject)
  private
    FVal: TIdentObject;
  protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    property Val: TIdentObject read FVal write FVal;
  end;

  TAdaptiveMinusExpression = class(TSimpleExpression)
  protected
    function GetValue: Variant; override;
  public
  end;

  TArrayExpression = class(TIdentObject)
  private
    FParams: TList;
  protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
    procedure SetObject(IO: TIdentObject);
    function GetObject: TIdentObject;
    property Params: TList read FParams write FParams;
  end;

  TCharArrayExpression = class(TSimpleExpression)
  private
    FParams: TList;
  protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
    property Params: TList read FParams write FParams;
  end;

  TBoolNotExpression = class(TSimpleExpression)
  protected
    function GetValue: Variant; override;
  public
  end;

  TBitwiseNotExpression = class(TSimpleExpression)
  protected
    function GetValue: Variant; override;
  public
  end;

  TExpression = class(TIdentObject)
  private
    FLeft: TIdentObject;
    FRight: TIdentObject;
  protected
    function GetValue: Variant; override;
  public
    property Left: TIdentObject read FLeft write FLeft;
    property Right: TIdentObject read FRight write FRight;
  end;

  TExpressionClass = class of TExpression;

  TAddExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TSetAddExpression = class(TExpression)
  protected
    S: TDSSet;
    function GetValue: Variant; override;
    //function GetSetValue: TDSSet; override;

  end;

  TSetSubExpression = class(TExpression)
  protected
    S: TDSSet;
    function GetValue: Variant; override;
    //function GetSetValue: TDSSet; override;
  end;

  TSetMulExpression = class(TExpression)
  protected
    S: TDSSet;
    function GetValue: Variant; override;
    //function GetSetValue: TDSSet; override;
  end;

  TSubExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TMulExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TDivExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TModExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TDivIExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TEqualExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TSetEqualExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TNotEqualExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TSetNotEqualExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TGreatExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TLessExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TGreatEqualExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TSetGreatEqualExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TLessEqualExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TSetLessEqualExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TInExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TIsExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TLogicAndExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TLogicOrExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TLogicXorExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TBitwiseAndExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TBitwiseOrExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TBitwiseXorExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TShlExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TShrExpression = class(TExpression)
  protected
    function GetValue: Variant; override;
  end;

  TDispExpression = class(TSimpleExpression)
  private
    FParams: TList;
  protected
    function DoInvoke(AParams: Variant; PCount: Integer; IsSetProp: Boolean): Variant;
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
    procedure AddParam(AParam: TIdentObject);
  end;

  TClassPropObject = class(TSimpleExpression)
  private
    FProp: PPropInfo;
   protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    property Prop: PPropInfo read FProp write FProp;
  end;

  TClassSetProp = class(TSimpleExpression)
  private
    FProp: PPropInfo;
    SetVal: TDSSet;
   protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    property Prop: PPropInfo read FProp write FProp;
  end;

  TClassInterfaceProp = class(TSimpleExpression)
  private
    FProp: PPropInfo;
   protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    property Prop: PPropInfo read FProp write FProp;
  end;

  TFindComponent = class(TSimpleExpression)
  protected
    function GetValue: Variant; override;
  end;

  { TFindClassVar }

  TFindClassVar = class(TSimpleExpression)
  protected
    DeclObject: TIdentObject;
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  end;

   { TClassProperty }

   TClassProperty = class(TSimpleExpression)
  protected
    DeclObject: TScriptProp;
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  end;

  TClassCallProp = class(TSimpleExpression)
  private
    GetPrValue: TGetPublicProp;
    SetPrVAlue: TSetPublicProp;
  protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  end;

  TIndexedPropCaller = class(TSimpleExpression)
  protected
    FList: TList;
    GetMethod: TCallDelphiMethod;
    SetMethod: TCallDelphiMethod;
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
  end;

  { TDpClassData }

  TDpClassData = class
  private
    FDataList: TIdentTable;
    FCompiler: TDpCompiler;
    FType: TDpType;
  public
    FObject: TObject;
    constructor Create(ACompiler: TDpCompiler; AObject: TObject; AType: TDpType);
    destructor Destroy; override;
    procedure ClearData;
    procedure AddData(ACompiler: TDpCompiler; AType: TDpType);
    procedure AddObject(IO: TIdentObject);
    function Find(AName: TDpString): TIdentObject;
  end;

  TDpEventHandlerClass = class of TDpEventHandler;

  TDpCustomProc = class(TIdentObject)
  private
    FVars: TIdentTable;
    FParams: TList;
    FProcs: TIdentTable;
    FErrorObjects: TIdentTable;
    FObjects: TList;
    FCode: TDpCode;
    FTypeTable: TTypeTable;
    FProcRun: Boolean;
    FResultValue: TIdentObject;
    FExecuteCount: Integer;
    FDataObject: TIdentObject;
    FBreak: Boolean;
    FContinue: Boolean;
    FExit: Boolean;
    FUnits: TList;
    FEventHandler: TDpEventHandler;
    FImpl: Boolean;
  protected
    procedure AddVar(AVar: TIdentObject; ACol, ARow: Integer);
    procedure AddProc(AProc: TIdentObject);
    procedure AddParam(AParam: TIdentObject);
    procedure AddConst(AConst: TIdentObject);
    procedure AddErrObject(AObj: TIdentObject);
    function GetValue: Variant; override;
    function GetParamCount: Integer; virtual;
    function GetParam(ParamIndex: Integer): TIDentObject; virtual;
    function GetEventHandler: TDpEventHandler; virtual;
  public
    FIsConstructor: Boolean;
    FIsFunction: Boolean;
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
    function CreateEventHandler(AType: PTypeInfo): Pointer;
    procedure InitializVar;
    procedure Exec; virtual;
    property Vars: TIdentTable read FVars write FVars;
    property Procs: TIdentTable read FProcs write FProcs;
    property Code: TDpCode read FCode write FCode;
    property ExecuteCount: Integer read FExecuteCount write FExecuteCount;
    property DataObject: TIdentObject read FDataObject write FDataObject;
    property EventHandler: TDpEventHandler read GetEventHandler;
    property ParamCount: Integer read GetParamCount;
    property Param[ParamIndex: Integer]: TIdentObject read GetParam;
  end;

  TSuProc = class(TDpCustomProc)
  protected
    Obj: TObject;
    FCreateType: TDpType;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
  end;

  { TRefProc }

  TRefProc = class(TSuProc)
  protected
    function GetParamCount: Integer; override;
    function GetParam(ParamIndex: Integer): TIdentObject; override;
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
    procedure SetProc(AValue: TDpCustomProc); override;
  public
    RefObj: TIdentObject;
    procedure Exec; override;
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
  end;

  { TPointerProc }

  TPointerProc = class(TSuProc)
  public
    PProc: TSuProc;
    DeclProc: TDpCustomProc;
    function GetParamCount: Integer; override;
    function GetParam(ParamIndex: Integer): TIdentObject; override;
    function GetValue: Variant; override;
    procedure SetValueType(AValue: TDpType); override;
    procedure SetValue(AValue: Variant); override;
    constructor Create(ACompiler: TDpCompiler); override;
  end;

  { TUnitProc }

  TUnitProc = class(TSuProc)
  private
    FIni: Boolean;
    FUnitTokens: TTokensList;
    FUnitCompiled: Boolean;
  protected
    function GetValue: Variant; override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
    procedure Inicializ; override;
    property Ini: Boolean read FIni;
  end;

  TExternalMethod = class(TSuProc)
  private
    FOnCallMethod: TCallDelphiMethod;
  protected
    function GetValue: variant; override;
  public
  published
    property OnCallMethod: TCallDelphiMethod read FOnCallMethod write FOnCallMethod;
  end;

  { TProcCaller }

  TProcCaller = class(TIdentObject)
  private
    FCallProc: TSuProc;
    FParams: TList;
    FOwnerIdent: TIdentObject;
    Inh: Boolean;
  protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    constructor Create(ACompiler: TDpCompiler); override;
    destructor Destroy; override;
    property CallProc: TSuProc read FCallProc write FCallProc;
  end;

  TConstrCaller = class(TProcCaller)
  protected
    InhValueType: TDpType;
    function GetValue: Variant; override;
  public

  end;

  TGetVarMethod = function: Variant of object;
  TSetVarMethod = procedure(AValue: Variant) of object;

  { TSysVarObject }

  TSysVarObject = class(TIdentObject)
  private
    FOnGetVarValue: TGetVarMethod;
    FOnSetVarValue: TSetVarMethod;
  protected
    function GetValue: Variant; override;
    procedure SetValue(AValue: Variant); override;
  public
    property OnGetVarValue: TGetVarMethod read FOnGetVarValue write FOnGetVarValue;
    property OnSetVarValue: TSetVarMethod read FOnSetVarValue write FOnSetVarValue;
  end;

  TIfInstruction = class(TDpCode)
  private
    FCondition: TIdentObject;
    FFalseCode: TDpCode;
  protected
    procedure Exec; override;
  public
    constructor Create(AProc: TDpCustomProc; ACol, ARow: Integer); override;
    destructor Destroy; override;
    property FalseCode: TDpCode read FFalseCode write FFalseCode;
    property Condition: TIdentObject read FCondition write FCondition;
  end;

  TTryInstruction = class(TDpCode)
  private
    FErrCode: TDpCode;
  protected
    FExcept: Boolean;
    Ex: TIdentObject;
    procedure Exec; override;
  public
    constructor Create(AProc: TDpCustomProc; ACol, ARow: Integer); override;
    destructor Destroy; override;
    property ErrCode: TDpCode read FErrCode;
  end;

  TCaseCode = class(TDpCode)
  private
    FValues: TList;
  protected
    function IsEqual(V: Variant): Boolean;
  public
    constructor Create(AProc: TDpCustomProc; ACol, ARow: Integer); override;
    destructor Destroy; override;
    procedure AddValue(V: Variant);
  end;

  TCaseInstruction = class(TDpCode)
  private
    FCaseValue: TIdentObject;
    FElseCode: TDpCode;
  protected
    procedure Exec; override;
  public
    constructor Create(AProc: TDpCustomProc; ACol, ARow: Integer); override;
    //destructor Destroy; override;
    property CaseValue: TIdentObject read FCaseValue;
    property ElseCode: TDpCode read FElseCode;
  end;

  TAssignInstruction = class(TDpCode)
  private
    FLeft: TIdentObject;
    FRight: TIdentObject;
  protected
    procedure Exec; override;
  public
    property Left: TIdentObject read FLeft write FLeft;
    property Right: TIdentObject read FRight write FRight;
  end;

  TRepeatInstruction = class(TDpCode)
  private
    FCondition: TIdentObject;
  protected
    procedure Exec; override;
  public
    property Condition: TIdentObject read FCondition write FCondition;
  end;

  TCallInstrcution = class(TDpCode)
  private
    FProcCaller: TProcCaller;
  protected
    procedure Exec; override;
  public
    property ProcCaller: TProcCaller read FProcCaller write FProcCaller;
  end;

  TIncInstruction = class(TDpCode)
  private
    FIdent: TIdentObject;
    IncValue: Variant;
  protected
    procedure Exec; override;
  public
    property Ident: TIdentObject read FIdent write FIdent;
  end;

  TIncAssignInstruction = class(TDpCode)
  private
    FIdent: TIdentObject;
    FIncValue: TIdentObject;
    FPlus: Boolean;
  protected
    procedure Exec; override;
  public
    property Ident: TIdentObject read FIdent write FIdent;
    property IncValue: TIdentObject read FIncValue write FIncValue;
  end;

  TDispInstruction = class(TDpCode)
  private
    FDispExpr: TDispExpression;
  protected
    procedure Exec; override;
  public
    //destructor Destroy; override;
    property DispExpr: TDispExpression read FDispExpr write FDispExpr;
  end;

  { TArrayAssignInstruction }

  TArrayAssignInstruction = class(TAssignInstruction)
  protected
    procedure Exec; override;
  end;

  TMethodAssignInstruction = class(TAssignInstruction)
  protected
    procedure Exec; override;
  end;

  TSetAdresInstruction = class(TAssignInstruction)
  protected
    procedure Exec; override;
  end;

  TWhileInstruction = class(TDpCode)
  private
    FCondition: TIdentObject;
  protected
    procedure Exec; override;
  public
    property Condition: TIdentObject read FCondition write FCondition;
  end;

  TForInstruction = class(TDpCode)
  private
    FAssign: TExpression;
    FToValue: TIdentObject;
    FIsDown: Boolean;
  protected
    procedure Exec; override;
  public
    constructor Create(AProc: TDpCustomProc; ACol, ARow: Integer); override;
    property Assign: TExpression read FAssign write FAssign;
    property ToValue: TIdentObject read FToValue write FToValue;
    property IsDown: Boolean read FIsDown write FIsDown;
  end;

  TBreakInstruction = class(TDpCode)
  private
    FInstruction: TDpCode;
  protected
    procedure Exec; override;
  end;

  TContinueInstruction = class(TDpCode)
  private
    FInstruction: TDpCode;
  protected
    procedure Exec; override;
  end;

  TExitInstruction = class(TDpCode)
  private
  protected
    procedure Exec; override;
  end;

  TWithInstruction = class(TDpCode)
  private
    WithList: TList;
  protected
  public
    constructor Create(AProc: TDpCustomProc; ACol: Integer; ARow: Integer); override;
    destructor Destroy; override;
  end;

  //Для лобавления простого типа
  TAddSimpleTypeProc = function(AName: TDpString; ABaseType: TsuBaseType): TDpType of object;
  TOnAddSimpleType = procedure(AddSimpleType: TAddSimpleTypeProc) of object;
  //Для добавления VCL типа в скрипт
  TAddTypeProc = function(ATypeInfo: PTypeInfo; WithName: string = ''): TDpType of object;
  TOnAddTypeInfo = procedure(AddType: TAddTypeProc) of object;
  //Для добавления класса типа в скрипт
  TAddClassProc = function(AClass: TClass; AltClassName: string = ''): TDpType of object;
  TOnAddClass = procedure(AddClass: TAddClassProc) of object;
  //для импорта записей
  TAddRecordProc = function(RecordName: TDpString; RecordSize: Integer): TDpType of object;
  //Для добавления Public свойства или метода или информирования о добавленном типе
  TOnAddTypeProp = procedure(AType: TDpType) of object;

  //Для добавление объекта в скрипт
  TAddObjectProc = procedure(ObjName: TDpString; AObject: TObject) of object;
  TOnAddObject = procedure(AddObject: TAddObjectProc) of object;
  //Для добавления констант
  TAddConstProc = procedure(ConstName, ATypeName: TDpString; AValue: Variant) of object;
  TOnAddConst = procedure(AddConst: TAddConstProc) of Object;
  TAddVarProc = procedure(VarName, VarType: TDpString) of Object;
  //Для получения исходного кода модулей
  TOnGetUnitSource = function(UnitName: string): string of object;
  TOnCreateForm = function (AOwner: TComponent; AType: TDpType): TForm of object;
  TOnCreateDataModule = function (AOwner: TComponent; AType: TDpType): TDataModule of object;
  TOnCreateFrame = function(AOwner: TComponent; AType: TDpType): TFrame of object;

  TRegHandlerProc = procedure (AType: PTypeInfo; AHanlderClass: TDpEventHandlerClass) of object;
  TRegHandlerEvent = procedure(RegisterHandler: TRegHandlerProc) of Object;

  TClassImporter = class
  private
  protected
    Compiler: TDpCompiler;
  public
    function Create_Object(AClass: TClass): TObject; virtual;
    procedure RegisterPublic(AType: TDpType); virtual;
    procedure AddTypes(AddType: TAddTypeProc); virtual;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); virtual;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); virtual;
    procedure AddConsts(AddConst: TAddConstProc); virtual;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); virtual;
    procedure AddVars(AddVar: TAddVarProc); virtual;
    procedure AddMethods(AddMethod: TAddMethodProc); virtual;
    procedure AddObjects(AddObject: TAddObjectProc); virtual;
  end;

  TDpEventHandlerReg = class
  public
    AType: PTypeInfo;
    AHandlerClass: TDpEventHandlerClass;
  end;

  TAddImporterProc = procedure (AClass: TClassImpoerterClass) of object;
  TOnAddClassImporter = procedure (AddImporter: TAddImporterProc) of object;

  { TDpCompiler }

  TDpCompiler = class(TComponent)
  private
    FErrors: Boolean;
    FMainProc: TUnitProc;
    FMsgList: TObjectList;
    FObjectData: TList;
    FSuLanguage: TSuLanguage;
    FCompiled: Boolean;
    FUseTranscription: Boolean;
    FTypeTable: TTypeTable;
    FOnExecuteInstruction: TOnExecuteInstruction;
    FOnCompilerMessage: TDpOnMessage;
    FOnAfterCallProc: TOnAfterCallProc;
    FOnAddSimpleType: TOnAddSimpleType;
    FOnAddTypeInfo: TOnAddTypeInfo;
    FOnAddClass: TOnAddClass;
    FOnAddTypeProp: TOnAddTypeProp;
    FOnAddConst: TOnAddConst;
    FOnAddObject: TOnAddObject;
    FOnAddMethod: TOnAddMethod;
    FOnGetUnitSource: TOnGetUnitSource;
    FOnError: TDpOnError;
    FCurProc: TSuProc;
    FCompClasses: TList;
    //FMetCont: TMethods;
    FImportList: TObjectList;
    FOnCreateDataModule: TOnCreateDataModule;
    FOnCreateForm: TOnCreateForm;
    FOnCreateFrame: TOnCreateFrame;
    FOnAddClassImpoerter: TOnAddClassImporter;


    function WriteError(AModuleName: TDpString; MsgCode: TCompilerError;
        AParam: string = ''): TDpCompilerMessage;
    procedure AddColorValues(const S: string);
  protected
    Tokens: TTokensList;
    Units: TIdentTable;
    ObjectsDump: TObjectList;
    EventHandlerRegList: TObjectList;
    DefaultType: TDpType;
    IntegerType: TDpType;
    Int64Type: TDpType;
    BooleanType: TDpType;
    ExtendedType: TDpType;
    ArrayType: TDpType;
    DispType: TDpType;
    WithIO: TIdentObject;
    TotalRow: Integer;
    procedure DoProgram;
    function DoBlock(Proc: TSuProc): Boolean;
    function DoUses(Proc: TSuProc):Boolean;
    function DoUnit(Proc: TSuProc):Boolean;
    function DoUnitInterface(Proc: TSuProc): Boolean;
    function DoImplementation(Proc: TSuProc): Boolean;
    function DoUnitImplementation(Proc: TSuProc): Boolean;
    function DoType(Proc: TSuProc):Boolean;
    function DoEnumConst(Proc: TSuProc; aType: TDpType): Boolean;
    function DoVar(Proc: TSuProc): Boolean;
    function DoConst(Proc: TSuProc): Boolean;
    function DoMethod(ParentProc: TSuProc): Boolean;
    function DoCompoundStat(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoStatment(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoAssignmentStatment(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoSetDeclaration(var MinVal, MaxVal: Integer;
      var RefType: TDpType; Proc: TSuProc): Boolean;
    function DoCheckParam(Proc: TSuProc): Boolean;
    function DoIf(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoCase(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoWhile(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoWith(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoTry(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoBreak(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoContinue(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoExit(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoFor(Proc: TSuProc; ACode: TDpCode): Boolean;
    function DoRepeat(Proc: TSuProc; ACode: TDpCode): Boolean;


    function GetIdentClass(AType: TDpType): TIdentClass;
    function Add_SimpleType(AName: TDpString; ABaseType: TsuBaseType): TDpType;
    function Add_TypeInfo(P: PTypeInfo; WithName: string = ''): TDpType;
    function Add_Class(AClass: TClass; AlterName: TDpString = ''): TDpType;
    function Add_Record(RecTypeName: TDpString; ASize: Integer): TDpType;
    procedure Add_Object(ObjName: TDpString; AObject: TObject);
    function AddTypes: Boolean;
    function AddTypeProp: Boolean;
    function AddConsts: Boolean;
    function AddVars: Boolean;
    function AddMethods: Boolean;
    function AddClassPublic(AType: TDpType): Boolean;

    procedure Add_Const(ConstName, ATypeName: TDpString; AValue: Variant);
    procedure Add_Var(VarName, ATypeName: TDpString);
    procedure Add_SysVar(VarName, ATypeName: TDpString; GetVarProc: TGetVarMethod; SetVarProc: TSetVarMethod = nil);
    procedure Add_Method(MethodDecl: TDpString; CallProc: TCallDelphiMethod);

    function ParseMethod(MethodDecl: TDpString; CallProc: TCallDelphiMethod): TSuProc;
    function DoProcParam(Proc: TSuProc): Boolean;
    function DoArray(Proc: TSuProc; List: TStringList; var AValueType: TDpType): Boolean;
    function GetVarTypeOfType(ABaseType: TsuBaseType): Word;
    function DoExpression(Proc: TSuProc; GetMethod: Boolean): TIdentObject;
    function DoSimpleExpression(Proc: TSuProc; GetMethod: Boolean): TIdentObject;
    function DoTerm(Proc: TSuProc; GetMethod: Boolean): TIdentObject;
    function DoFactor(Proc: TSuProc; GetMethod: Boolean): TIdentObject;
    function IsCompatibleTypes(T1, T2: TDpType; Oper: TIdentToken): Boolean;
    function IsCompatibleClasses(C1, C2: TClass): Boolean;
    function IsCompatibleScriptClasses(C1, C2: TDpType): Boolean;
    function DoSetValue(Proc: TSuProc): TIdentObject;
    function DoClassProperty(AIdent: TIdentObject;
      AType: TDpType; Proc: TSuProc; GetMethodAdres: Boolean): TIdentObject;
    function DoRecField(AIdent: TIdentObject; Proc: TSuProc): TIdentObject;
    function DoDispatch(AIdent: TIdentObject; Proc: TSuProc): TIdentObject;
    function DoCallMethod(Proc: TSuProc; CallProc: TSuProc;
      ClassObj: TIdentObject; AInheritedCall: Boolean): TProcCaller;
    function DoIndexedVar(Proc: TSuProc; Ident: TIdentObject): TIdentObject;
    function DoTypeCast(Proc: TSuProc; AType: TDpType; AssignValue: Boolean): TIdentObject;
    function DoArrayValue(Proc: TSuProc): TIdentObject;
    function FindTypeProp(PropName: TDpString; AType: TDpType; Proc: TSuProc): TIdentObject;
    function FindTypeMethod(AMethodName: TDpString; AType: TDpType; Proc: TSuProc): TSuProc;
    procedure ObjectDataClear;
    procedure CheckUseObject;
    procedure AddClassImport(AClass: TClassImpoerterClass);
    procedure RegisterHandler(AType: PTypeInfo; HandlerClass: TDpEventHandlerClass);
    procedure Notification(AComponent: TComponent; Operation: TOperation);
       override;

    function GetAsniFunciton: TdpAnsiFunction;
    function GetDOSFunction: TdpDOSFunction;
    procedure SetAnsiFunction(AValue: TdpAnsiFunction);
    procedure SetDOSFunction(AValue: TdpDOSFunction);
    function DecimalSeparator_Get: Variant;
    procedure DecimalSeparator_Set(Value: Variant);
  public
    Debug: Boolean;
    ExternalObject: TIdentTable;

    RetRect: TRect;
    RetPoint: TPoint;
    RetSet: TDSSet;
    Method: TMethod;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Reset;
    function GetIdent(IdentName: TDpString; H: Cardinal; Proc: TDpCustomProc): TIdentObject;
    procedure WriteHintWarning(AModuleName: TDpString; AMessage: TDpString;
      ACol, ARow: Integer; AMsgType: TSuMessageType);
    function GetIniValue(AType: TDpType): Variant;
    function Compile: Boolean;
    function Run: Variant;
    procedure WriteMessage(AModuleName: TDpString; AMessage: TDpString);
    procedure ShowMsg(S: TDpString);
    function GetHandlerClass(AType: PTypeInfo): TDpEventHandlerClass;
    function FindType(ATypeName: TDpString; Proc: TSuProc; WriteErr: Boolean): TDpType;
    function IsTypeExist(ATypeName: TDpString; Proc: TSuProc): Boolean;
    function IsIdentDeclared(IdentName: TDpString; H: Cardinal; Proc: TSuProc): Boolean;
    function AddObjectData(AObject: TObject; AType: TDpType): TDpClassData;
    function AddEmptyData(AObject: TObject): TDpClassData;
    function GetData(AObject: TObject): TDpClassData;
    procedure DeleteObjectData(AObject: TObject);
    function FindObjectData(AObject: TObject; varName: TDpString): TIdentObject;
    function ObjectDataExist(AObject: TObject): Boolean;
    function FindTypeObject(AObject: TObject): TDpType;
    function GetValueTypeOf(Proc: TSuProc; ALeft, ARight: TDpType; AOp: TIdentToken): TDpType;
    function GetScriptClass(AClassName: TDpString; H: Cardinal): TDpType;
    function GetClassMethod(AClassName, ProcName: TDpString): TSuProc;
    function ExtFindComponent(C: TComponent; AName: TDpString): TComponent;
    property MainProc: TUnitProc read FMainProc;
    property UseTranscription: Boolean read FUseTranscription write FUseTranscription;
    property TypeTable: TTypeTable read FTypeTable write FTypeTable;
  published
    property SuLanguage: TSuLanguage read FSuLanguage write FSuLanguage;
    property AsniFunciton: TdpAnsiFunction read GetAsniFunciton write SetAnsiFunction;
    property DosFunction: TdpDOSFunction read GetDOSFunction write SetDOSFunction;
    property OnExecuteInstruction: TOnExecuteInstruction read FOnExecuteInstruction write FOnExecuteInstruction;
    property OnCompilerMessage: TDpOnMessage read FOnCompilerMessage write FOnCompilerMessage;
    property OnAfterCallProc: TOnAfterCallProc read FOnAfterCallProc write FOnAfterCallProc;
    property OnAddSimpleType: TOnAddSimpleType read FOnAddSimpleType write FOnAddSimpleType;
    property OnAddTypeInfo: TOnAddTypeInfo read FOnAddTypeInfo write FOnAddTypeInfo;
    property OnAddClass: TOnAddClass read FOnAddClass write FOnAddClass;
    property OnAddTypeProp: TOnAddTypeProp read FOnAddTypeProp write FOnAddTypeProp;
    property OnAddConst: TOnAddConst read FOnAddConst write FOnAddConst;
    property OnAddObject: TOnAddObject read FOnAddObject write FOnAddObject;
    property OnAddMethod: TOnAddMethod read FOnAddMethod write FOnAddMethod;
    property OnGetUnitSource: TOnGetUnitSource read FOnGetUnitSource write FOnGetUnitSource;
    property OnError: TDpOnError read FOnError write FOnError;
    property OnCreateDataModule: TOnCreateDataModule read FOnCreateDataModule write FOnCreateDataModule;
    property OnCreateForm: TOnCreateForm read FOnCreateForm write FOnCreateForm;
    property OnCreateFrame: TOnCreateFrame read FOnCreateFrame write FOnCreateFrame;
    property OnAddClassImporter: TOnAddClassImporter read FOnAddClassImpoerter write FOnAddClassImpoerter;
  end;


implementation

uses Graphics, Controls, LCLIntf, dpi_Classes, dpi_Records, Dialogs,
  dpi_StdCtrls, dpi_DB, dpi_Forms, dpi_Graphics, dpi_Additional, dpi_Common,
  dpi_DataControls, dpi_DialogImport, dpi_DataAccess, FileUtil,
  LazUTF8;


{ TPointerProc }

function TPointerProc.GetParamCount: Integer;
begin
  if Compiler.FCompiled then
    Result := PProc.ParamCount
  else
    Result := DeclProc.ParamCount;
end;

function TPointerProc.GetParam(ParamIndex: Integer): TIdentObject;
begin
  if Compiler.FCompiled then
    Result := PProc.Param[ParamIndex]
  else
    Result := DeclProc.Param[ParamIndex];
end;

function TPointerProc.GetValue: Variant;
begin
  Result := PProc.Value;
end;

procedure TPointerProc.SetValueType(AValue: TDpType);
var
  Ident: TIdentObject;
begin
  inherited SetValueType(AValue);
  if AValue.FClassObjects.Count > 0 then
  begin
    Ident := AValue.FClassObjects.Items[0];
    if Ident is TDpCustomProc then
    begin
      DeclProc := TDpCustomProc(AValue.FClassObjects.Items[0]);
      FIsFunction:= DeclProc.FIsFunction;
    end;
  end;
end;

procedure TPointerProc.SetValue(AValue: Variant);
var
  I: Integer;
begin
  PProc := TSuProc(TSuPtr(AValue));
  if DeclProc <> nil then
  begin
    for I := 0 to PProc.ParamCount - 1 do
      PProc.Param[I].FIniValue:= DeclProc.Param[I].FIniValue;
  end;
end;

constructor TPointerProc.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  PProc := nil;
end;

{ TPointerProc }

//procedure TPointerProc.SetValue(AValue: Variant);
//begin
//  PProc := TSuProc(TSuPtr(AValue));
//end;
//
//constructor TPointerProc.Create(ACompiler: TDpCompiler);
//begin
//  inherited Create(ACompiler);
//  IdentType := itProc;
//  PProc := nil;
//end;

{ TIntegerObject }

procedure TIntegerObject.SetValue(AValue: Variant);
var
  I64: Int64;
  I: Integer;
begin
  I64 := AValue;
  if (I64 >= - MaxInt - 1) and (I64 <= MaxInt) then
  begin
    I := I64;
    FValue := I;
  end
  else
    FValue := I64;
end;

{ TSysVarObject }

function TSysVarObject.GetValue: Variant;
begin
  Result := Unassigned;
  if Assigned(FOnGetVarValue) then
    Result := OnGetVarValue();
end;

procedure TSysVarObject.SetValue(AValue: Variant);
begin
  if Assigned(FOnSetVarValue) then
  begin
    FOnSetVarValue(AValue);
  end;
end;

{ TClassProperty }

function TClassProperty.GetValue: Variant;
var
  AObj: TObject;
  AProc: TSuProc;
begin
  AObj := TObject(TSuPtr(FVal.Value));
  if DeclObject.ReadIdent.IdentType = itClassVar then
    Result := FCompiler.FindObjectData(AObj, DeclObject.ReadIdent.Name).Value
  else
  if DeclObject.ReadIdent.IdentType = itClassComponent then
    Result := TSuPtr(Compiler.ExtFindComponent(TComponent(AObj), DeclObject.ReadIdent.Name))
  else
  if DeclObject.ReadIdent.IdentType = itProc then
  begin
    AProc := TSuProc(DeclObject.ReadIdent);
    AProc.FDataObject.Value := TSuPtr(AObj);
    Result := AProc.Value;
  end;
end;

procedure TClassProperty.SetValue(AValue: Variant);
var
  AObj: TObject;
  AProc: TSuProc;
begin
  AObj := TObject(TSuPtr(FVal.Value));
  if DeclObject.WriteIdent.IdentType = itClassVar then
  begin
    FCompiler.FindObjectData(AObj, DeclObject.WriteIdent.Name).Value := AValue;
  end
  else
  if DeclObject.WriteIdent.IdentType = itProc then
  begin
    AProc := TSuProc(DeclObject.WriteIdent);
    AProc.Param[0].Value := AValue;
    AProc.FDataObject.Value := TSuPtr(AObj);
    AProc.Exec;
  end;
end;

{TDpType}

constructor TDpType.Create(ACompiler: TDpCompiler);
begin
  inherited Create;
  Parent := nil;
  ScriptRec := False;
  ScriptClass := False;
  FCompiler := ACompiler;
  FAtributes := TList.Create;
  FClassObjects := TIdentTable.Create;
end;

destructor TDpType.Destroy;
begin
  FAtributes.Clear;
  FAtributes.Free;
  FClassObjects.Free;
  if (FValueClassType <> nil) and FValueClassType.InheritsFrom(TPersistent) then
    UnRegisterClass(TPersistentClass(FValueClassType));
  inherited Destroy;
end;

procedure TDpType.AddMethodObj(AProc: TDpCustomProc);
begin
  FClassObjects.Add(AProc);
end;

{function TDpType.GetIniValue: Variant;
begin
  case BaseType of
    btInt:
    begin
      Result := 0;
      TVarData(Result).VType := varInteger;
    end;
    btBool: Result := False;
    btFloat:
    begin
      Result := 0.0;
      TVarData(Result).VType := varDouble;
    end;
    btChar: Result := #0;
    btString: Result := '';
    btClass: Result := 0;
    btEnum: Result := 0;
  end;
end;}

procedure TDpType.SetName(Value: TDpString);
begin
  FName := UTF8LowerCase(Value);
  FOriginalName := Value;
  FHashValue := Hash(FName);
end;

procedure TDpType.SetValueClassType(AClass: TClass);
begin
  FValueClassType := AClass;
  if (FValueClassType <> nil) and FValueClassType.InheritsFrom(TPersistent) then
    Classes.RegisterClass(TPersistentClass(FValueClassType));
end;

procedure TDpType.AddMethod(MethodDecl: TDpString; CallProc: TCallDelphiMethod);
var
  Proc: TSuProc;
begin
  Proc := FCompiler.ParseMethod(MethodDecl, CallProc);
  if Proc <> nil then
  begin
    Proc.FCompiler := FCompiler;
    Proc.FDataObject := TIdentObject.Create(FCompiler);
    Proc.FDataObject.Name := 'Self';
    Proc.FDataObject.ValueType := Self;
    Proc.AddVar(Proc.FDataObject, 0, 0);
    Proc.FDataObject.IdentType := itParam;
    if Proc.FIsConstructor then Proc.ValueType := Self;
    FClassObjects.Add(Proc);
  end;
end;

procedure TDpType.AddProp(AName, ATypeName: TDpString;
  GetProp: TGetPublicProp; SetProp: TSetPublicProp = nil);
var
  CP: TClassPublicProp;
begin
  CP := TClassPublicProp.Create(FCompiler);
  CP.IdentType := itProp;
  CP.GetPrValue := GetProp;
  CP.SetPrVAlue := SetProp;
  if not Assigned(SetProp) then CP.FOnlyRead := True;
  CP.Name := AName;
  CP.ValueType := FCompiler.FindType(ATypeName, nil, True);
  FClassObjects.Add(CP);
end;

procedure TDpType.AddPublishedProp(AName, ATypeName: TDpString; AProp: PPropInfo; ROnly: Boolean);
var
  CP: TClassPublishedProp;
begin
  CP := TClassPublishedProp.Create(FCompiler);
  CP.IdentType := itProp;
  CP.AProp := AProp;
  CP.FOnlyRead := ROnly;
  CP.Name := AName;
  CP.ValueType := FCompiler.FindType(ATypeName, nil, True);
  FClassObjects.Add(CP);
end;

function TDpType.FindClassObject(AName: TDpString; AInherited: Boolean): TIdentObject;
var
  AType: TDpType;
begin
  AType := Self;
  if AInherited then AType := AType.Parent;
  Result := nil;
  while AType <> nil do
  begin
    Result := AType.FClassObjects.Find(AName, 0);
    if Result <> nil then
    begin
      Result.FUse := True;
      Break;
    end;
    AType := AType.Parent;
  end;
end;

procedure TDpType.AddIndexedProp(AName, ATypeName, Indexed: TDpString;
      GetProp: TCallDelphiMethod; SetProp: TCallDelphiMethod = nil);
var
  CI: TClassIndexedProp;
  P: TDpParser;
  TmpList: TTokensList;
  IType: TDpType;
begin
  CI := TClassIndexedProp.Create(FCompiler);
  CI.Name := AName;
  CI.GetMethod := GetProp;
  CI.SetMethod := SetProp;
  CI.ValueType := FCompiler.FindType(ATypeName, nil, True);
  FClassObjects.Add(CI);
  if  not Assigned(CI.SetMethod) then CI.OnlyRead := True;

  P := TDpParser.Create(Compiler.UseTranscription, FCompiler.FSuLanguage);
  P.SetParseStr(Indexed);
  TmpList := P.GetTokensList;
  try

    while TmpList.Token.TokenID <> ID_EOF do
    begin
      if TmpList.Token.TokenID = ID_Identifier then
      begin
        IType := FCompiler.FindType(TmpList.Token.TokenName, nil, True);
        CI.Params.Add(IType);
        TmpList.Next;
        if TmpList.Token.TokenID = ID_EOF then Break
        else
        if TmpList.Token.TokenID in [ID_Comma, ID_Colon, ID_SemiColon, ID_Period] then
        begin
          TmpList.Next;
        end;
      end
      else
      begin
        FCompiler.WriteError('External add indexed property '+ AName, ceIdentifierExpected, '');
        Break;
      end;
    end;
  finally
    TmpList.Free;
    P.Free;
  end;
  if CI.Params.Count = 0 then FCompiler.WriteError('External add indexed property', ceInvalidnumberOfParameters, '');
end;

{TTypeTable}

constructor TTypeTable.Create(ACompiler: TDpCompiler);
begin
  inherited Create;
  FCompiler := ACompiler;
  FList := TList.Create;
end;

destructor TTypeTable.Destroy;
begin
  Clear;
  FList.Free;
  inherited Destroy;
end;

function TTypeTable.GetItems(Index: Integer): TDpType;
begin
  Result := TDpType(FList.Items[Index]);
end;

procedure TTypeTable.Clear;
begin
  while FList.Count > 0 do
  begin
    TObject(FList[0]).Free;
    FList.Delete(0);
  end;
end;

procedure TTypeTable.Append(AObject: TDpType);
begin
  FList.Add(AObject);
end;

function TTypeTable.Add(AName: TDpString; ABaseType: TsuBaseType;
  AClass: TClass; AParent: TDpType; P: PTypeInfo): TDpType;
begin
  Result := Find(AName, 0);
  if (Result <> nil) and (P <> nil) and (Result.ATypeInfo <> nil) then
  begin
    if (Result.ATypeInfo^.Kind = tkMethod) and (P^.Kind = tkMethod)
      and (Result.ATypeInfo <> P) then  Result := nil;
  end;

  if Result <> nil then
  begin
    FCompiler.ShowMsg('[Ошибка] Попытка добавление типа ' + AName + '. Тип с таким именем существует')
  end
  else
  begin
    Result := TDpType.Create(FCompiler);
    Result.FCompiler := Self.FCompiler;
    Result.Name := AName;
    Result.BaseType := ABaseType;
    Result.ValueClassType := AClass;
    Result.Parent := AParent;
    Result.ATypeInfo := P;
    Append(Result);
  end;
end;

function TTypeTable.AddSimpleType(AName: TDpString; ABaseType: TsuBaseType): TDpType;
begin
  Result := Find(AName, 0);
  if Result <> nil then
  begin
    FCompiler.ShowMsg('[Ошибка] Попытка добавление простого типа ' + AName + '. Тип с таким именем существует')
  end
  else
  begin
    Result := TDpType.Create(FCompiler);
    Result.FCompiler := Self.FCompiler;
    Result.Name := AName;
    Result.BaseType := ABaseType;
    Result.ValueClassType := nil;
    Result.Parent := nil;
    Result.ATypeInfo := nil;
    Append(Result);
  end;
end;

procedure TTypeTable.AddType(AType: TDpType);
var
  T: TDpType;
begin
  if AType.Name = '' then Exit;
  T := Find(AType.Name, 0);
  if T = nil then Append(AType);
end;

function TTypeTable.Count: Integer;
begin
  Result := FList.Count;
end;

procedure TTypeTable.Remove(AObject: TDpType);
begin
  FList.Remove(AObject);
end;

function TTypeTable.Find(AName: TDpString; H: Cardinal): TDpType;
var
  I: Integer;
begin
  Result := nil;
  AName := UTF8LowerCase(AName);
  if H = 0 then
    H := Hash(AName);
  I := 0;
  while I < FList.Count do
  begin
    if (TDpType(FList.Items[I]).FHashValue = H)
      and (TDpType(FList.Items[I]).FName = AName) then
    begin
      Result := TDpType(FList.Items[I]);
      Break;
    end;
    Inc(I);
  end;
end;

function TTypeTable.IsTypeExists(TypeName: TDpString; H: Cardinal): Boolean;
var
  I: Integer;
begin
  Result := False;
  TypeName := UTF8LowerCase(TypeName);
  if H = 0 then
    H := Hash(TypeName);
  I := 0;
  while I < FList.Count do
  begin
    if (TDpType(FList.Items[I]).FHashValue = H)
      and (TDpType(FList.Items[I]).FName = TypeName) then
    begin
      Result := True;
      Break;
    end;
    Inc(I);
  end;
end;


{TIdentObject}

constructor TIdentObject.Create(ACompiler: TDpCompiler);
begin
  FUse := False;
  FInitObj := False;
  ClassOwner := nil;
  FHashValue := 0;
  ClassWisibleStatus := 3;
  FValueType := nil;
  AsPointer := False;
  FOnlyRead := False;
  FIdentType := itValue;
  FCompiler := ACompiler;
  FIniValue := Unassigned;
  ConstValue:= False;
  if not ACompiler.FCompiled then
    FIndex := FCompiler.ObjectsDump.Add(Self);
end;

destructor TIdentObject.Destroy;
begin
  inherited Destroy;
end;

procedure TIdentObject.Inicializ;
begin
  if FIdentType = itConst then Exit;

  if FInitObj then Value := FIniValue;
end;

procedure TIdentObject.SetName(AValue: TDpString);
begin
  FOriginalName := AValue;
  FName := UTF8LowerCase(AValue);
  FHashValue := Hash(FName);
end;

function TIdentObject.GetValue: Variant;
begin
  Result := FValue;
end;

function TIdentObject.GetObjectValue: TObject;
begin
  Result := nil;
end;

procedure TIdentObject.SetValue(AValue: Variant);
begin
  FValue := AValue;
end;

procedure TIdentObject.SetValueType(AValue: TDpType);
begin
  FValueType := AValue;
  if FValue = Unassigned then
  begin
    if AValue = nil then
      raise Exception.Create(DeclUnit + '.' + OriginalName + ' type object = nil')
    else
      if AValue.BaseType <> btSet then
        FValue := FCompiler.GetIniValue(AValue);
  end;
end;

procedure TIdentObject.Assign(Source: TIdentObject);
begin
  FName := Source.Name;
  FProc := Source.FProc;
  ValueType := Source.ValueType;
  FHashValue := Source.HashValue;
end;

procedure TIdentObject.SetProc(AValue: TDpCustomProc);
begin
  FProc := AValue;
  FDeclUnit := Proc.DeclUnit;
end;

{TIdentTable}

constructor TIdentTable.Create;
begin
  FList := TList.Create;
end;

destructor TIdentTable.Destroy;
begin
  //Clear;
  FList.Free;
  inherited;
end;

procedure TIdentTable.Clear;
begin
  FList.Clear;
end;

procedure TIdentTable.Add(AObject: TIdentObject);
begin
  FList.Add(AObject);
end;

function TIdentTable.Count: Integer;
begin
  Result := FList.Count;
end;

function TIdentTable.GetItems(Index: Integer): TIdentObject;
begin
  Result := TIdentObject(FList.Items[Index]);
end;

procedure TIdentTable.Remove(AObject: TIdentObject);
begin
  FList.Remove(AObject);
end;

function TIdentTable.Find(AName: TDpString; HashValue: Cardinal): TIdentObject;
var
  I: Integer;
begin
  Result := nil;
  AName := UTF8LowerCase(AName);
  if HashValue = 0 then
    HashValue := Hash(AName);
  I := 0;
  while I < FList.Count do
  begin
    if (TIdentObject(FList.Items[I]).FHashValue = HashValue)
      and (TIdentObject(FList.Items[I]).FName = AName) then
    begin
      Result := TIdentObject(FList.Items[I]);
      Break;
    end;
    Inc(I);
  end;
end;

{TStringObject}

procedure TStringObject.SetValue(AValue: Variant);
begin
  FValue := string(AValue);
end;

{TClassPublicProp}
procedure TClassPublicProp.Assign(Source: TIdentObject);
begin
  inherited Assign(Source);
  GetPrValue := TClassPublicProp(Source).GetPrValue;
  SetPrVAlue := TClassPublicProp(Source).SetPrVAlue;
end;

{TClassPublishedProp}

procedure TClassPublishedProp.Assign(Source: TIdentObject);
begin
  inherited Assign(Source);
  AProp := TClassPublishedProp(Source).AProp;
  OnlyRead := TClassPublishedProp(Source).OnlyRead;
end;

{TClassIndexedProp}

constructor TClassIndexedProp.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  Params := TList.Create;
end;

destructor TClassIndexedProp.Destroy;
begin
  Params.Free;
  inherited Destroy;
end;

procedure TClassIndexedProp.Assign(Source: TIdentObject);
var
  ASource: TClassIndexedProp;
  I: Integer;
begin
  inherited Assign(Source);
  ASource := TClassIndexedProp(Source);
  GetMethod := ASource.GetMethod;
  SetMethod := ASource.SetMethod;
  for I := 0 to ASource.Params.Count - 1 do
  begin
    Params.Add(ASource.Params[I]);
  end;
end;

{TDpCode}

constructor TDpCode.Create(AProc: TDpCustomProc; ACol, ARow: Integer);
begin
  inherited Create;
  FParentCode := nil;
  FProc := AProc;
  FCompiler := AProc.Compiler;
  FDebugInfo := nil;
  if FCompiler.Debug then
  begin
    FDebugInfo := TDebugInfo.Create;
    FDebugInfo.Col := ACol;
    FDebugInfo.Row := ARow;
    FDebugInfo.DeclUnit := AProc.DeclUnit;
  end;
end;

destructor TDpCode.Destroy;
begin
  if FDebugInfo <> nil then FDebugInfo.Free;
  inherited Destroy;
end;

procedure TDpCode.Exec;
begin
  FPos := 0;
  while (FPos < Count) and not Proc.FBreak and not Proc.FExit do
  begin
    TDpCode(Items[FPos]).Exec;
    Inc(FPos);
  end;
end;

function TDpCode.Add(AObject: TObject): Integer;
begin
  TDpCode(AObject).FParentCode := Self;
  Result := inherited Add(AObject);
end;

{TArrayObject}

procedure TArrayObject.Assign(Source: TIdentObject);
begin
  inherited Assign(Source);
  DimCount := TArrayObject(Source).DimCount;
  FDataType := TArrayObject(Source).FDataType;
  FValue := Source.FValue;
end;

procedure TArrayObject.SetValue(AValue: Variant);
begin
  inherited SetValue(AValue);
  if FDinArray then
  begin
    FDimCount := VarArrayDimCount(FValue);
  end;
end;

{TArrayValueObject}

constructor TArrayValueObject.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  ValueType := Compiler.ArrayType;
  FList := TList.Create;
end;

destructor TArrayValueObject.Destroy;
begin
  FList.Free;
  inherited Destroy;
end;

function TArrayValueObject.GetValue: Variant;
var
  I: Integer;
begin
  Result := VarArrayCreate([0, FList.Count], varVariant);
  for I := 0 to FList.Count - 1 do
    Result[I] := TIdentObject(FList.Items[I]).Value;
end;

{TSetObject}

constructor TSetObject.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FMinVal := 0;
  FMaxVal := 255;
  IdentType := itValue;
  RefType := nil;
  New(SVal);
  SVal^ := [];
end;

destructor TSetObject.Destroy;
begin
  Dispose(SVal);
  inherited Destroy;
end;

{function TSetObject.GetSetValue: TDSSet;
begin
  Result := FSetVal;
end;}

procedure TSetObject.SetValue(AValue: Variant);
begin
  SVal^ := PDSSet(TSuPtr(AValue))^;
end;

function TSetObject.GetValue: Variant;
begin
  Result := TSuPtr(SVal);
end;

procedure TSetObject.Assign(Source: TIdentObject);
begin
  inherited Assign(Source);
  FRefType := TSetObject(Source).FRefType;
  FMinVal := TSetObject(Source).MinVal;
  FMaxVal := TSetObject(Source).MaxVal;
end;

{TEnumObject}

procedure TEnumObject.SetValue(AValue: variant);
begin
 if (AValue <  ValueType.MinVal) or (AValue > ValueType.MaxVal) then
    raise Exception.Create('Недопустимое значение для перечисления ' + string(ValueType.OriginalName))
 else FValue := AValue;
end;

{TRecObject}

constructor TRecObject.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  P := nil;
  RecSize := 0;
end;

destructor TRecObject.Destroy;
begin
  if P <> nil then FreeMem(P, RecSize);
  inherited Destroy;
end;

procedure TRecObject.SetValueType(AValue: TDpType);
begin
  inherited SetValueType(AValue);
  RecSize := ValueType.Size;
  GetMem(P, RecSize);
end;

function TRecObject.GetValue: Variant;
begin
  Result := TSuPtr(P);
end;

procedure TRecObject.SetValue(AValue: Variant);
var
  PS: Pointer;
  ASize: Integer;
begin
  PS := Pointer(TSuPtr(AValue));
  if PS <> nil then
  begin
    ASize := ValueType.Size;
    Move(PS, P, ASize);
  end;
end;

{TSCriptRecord}

destructor TScriptRecord.Destroy;
begin
  if Obj <> nil then
  begin
    Compiler.DeleteObjectData(Obj);
    Obj.Free;
  end;

  inherited Destroy;
end;

procedure TScriptRecord.SetValueType(AValue: TDpType);
begin
  inherited SetValueType(AValue);
  Obj := TObject.Create;
  FValue := TSuPtr(Obj);
  ClassData := Compiler.AddObjectData(Obj, AValue);
end;

procedure TScriptRecord.SetValue(AValue: Variant);
var
  Source: TObject;
  SourceData: TDpClassData;
  I: Integer;
begin
  Source := TObject(TSuPtr(AValue));
  SourceData := Compiler.GetData(Source);
  for I := 0 to ClassData.FDataList.Count - 1 do
  begin
    TIdentObject(ClassData.FDataList.Items[I]).Value :=
      TIdentObject(SourceData.FDataList.Items[I]).Value;
  end;
end;

{TRecFieldObject}

function TRecFieldObject.GetValue: Variant;
var
  R: TRecObject;
  F: TFindClassVar;
  C: TClassCallProp;
  AObj: TObject;
  P: Pointer;
begin
  Result := Unassigned;
  if RO is TFindClassVar then
  begin
    F := TFindClassVar(RO);
    AObj := TObject(TSuPtr(F.FVal.Value));
    R := TRecObject(FCompiler.FindObjectData(AObj, F.Name));
    if Assigned(AGetprop) then Result := AGetprop(R.P);
  end
  else
  if RO is TClassCallProp then
  begin
    C := TClassCallProp(RO);
    P := Pointer(TSuPtr(C.Value));
    Result := AGetprop(P);
  end
  else
  begin
    R := TRecObject(RO);
    if Assigned(AGetprop) then Result := AGetprop(R.P);
  end

end;

procedure TRecFieldObject.SetValue(AValue: Variant);
var
  R: TRecObject;
  F: TFindClassVar;
  AObj: TObject;
begin
  if RO is TFindClassVar then
  begin
    F := TFindClassVar(RO);
    AObj := TObject(TSuPtr(F.FVal.Value));
    R := TRecObject(FCompiler.FindObjectData(AObj, F.Name));
  end
  else
    R := TRecObject(RO);
  if Assigned(ASetProp) then ASetProp(R.P, AValue);
end;

{TSimpleExpression}

function TSimpleExpression.GetValue: Variant;
begin
  if FVal is TAdresExpression then
    Result := TIdentObject(TSuPtr(FVal.Value)).Value
  else
    Result := FVal.Value;
end;

procedure TSimpleExpression.SetValue(AValue: Variant);
begin
  FVal.Value := AValue;
end;

{TAdaptiveMinusExpression}

function TAdaptiveMinusExpression.GetValue: Variant;
begin
  Result := - FVal.Value;
end;

{TArrayExpression}

constructor TArrayExpression.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FParams := TList.Create;
end;

destructor TArrayExpression.Destroy;
begin
  FParams.Clear;
  FParams.Free;
  inherited Destroy;
end;

function TArrayExpression.GetValue: Variant;
var
  AI: array of LongInt;
  i, Dcount: Integer;
  IO: TIdentObject;
  C: TComponent;
  IC: TSuPtr;
begin
  IO := TIdentObject(TSuPtr(FValue));
  DCount := VarArrayDimCount(IO.Value);
  SetLength(AI, Dcount);
  for i := 0 to DCount - 1 do
    AI[i] := TIdentObject(Params.Items[I]).Value;
  Result := VarArrayGet(IO.Value, AI);
  SetLength(AI, 0);
end;

procedure TArrayExpression.SetValue(AValue: Variant);
var
  AI: array of LongInt;
  I, DCount: Integer;
  IO: TIdentObject;
  C: TComponent;
  IC: TSuPtr;
  V: Variant;
begin
  IO := TIdentObject(TSuPtr(FValue));
  DCount := VarArrayDimCount(IO.Value);
  SetLength(AI, DCount);
  for i := 0 to DCount - 1 do
    AI[I] := TIdentObject(Params.Items[I]).Value;
  V := IO.Value;
  VarArrayPut(V, AValue, AI);
  IO.Value := V;
  SetLength(AI, 0);
end;

procedure TArrayExpression.SetObject(IO: TIdentObject);
begin
  FValue := TSuPtr(IO);
end;

function TArrayExpression.GetObject: TIdentObject;
begin
  Result := TIdentObject(TSuPtr(FValue));
end;

{TCharArrayExpression}

constructor TCharArrayExpression.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FParams := TList.Create;
end;

destructor TCharArrayExpression.Destroy;
begin
  FParams.Clear;
  FParams.Free;
  inherited Destroy;
end;

function TCharArrayExpression.GetValue: Variant;
var
  S: string;
  AnsStr, Res: String;
  i: Integer;
  P: PChar;
begin
  S := Val.Value;
  I := TIdentObject(Params.Items[0]).Value;
  P := PChar(S);
  if FindInvalidUTF8Character(P, Length(S)) = -1 then
  begin
    Res := UTF8Copy(S, I, 1);
    Result := Res;
  end
  else
  begin
    AnsStr := S;
    Res := AnsStr[I];
    Result := Res;
  end;
end;

procedure TCharArrayExpression.SetValue(AValue: Variant);
var
  S: string;
  AnsStr, S2: AnsiString;
  C: Char;
  i: Integer;
  P: PChar;
begin
  S := Val.Value;
  P := PChar(S);
  if FindInvalidUTF8Character(P, Length(S)) = -1 then
    AnsStr := dp_UTF8ToAnsi(S)
  else AnsStr := S;
  I := TIdentObject(Params.Items[0]).Value;
  S2 := AValue;
  P := PChar(S2);
  if FindInvalidUTF8Character(P, Length(S2)) = -1 then
    S2 := dp_UTF8ToAnsi(S2);
  C := S2[1];
  AnsStr[I] := C;
  S := dp_AnsiToUTF8(AnsStr);
  Val.Value := S;
end;

function TBoolNotExpression.GetValue: Variant;
begin
  Result := not Boolean(FVal.Value);
end;

function TBitwiseNotExpression.GetValue: Variant;
begin
  Result := not Integer(FVal.Value);
end;

{TExpression}

function TExpression.GetValue: Variant;
begin
  Left.Value := Right.Value;
  Result := Left.Value;
end;

function TAddExpression.GetValue: Variant;
begin
  Result := Left.Value + Right.Value;
end;

//function TSetAddExpression.GetSetValue: TDSSet;
function TSetAddExpression.GetValue: Variant;
begin
  S := PDSSet(TSuPtr(Left.Value))^ + PDSSet(TSuPtr(Right.Value))^;
  Result := TSuPtr(@S);
  //Result :=  Left.GetSetValue + Right.GetSetValue;
end;

//function TSetSubExpression.GetSetValue: TDSSet;
function TSetSubExpression.GetValue: Variant;
begin
  S := PDSSet(TSuPtr(Left.Value))^ - PDSSet(TSuPtr(Right.Value))^;
  Result := TSuPtr(@S);
  //Result := Left.GetSetValue - Right.GetSetValue;
end;

//function TSetMulExpression.GetSetValue: TDSSet;
function TSetMulExpression.GetValue: Variant;
begin
  S := PDSSet(TSuPtr(Left.Value))^ * PDSSet(TSuPtr(Right.Value))^;
  Result := TSuPtr(@S);
  //Result := Left.GetSetValue * Right.GetSetValue;
end;

function TSubExpression.GetValue: Variant;
begin
  Result := Left.Value - Right.Value;
end;

function TMulExpression.GetValue: Variant;
begin
  Result := Left.Value * Right.Value;
end;

function TDivExpression.GetValue: Variant;
begin
  Result := Left.Value / Right.Value;
end;

function TModExpression.GetValue: Variant;
begin
  Result := Left.Value mod Right.Value;
end;

function TDivIExpression.GetValue: Variant;
begin
  Result := Left.Value div Right.Value;
end;

function TIsExpression.GetValue: Variant;
var
  AType: TDpType;
begin
  if (Left.ValueType.ScriptClass) and (Right.ValueType.ScriptClass) then
  begin
    Result := False;
    AType := Left.ValueType;
    while AType <> nil do
    begin
      if AType = Right.ValueType then
      begin
        Result := True;
        Break;
      end;
      AType := AType.Parent;
      if not AType.ScriptClass then Break;
    end;
  end
  else
    Result := TObject(TSuPtr(Left.Value)) is Right.ValueType.ValueClassType;
end;

function TEqualExpression.GetValue: Variant;
begin
  Result := Left.Value = Right.Value;
end;

function TSetEqualExpression.GetValue: Variant;
begin
  Result := PDSSet(TSuPtr(Left.Value))^ = PDSSet(TSuPtr(Right.Value))^;
  //Result := Left.GetSetValue = Right.GetSetValue;
end;

function TNotEqualExpression.GetValue: Variant;
begin
  Result := Left.Value <> Right.Value;
end;

function TSetNotEqualExpression.GetValue: Variant;
begin
  Result := PDSSet(TSuPtr(Left.Value))^ <> PDSSet(TSuPtr(Right.Value))^;
end;

function TGreatExpression.GetValue: Variant;
begin
  Result := Left.Value > Right.Value;
end;

function TLessExpression.GetValue: Variant;
begin
  Result := Left.Value < Right.Value;
end;

function TGreatEqualExpression.GetValue: Variant;
begin
  Result := Left.Value >= Right.Value;
end;

function TSetGreatEqualExpression.GetValue: Variant;
begin
  Result := PDSSet(TSuPtr(Left.Value))^ >= PDSSet(TSuPtr(Right.Value))^;
end;

function TLessEqualExpression.GetValue: Variant;
begin
  Result := Left.Value <= Right.Value;
end;

function TSetLessEqualExpression.GetValue: Variant;
begin
  Result := PDSSet(TSuPtr(Left.Value))^ <= PDSSet(TSuPtr(Right.Value))^;
end;

function TInExpression.GetValue: Variant;
var
  Ch: AnsiChar;
  SS: string;
  B: Byte;
begin
  if Left.ValueType.BaseType = btChar then
  begin
    SS := Left.Value;
    Ch := AnsiChar(SS[1]);
    B := Ord(Ch);
  end
  else
    B := Left.Value;
  Result := B in PDSSet(TSuPtr(Right.Value))^;
end;

function TLogicAndExpression.GetValue: Variant;
begin
  Result := Boolean(Left.Value) and Boolean(Right.Value);
end;

function TLogicOrExpression.GetValue: Variant;
begin
  Result := Boolean(Left.Value) or Boolean(Right.Value);
end;

function TLogicXOrExpression.GetValue: Variant;
begin
  Result := Boolean(Left.Value) xor Boolean(Right.Value);
end;

function TBitwiseAndExpression.GetValue: Variant;
begin
  Result := Integer(Left.Value) and Integer(Right.Value);
end;

function TBitwiseOrExpression.GetValue: Variant;
begin
  Result := Integer(Left.Value) or Integer(Right.Value);
end;

function TBitwiseXorExpression.GetValue: Variant;
begin
  Result := Integer(Left.Value) xor Integer(Right.Value);
end;

function TShlExpression.GetValue: Variant;
begin
  Result := Integer(Left.Value) shl Integer(Right.Value);
end;

function TShrExpression.GetValue: Variant;
begin
  Result := Integer(Left.Value) shr Integer(Right.Value);
end;

{TDispExpression}

constructor TDispExpression.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FParams := TList.Create;
end;

destructor TDispExpression.Destroy;
begin
  FParams.Free;
  inherited Destroy;
end;

procedure TDispExpression.AddParam(AParam: TIdentObject);
begin
  FParams.Add(AParam);
end;

function TDispExpression.DoInvoke(AParams: Variant; PCount: Integer;
  IsSetProp: Boolean): Variant;
var
  V, ParamVal: OleVariant;
  I: Integer;
  Flags: Word;
  DispIds: TDispId;
  ExcepInfo: TExcepInfo;
  Params: TDISPPARAMS;
  WName: WideString;
  S: string;
  Args: array[0..16] of Variant;
  ArgsNamed: array[0..0] of TDispID;
  P: PVariant;
  InvokeRes: Integer;
  vtp: tvartype;
begin
  WName := UTF8Decode(Name);
  V := FVal.Value;

  if TVarData(V).VType = varDispatch then
  begin
    IDispatch(V).GetIDsOfNames(GUID_NULL, @WName, 1, GetThreadLocale, @DispIds);
    //Параметры передаются в обратном порядке
    for I := 0 to PCount - 1 do
    begin
      ParamVal := AParams[PCount - I - 1];
      vtp := TVarData(ParamVal).vtype;
      if vtp in [varolestr, varstring] then
      begin
        S := ParamVal;
        Args[I] := UTF8Decode(S);
      end
      else
        Args[I] := ParamVal;
    end;

    //Неименованные параметры
    Params.rgvarg := @Args;
    Params.cArgs := PCount;
    //Отключаем именованные
    Params.rgdispidNamedArgs := nil;
    Params.cNamedArgs := 0;

    Flags := DISPATCH_PROPERTYPUT;

    if IsSetProp then
    begin
      P := nil;
      //Установка занчения свойства
      //В Именованные параметры передаем DISPID_PROPERTYPUT
      ArgsNamed[0] := DISPID_PROPERTYPUT;
      Params.rgdispidNamedArgs := @ArgsNamed;
      Params.cNamedArgs := 1;
    end
    else
    begin
      P := @Result;
      VarClear(P^);
      Flags := DISPATCH_METHOD or DISPATCH_PROPERTYGET;
    end;

    InvokeRes := IDispatch(V).Invoke(DispIds, GUID_NULL, 0,
      Flags, Params, P, @ExcepInfo, nil);
    if InvokeRes <> S_OK then
    begin
      raise Exception.Create('OLE error ' + IntToHex(InvokeRes, 8) + ': ' +
        string(Name) + ': ' + SysErrorMessage(InvokeRes));
    end;
  end
  else
    raise Exception.Create(string(FVal.Name) + ' не содержит интерфейс IDispatch');
end;

function TDispExpression.GetValue: Variant;
var
  V: Variant;
  I: Integer;
  S: string;
begin
  v := VarArrayCreate([0, FParams.Count - 1], varVariant);
  for i := 0 to FParams.Count - 1 do
    v[i] := TIdentObject(FParams.Items[i]).Value;

  Result := DoInvoke(v, FParams.Count, False);
  if tvardata(Result).vtype = varolestr then
  begin
    S := Result;
    Result := S;
  end;
end;

procedure TDispExpression.SetValue(AValue: Variant);
var
  V: Variant;
  I: Integer;
begin
  V := VarArrayCreate([0, FParams.Count], varVariant);
  for I := 0 to FParams.Count - 1 do
    V[I] := TIdentObject(FParams[I]).Value;
  V[FParams.Count] := AValue;

  DoInvoke(V, FParams.Count + 1, True);
end;

{TClassPropObject}

function TClassPropObject.GetValue: Variant;
var
  Intf: IInterface;
  ICR: IInterfaceComponentReference;
begin
  case Prop^.PropType^.Kind of
    tkMethod:
    begin
      Compiler.Method := GetMethodProp(TObject(TSuPtr(FVal.Value)), Prop);
      Result := TSuPtr(@Compiler.Method);
    end;

    tkInterface:
    begin
      Intf := GetInterfaceProp(TObject(TSuPtr(FVal.Value)), Prop);
      Result := TSuPtr(Intf);
      if intf is IDispatch then
      begin
        Result := IDispatch(Intf);
      end
      else
      if Supports(Intf, IInterfaceComponentReference, ICR) then
        Result := TSuPtr(ICR.GetComponent);
    end;

    else
      Result := GetPropValue(TObject(TSuPtr(FVal.Value)), Prop^.Name, False);
  end;
end;

procedure TClassPropObject.SetValue(AValue: Variant);
var
  O: TObject;
  C: TComponent;
  Intf: IInterface;
  ACharVal: Char;
begin
  O := TObject(TSuPtr(FVal.Value));
  if Prop^.PropType^.Kind = tkClass then
    SetObjectProp(O, Prop, TObject(TSuPtr(AValue)))
  else
  if Prop^.PropType^.Kind = tkInterface then
  begin
    C := TComponent(TSuPtr(AValue));
    if Supports(TObject(C), GetTypeData(Prop^.PropType)^.Guid, Intf) then
    begin
      SetInterfaceProp(O, Prop, Intf);
    end;
  end
  else
  if Prop^.PropType^.Kind = tkChar then
  begin
    ACharVal := AValue;
    SetOrdProp(O, Prop^.Name, Ord(ACharVal));
  end
  else
    SetPropValue(O, Prop^.Name, AValue);
end;

function TClassSetProp.GetValue: Variant;
var
  S: string;
  O: TObject;
  SetV: TIntegerSet;
begin
  O := TObject(TSuPtr(FVal.Value));
  S := GetSetProp(O, Prop, False);
  Integer(SetV) := StringToSet(Prop, S);
  SetVal := SetV;
  Result := TSuPtr(@SetVal);
end;

procedure TClassSetProp.SetValue(AValue: Variant);
var
  O: TObject;
  S: string;
  SetV: TIntegerSet;
begin
  O := TObject(TSuPtr(FVal.Value));
  SetVal := PDSSet(TSuPtr(AValue))^;
  SetV := SetVal;
  S := SetToString(Prop, Integer(SetV));
  SetSetProp(O, Prop, S);
end;

function TClassInterfaceProp.GetValue: Variant;
var
  Intf: IInterface;
  ICR: IInterfaceComponentReference;
begin
  Result := 0;
  Intf := GetInterfaceProp(TObject(TSuPtr(FVal.Value)), Prop);
  if Supports(Intf, IInterfaceComponentReference, ICR) then
    Result := TSuPtr(ICR.GetComponent);
end;

procedure TClassInterfaceProp.SetValue(AValue: Variant);
var
  O: TObject;
  C: TComponent;
  Intf: IInterface;
begin
  O := TObject(TSuPtr(FVal.Value));
  C := TComponent(TSuPtr(AValue));
  if Supports(TObject(C), GetTypeData(Prop^.PropType)^.Guid, Intf) then
      SetInterfaceProp(O, Prop, Intf);
end;

{TFindComponent}

function TFindComponent.GetValue: Variant;
var
  C: TComponent;
begin
  C := TComponent(TSuPtr(FVal.Value));
  Result := TSuPtr(C.FindComponent(Name));
  //Result := Integer(Compiler.ExtFindComponent(C, Name))
end;

{TClassCallProp}

function TClassCallProp.GetValue: Variant;
begin
  if Assigned(GetPrValue) then Result := GetPrValue(TObject(TSuPtr(FVal.Value)))
  else Result := Unassigned;
end;

procedure TClassCallProp.SetValue(AValue: Variant);
begin
  if Assigned(SetPrValue) then SetPrValue(TObject(TSuPtr(FVal.Value)), AValue);
end;

{TIndexPropCaller}

constructor TIndexedPropCaller.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FList := TList.Create;
end;

destructor TIndexedPropCaller.Destroy;
begin
  FList.Free;
  inherited Destroy;
end;

function TIndexedPropCaller.GetValue: Variant;
var
  V: Variant;
  I: Integer;
begin
  V := VarArrayCreate([0, FList.Count - 1], varVariant);
  for I := 0 to FList.Count - 1 do V[I] := TIdentObject(FList.Items[I]).Value;
  Result := GetMethod(TObject(TSuPtr(FVal.Value)), V);
end;

procedure TIndexedPropCaller.SetValue(AValue: Variant);
var
  V: Variant;
  I: Integer;
begin
  V := VarArrayCreate([0, FList.Count], varVariant);
  for I := 0 to FList.Count - 1 do V[I] := TIdentObject(FList.Items[I]).Value;
  V[FList.Count] := AValue;

  SetMethod(TObject(TSuPtr(FVal.Value)), V);
end;

{TFindClassVar}

function TFindClassVar.GetValue: Variant;
var
  AObj: TObject;
begin
  AObj := TObject(TSuPtr(FVal.Value));
  Result := FCompiler.FindObjectData(AObj, Name).Value;
end;

procedure TFindClassVar.SetValue(AValue: Variant);
var
  AObj: TObject;
begin
  AObj := TObject(TSuPtr(FVal.Value));
  FCompiler.FindObjectData(AObj, Name).Value := AValue;
end;

{TDpClassData}

constructor TDpClassData.Create(ACompiler: TDpCompiler; AObject: TObject; AType: TDpType);
var
  I: Integer;
  IO: TIdentObject;
  AClass: TIdentClass;
begin
  inherited Create;
  FType := AType;
  FCompiler := ACompiler;
  FObject := AObject;
  FDataList := TIdentTable.Create;
  if AType = nil then Exit;
  while AType.ScriptClass do
  begin
    for I := 0 to AType.FClassObjects.Count - 1 do
    begin
      if (AType.FClassObjects.Items[I].IdentType = itClassVar) then
      begin
        AClass := TIdentClass(AType.FClassObjects.Items[I].ClassType);
        IO := AClass.Create(ACompiler);
        IO.Assign(AType.FClassObjects.Items[I]);
        FDataList.Add(IO);
      end
    end;
    AType := AType.Parent;
  end;
end;

destructor TDpClassData.Destroy;
var
  AIdent: TIdentObject;
begin
  AIdent := FType.FindClassObject('Destroy', False);
  if AIdent <> nil then
  begin
    TSuProc(AIdent).DataObject.Value := TSuPtr(FObject);
    TSuProc(AIdent).Exec;
  end;
  ClearData;
  FDataList.Free;
  inherited Destroy;
end;

procedure TDpClassData.ClearData;
var
  I: Integer;
begin
  for I := 0 to FDataList.Count - 1 do
  begin
    TObject(FDataList.Items[I]).Free;
  end;
  FDataList.Clear;
end;

procedure TDpClassData.AddData(ACompiler: TDpCompiler; AType: TDpType);
var
  I: Integer;
  IO: TIdentObject;
  AClass: TIdentClass;
  SaveType: TDpType;
begin
  SaveType := FType;
  FType := AType;
  while AType.ScriptClass do
  begin
    for I := 0 to AType.FClassObjects.Count - 1 do
    begin
      if (AType.FClassObjects.Items[I].IdentType = itClassVar) then
      begin
        AClass := TIdentClass(AType.FClassObjects.Items[I].ClassType);
        IO := AClass.Create(ACompiler);
        IO.Assign(AType.FClassObjects.Items[I]);
        FDataList.Add(IO);
      end;
    end;
    AType := AType.Parent;
    if AType = SaveType then Break;
  end;
end;

procedure TDpClassData.AddObject(IO: TIdentObject);
begin
  FDataList.Add(IO);
end;

function TDpClassData.Find(AName: TDpString): TIdentObject;
begin
  Result := FDataList.Find(AName, 0);
end;

{TAdresExpression}

constructor TAdresExpression.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FValueType := ACompiler.FindType('Pointer', nil, True);
end;

function TAdresExpression.AssignedValue: Boolean;
begin
  Result := FValue <> 0;
end;

{TDpEventHandler}

constructor TDpEventHandler.Create(AProc: TDpCustomProc);
begin
  inherited Create;
  Proc := AProc;
end;

destructor TDpEventHandler.Destroy;
begin
  inherited Destroy;
end;

procedure TDpEventHandler.ShiftToSet(PSet: PDSSet; Shift: TShiftState);
begin
  PSet^ := [];
  if ssShift in Shift then Include(PSet^, Integer(ssShift));
  if ssAlt in Shift then Include(PSet^, Integer(ssAlt));
  if ssCtrl in Shift then Include(PSet^, Integer(ssCtrl));
  if ssLeft in Shift then Include(PSet^, Integer(ssLeft));
  if ssRight in Shift then Include(PSet^, Integer(ssRight));
  if ssMiddle in Shift then Include(PSet^, Integer(ssMiddle));
  if ssDouble in Shift then Include(PSet^, Integer(ssDouble));
end;

function TDpEventHandler.GetHandlerAdres: Pointer;
begin
  Result := MethodAddress('CallHandler');
end;

{TDpCustomProc}

constructor TDpCustomProc.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  //RefObject := nil;
  FImpl := False;
  FEventHandler := nil;
  FIsConstructor := False;
  FUnits :=TList.Create;
  FBreak := False;
  FContinue := False;
  FExit := False;
  FDataObject := nil;
  FIdentType := itProc;
  FVars := TIdentTable.Create;
  FParams := TList.Create;
  FProcs := TIdentTable.Create;
  FObjects := TList.Create;
  FTypeTable := TTypeTable.Create(ACompiler);
  FTypeTable.FCompiler := FCompiler;
  FErrorObjects := TIdentTable.Create;
  FProc := nil;
  FProcRun := False;
end;

destructor TDpCustomProc.Destroy;
begin
  FProcs.Free;
  FObjects.Clear;
  FObjects.Free;
  FVars.Free;
  FParams.Clear;
  FParams.Free;
  FTypeTable.Free;
  FErrorObjects.Free;
  FUnits.Free;
  if FEventHandler <> nil then FEventHandler.Free;
  FEventHandler := nil;
  inherited;
end;

function TDpCustomProc.CreateEventHandler(AType: PTypeInfo): Pointer;
var
  HandlClass: TdpEventHandlerClass;
begin
  Result := nil;
  if FEventHandler = nil then
  begin
    HandlClass := Compiler.GetHandlerClass(AType);
    if HandlClass <> nil then
    begin
      FEventHandler := HandlClass.Create(Self);
      Result := FEventHandler.GetHandlerAdres;
    end;
  end
  else Result := FEventHandler.GetHandlerAdres;
end;

function TDpCustomProc.GetValue: Variant;
begin
  //if (Proc is TUnitProc) and (Proc.FCode.Count > 0) and not (TUnitProc(Proc).Ini) then
  //begin
  //  TUnitProc(Proc).Inicializ;
  //end;
  try
    Inc(FExecuteCount);
    FCode.Exec;
    Result := Unassigned;
    if FResultValue <> nil then Result := FResultValue.FValue;
    if Assigned(FCompiler.FOnAfterCallProc) then FCompiler.FOnAfterCallProc(Self);
  finally
    Dec(FExecuteCount);
    FExit := False;
  end;
end;

function TDpCustomProc.GetParamCount: Integer;
begin
  Result := FParams.Count;
end;

function TDpCustomProc.GetParam(ParamIndex: Integer): TIDentObject;
begin
  Result := TIdentObject(FParams.Items[ParamIndex]);
end;

function TDpCustomProc.GetEventHandler: TDpEventHandler;
begin
  Result := FEventHandler;
end;

procedure TDpCustomProc.Exec;
begin
  GetValue;
end;

procedure TDpCustomProc.InitializVar;
var
  I: Integer;
begin
  for I := 0 to FVars.Count - 1 do FVars.Items[I].Inicializ;
end;

procedure TDpCustomProc.AddVar(AVar: TIdentObject; ACol, ARow: Integer);
begin
  AVar.Proc := Self;
  AVar.FCol := ACol;
  AVar.FRow := ARow;
  AVar.IdentType := itVar;

  FVars.Add(AVar);
  FObjects.Add(AVar);
end;

procedure TDpCustomProc.AddParam(AParam: TIdentObject);
begin
  AParam.Proc := Self;
  AddVar(AParam, 0, 0);
  AParam.IdentType := itParam;
  FParams.Add(AParam);
end;

procedure TDpCustomProc.AddConst(AConst: TIdentObject);
var
  I: Integer;
begin
  AConst.Proc := Self;
  AConst.FCompiler := FCompiler;
  FVars.Add(AConst);
  I := FObjects.Add(AConst);
  AConst.IdentType := itConst;
end;

procedure TDpCustomProc.AddErrObject(AObj: TIdentObject);
begin
  AObj.IdentType := itVar;
  FErrorObjects.Add(AObj);
end;

procedure TDpCustomProc.AddProc(AProc: TIdentObject);
begin
  AProc.FProc := Self;
  AProc.FCompiler := FCompiler;
  FProcs.Add(AProc);
  FObjects.Add(AProc);
  AProc.IdentType := itProc;
end;

{TRefProc}

function TRefProc.GetParamCount: Integer;
begin
  Result := Proc.ParamCount;
end;

function TRefProc.GetParam(ParamIndex: Integer): TIdentObject;
begin
  Result := Proc.Param[ParamIndex];
end;

function TRefProc.GetValue: Variant;
var
  I: Integer;
begin
  Proc.FDataObject.Value := RefObj.Value;
  for I := 0 to Proc.FVars.Count -1 do
  begin
    if Proc.FVars.Items[I].IdentType = itVar then
      Proc.FVars.Items[I].Inicializ;
  end;
  Result := Proc.Value;
end;

procedure TRefProc.SetValue(AValue: Variant);
begin

end;

procedure TRefProc.SetProc(AValue: TDpCustomProc);
begin
  inherited SetProc(AValue);
  Name := AValue.OriginalName;
  FValueType := AValue.ValueType;
end;

procedure TRefProc.Exec;
begin
  GetValue;
end;

constructor TRefProc.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  RefObj := TIdentObject.Create(ACompiler);
end;

destructor TRefProc.Destroy;
begin
  RefObj.Free;
  inherited Destroy;
end;

{TSuProc}
constructor TSuProc.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FCode := TDpCode.Create(Self, 0, 0);
end;

destructor TSuProc.Destroy;
begin
  FCode.Free;
  inherited Destroy;
end;

{TUnitProc}

constructor TUnitProc.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FIni := False;
  FUnitCompiled := False;
end;

destructor TUnitProc.Destroy;
begin
  if FUnitTokens <> nil then
  begin
    FUnitTokens.Free;
    FUnitTokens := nil;
  end;
  inherited Destroy;
end;

function TUnitProc.GetValue: Variant;
begin
  if not FIni then
  begin
    Inicializ;
    Result := inherited GetValue;
  end;
end;

procedure TUnitProc.Inicializ;
var
  I: Integer;
begin
  Self.FIni := True;
  InitializVar;
  for I := 0 to FUnits.Count - 1 do
  begin
    TUnitProc(FUnits.Items[I]).GetValue;
  end;
  //GetValue;
end;

{TExternalMethod}

function TExternalMethod.GetValue: variant;
var
  V, Val: variant;
  I: Integer;
  AObj: TObject;
  IO: TIdentObject;
begin
  if Assigned(FOnCallMethod) then
  begin
    AObj := nil;
    if FDataObject <> nil then
    begin
      IO := FDataObject;
      if IO <> nil then
        AObj := TObject(PtrInt(IO.Value));
    end;

    V := VarArrayCreate([0, ParamCount + 1], varVariant);

    for  I := 0 to ParamCount - 1 do
    begin
      Val := Param[I].Value;
      V[I] := Val;
    end;

    if FIsConstructor then
      V[ParamCount] := PtrInt(FCreateType)
    else
      V[ParamCount] := ValueType.OriginalName;

    Result := FOnCallMethod(AObj, V);

    for  I := 0 to ParamCount - 1 do
    begin
      if Param[I].AsPointer then Param[I].Value := V[I];
    end;
  end;
end;

{TProcCaller}

constructor TProcCaller.Create(ACompiler: TDpCompiler);
begin
  inherited Create(ACompiler);
  FParams := TList.Create;
  Inh := False;
end;

destructor TProcCaller.Destroy;
begin
  FParams.Clear;
  FParams.Free;
  inherited Destroy;
end;

function TProcCaller.GetValue: Variant;
var
  I: Integer;
  B: Boolean;
  Obj: TObject;
  SaveVar: array of Variant;
  AType: TDpType;
  AProc: TSuProc;
  IO: TIdentObject;
  D: TDpClassData;
  RP: TRefProc;
  AE: TAdresExpression;
begin
  AProc := CallProc;
  if AProc is TPointerProc then
    AProc := TPointerProc(AProc).PProc;

  if not Inh and (FOwnerIdent <> nil) then
  begin
    Obj := TObject(TSuPtr(FOwnerIdent.Value));
    if Obj <> nil then
    begin
      AType := Compiler.FindTypeObject(Obj);
      if (AType <> nil) and (AProc.ClassOwner <> nil) and (AType <> AProc.ClassOwner) then
      begin
        IO := AType.FindClassObject(AProc.Name, False);
        if (IO <> nil) and (IO.IdentType = itProc) then
        begin
          AProc := TSuProc(IO);
        end;
      end;
    end;
  end;

  if AProc.ExecuteCount > 0 then
  begin
    SetLength(SaveVar, AProc.Vars.Count);
    for I := 0 to AProc.Vars.Count - 1 do
    begin
      SaveVar[I] := AProc.Vars.Items[I].Value;
      AProc.Vars.Items[I].Inicializ;
    end;
  end
  else
  begin
    for I := 0 to AProc.Vars.Count - 1 do
        AProc.Vars.Items[I].Inicializ;
  end;

  B := False;

  for I := 0 to FParams.Count - 1 do
  begin
    if AProc.Param[I].AsPointer then B := True;

    if (AProc.Param[I] is TAdresExpression) then
    begin
      if (TIdentObject(FParams.Items[I]).ValueType.BaseType = btPointer) then
      begin
        AProc.Param[I].Value := TIdentObject(FParams.Items[I]).Value;
        if (TIdentObject(FParams.Items[I]) is TAdresExpression)
          and (TAdresExpression(FParams.Items[I]).RefObject <> nil) then
        begin
          D := Compiler.GetData(TObject(TSuPtr(TAdresExpression(FParams.Items[I]).RefObject.Value)));
          if D <> nil then
          begin
            AE := TAdresExpression(AProc.Param[I]);
            IO := TIdentObject(TSuPtr(AE.Value));
            RP := TRefProc(D.Find(IO.Name));
            if RP = nil then
            begin
              RP := TRefProc.Create(Compiler);
              RP.Proc := TSuProc(IO);
              D.AddObject(RP);
            end;
            RP.RefObj.Value := TAdresExpression(FParams.Items[I]).RefObject.Value;
            AE.Value := TSuPtr(RP);
          end;
        end;
      end
      else
        AProc.Param[I].Value := TSuPtr(TIdentObject(FParams.Items[I]))
    end
    else
      AProc.Param[I].Value := TIdentObject(FParams.Items[I]).Value;
  end;

  if AProc.FDataObject <> nil then
  begin
    if FOwnerIdent <> nil then
    begin
      AProc.FDataObject.Value := FOwnerIdent.Value;
    end;
  end;

  Result := AProc.Value;

  if B then
  begin
    for I := 0 to FParams.Count - 1 do
    begin
      if AProc.Param[I].AsPointer then
      TIdentObject(FParams.Items[I]).Value := AProc.Param[I].Value;
    end;
  end;

  if AProc.ExecuteCount > 0 then
  begin
    for I := 0 to AProc.Vars.Count - 1 do AProc.Vars.Items[I].Value := SaveVar[I];
  end;
end;

procedure TProcCaller.SetValue(AValue: Variant);
begin
  FProc := TSuProc(TSuPtr(AValue));
end;

function TConstrCaller.GetValue: Variant;
var
  I: Integer;
  B: Boolean;
  SaveVar: array of Variant;
  F: TCustomForm;
  D: TDataModule;
  CD: TDpClassData;
  IO: TIdentObject;
  RP: TRefProc;
  AE: TAdresExpression;
begin
  if CallProc.ExecuteCount > 0 then
  begin
    SetLength(SaveVar, CallProc.Vars.Count);
    for I := 0 to CallProc.Vars.Count - 1 do SaveVar[I] := CallProc.Vars.Items[I].Value;
  end;

  B := False;

  CallProc.InitializVar;
  {for I := 0 to FParams.Count - 1 do
  begin
    if CallProc.Param[I].FAsPointer then B := True;
    CallProc.Param[I].Value := TIdentObject(FParams.Items[I]).Value;
  end;}

  for I := 0 to FParams.Count - 1 do
  begin
    if CallProc.Param[I].AsPointer then B := True;

    if (CallProc.Param[I] is TAdresExpression) then
    begin
      if (TIdentObject(FParams.Items[I]).ValueType.BaseType = btPointer) then
      begin
        CallProc.Param[I].Value := TIdentObject(FParams.Items[I]).Value;
        if (TIdentObject(FParams.Items[I]) is TAdresExpression)
          and (TAdresExpression(FParams.Items[I]).RefObject <> nil) then
        begin
          CD := Compiler.GetData(TObject(TSuPtr(TAdresExpression(FParams.Items[I]).RefObject.Value)));
          if CD <> nil then
          begin
            AE := TAdresExpression(CallProc.Param[I]);
            IO := TIdentObject(TSuPtr(AE.Value));
            RP := TRefProc(CD.Find(IO.Name));
            if RP = nil then
            begin
              RP := TRefProc.Create(Compiler);
              RP.Proc := TSuProc(IO);
              CD.AddObject(RP);
            end;
            RP.RefObj.Value := TAdresExpression(FParams.Items[I]).RefObject.Value;
            AE.Value := TSuPtr(RP);
          end;
        end;
      end
      else
        CallProc.Param[I].Value := TSuPtr(TIdentObject(FParams.Items[I]))
    end
    else
      CallProc.Param[I].Value := TIdentObject(FParams.Items[I]).Value;
  end;

  CallProc.FCreateType := ValueType;

  Result := CallProc.Value;

  if Result <> 0 then
  begin

    if CallProc.FCreateType.ScriptClass and (ValueType <> InhValueType) then
        FCompiler.AddObjectData(TObject(TSuPtr(Result)), ValueType);

    if  not Inh then
    begin
      if TObject(TSuPtr(Result)) is TForm then
      begin
        F := TCustomForm(TSuPtr(Result));
        if Assigned(F.OnCreate) then F.OnCreate(F);
      end
      else
      if TObject(TSuPtr(Result)) is TDataModule then
      begin
        D := TDataModule(TSuPtr(Result));
        if Assigned(D.OnCreate) then D.OnCreate(D);
      end;
    end;
  end;

  if B then
  begin
    for I := 0 to FParams.Count - 1 do
    begin
      if CallProc.Param[I].AsPointer then
      TIdentObject(FParams.Items[I]).Value := CallProc.Param[I].Value;
    end;
  end;


  if CallProc.ExecuteCount > 0 then
  begin
    for I := 0 to CallProc.Vars.Count - 1 do CallProc.Vars.Items[I].Value := SaveVar[I];
  end;
end;

{TClassImporter}

function TClassImporter.Create_Object(AClass: TClass): TObject;
begin
  Result := nil;
end;

procedure TClassImporter.RegisterPublic(AType: TDpType);
begin
  {Empty}
end;

procedure TClassImporter.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  {Empty}
end;

procedure TClassImporter.AddConsts(AddConst: TAddConstProc);
begin
  {Empty}
end;

procedure TClassImporter.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin

end;

procedure TClassImporter.AddMethods(AddMethod: TAddMethodProc);
begin

end;

procedure TClassImporter.AddVars(AddVar: TAddVarProc);
begin

end;

procedure TClassImporter.AddObjects(AddObject: TAddObjectProc);
begin

end;

procedure TClassImporter.AddTypes(AddType: TAddTypeProc);
begin

end;

procedure TClassImporter.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin

end;

{TIfInstruction}

constructor TIfInstruction.Create(AProc: TDpCustomProc; ACol, ARow: Integer);
begin
  inherited Create(AProc, ACol, ARow);
  FFalseCode := TDpCode.Create(AProc, ACol, ARow);
end;

destructor TIfInstruction.Destroy;
begin
  FFalseCode.Free;
  inherited Destroy;
end;

procedure TIfInstruction.Exec;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  if Condition.Value then inherited Exec
  else FalseCode.Exec;
end;

{TTryInstruction}

constructor TTryInstruction.Create(AProc: TDpCustomProc; ACol, ARow: Integer);
begin
  inherited Create(AProc, ACol, ARow);
  Ex := nil;
  FExcept := False;
  FErrCode := TDpCode.Create(AProc, ACol, ARow);
end;

destructor TTryInstruction.Destroy;
begin
  FErrCode.Free;
  inherited Destroy;
end;

procedure TTryInstruction.Exec;
var
  AExit: Boolean;
begin
  if FExcept then
  begin
    try
       inherited Exec;
     except on E: Exception do
       begin
         if Ex <> nil then Ex.Value := TSuPtr(E);
         FErrCode.Exec;
       end;
     end;
  end
  else
  begin
    try
      inherited Exec;
    finally
      AExit:= Proc.FExit;
      Proc.FExit:= False;
      FErrCode.Exec;
      if not Proc.FExit then
        Proc.FExit:= AExit;
    end;
  end;

end;

procedure TRepeatInstruction.Exec;
begin
  repeat
    inherited Exec;
    if Proc.FExit then Exit;

    if Proc.FBreak then
    begin
      Proc.FBreak := False;
      if Proc.FContinue then
      begin
        Proc.FContinue := False;
        Continue;
      end
      else Break;
    end;
    if FCompiler.Debug then
      FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  until Condition.Value = True;
end;

procedure TCallInstrcution.Exec;
var
  V: Variant;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  V := FProcCaller.GetValue;
end;

{TIncInstruction}

procedure TIncInstruction.Exec;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  Ident.Value := Ident.Value + IncValue;
end;

procedure TIncAssignInstruction.Exec;
var
  S: TDSSet;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  if FPlus then
  begin
    if Ident.ValueType.BaseType = btSet then
    begin
      S := PDSSet(TSuPtr(Ident.Value))^ + PDSSet(TSuPtr(IncValue.Value))^;
      Ident.Value := TSuPtr(@S);
    end
    else
      Ident.Value := Ident.Value + IncValue.Value
  end
  else
  begin
    if Ident.ValueType.BaseType = btSet then
    begin
      S := PDSSet(TSuPtr(Ident.Value))^ - PDSSet(TSuPtr(IncValue.Value))^;
      Ident.Value := TSuPtr(@S)
    end
    else
    Ident.Value := Ident.Value - IncValue.Value;
  end;
end;

{TDispInstruction}

procedure TDispInstruction.Exec;
var
  V: Variant;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  V := FDispExpr.GetValue;
end;

{ TArrayAssignInstruction }

procedure TArrayAssignInstruction.Exec;
var
  C: TComponent;
  AValue: Variant;
begin
  if Left.ValueType.BaseType = btClass  then
  begin
    AValue := Right.Value;
    Left.Value := AValue;
  end
  else
    Left.Value := Right.Value;
end;

{TMethodAssignInstruction}

procedure TMethodAssignInstruction.Exec;
var
  T: TMethod;
  ADest, ASource: TObject;
  P: PTypeInfo;
  AProc: TSuProc;
  IO: TIdentObject;
  MethodAdres: Pointer;
  MethodData: Pointer;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  if Left is TClassPropObject then
  begin
    ADest := TObject(TSuPtr(TClassPropObject(Left).FVal.Value));
    if Right is TClassPropObject then
    begin
      ASource := TObject(TSuPtr(TClassPropObject(Right).FVal.Value));
      T := GetMethodProp(ASource, TClassPropObject(Right).Prop);
      SetMethodProp(ADest, TClassPropObject(Left).Prop, T);
    end
    else
    begin
      P := TClassPropObject(Left).Prop^.PropType;
      MethodAdres := nil;
      MethodData := nil;
      AProc := nil;
      if Right is TAdresExpression then
      begin
        IO := TIdentObject(TSuPtr(Right.Value));
        if IO.IdentType = itProc then
        begin
          AProc := TSuProc(TSuPtr(Right.Value));
          if TAdresExpression(Right).RefObject <> nil then
            AProc.DataObject.Value := TAdresExpression(Right).RefObject.Value;
        end
        else
        begin
          if IO is TClassPropObject then
          begin
            T := TMethod(Pointer(TSuPtr(IO.Value))^);
            SetMethodProp(ADest, TClassPropObject(Left).Prop, T);
            Exit;
          end;
        end;

        {Proc.RefObject := Right.RefObject;
        Left.RefObject := Right.RefObject;}
      end
      else
      if Right is TSuProc then
      begin
        AProc := TSuProc(Right);
      end;

      if AProc <> nil then
      begin
        MethodAdres := TSuProc(AProc).CreateEventHandler(P);
        MethodData := TSuProc(AProc).EventHandler;
      end;

      T.Code := MethodAdres;
      T.Data := MethodData;
      SetMethodProp(ADest, TClassPropObject(Left).Prop, T);
    end;
  end
  else
  if Left.ValueType.BaseType = btPointer then
  begin
    Left.Value := TSuPtr(Right);
  end;
end;

{TSetAdresInstruction}
procedure TSetAdresInstruction.Exec;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  if (Right is TAdresExpression) or (Right.ValueType.BaseType = btPointer) then
    Left.Value := Right.Value
  else
    Left.Value := TSuPtr(Right);
end;

{TDSWhileInstruction}

procedure TWhileInstruction.Exec;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  while Condition.Value do
  begin
    inherited Exec;
    if Proc.FExit then Exit;
    if Proc.FBreak then
    begin
      Proc.FBreak := False;
      if Proc.FContinue then
      begin
        Proc.FContinue := False;
        if FCompiler.Debug then
          FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
        Continue;
      end
      else Break;
    end;
    if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  end;
end;

{TForInstruction}

constructor TForInstruction.Create(AProc: TDpCustomProc; ACol, ARow: Integer);
begin
  inherited Create(AProc, ACol, ARow);
  FAssign := TExpression.Create(AProc.Compiler);
end;

procedure TForInstruction.Exec;
var
  I: Integer;
  ToVal: Integer;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  ToVal := FToValue.Value;
  if IsDown then
  begin
    for I := Assign.Value downto ToVal do
    begin
      Assign.Left.Value := I;
      inherited Exec;
      if Proc.FExit then Exit;
      if Proc.FBreak then
      begin
        Proc.FBreak := False;
        if Proc.FContinue then
        begin
          Proc.FContinue := False;
          Continue;
        end
        else Break;
      end;
    end;
  end
  else
  begin
    for I := Assign.Value to ToVal do
    begin
      Assign.Left.Value := I;
      inherited Exec;
      if Proc.FExit then Exit;

      if Proc.FBreak then
      begin
        Proc.FBreak := False;
        if Proc.FContinue then
        begin
          Proc.FContinue := False;
          Continue;
        end
        else Break;
      end;
    end;
  end;

end;

{TBreakInstruction}

procedure TBreakInstruction.Exec;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  Proc.FBreak := True;
end;

{TContinueInstruction}

procedure TContinueInstruction.Exec;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  Proc.FBreak := True;
  Proc.FContinue := True;
end;

{TExitInstruction}

procedure TExitInstruction.Exec;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  Proc.FExit := True;
end;

{TWithInstruction}

constructor TWithInstruction.Create(AProc: TDpCustomProc; ACol, ARow: Integer);
begin
  inherited Create(AProc, ACol, ARow);
  WithList := TList.Create;
end;

destructor TWithInstruction.Destroy;
begin
  WithList.Free;
  inherited Destroy;
end;

{TCaseCode}

constructor TCaseCode.Create(AProc: TDpCustomProc; ACol, ARow: Integer);
begin
  inherited Create(AProc, ACol, ARow);
  FValues := TList.Create;
end;

destructor TCaseCode.Destroy;
begin
  while FValues.Count > 0 do
  begin
    Dispose(PVariant(FValues.Items[0]));
    FValues.Delete(0);
  end;
  inherited Destroy;
end;

procedure TCaseCode.AddValue(V: Variant);
var
  P: PVariant;
begin
  New(P);
  P^ := V;
  FValues.Add(P);
end;

function TCaseCode.IsEqual(V: Variant): Boolean;
var
  I: Integer;
begin
  Result := False;
  I := 0;
  while I < FValues.Count do
  begin
    if PVariant(FValues.Items[I])^ = V then
    begin
      Result := TRue;
      Break;
    end;
    Inc(I);
  end;
end;

{TCaseInstruction}

constructor TCaseInstruction.Create(AProc: TDpCustomProc; ACol, ARow: Integer);
begin
  inherited Create(AProc, ACol, ARow);
   FElseCode := TDpCode.Create(AProc, ACol, ARow);
   FElseCode.ParentCode := Self;
end;

{destructor TCaseInstruction.Destroy;
begin
  if FCaseValue.IdentType = itValue then FCaseValue.Free;
  inherited Destroy;
end;}

procedure TCaseInstruction.Exec;
var
  CaseVal: Variant;
  I: Integer;
  B: Boolean;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);
  CaseVal := FCaseValue.Value;
  I := 0;
  B := True;
  while I < Count do
  begin
    if TCaseCode(Items[I]).IsEqual(CaseVal) then
    begin
      B := False;
      TCaseCode(Items[I]).Exec;
      Break;
    end;
    Inc(I);
  end;
  if B then ElseCode.Exec;
end;

{TAssignInstruction}

procedure TAssignInstruction.Exec;
begin
  if FCompiler.Debug then
    FCompiler.FOnExecuteInstruction(FDebugInfo.DeclUnit, FDebugInfo.Col, FDebugInfo.Row);

  Left.Value := Right.Value;
end;

{TDpCompiler}

constructor TDpCompiler.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  DefaultAnsiFunciton := af1251;
  DefaultDosFunction := df866;

  FSuLanguage := slPascal;
  Debug := False;
  FMsgList := TObjectList.Create;
  UseTranscription := False;
  Units := TIdentTable.Create;
  ExternalObject := TIdentTable.Create;

  FTypeTable := TTypeTable.Create(Self);
  FTypeTable.FCompiler := Self;
  FCompClasses := TList.Create;
  //FMetCont := TMethods.Create;
  ObjectsDump := TObjectList.Create;
  FImportList := TObjectList.Create;
  FObjectData := TList.Create;

  EventHandlerRegList := TObjectList.Create;
end;

destructor TDpCompiler.Destroy;
begin
  Reset;
  //ObjectDataClear;
  FObjectData.Free;
  FMsgList.Free;
  Units.Free;
  FTypeTable.Free;
  ExternalObject.Free;
  //FMetCont.Free;
  FCompClasses.Free;
  ObjectsDump.Free;
  FImportList.Free;
  EventHandlerRegList.Free;
  Tokens.Free;
  inherited Destroy;
end;

procedure TDpCompiler.Reset;
begin
  ObjectDataClear;
  FCompiled := False;
  Units.Clear;
  ExternalObject.Clear;
  FTypeTable.Clear;
  FMsgList.Clear;
  ObjectsDump.Clear;
  FErrors := False;
  FMainProc := nil;
  FImportList.Clear;
  WithIO := nil;
  TotalRow := 0;
end;

procedure TDpCompiler.WriteMessage(AModuleName: TDpString; AMessage: TDpString);
var
  Msg: TDpCompilerMessage;
  S: TDpString;
  ACol, ARow: Integer;
begin
  if Assigned(FOnCompilerMessage) then
  begin
    ACol :=0; ARow := 0;
    if Tokens <> nil then
    begin
      ACol := Tokens.Token.Col;
      ARow := Tokens.Token.Row;
    end;

    Msg := TDpCompilerMessage.Create(ACol + 1, ARow + 1, AModuleName, 0, AMessage, dsmMsg, FSuLanguage);
    FMsgList.Add(Msg);

    S := '';
    if AModuleName <> '' then S := S + AModuleName + ': ';
    S := S + AMessage;
    FOnCompilerMessage(S);
  end;
end;

procedure TDpCompiler.ShowMsg(S: TDpString);
begin
  if Assigned(FOnCompilerMessage) then FOnCompilerMessage(S);
end;

function TDpCompiler.Add_TypeInfo(P: PTypeInfo; WithName: string = ''): TDpType;
var
  L: Integer;
  IO: TIdentObject;
  S: string;
begin
  Result := nil;
  with GetTypeData(P)^ do
  begin
    case P^.Kind of
      tkSet:
      begin
        S := P^.Name;
        if WithName <> '' then S := WithName;
        Result  := FTypeTable.Add(S, btSet, nil, nil, P);
        with GetTypeData(GetTypeData(P)^.CompType)^ do
        begin
          Result.MinVal := MinValue;
          Result.MaxVal := MaxValue;
        end;
      end;

      tkEnumeration:
      begin
        S := P^.Name;
        if WithName <> '' then S := WithName;;
        Result := FTypeTable.Add(S, btEnum, nil, nil, P);
        Result.FMinVal := MinValue;
        Result.FMaxVal := MaxValue;
        for L := MinValue to MaxValue do
        begin
          IO := TIdentObject.Create(Self);
          S := GetEnumName(P, L);
          IO.Name := S;
          IO.FValue := L;
          IO.ValueType := Result;
          IO.IdentType := itConst;
          ExternalObject.Add(IO);
          Result.FAtributes.Add(IO);
        end;
      end;

      tkInterface:
      begin
        S := P^.Name;
        if WithName <> '' then S := WithName;;
        Result := FTypeTable.Add(S, btIntf, nil, nil, P);
      end;

      tkMethod:
      begin
        S := P^.Name;
        if WithName <> '' then S := WithName;
        Result := FTypeTable.Add(S, btEvent, nil, nil, P);
      end;

      tkArray:
      begin
        S := P^.Name;
        if WithName <> '' then S := WithName;
        Result := FTypeTable.Add(S, btArray, nil, nil, P);
      end;

      tkInteger:
      begin
        S := P^.Name;
        if WithName <> '' then S := WithName;
        Result := Add_SimpleType(S, btInt);
        Result.ATypeInfo := P;
      end;

    end;

  end;

end;

function TDpCompiler.Add_Class(AClass: TClass; AlterName: TDpString): TDpType;
var
  PST: TDpType;
  AClassParent: TClass;
  P: PTypeInfo;
  AltType: TDpType;
begin
  Result := FTypeTable.Find(AClass.ClassName, 0);

  if Result = nil then
  begin
    PST := nil;
    AClassParent := AClass.ClassParent;
    if AClassParent <> nil then
    begin
      PST := FTypeTable.Find(AClassParent.ClassName, 0);
      if PST = nil then
         PST := Add_Class(AClassParent);
    end;
    P := AClass.ClassInfo;
    Result := FTypeTable.Add(AClass.ClassName, btClass, AClass, PST, P);
  end;

  if AlterName <> '' then
  begin
    AltType := FTypeTable.Find(AlterName, 0);
    if AltType = nil then
    begin
      PST := nil;
      AClassParent := AClass.ClassParent;
      if AClassParent <> nil then
      begin
        PST := FTypeTable.Find(AClassParent.ClassName, 0);
        if PST = nil then
           PST := Add_Class(AClassParent);
      end;
      P := AClass.ClassInfo;
      FTypeTable.Add(AlterName, btClass, AClass, PST, P);
    end;
  end;
end;

function TDpCompiler.Add_Record(RecTypeName: TDpString; ASize: Integer): TDpType;
begin
  Result := FTypeTable.Add(RecTypeName, btRecord, nil, nil, nil);
  Result.Size := ASize;
end;

function TDpCompiler.Add_SimpleType(AName: TDpString; ABaseType: TsuBaseType): TDpType;
begin
  Result := FTypeTable.AddSimpleType(AName, ABaseType);
end;

function TDpCompiler.AddTypes: Boolean;
begin
  Add_SimpleType('Byte', btInt);
  Add_SimpleType('SmallInt', btInt);
  IntegerType := Add_SimpleType('Integer', btInt);
  Int64Type := Add_SimpleType('Int64', btInt);
  Add_SimpleType('Word', btInt);
  Add_SimpleType('DWord', btInt);
  Add_SimpleType('QWORD', btInt);
  Add_SimpleType('ShortInt', btInt);
  Add_SimpleType('LongInt', btInt);
  BooleanType := Add_SimpleType('Boolean', btBool);
  Add_SimpleType('WordBool', btBool);
  Add_SimpleType('Double', btFloat);
  ExtendedType := Add_SimpleType('Extended', btFloat);
  Add_SimpleType('Char', btChar);
  Add_SimpleType('AnsiChar', btChar);
  Add_SimpleType('TUTF8Char', btString);
  Add_SimpleType('String', btString);
  Add_SimpleType('AnsiString', btString);
  Add_SimpleType('WideString', btString);
  Add_SimpleType('UnicodeString', btString);
  Add_SimpleType('TTranslateString', btString);
  DefaultType := Add_SimpleType('Variant', btVariant);
  Add_SimpleType('Pointer', btPointer);
  ArrayType := Add_SimpleType('Array', btArray);
  Add_SimpleType('Set', btSet);
  Add_SimpleType('TCaption', btString);
  Add_SimpleType('TImageIndex', btInt);
  Add_SimpleType('TComponentName', btString);
  DispType := Add_SimpleType('IDispatch', btDisp);
  Add_SimpleType('TTabOrder', btInt);
  Add_SimpleType('TBorderWidth', btInt);
  Add_SimpleType('TDateTime', btFloat);
  Add_SimpleType('TDate', btFloat);
  Add_SimpleType('TTime', btFloat);
  Add_SimpleType('Single', btFloat);
  Add_SimpleType('Largeint', btInt);
  Add_SimpleType('Cardinal', btInt);
  Add_SimpleType('Currency', btFloat);
  Add_SimpleType('HWND', btInt);
  Add_SimpleType('TFileName', btString);
  Add_SimpleType('OleVariant', btVariant);
  Add_SimpleType('TColor', btInt);
  Add_SimpleType('TCursor', btInt);
  Add_SimpleType('THandle', btInt);
  Add_SimpleType('LongWord', btInt);
  Add_SimpleType('TVarType', btInt);
  Add_SimpleType('Ordinal', btOrdinal);

  Add_SimpleType('Байт', btInt);
  Add_SimpleType('МалоеЦелое', btInt);
  Add_SimpleType('Целое', btInt);
  Add_SimpleType('Целое64', btInt);
  Add_SimpleType('Слово', btInt);
  Add_SimpleType('ДСлово', btInt);
  Add_SimpleType('ЧСлово', btInt);
  Add_SimpleType('ДлинноеЦелое', btInt);
  Add_SimpleType('Логическое', btBool);
  Add_SimpleType('Двойное', btFloat);
  ExtendedType := Add_SimpleType('Расширенное', btFloat);
  Add_SimpleType('Символ', btChar);
  Add_SimpleType('Строка', btString);
  Add_SimpleType('Указатель', btPointer);
  Add_SimpleType('Множество', btSet);
  Add_SimpleType('ТДатаВремя', btFloat);
  Add_SimpleType('ТДата', btFloat);
  Add_SimpleType('ТВремя', btFloat);
  Add_SimpleType('БольшоеЦелое', btInt);
  Add_SimpleType('Кардинал', btInt);
  Add_SimpleType('Валюта', btFloat);
  Add_SimpleType('Вариант', btVariant);


  if Assigned(FOnAddSimpleType) then FOnAddSimpleType(@Add_SimpleType);
  {TClasses}
  AddClassImport(TRecordsImport);
  AddClassImport(TGraphicsImport);
  AddClassImport(TClassesImporter);
  AddClassImport(TStdImport);
  AddClassImport(TAdditionalImport);
  AddClassImport(TCommonImport);
  AddClassImport(TFormsImport);
  AddClassImport(TDataImport);
  AddClassImport(TDCImport);
  AddClassImport(TDialogImport);
  AddClassImport(TDataAccImport);
  if Assigned(FOnAddClassImpoerter) then FOnAddClassImpoerter(@AddClassImport);


  if Assigned(FOnAddTypeInfo) then FOnAddTypeInfo(@Add_TypeInfo);
  if Assigned(FOnAddClass) then FOnAddClass(@Add_Class);

  Result := not FErrors;
end;

function TDpCompiler.AddTypeProp: Boolean;
var
  I: Integer;
  S: TDpString;
begin
  //Result := True;
  for I := 0 to FTypeTable.Count - 1 do
  begin
    if FTypeTable.Items[I].ClassImporter <> nil then
    begin
      FTypeTable.Items[I].ClassImporter.RegisterPublic(FTypeTable.Items[I]);
    end;
    AddClassPublic(FTypeTable.Items[I]);
    if FErrors then
    begin
      S := FTypeTable.Items[I].ClassImporter.ClassName;
      WriteError(S, ceCustomError, 'Ошибка при импорте типов');
      Break;
    end;
  end;
  Result := not FErrors;
end;

function TDpCompiler.AddClassPublic(AType: TDpType): Boolean;
begin
  if Assigned(FOnAddTypeProp) then FOnAddTypeProp(AType);
  Result := not FErrors;
end;

function TDpCompiler.AddConsts: Boolean;
begin
  {ShiftState}
  Add_Const('ssShift', 'Integer', 0);
  Add_Const('ssAlt', 'Integer', 1);
  Add_Const('ssCtrl', 'Integer', 2);
  Add_Const('ssLeft', 'Integer', 3);
  Add_Const('ssRight', 'Integer', 4);
  Add_Const('ssMiddle', 'Integer', 5);
  Add_Const('ssDouble', 'Integer', 6);
  Add_Const('ssTouch', 'Integer', 7);
  Add_Const('ssPen', 'Integer', 8);

  {ModalResult}
  Add_Const('mrNone', 'Integer', mrNone);
  Add_Const('mrOk', 'Integer', mrOk);
  Add_Const('mrCancel', 'Integer', mrCancel);
  Add_Const('mrAbort', 'Integer', mrAbort);
  Add_Const('mrRetry', 'Integer', mrRetry);
  Add_Const('mrIgnore', 'Integer', mrIgnore);
  Add_Const('mrYes', 'Integer', mrYes);
  Add_Const('mrNo', 'Integer', mrNo);
  Add_Const('mrAll', 'Integer', mrAll);
  Add_Const('mrNoToAll', 'Integer', mrNoToAll);
  Add_Const('mrYesToAll', 'Integer', mrYesToAll);
  {Cursors}
  Add_Const('crDefault', 'Integer', crDefault);
  Add_Const('crNone', 'Integer', crNone);
  Add_Const('crArrow', 'Integer', crArrow);
  Add_Const('crCross', 'Integer', crCross);
  Add_Const('crIBeam', 'Integer', crIBeam);
  Add_Const('crSize', 'Integer', crSize);
  Add_Const('crSizeNESW', 'Integer', crSizeNESW);
  Add_Const('crSizeNS', 'Integer', crSizeNS);
  Add_Const('crSizeNWSE', 'Integer', crSizeNWSE);
  Add_Const('crSizeWE', 'Integer', crSizeWE);
  Add_Const('crUpArrow', 'Integer', crUpArrow);
  Add_Const('crHourGlass', 'Integer', crHourGlass);
  Add_Const('crDrag', 'Integer', crDrag);
  Add_Const('crNoDrop', 'Integer', crNoDrop);
  Add_Const('crHSplit', 'Integer', crHSplit);
  Add_Const('crVSplit', 'Integer', crVSplit);
  Add_Const('crMultiDrag', 'Integer', crMultiDrag);
  Add_Const('crSQLWait', 'Integer', crSQLWait);
  Add_Const('crNo', 'Integer', crNo);
  Add_Const('crAppStart', 'Integer', crAppStart);
  Add_Const('crHelp', 'Integer', crHelp);
  Add_Const('crHandPoint', 'Integer', crHandPoint);
  Add_Const('crSizeAll', 'Integer', crSizeAll);
  {FileMode}
  Add_Const('fmCreate', 'Integer', fmCreate);
  Add_Const('fmOpenRead', 'Integer', fmOpenRead);
  Add_Const('fmOpenWrite', 'Integer', fmOpenWrite);
  Add_Const('fmOpenReadWrite', 'Integer', fmOpenReadWrite);

  Add_Const('фмСоздать', 'Целое', fmCreate);
  Add_Const('фмОткрытьДляЧтения', 'Целое', fmOpenRead);
  Add_Const('фмОткрытьДляЗаписи', 'Целое', fmOpenWrite);
  Add_Const('фмОткрытьДляЧтенияЗаписи', 'Целое', fmOpenReadWrite);

  Add_Const('fmShareExclusive', 'Integer', fmShareExclusive);
  Add_Const('fmShareDenyWrite', 'Integer', fmShareDenyWrite);
  Add_Const('fmShareDenyNone', 'Integer', fmShareDenyNone);
  Add_Const('fmClosed', 'Integer', fmClosed);
  Add_Const('fmInput', 'Integer', fmInput);
  Add_Const('fmOutput', 'Integer', fmOutput);
  Add_Const('fmInOut', 'Integer', fmInOut);
  {Pi}
  Add_Const('Pi', 'extended', Pi);
  {varType const}
  Add_Const('varEmpty', 'Integer', varEmpty);
  Add_Const('varNull', 'Integer', varNull);
  Add_Const('varSmallint', 'Integer', varSmallint);
  Add_Const('varInteger', 'Integer', varInteger);
  Add_Const('varSingle', 'Integer', varSingle);
  Add_Const('varDouble', 'Integer', varDouble);
  Add_Const('varCurrency', 'Integer', varCurrency);
  Add_Const('varDate', 'Integer', varDate);
  Add_Const('varOleStr', 'Integer', varOleStr);
  Add_Const('varDispatch', 'Integer', varDispatch);
  Add_Const('varError', 'Integer', varError);
  Add_Const('varBoolean', 'Integer', varBoolean);
  Add_Const('varVariant', 'Integer', varVariant);
  Add_Const('varUnknown', 'Integer', varUnknown);
  Add_Const('varShortInt', 'Integer', varShortInt);
  Add_Const('varByte', 'Integer', varByte);
  Add_Const('varWord', 'Integer', varWord);
  Add_Const('varLongWord', 'Integer', varLongWord);
  Add_Const('varInt64', 'Integer', varInt64);
  Add_Const('varStrArg', 'Integer', varStrArg);
  Add_Const('varString', 'Integer', varString);
  Add_Const('varAny', 'Integer', varAny);
  Add_Const('varTypeMask', 'Integer', varTypeMask);
  Add_Const('varArray', 'Integer', varArray);
  Add_Const('varByRef', 'Integer', varByRef);
  Add_Const('varQWord', 'Integer', varqword);
  Add_Const('DirectorySeparator', 'string', DirectorySeparator);
  Add_Const('PathSeparator', 'string', PathSeparator);
  Add_Const('PathSep', 'string', PathSeparator);
  Add_Const('PathDelim', 'string', PathDelim);
  Add_Const('EOL', 'string', LineEnding);

  GetColorValues(@AddColorValues);

  if Assigned(FOnAddConst) then FOnAddConst(@Add_Const);
  Result := not FErrors;
end;

function TDpCompiler.AddVars: Boolean;
begin
  Add_SysVar('DecimalSeparator', 'Char', @DecimalSeparator_Get, @DecimalSeparator_Set);
  Result := not FErrors;
end;

function TDpCompiler.AddMethods: Boolean;
var
  I: Integer;
begin

  for I := 0 to MethodDefList.Count - 1 do
  begin
    TMethodsDef(MethodDefList.Items[I]).AddMethod(@Add_Method);
  end;

  if Assigned(FOnAddMethod) then FOnAddMethod(@Add_Method);
  Result := not FErrors;

end;

procedure TDpCompiler.Add_Object(ObjName: TDpString; AObject: TObject);
var
  OO: TIdentObject;
  AType: TDpType;
begin
  if IsIdentDeclared(ObjName, 0, MainProc) then
  begin
    FErrors := True;
    ShowMsg('[Ошибка] Добавление объекта с именем ' + ObjName + '. Идентификатор с таким именем уже существует');
  end
  else
  begin
    OO := TIdentObject.Create(Self);
    OO.Name := ObjName;
    AType := FindType(AObject.ClassName, MainProc, False);
    if AType = nil then Add_Class(AObject.ClassType);
    AType := FindType(AObject.ClassName, MainProc, True);
    if AType = nil then
    begin
      AType := DefaultType;
      WriteError('Add External Object', ceUnknownType, AObject.ClassName);
    end;
    OO.ValueType := AType;
    OO.IdentType := itVar;
    OO.Value := PtrInt(AObject);
    ExternalObject.Add(OO);
  end;
end;

procedure TDpCompiler.Add_Const(ConstName, ATypeName: TDpString; AValue: Variant);
var
  IO: TIdentObject;
begin
  if IsIdentDeclared(ConstName, 0, MainProc) then
  begin
    WriteError('External AddConst', ceIdentifierRedeclared, ConstName);
    Exit;
  end;
  IO := TIdentObject.Create(Self);
  IO.Name := ConstName;
  IO.ValueType := FindType(ATypeName, MainProc, True);
  IO.Value := AValue;
  IO.IdentType := itConst;
  ExternalObject.Add(IO);
end;

procedure TDpCompiler.Add_Var(VarName, ATypeName: TDpString);
var
  IO: TIdentObject;
begin
  if IsIdentDeclared(VarName, 0, MainProc) then
  begin
    WriteError('External AddVar', ceIdentifierRedeclared, VarName);
    Exit;
  end;
  IO := TIdentObject.Create(Self);
  IO.Name := VarName;
  IO.ValueType := FindType(ATypeName, MainProc, True);
  IO.IdentType := itVar;
  ExternalObject.Add(IO);
end;

procedure TDpCompiler.Add_SysVar(VarName, ATypeName: TDpString;
  GetVarProc: TGetVarMethod; SetVarProc: TSetVarMethod);
var
  IO: TSysVarObject;
begin
  if IsIdentDeclared(VarName, 0, MainProc) then
  begin
    WriteError('External AddVar', ceIdentifierRedeclared, VarName);
    Exit;
  end;
  IO := TSysVarObject.Create(Self);
  IO.Name := VarName;
  IO.ValueType := FindType(ATypeName, MainProc, True);
  IO.IdentType := itVar;
  IO.OnGetVarValue := GetVarProc;
  if Assigned(SetVarProc) then
    IO.OnSetVarValue := SetVarProc
  else IO.OnlyRead := True;

  ExternalObject.Add(IO);
end;

procedure TDpCompiler.Add_Method(MethodDecl: TDpString; CallProc: TCallDelphiMethod);
var
  Proc: TSuProc;
begin
  Proc := ParseMethod(MethodDecl, CallProc);
  if Proc <> nil then
  begin
    Proc.FImpl := True;
    if IsIdentDeclared(Proc.Name, Proc.HashValue, MainProc) then
    begin
      ShowMsg(Proc.DeclUnit + ' Идентификатор с таким имененем уже существует');
      FErrors := True;
    end;
    ExternalObject.Add(Proc);
  end;
end;

function TDpCompiler.ParseMethod(MethodDecl: TDpString; CallProc: TCallDelphiMethod): TSuProc;
var
  Pars: TDpParser;
  SaveTokens: TTokensList;
  Param: TIdentObject;
  IsFunc: Boolean;
  IsConstr: Boolean;
  ExtProc: TExternalMethod;
  T_ID: TIdentToken;
begin
  Result := nil;
  SaveTokens := Tokens;
  Pars := TDpParser.Create(UseTranscription, FSuLanguage);
  Pars.SetParseStr(MethodDecl);
  Tokens := Pars.GetTokensList;
  try
    IsFunc := False;
    IsConstr := False;
    while Tokens.Token.TokenID <> ID_EOF do
    begin
      T_ID:= Tokens.Token.TokenID;
      //if Tokens.Token.TokenID in [ID_procedure, ID_function, ID_constructor, ID_Destructor] then
      if T_ID in [ID_procedure, ID_function, ID_constructor, ID_Destructor] then
      begin
        if Tokens.Token.TokenID = ID_constructor then IsConstr := True
        else
        if Tokens.Token.TokenID = ID_function then IsFunc := True;
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Identifier then
        begin
          ExtProc := TExternalMethod.Create(Self);
          ExtProc.FIsConstructor := IsConstr;
          ExtProc.IdentType := itProc;
          ExtProc.FIsFunction := IsFunc;
          ExtProc.Name := Tokens.Token.TokenName;
          ExtProc.OnCallMethod := CallProc;
          ExtProc.DeclUnit := 'External method ' + Tokens.Token.TokenName;
          ExtProc.FValueType := DefaultType;
          Result := ExtProc;
          Tokens.Next;
          if DoProcParam(ExtProc) then
          begin
            if IsFunc then
            begin
              if Tokens.Token.TokenID = ID_Colon then
              begin
                Tokens.Next;
                if Tokens.Token.TokenID = ID_Identifier then
                begin
                  Param := TIdentObject.Create(Self);
                  Param.Name := 'Result';
                  Param.FValueType := FindType(Tokens.Token.TokenName, nil, True);
                  ExtProc.AddVar(Param, 0, 0);
                  Param.IdentType := itParam;
                  ExtProc.ValueType := Param.ValueType;
                  ExtProc.FResultValue := Param;
                  Tokens.Next;
                end
                else
                begin
                  ShowMsg(ExtProc.DeclUnit + ' Не верно указан тип возвращаемого значения функции');
                  FErrors := True;
                end;
              end
              else
              begin
                ShowMsg(ExtProc.DeclUnit + ' Не найден тип возвращаемого значения функции');
                FErrors := True;
              end;
            end;
          end;
          if Tokens.Token.TokenID = ID_SemiColon then
          begin
            Tokens.Next;
            if Tokens.Token.TokenID = ID_overload then
            begin
              Tokens.Next;
            end;
          end;
        end
        else
        begin
          FErrors := True;
          ShowMsg('Добавление Метода ' + MethodDecl + '. Не найдено имя метода');
          Break;
        end;
      end
      else
      begin
        FErrors := True;
        ShowMsg('Добавление Метода ' + MethodDecl + '. Ожидается function или procedure');
        Break;
      end;
      Tokens.Next;
    end;
  finally
    Tokens.Free;
    Tokens := SaveTokens;
    Pars.Free;
    //SynList.Free;

  end;
end;

function TDpCompiler.DoProcParam(Proc: TSuProc): Boolean;
var
   AsAdres: Boolean;
   AsConst: Boolean;
   Status: Integer;
   SList, Bounds: TStringList;
   PP: TIdentObject;
   AType: TDpType;
   I, N: Integer;
   IniValue: Variant;
   Init: Boolean;
   ClassVar: TIdentClass;
   T: TIdentToken;
   Ar: TArrayObject;
   AI: Array of PtrInt;
   AVarType: Word;
begin
  Result := True;
  if Tokens.Token.TokenID <> ID_OpenRound then Exit;
  Tokens.Next;
  if Tokens.Token.TokenID = ID_CloseRound then Exit;
  Status := 0;
  SList := TStringList.Create;
  try
    AsAdres := False;
    AsConst := False;
    Init := False;
    while Tokens.Token.TokenID <> ID_EOF do
    begin

      case Status of
        0:
        begin
          //Проверяем как передается параетр
          if Tokens.Token.TokenID in [ID_var, ID_out] then
          begin
              AsAdres := True;
              Tokens.Next;
          end
          else
          if Tokens.Token.TokenID = ID_const then
          begin
              AsConst := True;
              Tokens.Next;
          end;

          Status := 1;
          Continue;
        end;

        1:
        begin
          //Ожидается имя переменной или )
          if Tokens.Token.TokenID = ID_Identifier then
          begin
            SList.Add(Tokens.Token.TokenName);
            Status := 2;
          end
          else
          begin
            Result := False;
            WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
            Break;
          end;
        end;

        2:
        begin
          //Ожидается , или :
          if Tokens.Token.TokenID = ID_Comma then Status := 1
          else
          if Tokens.Token.TokenID = ID_Colon then Status := 3
          else
          begin
            Result := False;
            WriteError(Proc.DeclUnit, ceColonExpected, '');
            Break;
          end;
        end;

        3:
        begin
          //Ожидается тип параметра
          if Tokens.Token.TokenID = ID_array then
          begin
            I := 0;
            Bounds := TStringList.Create;
            try
              Result := DoArray(Proc, Bounds, AType);
              Tokens.Prev;
              if Result then
              begin
                while I < SList.Count do
                begin
                    Ar := TArrayObject.Create(Self);
                    Ar.Name := SList.Strings[I];
                    Ar.DimCount := Bounds.Count div 2;
                    Ar.FDataType := AType;
                    Ar.FValueType := ArrayType;
                    Ar.FDinArray := False;
                    AVarType := GetVarTypeOfType(AType.BaseType);
                    if Ar.DimCount = 0 then
                    begin
                      Ar.FDinArray := True;
                      if AVarType = varString then AVarType := varOleStr;
                      Ar.FValue := VarArrayCreate([0, 0], AVarType);
                    end
                    else
                    begin
                      SetLength(AI, Bounds.Count);
                      for N := 0 to Bounds.Count - 1 do
                        AI[N] := StrToInt(Bounds.Strings[N]);
                      Ar.FValue := VarArrayCreate(AI, AVarType);
                      SetLength(AI, 0);
                    end;
                    Ar.AsPointer := AsAdres;
                    Ar.FOnlyRead := AsConst;
                    Proc.AddParam(Ar);
                    Inc(I);
                end;
                SList.Clear;
              end;
            finally
              Bounds.Free;
              AsAdres := False;
              AsConst := False;
              Status := 4;
            end;
          end
          else
          if Tokens.Token.TokenID = ID_Identifier then
          begin
            I := 0;
            AType := FindType(Tokens.Token.TokenName, Proc, True);
            IniValue := Unassigned;
            Init := False;
            T := Tokens.PreviewNext.TokenID;
            if (SuLanguage = slPascal) and (T = ID_Equal) then T := ID_Assignment;
            if T = ID_Assignment then
            begin
              Tokens.Next;
              Tokens.Next;
              PP := DoExpression(Proc, False);
              Tokens.Prev;
              if PP <> nil then
              begin
                if not IsCompatibleTypes(PP.ValueType, AType, ID_Assignment) then
                begin
                  WriteError(Proc.DeclUnit, ceTypeMismatch, AType.OriginalName + ', ' + PP.ValueType.FOriginalName);
                end;
                IniValue := PP.Value;
                Init := True;
              end;
            end;

            while I < SList.Count do
            begin
              ClassVar := GetIdentClass(AType);
              PP := ClassVar.Create(Self);
              if AsAdres then PP.AsPointer := True;
              if AsConst then PP.FOnlyRead := True;
              PP.Name := TDpString(SList.Strings[I]);
              PP.ValueType := AType;
              PP.FIniValue := IniValue;
              PP.FInitObj := Init;
              //if PP.FValueType = nil then WriteError(Proc.DeclUnit, ceUnknownType, '');
              Proc.AddParam(PP);
              if PP.ValueType.BaseType = btPointerProc then
                PP.IdentType := itProc;
              Inc(I);
            end;
            SList.Clear;
            AsAdres := False;
            AsConst := False;
            Status := 4;
          end
          else
          begin
            Result := False;
            WriteError(Proc.DeclUnit, ceTypeExpected, '');
            Break;
          end;
        end;

        4:
        begin
          if Tokens.Token.TokenID = ID_CloseRound then
          begin
            Tokens.Next;
            Break;
          end
          else
          if Tokens.Token.TokenID = ID_SemiColon then Status := 0;
        end;
      end;

      Tokens.Next;
    end;
  finally
    SList.Free;
  end;

end;

function TDpCompiler.DoArray(Proc: TSuProc; List: TStringList; var AValueType: TDpType): Boolean;
var
  Status: Integer;
begin
  Tokens.Next;
  Result := True;
  if Tokens.Token.TokenID = ID_OpenBlock then
  begin
    Status := 0;
    Tokens.Next;
    if Tokens.Token.TokenID = ID_CloseBlock then Tokens.Next
    else
    begin
      while True do
      begin
        case Status of
          0: //Ожидается нижняя граница массив
          begin
            if Tokens.Token.TokenID = ID_Integer then
            begin
              List.Add(Tokens.Token.TokenName);
              Tokens.Next;
              if Tokens.Token.TokenID = ID_Dots then
              begin
                Tokens.Next;
                if Tokens.Token.TokenID = ID_Integer then
                begin
                  List.Add(Tokens.Token.TokenName);
                  Status := 1;
                end
                else
                begin
                  WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается ''Целое'' число');
                  Break;
                end;
              end
              else
              begin
                WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается ''..''');
                Break;
              end;
            end
            else
            begin
              WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается ''Целое'' число');
              Break;
            end;

          end;

          1: //Ожидается ] или ,
          begin
            if Tokens.Token.TokenID = ID_Comma then Status := 0
            else
            if Tokens.Token.TokenID = ID_CloseBlock then
            begin
              Tokens.Next;
              Break;
            end
            else
            begin
              WriteError(Proc.DeclUnit, ceCloseBlockExpected, '');
              Break;
            end;
          end;
        end;
        Tokens.Next;
      end;

    end;
  end;

  if Tokens.Token.TokenID = ID_of then
  begin
    Tokens.Next;
    if Tokens.Token.TokenID = ID_const then
    begin
      AValueType := DefaultType;
      Tokens.Next;
    end
    else
    if Tokens.Token.TokenID = ID_Identifier then
    begin
      AValueType := FindType(Tokens.Token.TokenName, Proc, True);
      Tokens.Next;
    end
    else
    begin
      AValueType := DefaultType;
      Result := False;
      WriteError(Proc.DeclUnit, ceTypeExpected, '');
    end;
  end
  else
  begin
    AValueType := DefaultType;
    //WriteError(Proc.DeclUnit, ceOfExpected, '');
  end;
end;

function TDpCompiler.GetVarTypeOfType(ABaseType: TsuBaseType): Word;
begin
  Result := varVariant;
  case ABaseType of
    btInt, btEnum: Result := varInteger;
    btBool: Result := varBoolean;
    btFloat: Result := varDouble;
    btChar, btString: Result := varolestr;
  end;
end;

function TDpCompiler.DoFactor(Proc: TSuProc; GetMethod: Boolean): TIdentObject;
var
  NegExpr: TSimpleExpression;
  AE: TAdresExpression;
  AdaptivOper: Boolean;
  IsNot: Boolean;
  AType: TDpType;
  S: string;
  Inh: Boolean;
  ValInt64: Int64;
  aMinLongInt, aMaxLongInt: LongInt;
  ValExtend: Extended;
  I: Integer;
begin
  Result := nil;
  AdaptivOper := False;
  IsNot := False;
  Inh := False;
  if Tokens.Token.TokenID = ID_inherited then
  begin
    Inh := True;
    Tokens.Next;
  end;

  if Tokens.Token.TokenID = ID_AddressOf then
  begin
    Tokens.Next;
    Result := DoFactor(Proc, TRue);
    //Result.FValueType := FindType('Pointer', Proc, True);
  end;

  if Tokens.Token.TokenID = ID_not then
  begin
    while Tokens.Token.TokenID = ID_not do
    begin
      IsNot := not IsNot;
      Tokens.Next;
    end;

    Result := DoFactor(Proc, GetMethod);

    if IsNot then
    begin
      if Result.ValueType.BaseType = btInt then
      begin
        NegExpr := TBitwiseNotExpression.Create(Self);
        NegExpr.FVal := Result;
        NegExpr.ValueType := Result.ValueType;
        Result := NegExpr;
      end
      else
      if Result.ValueType.BaseType = btBool then
      begin
        NegExpr := TBoolNotExpression.Create(Self);
        NegExpr.FVal := Result;
        NegExpr.ValueType := Result.ValueType;
        Result := NegExpr;
      end
      else
      begin
        WriteError(Proc.DeclUnit, ceOperatorNoAcceptOperandTip, '');
      end;
    end;
  end
  else
  if Tokens.Token.TokenID in [ID_Plus, ID_Minus] then
  begin
    while Tokens.Token.TokenID in [ID_Plus, ID_Minus] do
    begin
      if Tokens.Token.TokenID = ID_Minus then AdaptivOper := not AdaptivOper;
      Tokens.Next;
    end;
    Result := DoFactor(Proc, GetMethod);
    if AdaptivOper then
    begin
      NegExpr := TAdaptiveMinusExpression.Create(Self);
      NegExpr.FVal := Result;
      NegExpr.ValueType := Result.ValueType;
      Result := NegExpr;
      if not (Result.ValueType.BaseType in [btInt, btFloat, btVariant]) then
        WriteError(Proc.DeclUnit, ceOperatorNoAcceptOperandTip, '');
    end;
  end
  else
  case Tokens.Token.TokenID of

    ID_OpenBlock:
    begin
      Result := DoSetValue(Proc);
    end;

    ID_Identifier:
    begin
      if (WithIO <> nil) and (WithIO.ValueType.BaseType in [btClass, btRecord]) then
      begin
        if WithIO.ValueType.BaseType = btClass then
        begin
          Result := WithIO.ValueType.FindClassObject(Tokens.Token.TokenName, Inh);
          if Result = nil then
          begin
            if GetPropInfo(WithIO.ValueType.ValueClassType, Tokens.Token.TokenName) <> nil then
              Result := WithIO;
          end;

          if Result <> nil then
          begin
            Tokens.Prev;
            Result := DoClassProperty(WithIO, WithIO.ValueType, Proc, GetMethod);
            Tokens.Prev;
          end;
        end
        else
        if WithIO.ValueType.BaseType = btRecord then
        begin
          Result := WithIO.ValueType.FindClassObject(Tokens.Token.TokenName, False);
          if Result <> nil then
          begin
            Result := DoRecField(Result, Proc);
            Tokens.Prev;
          end;
        end;
      end;

      if Result = nil then
        Result := GetIdent(Tokens.Token.TokenName, Tokens.Token.HashValue, Proc);


      if Result <> nil then
      begin
        if (Result.FIdentType = itProc) then
        begin
          if GetMethod then
          begin
            AE := TAdresExpression.Create(Self);
            AE.FValue := TSuPtr(Result);
            AE.RefObject := nil;
            Result := AE;
          end
          else
          begin
            if not TSuProc(Result).FIsFunction then
              WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается вызов функции');

            Result := DoCallMethod(Proc, TSuProc(Result), nil, inh);
            Tokens.Prev;
          end

        end;

        if Result.ValueType.BaseType in [btArray, btString, btVariant] then
        begin
          if Tokens.PreviewNext.TokenID = ID_OpenBlock then
          begin
            Tokens.Next;
            Result := DoIndexedVar(Proc, Result);
          end;
        end;

        if Tokens.PreviewNext.TokenID = ID_Period then
        begin
          if Result.ValueType.BaseType = btClass then
          begin
            Tokens.Next;
            Result := DoClassProperty(Result, Result.ValueType, Proc, GetMethod);
            Tokens.Prev;
          end
          else
          if Result.ValueType.BaseType = btDisp then
          begin
            Tokens.Next;
            Result := DoDispatch(Result, Proc);
            Tokens.Prev;
          end
          else
          if Result.ValueType.BaseType = btRecord then
          begin
            Tokens.Next;
            Result := DoRecField(Result, Proc);
            Tokens.Prev;
          end
          else
            WriteError(Proc.DeclUnit, ceSyntaxError, '');
        end;
      end
      else
      begin
        AType := FindType(Tokens.Token.TokenName, Proc, False);
        if AType <> nil then
        begin
          if Tokens.PreviewNext.TokenID = ID_Period then
          begin
            Tokens.Next;
            Tokens.Next;
            Result := DoClassProperty(nil, AType, Proc, False);
            Tokens.Prev;
          end
          else
          if Tokens.PreviewNext.TokenID = ID_OpenRound then
          begin
            Result := DoTypeCast(Proc, AType, False);
            if Tokens.Token.TokenID = ID_Period then
            begin
              if Result.ValueType.BaseType = btClass then
              begin
                //Tokens.Next;
                Result := DoClassProperty(Result, Result.ValueType, Proc, GetMethod);
              end
            end;
            Tokens.Prev;
          end
          else
            Result := DoTypeCast(Proc, AType, False)
        end
        else
        if Proc.ClassOwner <> nil then
        begin
          Tokens.Prev;
          AType := Proc.FDataObject.ValueType;
          if Inh and (AType <> nil) then AType := AType.Parent;
          Result := DoClassProperty(Proc.FDataObject, AType, Proc, GetMethod);
          if (Result.ValueType.BaseType in [btArray, btString, btVariant])
          and (Tokens.Token.TokenID = ID_OpenBlock) then
          begin
            Result := DoIndexedVar(Proc, Result);
          end
          else
            Tokens.Prev;
        end;

        if Result = nil then
        begin
          WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
          Result := TIdentObject.Create(Self);
          Result.ValueType := DefaultType;
        end;

      end;

      if (Result.ValueType.BaseType = btArray) and
        (Tokens.PreviewNext.TokenID = ID_OpenBlock) then
      begin
        Tokens.Next;
        Result := DoIndexedVar(Proc, Result);
      end;

      Tokens.Next;
    end;

    ID_Integer:
    begin
      Result := TIdentObject.Create(Self);
      Result.IdentType := itConst;
      Result.OnlyRead := True;
      Result.Name := Tokens.Token.TokenName;
      Result.ConstValue := True;
      ValInt64 := StrToInt64(Tokens.Token.TokenName);
      aMaxLongInt := maxLongint;
      aMinLongInt := -maxLongint - 1;
      if (ValInt64 > aMaxLongInt) or (ValInt64 < aMinLongInt) then
      begin
        Result.FValue := ValInt64;
        Result.FValueType := Int64Type;
      end
      else
      begin
        Result.FValue := Integer(ValInt64);
        Result.FValueType := IntegerType;
      end;

      Tokens.Next;
    end;

    ID_Char:
    begin
      Result := TIdentObject.Create(Self);
      Result.IdentType := itConst;
      Result.OnlyRead := True;
      Result.Name := Tokens.Token.TokenName;
      Result.FValue := Tokens.Token.TokenName;
      Result.FValueType := FindType('char', Proc, True);
      Result.ConstValue := True;
      Tokens.Next;
    end;

    ID_Float:
    begin
      Result := TIdentObject.Create(Self);
      Result.IdentType := itConst;
      Result.OnlyRead := True;
      Result.Name := Tokens.Token.TokenName;
      S := Tokens.Token.TokenName;
      Result.FValue := StrToFloat(S);
      Result.FValueType := ExtendedType;
      Result.ConstValue := True;
      Tokens.Next;
    end;

    ID_String:
    begin
      Result := TStringObject.Create(Self);
      Result.IdentType := itConst;
      Result.OnlyRead := True;
      Result.Name := 'StrConst';
      Result.Value := Tokens.Token.TokenName;
      Result.FValueType := FindType('String', Proc, True);
      Result.ConstValue := True;
      Tokens.Next;
      if Tokens.Token.TokenID in [ID_Char, ID_String] then
      begin
        Tokens.Next;
        S := Result.Value;
        while Tokens.Token.TokenID in [ID_Char, ID_String] do
        begin
          S := S + Tokens.Token.TokenName;
          Tokens.Next;
        end;
        Result.Value := S;
      end;


    end;

    ID_True:
    begin
      Result := TIdentObject.Create(Self);
      Result.IdentType := itConst;
      Result.OnlyRead := True;
      Result.FValue := True;
      Result.Name := 'True';
      Result.FValueType := BooleanType;
      Result.ConstValue := True;
      Tokens.Next;
    end;

    ID_False:
    begin
      Result := TIdentObject.Create(Self);
      Result.IdentType := itConst;
      Result.OnlyRead := True;
      Result.Name := 'False';
      Result.FValue := False;
      Result.FValueType := BooleanType;
      Result.ConstValue := True;
      Tokens.Next;
    end;

    ID_nil:
    begin
      Result := TIdentObject.Create(Self);
      Result.IdentType := itConst;
      Result.OnlyRead := True;
      Result.Name := 'nil';
      Result.FValue := 0;
      Result.FValueType := FindType('pointer', nil, True);
      Result.ConstValue := True;
      Tokens.Next;
    end;

    ID_OpenRound:
    begin
      Tokens.Next;
      Result := DoExpression(Proc, GetMethod);
      if Tokens.Token.TokenID = ID_CloseRound then
        Tokens.Next
      else
      begin
        Result := nil;
        WriteError(Proc.DeclUnit, ceCloseRoundExpected, '');
      end;
    end;
  end;

  if Result = nil then
  begin
    if (WithIO <> nil) and (WithIO.ValueType.BaseType = btDisp) then
      Result := DoDispatch(WithIO, Proc)
    else
    begin
      Result := TIdentObject.Create(Self);
      Result.OnlyRead := True;
      Result.FValueType := DefaultType;
      Proc.AddErrObject(Result);
    end;
  end;

end;

function TDpCompiler.DoTerm(Proc: TSuProc; GetMethod: Boolean): TIdentObject;
var
  ALeft, ARight: TIdentObject;
  Cl: TExpressionClass;
  Oper: TIdentToken;
  IO: TIdentObject;
  S: TDSSet;
begin
  Result := nil;

  ALeft := DoFactor(Proc, GetMethod);
  CL := TExpression;
  if Tokens.Token.TokenID in [ID_Multiply, ID_Divide, ID_div, ID_mod, ID_and, ID_shl, ID_shr] then
  begin
    while Tokens.Token.TokenID in [ID_Multiply, ID_Divide, ID_div, ID_mod, ID_and, ID_shl, ID_shr] do
    begin
      Oper := Tokens.Token.TokenID;
      Tokens.Next;
      ARight := DoFactor(Proc, GetMethod);

      //сворачивание констант
      if (ALeft.IdentType = itConst) and (ARight.IdentType = itConst) then
      begin
        if ALeft is TSetObject then
          IO := TSetObject.Create(Self)
        else
          IO := TIdentObject.Create(Self);
        IO.ValueType := GetValueTypeOf(Proc, ALeft.FValueType, ARight.FValueType, Oper);
        if IO.ValueType = nil then
        begin
          WriteError(Proc.DeclUnit, ceTypeMismatch,
          ALeft.FValueType.OriginalName + ', ' + ARight.FValueType.OriginalName);
          Result.ValueType := DefaultType;
        end
        else
          case Oper of
            ID_Multiply:
            begin
              if IO is TSetObject then
              begin
                S := PDSSet(TSuPtr(ALeft.Value))^ * PDSSet(TSuPtr(ARight.Value))^;
                IO.Value := TSuPtr(@S);
              end
              else
                IO.Value := ALeft.Value * ARight.Value;
            end;
            ID_Divide: IO.Value := ALeft.Value / ARight.Value;
            ID_div: IO.Value := ALeft.Value div ARight.Value;
            ID_mod: IO.Value := ALeft.Value mod ARight.Value;
            ID_and:
            begin
              if ALeft.FValueType.FBaseType = btInt then
                IO.Value := Integer(ALeft.Value) and Integer(ARight.Value)
              else
                IO.Value := Boolean(ALeft.Value) and Boolean(ARight.Value);
            end;
          end;
        IO.IdentType := itConst;
        Result := IO;
        ALeft := IO;
      end
      else
      begin

        case Oper of
          ID_Multiply:
          begin
            if ALeft is TSetObject then CL := TSetMulExpression
            else Cl := TMulExpression;
          end;
          ID_Divide: Cl := TDivExpression;
          ID_div: Cl := TDivIExpression;
          ID_mod: Cl := TModExpression;
          ID_and:
          begin
            if ALeft.FValueType.FBaseType = btInt then
              Cl := TBitwiseAndExpression
            else Cl := TLogicAndExpression
          end;
          ID_shl: Cl := TShlExpression;
          ID_shr: Cl := TShrExpression;
        end;

        Result := Cl.Create(Self);
        TExpression(Result).Left := ALeft;
        TExpression(Result).Right := ARight;
        TExpression(Result).FValueType :=
          GetValueTypeOf(Proc, ALeft.FValueType, ARight.FValueType, Oper);
        if Result.ValueType = nil then
        begin
          WriteError(Proc.DeclUnit, ceTypeMismatch,
            ALeft.FValueType.OriginalName + ', ' + ARight.FValueType.OriginalName);
          Result.ValueType := DefaultType;
        end;
        ALeft := Result;
      end;
    end;
  end
  else Result := ALeft;
end;

function TDpCompiler.DoSimpleExpression(Proc: TSuProc; GetMethod: Boolean): TIdentObject;
var
  ALeft, ARight: TIdentObject;
  Cl: TExpressionClass;
  Oper: TIdentToken;
  IO: TIdentObject;
  S: TDSSet;
begin
  Result := nil;
  ALeft := DoTerm(Proc, GetMethod);

  if Tokens.Token.TokenID in [ID_Plus, ID_Minus, ID_or, ID_xor] then
  begin
    while Tokens.Token.TokenID in [ID_Plus, ID_Minus, ID_or, ID_xor] do
    begin
      Oper := Tokens.Token.TokenID;
      Tokens.Next;
      ARight := DoTerm(Proc, GetMethod);

      {Сворачивание констант}
      if (ALeft.IdentType = itConst) and (ARight.IdentType = itConst) then
      begin
        if ALeft is TSetObject then
          IO := TSetObject.Create(Self)
        else
          IO := TIdentObject.Create(Self);
        IO.ValueType := GetValueTypeOf(Proc, ALeft.FValueType, ARight.FValueType, Oper);
        if IO.ValueType = nil then
        begin
          WriteError(Proc.DeclUnit, ceTypeMismatch,
          ALeft.FValueType.OriginalName + ', ' + ARight.FValueType.OriginalName);
          Result.ValueType := DefaultType;
        end
        else
          case Oper of
            ID_Plus:
            begin
              if IO is TSetObject then
              begin
                S := PDSSet(TSuPtr(ALeft.Value))^ + PDSSet(TSuPtr(ARight.Value))^;
                IO.Value := Integer(@S);
              end
              else
                IO.Value := ALeft.Value + ARight.Value;
            end;
            ID_Minus:
            begin
              if IO is TSetObject then
              begin
                S := PDSSet(TSuPtr(ALeft.Value))^ - PDSSet(TSuPtr(ARight.Value))^;
                IO.Value := Integer(@S);
              end
              else
                IO.Value := ALeft.Value - ARight.Value;
            end;
            ID_or:
            begin
              if ALeft.FValueType.FBaseType = btInt then
                IO.Value := Integer(ALeft.Value) or Integer(ARight.Value)
              else
                IO.Value := Boolean(ALeft.Value) or Boolean(ARight.Value);
            end;
            ID_xor:
            begin
              if ALeft.FValueType.FBaseType = btInt then
                IO.Value := Integer(ALeft.Value) xor Integer(ARight.Value)
              else
                IO.Value := Boolean(ALeft.Value) xor Boolean(ARight.Value);
            end;
          end;
        IO.IdentType := itConst;
        Result := IO;
        ALeft := IO;
      end
      else
      begin
        Cl := nil;
        case Oper of
          ID_Plus:
          begin
            if ALeft.ValueType.BaseType = btSet then CL := TSetAddExpression
            else Cl := TAddExpression;
          end;
          ID_Minus:
          begin
            if ALeft.ValueType.BaseType = btSet then CL := TSetSubExpression
            else Cl := TSubExpression;
          end;
          ID_or:
          begin
            if ALeft.ValueType.BaseType = btInt then Cl := TBitwiseOrExpression
            else Cl := TLogicOrExpression;
          end;
          ID_xor:
          begin
            if ALeft.ValueType.BaseType = btInt then Cl := TBitwiseXorExpression
            else Cl := TLogicXorExpression;
          end;
        end;
        Result := Cl.Create(Self);
        TExpression(Result).Left := ALeft;
        TExpression(Result).Right := ARight;
        Result.FValueType :=
          GetValueTypeOf(Proc, ALeft.ValueType, ARight.ValueType, Oper);
        if Result.FValueType = nil then
        begin
          WriteError(Proc.DeclUnit, ceTypeMismatch,
            ALeft.ValueType.OriginalName + ', ' + ARight.ValueType.OriginalName);
          Result.ValueType := DefaultType;
        end;
        ALeft := Result;
      end;
    end;
  end
  else Result := ALeft;
end;

function TDpCompiler.DoExpression(Proc: TSuProc; GetMethod: Boolean): TIdentObject;
var
  ALeft, ARight: TIdentObject;
  Token: TIdentToken;
  CL: TExpressionClass;
  SE: TSimpleExpression;
  AType: TDpType;
begin
  ALeft := DoSimpleExpression(Proc, GetMethod);

  Token := Tokens.Token.TokenID;
  if (Token in [ID_Equal, ID_NotEqual, ID_Greater, ID_Less,
    ID_GreaterEqual, ID_LessEqual, ID_in, ID_Is])
    or ((FSuLanguage = slPPlus) and (Token = ID_Assignment)) then
  begin
    if Token = ID_Assignment then Token := ID_Equal;

    Tokens.Next;
    ARight := DoSimpleExpression(Proc, GetMethod);
    CL := nil;
     case Token of

        ID_Equal:
        begin
          if ALeft.ValueType.FBaseType = btSet then CL := TSetEqualExpression
          else CL := TEqualExpression;
        end;

        ID_NotEqual:
        begin
          if ALeft.ValueType.BaseType = btSet then CL := TSetNotEqualExpression
          else CL := TNotEqualExpression;
        end;

        ID_Greater: CL := TGreatExpression;

        ID_Less:  CL := TLessExpression;

        ID_GreaterEqual:
        begin
          if ALeft.ValueType.BaseType = btSet then CL := TSetGreatEqualExpression
          else CL := TGreatEqualExpression;
        end;

        ID_LessEqual:
        begin
          if ALeft.ValueType.BaseType = btSet then CL := TSetLessEqualExpression
          else CL := TLessEqualExpression;
        end;

        ID_In: CL := TInExpression;

        ID_Is:
          CL := TIsExpression;

        {ID_As:
          CL := ;}
     end;
     Result := CL.Create(Self);
     TExpression(Result).Left := ALeft;
     TExpression(Result).Right := ARight;
     Result.FValueType :=
      GetValueTypeOf(Proc, ALeft.ValueType, ARight.ValueType, Token);
     if Result.ValueType = nil then
     begin
       WriteError(Proc.DeclUnit, ceTypeMismatch,
       ALeft.ValueType.OriginalName + ', ' + ARight.ValueType.OriginalName);
       Result.ValueType := BooleanType;
     end;
  end
  else
  if Token = ID_As then
  begin
    Tokens.Next;
    Token := Tokens.Token.TokenID;
    if Token = ID_Identifier then
    begin
      AType := FindType(Tokens.Token.TokenName, Proc, True);
      Tokens.Next;
      SE := TSimpleExpression.Create(Self);
      SE.ValueType := AType;
      SE.Name := AType.Name;
      SE.FVal := ALeft;
      Result := SE;
    end
    else
    begin
      WriteError(Proc.DeclUnit, ceTypeExpected, '');
      Result := ALeft;
    end;
  end
  else
    Result := ALeft;
end;

function TDpCompiler.DoSetValue(Proc: TSuProc): TIdentObject;
var
  IO, IO2: TIdentObject;
  SA: TDpString;
  C: AnsiChar;
  I, N, M: Integer;
  SI: TDSSet;
begin
  Tokens.Next;
  SI := [];
  while Tokens.Token.TokenID <> ID_CloseBlock do
  begin
    IO := DoFactor(Proc, False);
    I := 0;
    try
      if (IO.ValueType.BaseType = btInt) or (IO.ValueType.BaseType = btChar)
        or (IO.ValueType.BaseType = btEnum) then
      begin
        if IO.ValueType.BaseType = btChar then
        begin
          SA := VarToStr(IO.Value);
          C := SA[1];
          I := Ord(C);
        end
        else
          I := IO.Value;
          Include(SI, I);
      end
      else
        WriteError(Proc.DeclUnit, ceErrorTypeInSet, IO.ValueType.OriginalName);
    finally
      if IO.IdentType = itValue then IO.Free;
    end;

    case Tokens.Token.TokenID of
       ID_Comma: Tokens.Next;

       ID_Dots:
       begin
           Tokens.Next;
           IO2 := DoFactor(Proc, False);
           try
             if (IO2.ValueType.BaseType = btInt)
                or (IO2.ValueType.BaseType = btChar)
                or (IO2.ValueType.BaseType = btEnum) then
             begin
                  if IO2.ValueType.BaseType = btChar then
                  begin
                    SA := VarToStr(IO2.Value);
                    C := SA[1];
                    N := Ord(C)
                  end
                  else
                    N := IO2.Value;
                  for M := I to N do Include(SI, M);
             end
             else WriteError(Proc.DeclUnit, ceErrorTypeInSet, IO2.ValueType.OriginalName);
           finally
             if IO2.IdentType = itValue then IO2.Free;
           end;


           if Tokens.Token.TokenID = ID_Comma then Tokens.Next
           else Break;
       end;

       else Break;

    end; //Enc Case

  end; //End While

  if Tokens.Token.TokenID = ID_CloseBlock then Tokens.Next
    else WriteError(Proc.DeclUnit, ceCloseBlockExpected, '');
  Result := TSetObject.Create(Self);
  Result.ValueType := FindType('set', Proc, True);
  Result.Value := TSuPtr(@SI);
end;

function TDpCompiler.Compile: Boolean;
var
  Parser: TDpParser;
  I: Cardinal;
  S: TDpString;
  C: Char;
begin
  Reset;
  I := 0;
  Debug := False;
  C := DecimalSeparator;
  if Assigned(FOnExecuteInstruction) then Debug := True;
  WriteMessage('', 'Подготовка к компиляции');
  WriteMessage('', 'Импорт типов');
  if AddTypes then
  begin
    WriteMessage('', 'OK');
    WriteMessage('', 'Импорт свойств типов');
    if AddTypeProp then
    begin
      WriteMessage('', 'OK');
      WriteMessage('', 'Импорт констант');
      if AddConsts then
      begin
        WriteMessage('', 'OK');
        WriteMessage('', 'Импорт переменных');
        if AddVars then
        begin
          WriteMessage('', 'OK');
          WriteMessage('', 'Импорт объектов');
          if Assigned(FOnAddObject) then FOnAddObject(@Add_Object);
          if not FErrors then
          begin
            WriteMessage('', 'OK');
            WriteMessage('', 'Импорт методов');
            if AddMethods then
            begin
              WriteMessage('', 'OK');
              if Assigned(FOnGetUnitSource) then
              begin
                WriteMessage('', 'Запуск процесса компиляции');
                I := GetTickCount;
                Parser := TDpParser.Create(UseTranscription, FSuLanguage);
                try
                  if DecimalSeparator <> '.' then DecimalSeparator := '.';
                  FMainProc := TUnitProc.Create(Self);
                  Units.Add(FMainProc);
                  Parser.SetParseStr(FOnGetUnitSource('!'));
                  Tokens := Parser.GetTokensList;
                  DoProgram;
                finally
                  Parser.Free;
                  DecimalSeparator := C;
                end;
              end
              else
                WriteMessage('', 'Исходный код программы не найден');
            end;
          end;
        end;
      end;
    end;
  end;
  Result := not FErrors;
  if Result then
  begin
    FCompiled := True;
    S := 'Компиляция завершена успешно. Обработано модулей: ' + IntToStr(Units.Count);
    S := S + '. Обработано строк: ' + IntToStr(TotalRow + 1);
    if I <> 0 then
    begin
      I := GetTickCount - I;
      S := S + '  (' + TDpString(FloatToStr(I / 1000)) + ' сек)';
    end;
    if MainProc <> nil then
      WriteMessage(MainProc.FOriginalName, S)
    else
      WriteMessage('Программа нет найдена', S)
  end
  else
  begin
    S := '';
    if MainProc <> nil then S := MainProc.OriginalName;
    WriteMessage(S, 'Компиляция не возможна из-за ошибок');
  end;
end;

function TDpCompiler.Run: Variant;
begin
  //MainProc.Inicializ;
  Result := MainProc.Value;
end;

function TDpCompiler.GetIniValue(AType: TDpType): Variant;
begin
  case AType.BaseType of
    btInt:
    begin
      Result := 0;
      TVarData(Result).VType := varInteger;
    end;
    btBool: Result := False;
    btFloat:
    begin
      Result := 0.0;
      TVarData(Result).VType := varDouble;
    end;
    btChar: Result := #0;
    btString: Result := '';
    btClass: Result := 0;
    btEnum: Result := 0;
  end;
end;

function TDpCompiler.GetHandlerClass(AType: PTypeInfo): TDpEventHandlerClass;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to EventHandlerRegList.Count - 1 do
  begin
    if TdpEventHandlerReg(EventHandlerRegList.Items[I]).AType = AType then
    begin
      Result := TdpEventHandlerReg(EventHandlerRegList.Items[I]).AHandlerClass;
      Break;
    end;
  end;
end;

function TDpCompiler.FindType(ATypeName: TDpString; Proc: TSuProc; WriteErr: Boolean): TDpType;
var
  DeclUnit: TDpString;
  UnitProc: TSuProc;
  I: Integer;
begin
  DeclUnit := 'External Error';
  if Proc <> nil then DeclUnit := Proc.DeclUnit;

  UnitProc := nil;

  while Proc <> nil do
  begin
    Result := Proc.FTypeTable.Find(ATypeName, 0);
    if Result <> nil then Exit;
    if Proc.FUnits.Count > 0 then UnitProc := Proc;
    Proc := TSuProc(Proc.Proc);
  end;

  if UnitProc <> nil then
  begin
    I := 0;
    while I < UnitProc.FUnits.Count do
    begin
      Proc := TSuProc(UnitProc.FUnits.Items[I]);
      Result := Proc.FTypeTable.Find(ATypeName, 0);
      if Result <> nil then Exit;
      Inc(I);
    end;
  end;

  Result := TypeTable.Find(ATypeName, 0);
  if (Result = nil) and WriteErr then
  begin
    WriteError(DeclUnit, ceUnknownType, ATypeName);
    Result := DefaultType;
  end;

end;

function TDpCompiler.IsTypeExist(ATypeName: TDpString; Proc: TSuProc): Boolean;
var
  UnitProc: TSuProc;
  I: Integer;
begin
  UnitProc := nil;
  while Proc <> nil do
  begin
    Result := Proc.FTypeTable.Find(ATypeName, 0) <> nil;
    if Result then Exit;
    if Proc.FUnits.Count > 0 then UnitProc := Proc;
    Proc := TSuProc(Proc.Proc);
  end;
  if UnitProc <> nil then
  begin
    I := 0;
    while I < UnitProc.FUnits.Count do
    begin
      Proc := TSuProc(UnitProc.FUnits.Items[I]);
      Result := Proc.FTypeTable.Find(ATypeName, 0) <> nil;
      if Result then Exit;
      Inc(I);
    end;
  end;
  Result := TypeTable.Find(ATypeName, 0) <> nil;
end;

function TDpCompiler.IsIdentDeclared(IdentName: TDpString; H: Cardinal; Proc: TSuProc): Boolean;
var
  I, N: Integer;
  UnitProc: TSuProc;
begin
  Result := False;
  IdentName := IdentName;
  if H = 0 then
    H := Hash(IdentName);
  UnitProc := nil;
  while Proc <> nil do
  begin
    I := 0;
    while I < Proc.FObjects.Count do
    begin
      if (TIdentObject(Proc.FObjects.Items[I]).HashValue = H) and
        (TIdentObject(Proc.FObjects.Items[I]).Name = IdentName) then
      begin
        Result := True;
        Exit;
      end;
      Inc(I);
    end;
    if Proc.FUnits.Count > 0 then
    begin
      UnitProc := Proc;
    end;
    Proc := TSuProc(Proc.Proc);
  end;

  if UnitProc <> nil then
  begin
    N := 0;
    while N < UnitProc.FUnits.Count do
    begin
      Proc := TSuProc(UnitProc.FUnits.Items[N]);
      I := 0;
      while I < Proc.FObjects.Count do
      begin
        if (TIdentObject(Proc.FObjects.Items[I]).HashValue = H) and
          (TIdentObject(Proc.FObjects.Items[I]).Name = IdentName) then
        begin
          Result := True;
          Exit;
        end;
        Inc(I);
      end;
      Inc(N);
    end;
  end;
  I := 0;
  while I < ExternalObject.Count do
  begin
    if (TIdentObject(ExternalObject.Items[I]).HashValue = H) and
        (TIdentObject(ExternalObject.Items[I]).Name = IdentName) then
    begin
      Result := True;
      Exit;
    end;
    Inc(I);
  end;

end;

procedure TDpCompiler.WriteHintWarning(AModuleName: TDpString;
  AMessage: TDpString; ACol, ARow: Integer; AMsgType: TSuMessageType);
var
  Msg: TDpCompilerMessage;
begin
  Msg := TDpCompilerMessage.Create(ACol + 1, ARow + 1, AModuleName, Integer(ceCustomError), AMessage, AMsgType, FSuLanguage);
  FMsgList.Add(Msg);
  FOnError(Msg);
  if AMsgType = dsmError then FErrors := True;

end;

function TDpCompiler.WriteError(AModuleName: TDpString; MsgCode: TCompilerError;
        AParam: string = ''): TDpCompilerMessage;
var
  ACol, ARow: Integer;
begin
  FErrors := True;
  Result := nil;
  if Assigned(FOnError) then
  begin
    ACol := 0; ARow := 0;
    if Tokens <> nil then
    begin
      ACol := Tokens.Token.Col + 1;
      ARow := Tokens.Token.Row + 1;
    end;
    Result := TDpCompilerMessage.Create(ACol, ARow,
      AModuleName, Integer(MsgCode), AParam, dsmError, FSuLanguage);
    FMsgList.Add(Result);
    FOnError(Result);
  end;
end;

function TDpCompiler.GetAsniFunciton: TdpAnsiFunction;
begin
  Result := DefaultAnsiFunciton;
end;

function TDpCompiler.GetDOSFunction: TdpDOSFunction;
begin
  Result := DefaultDosFunction;
end;

procedure TDpCompiler.SetAnsiFunction(AValue: TdpAnsiFunction);
begin
  if DefaultAnsiFunciton <> AValue then
    DefaultAnsiFunciton := AValue;
end;

procedure TDpCompiler.SetDOSFunction(AValue: TdpDOSFunction);
begin
  if DefaultDosFunction <> AValue then
    DefaultDosFunction := AValue;
end;

function TDpCompiler.DecimalSeparator_Get: Variant;
begin
  Result := DecimalSeparator;
end;

procedure TDpCompiler.DecimalSeparator_Set(Value: Variant);
var
  S: string;
begin
  S := Value;
  if S <> '' then DecimalSeparator := S[1];
end;

procedure TDpCompiler.AddColorValues(const S: string);
begin
  Add_Const(S, 'TColor', StringToColor(S));
end;

function TDpCompiler.GetIdent(IdentName: TDpString; H: Cardinal; Proc: TDpCustomProc): TIdentObject;
var
  I, N: Integer;
  UnitProc: TSuProc;
begin
  Result := nil;
  IdentName := UTF8LowerCase(IdentName);
  if H = 0 then
    H := Hash(IdentName);
  UnitProc := nil;
  while Proc <> nil do
  begin
    I := 0;
    while I < Proc.FObjects.Count do
    begin
      if (TIdentObject(Proc.FObjects.Items[I]).HashValue = H) and (TIdentObject(Proc.FObjects.Items[I]).Name = IdentName) then
      begin
        Result := TIdentObject(Proc.FObjects.Items[I]);
        Result.FUse := True;
        Exit;
      end;
      Inc(I);
    end;

    if Proc.FUnits.Count > 0 then
    begin
      UnitProc := TSuProc(Proc);
    end;
    //ParentProc
    Proc := Proc.Proc;
  end;
  if UnitProc <> nil then
  begin
    N := 0;
    while N < UnitProc.FUnits.Count do
    begin
      Proc := TSuProc(UnitProc.FUnits.Items[N]);
      if (Proc.HashValue = H) and (Proc.Name = IdentName) then
      begin
        Result := Proc;
        Result.FUse := True;
        if Tokens.PreviewNext.TokenID = ID_Period then
        begin
          Tokens.Next;
          Tokens.Next;
          Result := GetIdent(Tokens.Token.TokenName, Tokens.Token.HashValue, Proc);
        end;
        Exit;
      end;

      I := 0;
      while I < Proc.FObjects.Count do
      begin
        if (TIdentObject(Proc.FObjects.Items[I]).HashValue = H)
          and (TIdentObject(Proc.FObjects.Items[I]).Name = IdentName) then
        begin

          Result := TIdentObject(Proc.FObjects.Items[I]);
          Result.FUse := True;
          Exit;
        end;
        Inc(I);
      end;
      Inc(N);
    end;
  end;
  I := 0;
  while I < ExternalObject.Count do
  begin
    if (TIdentObject(ExternalObject.Items[I]).HashValue = H)
      and (TIdentObject(ExternalObject.Items[I]).Name = IdentName) then
    begin
      Result := TIdentObject(ExternalObject.Items[I]);
      Exit;
    end;
    Inc(I);
  end;
end;

function TDpCompiler.GetIdentClass(AType: TDpType): TIdentClass;
begin
  Result := TIdentObject;
  case AType.BaseType of
    btInt: Result := TIntegerObject;
    btBool: Result := TIdentObject;
    btFloat: Result := TIdentObject;
    btChar: Result := TIdentObject;
    btString: Result := TStringObject;
    btClass:
    begin
      if AType.ScriptRec then
        Result := TScriptRecord
      else
        Result := TIdentObject;
    end;
    btArray: Result := TArrayObject;
    btVariant: Result := TIdentObject;
    btEnum: Result := TEnumObject;
    btSet: Result := TSetObject;
    btEvent: Result := TIdentObject;
    btRecord:  Result := TRecObject;
    btPointer: Result := TAdresExpression;
    btIntf: Result := TIdentObject;
    btPointerProc: Result := TPointerProc;
  end;
end;

function TDpCompiler.DoClassProperty(AIdent: TIdentObject;
  AType: TDpType; Proc: TSuProc; GetMethodAdres: Boolean): TIdentObject;
var
  Ident: TIdentObject;
  AClass: TClass;

  function DoCallProp(ValTyp: TDpType): TIdentObject;
  var
    P: PPropInfo;
    I: Integer;
    IO: TIdentObject;
    CP: TClassPropObject;
    CCP: TClassCallProp;
    CSP: TClassSetProp;
    FC: TFindComponent;
    IP: TIndexedPropCaller;
    FV: TFindClassVar;
    ClasPrp: TClassProperty;
    AE: TAdresExpression;

  begin
    Result := Ident;
    if AClass <> nil then
    begin
      //проверяем есть ли такое свойство
      P := GetPropInfo(AClass, string(Tokens.Token.TokenName));
      if P <> nil then
      begin
        //Свойство найдено
        if P^.PropType^.Kind = tkSet then
        begin
          CSP := TClassSetProp.Create(Self);
          CSP.Proc := Proc;
          CSP.Name := Tokens.Token.TokenName;
          CSP.FVal := Ident;
          CSP.Prop := P;
          CSP.ValueType := FindType(P^.PropType^.Name, Proc, True);
          Ident := CSP;
          Result := CSP;
          AClass := nil;
        end
        else
        begin
          CP := TClassPropObject.Create(Self);
          CP.Proc := Proc;
          CP.Name := Tokens.Token.TokenName;
          CP.FVal := Ident;
          CP.Prop := P;
          CP.ValueType := FindType(P^.PropType^.Name, Proc, True);
          Ident := CP;
          Result := CP;
          AClass := CP.ValueType.ValueClassType;
          //AClass := GetTypeData(P^.PropType^)^.ClassType;
        end;
      end
      else
      begin
          //Свойства нет, ищем public свойство или метод
          Result := FindTypeProp(Tokens.Token.TokenName, ValTyp, Proc);
          if Result <> nil then
          begin
            if Result.IdentType = itClassComponent then
            begin
              FC := TFindComponent.Create(Self);
              FC.Name := Result.Name;
              FC.FVal := Ident;
              FC.ValueType := Result.ValueType;
              Result := FC;
            end
            else
            if Result.IdentType = itClassVar then
            begin
              {if (Result.ValueType.BaseType in [btArray, btVariant]) then
              begin
                Tokens.Next;
                if (Tokens.Token.TokenID = ID_OpenBlock) then
                  Ident := DoIndexedVar(Proc, Result);
              end;}
              FV := TFindClassVar.Create(Self);
              FV.FVal := Ident;
              FV.IdentType := Ident.IdentType;
              FV.DeclObject := Result;
              FV.Name := Result.OriginalName;
              FV.ValueType := Result.ValueType;
              Result := FV;
            end
            else
            if Result.IdentType = itProp then
            begin
              if Result is TClassPublishedProp then
              begin
                //Свойство найдено
                P := TClassPublishedProp(Result).AProp;
                if P^.PropType^.Kind = tkSet then
                begin
                  CSP := TClassSetProp.Create(Self);
                  CSP.Proc := Proc;
                  CSP.Name := Tokens.Token.TokenName;
                  CSP.FVal := Ident;
                  CSP.Prop := P;
                  CSP.ValueType := FindType(P^.PropType^.Name, Proc, True);
                  Ident := CSP;
                  Result := CSP;
                  AClass := nil;
                end
                else
                begin
                  CP := TClassPropObject.Create(Self);
                  CP.Proc := Proc;
                  CP.Name := Tokens.Token.TokenName;
                  CP.FVal := Ident;
                  CP.Prop := P;
                  CP.ValueType := FindType(P^.PropType^.Name, Proc, True);
                  Ident := CP;
                  Result := CP;
                  AClass := CP.ValueType.ValueClassType;
                  //AClass := GetTypeData(P^.PropType^)^.ClassType;
                end;
              end
              else
              begin
                CCP := TClassCallProp.Create(Self);
                CCP.Name := Tokens.Token.TokenName;
                CCP.GetPrValue := TClassPublicProp(Result).GetPrValue;
                CCP.SetPrVAlue := TClassPublicProp(Result).SetPrVAlue;
                if not Assigned(CCP.SetPrVAlue) then CCP.OnlyRead := True;
                CCP.ValueType := Result.ValueType;
                CCP.FVal := Ident;
                Result := CCP;
              end;

            end
            else
            if Result.IdentType = itClassProp then
            begin
              //Свойство объявленное в классе в скрипте
              ClasPrp := TClassProperty.Create(Self);
              ClasPrp.OnlyRead := Ident.OnlyRead;
              ClasPrp.FVal := Ident;
              ClasPrp.IdentType := Ident.IdentType;
              ClasPrp.DeclObject := TScriptProp(Result);
              ClasPrp.Name := Result.OriginalName;
              ClasPrp.ValueType := Result.ValueType;
              Result := ClasPrp;
            end
            else
            if Result is TClassIndexedProp then
            begin
              IP := TIndexedPropCaller.Create(Self);
              IP.FVal := Ident;
              IP.Name := Result.OriginalName;
              IP.GetMethod := TClassIndexedProp(Result).GetMethod;
              IP.SetMethod := TClassIndexedProp(Result).SetMethod;
              IP.ValueType := TClassIndexedProp(Result).ValueType;
              if not Assigned(IP.SetMethod) then IP.OnlyRead := True;
              Tokens.Next;
              if Tokens.Token.TokenID = ID_OpenBlock then
              begin
                Tokens.Next;
                I := 0;
                while True do
                begin
                  IO := DoExpression(Proc, False);
                  IP.FList.Add(IO);
                  if I <= TClassIndexedProp(Result).Params.Count then
                  begin
                    ValTyp := TDpType(TClassIndexedProp(Result).Params.Items[I]);
                    if not IsCompatibleTypes(IO.ValueType, ValTyp, ID_Assignment) then
                      WriteError(Proc.DeclUnit, ceTypeMismatch, IO.ValueType.OriginalName + ', ' + ValTyp.OriginalName);
                  end;
                  Inc(I);
                  if Tokens.Token.TokenID = ID_Comma then
                  begin
                    Tokens.Next;
                    Continue;
                  end
                  else Break;
                end;
                if Tokens.Token.TokenID = ID_CloseBlock then
                begin
                  if TClassIndexedProp(Result).Params.Count <> IP.FList.Count then
                    WriteError(Proc.DeclUnit, ceCustomError, 'Неверное количество индексов');
                end
                else
                  WriteError(Proc.DeclUnit, ceCloseBlockExpected, '');
              end
              else
                WriteError(Proc.DeclUnit, ceOpenBlockExpected, '');
              Result := IP;
            end;
          end
          else
          begin
            Result := FindTypeMethod(Tokens.Token.TokenName, ValTyp, Proc);
            if Result <> nil then
            begin
              if GetMethodAdres then
              begin
                AE := TAdresExpression.Create(Self);
                //AE.FValueType :=
                AE.FValue := TSuPtr(Result);
                AE.RefObject := Ident;
                Result := AE;
              end
              else
              begin
                Result := DoCallMethod(Proc, TSuProc(Result), Ident, False);
                if TProcCaller(Result).CallProc.FIsConstructor then
                  Result.ValueType := ValTyp;
                Tokens.Prev;
              end;
            end;
          end;
          if Result <> nil then
          begin
            //Найдено public свойство или метод
            Ident := Result;
            if Result.ValueType.BaseType = btClass then
              AClass := Result.ValueType.ValueClassType
            else AClass := nil;
          end
          else
          begin
            //метод или свойство не найдены
            WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
          end;
      end;
    end
    else
    if Ident.ValueType.BaseType = btRecord then
    begin
      Result := DoRecField(Ident, Proc);
      Tokens.Prev
    end
    else
    begin
      WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
    end;

    Tokens.Next;
  end;

begin
  Result := nil;
  if AIdent = nil then
  begin
    if AType <> nil then
    begin
      AClass := AType.ValueClassType;
      Result := DoCallProp(AType);
    end
    else
    if Proc.ClassOwner <> nil then
    begin
      Ident := Proc.FDataObject;
      AClass := Proc.ClassOwner.ValueClassType;
      Result := DoCallProp(Proc.ClassOwner);
    end;
  end
  else
  begin
    if AIdent.IdentType = itClassComponent then
    begin
      Ident := TFindComponent.Create(Self);
      TFindComponent(Ident).FVal := Proc.FDataObject;
      Ident.FValueType := AIdent.ValueType;
      Ident.FName := AIdent.Name;
      Result := Ident;
    end
    else
    if AIdent.IdentType = itClassProp then
    begin
      Ident := TClassProperty.Create(Self);
      TClassProperty(Ident).FVal := Proc.FDataObject;
      TClassProperty(Ident).IdentType := itVar;
      TClassProperty(Ident).DeclObject := TScriptProp(AIdent);
      Ident.FValueType := AIdent.ValueType;
      Ident.OnlyRead := AIdent.OnlyRead;
      Ident.FName := AIdent.Name;
      Result := Ident;
    end
    else
    if AIdent.IdentType = itClassVar then
    begin
      {if (AIdent.ValueType.BaseType = btArray) then
      begin
        Tokens.Next;
        if (Tokens.Token.TokenID = ID_OpenBlock) then
        AIdent := DoIndexedVar(Proc, AIdent);
      end;}
      Ident := TFindClassVar.Create(Self);
      TFindClassVar(Ident).FVal := Proc.FDataObject;
      TFindClassVar(Ident).IdentType := Proc.FDataObject.IdentType;
      TFindClassVar(Ident).DeclObject := AIdent;
      Ident.FValueType := AIdent.ValueType;
      Ident.FName := AIdent.Name;
      Result := Ident;
    end
    else
      Ident := AIdent;
    if AType = nil then
      AClass := Ident.ValueType.ValueClassType
    else
      AClass := AType.ValueClassType;
    Tokens.Next;
    if Tokens.Token.TokenID = ID_Period then Tokens.Next;

    while True do
    begin
      if Tokens.Token.TokenID = ID_Identifier then
      begin
        Result := DoCallProp(AType);
        if (Result = nil) or (Result.ValueType.BaseType = btVariant) then
          Break;
      end;
      if Tokens.Token.TokenID = ID_Period then
      begin
        AType := Result.ValueType;
        Tokens.Next;
        Continue;
      end
      else Break;
    end;
  end;

  if Result = nil then
  begin
    Result := TIdentObject.Create(Self);
    Result.ValueType := DefaultType;
    Result.IdentType := itVar;
    Proc.AddErrObject(Result);
  end;

end;

function TDpCompiler.DoRecField(AIdent: TIdentObject; Proc: TSuProc): TIdentObject;
var
  IO: TIdentObject;
  RF: TRecFieldObject;
begin
  Result := AIdent;
  if Tokens.Token.TokenID = ID_Period then Tokens.Next;
  if Tokens.Token.TokenID = ID_Identifier then
  begin
    IO := AIdent.ValueType.FClassObjects.Find(Tokens.Token.TokenName, Tokens.Token.HashValue);
    if IO <> nil then
    begin
      RF := TRecFieldObject.Create(Self);
      RF.RO := AIdent;
      RF.IdentType := IO.IdentType;
        //RF.IdentType := itVar;
      RF.Name := RF.RO.OriginalName + '.' + IO.OriginalName;
      RF.ASetProp := TClassPublicProp(IO).SetPrVAlue;
      RF.AGetprop := TClassPublicProp(IO).GetPrValue;
      RF.ValueType := IO.ValueType;
      Result := RF;
    end
    else
      WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
    Tokens.Next;
  end
  else
    WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
end;

function TDpCompiler.DoDispatch(AIdent: TIdentObject; Proc: TSuProc): TIdentObject;
var
  DE: TDispExpression;
  AParam: TIdentObject;
begin
  Result := AIdent;
  Tokens.Next;
  while True do
  begin
    DE := TDispExpression.Create(Self);
    DE.ValueType := DispType;
    if Tokens.Token.TokenID = ID_Identifier then
      DE.Name := Tokens.Token.TokenName
    else
      WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
    DE.FVal := Result;
    Result := DE;
    Tokens.Next;
    if Tokens.Token.TokenID = ID_OpenRound then
    begin
      if Tokens.PreviewNext.TokenID = ID_CloseRound then
      begin
        Tokens.Next;
        Tokens.Next;
      end
      else
      begin
        Tokens.Next;
        while True do
        begin
          AParam := DoSimpleExpression(Proc, False);
          DE.AddParam(AParam);
          if Tokens.Token.TokenID = ID_Comma then Tokens.Next
          else Break;
        end;
        if Tokens.Token.TokenID = ID_CloseRound then Tokens.Next
        else
          WriteError(Proc.DeclUnit, ceCloseRoundExpected, '');
      end;
    end;
    if Tokens.Token.TokenID = ID_Period then Tokens.Next
    else Break;
  end;
end;

function TDpCompiler.DoCallMethod(Proc: TSuProc; CallProc: TSuProc;
  ClassObj: TIdentObject; AInheritedCall: Boolean): TProcCaller;

  function DoCallProcParam(ParamList: TList): Boolean;
  var
     Param: TIdentObject;
     T1, T2: TDpType;
     I: Integer;
     B: Boolean;
  begin
    Result := True;
    Param  := nil;
    I := -1;
    if Tokens.Token.TokenID = ID_OpenRound then
    begin
      Tokens.Next;
      while True do
      begin
        if Tokens.Token.TokenID = ID_OpenBlock then
        begin
          Inc(I);
          if I < CallProc.ParamCount then
            if CallProc.Param[I].ValueType.BaseType = btArray then
              Param := DoArrayValue(Proc)
            else
              Param := DoExpression(Proc, False);
        end
        else
          Param := DoExpression(Proc, False);

        if Param = nil then Result := False
        else
        begin

          I := ParamList.Add(Param);
          if I < CallProc.ParamCount then
          begin
            T1 := CallProc.Param[I].ValueType;
            if T1.BaseType = btArray then
              T1 := TArrayObject(CallProc.Param[I]).DataType;

            T2 := Param.ValueType;

            if (Param is TProcCaller) and (TProcCaller(Param).CallProc.ValueType.BaseType = btPointerProc) then
              T2 := TPointerProc(TProcCaller(Param).CallProc).DeclProc.ValueType
            else
            if T2.BaseType = btArray then
              T2 := TArrayObject(Param).DataType;

            if not IsCompatibleTypes(T1, T2, ID_Assignment) then
              WriteError(Proc.DeclUnit, ceInvalidParameterType, '');
            if CallProc.Param[I].AsPointer and (Param.IdentType = itValue) then
              WriteError(Proc.DeclUnit, ceValueInVarParam, '');
          end;
        end;
        if Tokens.Token.TokenID = ID_Comma then
        begin
          Tokens.Next;
          Continue;
        end
        else Break;
      end;
      if Tokens.Token.TokenID = ID_CloseRound then Tokens.Next
      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceCloseRoundExpected, '');
      end;
    end;

    if ParamList.Count < CallProc.ParamCount then
    begin
      B := False;
      for I := ParamList.Count to CallProc.ParamCount - 1 do
      begin
        if not CallProc.Param[I].FInitObj then
        begin
          B := True;
          Break;
        end;
      end;
      if B then
      begin
        WriteError(Proc.DeclUnit, ceInvalidnumberOfParameters, '');
      end;
    end
    else
    if ParamList.Count > CallProc.ParamCount then
      WriteError(Proc.DeclUnit, ceInvalidnumberOfParameters, '');
  end;
begin
  if CallProc.FIsConstructor then
  begin
    Result := TConstrCaller.Create(Self);
    TConstrCaller(Result).InhValueType := CallProc.ValueType;
  end
  else
    Result := TProcCaller.Create(Self);

  Result.Name := 'Call_' + CallProc.Name;
  Result.FOwnerIdent := ClassObj;
  Result.FCallProc := CallProc;
  Result.FProc := Proc;
  if AInheritedCall then
  begin
    Result.Inh := True;
    Result.ValueType := Proc.ValueType;
  end
  else
  begin
    Result.ValueType := CallProc.ValueType;
    if CallProc is TPointerProc then
      Result.ValueType := TPointerProc(CallProc).DeclProc.ValueType;
  end;
  Tokens.Next;
  DoCallProcParam(TProcCaller(Result).FParams);
  if Tokens.Token.TokenID = ID_OpenRound then
  begin
    if CallProc.ParamCount = 0 then
      WriteError(Proc.DeclUnit, ceCallMethodHasNoParam, '');

  end;
end;

function TDpCompiler.FindTypeObject(AObject: TObject): TDpType;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to FObjectData.Count - 1 do
  begin
    if TDpClassData(FObjectData.Items[I]).FObject = AObject then
    begin
      Result := TDpClassData(FObjectData.Items[I]).FType;
      Break;
    end;
  end;
end;

function TDpCompiler.GetValueTypeOf(Proc: TSuProc; ALeft, ARight: TDpType; AOp: TIdentToken): TDpType;
var
  LeftBt, RightBt: TsuBaseType;
  S: set of TsuBaseType;
begin
    Result := nil;
    if IsCompatibleTypes(ALeft, ARight, AOp) then
    begin
      S := [ALeft.FBaseType] + [ARight.FBaseType];
      LeftBt := ALeft.BaseType;
      RightBt := ARight.BaseType;
      case AOp of
        ID_Plus:
        begin
          if LeftBt = btEnum then LeftBt := btInt;
          if RightBt = btEnum then RightBt := btInt;

          if (LeftBt in [btVariant, btDisp]) or (RightBt in [btVariant, btDisp]) then
            Result := DefaultType
          else
          if (LeftBt = btString) or (LeftBt = btChar) then
            Result := FindType('String', MainProc, True)
          else
          if S = [btInt] then
            Result := IntegerType
          else
          if S = [btInt, btFloat] then
            Result := ExtendedType
          else
          if S = [btFloat] then
            Result := ExtendedType
          else
          if LeftBt = btSet then Result := ALeft;

        end;
        ID_Minus, ID_Multiply:
        begin
          if S = [btString, btChar, btBool] then
            Result := nil
          else
          if (ALeft.FBaseType in [btVariant, btDisp]) or (ARight.FBaseType in [btVariant, btDisp]) then
            Result := DefaultType
          else
          if (ALeft.FBaseType = btInt) and (ARight.FBaseType = btInt) then
            Result := IntegerType
          else
          if S = [btFloat] then
            Result := ExtendedType
          else
          if S = [btInt, btFloat] then
            Result := ExtendedType
          else
          if ALeft.FBaseType = btSet then Result := ALeft;
        end;
        ID_Divide:
        begin
          if S = [btString, btChar, btBool] then
            Result := nil
          else
            Result := ExtendedType
        end;
        ID_div, ID_mod, ID_shl, ID_shr:
        begin
          if (ALeft.FBaseType = btInt) and (ARight.FBaseType = btInt) then
            Result := IntegerType;
        end;
        ID_Greater, ID_Less, ID_Equal, ID_NotEqual, ID_in,
        ID_LessEqual, ID_GreaterEqual:
        begin
          if (ALeft.BaseType = btSet) then
          begin
            if AOp in [ID_Equal, ID_NotEqual, ID_GreaterEqual, ID_LessEqual] then
              Result := BooleanType;
          end
          else
          begin
            if AOp = ID_in then
            begin
              if ARight.BaseType = btSet then Result := BooleanType;
            end
            else
              Result := BooleanType;
          end;
        end;
        ID_and, ID_or, ID_xor:
        begin
          if (ALeft.FBaseType = btBool) and (ARight.FBaseType = btBool) then
            Result := ALeft
          else
          if (ALeft.FBaseType = btInt) and (ARight.FBaseType = btInt) then
            Result := ALeft;
        end;
        ID_Is:
        begin
          if (ALeft.FBaseType = btClass) and (ARight.FBaseType = btClass) then
          begin
            Result := BooleanType;
          end;
        end;
      end; //End Case
    end;
end;

function TDpCompiler.GetScriptClass(AClassName: TDpString; H: Cardinal
  ): TDpType;
var
  I: Integer;
begin
  Result := nil;
  AClassName := UTF8LowerCase(AClassName);
  if H = 0 then
    H := Hash(AClassName);
  for I := 0 to FCompClasses.Count - 1 do
  begin
    if TDpType(FCompClasses.Items[I]).FHashValue = H then
    begin
      if TDpType(FCompClasses.Items[I]).Name = AClassName then
      begin
        Result := TDpType(FCompClasses.Items[I]);
        Break;
      end;
    end;
  end;
end;

function TDpCompiler.GetClassMethod(AClassName, ProcName: TDpString): TSuProc;
var
  AType: TDpType;
  Ident: TIdentObject;
begin
  Result := nil;
  AType := GetScriptClass(AClassName, 0);
  if (AType <> nil) and (AType.BaseType = btClass) then
  begin
    Ident := AType.FClassObjects.Find(ProcName, 0);
    if (Ident <> nil) and (Ident.IdentType = itProc) then
      Result := TSuProc(Ident);
  end;
end;

function TDpCompiler.ExtFindComponent(C: TComponent; AName: TDpString
  ): TComponent;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to C.ComponentCount - 1 do
  begin
    if CompareText(C.Components[I].Name, AName) = 0 then
    begin
      Result := C.Components[I];
      Break;
    end;
  end;
end;

function TDpCompiler.AddEmptyData(AObject: TObject): TDpClassData;
begin
  Result := TDpClassData.Create(Self, AObject, nil);
  FObjectData.Add(Result);
end;

function TDpCompiler.AddObjectData(AObject: TObject; AType: TDpType): TDpClassData;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to FObjectData.Count - 1 do
  begin
    if TDpClassData(FObjectData.Items[I]).FObject = AObject then
    begin
      Result := TDpClassData(FObjectData.Items[I]);
      Break;
    end;
  end;
  if Result = nil then
  begin
    Result := TDpClassData.Create(Self, AObject, AType);
    FObjectData.Add(Result);
  end
  else
  begin
    Result.AddData(Self, AType);
  end;
end;

function TDpCompiler.GetData(AObject: TObject): TDpClassData;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to FObjectData.Count - 1 do
  begin
    if TDpClassData(FObjectData.Items[I]).FObject = AObject then
    begin
      Result := TDpClassData(FObjectData.Items[I]);
      Break;
    end;
  end;
end;

procedure TDpCompiler.DeleteObjectData(AObject: TObject);
var
  I: Integer;
begin
  for I := 0 to FObjectData.Count - 1 do
  begin
    if TDpClassData(FObjectData.Items[I]).FObject = AObject then
    begin
      TDpClassData(FObjectData.Items[I]).Free;
      FObjectData.Delete(I);
      Break;
    end;
  end;
end;

function TDpCompiler.FindObjectData(AObject: TObject;
  varName: TDpString): TIdentObject;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to FObjectData.Count - 1 do
  begin
    if TDpClassData(FObjectData.Items[I]).FObject = AObject then
    begin
      Result := TDpClassData(FObjectData.Items[I]).FDataList.Find(varName, 0);
      Break;
    end;
  end;
end;

function TDpCompiler.ObjectDataExist(AObject: TObject): Boolean;
var
  I: Integer;
begin
  Result := False;
  for I := 0 to FObjectData.Count - 1 do
  begin
    if TDpClassData(FObjectData.Items[I]).FObject = AObject then
    begin
      Result := True;
      Break;
    end;
  end;
end;

function TDpCompiler.DoIndexedVar(Proc: TSuProc; Ident: TIdentObject): TIdentObject;
var
  ArExpr: TArrayExpression;
  AO: TArrayObject;
  CArExpr: TCharArrayExpression;
  IO: TIdentObject;
begin
  Result := Ident;
  if Tokens.Token.TokenID = ID_OpenBlock then
  begin
    if Ident.ValueType.BaseType = btString then
    begin
      CArExpr := TCharArrayExpression.Create(Self);
      CArExpr.Val := Ident;
      CArExpr.ValueType := FindType('Char', Proc, True);
      Result := CArExpr;
      Tokens.Next;
      IO := DoExpression(Proc, False);
      CArExpr.Params.Add(IO);
      if Tokens.Token.TokenID <> ID_CloseBlock then
          WriteError(Proc.DeclUnit, ceCloseBlockExpected, '');
    end
    else
    begin
      ArExpr := TArrayExpression.Create(Self);
      ArExpr.SetObject(Ident);
      ArExpr.Name := Ident.OriginalName;
      if Result is TFindClassVar then
         Result := TFindClassVar(Result).DeclObject;
      if Result.ValueType.BaseType = btArray then
        ArExpr.ValueType := TArrayObject(Result).DataType
      else ArExpr.ValueType := Result.ValueType;
      Result := ArExpr;
      Tokens.Next;
      while Tokens.Token.TokenID <> ID_CloseBlock do
      begin
        IO := DoExpression(Proc, False);
        ArExpr.Params.Add(IO);
        if Tokens.Token.TokenID = ID_Comma then
        begin
          Tokens.Next;
          Continue;
        end
        else Break;
      end;
      if Tokens.Token.TokenID = ID_CloseBlock then
      begin

        if Ident.ValueType.BaseType = btArray then
        begin
          if Ident is TFindClassVar then
            AO := TArrayObject(TFindClassVar(Ident).DeclObject)
          else
            AO := TArrayObject(Ident);
          if (AO.DimCount > 0) and
            (ArExpr.FParams.Count <> AO.DimCount) then
             WriteError(Proc.DeclUnit, ceCustomError, 'Неверное количество индексов при обращении к массиву');
        end;
      end
      else WriteError(Proc.DeclUnit, ceCloseBlockExpected, '');
    end;
  end;
end;

function TDpCompiler.DoTypeCast(Proc: TSuProc; AType: TDpType; AssignValue: Boolean): TIdentObject;
var
  SE: TSimpleExpression;
begin
  SE := TSimpleExpression.Create(Self);
  SE.ValueType := AType;
  SE.Name := AType.Name;
  Result := SE;
  if Tokens.PreviewNext.TokenID = ID_OpenRound then
  begin
    Tokens.Next;
    Tokens.Next;
    SE.FVal := DoFactor(Proc, False);
    if Tokens.Token.TokenID = ID_CloseRound then
      Tokens.Next
    else
      WriteError(Proc.DeclUnit, ceCloseRoundExpected, '');
  end
  else
  if AssignValue then
    WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
end;

function TDpCompiler.DoArrayValue(Proc: TSuProc): TIdentObject;
var
  ArVal: TArrayValueObject;
  IO: TIdentObject;
  I: Integer;
begin
  Tokens.Next;
  ArVal := TArrayValueObject.Create(Self);
  ArVal.ValueType := ArrayType;
  ArVal.FDataType := DefaultType;
  //ArVal.FValue := VarArrayOf([]);
  Result := ArVal;
  I := 0;
  while Tokens.Token.TokenID <> ID_EOF do
  begin
    if Tokens.Token.TokenID = ID_CloseBlock then Break;
    IO := DoSimpleExpression(Proc, False);
    if IO <> nil then
    begin
      ArVal.FList.Add(IO);
      Inc(I);
    end
    else
    begin
      WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается константа');
      Break;
    end;
    if Tokens.Token.TokenID = ID_Comma then Tokens.Next
    else
    if Tokens.Token.TokenID = ID_CloseBlock then Break
    else
    begin
      WriteError(Proc.DeclUnit, ceCloseBlockExpected, '');
    end;
  end;
  ArVal.FDimCount := I;
  if Tokens.Token.TokenID = ID_CloseBlock then Tokens.Next;

end;

function TDpCompiler.FindTypeProp(PropName: TDpString; AType: TDpType; Proc: TSuProc): TIdentObject;
var
  IO: TIdentObject;
  FindVisible, IOVizible: Integer;
begin
  Result := nil;
  if AType.BaseType = btClass then
  begin
    FindVisible := 3;
    if Proc.ClassOwner <> nil then
    begin
      if Proc.ClassOwner = AType then FindVisible := 1
      else
      if IsCompatibleScriptClasses(Proc.ClassOwner, AType) then
        FindVisible := 2;
    end;

    while AType <> nil do
    begin
      IO := AType.ClassObjects.Find(PropName, 0);
      if (IO <> nil) and (IO.IdentType <> itProc) then
      begin
        IOVizible := IO.ClassWisibleStatus;
        if IOVizible = 0 then IOVizible := 3;
        if (IOVizible >= FindVisible) then
        begin
          Result := IO;
          IO.FUse := True;
          Exit;
        end;
      end;
      AType := AType.Parent;
      if IOVizible = 1 then IOVizible := 2;
    end;
  end;
end;

function TDpCompiler.FindTypeMethod(AMethodName: TDpString; AType: TDpType; Proc: TSuProc): TSuProc;
var
  IO: TIdentObject;
  FindVisible, IOVizible: Integer;
begin
  Result := nil;
  if AType.BaseType = btClass then
  begin
    FindVisible := 3;
    if Proc.ClassOwner <> nil then
    begin
      if Proc.ClassOwner = AType then FindVisible := 1
      else
      if IsCompatibleScriptClasses(Proc.ClassOwner, AType) then
        FindVisible := 2;
    end;

    while AType <> nil do
    begin
      IO := AType.ClassObjects.Find(AMethodName, 0);
      if (IO <> nil) and (IO.IdentType = itProc) then
      begin
        IOVizible := IO.ClassWisibleStatus;
        if IOVizible = 0 then IOVizible := 3;
        if (IOVizible >= FindVisible) then
        begin
          Result := TSuProc(IO);
          Exit;
        end;
      end;
      AType := AType.Parent;
      if IOVizible = 1 then IOVizible := 2;
    end;
  end;
end;

procedure TDpCompiler.ObjectDataClear;
var
  I: Integer;
begin
  for I := 0 to FObjectData.Count - 1 do
  begin
    TObject(FObjectData.Items[I]).Free;
  end;
  FObjectData.Clear;
end;

procedure TDpCompiler.DoProgram;
var
  B: Boolean;
  IO: TIdentObject;
begin
  if Tokens.Count = 0 then Exit;
  if Tokens.Token.TokenID = ID_program then
  begin
    Tokens.UnitSection := usImplementation;
    Tokens.Next;
    if Tokens.Token.TokenID = ID_Identifier then
    begin
      //Имя программы
      if IsIdentDeclared(Tokens.Token.TokenName, Tokens.Token.HashValue, MainProc) then
      begin
        WriteError(FCurProc.FName, ceIdentifierRedeclared, Tokens.Token.TokenName);
      end
      else
      begin
        MainProc.Name := Tokens.Token.TokenName;
        MainProc.DeclUnit := Tokens.Token.TokenName;
        IO := TIdentObject.Create(Self);
        IO.Name := 'Result';
        IO.ValueType := DefaultType;
        MainProc.AddVar(IO, 0, 0);
        IO.IdentType := itParam;
        MainProc.FResultValue := IO;
        Tokens.Next;
        if Tokens.Token.TokenID = ID_SemiColon then
        begin
          Tokens.Next;
          B := DoBlock(MainProc);
          if B then
          begin
            if Assigned(FOnCompilerMessage) then CheckUseObject;
            if Tokens.Token.TokenID = ID_Period then
            begin
              TotalRow := TotalRow + Tokens.Token.Row;
              Tokens.Next;
              if Tokens.Token.TokenID <> ID_EOF then
              begin
                WriteError(MainProc.FName, ceSyntaxError, Tokens.Token.TokenName);
              end;
            end
            else
            begin
              WriteError(MainProc.FName, cePeriodExpected, '');
            end;
          end;
        end
        else
        begin
          WriteError(MainProc.FName, ceSemicolonExpected, '');
        end;
      end;
    end
    else
    begin
      WriteError(MainProc.FName, ceIdentifierExpected, '');
    end;
  end;
end;

function TDpCompiler.DoBlock(Proc: TSuProc): Boolean;
begin
  Result := True;
  while Tokens.Token.TokenID <> ID_EOF do
  begin
    case Tokens.Token.TokenID of
      ID_uses:
      begin
        Result := DoUses(Proc);
        if Result then
        begin
          Result := DoImplementation(Proc);
        end;
        if not Result then Exit;
      end;

      ID_type:
      begin

        Result := DoType(Proc);
        if not Result then Exit;
      end;

      ID_const:
      begin
        Result := DoConst(Proc);
        if not Result then Exit;
      end;

      ID_var:
      begin
        Result := DoVar(Proc);
        if not Result then Exit;
      end;

      ID_method, ID_constructor, ID_destructor, ID_procedure, ID_function:
      begin
        Result := DoMethod(Proc);
        if not Result then Exit;
      end;

      else
      begin
        Break;
      end;
    end;
  end;

  if Result then
  begin
    if Tokens.Token.TokenID = ID_begin then
    begin
      Result := DoCompoundStat(Proc, Proc.Code);
      if Tokens.Token.TokenID = ID_end then Tokens.Next
      else WriteError(Proc.DeclUnit, ceEndExpected, '');

    end
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceBeginExpected, '');
    end;
  end;
end;

procedure TDpCompiler.CheckUseObject;
var
  I: Integer;
  S: String;
  IO: TIdentObject;
begin
  if FErrors then Exit;

  for I := 0 to ObjectsDump.Count - 1 do
  begin
    IO := TIdentObject(ObjectsDump.Items[I]);

    if (IO.FIdentType in [itVar, itClassVar, itProc]) and
      (IO.FRow > 0) then
    begin

      if (IO.IdentType = itProc) and (IO.ValueType.BaseType <> btPointerProc) then
      begin
        if not TSuProc(IO).FImpl then
        begin
          S := 'Метод ' + IO.OriginalName + ' объявлен и не реализован';
          WriteHintWarning(IO.DeclUnit, S, IO.FCol, IO.FRow, dsmError);
        end;
      end
      else
      if not IO.FUse then
      begin
        S := 'Переменная ' + IO.OriginalName + ' объявлена и не использована';
        WriteHintWarning(IO.DeclUnit, S, IO.FCol, IO.FRow, dsmHint);
      end;
    end;
  end;
end;

function TDpCompiler.DoUses(Proc: TSuProc):Boolean;
begin
  Result := True;
  Tokens.Next;
  while True do
  begin
    if Tokens.Token.TokenID = ID_Identifier then
    begin
      Result := DoUnit(Proc);
    end
    else
      WriteError(Proc.DeclUnit, ceIdentifierExpected, '');

    if Tokens.Token.TokenID = ID_Comma then Tokens.Next
    else
    if Tokens.Token.TokenID = ID_SemiColon then
    begin
      Tokens.Next;
      Break;
    end
    else
    begin
      WriteError(Proc.DeclUnit, ceSemicolonExpected, '');
      Break;
    end;
  end;
end;

function TDpCompiler.DoUnit(Proc: TSuProc):Boolean;
var
  IO: TIdentObject;
  UnitProc: TUnitProc;
  Parser: TDpParser;
  SaveTokens: TTokensList;
  AName, S: TDpString;
   H: Cardinal;
begin
  Result := True;
  AName:= Tokens.Token.TokenName;
  H := Tokens.Token.HashValue;
  Tokens.Next;
  UnitProc := TUnitProc(Units.Find(AName, H));

  if UnitProc <> nil then
  begin
    //Tokens.Next;
    Proc.FUnits.Add(UnitProc);
    Exit;
  end;

  S := FOnGetUnitSource(AName);
  if S = '' then
  begin
    Result := False;
    WriteError(Proc.DeclUnit, ceUnknownIdentifier, AName);
    Exit;
  end;


  SaveTokens := Tokens;
  Tokens := nil;

  try
    Parser := TDpParser.Create(UseTranscription, FSuLanguage);
    try
      Parser.SetParseStr(S);
      Tokens := Parser.GetTokensList;
    finally
      Parser.Free;
    end;

    if Tokens.Token.TokenID = ID_Unit then
    begin
      Tokens.Next;
      if Tokens.Token.TokenID = ID_Identifier then
      begin
        //Имя модуля
        if IsIdentDeclared(Tokens.Token.TokenName, Tokens.Token.HashValue, Proc) then
        begin
          WriteError(Proc.FDeclUnit, ceIdentifierRedeclared, Tokens.Token.TokenName);
        end
        else
        begin
          UnitProc := TUnitProc.Create(Self);
          UnitProc.Name := Tokens.Token.TokenName;
          UnitProc.DeclUnit := Tokens.Token.TokenName;
          UnitProc.FUnitTokens := Tokens;
          Proc.FUnits.Add(UnitProc);
          Units.Add(UnitProc);
          //IO := TIdentObject.Create(Self);
          //IO.Name := 'Result';
          //IO.ValueType := DefaultType;
          //UnitProc.AddVar(IO, 0, 0);
          //IO.IdentType := itParam;
          //UnitProc.FResultValue := IO;
          Tokens.Next;
          if Tokens.Token.TokenID = ID_SemiColon then
          begin
            Tokens.Next;
            if Tokens.Token.TokenID = ID_Interface then Tokens.Next;

            Result := DoUnitInterface(UnitProc);
          end
          else
          begin
            WriteError(UnitProc.FName, ceSemicolonExpected, '');
          end;
        end;
      end
      else
      begin
        WriteError(UnitProc.FName, ceIdentifierExpected, '');
      end;
    end;
  finally
    Tokens := SaveTokens;
  end;
end;

function TDpCompiler.DoUnitInterface(Proc: TSuProc): Boolean;
begin
  Result := True;
  while Tokens.Token.TokenID <> ID_EOF do
  begin
    case Tokens.Token.TokenID of
      ID_uses:
      begin
        Result := DoUses(Proc);
        if not Result then Exit;
      end;

      ID_type:
      begin
        Result := DoType(Proc);
        if not Result then Exit;
      end;

      ID_const:
      begin
        Result := DoConst(Proc);
        if not Result then Exit;
      end;

      ID_var:
      begin
        Result := DoVar(Proc);
        if not Result then Exit;
      end;

      ID_Implementation:
      begin
        Tokens.Next;
        Tokens.UnitSection := usImplementation;
        Break;
      end;

      ID_method, ID_procedure, ID_function:
      begin
        DoMethod(Proc);
      end;

      {ID_Interface:
      begin
        Tokens.Next;
        Continue;
      end}

      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
        Break;
      end;
    end;
  end;
end;

function TDpCompiler.DoImplementation(Proc: TSuProc): Boolean;
var
  I: Integer;
  UP: TUnitProc;

  function DoImplement(UnitProc: TUnitProc): Boolean;
  var
    SaveTokens: TTokensList;
    UP2: TUnitProc;
    N: Integer;
  begin


    if UnitProc.FUnitCompiled then
    begin
      Result := True;
      Exit;
    end;
    SaveTokens := Tokens;
    try
      Tokens := UnitProc.FUnitTokens;
      UnitProc.FUnitCompiled := True;
      Result := DoUnitImplementation(UnitProc);
      UnitProc.FUnitTokens.Free;
      UnitProc.FUnitTokens := nil;
      if Result then
      begin
        for N := 0 to UnitProc.FUnits.Count - 1 do
        begin
          UP2 := TUnitProc(UnitProc.FUnits.Items[N]);
          DoImplement(UP2);
        end;
      end;
    finally
      Tokens := SaveTokens;
    end;
  end;

begin
  Result := True;
  UP := TUnitProc(Proc);
  for I := 0 to UP.FUnits.Count - 1 do
  begin
    Result := DoImplement(TUnitProc(UP.FUnits.Items[I]));
  end;
end;

function TDpCompiler.DoUnitImplementation(Proc: TSuProc): Boolean;
var
    AToken: TIdentToken;
begin
  Result := True;
  while Tokens.Token.TokenID <> ID_EOF do
  begin
    case Tokens.Token.TokenID of
      ID_uses:
      begin
        Result := DoUses(Proc);
        if Result then
        begin
          Result := DoImplementation(Proc);
        end;
        if not Result then Exit;
      end;

      ID_type:
      begin
        Result := DoType(Proc);
        if not Result then Exit;
      end;

      ID_const:
      begin
        Result := DoConst(Proc);
        if not Result then Exit;
      end;

      ID_var:
      begin
        Result := DoVar(Proc);
        if not Result then Exit;
      end;

      ID_method, ID_constructor, ID_destructor, ID_procedure, ID_function:
      begin
        Result := DoMethod(Proc);
        if not Result then Exit;
      end;

      else
      begin
        Break;
      end;
    end;
  end;

  if Result then
  begin
    if Tokens.Token.TokenID = ID_initialization then
    begin
      Tokens.UnitSection := usInitialization;
      Result := DoCompoundStat(Proc, Proc.Code);
    end;

    if Tokens.Token.TokenID = ID_end then
    begin
      Tokens.Next;
      if Tokens.Token.TokenID = ID_Period then
      begin
        TotalRow := TotalRow + Tokens.Token.Row;
        Tokens.Next;
        if Tokens.Token.TokenID <> ID_EOF then
          WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
      end
      else
      begin
        WriteError(Proc.DeclUnit, cePeriodExpected, '');
      end;
    end
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается завершение модуля (End)');
    end;
  end;
end;

function TDpCompiler.DoType(Proc: TSuProc):Boolean;
var
  AName: TDpString;
  T: TIdentToken;

  function DoClassType: Boolean;
  var
    AClassOf: TClass;
    AClassOfName: TDpString;
    AType, ATypeParent: TDpType;
    Status: Integer;
    ScriptRecord: Boolean;

    function DoClassObject: Boolean;
    var
      //CO: TClassComponent;
      IO: TIdentObject;
      IOName: TDpString;
      IOValType: TDpType;
      NamesList, ArrayBounds: TStringList;
      MinVal, MaxVal: Integer;
      VarClass: TIdentClass;
      ArrObj: TArrayObject;
      I, N, ACol, ARow: Integer;
      AI: Array of PtrInt;
    begin
      Result := True;
      NamesList := TStringList.Create;
      ArrayBounds := TStringList.Create;
      ARow := 0;
      ACol := 0;
      VarClass := nil;
      IO := nil;
      try
      while Tokens.Token.TokenID <> ID_EOF do
      begin
        IOName := Tokens.Token.TokenName;
        if (NamesList.Count = 0) or (Tokens.Token.Row <> ARow) then
        begin
          ACol := Tokens.Token.Col;
          ARow := Tokens.Token.Row;
        end;
        if AType.FClassObjects.Find(IOName, Tokens.Token.HashValue) <> nil then
          WriteError(Proc.DeclUnit, ceIdentifierRedeclared, IOName);
        NamesList.Add(string(IOName));
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Comma then
        begin
          Tokens.Next;
          Continue;
        end;
        if Tokens.Token.TokenID = ID_Colon then
        begin
          Tokens.Next;
          Break;
        end
        else
        begin
          Result := False;
          WriteError(Proc.DeclUnit, ceColonExpected, '');
          Exit;
        end;
      end;
      if Tokens.Token.TokenID = ID_Identifier then
      begin
        IOValType := FindType(Tokens.Token.TokenName, Proc, True);
        VarClass := GetIdentClass(IOValType);
        Tokens.Next;
      end
      else
      if Tokens.Token.TokenID = ID_set then
      begin
        Result := DoSetDeclaration(MinVal, MaxVal, IOValType, Proc);
        if IOValType = nil then IOValType := DefaultType;
        VarClass := TSetObject;
      end
      else
      if Tokens.Token.TokenID = ID_array then
      begin
        Result := DoArray(Proc, ArrayBounds, IOValType);
        VarClass := TArrayObject;
      end
      else
      begin
        WriteError(Proc.DeclUnit, ceTypeExpected, '');
        IOValType := DefaultType;
      end;

      if Status = 0 then
      begin
        if IOValType.BaseType = btClass then
        begin
          IO := TIdentObject.Create(Self);
          IO.Proc := Proc;
          IO.ValueType := IOValType;
          IO.Name := IOName;
          IO.IdentType := itClassComponent;
          IO.ClassOwner := AType;
          AType.FClassObjects.Add(IO);
        end
        else
        begin
          IO := TIdentObject.Create(Self);
          IO.Proc := Proc;
          IO.ValueType := IOValType;
          IO.Name := IOName;
          IO.IdentType := itClassVar;
          IO.ClassOwner := AType;
          AType.FClassObjects.Add(IO);
          WriteError(Proc.DeclUnit, ceCustomError, 'В этом разделе класса могут быть объявлены только дочерние компоненты');
        end;
        NamesList.Clear;
      end
      else
      begin
        for I := 0 to NamesList.Count - 1 do
        begin
          IO := VarClass.Create(Self);
          if IO is TSetObject then
          begin
            TSetObject(IO).ValueType := FindType('set', Proc, True);
            TSetObject(IO).RefType := IOValType;
          end
          else
          if IO is TArrayObject then
          begin
            ArrObj := TArrayObject(IO);
            ArrObj.DimCount := ArrayBounds.Count div 2;
            ArrObj.FDataType := IOValType;
            ArrObj.FValueType := ArrayType;
            if ArrObj.DimCount = 0 then
               ArrObj.FValue := VarArrayCreate([0, 0], varVariant)
            else
            begin
              SetLength(AI, ArrayBounds.Count);
              for N := 0 to ArrayBounds.Count - 1 do
                AI[N] := StrToInt(ArrayBounds.Strings[N]);
              ArrObj.FValue := VarArrayCreate(AI, varVariant);
              SetLength(AI, 0);
            end;
          end
          else
          begin
            IO.ValueType := IOValType;
          end;
          IO.Name := NamesList.Strings[I];
          IO.Proc := Proc;
          IO.IdentType := itClassVar;
          if IO is TPointerProc then IO.IdentType:= itProc;
          IO.ClassOwner := AType;
          IO.FCol := ACol;
          IO.FRow := ARow;
          AType.FClassObjects.Add(IO);
        end;
        NamesList.Clear;
      end;
      if IO <> nil then IO.ClassWisibleStatus := Status;
      finally
        NamesList.Free;
        ArrayBounds.Free;
      end;
    end;

    function DoClassProc: Boolean;
    var
      ClassProc: TSuProc;
      Param: TIdentObject;
      CP: TIdentObject;
      Constr: Boolean;
      ACol, ARow: Integer;
    begin
      Result := True;
      Constr := False;
      ACol := Tokens.Token.Col;
      ARow := Tokens.Token.Row;
      if Tokens.Token.TokenID = ID_constructor then Constr := True;
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Identifier then
        begin
          ClassProc := TSuProc.Create(Self);
          ClassProc.FCol := ACol;
          ClassProc.FRow := ARow;
          ClassProc.Proc := Proc;
          ClassProc.IdentType := itProc;
          ClassProc.ClassOwner := AType;
          ClassProc.Name := Tokens.Token.TokenName;
          ClassProc.FIsConstructor := Constr;
          if Constr then
          begin
            Param := TIdentObject.Create(Self);
            Param.Name := 'Self';
            Param.FValueType := AType;
            ClassProc.AddVar(Param, 0, 0);
            Param.IdentType := itParam;
            ClassProc.FValueType := AType;
            ClassProc.FDataObject := Param;
            ClassProc.FResultValue := Param;
          end
          else
          begin
            ClassProc.FValueType := DefaultType;
            CP := TIdentObject.Create(Self);
            CP.Name := 'Self';
            CP.ValueType := AType;
            ClassProc.AddVar(CP, Tokens.Token.Col, Tokens.Token.Row);
            CP.IdentType := itParam;
            ClassProc.FDataObject := CP;
          end;

          //ClassProc.DeclUnit := Proc.DeclUnit;

          Tokens.Next;
          Result := DoProcParam(ClassProc);
          if Result then
          begin
            if  Tokens.Token.TokenID = ID_Colon then
            begin
                ClassProc.FIsFunction := True;
                Tokens.Next;
                if Tokens.Token.TokenID = ID_Identifier then
                begin
                  Param := TIdentObject.Create(Self);
                  Param.Name := 'Result';
                  Param.FValueType := FindType(Tokens.Token.TokenName, Proc, True);
                  ClassProc.AddVar(Param, 0, 0);
                  Param.IdentType := itParam;
                  ClassProc.ValueType := Param.ValueType;
                  ClassProc.FResultValue := Param;
                  Tokens.Next;
                end
                else
                begin
                  WriteError(Proc.DeclUnit, ceTypeExpected, '');
                end;
            end;

          end;
          if ClassProc <> nil then
          begin
            ClassProc.ClassWisibleStatus := Status;
            AType.FClassObjects.Add(ClassProc);
          end;
        end
        else
        begin
          WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
        end;
    end;

    function DoScriptProp: Boolean;
    var
      SP: TScriptProp;
      SRead, SReadRu, SWrite, SWRiteRu: string;
    begin
      Result := True;
      Tokens.Next;
      if Tokens.Token.TokenID = ID_Identifier then
      begin
        if AType.FClassObjects.Find(Tokens.Token.TokenName, Tokens.Token.HashValue) <> nil then
          WriteError(Proc.DeclUnit, ceIdentifierRedeclared, Tokens.Token.TokenName);
        SP := TScriptProp.Create(Self);
        SP.FCol := Tokens.Token.Col;
        SP.FRow := Tokens.Token.Row;
        SP.Name := Tokens.Token.TokenName;
        SP.ClassOwner := AType;
        SP.ReadIdent := nil;
        SP.WriteIdent := nil;
        SP.OnlyRead := True;
        SP.IdentType := itClassProp;
        SP.ClassWisibleStatus := Status;
        SP.Proc := Proc;
        AType.FClassObjects.Add(SP);
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Colon then
        begin
          Tokens.Next;
          if Tokens.Token.TokenID = ID_Identifier then
          begin
            SP.ValueType := FindType(Tokens.Token.TokenName, Proc, True);
            Tokens.Next;
            SRead := 'read';
            SWrite := 'write';
            SReadRu := 'читать';
            SWRiteRu := 'писать';

            if (Tokens.Token.TokenID = ID_Identifier) and
              (((Tokens.Token.TokenName = SRead) or (Tokens.Token.TokenName = SReadRu))
              or ((Tokens.Token.TokenName = SWrite) or (Tokens.Token.TokenName = SWRiteRu))) then
            begin
              if (Tokens.Token.TokenName = SRead) or (Tokens.Token.TokenName = SReadRu) then
              begin
                Tokens.Next;
                if Tokens.Token.TokenID = ID_nil then
                begin
                  Tokens.Next;
                end
                else
                if Tokens.Token.TokenID = ID_Identifier then
                begin
                  SP.ReadIdent := AType.FClassObjects.Find(Tokens.Token.TokenName, Tokens.Token.HashValue);
                  if SP.ReadIdent = nil then
                  begin
                    Result := False;
                    WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
                  end
                  else
                  begin
                    if SP.ReadIdent.IdentType = itProc then
                    begin
                      if TSuProc(SP.ReadIdent).ParamCount > 0 then
                        WriteError(Proc.DeclUnit, ceInvalidnumberOfParameters, '');
                      if not TSuProc(SP.ReadIdent).FIsFunction then
                        WriteError(Proc.DeclUnit, ceCustomError, 'Этот метод должен быть функцией');
                    end;

                    if SP.ReadIdent.ValueType <> SP.ValueType then
                      WriteError(Proc.DeclUnit, ceTypeMismatch, SP.ValueType.OriginalName + ', ' + SP.ReadIdent.ValueType.OriginalName);

                  end;
                  Tokens.Next;
                end
                else
                begin
                  Result := False;
                  WriteError(Proc.DeclUnit, ceIdentifierExpected, '')
                end;

              end;

              if (Tokens.Token.TokenID = ID_Identifier) and
                 ((Tokens.Token.TokenName = swrite) or ((Tokens.Token.TokenName = SWRiteRu))) then
              begin
                Tokens.Next;
                if Tokens.Token.TokenID = ID_nil then
                begin
                  SP.OnlyRead := True;
                  Tokens.Next;
                end
                else
                if Tokens.Token.TokenID = ID_Identifier then
                begin
                  SP.WriteIdent := AType.FClassObjects.Find(Tokens.Token.TokenName, Tokens.Token.HashValue);
                  if SP.WriteIdent = nil then
                  begin
                    Result := False;
                    WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
                  end
                  else
                  begin
                    SP.OnlyRead := False;
                    if SP.WriteIdent.IdentType = itProc then
                    begin
                      if TDpCustomProc(SP.WriteIdent).ParamCount <> 1 then
                      begin
                        WriteError(Proc.DeclUnit, ceInvalidnumberOfParameters, '');
                      end
                      else
                      begin
                        if TDpCustomProc(SP.WriteIdent).Param[0].ValueType <> SP.ValueType then
                        begin
                          WriteError(Proc.DeclUnit, ceInvalidParameterType, '');
                        end;
                      end;
                    end
                    else
                    begin
                      if SP.WriteIdent.ValueType <> SP.ValueType then
                        WriteError(Proc.DeclUnit, ceTypeMismatch, SP.ValueType.OriginalName + ', ' + SP.WriteIdent.ValueType.OriginalName)
                      else
                      if SP.WriteIdent.IdentType = itClassComponent then
                        WriteError(Proc.DeclUnit, ceCustomError, 'Этот объект не может быть здесь использован');
                    end;
                  end;
                  Tokens.Next;
                end
                else
                begin
                  Result := False;
                  WriteError(Proc.DeclUnit, ceIdentifierExpected, '')
                end;
              end;


            end
            else
            begin
              Result := False;
              WriteError(Proc.DeclUnit, ceReadExpected, '')
            end;
          end
          else
          begin
            Result := False;
            WriteError(Proc.DeclUnit, ceTypeExpected, '')
          end;
        end
        else
        begin
          Result := False;
          WriteError(Proc.DeclUnit, ceColonExpected, '');
        end;
      end
      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceIdentifierExpected, '')
      end;
    end;

  begin
    Result := True;
    Status := 0;
    ScriptRecord := False;
    if Tokens.Token.TokenID = ID_record then
    begin
      Status := 3;
      ScriptRecord := True;
    end;

    Tokens.Next;
    AClassOf := TObject;
    AClassOfName := AClassOf.ClassName;
    ATypeParent := FindType(AClassOfName, Proc, True);
    if Tokens.Token.TokenID = ID_OpenRound then
    begin
      Tokens.Next;
      if Tokens.Token.TokenID = ID_Identifier then
      begin
        AClassOfName := Tokens.Token.TokenName;
        ATypeParent := FindType(AClassOfName, Proc, True);
        if ATypeParent.BaseType <> btClass then
          WriteError(Proc.DeclUnit, ceClassTypeExpected, '');
        AClassOf := ATypeParent.ValueClassType;
        Tokens.Next;
      end;
      if Tokens.Token.TokenID = ID_CloseRound then Tokens.Next
      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceCloseRoundExpected, '');
      end;
    end;
    AType := Proc.FTypeTable.Add(AName, btClass, AClassOf, ATypeParent, AClassOf.ClassInfo);
    AType.FDeclUnit:= Proc.OriginalName;
    AType.ScriptRec := ScriptRecord;
    AType.ScriptClass := True;
    if (AClassOf.ClassNameIs('TForm')) or (AClassOf.ClassNameIs('TDataModule'))
      or (AClassOf.InheritsFrom(TCustomFrame)) then
    begin
      AType.FResursName := AName;
      if ATypeParent.ScriptClass then AType.FResursName := ATypeParent.FResursName;
      FCompClasses.Add(AType);
    end;

    while Tokens.Token.TokenID <> ID_end do
    begin
      if Tokens.Token.TokenID = ID_private then
      begin
        Status := 1;
        Tokens.Next;
        Continue;
      end
      else
      if Tokens.Token.TokenID = ID_protected then
      begin
        Status := 2;
        Tokens.Next;
        Continue;
      end
      else
      if Tokens.Token.TokenID = ID_public then
      begin
        Status := 3;
        Tokens.Next;
        Continue;
      end;
      if Tokens.Token.TokenID = ID_Identifier then
      begin
        Result := DoClassObject;
      end
      else
      if Tokens.Token.TokenID = ID_property then
      begin
        Result := DoScriptProp;
      end
      else
      if Tokens.Token.TokenID in [ID_procedure, ID_function, ID_method,
        ID_constructor, ID_destructor] then
      begin
        Result := DoClassProc;
      end
      else
      begin
        WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
        Result := False;
        Break;
      end;

      if Tokens.Token.TokenID = ID_SemiColon then
      begin
        Tokens.Next;
        Continue;
      end
      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceSemicolonExpected, '');
        Break;
      end;

    end;

    if Tokens.Token.TokenID = ID_end then Tokens.Next
    else
    begin
      WriteError(Proc.DeclUnit, ceEndExpected, '');
      Result := False;
    end;
  end;

  {function DoRecord: Boolean;
  var
    AType: TDpType;
    RecSize: Integer;
  begin
    Result := True;
    RecSize := 0;
    AType := Proc.FTypeTable.Add(AName, btClass, nil, nil, nil);
    AType.ScriptClass := True;
    Tokens.Next;
    AType.Size := RecSize;
    Result := DoClassObject(AType, 3);
    if not Result then Exit
    else
    begin
      if Tokens.Token.TokenID = ID_end then Tokens.Next
      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceEndExpected, '');
      end;
    end;
  end;}

  function DoEnumType: Boolean;
  var
    AType: TDpType;
    IO: TIdentObject;
    I: Integer;
  begin
    Result := True;
    AType := Proc.FTypeTable.Add(AName, btEnum, nil, nil, nil);
    AType.FDeclUnit:= Proc.OriginalName;

    Result := DoEnumConst(Proc, AType);
  end;

  function DoSimpleType: Boolean;
  var
    AParent, AType: TDpType;
  begin
    Result := True;
    AParent := FindType(Tokens.Token.TokenName, Proc, True);
    AType := Proc.FTypeTable.Add(AName, AParent.BaseType, nil, AParent, nil);
    AType.FDeclUnit := Proc.OriginalName;
  end;

  function DoSetType: Boolean;
  var
    AType, ATypeOf: TDpType;

  begin
    Result := True;

    AType  := Proc.FTypeTable.Add(AName, btSet, nil, nil, nil);
    AType.FDeclUnit := Proc.OriginalName;
    Tokens.Next;

    if Tokens.Token.TokenID = ID_of then
      Tokens.Next
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceOfExpected, '');
    end;

    if Tokens.Token.TokenID = ID_Identifier then
    begin
      ATypeOf := FindType(Tokens.Token.TokenName, Proc, True);
      if ATypeOf <> nil then
      begin
        if ATypeOf.FBaseType = btEnum then
        begin
          AType.MinVal := ATypeOf.MinVal;
          AType.MaxVal := ATypeOf.MaxVal;
        end
        else
        begin
          WriteError(Proc.DeclUnit, ceErrorTypeInExpression, Tokens.Token.TokenName);
        end;
      end;
      Tokens.Next;
    end
    else
    if Tokens.Token.TokenID = ID_OpenRound then
    begin
      Result := DoEnumConst(Proc, AType);
    end
    else
    if Tokens.Token.TokenID = ID_Integer then
    begin
      AType.MinVal := StrToInt(Tokens.Token.TokenName);
      Tokens.Next;
      if Tokens.Token.TokenID = ID_Dots then
      begin
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Integer then
        begin
          AType.MaxVal := StrToInt(Tokens.Token.TokenName);
          Tokens.Next;
          if AType.MaxVal > 255 then
            WriteError(Proc.DeclUnit, ceCustomError, 'Значение не должно превышать 255');
        end
        else
          WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается константа целого типа');
      end
      else
      begin
        WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается ''..''');
        Result := False;
      end;
    end
    else
      WriteError(Proc.DeclUnit, ceTypeExpected, '');
  end;

  function DoProcType: Boolean;
  var
    AType: TDpType;
    ProcDecl: TSuProc;
    Param: TIdentObject;
  begin
    Result := True;
    AType := Proc.FTypeTable.Add(AName, btPointerProc, nil, nil, nil);
    Tokens.Next;
    ProcDecl := TSuProc.Create(Self);
    ProcDecl.Name := 'PointerProc';
    ProcDecl.DeclUnit:= Proc.DeclUnit;
    ProcDecl.Proc := Proc;
    ProcDecl.ValueType := DefaultType;
    AType.AddMethodObj(ProcDecl);
    Result := DoProcParam(ProcDecl);
    if Result then
    begin
      if Tokens.Token.TokenID = ID_Colon then
      begin
        ProcDecl.FIsFunction := True;
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Identifier then
        begin
          Param := TIdentObject.Create(Self);
          Param.Name := 'Result';
          Param.FValueType := FindType(Tokens.Token.TokenName, ProcDecl, True);
          ProcDecl.AddVar(Param, 0, 0);
          Param.IdentType := itParam;
          ProcDecl.ValueType := Param.ValueType;
          ProcDecl.FResultValue := Param;
          ProcDecl.FIsFunction := True;
          Tokens.Next;
        end
        else
        begin
          Result := False;
          WriteError(ProcDecl.DeclUnit, ceTypeExpected, '');
        end;
      end;
    end;
  end;

begin
  Result := True;
  Tokens.Next;
  if Tokens.Token.TokenID = ID_Identifier then
  begin
    while Tokens.Token.TokenID = ID_Identifier do
    begin
      AName := Tokens.Token.TokenName;
      if IsTypeExist(AName, Proc) then
        WriteError(Proc.DeclUnit, ceTypeRedeclared, '');
      Tokens.Next;
      T := Tokens.Token.TokenID;
      if FSuLanguage = slPascal then
      begin
        if T = ID_Equal then T := ID_Assignment;
      end;

      if T = ID_Assignment then
      begin
        Tokens.Next;
        case Tokens.Token.TokenID of
          ID_class, ID_record:
            Result := DoClassType;

          ID_OpenRound:
            Result := DoEnumType;

          ID_Identifier:
            Result := DoSimpleType;

          ID_set:
            Result := DoSetType;

          ID_method, ID_procedure, ID_function:
             Result := DoProcType;
        end;
        if not Result then Exit;
      end
      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается ''=''');
      end;
      if Tokens.Token.TokenID = ID_SemiColon then Tokens.Next
      else
      begin
        WriteError(Proc.DeclUnit, ceSemicolonExpected, '');
        Result := False;
        Break;
      end;
    end;
  end
  else
  begin
    Result := False;
    WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
  end;

end;

function TDpCompiler.DoEnumConst(Proc: TSuProc; aType: TDpType): Boolean;
var
  IO: TIdentObject;
  I: Integer;
begin
  Result := True;
  Tokens.Next;
  I := 0;
  while True do
  begin
    if Tokens.Token.TokenID = ID_Identifier then
    begin
      IO := TIdentObject.Create(Self);
      IO.Name := Tokens.Token.TokenName;
      IO.FValue := I;
      Inc(I);
      if (aType = nil) or (aType.BaseType = btSet) then
        IO.ValueType := IntegerType
      else
        IO.ValueType := aType;

      Proc.AddConst(IO);
      if aType <> nil then
        AType.FAtributes.Add(IO);
      Tokens.Next;
      if Tokens.Token.TokenID = ID_Comma then
      begin
        Tokens.Next;
        Continue;
      end
      else Break;
    end
    else
      Break;
  end;

  if Tokens.Token.TokenID = ID_CloseRound then
  begin
    Tokens.Next;
    Dec(I);
    if I < 0 then
    begin
      WriteError(Proc.DeclUnit, ceCustomError, 'Пустое перечисление');
      Result := False;
    end
    else
    begin
      if aType <> nil then
        aType.MaxVal := I;
    end;
  end
  else
  begin
    WriteError(Proc.DeclUnit, ceCloseRoundExpected, '');
    Result := False;
  end;
end;

function TDpCompiler.DoVar(Proc: TSuProc): Boolean;
var
  VarList, PosList: TStringList;
  I, N, MinVal, MaxVal, ACol, ARow: Integer;
  V: TIdentObject;
  Ar: TArrayObject;
  St: TSetObject;
  Bounds: TStringList;
  AValType: TDpType;
  VarClass: TIdentClass;
  AI: Array of PtrInt;
  IniValue: Variant;
  Init: Boolean;
  T: TIdentToken;
  AVarType: Word;

  procedure PosStrToPos(AStr: string);
  var
    AM, AL: Integer;
    AC: string;
  begin
    AM := LastDelimiter(',', AStr);
    if AM > 0 then
    begin
      AC := Copy(AStr, 1, AM - 1);
      ACol:= StrToInt(AC);
      AL := Length(AStr);
      AC := Copy(AStr, AM + 1, AL - AM);
      ARow:= StrToInt(AC);
    end;
  end;

begin
  Result := True;
  Tokens.Next;
  ARow := -1;
  ACol := 0;
  VarList := TStringList.Create;
  PosList := TStringList.Create;
  try
    while Tokens.Token.TokenID <> ID_SemiColon do
    begin
      if Tokens.Token.TokenID = ID_Identifier then
      begin
        if (VarList.Count = 0) or (Tokens.Token.Row <> ARow) then
        begin
          ACol := Tokens.Token.Col;
          ARow := Tokens.Token.Row;
        end;
        //Имя переменной
        if IsIdentDeclared(Tokens.Token.TokenName, Tokens.Token.HashValue, Proc) then
        begin
          WriteError(Proc.DeclUnit, ceIdentifierRedeclared, Tokens.Token.TokenName);
        end;
        VarList.Add(Tokens.Token.TokenName);
        PosList.Add(IntToStr(ACol) + ',' + IntToStr(ARow));
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Comma then
        begin
          //Ожидается следующая переменная
          Tokens.Next;
          Continue;
        end
        else
        if Tokens.Token.TokenID = ID_Colon then
        begin
          // ожидается тип переменной
          Tokens.Next;
          if Tokens.Token.TokenID in [ID_Identifier, ID_array, ID_set] then
          begin
            if Tokens.Token.TokenID = ID_set then
            begin
              Result := DoSetDeclaration(MinVal, MaxVal, AValType, Proc);
              I := 0;
              while I < VarList.Count do
              begin
                St := TSetObject.Create(Self);
                St.Name := VarList.Strings[I];
                St.ValueType := FindType('set', Proc, True);
                St.RefType := AValType;
                PosStrToPos(PosList.Strings[I]);
                Proc.AddVar(St, ACol, ARow);
                Inc(I);
              end;
              VarList.Clear;
              PosList.Clear;
            end
            else
            if Tokens.Token.TokenID = ID_array then
            begin
              I := 0;
              Bounds := TStringList.Create;
              try
                Result := DoArray(Proc, Bounds, AValType);
                if Result then
                begin
                  while I < VarList.Count do
                  begin
                    Ar := TArrayObject.Create(Self);
                    Ar.Name := VarList.Strings[I];
                    Ar.DimCount := Bounds.Count div 2;
                    Ar.FDataType := AValType;
                    Ar.FValueType := ArrayType;
                    Ar.FDinArray := False;
                    AVarType := GetVarTypeOfType(AValType.BaseType);
                    if Ar.DimCount = 0 then
                    begin
                      Ar.FDinArray := True;
                      Ar.FValue := VarArrayCreate([0, 0], AVarType)
                    end
                    else
                    begin
                      SetLength(AI, Bounds.Count);
                      for N := 0 to Bounds.Count - 1 do
                        AI[N] := StrToInt(Bounds.Strings[N]);
                      Ar.FValue := VarArrayCreate(AI, AVarType);
                      SetLength(AI, 0);
                    end;
                    PosStrToPos(PosList.Strings[I]);
                    Proc.AddVar(Ar, ACol, ARow);
                    Inc(I);
                  end;
                  VarList.Clear;
                  PosList.Clear;
                end;
              finally
                Bounds.Free;

              end;

            end
            else
            begin
              AValType := FindType(Tokens.Token.TokenName, Proc, True);
              IniValue := Unassigned;
              Init := False;
              T := Tokens.PreviewNext.TokenID;
              if (SuLanguage = slPascal) and (T = ID_Equal) then T := ID_Assignment;
              if T = ID_Assignment then
              begin
                Tokens.Next;
                Tokens.Next;
                V := DoExpression(Proc, False);
                Tokens.Prev;
                if V <> nil then
                begin
                  if not IsCompatibleTypes(V.ValueType, AValType, ID_Assignment) then
                  begin
                    WriteError(Proc.DeclUnit, ceTypeMismatch, AValType.OriginalName + ', ' + V.ValueType.FOriginalName);
                  end;
                  IniValue := V.Value;
                  Init := True;
                end;
              end;

              VarClass := GetIdentClass(AValType);

              I := 0;
              while I < VarList.Count do
              begin
                V := VarClass.Create(Self);
                //V.IdentType := itVar;
                V.Compiler := Self;
                V.Name := VarList.Strings[I];
                V.ValueType := AValType;
                V.FIniValue := IniValue;
                V.FInitObj := Init;
                if V.ValueType = nil then
                begin
                  WriteError(Proc.DeclUnit, ceUnknownType, Tokens.Token.TokenName);
                  V.ValueType := DefaultType;
                end;
                PosStrToPos(PosList.Strings[I]);
                if V.ValueType.BaseType = btPointerProc then
                  Proc.AddProc(V)
                else
                  Proc.AddVar(V, ACol, ARow);
                Inc(I);
              end;
              Tokens.Next;
            end;
            VarList.Clear;
            PosList.Clear;
            if Tokens.Token.TokenID = ID_SemiColon then
            begin
              //конец инструкции
              //Если следующий токен - идентификатор, продолжаем вводить переменные
              Tokens.Next;
              if Tokens.Token.TokenID = ID_Identifier then Continue
              else Break;
            end
            else
            begin
              WriteError(Proc.DeclUnit, ceSemicolonExpected, '');
              Result := False;
              Break;
            end;
          end
          else
          begin
            WriteError(Proc.DeclUnit, ceTypeExpected, '');
            Result := False;
            Break;
          end;
        end
        else
        begin
          WriteError(Proc.DeclUnit, ceColonExpected, '');
          Result := False;
          Break;
        end;
      end
      else
      begin
        WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
        Result := False;
        Break;
      end;
      Tokens.Next;
    end;
  finally
    VarList.Free;
    PosList.Free;
  end;
end;

function TDpCompiler.DoConst(Proc: TSuProc): Boolean;
var
  CName: TDpString;
  DSC, AVal: TIdentObject;
  T: TIdentToken;
begin
  Result := True;
  Tokens.Next;
  if Tokens.Token.TokenID = ID_Identifier then
  begin
    while Tokens.Token.TokenID = ID_Identifier do
    begin
      CName := Tokens.Token.TokenName;
      if IsIdentDeclared(CName, Tokens.Token.HashValue, Proc) then
        WriteError(Proc.DeclUnit, ceIdentifierRedeclared, CName);
      Tokens.Next;
      T := Tokens.Token.TokenID;
      if FSuLanguage = slPascal then
      begin
        if T = ID_Equal then T := ID_Assignment;
      end;
      if T = ID_Assignment then
      begin

        Tokens.Next;
        AVal := DoExpression(Proc, False);
        if AVal.IdentType in [itConst, itValue] then
        begin
          if AVal.ConstValue then
          begin
            DSC := AVal;
            DSC.ConstValue := False;
            DSC.FIdentType := itConst;
          end
          else
          begin
            DSC := TIdentObject.Create(Self);
            DSC.ValueType := AVal.ValueType;
            DSC.Value:= AVal.Value;
            DSC.FIdentType := itConst;
          end;
          DSC.Name := CName;
          DSC.FOnlyRead := True;
          Proc.AddConst(DSC);
        end
        else
          WriteError(Proc.DeclUnit, ceConstExpected, '');;

        if Tokens.Token.TokenID = ID_SemiColon then
        begin
          Tokens.Next;
          if Tokens.Token.TokenID = ID_Identifier then Continue
          else Break;
        end
        else
        begin
          WriteError(Proc.DeclUnit, ceSemicolonExpected, '');
          Result := False;
          Break;
        end;

      end
      else
      begin
        WriteError(Proc.DeclUnit, ceSyntaxError, '=');
        Result := False;
        Break;
      end;
      Tokens.Next;
    end;
  end
  else
  begin
    WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
    Result := False;
  end;
end;

function TDpCompiler.DoMethod(ParentProc: TSuProc): Boolean;
var
  DSP: TSuProc;
  Param, Ident: TIdentObject;
  AType: TDpType;
  ACol, ARow: Integer;
begin
  Result := True;
  DSP := nil;
  ACol := Tokens.Token.Col;
  ARow := Tokens.Token.Row;
  Tokens.Next;
  if Tokens.Token.TokenID = ID_Identifier then
  begin
    if Tokens.PreviewNext.TokenID = ID_Period then
    begin
      AType := FindType(Tokens.Token.TokenName, ParentProc, True);
      if AType <> nil then
      begin
        Tokens.Next;
        Tokens.Next;
        Ident := AType.FClassObjects.Find(Tokens.Token.TokenName, Tokens.Token.HashValue);
        if Ident = nil then
        begin
          Result := False;
          WriteError(ParentProc.DeclUnit, ceNoMethodInClass, Tokens.Token.TokenName);
          Exit;
        end;
        if Ident.IdentType <> itProc then
        begin
          Result := False;
          WriteError(ParentProc.DeclUnit, ceNoMethodInClass, Tokens.Token.TokenName);
          Exit;
        end;
        DSP := TSuProc(Ident);
        DSP.Proc := ParentProc;
        Tokens.Next;
        if Tokens.Token.TokenID = ID_OpenRound then
        begin
          Result := DoCheckParam(DSP);
        end;

        //----------------
        if Result then
        begin
          //Тип возвращаемого значения
          if Tokens.Token.TokenID = ID_Colon then
          begin
            Tokens.Next;
            if Tokens.Token.TokenID = ID_Identifier then
            begin
              AType := FindType(Tokens.Token.TokenName, ParentProc, True);
              if AType <> nil then
              begin
                if AType <> DSP.ValueType then
                begin
                  WriteError(DSP.DeclUnit, ceCustomError, 'Тип возвращаемого значения отличается от предыдущего объявления внутри класса');
                end;
              end;
              Tokens.Next;
            end
            else
            begin
              Result := False;
              WriteError(DSP.DeclUnit, ceTypeExpected, '');
            end;
          end;
        end;//if result
        //----------------

      end
      else
      begin
        Result := False;
        Exit;
      end;
    end
    else
    begin
      DSP := nil;
      if Tokens.UnitSection = usImplementation then
      begin
        Ident := ParentProc.FProcs.Find(Tokens.Token.TokenName, Tokens.Token.HashValue);
        if (Ident <> nil) and (Ident.IdentType = itProc) then
          DSP := TSuProc(Ident);
      end;

      if DSP <> nil then
      begin
        Tokens.Next;
        if Tokens.Token.TokenID = ID_OpenRound then
        begin
          Result := DoCheckParam(DSP);
        end;
        if Result then
        begin
          //Тип возвращаемого значения
          if Tokens.Token.TokenID = ID_Colon then
          begin
            Tokens.Next;
            if Tokens.Token.TokenID = ID_Identifier then
            begin
              AType := FindType(Tokens.Token.TokenName, ParentProc, True);
              if AType <> nil then
              begin
                if AType <> DSP.ValueType then
                begin
                  WriteError(DSP.DeclUnit, ceCustomError, 'Тип возвращаемого значения отличается от предыдущего объявления внутри класса');
                end;
              end;
              Tokens.Next;
            end
            else
            begin
              Result := False;
              WriteError(DSP.DeclUnit, ceTypeExpected, '');
            end;
          end;
        end;
      end
      else
      begin
        DSP := TSuProc.Create(Self);
        DSP.FCol := ACol;
        DSP.FRow := ARow;
        DSP.DeclUnit := ParentProc.DeclUnit;
        DSP.Compiler := Self;
        DSP.Proc := ParentProc;
        DSP.ValueType := DefaultType;
        if ParentProc.ClassOwner <> nil then
        begin
          DSP.ClassOwner := ParentProc.ClassOwner;
          if ParentProc.FDataObject <> nil then DSP.DataObject := ParentProc.DataObject;
        end;
        //Имя процедуры
        DSP.Name := Tokens.Token.TokenName;
        if IsIdentDeclared(Tokens.Token.TokenName, Tokens.Token.HashValue, ParentProc) then
          WriteError(DSP.DeclUnit, ceIdentifierRedeclared, Tokens.Token.TokenName);

        Tokens.Next;
        //Параметры
        Result := DoProcParam(DSP);
        ParentProc.AddProc(DSP);
        if Result then
        begin
          //Тип возвращаемого значения
          if Tokens.Token.TokenID = ID_Colon then
          begin
            DSP.FIsFunction := True;
            Tokens.Next;
            if Tokens.Token.TokenID = ID_Identifier then
            begin
              Param := TIdentObject.Create(Self);
              Param.Name := 'Result';
              Param.FValueType := FindType(Tokens.Token.TokenName, DSP, True);
              DSP.AddVar(Param, 0, 0);
              Param.IdentType := itParam;
              DSP.ValueType := Param.ValueType;
              DSP.FResultValue := Param;
              Tokens.Next;
            end
            else
            begin
              Result := False;
              WriteError(DSP.DeclUnit, ceTypeExpected, '');
            end;
          end;
        end; //if result
      end; //if DSP <> nil
    end;

    if Result then
    begin
        if Tokens.Token.TokenID = ID_SemiColon then
        begin
          Tokens.Next;
          if Tokens.UnitSection = usInterface then Exit;
          if Tokens.Token.TokenID = ID_Forward then
          begin
            Tokens.Next;
            if Tokens.Token.TokenID = ID_SemiColon then
              Tokens.Next
            else
              WriteError(DSP.DeclUnit, ceSemicolonExpected, '');
            Exit;
          end;

          Result := DoBlock(DSP);
          if Result then
          begin
            DSP.FImpl := True;
            if Tokens.Token.TokenID = ID_SemiColon then Tokens.Next
            else
            begin
              //Result := False;
              WriteError(DSP.DeclUnit, ceSemicolonExpected, '');
            end;
          end;
        end
        else
        begin
          Result := False;
          WriteError(DSP.DeclUnit, ceSemicolonExpected, '');
        end;
    end;
  end
  else
  begin
    Result := False;
    WriteError(DSP.DeclUnit, ceIdentifierExpected, '');
  end;
end;

function TDpCompiler.DoCompoundStat(Proc: TSuProc; ACode: TDpCode): Boolean;
begin
  Result := True;
  Tokens.Next;
  while Tokens.Token.TokenID <> ID_EOF do
  begin
    Result := DoStatment(Proc, ACode);
    if not Result then Break;

      case Tokens.Token.TokenID of
        ID_SemiColon:
        begin
          Result := True;
          Tokens.Next;
          Continue;
        end;

        ID_end, ID_Except, ID_Finally, ID_until, ID_else, ID_elseif:
        begin
          if Tokens.Token.TokenID in [ID_Except, ID_Finally] then
          begin
            if not (ACode is TTryInstruction) then
              WriteError(Proc.DeclUnit, ceCustomError, 'Инструкция ' + Tokens.Token.TokenName + ' не может быть применена без Try')
          end
          else
          if Tokens.Token.TokenID = ID_until then
          begin
            if not (ACode is TRepeatInstruction) then
              WriteError(Proc.DeclUnit, ceCustomError, 'Инструкция ' + Tokens.Token.TokenName + ' не может быть применена без Repeat')
          end
          else
          if Tokens.Token.TokenID in [ID_else, ID_elseif] then
          begin
            if not ((ACode.ParentCode <> nil) and (ACode is TIfInstruction)) then
              WriteError(Proc.DeclUnit, ceSyntaxError, 'else применен неуместно');
          end
          else
          if Tokens.Token.TokenID = ID_end then
          begin
            //Tokens.Next;
            Result := True;
            //Break;
          end
          else
          begin
            Result := False;
            WriteError(Proc.DeclUnit, ceEndExpected, '');
            //Break;
          end;
          Break;
        end;

        else
        begin
          Result := False;
          WriteError(Proc.DeclUnit, ceSemicolonExpected, '');
          if Tokens.Token.TokenID in [ID_Identifier, ID_if, ID_while, ID_for] then
            Continue else Break;
        end;
      end;
  end;
end;

function TDpCompiler.DoStatment(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  Token: TIdentToken;
begin
  Result := True;
  Token := Tokens.Token.TokenID;
  case Token of

    ID_Identifier, ID_inherited, ID_OpenRound: Result := DoAssignmentStatment(Proc, ACode);

    ID_begin:
    begin
      Result := DoCompoundStat(Proc, ACode);
      if Tokens.Token.TokenID <> ID_end then
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceEndExpected, '');
      end
      else
        Tokens.Next;
    end;

    ID_if: Result := DoIf(Proc, ACode);

    ID_case: Result := DoCase(Proc, ACode);

    ID_while: Result := DoWhile(Proc, ACode);

    ID_repeat: Result := DoRepeat(Proc, ACode);

    ID_for: Result := DoFor(Proc, ACode);

    ID_with: Result := DoWith(Proc, ACode);

    ID_Try: Result := DoTry(Proc, ACode);

    ID_Exit: Result := DoExit(Proc, ACode);

    ID_Break: Result := DoBreak(Proc, ACode);

    ID_Continue: Result := DoContinue(Proc, ACode);

  end;
end;

function TDpCompiler.DoAssignmentStatment(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  ALeft, ARight: TIdentObject;
  Ident: TIdentObject;
  AType: TDpType;
  AI: TAssignInstruction;
  CI: TCallInstrcution;
  II: TIncInstruction;
  IAI: TIncAssignInstruction;
  //DI: TDecInstruction;
  DC: TDispInstruction;
  ACol, ARow: Integer;
  Inh, CallProc: Boolean;
  AProc, PProc: TDpCustomProc;
  I: Integer;
begin
  Result := True;
  Inh := False;
  ACol := Tokens.Token.Col;
  ARow := Tokens.Token.Row;
  Ident := nil;
  if Tokens.Token.TokenID = ID_inherited then
  begin
    Inh := True;
    Tokens.Next;
  end;

  if Tokens.Token.TokenID = ID_OpenRound then
  begin
     Tokens.Next;
     Ident := DoExpression(Proc, False);
     if Tokens.Token.TokenID <> ID_CloseRound then
     begin
        Ident := nil;
        WriteError(Proc.DeclUnit, ceCloseRoundExpected, '');
     end;
  end;

  if (Ident = nil) and (WithIO <> nil) and (WithIO.ValueType.BaseType in [btClass, btRecord]) then
  begin
    if WithIO.ValueType.BaseType = btClass then
    begin
      Ident := WithIO.ValueType.FindClassObject(Tokens.Token.TokenName, Inh);
      if Ident = nil then
      begin
        if GetPropInfo(WithIO.ValueType.ValueClassType, Tokens.Token.TokenName) <> nil then
          Ident := WithIO;
      end;

      if Ident <> nil then
      begin
        Tokens.Prev;
        Ident := DoClassProperty(Ident, Ident.ValueType, Proc, False);
        Tokens.Prev;
      end;
    end
    else
    if WithIO.ValueType.BaseType = btRecord then
    begin
      Ident := WithIO.ValueType.FindClassObject(Tokens.Token.TokenName, Inh);
      if Ident <> nil then
      begin
        Ident := DoRecField(WithIO, Proc);
        Tokens.Prev;
      end
      else Ident := nil;
    end;
  end;



  if Ident = nil then
    Ident := GetIdent(Tokens.Token.TokenName, Tokens.Token.HashValue, Proc);

  if Ident = nil then
  begin
    AType := FindType(Tokens.Token.TokenName, Proc, False);
    if AType <> nil then
    begin
      Ident := DoTypeCast(Proc, AType, True);
      Tokens.Prev;
    end
    else
    if Proc.ClassOwner <> nil then
    begin
      Ident := Proc.ClassOwner.FindClassObject(Tokens.Token.TokenName, Inh);
      if Ident = nil then
      begin
        if (WithIO <> nil) and (WithIO.ValueType.BaseType = btDisp) then
        begin
          if GetPropInfo(Proc.ClassOwner.ValueClassType, Tokens.Token.TokenName) <> nil then
          begin
            Ident := DoClassProperty(nil, nil, Proc, False);
            Tokens.Prev;
          end
          else
          begin
            Tokens.Prev;
            Ident := DoDispatch(WithIO, Proc);
            Tokens.Prev;
          end;
        end
        else
        begin
          Ident := DoClassProperty(nil, nil, Proc, False);
          Tokens.Prev;
        end;
      end
      else
      if Ident.IdentType = itProp then
      begin
        Ident := Proc.FDataObject;
        Tokens.Prev;
        Ident := DoClassProperty(Ident, Ident.ValueType, Proc, False);
        Tokens.Prev;
      end
      else
      if Ident.IdentType in [itClassVar, itClassProp] then
      begin
        {if Ident.ValueType.BaseType = btRecord then
          Ident := DoRecField(Ident, Proc)
        else}
          Ident := DoClassProperty(Ident, Ident.ValueType, Proc, False);
        Tokens.Prev;
      end;
    end;
  end;

  if (Ident = Proc) and (Tokens.PreviewNext.TokenID = ID_Assignment) then
    Ident := Proc.FResultValue;

  if Ident = nil then
  begin
    WriteError(Proc.DeclUnit, ceUnknownIdentifier, Tokens.Token.TokenName);
    if Tokens.PreviewNext.TokenID = ID_Assignment then
    begin
      Ident := TIdentObject.Create(Self);
      Ident.FValueType := DefaultType;
      Proc.AddErrObject(Ident);
    end
    else
    if (Tokens.Items[Tokens.Pos + 2].TokenID = ID_OpenRound) or
      (Tokens.Items[Tokens.Pos + 2].TokenID = ID_SemiColon) then
    begin
      Ident := TSuProc.Create(Self);
      Ident.Name := Tokens.Token.TokenName;
      Proc.AddErrObject(Ident);
      Ident.FIdentType := itProc;
    end
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceAssignmentExpected, '');
      Exit;
    end;
  end;

  if Ident <> nil then
  begin
    if (Ident.FIdentType = itVar) or (Ident.FIdentType = itParam) or (Ident.IdentType = itProp)
      or (Ident.IdentType = itClassVar) or (Ident.IdentType = itClassComponent)
      or (Ident.IdentType = itProc) or (Ident is TProcCaller)
      or ((Ident.IdentType = itValue) and (Ident is TSimpleExpression)) then
    begin
      CallProc := True;

      if Ident.ValueType.BaseType = btPointerProc then
      begin
        if Tokens.PreviewNext.TokenID = ID_Assignment then CallProc := False;
      end;

      if (Ident.FIdentType = itProc) and CallProc then
      begin
        if TSuProc(Ident).FIsConstructor and Inh then
        begin
          ALeft := Proc.FDataObject;
          ARight := DoCallMethod(Proc, TSuProc(Ident), Proc.FDataObject, True);
          AI := TAssignInstruction.Create(Proc, ACol, ARow);
          AI.Left := ALeft;
          AI.Right := ARight;
          ACode.Add(AI);
          Exit;
        end
        else
          Ident := DoCallMethod(Proc, TSuProc(Ident), Proc.FDataObject, inh);
        Tokens.Prev;
      end;

      if (Ident.ValueType.BaseType in [btArray, btString, btVariant, btDisp]) and
         (Tokens.PreviewNext.TokenID = ID_OpenBlock) then
      begin
        Tokens.Next;
        Ident := DoIndexedVar(Proc, Ident);
      end;

      Tokens.Next;
      if (Tokens.Token.TokenID = ID_Period) then
      begin
        if Ident.ValueType.BaseType = btClass then
          Ident := DoClassProperty(Ident, Ident.ValueType, Proc, False)
        else
        if (Ident.ValueType.BaseType = btDisp) then
          Ident := DoDispatch(Ident, Proc)
        else
        if Ident.ValueType.BaseType = btRecord then
          Ident := DoRecField(Ident, Proc)
        else
          WriteError(Proc.DeclUnit, ceSyntaxError, '');

        if (Ident.ValueType.BaseType in [btArray, btString, btVariant]) and
         (Tokens.Token.TokenID = ID_OpenBlock) then
        begin
           Ident := DoIndexedVar(Proc, Ident);
           Tokens.Next;
        end;
      end;

      if Tokens.Token.TokenID in [ID_Inc, ID_Dec] then
      begin
        if not (Ident.ValueType.BaseType in [btInt, btFloat]) then
          WriteError(Proc.DeclUnit, ceOperatorNoAcceptOperandTip, '');
        II := TIncInstruction.Create(Proc, ACol, ARow);
        II.FIdent := Ident;
        II.IncValue := 1;
        if Tokens.Token.TokenID = ID_Dec then II.IncValue := -1;
        ACode.Add(II);
        Tokens.Next;
      end
      else
      if Tokens.Token.TokenID in [ID_IncAssign, ID_DecAssign] then
      begin
        if not (Ident.ValueType.BaseType in [btInt, btFloat, btString, btSet]) then
          WriteError(Proc.DeclUnit, ceOperatorNoAcceptOperandTip, '');
        IAI := TIncAssignInstruction.Create(Proc, ACol, ARow);
        IAI.FIdent := Ident;
        IAI.FPlus := True;
        if Tokens.Token.TokenID = ID_DecAssign then IAI.FPlus := False;
        Tokens.Next;
        ACode.Add(IAI);
        ARight := DoExpression(Proc, False);
        if ARight <> nil then
        begin
          if not IsCompatibleTypes(Ident.ValueType, ARight.ValueType, ID_Assignment) then
            WriteError(Proc.DeclUnit, ceTypeMismatch, Ident.ValueType.OriginalName + ', ' + ARight.ValueType.OriginalName);
          IAI.IncValue := ARight;
        end;
      end
      else
      if Tokens.Token.TokenID = ID_Assignment then
      begin
        Tokens.Next;
        if Ident.OnlyRead then WriteError(Proc.DeclUnit, ceReadOnlyVar, Ident.OriginalName);
        ALeft := Ident;

        ARight := DoExpression(Proc, False);

        if ALeft.ValueType.BaseType = btPointer then
          AI := TSetAdresInstruction.Create(Proc, ACol, ARow)
        else
        if ALeft.ValueType.BaseType = btEvent then
          AI := TMethodAssignInstruction.Create(Proc, ACol, ARow)
        else
        if ALeft is TArrayExpression then
          AI := TArrayAssignInstruction.Create(Proc, ACol, ARow)
        else
          AI := TAssignInstruction.Create(Proc, ACol, ARow);
        AI.Left := Ident;
        AI.Right := ARight;
        if (AI.Right.ValueType.BaseType = btDisp)
        and (AI.Left.ValueType.BaseType = btVariant) then
          AI.Left.ValueType := FindType('idispatch', Proc, True);

        if (ARight is TProcCaller)
          and (ARight.ValueType.BaseType = btPointerProc) then
          ARight := TPointerProc( TProcCaller(ARight).CallProc).DeclProc;

        if not IsCompatibleTypes(Ident.ValueType, ARight.ValueType, ID_Assignment) then
          WriteError(Proc.DeclUnit, ceTypeMismatch,
          Ident.ValueType.OriginalName + ', ' + ARight.ValueType.OriginalName);

        if ALeft is TPointerProc then
        begin
          if ARight is TAdresExpression then
          begin
            if TAdresExpression(ARight).AssignedValue and (TIdentObject(TSuPtr(ARight.Value)) is TDpCustomProc) then
            begin
              PProc := TPointerProc(ALeft).DeclProc;
              AProc := TDpCustomProc(TSuPtr(ARight.Value));

              if PProc.FIsFunction then
              begin
                if not AProc.FIsFunction then
                  WriteError(Proc.DeclUnit, ceProcFunctionExpected, AProc.OriginalName)
                else
                begin
                  if not IsCompatibleTypes(PProc.ValueType, AProc.ValueType, ID_Assignment) then
                    WriteError(Proc.DeclUnit, ceErrorTypeInExpression, '');
                end
              end
              else
              begin
                if AProc.FIsFunction then
                  WriteError(Proc.DeclUnit, ceFuncProcExpected, AProc.OriginalName);
              end;

              if AProc.ParamCount <> PProc.ParamCount then
                WriteError(Proc.DeclUnit, ceInvalidnumberOfParameters, '')
              else
              begin
                for I := 0 to PProc.ParamCount - 2 do
                begin
                  if not IsCompatibleTypes(PProc.Param[I].ValueType, AProc.Param[I].ValueType, ID_Assignment) then
                      WriteError(Proc.DeclUnit, ceInvalidParameterType, '');
                end;
              end
            end
            else
              WriteError(Proc.DeclUnit, ceProcPointer, '');
          end;
        end;

        ACode.Add(AI);
      end
      else
      if Ident is TProcCaller then
      begin
        CI := TCallInstrcution.Create(Proc, ACol, ARow);
        CI.FProcCaller := TProcCaller(Ident);
        ACode.Add(CI);
      end
      else
      if Ident is TDispExpression then
      begin
        DC := TDispInstruction.Create(Proc, ACol, ARow);
        DC.FDispExpr := TDispExpression(Ident);
        ACode.Add(DC);
      end
      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceAssignmentExpected, '');
      end;
    end
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceVariableExpected, '');
    end;
  end;
end;

function TDpCompiler.DoSetDeclaration(var MinVal, MaxVal: Integer;
  var RefType: TDpType; Proc: TSuProc): Boolean;
begin
  Result := True;
  Tokens.Next;
  MinVal := 0;
  MaxVal := 255;
  if Tokens.Token.TokenID = ID_of then
  begin
    Tokens.Next;
    if Tokens.Token.TokenID = ID_Identifier then
    begin
      RefType := FindType(Tokens.Token.TokenName, Proc, True);
      if RefType.FBaseType = btEnum then
      begin
          MinVal := RefType.MinVal;
          MaxVal := RefType.MaxVal;
      end
      else
      if not ((RefType.Name = 'char') or (RefType.Name = 'byte')) then
          WriteError(Proc.DeclUnit, ceCustomError, 'Множество не может быть задано с типом ' + Tokens.Token.TokenName);
      Tokens.Next;
    end
    else
    if Tokens.Token.TokenID = ID_OpenRound then
    begin
      Result := DoEnumConst(Proc, nil);
    end
    else
    if Tokens.Token.TokenID = ID_Integer then
    begin
      MinVal := StrToInt(string(Tokens.Token.TokenName));
      Tokens.Next;
      if Tokens.Token.TokenID = ID_Dots then
      begin
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Integer then
        begin
          MaxVal := StrToInt(string(Tokens.Token.TokenName));
          Tokens.Next;
        end
        else
          WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается константа ''Целого'' типа')
      end
    end
    else
      WriteError(Proc.DeclUnit, ceUnknownType, Tokens.Token.TokenName);
  end
  else
  begin
    WriteError(Proc.DeclUnit, ceOfExpected, '');
    Result := False;
  end;
end;

function TDpCompiler.DoCheckParam(Proc: TSuProc): Boolean;
var
   Status: Integer;
   ValType: TDpType;
   T: TIdentToken;
   SList: TStringList;
begin
  Result := True;
  if Tokens.Token.TokenID <> ID_OpenRound then
  begin
    if Proc.ParamCount > 0 then
      WriteError(Proc.DeclUnit, ceCustomError, 'Базовое объявление метода отличается от текущего');
    Exit;
  end;
  Tokens.Next;
  if Tokens.Token.TokenID = ID_CloseRound then
  begin
    if Proc.ParamCount > 0 then
      WriteError(Proc.DeclUnit, ceCustomError, 'Базовое объявление метода отличается от текущего');
     Exit;
  end;
  Status := 0;

  while Tokens.Token.TokenID <> ID_EOF do
  begin
      case Status of
        0:
        begin
          //Проверяем как передается параетр
          if Tokens.Token.TokenID in [ID_var, ID_out] then
          begin
              Tokens.Next;
          end
          else
          if Tokens.Token.TokenID = ID_const then
          begin
              Tokens.Next;
          end;

          Status := 1;
          Continue;
        end;

        1:
        begin
          //Ожидается имя переменной или )
          if Tokens.Token.TokenID = ID_Identifier then
          begin
            Status := 2;
          end
          else
          begin
            Result := False;
            WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
            Break;
          end;
        end;

        2:
        begin
          //Ожидается , или :
          if Tokens.Token.TokenID = ID_Comma then Status := 1
          else
          if Tokens.Token.TokenID = ID_Colon then Status := 3;
        end;

        3:
        begin
          //Ожидается тип параметра
          if Tokens.Token.TokenID = ID_array then
          begin
            SList := TStringList.Create;
            try
              DoArray(Proc, SList, ValType);
              Tokens.Prev;
            finally
              SList.Free;
              Status := 4;
            end;
          end
          else
          if Tokens.Token.TokenID = ID_Identifier then
          begin
            ValType := FindType(Tokens.Token.TokenName, Proc, True);
            T := Tokens.PreviewNext.TokenID;
            if (SuLanguage = slPascal) and (T = ID_Equal) then T := ID_Assignment;
            if T = ID_Assignment then
            begin
              while Tokens.Token.TokenID in [ID_SemiColon, ID_CloseRound] do
                Tokens.Next;
            end;
              //ValType = nil then WriteError(Proc.DeclUnit, ceUnknownType, '');
            Status := 4;
          end
          else
          begin
            Result := False;
            WriteError(Proc.DeclUnit, ceTypeExpected, '');
            Break;
          end;
        end;

        4:
        begin
          if Tokens.Token.TokenID = ID_CloseRound then
          begin
            Tokens.Next;
            Break;
          end
          else
          if Tokens.Token.TokenID = ID_SemiColon then Status := 0;
        end;
      end;

      Tokens.Next;
    end;
end;

function TDpCompiler.DoIf(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  IfInstr: TIfInstruction;
begin
  Tokens.Next;
  IfInstr := TIfInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(IfInstr);
  IfInstr.FCondition := DoExpression(Proc, False);
  if IfInstr.FCondition.ValueType.BaseType <> btBool then
    WriteError(Proc.DeclUnit, ceErrorTypeInExpression, '');

  if Tokens.Token.TokenID = ID_then then
  begin
    if FSuLanguage = slPPlus then
    begin
      if Tokens.PreviewNext.TokenID = ID_begin then
      begin
        Tokens.Next;
        WriteHintWarning(Proc.DeclUnit, ch_BadBegin, Tokens.Token.Col, Tokens.Token.Row, dsmHint);
      end;
      Result := DoCompoundStat(Proc, IfInstr);

      if Tokens.Token.TokenID = ID_else then
      begin
        if Tokens.PreviewNext.TokenID = ID_begin then Tokens.Next;
        Result := DoCompoundStat(Proc, IfInstr.FFalseCode);
        if Tokens.Token.TokenID = ID_end then Tokens.Next
        else WriteError(Proc.DeclUnit, ceEndExpected, '');
      end
      else
      if Tokens.Token.TokenID = ID_elseif then
      begin
        Result := DoIf(Proc, IfInstr.FalseCode);
      end
      else
      if Tokens.Token.TokenID = ID_end then
        Tokens.Next
      else WriteError(Proc.DeclUnit, ceEndExpected, '');
    end
    else
    begin
      Tokens.Next;
      Result := DoStatment(Proc, IfInstr);
      if Tokens.Token.TokenID = ID_else then
      begin
        Tokens.Next;
        Result := DoStatment(Proc, IfInstr.FFalseCode);
      end;
    end;
  end
  else
  begin
    WriteError(Proc.DeclUnit, ceThenExpected, '');
    Result := False;
  end;
end;

function TDpCompiler.DoCase(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  IO: TIdentObject;
  CI: TCaseInstruction;
  CC: TCaseCode;
begin
  Result := True;
  Tokens.Next;
  CI := TCaseInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(CI);
  IO := DoSimpleExpression(Proc, False);
  CI.FCaseValue := IO;
  if Tokens.Token.TokenID = ID_of then
  begin
    Tokens.Next;
    while True do
    begin
      if Tokens.Token.TokenID = ID_end then Break
      else
      if Tokens.Token.TokenID = ID_else then
      begin
        Tokens.Next;
        DoStatment(Proc, CI.ElseCode);
        if Tokens.Token.TokenID = ID_SemiColon then Tokens.Next
        else WriteError(Proc.DeclUnit, ceSemicolonExpected, '');
        Break;
      end
      else
      begin
        CC := TCaseCode.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
        CI.Add(CC);

        while True do
        begin
          IO := DoFactor(Proc, False);
          if IO.IdentType <> itConst then
            WriteError(Proc.DeclUnit, ceConstExpected, '')
          else
          begin
            CC.AddValue(IO.FValue);
            if not IsCompatibleTypes(CI.FCaseValue.ValueType, IO.FValueType, ID_Assignment) then
              WriteError(Proc.DeclUnit, ceTypeMismatch, CI.FCaseValue.ValueType.OriginalName + ', ' + IO.FValueType.OriginalName);
            if IO.IdentType = itValue then
            begin
              ObjectsDump.Delete(IO.FIndex);
              IO.Free;
            end;


          end;

          if Tokens.Token.TokenID = ID_Comma then
          begin
            Tokens.Next;
            Continue;
          end
          else
          if Tokens.Token.TokenID = ID_Colon then
          begin
            Tokens.Next;
            Break;
          end
          else
          begin
            Result := False;
            WriteError(Proc.DeclUnit, ceColonExpected, '');
            Break;
          end;
        end;

        if Result then
        begin
          Result := DoStatment(Proc, CC);
          if Tokens.Token.TokenID = ID_SemiColon then Tokens.Next
          else WriteError(Proc.DeclUnit, ceSemicolonExpected, '');
        end
        else Break;
      end;
    end;

    if Tokens.Token.TokenID = ID_end then Tokens.Next
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceEndExpected, '');
    end;
  end
  else
  begin
    Result := False;
    WriteError(Proc.DeclUnit, ceOfExpected, '');
  end;
end;

function TDpCompiler.DoWhile(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  WI: TWhileInstruction;
begin
  Tokens.Next;
  WI := TWhileInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  WI.Proc := Proc;
  ACode.Add(WI);
  WI.FCondition := DoExpression(Proc, False);

  if WI.Condition.ValueType.BaseType <> btBool then
    WriteError(Proc.DeclUnit, ceErrorTypeInExpression, '');

  if Tokens.Token.TokenID = ID_do then
  begin
    if FSuLanguage = slPPlus then
    begin
      if Tokens.PreviewNext.TokenID = ID_begin then
      begin
        Tokens.Next;
        WriteHintWarning(Proc.DeclUnit, ch_BadBegin, Tokens.Token.Col, Tokens.Token.Row, dsmHint);
      end;
      Result := DoCompoundStat(Proc, WI);
      if Tokens.Token.TokenID = ID_end then Tokens.Next
      else WriteError(Proc.DeclUnit, ceEndExpected, '');
    end
    else
    begin
      Tokens.Next;
      Result := DoStatment(Proc, WI);
    end;
  end
  else
  begin
    Result := False;
    WriteError(Proc.DeclUnit, ceDoExpected, '');
  end;
end;

function TDpCompiler.DoFor(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  ForInstr: TForInstruction;
begin
  Result := True;
  Tokens.Next;
  ForInstr := TForInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(ForInstr);
  ForInstr.Assign.Left := GetIdent(Tokens.Token.TokenName, Tokens.Token.HashValue, Proc);
  if ForInstr.Assign.Left = nil then
  begin
    WriteError(Proc.DeclUnit, ceUnknownIdentifier, '');
    ForInstr.Assign.Left := TIdentObject.Create(Self);
    ForInstr.Assign.Left.FValueType := IntegerType;
    Proc.FErrorObjects.Add(ForInstr.Assign.Left);
  end;
  if ForInstr.Assign.Left.ValueType.BaseType <> btInt then
    WriteError(Proc.DeclUnit, ceCustomError, 'Идентификатор должени иметь ''Целый'' тип');

  Tokens.Next;
  if Tokens.Token.TokenID = ID_Assignment then
  begin
    Tokens.Next;
    ForInstr.Assign.Right := DoSimpleExpression(Proc, False);
    if ForInstr.Assign.Right.ValueType.BaseType <> btInt then
      WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается значение ''Целого'' типа');

    if Tokens.Token.TokenID in [ID_to, ID_downto] then
    begin

      if Tokens.Token.TokenID = ID_downto then ForInstr.IsDown := True;
      Tokens.Next;
      ForInstr.ToValue := DoSimpleExpression(Proc, False);
      if ForInstr.ToValue.ValueType.BaseType <> btInt then
        WriteError(Proc.DeclUnit, ceCustomError, 'Ожидается значение ''Целого'' типа');

      if Tokens.Token.TokenID = ID_do then
      begin
        if FSuLanguage = slPPlus then
        begin
          if Tokens.PreviewNext.TokenID = ID_begin then
          begin
            Tokens.Next;
            WriteHintWarning(Proc.DeclUnit, ch_BadBegin, Tokens.Token.Col, Tokens.Token.Row, dsmHint);
          end;
          DoCompoundStat(Proc, ForInstr);
          if Tokens.Token.TokenID = ID_end then Tokens.Next
          else WriteError(Proc.DeclUnit, ceEndExpected, '')

        end
        else
        begin
          Tokens.Next;
          DoStatment(Proc, ForInstr);
        end;
      end
      else
      begin
        Result := False;
        WriteError(Proc.DeclUnit, ceDoExpected, '');
      end;

    end
    else
    begin
      WriteError(Proc.DeclUnit, ceToExpected, '');
      Result := False;
    end;

  end
  else
  begin
    Result := False;
    WriteError(Proc.DeclUnit, ceAssignmentExpected, '');
  end;
end;

function TDpCompiler.DoRepeat(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  RI: TRepeatInstruction;
begin
  RI := TRepeatInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(RI);
  Result := DoCompoundStat(Proc, RI);
  if Result then
  begin
    if Tokens.Token.TokenID = ID_until then
    begin
      Tokens.Next;
      if RI.FDebugInfo <> nil then
      begin
        RI.FDebugInfo.Col := Tokens.Token.Col;
        RI.FDebugInfo.Row := Tokens.Token.Row;
      end;
      RI.FCondition := DoExpression(Proc, False);
      if RI.Condition.ValueType.BaseType <> btBool then
        WriteError(Proc.DeclUnit, ceErrorTypeInExpression, '');
    end
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceUntilExpected, '');
    end;
  end;
end;

function TDpCompiler.DoBreak(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  BI: TBreakInstruction;
  ParentCode, ICode: TDpCode;
begin
  Result := TRue;
  BI := TBreakInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(BI);
  ParentCode := nil;
  ICode := ACode;
  while ICode.ParentCode <> nil do
  begin
    if (ICode is TWhileInstruction) or (ICode is TRepeatInstruction)
      or (ICode is TForInstruction) then
    begin
      ParentCode := ICode;
    end;
    ICode := ICode.ParentCode;
  end;
  if ICode = nil then
      WriteError(Proc.DeclUnit, ceBreakNotInCycle, '');
  BI.FInstruction := ParentCode;
  Tokens.Next;
end;

function TDpCompiler.DoContinue(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  CI: TContinueInstruction;
  ParentCode, ICode: TDpCode;
begin
  Result := True;
  CI := TContinueInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(CI);
  ParentCode := nil;
  ICode := ACode;
  while ICode.ParentCode <> nil do
  begin
    if (ICode is TWhileInstruction) or (ICode is TRepeatInstruction)
      or (ICode is TForInstruction) then
    begin
      ParentCode := ICode;
    end;
    ICode := ICode.ParentCode;
  end;
  if ICode = nil then
      WriteError(Proc.DeclUnit, ceContinueNotInCycle, '');
  CI.FInstruction := ParentCode;
  Tokens.Next;
end;

function TDpCompiler.DoExit(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  EI: TExitInstruction;
begin
  Result := True;
  EI := TExitInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(EI);
  Tokens.Next;
end;

function TDpCompiler.DoWith(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  IO: TIdentObject;
  WithInstr: TWithInstruction;
begin
  Result := True;
  Tokens.Next;
  WithInstr := TWithInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(WithInstr);

  while Tokens.Token.TokenID <> ID_EOF do
  begin

    case Tokens.Token.TokenID of

      ID_Identifier:
      begin
        IO := DoFactor(Proc, False);
        if IO = nil then
        begin
          WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
          Result := False;
          Break;
        end
        else
        begin
          WithInstr.WithList.Add(IO);
          //Tokens.Next;
          if Tokens.Token.TokenID = ID_Colon then
          begin
            Tokens.Next;
            Continue;
          end
          else Break;
        end;
      end;

      else Break;
    end;
  end;

  if Result then
  begin
    if Tokens.Token.TokenID = ID_do then
    begin
      WithIO := TIdentObject(WithInstr.WithList.Items[0]);
      if SuLanguage = slPPlus then
      begin
        if Tokens.PreviewNext.TokenID = ID_begin then
        begin
          Tokens.Next;
          WriteHintWarning(Proc.DeclUnit, ch_BadBegin, Tokens.Token.Col, Tokens.Token.Row, dsmHint);
        end;
        Result := DoCompoundStat(Proc, WithInstr);
        if Tokens.Token.TokenID = ID_end then Tokens.Next
        else WriteError(Proc.DeclUnit, ceEndExpected)
      end
      else
      begin
        Tokens.Next;
        Result := DoStatment(Proc, WithInstr);
      end;
      WithIO := nil;
    end
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceDoExpected, '');
    end;
  end;
end;

function TDpCompiler.DoTry(Proc: TSuProc; ACode: TDpCode): Boolean;
var
  TI: TTryInstruction;
begin
  TI := TTryInstruction.Create(Proc, Tokens.Token.Col, Tokens.Token.Row);
  ACode.Add(TI);
  Result := DoCompoundStat(Proc, TI);
  //if Tokens.Token.TokenID = ID_SemiColon then Tokens.Next;
  if Result then
  begin
    if Tokens.Token.TokenID in [ID_Except, ID_Finally] then
    begin
      if Tokens.Token.TokenID = ID_Except then  TI.FExcept := True;
      if Tokens.PreviewNext.TokenID = ID_On then
      begin
        Tokens.Next;
        Tokens.Next;
        if Tokens.Token.TokenID = ID_Identifier then
        begin
          TI.Ex := GetIdent(Tokens.Token.TokenName, Tokens.Token.HashValue, Proc);
          if TI.Ex = nil then
          begin
            TI.Ex := TIdentObject.Create(Self);
            TI.Ex.Name := Tokens.Token.TokenName;
            Proc.AddVar(TI.Ex, Tokens.Token.Col, Tokens.Token.Row);
            Tokens.Next;
            if Tokens.Token.TokenID = ID_Colon then
            begin
              Tokens.Next;
              if Tokens.Token.TokenID = ID_Identifier then
              begin
                TI.Ex.ValueType := FindType(Tokens.Token.TokenName, nil, True);
                if TI.Ex.ValueType = nil then TI.Ex.ValueType := DefaultType
                else
                begin
                  if UseTranscription then
                  begin
                    if (TI.Ex.ValueType.Name <> 'исключение') and (TI.Ex.ValueType.Name <> 'exception') then
                      WriteError(Proc.DeclUnit, ceErrorTypeInExpression, TI.Ex.ValueType.Name)
                  end
                  else
                  if TI.Ex.ValueType.Name <> 'exception' then
                  begin
                    WriteError(Proc.DeclUnit, ceErrorTypeInExpression, TI.Ex.ValueType.Name);
                  end;
                end;
              end;
            end
            else
            begin
              Result := False;
              WriteError(Proc.DeclUnit, ceColonExpected, '');
              Exit;
            end;
          end
          else
          begin
            if TI.Ex.ValueType.Name <> 'exception' then
            begin
              Result := False;
              WriteError(Proc.DeclUnit, ceErrorTypeInExpression, TI.Ex.ValueType.Name);
              Exit;
            end;
          end;
          if Tokens.PreviewNext.TokenID = ID_do then Tokens.Next;
        end
        else
        begin
          Result := False;
          WriteError(Proc.DeclUnit, ceIdentifierExpected, '');
          Exit;
        end;
      end;
      Result := DoCompoundStat(Proc, TI.ErrCode);
      if Tokens.Token.TokenID = ID_end then Tokens.Next
      else WriteError(Proc.DeclUnit, ceEndExpected, '')

    end
    else
    begin
      Result := False;
      WriteError(Proc.DeclUnit, ceExceptFinallyExpected, '');
    end;
  end;
end;

function TDpCompiler.IsCompatibleTypes(T1, T2: TDpType; Oper: TIdentToken): Boolean;
var
  S1, S2: string;
begin
  Result := False;

  if Oper = ID_in then
  begin
    Result := (T1.BaseType in [btEnum, btInt, btChar, btArray, btVariant, btSet]) and
      (T2.BaseType = btSet);
    Exit;
  end
  else
  if Oper in [ID_shl, ID_shr] then
  begin
    Result := (T1.BaseType = btInt) and (T2.BaseType = btInt);
    Exit;
  end;

  if (T1.BaseType = btRecord) and (T2.BaseType = btRecord) then
  begin
    Result := T1.Name = T2.Name;
    Exit;
  end;

  if Oper in [ID_Plus] then
  begin
    case T1.FBaseType of
      btVariant: Result := True;
      btInt, btFloat: Result := T2.FBaseType in [btInt, btVariant, btEnum, btArray, btDisp, btFloat];
      btString, btChar: Result := T2.BaseType in [btString, btChar, btVariant, btDisp];
      btSet: Result := T2.BaseType = btSet;
      btEnum: Result := T2.FBaseType in [btEnum, btInt, btVariant, btDisp];
    end;
    Exit;
  end;

  if Oper in [ID_Minus, ID_Multiply, ID_Divide] then
  begin
    case T1.FBaseType of
      btVariant: Result := True;
      btInt, btFloat:
        Result := T2.FBaseType in [btInt, btVariant, btEnum, btArray, btDisp, btFloat];
      btSet: Result := T2.FBaseType = btSet;
      btEnum: Result := (T2.FBaseType in [btEnum, btInt, btVariant, btDisp]) and (Oper in [ID_Minus, ID_Multiply]);
    end;
    Exit;
  end;

  if Oper in [ID_div, ID_mod, ID_shl, ID_shr] then
  begin
    if T1.FBaseType in [btInt, btEnum, btVariant] then Result := T2.FBaseType in [btInt, btEnum,  btVariant];
    Exit;
  end;

  //if Oper = ID_Assignment then
  //begin
  //  if T1.BaseType = btInt then
  //  begin
  //    Result := T2.FBaseType in [btInt, btVariant, btEnum, btArray, btDisp];
  //    Exit;
  //  end;
  //end;

  case T1.FBaseType of
    btSet: Result := T2.BaseType = btSet;
    btInt: Result := T2.FBaseType in [btInt, btVariant, btEnum, btArray, btDisp];
    btFloat: Result := T2.FBaseType in [btInt, btFloat, btVariant, btDisp];
    btBool: Result := T2.FBaseType in [btBool, btVariant, btDisp];
    btChar:
    begin
      if Oper = ID_Plus then
        Result := T2.FBaseType in [btChar, btVariant, btString, btDisp]
      else
        Result := T2.FBaseType in [btChar, btVariant, btDisp]
    end;
    btString: Result := T2.FBaseType in [btChar, btString, btVariant, btDisp];
    btClass:
      if T1 = T2 then
        Result := True
      else
      if T1.ScriptClass then
        Result := IsCompatibleScriptClasses(T1, T2)
      else
      if T2.BaseType = btIntf then
        Result := Supports(T1.ValueClassType, GetTypeData(T2.ATypeInfo)^.Guid)
      else
        Result := (T2.FBaseType = btPointer) or ((T2.FBaseType = btClass) and
         IsCompatibleClasses(T1.ValueClassType, T2.ValueClassType));
    btArray:
    begin
      //Result := T2.FBaseType in [btArray, btVariant];
      Result := True;
    end;
    btVariant, btDisp: Result := True;
    btEnum:
    begin
      if T2.FBaseType = btEnum then Result := CompareText(string(T1.FName), string(T2.FName)) = 0;
    end;
    btEvent:
    begin
      Result := TRue;
    end;
    btPointer:
    begin
      Result := True;
    end;
    btIntf:
    begin
      Result := False;
      if T2.BaseType = btClass then
        Result := Supports(T2.ValueClassType, GetTypeData(T1.ATypeInfo)^.Guid)
      else
      if T2.BaseType = btIntf then
      begin
        S1 := GUIDToString(GetTypeData(T1.ATypeInfo)^.Guid);
        S2 := GUIDToString(GetTypeData(T2.ATypeInfo)^.Guid);
        Result := S2 = S1;
      end;
    end;
    btOrdinal:
    begin
      Result := T2.BaseType in [btOrdinal, btInt, btBool, btEnum, btChar];
    end;
    btPointerProc:
      Result := True;
  end;
end;

function TDpCompiler.IsCompatibleClasses(C1, C2: TClass): Boolean;
begin
  Result := C2.InheritsFrom(C1);
end;

function TDpCompiler.IsCompatibleScriptClasses(C1, C2: TDpType): Boolean;
var
  C: TDpType;
begin
  Result := False;
  if C2.BaseType = btPointer then
  begin
    Result := True;
    Exit;
  end
  else
  if C2.BaseType = btIntf then
  begin
    Result := Supports(C1.ValueClassType, GetTypeData(C2.ATypeInfo)^.Guid);
    Exit;
  end;


  if C2.ScriptClass then
  begin
    C := C2;
    while C <> nil do
    begin
      if C = C1 then
      begin
        Result := True;
        Break;
      end;
      C := C.Parent;
    end;
  end;

end;

procedure TDpCompiler.RegisterHandler(AType: PTypeInfo; HandlerClass: TDpEventHandlerClass);
var
  RegHandlerObject: TdpEventHandlerReg;
begin
  Add_TypeInfo(AType);
  RegHandlerObject := TdpEventHandlerReg.Create;
  RegHandlerObject.AType := AType;
  RegHandlerObject.AHandlerClass := HandlerClass;
  EventHandlerRegList.Add(RegHandlerObject);
end;

procedure TDpCompiler.Notification(AComponent: TComponent; Operation: TOperation
  );
begin
  if (Operation = opRemove) and (AComponent <> Self) then
  begin
    DeleteObjectData(AComponent);
  end;
  inherited Notification(AComponent, Operation);
end;

procedure TDpCompiler.AddClassImport(AClass: TClassImpoerterClass);
var
  IClass: TClassImporter;
begin
  IClass := AClass.Create;
  IClass.Compiler := Self;
  FImportList.Add(IClass);
  IClass.AddSimpleTypes(@Add_SimpleType);
  IClass.AddTypes(@Add_TypeInfo);
  IClass.AddClasses(@Add_Class, @Add_Record);
  IClass.AddConsts(@Add_Const);
  IClass.RegisterHandlers(@RegisterHandler);
  IClass.AddMethods(@Add_Method);
  IClass.AddVars(@Add_Var);
  IClass.AddObjects(@Add_Object);
end;

end.

