unit ActionPanel;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs;

type

  TActionPanel = class;

  { TActionPanelItem }

  TActionPanelItem = class(TCollectionItem)
  private
    FCaption: TCaption;

    procedure SetCaption(AValue: TCaption);
  protected
    FActionPanel: TActionPanel;
  public
    constructor Create(ACollection: TCollection); override;
  published
    property Caption: TCaption read FCaption write SetCaption;
  end;

  { TActionPanelCollection }

  TActionPanelCollection = class(TCollection)
  private
  protected
    FActionPanel: TActionPanel;
  public
    constructor Create(APanel: TActionPanel; aItemClass: TCollectionItemClass);
    property ActionPanel: TActionPanel read FActionPanel;
  end;


  TActionPanel = class(TCustomControl)
  private
    FTitleWidth: Integer;
    procedure SetTitleWidth(AValue: Integer);
  protected
    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); override;
  published
    property TitleWidth: Integer read FTitleWidth write SetTitleWidth;
  end;

implementation

{ TActionPanel }

procedure TActionPanel.SetTitleWidth(AValue: Integer);
begin
  if FTitleWidth=AValue then Exit;
  FTitleWidth:=AValue;
end;

constructor TActionPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 300;
  Height := 200;
  FTitleWidth := 150;
end;

{ TActionPanel }

{ TActionPanelCollection }

constructor TActionPanelCollection.Create(APanel: TActionPanel;
  aItemClass: TCollectionItemClass);
begin
  inherited Create(aItemClass);
  FActionPanel := APanel;
end;

{ TActionPanelItem }

procedure TActionPanelItem.SetCaption(AValue: TCaption);
begin
  if FCaption=AValue then Exit;
  FCaption:=AValue;
  FActionPanel.Invalidate;
end;

constructor TActionPanelItem.Create(ACollection: TCollection);
begin
  inherited Create(ACollection);
  FActionPanel := TActionPanelCollection(ACollection).ActionPanel;
end;

end.
