unit suibdac;

interface

uses SysUtils, Classes, dpCompil, TypInfo, Variants, Dialogs;

{$M+}

type

  { TIBDacImport }

  TIBDacImport = class(TClassImporter)
    function ConnectionList_GetCount(Instance: Pointer): Variant;
    function ConnectionList_ItemsGet(Instence: TObject; var Params: Variant
      ): Variant;
    function CustomIBCDataSet_CreateBlobStream(Instence: TObject;
      var Params: Variant): Variant;
    function CustomIBCDataSet_CreateProcCall(Instence: TObject;
      var Params: Variant): Variant;
    function CustomIBCDataSet_FindParam(Instence: TObject; var Params: Variant
      ): Variant;
    function CustomIBCDataSet_GetCursor(Instance: Pointer): Variant;
    function CustomIBCDataSet_GetIsQuery(Instance: Pointer): Variant;
    function CustomIBCDataSet_GetPlan(Instance: Pointer): Variant;
    function CustomIBCDataSet_GetRowsDeleted(Instance: Pointer): Variant;
    function CustomIBCDataSet_GetRowsFetched(Instance: Pointer): Variant;
    function CustomIBCDataSet_GetRowsInserted(Instance: Pointer): Variant;
    function CustomIBCDataSet_GetRowsUpdated(Instance: Pointer): Variant;
    function CustomIBCDataSet_GetSQLType(Instance: Pointer): Variant;
    function CustomIBCDataSet_GetSQLTypeEx(Instance: Pointer): Variant;
    function CustomIBCDataSet_ParamByName(Instence: TObject; var Params: Variant
      ): Variant;
    function CustomIBCDataSet_QueryKeyFields(Instence: TObject;
      var Params: Variant): Variant;
    function IBCAlerter_SendEvent(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCArrayField_AsArrayGet(Instance: Pointer): Variant;
    function IBCArray_GetItemType(Instance: Pointer): Variant;
    procedure IBCArray_SetItemType(Instance: Pointer; AValue: Variant);
    function IBCBlob_CloseBlob(Instence: TObject; var Params: Variant): Variant;
    function IBCBlob_LengthBlob(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCConnection_AddTransaction(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCConnection_AssignConnect(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCConnection_CommitRetaining(Instence: TObject;
      var Params: Variant): Variant;
    function IBCConnection_CreateDatabase(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCConnection_DBSQLDialect(Instance: Pointer): Variant;
    function IBCConnection_DropDatabase(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCConnection_FindDefaultTransaction(Instence: TObject;
      var Params: Variant): Variant;
    function IBCConnection_GetGeneratorNames(Instence: TObject;
      var Params: Variant): Variant;
    function IBCConnection_GetHandle(Instance: Pointer): Variant;
    function IBCConnection_GetLastError(Instance: Pointer): Variant;
    function IBCConnection_HandleIsShared(Instance: Pointer): Variant;
    function IBCConnection_IsReadOnly(Instance: Pointer): Variant;
    function IBCConnection_ParamByName(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCConnection_RemoveTransaction(Instence: TObject;
      var Params: Variant): Variant;
    function IBCConnection_RollbackRetaining(Instence: TObject;
      var Params: Variant): Variant;
    procedure IBCConnection_SetHandle(Instance: Pointer; AValue: Variant);
    procedure IBCConnection_SetLastError(Instance: Pointer; AValue: Variant);
    function IBCConnection_SQL(Instance: Pointer): Variant;
    function IBCConnection_TransactionCount(Instance: Pointer): Variant;
    function IBCConnection_TransactionsGet(Instence: TObject;
      var Params: Variant): Variant;
    function IBCParams_FindParam(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCParams_ItemsGet(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCParams_ItemsSet(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCParams_ParamByName(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCParam_AsArrayGet(Instance: Pointer): Variant;
    procedure IBCParam_AsArraySet(Instance: Pointer; AValue: Variant);
    function IBCParam_AsIbBlobGet(Instance: Pointer): Variant;
    procedure IBCParam_AsIbBlobSet(Instance: Pointer; AValue: Variant);
    function IBCParam_NumericScaleGet(Instance: Pointer): Variant;
    procedure IBCParam_NumericScaleSet(Instance: Pointer; AValue: Variant);
    function IBCParam_PrecisionGet(Instance: Pointer): Variant;
    procedure IBCParam_PrecisionSet(Instance: Pointer; AValue: Variant);
    function IBCScript_ExecuteScript(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCScript_Params(Instance: Pointer): Variant;
    function IBCSQL_BreakExec(Instence: TObject; var Params: Variant): Variant;
    function IBCSQL_CreateProcCall(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCSQL_ExecQuery(Instence: TObject; var Params: Variant): Variant;
    function IBCSQL_ExecuteNext(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCSQL_FindParam(Instence: TObject; var Params: Variant): Variant;
    function IBCSQL_GetHandle(Instance: Pointer): Variant;
    function IBCSQL_GetPlan(Instance: Pointer): Variant;
    function IBCSQL_GetSQLType(Instance: Pointer): Variant;
    function IBCSQL_GetSQLTypeEx(Instance: Pointer): Variant;
    function IBCSQL_GetText(Instance: Pointer): Variant;
    function IBCSQL_ParamByName(Instence: TObject; var Params: Variant
      ): Variant;
    procedure IBCSQL_SetText(Instance: Pointer; AValue: Variant);
    function IBCSStoredProc_ExecProc(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCSStoredProc_PrepareSQL(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCTransaction_AddConnection(Instence: TObject; var Params: Variant
      ): Variant;
    function IBCTransaction_CommitRetaining(Instence: TObject;
      var Params: Variant): Variant;
    function IBCTransaction_ConnectionsCount(Instance: Pointer): Variant;
    function IBCTransaction_FindDefaultConnection(Instence: TObject;
      var Params: Variant): Variant;
    function IBCTransaction_GetHandle(Instance: Pointer): Variant;
    function IBCTransaction_HandleIsShared(Instance: Pointer): Variant;
    function IBCTransaction_ReleaseSavepoint(Instence: TObject;
      var Params: Variant): Variant;
    function IBCTransaction_RemoveConnection(Instence: TObject;
      var Params: Variant): Variant;
    function IBCTransaction_RollbackRetaining(Instence: TObject;
      var Params: Variant): Variant;
    function IBCTransaction_RollbackSavepoint(Instence: TObject;
      var Params: Variant): Variant;
    procedure IBCTransaction_SetHandle(Instance: Pointer; AValue: Variant);
    function IBCTransaction_StartSavepoint(Instence: TObject;
      var Params: Variant): Variant;
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    //procedure AddConsts(AddConst: TAddConstProc); override;
    //procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
    //procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
  published

  end;

implementation

uses IBC, DBAccess, DB, IBCScript, IBDacVCL, //MemDS,
  DAScript, IBCSQLMonitor, DASQLMonitor, MemData, IBCServices,
  IBCAlerter, IBCLoader, IBCAdmin, IBCClasses, IBCArray;


type

  { TIBCAlertEventHandler }

  TIBCAlertEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; EventName: string; EventCount: Integer);
  end;

{ TIBCAlertEventHandler }

function TIBCAlertEventHandler.GetHandlerAdres: Pointer;
begin
  Result:= @TIBCAlertEventHandler.CallHandler;
end;

procedure TIBCAlertEventHandler.CallHandler(Sender: TObject; EventName: string;
  EventCount: Integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := EventName;
  Proc.Param[2].Value := EventCount;
  Proc.Exec;
end;

{TIBDacImport}

function TIBDacImport.ConnectionList_GetCount(Instance: Pointer): Variant;
begin
  Result := TConnectionList(Instance).Count;
end;

function TIBDacImport.ConnectionList_ItemsGet(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TConnectionList(Instence).Items[Params[0]]);
end;

function TIBDacImport.CustomIBCDataSet_CreateBlobStream(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomIBCDataSet(Instence).CreateBlobStream(TField(TSuPtr(Params[0])), Params[1]));
end;

function TIBDacImport.CustomIBCDataSet_CreateProcCall(Instence: TObject;
  var Params: Variant): Variant;
begin
  TCustomIBCDataSet(Instence).CreateProcCall(Params[0]);
end;

function TIBDacImport.CustomIBCDataSet_FindParam(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomIBCDataSet(Instence).FindParam(Params[0]));
end;

function TIBDacImport.CustomIBCDataSet_GetCursor(Instance: Pointer): Variant;
begin
  Result := TCustomIBCDataSet(Instance).Cursor;
end;

function TIBDacImport.CustomIBCDataSet_GetIsQuery(Instance: Pointer): Variant;
begin
  Result := TCustomIBCDataSet(Instance).IsQuery;
end;

function TIBDacImport.CustomIBCDataSet_GetPlan(Instance: Pointer): Variant;
begin
  Result := TCustomIBCDataSet(Instance).Plan;
end;

function TIBDacImport.CustomIBCDataSet_GetRowsDeleted(Instance: Pointer
  ): Variant;
begin
  Result := TCustomIBCDataSet(Instance).RowsDeleted;
end;

function TIBDacImport.CustomIBCDataSet_GetRowsFetched(Instance: Pointer
  ): Variant;
begin
  Result := TCustomIBCDataSet(Instance).RowsFetched;
end;

function TIBDacImport.CustomIBCDataSet_GetRowsInserted(Instance: Pointer
  ): Variant;
begin
  Result := TCustomIBCDataSet(Instance).RowsInserted;
end;

function TIBDacImport.CustomIBCDataSet_GetRowsUpdated(Instance: Pointer
  ): Variant;
begin
  Result := TCustomIBCDataSet(Instance).RowsUpdated;
end;

function TIBDacImport.CustomIBCDataSet_GetSQLType(Instance: Pointer): Variant;
begin
  Result := TCustomIBCDataSet(Instance).SQLType;
end;

function TIBDacImport.CustomIBCDataSet_GetSQLTypeEx(Instance: Pointer): Variant;
begin
  Result := TCustomIBCDataSet(Instance).SQLTypeEx;
end;

function TIBDacImport.CustomIBCDataSet_ParamByName(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomIBCDataSet(Instence).ParamByName(Params[0]));
end;

function TIBDacImport.CustomIBCDataSet_QueryKeyFields(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomIBCDataSet(Instence).QueryKeyFields(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TIBDacImport.IBCAlerter_SendEvent(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCAlerter(Instence).SendEvent(Params[0]);
end;

function TIBDacImport.IBCArrayField_AsArrayGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBCArrayField(Instance).AsArray);
end;

function TIBDacImport.IBCArray_GetItemType(Instance: Pointer): Variant;
begin
  Result := TIBCArray(Instance).ItemType;
end;

procedure TIBDacImport.IBCArray_SetItemType(Instance: Pointer; AValue: Variant);
begin
  TIBCArray(Instance).ItemType := AValue;
end;

function TIBDacImport.IBCBlob_CloseBlob(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TIBCBlob(Instence).CloseBlob;
end;

function TIBDacImport.IBCBlob_LengthBlob(Instence: TObject; var Params: Variant
  ): Variant;
begin
   Result := TIBCBlob(Instence).LengthBlob;
end;

function TIBDacImport.IBCConnection_AddTransaction(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBCConnection(Instence).AddTransaction(TIBCTransaction(TSuPtr(Params[0])));
end;

function TIBDacImport.IBCConnection_AssignConnect(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCConnection(Instence).AssignConnect(TIBCConnection(TSuPtr(Params[0])));
end;

function TIBDacImport.IBCConnection_CommitRetaining(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCConnection(Instence).CommitRetaining;
end;

function TIBDacImport.IBCConnection_CreateDatabase(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCConnection(Instence).CreateDatabase;
end;

function TIBDacImport.IBCConnection_DBSQLDialect(Instance: Pointer): Variant;
begin
  Result := TIBCConnection(Instance).DBSQLDialect;
end;

function TIBDacImport.IBCConnection_DropDatabase(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCConnection(Instence).DropDatabase;
end;

function TIBDacImport.IBCConnection_FindDefaultTransaction(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TIBCConnection(Instence).FindDefaultTransaction);
end;

function TIBDacImport.IBCConnection_GetGeneratorNames(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCConnection(Instence).GetGeneratorNames(TStrings(TSuPtr(Params[0])), Params[1]);
end;

function TIBDacImport.IBCConnection_GetHandle(Instance: Pointer): Variant;
begin
  Result := TIBCConnection(Instance).Handle;
end;

function TIBDacImport.IBCConnection_GetLastError(Instance: Pointer): Variant;
begin
  Result := TIBCConnection(Instance).LastError;
end;

function TIBDacImport.IBCConnection_HandleIsShared(Instance: Pointer): Variant;
begin
  Result := TIBCConnection(Instance).HandleIsShared;
end;

function TIBDacImport.IBCConnection_IsReadOnly(Instance: Pointer): Variant;
begin
  Result := TIBCConnection(Instance).IsReadOnly;
end;

function TIBDacImport.IBCConnection_ParamByName(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TIBCConnection(Instence).ParamByName(Params[0]));
end;

function TIBDacImport.IBCConnection_RemoveTransaction(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCConnection(Instence).RemoveTransaction(TIBCTransaction(TSuPtr(Params[0])));
end;

function TIBDacImport.IBCConnection_RollbackRetaining(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCConnection(Instence).RollbackRetaining;
end;

procedure TIBDacImport.IBCConnection_SetHandle(Instance: Pointer;
  AValue: Variant);
begin
  TIBCConnection(Instance).Handle := Pointer(TSuPtr(AValue));
end;

procedure TIBDacImport.IBCConnection_SetLastError(Instance: Pointer;
  AValue: Variant);
begin
  TIBCConnection(Instance).LastError := AValue;
end;

function TIBDacImport.IBCConnection_SQL(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBCConnection(Instance).SQL);
end;

function TIBDacImport.IBCConnection_TransactionCount(Instance: Pointer
  ): Variant;
begin
  Result := TIBCConnection(Instance).TransactionCount;
end;

function TIBDacImport.IBCConnection_TransactionsGet(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TIBCConnection(Instence).Transactions[Params[0]]);
end;

function TIBDacImport.IBCParams_FindParam(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TIBCParams(Instence).FindParam(Params[0]));
end;

function TIBDacImport.IBCParams_ItemsGet(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TIBCParams(Instence).Items[Params[0]]);
end;

function TIBDacImport.IBCParams_ItemsSet(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TIBCParams(Instence).Items[Params[0]] := TIBCParam(TSuPtr(Params[1]));
end;

function TIBDacImport.IBCParams_ParamByName(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TIBCParams(Instence).ParamByName(Params[0]));
end;

function TIBDacImport.IBCParam_AsArrayGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBCParam(Instance).AsArray);
end;

procedure TIBDacImport.IBCParam_AsArraySet(Instance: Pointer; AValue: Variant);
begin
  TIBCParam(Instance).AsArray := TIBCArray(TSuPtr(AValue));
end;

function TIBDacImport.IBCParam_AsIbBlobGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBCParam(Instance).AsIbBlob);
end;

procedure TIBDacImport.IBCParam_AsIbBlobSet(Instance: Pointer; AValue: Variant);
begin
  TIBCParam(Instance).AsIbBlob := TIBCBlob(TSuPtr(AValue));
end;

function TIBDacImport.IBCParam_NumericScaleGet(Instance: Pointer): Variant;
begin
  Result := TIBCParam(Instance).NumericScale;
end;

procedure TIBDacImport.IBCParam_NumericScaleSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBCParam(Instance).NumericScale := AValue;
end;

function TIBDacImport.IBCParam_PrecisionGet(Instance: Pointer): Variant;
begin
  Result := TIBCParam(Instance).Precision;
end;

procedure TIBDacImport.IBCParam_PrecisionSet(Instance: Pointer; AValue: Variant
  );
begin
  TIBCParam(Instance).Precision:= AValue;
end;

function TIBDacImport.IBCScript_ExecuteScript(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCScript(Instence).ExecuteScript;
end;

function TIBDacImport.IBCScript_Params(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBCScript(Instance).Params);
end;

function TIBDacImport.IBCSQL_BreakExec(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TIBCSQL(Instence).BreakExec;
end;

function TIBDacImport.IBCSQL_CreateProcCall(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCSQL(Instence).CreateProcCall(Params[0]);
end;

function TIBDacImport.IBCSQL_ExecQuery(Instence: TObject; var Params: Variant
  ): Variant;
begin
  TIBCSQL(Instence).ExecQuery;
end;

function TIBDacImport.IBCSQL_ExecuteNext(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIBCSQL(Instence).ExecuteNext;
end;

function TIBDacImport.IBCSQL_FindParam(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TIBCSQL(Instence).FindParam(Params[0]));
end;

function TIBDacImport.IBCSQL_GetHandle(Instance: Pointer): Variant;
begin
  Result := TIBCSQL(Instance).Handle;
end;

function TIBDacImport.IBCSQL_GetPlan(Instance: Pointer): Variant;
begin
  Result := TIBCSQL(Instance).Plan;
end;

function TIBDacImport.IBCSQL_GetSQLType(Instance: Pointer): Variant;
begin
   Result := TIBCSQL(Instance).SQLType;
end;

function TIBDacImport.IBCSQL_GetSQLTypeEx(Instance: Pointer): Variant;
begin
  Result := TIBCSQL(Instance).SQLTypeEx;
end;

function TIBDacImport.IBCSQL_GetText(Instance: Pointer): Variant;
begin
  Result := TIBCSQL(Instance).Text;
end;

function TIBDacImport.IBCSQL_ParamByName(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TIBCSQL(Instence).ParamByName(Params[0]));
end;

procedure TIBDacImport.IBCSQL_SetText(Instance: Pointer; AValue: Variant);
begin
  TIBCSQL(Instance).Text := AValue;
end;

function TIBDacImport.IBCSStoredProc_ExecProc(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCStoredProc(Instence).ExecProc;
end;

function TIBDacImport.IBCSStoredProc_PrepareSQL(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCStoredProc(Instence).PrepareSQL(Params[0]);
end;

function TIBDacImport.IBCTransaction_AddConnection(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBCTransaction(Instence).AddConnection(TIBCConnection(TSuPtr(Params[0])));
end;

function TIBDacImport.IBCTransaction_CommitRetaining(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCTransaction(Instence).CommitRetaining;
end;

function TIBDacImport.IBCTransaction_ConnectionsCount(Instance: Pointer
  ): Variant;
begin
  Result := TIBCTransaction(Instance).ConnectionsCount;
end;

function TIBDacImport.IBCTransaction_FindDefaultConnection(Instence: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TIBCTransaction(Instence).FindDefaultConnection);
end;

function TIBDacImport.IBCTransaction_GetHandle(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBCTransaction(Instance).Handle);
end;

function TIBDacImport.IBCTransaction_HandleIsShared(Instance: Pointer): Variant;
begin
  Result := TIBCTransaction(Instance).HandleIsShared;
end;

function TIBDacImport.IBCTransaction_ReleaseSavepoint(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCTransaction(Instence).ReleaseSavepoint(Params[0]);
end;

function TIBDacImport.IBCTransaction_RemoveConnection(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCTransaction(Instence).RemoveConnection(TIBCConnection(TSuPtr(Params[0])));
end;

function TIBDacImport.IBCTransaction_RollbackRetaining(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCTransaction(Instence).RollbackRetaining;
end;

function TIBDacImport.IBCTransaction_RollbackSavepoint(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCTransaction(Instence).RollbackSavepoint(Params[0]);
end;

procedure TIBDacImport.IBCTransaction_SetHandle(Instance: Pointer;
  AValue: Variant);
begin
  TIBCTransaction(Instance).Handle := Pointer(TSuPtr(AValue));
end;

function TIBDacImport.IBCTransaction_StartSavepoint(Instence: TObject;
  var Params: Variant): Variant;
begin
  TIBCTransaction(Instence).StartSavepoint(Params[0]);
end;

procedure TIBDacImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TIBCProtocol));
  AddType(TypeInfo(IBC.TLockMode));
  AddType(TypeInfo(TGeneratorMode));
  AddType(TypeInfo(TIBCInsertMode));
  {From IBCAdmin}
  AddType(TypeInfo(TIntegerDynArray));
  AddType(TypeInfo(TStringDynArray));
  AddType(TypeInfo(TIBCPropertyOption));
  AddType(TypeInfo(TIBCPropertyOptions));
  AddType(TypeInfo(TIBCShutdownMode));
  AddType(TypeInfo(TIBCShutdownOptions));
  AddType(TypeInfo(TIBCLicensingAction));
  AddType(TypeInfo(TIBCStatOption));
  AddType(TypeInfo(TIBCStatOptions));
  AddType(TypeInfo(TIBCNBackupOption));
  AddType(TypeInfo(TIBCNBackupOptions));
  AddType(TypeInfo(TIBCBackupOption));
  AddType(TypeInfo(TIBCBackupOptions));
  AddType(TypeInfo(TIBCRestoreOption));
  AddType(TypeInfo(TIBCRestoreOptions));
  AddType(TypeInfo(TIBCValidateOption));
  AddType(TypeInfo(TIBCValidateOptions));
  AddType(TypeInfo(TIBCTransactionGlobalAction));
  AddType(TypeInfo(TIBCTransactionState));
  AddType(TypeInfo(TIBCTransactionAdvise));
  AddType(TypeInfo(TIBCUserModifiedParam));
  AddType(TypeInfo(TIBCUserModifiedParams));
  AddType(TypeInfo(TIBCSecurityAction));
end;

procedure TIBDacImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TIBCSQL).ClassImporter := Self;
  AddClass(TIBCUpdateSQL);
  AddClass(TIBCConnection).ClassImporter := Self;
  AddClass(TIBCTransaction).ClassImporter := Self;
  AddClass(TIBCParam).ClassImporter := Self;
  AddClass(TIBCBlob).ClassImporter := Self;
  AddClass(TCustomIBCArray).ClassImporter := Self;
  AddClass(TIBCArray).ClassImporter := Self;
  AddClass(TIBCEncryptor);
  AddClass(TIBCEncryption);
  AddClass(TIBCConnectStringBuilder);
  AddClass(TIBCConnectionOptions);
  AddClass(TConnectionList).ClassImporter := Self;
  AddClass(TIBCParams).ClassImporter := Self;
  AddClass(TIBCDbKeyField);
  AddClass(TIBCArrayField).ClassImporter := Self;
  AddClass(TIBCDataSetOptions);
  AddClass(TIBCSQLGenerator);
  AddClass(TIBCDataSetUpdater);
  AddClass(TIBCDataSetService);
  AddClass(TCustomIBCDataSet).ClassImporter := Self;
  AddClass(TIBCQuery);
  AddClass(TIBCStoredProc).ClassImporter := Self;

  AddClass(TCustomIBCTable).ClassImporter := Self;
  AddClass(TIBCTable);
  AddClass(TIBCUpdateSQL);
  AddClass(TIBCMetaData);
  AddClass(TIBCFieldTypeMap).ClassImporter := Self;
  AddClass(TIBCArray).ClassImporter := Self;
  AddClass(TIBCUtils);
  AddClass(TIBCScript).ClassImporter := Self;
  AddClass(TIBCAlerter).ClassImporter := Self;
  AddClass(TIBCLoader);
  AddClass(TIBCSQLMonitor).ClassImporter := Self;
  AddClass(TIBCConnectDialog);
  {fromIBCAdmin}
  AddClass(TCustomIBCService).ClassImporter := Self;
  AddClass(TIBCDatabaseInfo).ClassImporter := Self;
  AddClass(TIBCLicenseInfo).ClassImporter := Self;
  AddClass(TIBCLicenseMaskInfo).ClassImporter := Self;
  AddClass(TIBCConfigParams).ClassImporter := Self;
  AddClass(TIBCVersionInfo).ClassImporter := Self;
  AddClass(TIBCAliasInfo).ClassImporter := Self;
  AddClass(TIBCServerProperties).ClassImporter := Self;
  AddClass(TIBCJournalInformation).ClassImporter := Self;
  AddClass(TIBCConfigService).ClassImporter := Self;
  AddClass(TIBCLicensingService).ClassImporter := Self;
  AddClass(TIBCControlAndQueryService).ClassImporter := Self;
  AddClass(TIBCLogService);
  AddClass(TIBCStatisticalService).ClassImporter := Self;
  AddClass(TIBCBackupRestoreService).ClassImporter := Self;
  AddClass(TIBCBackupService);
  AddClass(TIBCRestoreService);
  AddClass(TIBCLimboTransactionInfo).ClassImporter := Self;
  AddClass(TIBCValidationService).ClassImporter := Self;
  AddClass(TIBCUserInfo);
  AddClass(TIBCSecurityService).ClassImporter := Self;
  AddClass(TIBCTraceService).ClassImporter := Self;
end;

procedure TIBDacImport.AddConsts(AddConst: TAddConstProc);
begin
  AddConst('ftObject', 'Integer', ftObject);
  AddConst('ftXML', 'Integer', ftXML);
  AddConst('ftIBCArray', 'Integer', ftIBCArray);
  AddConst('ftIBCDbKey', 'Integer', ftIBCDbKey);
  AddConst('DefValProtocol', 'Integer', DefValProtocol);
end;

procedure TIBDacImport.RegisterPublic(AType: TDpType);
begin

  if AType.ValueClassType = TCustomIBCDataSet then
  begin
    AType.AddMethod('function QueryKeyFields(TableName: string; List: TStrings): string', @CustomIBCDataSet_QueryKeyFields);
    AType.AddMethod('procedure CreateProcCall(const Name: string)', @CustomIBCDataSet_CreateProcCall);
    AType.AddMethod('function FindParam(const Value: string): TIBCParam', @CustomIBCDataSet_FindParam);
    AType.AddMethod('function ParamByName(const Value: string): TIBCParam', @CustomIBCDataSet_ParamByName);
    AType.AddMethod('function PN(const Value: string): TIBCParam', @CustomIBCDataSet_ParamByName);
    AType.AddMethod('function CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream', @CustomIBCDataSet_CreateBlobStream);
    AType.AddProp('RowsFetched', 'integer', @CustomIBCDataSet_GetRowsFetched);
    AType.AddProp('RowsInserted', 'integer', @CustomIBCDataSet_GetRowsInserted);
    AType.AddProp('RowsUpdated', 'integer', @CustomIBCDataSet_GetRowsUpdated);
    AType.AddProp('RowsDeleted', 'integer', @CustomIBCDataSet_GetRowsDeleted);
    AType.AddProp('IsQuery', 'Boolean', @CustomIBCDataSet_GetIsQuery);
    AType.AddProp('SQLType', 'Integer', @CustomIBCDataSet_GetSQLType);
    AType.AddProp('SQLTypeEx', 'Integer', @CustomIBCDataSet_GetSQLTypeEx);
    AType.AddProp('Cursor', 'string', @CustomIBCDataSet_GetCursor);
    AType.AddProp('Plan', 'string', @CustomIBCDataSet_GetPlan);
  end
  else
  if AType.ValueClassType = TIBCStoredProc then
  begin
    AType.AddMethod('procedure PrepareSQL(IsQuery: boolean = False)', @IBCSStoredProc_PrepareSQL);
    AType.AddMethod('procedure ExecProc', @IBCSStoredProc_ExecProc);
  end
  else
  if AType.ValueClassType = TIBCSQL then
  begin
    AType.AddMethod('function ExecuteNext: boolean', @IBCSQL_ExecuteNext);
    AType.AddMethod('procedure BreakExec', @IBCSQL_BreakExec);
    AType.AddMethod('function FindParam(const Value: string): TIBCParam', @IBCSQL_FindParam);
    AType.AddMethod('function ParamByName(const Value: string): TIBCParam', @IBCSQL_ParamByName);
    AType.AddMethod('function PN(const Value: string): TIBCParam', @IBCSQL_ParamByName);
    AType.AddMethod('procedure CreateProcCall(const Name: string)', @IBCSQL_CreateProcCall);
    AType.AddMethod('procedure ExecQuery', @IBCSQL_ExecQuery);

    AType.AddProp('SQLType', 'Integer', @IBCSQL_GetSQLType);
    AType.AddProp('SQLTypeEx', 'integer', @IBCSQL_GetSQLTypeEx);
    AType.AddProp('Text', 'string', @IBCSQL_GetText, @IBCSQL_SetText);
    AType.AddProp('Handle', 'Pointer', @IBCSQL_GetHandle);
    AType.AddProp('Plan', 'string', @IBCSQL_GetPlan);
  end
  else
  if AType.ValueClassType = TIBCConnection then
  begin
    AType.AddMethod('function ParamByName(const Name: string): TIBCParam', @IBCConnection_ParamByName);
    AType.AddMethod('function PN(const Name: string): TIBCParam', @IBCConnection_ParamByName);
    AType.AddMethod('procedure GetGeneratorNames(List: TStrings; AllGenerators: boolean = False)', @IBCConnection_GetGeneratorNames);
    AType.AddMethod('procedure AssignConnect(Source: TIBCConnection)', @IBCConnection_AssignConnect);
    AType.AddMethod('procedure CommitRetaining', @IBCConnection_CommitRetaining);
    AType.AddMethod('procedure RollbackRetaining', @IBCConnection_RollbackRetaining);
    AType.AddMethod('procedure CreateDatabase', @IBCConnection_CreateDatabase);
    AType.AddMethod('procedure DropDatabase', @IBCConnection_DropDatabase);
    AType.AddMethod('function AddTransaction(TR: TIBCTransaction): Integer', @IBCConnection_AddTransaction);
    AType.AddMethod('function FindDefaultTransaction: TIBCTransaction', @IBCConnection_FindDefaultTransaction);
    AType.AddMethod('procedure RemoveTransaction(TR: TIBCTransaction)', @IBCConnection_RemoveTransaction);

    AType.AddProp('Handle', 'Pointer', @IBCConnection_GetHandle, @IBCConnection_SetHandle);
    AType.AddProp('HandleIsShared', 'boolean', @IBCConnection_HandleIsShared);
    AType.AddProp('IsReadOnly', 'boolean', @IBCConnection_IsReadOnly);
    AType.AddProp('SQL', 'TIBCSQL', @IBCConnection_SQL);
    AType.AddProp('DBSQLDialect', 'Integer', @IBCConnection_DBSQLDialect);
    AType.AddProp('TransactionCount', 'Integer', @IBCConnection_TransactionCount);
    AType.AddIndexedProp('Transactions', 'TIBCTransaction', 'Integer', @IBCConnection_TransactionsGet);
    AType.AddProp('LastError', 'Integer', @IBCConnection_GetLastError, @IBCConnection_SetLastError);
  end
  else
  if AType.ValueClassType = TIBCTransaction then
  begin
    AType.AddMethod('function AddConnection(Connection: TIBCConnection): integer', @IBCTransaction_AddConnection);
    AType.AddMethod('function FindDefaultConnection: TIBCConnection', @IBCTransaction_FindDefaultConnection);
    AType.AddMethod('procedure RemoveConnection(Connection: TIBCConnection)', @IBCTransaction_RemoveConnection);
    AType.AddMethod('procedure CommitRetaining', @IBCTransaction_CommitRetaining);
    AType.AddMethod('procedure RollbackRetaining', @IBCTransaction_RollbackRetaining);
    AType.AddMethod('procedure ReleaseSavepoint(const Name: string)', @IBCTransaction_ReleaseSavepoint);
    AType.AddMethod('procedure RollbackSavepoint(const Name: string)', @IBCTransaction_RollbackSavepoint);
    AType.AddMethod('procedure StartSavepoint(const Name: string)', @IBCTransaction_StartSavepoint);

    AType.AddProp('Handle', 'Pointer', @IBCTransaction_GetHandle, @IBCTransaction_SetHandle);
    AType.AddProp('HandleIsShared', 'Boolean', @IBCTransaction_HandleIsShared);
    AType.AddProp('ConnectionsCount', 'Integer', @IBCTransaction_ConnectionsCount);
  end
  else
  if AType.ValueClassType = TIBCParam then
  begin
    AType.AddProp('Precision', 'Integer', @IBCParam_PrecisionGet, @IBCParam_PrecisionSet);
    AType.AddProp('NumericScale', 'Integer', @IBCParam_NumericScaleGet, @IBCParam_NumericScaleSet);
    AType.AddProp('AsIbBlob', 'TIBCBlob', @IBCParam_AsIbBlobGet, @IBCParam_AsIbBlobSet);
    AType.AddProp('AsArray', 'TIBCArray', @IBCParam_AsArrayGet, @IBCParam_AsArraySet);
  end
  else
  if AType.ValueClassType = TIBCBlob then
  begin
    AType.AddMethod('procedure CloseBlob', @IBCBlob_CloseBlob);
    AType.AddMethod('function LengthBlob: longint', @IBCBlob_LengthBlob);
  end
  else
  if AType.ValueClassType = TCustomIBCArray then
  begin
    {AType.AddMethod('procedure ClearArray', @CustomIBCArray_ClearArray);
    AType.AddMethod('function GetItemValue(Indices: array of integer): variant', @CustomIBCArray_GetItemValue);
    AType.AddMethod('procedure SetItemValue(Indices: array of integer; Value: variant)', @CustomIBCArray_SetItemValue);
    AType.AddProp('Modified', 'Boolean', @CustomIBCArray_Modified);
    AType.AddProp('TableName', 'string', @CustomIBCArray_TableNameGet, @CustomIBCArray_TableNameSet);
    AType.AddProp('ColumnName', 'string', @CustomIBCArray_ColumnNameGet, @CustomIBCArray_ColumnNameSet);
    AType.AddProp('ArrayDimensions', 'Integer', @CustomIBCArray_ArrayDimensionsGet, @CustomIBCArray_ArrayDimensionsSet);
    AType.AddProp('ArraySize', 'Integer', @CustomIBCArray_ArraySizeGet);
    AType.AddProp('Cached', 'Boolean', @CustomIBCArray_CachedGet, @CustomIBCArray_CachedSet);
    AType.AddProp('IsNull', 'Boolen', @CustomIBCArray_IsNullGet, @CustomIBCArray_IsNullSet);
    AType.AddProp('CachedDimensions', 'integer', @CustomIBCArray_CachedDimensionsGet);
    AType.AddProp('CachedSize', 'integer', @CustomIBCArray_CachedSizeGet, @CustomIBCArray_CachedSizeSet);
    AType.AddProp('ItemSize', 'integer', @CustomIBCArray_ItemSizeGet, @CustomIBCArray_ItemSizeSet);
    AType.AddProp('ItemScale', 'integer', @CustomIBCArray_ItemScaleGet, @CustomIBCArray_ItemScaleSet);
    AType.AddProp('Items', 'variant', @CustomIBCArray_ItemsGet, @CustomIBCArray_ItemsSet);}
  end
  else
  if AType.ValueClassType = TIBCArray then
  begin
    AType.AddProp('ItemType', 'TFieldType', @IBCArray_GetItemType, @IBCArray_SetItemType);
  end
  else
  if AType.ValueClassType = TConnectionList then
  begin
    AType.AddProp('Count', 'Integer', @ConnectionList_GetCount);
    AType.AddIndexedProp('Items', 'TIBCConnection', 'Integer', @ConnectionList_ItemsGet);
  end
  else
  if AType.ValueClassType = TIBCParams then
  begin
    AType.AddMethod('function ParamByName(const Value: string): TIBCParam', @IBCParams_ParamByName);
    AType.AddMethod('function PN(const Value: string): TIBCParam', @IBCParams_ParamByName);
    AType.AddMethod('function FindParam(const Value: string): TIBCParam', @IBCParams_FindParam);
    AType.AddIndexedProp('Items', 'TIBCParam', 'Integer', @IBCParams_ItemsGet, @IBCParams_ItemsSet);
  end
  else
  if AType.ValueClassType = TIBCArrayField then
  begin
    AType.AddProp('AsArray', 'TIBCArray', @IBCArrayField_AsArrayGet);
  end
  else
  if AType.ValueClassType = TIBCScript then
  begin
    AType.AddMethod('procedure ExecuteScript', @IBCScript_ExecuteScript);
    AType.AddProp('Params', 'TIBCParams', @IBCScript_Params);
  end
  else
  if AType.ValueClassType = TIBCAlerter then
  begin
    AType.AddMethod('procedure SendEvent(const Name: string)', @IBCAlerter_SendEvent);
  end;
end;

procedure TIBDacImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TIBCAlertEvent), TIBCAlertEventHandler);
end;


end.
