{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit RegCompEditors;

{$mode objfpc}{$H+}

interface

{$I SetComponent.inc}

uses
  Classes, SysUtils, ActionsEditor, ActnList, ComponentEditors,
  MenuEditor, ImageListEditor, Menus, Controls, PropEdits,
  typinfo, GraphPropEdits, ImgList
  {$ifdef IBDAC},
  IBC, IBCDesign, IBCConnectionEditor, CRDesign,
  IBCDesignUtils, IBCLoader, IBCAdmin, CRTypes, DADesign, DBAccess, DALoader,
  DAAlerter, IBCTransactionEditor, IBCTableEditor, IBCStoredProcEditor,
  IBCAlerterEditor, IBCScript, DAScriptEditor, IBCAlerter, IBCSQLEditor,
  IBCQueryEditor, IBCUpdateSQLEditor, IBCSQLEdits
  {$endif}
  {$IFDEF ZEOS}
  ,ZConnection, ZDataset, ZSqlUpdate, ZConnectionGroup, ZGroupedConnection,
  ZStoredProcedure, ZSqlMetadata, ZSequence,
  ZPropertyEditor, ZUpdateSqlEditor, ZSQLPropEdit
  {$ENDIF}
  {$IFDEF IBX}
   ,IBQuery, IBCustomDataSet, IBDatabase, IBSQL, IBStoredProc,
    IBUpdateSQL, IBEvents, IBSQLMonitor, IBTable,
    IBExtract, IBServices, IBDBReg, IBXSQLEdits
  {$ENDIF}
  {$IfDef FASTREPORT} ,frxClass, frxLazarusComponentEditors{$EndIf}
  {$IFDEF LAZREPORT} ,LR_Register, LR_Class {$ENDIF}
  {$IfDef CHART} , TASeriesEditor, TASeriesPropEditors, TADataPointsEditor
  //Uncoment in Lazarus 2.2, 3
  //,TASourcePropEditors
  {$EndIf}
  ;

procedure RegisterComponentsEditors;
procedure RegisterPropEditors;

implementation

uses xGridPropsEdit, xdbf_reg, xdbf, dbf_idxfile, dbf_fields, xDBControls,
  regvtcomponents, xColumnImageEdotors, XDBGrids, ComCtrls;

procedure RegisterComponentsEditors;
begin
  //RegisterComponentEditor(TActionList, TActionListComponentEditor);
  RegisterComponentEditor(TMainMenu, TMainMenuComponentEditor);
  RegisterComponentEditor(TImageList, TImageListComponentEditor);
  {$ifdef IBDAC}
    DARegisterComponentEditor(TIBCConnection, TIBCConnectionEditor, TIBCConnectionEditorForm, TIBCDesignUtils);
    DARegisterComponentEditor(TIBCTransaction, TIBCTransactionEditor, TIBCTransactionEditorForm, TIBCDesignUtils);
    DARegisterComponentEditor(TIBCSQL, TIBCSQLEditor, TIBCSQLEditorForm, TIBCDesignUtils);
    DARegisterComponentEditor(TIBCQuery, TIBCQueryEditor, TIBCQueryEditorForm, TIBCDesignUtils);
    DARegisterComponentEditor(TIBCTable, TIBCTableEditor, TIBCTableEditorForm, TIBCDesignUtils);
    DARegisterComponentEditor(TIBCStoredProc, TIBCStoredProcEditor, TIBCStoredProcEditorForm, TIBCDesignUtils);
    DARegisterComponentEditor(TIBCUpdateSQL, TIBCUpdateSQLEditor, TIBCUpdateSQLEditorForm, TIBCDesignUtils);
    DARegisterComponentEditor(TIBCScript, TIBCScriptEditor, TDAScriptEditorForm, TIBCDesignUtils);
    // DAComponentEditor is needed to display session select dialog with Delphi 5
    DARegisterComponentEditor(TIBCMetaData, TDAComponentEditor, nil, TIBCDesignUtils);
    {$IFDEF MSWINDOWS}
      DARegisterComponentEditor(TIBCAlerter, TIBCAlerterEditor, TIBCAlerterEditorForm, TIBCDesignUtils);
    {$ENDIF}
    DARegisterComponentEditor(TIBCLoader, TDALoaderEditor, nil, TIBCDesignUtils);
    DARegisterComponentEditor(TCustomIBCService, TIBCServiceEditor, TIBCConnectionEditorForm, TIBCDesignUtils);
  {$endif}

  {$IFDEF ZEOS}
  RegisterComponentEditor(TZUpdateSQL, TZUpdateSQLEditor);
  {$ENDIF}

  {$IFDEF IBX}
  RegisterComponentEditor(TIBDatabase, TIBDatabaseEditor);
  RegisterComponentEditor(TIBTransaction, TIBTransactionEditor);
  RegisterComponentEditor(TIBUpdateSQL, TIBUpdateSQLEditor);
  RegisterComponentEditor(TIBDataSet, TIBDataSetEditor);
  RegisterComponentEditor(TIBQuery, TIBQueryEditor);
  RegisterComponentEditor(TIBStoredProc, TIBStoredProcEditor);
  RegisterComponentEditor(TIBSQL, TIBSQLEditor);
  RegisterComponentEditor(TIBCustomService, TIBServiceEditor);
  {$ENDIF}

  {$IFDEF LAZREPORT}
  RegisterComponentEditor(TfrReport, TfrRepEditor);
  {$ENDIF}

  {$IFDEF FASTREPORT}
   frxLazarusComponentEditors.Register;
  {$EndIf}

  {$IfDef CHART}
  TASeriesEditor.Register;
  TASeriesPropEditors.Register;

  //Uncoment in Lazarus 2.2, 3
  {TASeriesEditor.Register;
  TASeriesPropEditors.Register;
  TASourcePropEditors.Register;}

  //Comment in Lazarus 2.2
  TADataPointsEditor.Register;
  {$EndIf}
end;

procedure RegisterPropEditors;
begin
  {$ifdef IBDAC}
  RegisterPropertyEditor(TypeInfo(String), TIBCConnectionOptions, 'Charset', TIBCConnectionOptionsCharsetProperty);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCConnection, 'Params', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(String), TIBCConnection, 'Database', TIBFileNameProperty);

  RegisterPropertyEditor(TypeInfo(String), TIBCConnection, 'ClientLibrary', TIBCClientLibraryProperty);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCTransaction, 'Params', TDAPropertyEditor);


  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQL', TIBCSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLDelete', TIBCSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLInsert', TIBCSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLLock', TIBCSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLRecCount', TIBCSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLRefresh', TIBCSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLUpdate', TIBCSQLPropertyEditor);

  {RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQL', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLDelete', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLInsert', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLLock', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLRecCount', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLRefresh', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCQuery, 'SQLUpdate', TDAPropertyEditor);}

  RegisterPropertyEditor(TypeInfo(TStrings), TIBCSQL, 'SQL', TDAPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TStrings), TIBCScript, 'SQL', TDAPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TStrings), TIBCStoredProc, 'SQLDelete', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCStoredProc, 'SQLInsert', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCStoredProc, 'SQLLock', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCStoredProc, 'SQLRecCount', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCStoredProc, 'SQLRefresh', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCStoredProc, 'SQLUpdate', TDAPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TStrings), TIBCUpdateSQL, 'InsertSQL', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCUpdateSQL, 'ModifySQL', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCUpdateSQL, 'DeleteSQL', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCUpdateSQL, 'RefreshSQL', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBCUpdateSQL, 'LockSQL', TDAPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TIBCTransaction), TIBCQuery, 'Transaction', TIBCTransactionProperty);
  RegisterPropertyEditor(TypeInfo(TIBCTransaction), TIBCSQL, 'Transaction', TIBCTransactionProperty);
  RegisterPropertyEditor(TypeInfo(TIBCTransaction), TIBCTable, 'Transaction', TIBCTransactionProperty);
  RegisterPropertyEditor(TypeInfo(TIBCTransaction), TIBCStoredProc, 'Transaction', TIBCTransactionProperty);
  RegisterPropertyEditor(TypeInfo(TIBCTransaction), TIBCScript, 'Transaction', TIBCTransactionProperty);
  RegisterPropertyEditor(TypeInfo(TIBCTransaction), TIBCLoader, 'Transaction', TIBCTransactionProperty);
  RegisterPropertyEditor(TypeInfo(TIBCTransaction), TIBCConnection, 'DefaultTransaction', TIBCTransactionProperty);

  RegisterPropertyEditor(TypeInfo(string), TCustomIBCDataSet, 'KeyGenerator', TIBCKeyGeneratorProperty);
  {$IFDEF MSWINDOWS}
    RegisterPropertyEditor(TypeInfo(TStrings), TIBCAlerter, 'Events', TDAPropertyEditor);
    RegisterPropertyEditor(TypeInfo(TIBCTransaction), TIBCAlerter, 'Transaction', TIBCTransactionProperty);
  {$ENDIF}
  RegisterPropertyEditor(TypeInfo(string), TCustomIBCService, 'Password', TDAPasswordProperty);
  RegisterPropertyEditor(TypeInfo(TStrings), TCustomIBCService, 'Params', TDAPropertyEditor);
  RegisterPropertyEditor(TypeInfo(Boolean), TIBCConnection, 'ConnectPrompt', nil);
  {$endif}

  {$IFDEF IBX}
  RegisterPropertyEditor(TypeInfo(TIBFileName), TIBDatabase, 'DatabaseName', TIBFileNameProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(TFileName), TIBDatabase, 'LibraryName', TFileNamePropertyEditor); {do not localize}
  RegisterPropertyEditor(TypeInfo(string), TIBStoredProc, 'StoredProcName', TIBStoredProcNameProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBStoredProc, 'SQL', TIBXProcSQLPropertyEditor); {do not localize}
  RegisterPropertyEditor(TypeInfo(string), TIBTable, 'TableName', TIBTableNameProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(string), TIBTable, 'IndexName', TIBIndexNameProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(string), TIBTable, 'IndexFieldNames', TIBIndexFieldNamesProperty); {do not localize}
//  RegisterPropertyEditor(TypeInfo(string), TIBTable, 'MasterFields', TIBTableFieldLinkProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBQuery, 'SQL', TIBXSQLPropertyEditor); {do not localize}

  RegisterPropertyEditor(TypeInfo(TStrings), TIBDataSet, 'SelectSQL', TIBXSQLPropertyEditor); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBDataSet, 'ModifySQL', TIBXSQLPropertyEditor); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBDataSet, 'InsertSQL', TIBXSQLPropertyEditor); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBDataSet, 'RefreshSQL', TIBXSQLPropertyEditor); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBDataSet, 'DeleteSQL', TIBXSQLPropertyEditor); {do not localize}

  RegisterPropertyEditor(TypeInfo(TStrings), TIBSQL, 'SQL', TIBSQLSQLPropertyEditor); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBUpdateSQL, 'RefreshSQL', TIBUpdateSQLRefreshSQLProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBUpdateSQL, 'ModifySQL', TIBUpdateSQLUpdateProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBUpdateSQL, 'InsertSQL', TIBUpdateSQLInsertSQLProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBUpdateSQL, 'DeleteSQL', TIBUpdateSQLDeleteProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStrings), TIBEvents, 'Events', TIBEventListProperty); {do not localize}
  RegisterPropertyEditor(TypeInfo(TPersistent), TIBDataSet, 'GeneratorField', TIBGeneratorProperty);  {do not localize}
  RegisterPropertyEditor(TypeInfo(TPersistent), TIBQuery, 'GeneratorField', TIBGeneratorProperty);  {do not localize}

  {$ENDIF}

  {$IFDEF ZEOS}
  RegisterPropertyEditor(TypeInfo(string), TZConnection, 'ClientCodepage',
    TZClientCodePagePropertyEditor); {EgonHugeist}
  RegisterPropertyEditor(TypeInfo(string), TZConnection, 'Protocol',
    TZProtocolPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZConnection, 'Database',
    TZDatabasePropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZConnection, 'Catalog',
    TZCatalogPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZConnection, 'LibraryLocation',
    TZLibLocationPropertyEditor);

  RegisterPropertyEditor(TypeInfo(string), TZConnectionGroup, 'Protocol',
    TZProtocolPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZConnectionGroup, 'Database',
    TZConnectionGroupPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZConnectionGroup, 'LibraryLocation',
    TZLibLocationPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZGroupedConnection, 'Catalog',
      TZGroupedConnectionCatalogPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TStrings), TZReadOnlyQuery, 'SQL',
    TZSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TZQuery, 'SQL',
    TZSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TZUpdateSQL, 'DeleteSQL',
    TZSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TZUpdateSQL, 'InsertSQL',
    TZSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TZUpdateSQL, 'ModifySQL',
    TZSQLPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TZUpdateSQL, 'RefreshSQL',
    TZSQLPropertyEditor);

  RegisterPropertyEditor(TypeInfo(string), TZQuery, 'LinkedFields',
    TZDataFieldPropertyEditor); {renamed by bangfauzan}
  RegisterPropertyEditor(TypeInfo(string), TZQuery, 'MasterFields',
    TZMasterFieldPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZQuery, 'SortedFields',
    TZDataFieldPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZQuery, 'SequenceField',
    TZDataFieldPropertyEditor);

  RegisterPropertyEditor(TypeInfo(string), TZReadOnlyQuery, 'LinkedFields',
    TZDataFieldPropertyEditor); {renamed by bangfauzan}
  RegisterPropertyEditor(TypeInfo(string), TZReadOnlyQuery, 'MasterFields',
    TZMasterFieldPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZReadOnlyQuery, 'SortedFields',
    TZDataFieldPropertyEditor);

  RegisterPropertyEditor(TypeInfo(string), TZTable, 'TableName',
    TZTableNamePropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZTable, 'LinkedFields',
    TZDataFieldPropertyEditor); {renamed by bangfauzan}
  RegisterPropertyEditor(TypeInfo(string), TZTable, 'MasterFields',
    TZMasterFieldPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZTable, 'SortedFields',
    TZDataFieldPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZTable, 'SequenceField',
    TZDataFieldPropertyEditor);

  RegisterPropertyEditor(TypeInfo(string), TZStoredProc, 'StoredProcName',
    TZProcedureNamePropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZStoredProc, 'SortedFields',
    TZDataFieldPropertyEditor);

  RegisterPropertyEditor(TypeInfo(string), TZSequence, 'SequenceName',
    TZSequenceNamePropertyEditor);

  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'Catalog',
    TZCatalogProperty);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'ColumnName',
    TZColumnNamePropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'ForeignCatalog',
    TZCatalogProperty);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'ForeignSchema',
    TZSchemaPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'ForeignTableName',
    TZTableNamePropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'LinkedFields',
    TZDataFieldPropertyEditor); {renamed by bangfauzan}
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'MasterFields',
    TZMasterFieldPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'ProcedureName',
    TZProcedureNamePropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'Schema',
    TZSchemaPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'SequenceName',
    TZSequenceNamePropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'SortedFields',
    TZDataFieldPropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'TableName',
    TZTableNamePropertyEditor);
  RegisterPropertyEditor(TypeInfo(string), TZSQLMetadata, 'TypeName',
    TZTypeNamePropertyEditor);
  {$ENDIF}

  RegisterPropertyEditor(TypeInfo(string), TxDbf, 'TableName', xdbf_reg.TTableNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TxDbf, 'Version', xdbf_reg.TVersionProperty);
  RegisterPropertyEditor(TypeInfo(string), TxDbf, 'IndexName', xdbf_reg.TIndexNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TDbfIndexDef, 'IndexFile', xdbf_reg.TIndexFileNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TDbfIndexDef, 'SortField', xdbf_reg.TSortFieldProperty);
  RegisterPropertyEditor(TypeInfo(char), TDbfFieldDef, 'NativeFieldType', xdbf_reg.TNativeFieldTypeProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TxEditButton, 'ImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TxEditButton, 'DownImageIndex', TxImageIndexPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TDBEditButton, 'ImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TDBEditButton, 'DownImageIndex', TxImageIndexPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TxSpeedBtn, 'ImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TxSpeedBtn, 'DownImageIndex', TxImageIndexPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TAction, 'ImageIndex', TxImageIndexPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TxBitBtn, 'ImageIndex', TxImageIndexPropertyEditor);

  RegisterPropertyEditor(TypeInfo(TImagesIndexes), TxColumn, 'ImagesIndexes', TImagesIndexesProperty);
  RegisterPropertyEditor(TypeInfo(TImagesIndexes), TxColumn, 'xImagesIndexes', TxImagesIndexesProperty);
end;


end.

